// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax/build/src/protobuf").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_cloud_ces_protos || ($protobuf.roots._google_cloud_ces_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.cloud = (function() {
    
            /**
             * Namespace cloud.
             * @memberof google
             * @namespace
             */
            var cloud = {};
    
            cloud.ces = (function() {
    
                /**
                 * Namespace ces.
                 * @memberof google.cloud
                 * @namespace
                 */
                var ces = {};
    
                ces.v1 = (function() {
    
                    /**
                     * Namespace v1.
                     * @memberof google.cloud.ces
                     * @namespace
                     */
                    var v1 = {};
    
                    v1.Agent = (function() {
    
                        /**
                         * Properties of an Agent.
                         * @memberof google.cloud.ces.v1
                         * @interface IAgent
                         * @property {google.cloud.ces.v1.Agent.ILlmAgent|null} [llmAgent] Agent llmAgent
                         * @property {google.cloud.ces.v1.Agent.IRemoteDialogflowAgent|null} [remoteDialogflowAgent] Agent remoteDialogflowAgent
                         * @property {string|null} [name] Agent name
                         * @property {string|null} [displayName] Agent displayName
                         * @property {string|null} [description] Agent description
                         * @property {google.cloud.ces.v1.IModelSettings|null} [modelSettings] Agent modelSettings
                         * @property {string|null} [instruction] Agent instruction
                         * @property {Array.<string>|null} [tools] Agent tools
                         * @property {Array.<string>|null} [childAgents] Agent childAgents
                         * @property {Array.<google.cloud.ces.v1.ICallback>|null} [beforeAgentCallbacks] Agent beforeAgentCallbacks
                         * @property {Array.<google.cloud.ces.v1.ICallback>|null} [afterAgentCallbacks] Agent afterAgentCallbacks
                         * @property {Array.<google.cloud.ces.v1.ICallback>|null} [beforeModelCallbacks] Agent beforeModelCallbacks
                         * @property {Array.<google.cloud.ces.v1.ICallback>|null} [afterModelCallbacks] Agent afterModelCallbacks
                         * @property {Array.<google.cloud.ces.v1.ICallback>|null} [beforeToolCallbacks] Agent beforeToolCallbacks
                         * @property {Array.<google.cloud.ces.v1.ICallback>|null} [afterToolCallbacks] Agent afterToolCallbacks
                         * @property {google.protobuf.ITimestamp|null} [createTime] Agent createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] Agent updateTime
                         * @property {Array.<string>|null} [guardrails] Agent guardrails
                         * @property {string|null} [etag] Agent etag
                         * @property {Array.<google.cloud.ces.v1.Agent.IAgentToolset>|null} [toolsets] Agent toolsets
                         * @property {string|null} [generatedSummary] Agent generatedSummary
                         */
    
                        /**
                         * Constructs a new Agent.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an Agent.
                         * @implements IAgent
                         * @constructor
                         * @param {google.cloud.ces.v1.IAgent=} [properties] Properties to set
                         */
                        function Agent(properties) {
                            this.tools = [];
                            this.childAgents = [];
                            this.beforeAgentCallbacks = [];
                            this.afterAgentCallbacks = [];
                            this.beforeModelCallbacks = [];
                            this.afterModelCallbacks = [];
                            this.beforeToolCallbacks = [];
                            this.afterToolCallbacks = [];
                            this.guardrails = [];
                            this.toolsets = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Agent llmAgent.
                         * @member {google.cloud.ces.v1.Agent.ILlmAgent|null|undefined} llmAgent
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.llmAgent = null;
    
                        /**
                         * Agent remoteDialogflowAgent.
                         * @member {google.cloud.ces.v1.Agent.IRemoteDialogflowAgent|null|undefined} remoteDialogflowAgent
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.remoteDialogflowAgent = null;
    
                        /**
                         * Agent name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.name = "";
    
                        /**
                         * Agent displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.displayName = "";
    
                        /**
                         * Agent description.
                         * @member {string} description
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.description = "";
    
                        /**
                         * Agent modelSettings.
                         * @member {google.cloud.ces.v1.IModelSettings|null|undefined} modelSettings
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.modelSettings = null;
    
                        /**
                         * Agent instruction.
                         * @member {string} instruction
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.instruction = "";
    
                        /**
                         * Agent tools.
                         * @member {Array.<string>} tools
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.tools = $util.emptyArray;
    
                        /**
                         * Agent childAgents.
                         * @member {Array.<string>} childAgents
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.childAgents = $util.emptyArray;
    
                        /**
                         * Agent beforeAgentCallbacks.
                         * @member {Array.<google.cloud.ces.v1.ICallback>} beforeAgentCallbacks
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.beforeAgentCallbacks = $util.emptyArray;
    
                        /**
                         * Agent afterAgentCallbacks.
                         * @member {Array.<google.cloud.ces.v1.ICallback>} afterAgentCallbacks
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.afterAgentCallbacks = $util.emptyArray;
    
                        /**
                         * Agent beforeModelCallbacks.
                         * @member {Array.<google.cloud.ces.v1.ICallback>} beforeModelCallbacks
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.beforeModelCallbacks = $util.emptyArray;
    
                        /**
                         * Agent afterModelCallbacks.
                         * @member {Array.<google.cloud.ces.v1.ICallback>} afterModelCallbacks
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.afterModelCallbacks = $util.emptyArray;
    
                        /**
                         * Agent beforeToolCallbacks.
                         * @member {Array.<google.cloud.ces.v1.ICallback>} beforeToolCallbacks
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.beforeToolCallbacks = $util.emptyArray;
    
                        /**
                         * Agent afterToolCallbacks.
                         * @member {Array.<google.cloud.ces.v1.ICallback>} afterToolCallbacks
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.afterToolCallbacks = $util.emptyArray;
    
                        /**
                         * Agent createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.createTime = null;
    
                        /**
                         * Agent updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.updateTime = null;
    
                        /**
                         * Agent guardrails.
                         * @member {Array.<string>} guardrails
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.guardrails = $util.emptyArray;
    
                        /**
                         * Agent etag.
                         * @member {string} etag
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.etag = "";
    
                        /**
                         * Agent toolsets.
                         * @member {Array.<google.cloud.ces.v1.Agent.IAgentToolset>} toolsets
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.toolsets = $util.emptyArray;
    
                        /**
                         * Agent generatedSummary.
                         * @member {string} generatedSummary
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Agent.prototype.generatedSummary = "";
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Agent agentType.
                         * @member {"llmAgent"|"remoteDialogflowAgent"|undefined} agentType
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         */
                        Object.defineProperty(Agent.prototype, "agentType", {
                            get: $util.oneOfGetter($oneOfFields = ["llmAgent", "remoteDialogflowAgent"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Agent instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.Agent
                         * @static
                         * @param {google.cloud.ces.v1.IAgent=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.Agent} Agent instance
                         */
                        Agent.create = function create(properties) {
                            return new Agent(properties);
                        };
    
                        /**
                         * Encodes the specified Agent message. Does not implicitly {@link google.cloud.ces.v1.Agent.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.Agent
                         * @static
                         * @param {google.cloud.ces.v1.IAgent} message Agent message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Agent.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.displayName);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
                            if (message.modelSettings != null && Object.hasOwnProperty.call(message, "modelSettings"))
                                $root.google.cloud.ces.v1.ModelSettings.encode(message.modelSettings, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.instruction != null && Object.hasOwnProperty.call(message, "instruction"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.instruction);
                            if (message.tools != null && message.tools.length)
                                for (var i = 0; i < message.tools.length; ++i)
                                    writer.uint32(/* id 7, wireType 2 =*/58).string(message.tools[i]);
                            if (message.childAgents != null && message.childAgents.length)
                                for (var i = 0; i < message.childAgents.length; ++i)
                                    writer.uint32(/* id 8, wireType 2 =*/66).string(message.childAgents[i]);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 16, wireType 2 =*/130).fork()).ldelim();
                            if (message.guardrails != null && message.guardrails.length)
                                for (var i = 0; i < message.guardrails.length; ++i)
                                    writer.uint32(/* id 17, wireType 2 =*/138).string(message.guardrails[i]);
                            if (message.beforeAgentCallbacks != null && message.beforeAgentCallbacks.length)
                                for (var i = 0; i < message.beforeAgentCallbacks.length; ++i)
                                    $root.google.cloud.ces.v1.Callback.encode(message.beforeAgentCallbacks[i], writer.uint32(/* id 18, wireType 2 =*/146).fork()).ldelim();
                            if (message.afterAgentCallbacks != null && message.afterAgentCallbacks.length)
                                for (var i = 0; i < message.afterAgentCallbacks.length; ++i)
                                    $root.google.cloud.ces.v1.Callback.encode(message.afterAgentCallbacks[i], writer.uint32(/* id 19, wireType 2 =*/154).fork()).ldelim();
                            if (message.beforeModelCallbacks != null && message.beforeModelCallbacks.length)
                                for (var i = 0; i < message.beforeModelCallbacks.length; ++i)
                                    $root.google.cloud.ces.v1.Callback.encode(message.beforeModelCallbacks[i], writer.uint32(/* id 20, wireType 2 =*/162).fork()).ldelim();
                            if (message.afterModelCallbacks != null && message.afterModelCallbacks.length)
                                for (var i = 0; i < message.afterModelCallbacks.length; ++i)
                                    $root.google.cloud.ces.v1.Callback.encode(message.afterModelCallbacks[i], writer.uint32(/* id 21, wireType 2 =*/170).fork()).ldelim();
                            if (message.beforeToolCallbacks != null && message.beforeToolCallbacks.length)
                                for (var i = 0; i < message.beforeToolCallbacks.length; ++i)
                                    $root.google.cloud.ces.v1.Callback.encode(message.beforeToolCallbacks[i], writer.uint32(/* id 22, wireType 2 =*/178).fork()).ldelim();
                            if (message.afterToolCallbacks != null && message.afterToolCallbacks.length)
                                for (var i = 0; i < message.afterToolCallbacks.length; ++i)
                                    $root.google.cloud.ces.v1.Callback.encode(message.afterToolCallbacks[i], writer.uint32(/* id 23, wireType 2 =*/186).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 24, wireType 2 =*/194).string(message.etag);
                            if (message.llmAgent != null && Object.hasOwnProperty.call(message, "llmAgent"))
                                $root.google.cloud.ces.v1.Agent.LlmAgent.encode(message.llmAgent, writer.uint32(/* id 26, wireType 2 =*/210).fork()).ldelim();
                            if (message.remoteDialogflowAgent != null && Object.hasOwnProperty.call(message, "remoteDialogflowAgent"))
                                $root.google.cloud.ces.v1.Agent.RemoteDialogflowAgent.encode(message.remoteDialogflowAgent, writer.uint32(/* id 27, wireType 2 =*/218).fork()).ldelim();
                            if (message.toolsets != null && message.toolsets.length)
                                for (var i = 0; i < message.toolsets.length; ++i)
                                    $root.google.cloud.ces.v1.Agent.AgentToolset.encode(message.toolsets[i], writer.uint32(/* id 28, wireType 2 =*/226).fork()).ldelim();
                            if (message.generatedSummary != null && Object.hasOwnProperty.call(message, "generatedSummary"))
                                writer.uint32(/* id 29, wireType 2 =*/234).string(message.generatedSummary);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Agent message, length delimited. Does not implicitly {@link google.cloud.ces.v1.Agent.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.Agent
                         * @static
                         * @param {google.cloud.ces.v1.IAgent} message Agent message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Agent.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an Agent message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.Agent
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.Agent} Agent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Agent.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.Agent();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 26: {
                                        message.llmAgent = $root.google.cloud.ces.v1.Agent.LlmAgent.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 27: {
                                        message.remoteDialogflowAgent = $root.google.cloud.ces.v1.Agent.RemoteDialogflowAgent.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.modelSettings = $root.google.cloud.ces.v1.ModelSettings.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.instruction = reader.string();
                                        break;
                                    }
                                case 7: {
                                        if (!(message.tools && message.tools.length))
                                            message.tools = [];
                                        message.tools.push(reader.string());
                                        break;
                                    }
                                case 8: {
                                        if (!(message.childAgents && message.childAgents.length))
                                            message.childAgents = [];
                                        message.childAgents.push(reader.string());
                                        break;
                                    }
                                case 18: {
                                        if (!(message.beforeAgentCallbacks && message.beforeAgentCallbacks.length))
                                            message.beforeAgentCallbacks = [];
                                        message.beforeAgentCallbacks.push($root.google.cloud.ces.v1.Callback.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 19: {
                                        if (!(message.afterAgentCallbacks && message.afterAgentCallbacks.length))
                                            message.afterAgentCallbacks = [];
                                        message.afterAgentCallbacks.push($root.google.cloud.ces.v1.Callback.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 20: {
                                        if (!(message.beforeModelCallbacks && message.beforeModelCallbacks.length))
                                            message.beforeModelCallbacks = [];
                                        message.beforeModelCallbacks.push($root.google.cloud.ces.v1.Callback.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 21: {
                                        if (!(message.afterModelCallbacks && message.afterModelCallbacks.length))
                                            message.afterModelCallbacks = [];
                                        message.afterModelCallbacks.push($root.google.cloud.ces.v1.Callback.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 22: {
                                        if (!(message.beforeToolCallbacks && message.beforeToolCallbacks.length))
                                            message.beforeToolCallbacks = [];
                                        message.beforeToolCallbacks.push($root.google.cloud.ces.v1.Callback.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 23: {
                                        if (!(message.afterToolCallbacks && message.afterToolCallbacks.length))
                                            message.afterToolCallbacks = [];
                                        message.afterToolCallbacks.push($root.google.cloud.ces.v1.Callback.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 15: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 16: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 17: {
                                        if (!(message.guardrails && message.guardrails.length))
                                            message.guardrails = [];
                                        message.guardrails.push(reader.string());
                                        break;
                                    }
                                case 24: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                case 28: {
                                        if (!(message.toolsets && message.toolsets.length))
                                            message.toolsets = [];
                                        message.toolsets.push($root.google.cloud.ces.v1.Agent.AgentToolset.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 29: {
                                        message.generatedSummary = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an Agent message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.Agent
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.Agent} Agent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Agent.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an Agent message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.Agent
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Agent.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.llmAgent != null && message.hasOwnProperty("llmAgent")) {
                                properties.agentType = 1;
                                {
                                    var error = $root.google.cloud.ces.v1.Agent.LlmAgent.verify(message.llmAgent);
                                    if (error)
                                        return "llmAgent." + error;
                                }
                            }
                            if (message.remoteDialogflowAgent != null && message.hasOwnProperty("remoteDialogflowAgent")) {
                                if (properties.agentType === 1)
                                    return "agentType: multiple values";
                                properties.agentType = 1;
                                {
                                    var error = $root.google.cloud.ces.v1.Agent.RemoteDialogflowAgent.verify(message.remoteDialogflowAgent);
                                    if (error)
                                        return "remoteDialogflowAgent." + error;
                                }
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.modelSettings != null && message.hasOwnProperty("modelSettings")) {
                                var error = $root.google.cloud.ces.v1.ModelSettings.verify(message.modelSettings);
                                if (error)
                                    return "modelSettings." + error;
                            }
                            if (message.instruction != null && message.hasOwnProperty("instruction"))
                                if (!$util.isString(message.instruction))
                                    return "instruction: string expected";
                            if (message.tools != null && message.hasOwnProperty("tools")) {
                                if (!Array.isArray(message.tools))
                                    return "tools: array expected";
                                for (var i = 0; i < message.tools.length; ++i)
                                    if (!$util.isString(message.tools[i]))
                                        return "tools: string[] expected";
                            }
                            if (message.childAgents != null && message.hasOwnProperty("childAgents")) {
                                if (!Array.isArray(message.childAgents))
                                    return "childAgents: array expected";
                                for (var i = 0; i < message.childAgents.length; ++i)
                                    if (!$util.isString(message.childAgents[i]))
                                        return "childAgents: string[] expected";
                            }
                            if (message.beforeAgentCallbacks != null && message.hasOwnProperty("beforeAgentCallbacks")) {
                                if (!Array.isArray(message.beforeAgentCallbacks))
                                    return "beforeAgentCallbacks: array expected";
                                for (var i = 0; i < message.beforeAgentCallbacks.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Callback.verify(message.beforeAgentCallbacks[i]);
                                    if (error)
                                        return "beforeAgentCallbacks." + error;
                                }
                            }
                            if (message.afterAgentCallbacks != null && message.hasOwnProperty("afterAgentCallbacks")) {
                                if (!Array.isArray(message.afterAgentCallbacks))
                                    return "afterAgentCallbacks: array expected";
                                for (var i = 0; i < message.afterAgentCallbacks.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Callback.verify(message.afterAgentCallbacks[i]);
                                    if (error)
                                        return "afterAgentCallbacks." + error;
                                }
                            }
                            if (message.beforeModelCallbacks != null && message.hasOwnProperty("beforeModelCallbacks")) {
                                if (!Array.isArray(message.beforeModelCallbacks))
                                    return "beforeModelCallbacks: array expected";
                                for (var i = 0; i < message.beforeModelCallbacks.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Callback.verify(message.beforeModelCallbacks[i]);
                                    if (error)
                                        return "beforeModelCallbacks." + error;
                                }
                            }
                            if (message.afterModelCallbacks != null && message.hasOwnProperty("afterModelCallbacks")) {
                                if (!Array.isArray(message.afterModelCallbacks))
                                    return "afterModelCallbacks: array expected";
                                for (var i = 0; i < message.afterModelCallbacks.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Callback.verify(message.afterModelCallbacks[i]);
                                    if (error)
                                        return "afterModelCallbacks." + error;
                                }
                            }
                            if (message.beforeToolCallbacks != null && message.hasOwnProperty("beforeToolCallbacks")) {
                                if (!Array.isArray(message.beforeToolCallbacks))
                                    return "beforeToolCallbacks: array expected";
                                for (var i = 0; i < message.beforeToolCallbacks.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Callback.verify(message.beforeToolCallbacks[i]);
                                    if (error)
                                        return "beforeToolCallbacks." + error;
                                }
                            }
                            if (message.afterToolCallbacks != null && message.hasOwnProperty("afterToolCallbacks")) {
                                if (!Array.isArray(message.afterToolCallbacks))
                                    return "afterToolCallbacks: array expected";
                                for (var i = 0; i < message.afterToolCallbacks.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Callback.verify(message.afterToolCallbacks[i]);
                                    if (error)
                                        return "afterToolCallbacks." + error;
                                }
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            if (message.guardrails != null && message.hasOwnProperty("guardrails")) {
                                if (!Array.isArray(message.guardrails))
                                    return "guardrails: array expected";
                                for (var i = 0; i < message.guardrails.length; ++i)
                                    if (!$util.isString(message.guardrails[i]))
                                        return "guardrails: string[] expected";
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            if (message.toolsets != null && message.hasOwnProperty("toolsets")) {
                                if (!Array.isArray(message.toolsets))
                                    return "toolsets: array expected";
                                for (var i = 0; i < message.toolsets.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Agent.AgentToolset.verify(message.toolsets[i]);
                                    if (error)
                                        return "toolsets." + error;
                                }
                            }
                            if (message.generatedSummary != null && message.hasOwnProperty("generatedSummary"))
                                if (!$util.isString(message.generatedSummary))
                                    return "generatedSummary: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an Agent message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.Agent
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.Agent} Agent
                         */
                        Agent.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.Agent)
                                return object;
                            var message = new $root.google.cloud.ces.v1.Agent();
                            if (object.llmAgent != null) {
                                if (typeof object.llmAgent !== "object")
                                    throw TypeError(".google.cloud.ces.v1.Agent.llmAgent: object expected");
                                message.llmAgent = $root.google.cloud.ces.v1.Agent.LlmAgent.fromObject(object.llmAgent);
                            }
                            if (object.remoteDialogflowAgent != null) {
                                if (typeof object.remoteDialogflowAgent !== "object")
                                    throw TypeError(".google.cloud.ces.v1.Agent.remoteDialogflowAgent: object expected");
                                message.remoteDialogflowAgent = $root.google.cloud.ces.v1.Agent.RemoteDialogflowAgent.fromObject(object.remoteDialogflowAgent);
                            }
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.modelSettings != null) {
                                if (typeof object.modelSettings !== "object")
                                    throw TypeError(".google.cloud.ces.v1.Agent.modelSettings: object expected");
                                message.modelSettings = $root.google.cloud.ces.v1.ModelSettings.fromObject(object.modelSettings);
                            }
                            if (object.instruction != null)
                                message.instruction = String(object.instruction);
                            if (object.tools) {
                                if (!Array.isArray(object.tools))
                                    throw TypeError(".google.cloud.ces.v1.Agent.tools: array expected");
                                message.tools = [];
                                for (var i = 0; i < object.tools.length; ++i)
                                    message.tools[i] = String(object.tools[i]);
                            }
                            if (object.childAgents) {
                                if (!Array.isArray(object.childAgents))
                                    throw TypeError(".google.cloud.ces.v1.Agent.childAgents: array expected");
                                message.childAgents = [];
                                for (var i = 0; i < object.childAgents.length; ++i)
                                    message.childAgents[i] = String(object.childAgents[i]);
                            }
                            if (object.beforeAgentCallbacks) {
                                if (!Array.isArray(object.beforeAgentCallbacks))
                                    throw TypeError(".google.cloud.ces.v1.Agent.beforeAgentCallbacks: array expected");
                                message.beforeAgentCallbacks = [];
                                for (var i = 0; i < object.beforeAgentCallbacks.length; ++i) {
                                    if (typeof object.beforeAgentCallbacks[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Agent.beforeAgentCallbacks: object expected");
                                    message.beforeAgentCallbacks[i] = $root.google.cloud.ces.v1.Callback.fromObject(object.beforeAgentCallbacks[i]);
                                }
                            }
                            if (object.afterAgentCallbacks) {
                                if (!Array.isArray(object.afterAgentCallbacks))
                                    throw TypeError(".google.cloud.ces.v1.Agent.afterAgentCallbacks: array expected");
                                message.afterAgentCallbacks = [];
                                for (var i = 0; i < object.afterAgentCallbacks.length; ++i) {
                                    if (typeof object.afterAgentCallbacks[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Agent.afterAgentCallbacks: object expected");
                                    message.afterAgentCallbacks[i] = $root.google.cloud.ces.v1.Callback.fromObject(object.afterAgentCallbacks[i]);
                                }
                            }
                            if (object.beforeModelCallbacks) {
                                if (!Array.isArray(object.beforeModelCallbacks))
                                    throw TypeError(".google.cloud.ces.v1.Agent.beforeModelCallbacks: array expected");
                                message.beforeModelCallbacks = [];
                                for (var i = 0; i < object.beforeModelCallbacks.length; ++i) {
                                    if (typeof object.beforeModelCallbacks[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Agent.beforeModelCallbacks: object expected");
                                    message.beforeModelCallbacks[i] = $root.google.cloud.ces.v1.Callback.fromObject(object.beforeModelCallbacks[i]);
                                }
                            }
                            if (object.afterModelCallbacks) {
                                if (!Array.isArray(object.afterModelCallbacks))
                                    throw TypeError(".google.cloud.ces.v1.Agent.afterModelCallbacks: array expected");
                                message.afterModelCallbacks = [];
                                for (var i = 0; i < object.afterModelCallbacks.length; ++i) {
                                    if (typeof object.afterModelCallbacks[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Agent.afterModelCallbacks: object expected");
                                    message.afterModelCallbacks[i] = $root.google.cloud.ces.v1.Callback.fromObject(object.afterModelCallbacks[i]);
                                }
                            }
                            if (object.beforeToolCallbacks) {
                                if (!Array.isArray(object.beforeToolCallbacks))
                                    throw TypeError(".google.cloud.ces.v1.Agent.beforeToolCallbacks: array expected");
                                message.beforeToolCallbacks = [];
                                for (var i = 0; i < object.beforeToolCallbacks.length; ++i) {
                                    if (typeof object.beforeToolCallbacks[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Agent.beforeToolCallbacks: object expected");
                                    message.beforeToolCallbacks[i] = $root.google.cloud.ces.v1.Callback.fromObject(object.beforeToolCallbacks[i]);
                                }
                            }
                            if (object.afterToolCallbacks) {
                                if (!Array.isArray(object.afterToolCallbacks))
                                    throw TypeError(".google.cloud.ces.v1.Agent.afterToolCallbacks: array expected");
                                message.afterToolCallbacks = [];
                                for (var i = 0; i < object.afterToolCallbacks.length; ++i) {
                                    if (typeof object.afterToolCallbacks[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Agent.afterToolCallbacks: object expected");
                                    message.afterToolCallbacks[i] = $root.google.cloud.ces.v1.Callback.fromObject(object.afterToolCallbacks[i]);
                                }
                            }
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.ces.v1.Agent.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.cloud.ces.v1.Agent.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            if (object.guardrails) {
                                if (!Array.isArray(object.guardrails))
                                    throw TypeError(".google.cloud.ces.v1.Agent.guardrails: array expected");
                                message.guardrails = [];
                                for (var i = 0; i < object.guardrails.length; ++i)
                                    message.guardrails[i] = String(object.guardrails[i]);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            if (object.toolsets) {
                                if (!Array.isArray(object.toolsets))
                                    throw TypeError(".google.cloud.ces.v1.Agent.toolsets: array expected");
                                message.toolsets = [];
                                for (var i = 0; i < object.toolsets.length; ++i) {
                                    if (typeof object.toolsets[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Agent.toolsets: object expected");
                                    message.toolsets[i] = $root.google.cloud.ces.v1.Agent.AgentToolset.fromObject(object.toolsets[i]);
                                }
                            }
                            if (object.generatedSummary != null)
                                message.generatedSummary = String(object.generatedSummary);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an Agent message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.Agent
                         * @static
                         * @param {google.cloud.ces.v1.Agent} message Agent
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Agent.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.tools = [];
                                object.childAgents = [];
                                object.guardrails = [];
                                object.beforeAgentCallbacks = [];
                                object.afterAgentCallbacks = [];
                                object.beforeModelCallbacks = [];
                                object.afterModelCallbacks = [];
                                object.beforeToolCallbacks = [];
                                object.afterToolCallbacks = [];
                                object.toolsets = [];
                            }
                            if (options.defaults) {
                                object.name = "";
                                object.displayName = "";
                                object.description = "";
                                object.modelSettings = null;
                                object.instruction = "";
                                object.createTime = null;
                                object.updateTime = null;
                                object.etag = "";
                                object.generatedSummary = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.modelSettings != null && message.hasOwnProperty("modelSettings"))
                                object.modelSettings = $root.google.cloud.ces.v1.ModelSettings.toObject(message.modelSettings, options);
                            if (message.instruction != null && message.hasOwnProperty("instruction"))
                                object.instruction = message.instruction;
                            if (message.tools && message.tools.length) {
                                object.tools = [];
                                for (var j = 0; j < message.tools.length; ++j)
                                    object.tools[j] = message.tools[j];
                            }
                            if (message.childAgents && message.childAgents.length) {
                                object.childAgents = [];
                                for (var j = 0; j < message.childAgents.length; ++j)
                                    object.childAgents[j] = message.childAgents[j];
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            if (message.guardrails && message.guardrails.length) {
                                object.guardrails = [];
                                for (var j = 0; j < message.guardrails.length; ++j)
                                    object.guardrails[j] = message.guardrails[j];
                            }
                            if (message.beforeAgentCallbacks && message.beforeAgentCallbacks.length) {
                                object.beforeAgentCallbacks = [];
                                for (var j = 0; j < message.beforeAgentCallbacks.length; ++j)
                                    object.beforeAgentCallbacks[j] = $root.google.cloud.ces.v1.Callback.toObject(message.beforeAgentCallbacks[j], options);
                            }
                            if (message.afterAgentCallbacks && message.afterAgentCallbacks.length) {
                                object.afterAgentCallbacks = [];
                                for (var j = 0; j < message.afterAgentCallbacks.length; ++j)
                                    object.afterAgentCallbacks[j] = $root.google.cloud.ces.v1.Callback.toObject(message.afterAgentCallbacks[j], options);
                            }
                            if (message.beforeModelCallbacks && message.beforeModelCallbacks.length) {
                                object.beforeModelCallbacks = [];
                                for (var j = 0; j < message.beforeModelCallbacks.length; ++j)
                                    object.beforeModelCallbacks[j] = $root.google.cloud.ces.v1.Callback.toObject(message.beforeModelCallbacks[j], options);
                            }
                            if (message.afterModelCallbacks && message.afterModelCallbacks.length) {
                                object.afterModelCallbacks = [];
                                for (var j = 0; j < message.afterModelCallbacks.length; ++j)
                                    object.afterModelCallbacks[j] = $root.google.cloud.ces.v1.Callback.toObject(message.afterModelCallbacks[j], options);
                            }
                            if (message.beforeToolCallbacks && message.beforeToolCallbacks.length) {
                                object.beforeToolCallbacks = [];
                                for (var j = 0; j < message.beforeToolCallbacks.length; ++j)
                                    object.beforeToolCallbacks[j] = $root.google.cloud.ces.v1.Callback.toObject(message.beforeToolCallbacks[j], options);
                            }
                            if (message.afterToolCallbacks && message.afterToolCallbacks.length) {
                                object.afterToolCallbacks = [];
                                for (var j = 0; j < message.afterToolCallbacks.length; ++j)
                                    object.afterToolCallbacks[j] = $root.google.cloud.ces.v1.Callback.toObject(message.afterToolCallbacks[j], options);
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            if (message.llmAgent != null && message.hasOwnProperty("llmAgent")) {
                                object.llmAgent = $root.google.cloud.ces.v1.Agent.LlmAgent.toObject(message.llmAgent, options);
                                if (options.oneofs)
                                    object.agentType = "llmAgent";
                            }
                            if (message.remoteDialogflowAgent != null && message.hasOwnProperty("remoteDialogflowAgent")) {
                                object.remoteDialogflowAgent = $root.google.cloud.ces.v1.Agent.RemoteDialogflowAgent.toObject(message.remoteDialogflowAgent, options);
                                if (options.oneofs)
                                    object.agentType = "remoteDialogflowAgent";
                            }
                            if (message.toolsets && message.toolsets.length) {
                                object.toolsets = [];
                                for (var j = 0; j < message.toolsets.length; ++j)
                                    object.toolsets[j] = $root.google.cloud.ces.v1.Agent.AgentToolset.toObject(message.toolsets[j], options);
                            }
                            if (message.generatedSummary != null && message.hasOwnProperty("generatedSummary"))
                                object.generatedSummary = message.generatedSummary;
                            return object;
                        };
    
                        /**
                         * Converts this Agent to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.Agent
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Agent.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Agent
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.Agent
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Agent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.Agent";
                        };
    
                        Agent.LlmAgent = (function() {
    
                            /**
                             * Properties of a LlmAgent.
                             * @memberof google.cloud.ces.v1.Agent
                             * @interface ILlmAgent
                             */
    
                            /**
                             * Constructs a new LlmAgent.
                             * @memberof google.cloud.ces.v1.Agent
                             * @classdesc Represents a LlmAgent.
                             * @implements ILlmAgent
                             * @constructor
                             * @param {google.cloud.ces.v1.Agent.ILlmAgent=} [properties] Properties to set
                             */
                            function LlmAgent(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * Creates a new LlmAgent instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @static
                             * @param {google.cloud.ces.v1.Agent.ILlmAgent=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.Agent.LlmAgent} LlmAgent instance
                             */
                            LlmAgent.create = function create(properties) {
                                return new LlmAgent(properties);
                            };
    
                            /**
                             * Encodes the specified LlmAgent message. Does not implicitly {@link google.cloud.ces.v1.Agent.LlmAgent.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @static
                             * @param {google.cloud.ces.v1.Agent.ILlmAgent} message LlmAgent message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            LlmAgent.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified LlmAgent message, length delimited. Does not implicitly {@link google.cloud.ces.v1.Agent.LlmAgent.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @static
                             * @param {google.cloud.ces.v1.Agent.ILlmAgent} message LlmAgent message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            LlmAgent.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a LlmAgent message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.Agent.LlmAgent} LlmAgent
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            LlmAgent.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.Agent.LlmAgent();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a LlmAgent message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.Agent.LlmAgent} LlmAgent
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            LlmAgent.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a LlmAgent message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            LlmAgent.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                return null;
                            };
    
                            /**
                             * Creates a LlmAgent message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.Agent.LlmAgent} LlmAgent
                             */
                            LlmAgent.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.Agent.LlmAgent)
                                    return object;
                                return new $root.google.cloud.ces.v1.Agent.LlmAgent();
                            };
    
                            /**
                             * Creates a plain object from a LlmAgent message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @static
                             * @param {google.cloud.ces.v1.Agent.LlmAgent} message LlmAgent
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            LlmAgent.toObject = function toObject() {
                                return {};
                            };
    
                            /**
                             * Converts this LlmAgent to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            LlmAgent.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for LlmAgent
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.Agent.LlmAgent
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            LlmAgent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.Agent.LlmAgent";
                            };
    
                            return LlmAgent;
                        })();
    
                        Agent.RemoteDialogflowAgent = (function() {
    
                            /**
                             * Properties of a RemoteDialogflowAgent.
                             * @memberof google.cloud.ces.v1.Agent
                             * @interface IRemoteDialogflowAgent
                             * @property {string|null} [agent] RemoteDialogflowAgent agent
                             * @property {string|null} [flowId] RemoteDialogflowAgent flowId
                             * @property {string|null} [environmentId] RemoteDialogflowAgent environmentId
                             * @property {Object.<string,string>|null} [inputVariableMapping] RemoteDialogflowAgent inputVariableMapping
                             * @property {Object.<string,string>|null} [outputVariableMapping] RemoteDialogflowAgent outputVariableMapping
                             */
    
                            /**
                             * Constructs a new RemoteDialogflowAgent.
                             * @memberof google.cloud.ces.v1.Agent
                             * @classdesc Represents a RemoteDialogflowAgent.
                             * @implements IRemoteDialogflowAgent
                             * @constructor
                             * @param {google.cloud.ces.v1.Agent.IRemoteDialogflowAgent=} [properties] Properties to set
                             */
                            function RemoteDialogflowAgent(properties) {
                                this.inputVariableMapping = {};
                                this.outputVariableMapping = {};
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * RemoteDialogflowAgent agent.
                             * @member {string} agent
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @instance
                             */
                            RemoteDialogflowAgent.prototype.agent = "";
    
                            /**
                             * RemoteDialogflowAgent flowId.
                             * @member {string} flowId
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @instance
                             */
                            RemoteDialogflowAgent.prototype.flowId = "";
    
                            /**
                             * RemoteDialogflowAgent environmentId.
                             * @member {string} environmentId
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @instance
                             */
                            RemoteDialogflowAgent.prototype.environmentId = "";
    
                            /**
                             * RemoteDialogflowAgent inputVariableMapping.
                             * @member {Object.<string,string>} inputVariableMapping
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @instance
                             */
                            RemoteDialogflowAgent.prototype.inputVariableMapping = $util.emptyObject;
    
                            /**
                             * RemoteDialogflowAgent outputVariableMapping.
                             * @member {Object.<string,string>} outputVariableMapping
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @instance
                             */
                            RemoteDialogflowAgent.prototype.outputVariableMapping = $util.emptyObject;
    
                            /**
                             * Creates a new RemoteDialogflowAgent instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @static
                             * @param {google.cloud.ces.v1.Agent.IRemoteDialogflowAgent=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.Agent.RemoteDialogflowAgent} RemoteDialogflowAgent instance
                             */
                            RemoteDialogflowAgent.create = function create(properties) {
                                return new RemoteDialogflowAgent(properties);
                            };
    
                            /**
                             * Encodes the specified RemoteDialogflowAgent message. Does not implicitly {@link google.cloud.ces.v1.Agent.RemoteDialogflowAgent.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @static
                             * @param {google.cloud.ces.v1.Agent.IRemoteDialogflowAgent} message RemoteDialogflowAgent message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            RemoteDialogflowAgent.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.agent != null && Object.hasOwnProperty.call(message, "agent"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.agent);
                                if (message.flowId != null && Object.hasOwnProperty.call(message, "flowId"))
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.flowId);
                                if (message.environmentId != null && Object.hasOwnProperty.call(message, "environmentId"))
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.environmentId);
                                if (message.inputVariableMapping != null && Object.hasOwnProperty.call(message, "inputVariableMapping"))
                                    for (var keys = Object.keys(message.inputVariableMapping), i = 0; i < keys.length; ++i)
                                        writer.uint32(/* id 4, wireType 2 =*/34).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.inputVariableMapping[keys[i]]).ldelim();
                                if (message.outputVariableMapping != null && Object.hasOwnProperty.call(message, "outputVariableMapping"))
                                    for (var keys = Object.keys(message.outputVariableMapping), i = 0; i < keys.length; ++i)
                                        writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.outputVariableMapping[keys[i]]).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified RemoteDialogflowAgent message, length delimited. Does not implicitly {@link google.cloud.ces.v1.Agent.RemoteDialogflowAgent.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @static
                             * @param {google.cloud.ces.v1.Agent.IRemoteDialogflowAgent} message RemoteDialogflowAgent message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            RemoteDialogflowAgent.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a RemoteDialogflowAgent message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.Agent.RemoteDialogflowAgent} RemoteDialogflowAgent
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            RemoteDialogflowAgent.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.Agent.RemoteDialogflowAgent(), key, value;
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.agent = reader.string();
                                            break;
                                        }
                                    case 2: {
                                            message.flowId = reader.string();
                                            break;
                                        }
                                    case 3: {
                                            message.environmentId = reader.string();
                                            break;
                                        }
                                    case 4: {
                                            if (message.inputVariableMapping === $util.emptyObject)
                                                message.inputVariableMapping = {};
                                            var end2 = reader.uint32() + reader.pos;
                                            key = "";
                                            value = "";
                                            while (reader.pos < end2) {
                                                var tag2 = reader.uint32();
                                                switch (tag2 >>> 3) {
                                                case 1:
                                                    key = reader.string();
                                                    break;
                                                case 2:
                                                    value = reader.string();
                                                    break;
                                                default:
                                                    reader.skipType(tag2 & 7);
                                                    break;
                                                }
                                            }
                                            message.inputVariableMapping[key] = value;
                                            break;
                                        }
                                    case 5: {
                                            if (message.outputVariableMapping === $util.emptyObject)
                                                message.outputVariableMapping = {};
                                            var end2 = reader.uint32() + reader.pos;
                                            key = "";
                                            value = "";
                                            while (reader.pos < end2) {
                                                var tag2 = reader.uint32();
                                                switch (tag2 >>> 3) {
                                                case 1:
                                                    key = reader.string();
                                                    break;
                                                case 2:
                                                    value = reader.string();
                                                    break;
                                                default:
                                                    reader.skipType(tag2 & 7);
                                                    break;
                                                }
                                            }
                                            message.outputVariableMapping[key] = value;
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a RemoteDialogflowAgent message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.Agent.RemoteDialogflowAgent} RemoteDialogflowAgent
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            RemoteDialogflowAgent.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a RemoteDialogflowAgent message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            RemoteDialogflowAgent.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.agent != null && message.hasOwnProperty("agent"))
                                    if (!$util.isString(message.agent))
                                        return "agent: string expected";
                                if (message.flowId != null && message.hasOwnProperty("flowId"))
                                    if (!$util.isString(message.flowId))
                                        return "flowId: string expected";
                                if (message.environmentId != null && message.hasOwnProperty("environmentId"))
                                    if (!$util.isString(message.environmentId))
                                        return "environmentId: string expected";
                                if (message.inputVariableMapping != null && message.hasOwnProperty("inputVariableMapping")) {
                                    if (!$util.isObject(message.inputVariableMapping))
                                        return "inputVariableMapping: object expected";
                                    var key = Object.keys(message.inputVariableMapping);
                                    for (var i = 0; i < key.length; ++i)
                                        if (!$util.isString(message.inputVariableMapping[key[i]]))
                                            return "inputVariableMapping: string{k:string} expected";
                                }
                                if (message.outputVariableMapping != null && message.hasOwnProperty("outputVariableMapping")) {
                                    if (!$util.isObject(message.outputVariableMapping))
                                        return "outputVariableMapping: object expected";
                                    var key = Object.keys(message.outputVariableMapping);
                                    for (var i = 0; i < key.length; ++i)
                                        if (!$util.isString(message.outputVariableMapping[key[i]]))
                                            return "outputVariableMapping: string{k:string} expected";
                                }
                                return null;
                            };
    
                            /**
                             * Creates a RemoteDialogflowAgent message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.Agent.RemoteDialogflowAgent} RemoteDialogflowAgent
                             */
                            RemoteDialogflowAgent.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.Agent.RemoteDialogflowAgent)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.Agent.RemoteDialogflowAgent();
                                if (object.agent != null)
                                    message.agent = String(object.agent);
                                if (object.flowId != null)
                                    message.flowId = String(object.flowId);
                                if (object.environmentId != null)
                                    message.environmentId = String(object.environmentId);
                                if (object.inputVariableMapping) {
                                    if (typeof object.inputVariableMapping !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Agent.RemoteDialogflowAgent.inputVariableMapping: object expected");
                                    message.inputVariableMapping = {};
                                    for (var keys = Object.keys(object.inputVariableMapping), i = 0; i < keys.length; ++i)
                                        message.inputVariableMapping[keys[i]] = String(object.inputVariableMapping[keys[i]]);
                                }
                                if (object.outputVariableMapping) {
                                    if (typeof object.outputVariableMapping !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Agent.RemoteDialogflowAgent.outputVariableMapping: object expected");
                                    message.outputVariableMapping = {};
                                    for (var keys = Object.keys(object.outputVariableMapping), i = 0; i < keys.length; ++i)
                                        message.outputVariableMapping[keys[i]] = String(object.outputVariableMapping[keys[i]]);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a RemoteDialogflowAgent message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @static
                             * @param {google.cloud.ces.v1.Agent.RemoteDialogflowAgent} message RemoteDialogflowAgent
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            RemoteDialogflowAgent.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.objects || options.defaults) {
                                    object.inputVariableMapping = {};
                                    object.outputVariableMapping = {};
                                }
                                if (options.defaults) {
                                    object.agent = "";
                                    object.flowId = "";
                                    object.environmentId = "";
                                }
                                if (message.agent != null && message.hasOwnProperty("agent"))
                                    object.agent = message.agent;
                                if (message.flowId != null && message.hasOwnProperty("flowId"))
                                    object.flowId = message.flowId;
                                if (message.environmentId != null && message.hasOwnProperty("environmentId"))
                                    object.environmentId = message.environmentId;
                                var keys2;
                                if (message.inputVariableMapping && (keys2 = Object.keys(message.inputVariableMapping)).length) {
                                    object.inputVariableMapping = {};
                                    for (var j = 0; j < keys2.length; ++j)
                                        object.inputVariableMapping[keys2[j]] = message.inputVariableMapping[keys2[j]];
                                }
                                if (message.outputVariableMapping && (keys2 = Object.keys(message.outputVariableMapping)).length) {
                                    object.outputVariableMapping = {};
                                    for (var j = 0; j < keys2.length; ++j)
                                        object.outputVariableMapping[keys2[j]] = message.outputVariableMapping[keys2[j]];
                                }
                                return object;
                            };
    
                            /**
                             * Converts this RemoteDialogflowAgent to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            RemoteDialogflowAgent.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for RemoteDialogflowAgent
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.Agent.RemoteDialogflowAgent
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            RemoteDialogflowAgent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.Agent.RemoteDialogflowAgent";
                            };
    
                            return RemoteDialogflowAgent;
                        })();
    
                        Agent.AgentToolset = (function() {
    
                            /**
                             * Properties of an AgentToolset.
                             * @memberof google.cloud.ces.v1.Agent
                             * @interface IAgentToolset
                             * @property {string|null} [toolset] AgentToolset toolset
                             * @property {Array.<string>|null} [toolIds] AgentToolset toolIds
                             */
    
                            /**
                             * Constructs a new AgentToolset.
                             * @memberof google.cloud.ces.v1.Agent
                             * @classdesc Represents an AgentToolset.
                             * @implements IAgentToolset
                             * @constructor
                             * @param {google.cloud.ces.v1.Agent.IAgentToolset=} [properties] Properties to set
                             */
                            function AgentToolset(properties) {
                                this.toolIds = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * AgentToolset toolset.
                             * @member {string} toolset
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @instance
                             */
                            AgentToolset.prototype.toolset = "";
    
                            /**
                             * AgentToolset toolIds.
                             * @member {Array.<string>} toolIds
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @instance
                             */
                            AgentToolset.prototype.toolIds = $util.emptyArray;
    
                            /**
                             * Creates a new AgentToolset instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @static
                             * @param {google.cloud.ces.v1.Agent.IAgentToolset=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.Agent.AgentToolset} AgentToolset instance
                             */
                            AgentToolset.create = function create(properties) {
                                return new AgentToolset(properties);
                            };
    
                            /**
                             * Encodes the specified AgentToolset message. Does not implicitly {@link google.cloud.ces.v1.Agent.AgentToolset.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @static
                             * @param {google.cloud.ces.v1.Agent.IAgentToolset} message AgentToolset message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            AgentToolset.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.toolset != null && Object.hasOwnProperty.call(message, "toolset"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.toolset);
                                if (message.toolIds != null && message.toolIds.length)
                                    for (var i = 0; i < message.toolIds.length; ++i)
                                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.toolIds[i]);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified AgentToolset message, length delimited. Does not implicitly {@link google.cloud.ces.v1.Agent.AgentToolset.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @static
                             * @param {google.cloud.ces.v1.Agent.IAgentToolset} message AgentToolset message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            AgentToolset.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an AgentToolset message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.Agent.AgentToolset} AgentToolset
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            AgentToolset.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.Agent.AgentToolset();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.toolset = reader.string();
                                            break;
                                        }
                                    case 4: {
                                            if (!(message.toolIds && message.toolIds.length))
                                                message.toolIds = [];
                                            message.toolIds.push(reader.string());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an AgentToolset message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.Agent.AgentToolset} AgentToolset
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            AgentToolset.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an AgentToolset message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            AgentToolset.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.toolset != null && message.hasOwnProperty("toolset"))
                                    if (!$util.isString(message.toolset))
                                        return "toolset: string expected";
                                if (message.toolIds != null && message.hasOwnProperty("toolIds")) {
                                    if (!Array.isArray(message.toolIds))
                                        return "toolIds: array expected";
                                    for (var i = 0; i < message.toolIds.length; ++i)
                                        if (!$util.isString(message.toolIds[i]))
                                            return "toolIds: string[] expected";
                                }
                                return null;
                            };
    
                            /**
                             * Creates an AgentToolset message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.Agent.AgentToolset} AgentToolset
                             */
                            AgentToolset.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.Agent.AgentToolset)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.Agent.AgentToolset();
                                if (object.toolset != null)
                                    message.toolset = String(object.toolset);
                                if (object.toolIds) {
                                    if (!Array.isArray(object.toolIds))
                                        throw TypeError(".google.cloud.ces.v1.Agent.AgentToolset.toolIds: array expected");
                                    message.toolIds = [];
                                    for (var i = 0; i < object.toolIds.length; ++i)
                                        message.toolIds[i] = String(object.toolIds[i]);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an AgentToolset message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @static
                             * @param {google.cloud.ces.v1.Agent.AgentToolset} message AgentToolset
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            AgentToolset.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.toolIds = [];
                                if (options.defaults)
                                    object.toolset = "";
                                if (message.toolset != null && message.hasOwnProperty("toolset"))
                                    object.toolset = message.toolset;
                                if (message.toolIds && message.toolIds.length) {
                                    object.toolIds = [];
                                    for (var j = 0; j < message.toolIds.length; ++j)
                                        object.toolIds[j] = message.toolIds[j];
                                }
                                return object;
                            };
    
                            /**
                             * Converts this AgentToolset to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            AgentToolset.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for AgentToolset
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.Agent.AgentToolset
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            AgentToolset.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.Agent.AgentToolset";
                            };
    
                            return AgentToolset;
                        })();
    
                        return Agent;
                    })();
    
                    /**
                     * ExecutionType enum.
                     * @name google.cloud.ces.v1.ExecutionType
                     * @enum {number}
                     * @property {number} EXECUTION_TYPE_UNSPECIFIED=0 EXECUTION_TYPE_UNSPECIFIED value
                     * @property {number} SYNCHRONOUS=1 SYNCHRONOUS value
                     * @property {number} ASYNCHRONOUS=2 ASYNCHRONOUS value
                     */
                    v1.ExecutionType = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "EXECUTION_TYPE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "SYNCHRONOUS"] = 1;
                        values[valuesById[2] = "ASYNCHRONOUS"] = 2;
                        return values;
                    })();
    
                    v1.Callback = (function() {
    
                        /**
                         * Properties of a Callback.
                         * @memberof google.cloud.ces.v1
                         * @interface ICallback
                         * @property {string|null} [pythonCode] Callback pythonCode
                         * @property {string|null} [description] Callback description
                         * @property {boolean|null} [disabled] Callback disabled
                         */
    
                        /**
                         * Constructs a new Callback.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a Callback.
                         * @implements ICallback
                         * @constructor
                         * @param {google.cloud.ces.v1.ICallback=} [properties] Properties to set
                         */
                        function Callback(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Callback pythonCode.
                         * @member {string|null|undefined} pythonCode
                         * @memberof google.cloud.ces.v1.Callback
                         * @instance
                         */
                        Callback.prototype.pythonCode = null;
    
                        /**
                         * Callback description.
                         * @member {string} description
                         * @memberof google.cloud.ces.v1.Callback
                         * @instance
                         */
                        Callback.prototype.description = "";
    
                        /**
                         * Callback disabled.
                         * @member {boolean} disabled
                         * @memberof google.cloud.ces.v1.Callback
                         * @instance
                         */
                        Callback.prototype.disabled = false;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * Callback callback.
                         * @member {"pythonCode"|undefined} callback
                         * @memberof google.cloud.ces.v1.Callback
                         * @instance
                         */
                        Object.defineProperty(Callback.prototype, "callback", {
                            get: $util.oneOfGetter($oneOfFields = ["pythonCode"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new Callback instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.Callback
                         * @static
                         * @param {google.cloud.ces.v1.ICallback=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.Callback} Callback instance
                         */
                        Callback.create = function create(properties) {
                            return new Callback(properties);
                        };
    
                        /**
                         * Encodes the specified Callback message. Does not implicitly {@link google.cloud.ces.v1.Callback.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.Callback
                         * @static
                         * @param {google.cloud.ces.v1.ICallback} message Callback message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Callback.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.pythonCode != null && Object.hasOwnProperty.call(message, "pythonCode"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.pythonCode);
                            if (message.disabled != null && Object.hasOwnProperty.call(message, "disabled"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.disabled);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Callback message, length delimited. Does not implicitly {@link google.cloud.ces.v1.Callback.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.Callback
                         * @static
                         * @param {google.cloud.ces.v1.ICallback} message Callback message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Callback.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Callback message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.Callback
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.Callback} Callback
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Callback.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.Callback();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.pythonCode = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.disabled = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Callback message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.Callback
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.Callback} Callback
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Callback.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Callback message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.Callback
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Callback.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.pythonCode != null && message.hasOwnProperty("pythonCode")) {
                                properties.callback = 1;
                                if (!$util.isString(message.pythonCode))
                                    return "pythonCode: string expected";
                            }
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.disabled != null && message.hasOwnProperty("disabled"))
                                if (typeof message.disabled !== "boolean")
                                    return "disabled: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a Callback message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.Callback
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.Callback} Callback
                         */
                        Callback.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.Callback)
                                return object;
                            var message = new $root.google.cloud.ces.v1.Callback();
                            if (object.pythonCode != null)
                                message.pythonCode = String(object.pythonCode);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.disabled != null)
                                message.disabled = Boolean(object.disabled);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Callback message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.Callback
                         * @static
                         * @param {google.cloud.ces.v1.Callback} message Callback
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Callback.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.disabled = false;
                                object.description = "";
                            }
                            if (message.pythonCode != null && message.hasOwnProperty("pythonCode")) {
                                object.pythonCode = message.pythonCode;
                                if (options.oneofs)
                                    object.callback = "pythonCode";
                            }
                            if (message.disabled != null && message.hasOwnProperty("disabled"))
                                object.disabled = message.disabled;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            return object;
                        };
    
                        /**
                         * Converts this Callback to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.Callback
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Callback.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Callback
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.Callback
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Callback.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.Callback";
                        };
    
                        return Callback;
                    })();
    
                    v1.ModelSettings = (function() {
    
                        /**
                         * Properties of a ModelSettings.
                         * @memberof google.cloud.ces.v1
                         * @interface IModelSettings
                         * @property {string|null} [model] ModelSettings model
                         * @property {number|null} [temperature] ModelSettings temperature
                         */
    
                        /**
                         * Constructs a new ModelSettings.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ModelSettings.
                         * @implements IModelSettings
                         * @constructor
                         * @param {google.cloud.ces.v1.IModelSettings=} [properties] Properties to set
                         */
                        function ModelSettings(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ModelSettings model.
                         * @member {string} model
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @instance
                         */
                        ModelSettings.prototype.model = "";
    
                        /**
                         * ModelSettings temperature.
                         * @member {number|null|undefined} temperature
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @instance
                         */
                        ModelSettings.prototype.temperature = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        // Virtual OneOf for proto3 optional field
                        Object.defineProperty(ModelSettings.prototype, "_temperature", {
                            get: $util.oneOfGetter($oneOfFields = ["temperature"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new ModelSettings instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @static
                         * @param {google.cloud.ces.v1.IModelSettings=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ModelSettings} ModelSettings instance
                         */
                        ModelSettings.create = function create(properties) {
                            return new ModelSettings(properties);
                        };
    
                        /**
                         * Encodes the specified ModelSettings message. Does not implicitly {@link google.cloud.ces.v1.ModelSettings.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @static
                         * @param {google.cloud.ces.v1.IModelSettings} message ModelSettings message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ModelSettings.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.model != null && Object.hasOwnProperty.call(message, "model"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.model);
                            if (message.temperature != null && Object.hasOwnProperty.call(message, "temperature"))
                                writer.uint32(/* id 2, wireType 1 =*/17).double(message.temperature);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ModelSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ModelSettings.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @static
                         * @param {google.cloud.ces.v1.IModelSettings} message ModelSettings message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ModelSettings.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ModelSettings message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ModelSettings} ModelSettings
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ModelSettings.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ModelSettings();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.model = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.temperature = reader.double();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ModelSettings message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ModelSettings} ModelSettings
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ModelSettings.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ModelSettings message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ModelSettings.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.model != null && message.hasOwnProperty("model"))
                                if (!$util.isString(message.model))
                                    return "model: string expected";
                            if (message.temperature != null && message.hasOwnProperty("temperature")) {
                                properties._temperature = 1;
                                if (typeof message.temperature !== "number")
                                    return "temperature: number expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ModelSettings message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ModelSettings} ModelSettings
                         */
                        ModelSettings.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ModelSettings)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ModelSettings();
                            if (object.model != null)
                                message.model = String(object.model);
                            if (object.temperature != null)
                                message.temperature = Number(object.temperature);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ModelSettings message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @static
                         * @param {google.cloud.ces.v1.ModelSettings} message ModelSettings
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ModelSettings.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.model = "";
                            if (message.model != null && message.hasOwnProperty("model"))
                                object.model = message.model;
                            if (message.temperature != null && message.hasOwnProperty("temperature")) {
                                object.temperature = options.json && !isFinite(message.temperature) ? String(message.temperature) : message.temperature;
                                if (options.oneofs)
                                    object._temperature = "temperature";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ModelSettings to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ModelSettings.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ModelSettings
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ModelSettings
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ModelSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ModelSettings";
                        };
    
                        return ModelSettings;
                    })();
    
                    v1.TriggerAction = (function() {
    
                        /**
                         * Properties of a TriggerAction.
                         * @memberof google.cloud.ces.v1
                         * @interface ITriggerAction
                         * @property {google.cloud.ces.v1.TriggerAction.IRespondImmediately|null} [respondImmediately] TriggerAction respondImmediately
                         * @property {google.cloud.ces.v1.TriggerAction.ITransferAgent|null} [transferAgent] TriggerAction transferAgent
                         * @property {google.cloud.ces.v1.TriggerAction.IGenerativeAnswer|null} [generativeAnswer] TriggerAction generativeAnswer
                         */
    
                        /**
                         * Constructs a new TriggerAction.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a TriggerAction.
                         * @implements ITriggerAction
                         * @constructor
                         * @param {google.cloud.ces.v1.ITriggerAction=} [properties] Properties to set
                         */
                        function TriggerAction(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * TriggerAction respondImmediately.
                         * @member {google.cloud.ces.v1.TriggerAction.IRespondImmediately|null|undefined} respondImmediately
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @instance
                         */
                        TriggerAction.prototype.respondImmediately = null;
    
                        /**
                         * TriggerAction transferAgent.
                         * @member {google.cloud.ces.v1.TriggerAction.ITransferAgent|null|undefined} transferAgent
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @instance
                         */
                        TriggerAction.prototype.transferAgent = null;
    
                        /**
                         * TriggerAction generativeAnswer.
                         * @member {google.cloud.ces.v1.TriggerAction.IGenerativeAnswer|null|undefined} generativeAnswer
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @instance
                         */
                        TriggerAction.prototype.generativeAnswer = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * TriggerAction action.
                         * @member {"respondImmediately"|"transferAgent"|"generativeAnswer"|undefined} action
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @instance
                         */
                        Object.defineProperty(TriggerAction.prototype, "action", {
                            get: $util.oneOfGetter($oneOfFields = ["respondImmediately", "transferAgent", "generativeAnswer"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new TriggerAction instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @static
                         * @param {google.cloud.ces.v1.ITriggerAction=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.TriggerAction} TriggerAction instance
                         */
                        TriggerAction.create = function create(properties) {
                            return new TriggerAction(properties);
                        };
    
                        /**
                         * Encodes the specified TriggerAction message. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @static
                         * @param {google.cloud.ces.v1.ITriggerAction} message TriggerAction message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TriggerAction.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.respondImmediately != null && Object.hasOwnProperty.call(message, "respondImmediately"))
                                $root.google.cloud.ces.v1.TriggerAction.RespondImmediately.encode(message.respondImmediately, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.transferAgent != null && Object.hasOwnProperty.call(message, "transferAgent"))
                                $root.google.cloud.ces.v1.TriggerAction.TransferAgent.encode(message.transferAgent, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.generativeAnswer != null && Object.hasOwnProperty.call(message, "generativeAnswer"))
                                $root.google.cloud.ces.v1.TriggerAction.GenerativeAnswer.encode(message.generativeAnswer, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified TriggerAction message, length delimited. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @static
                         * @param {google.cloud.ces.v1.ITriggerAction} message TriggerAction message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TriggerAction.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a TriggerAction message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.TriggerAction} TriggerAction
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TriggerAction.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.TriggerAction();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.respondImmediately = $root.google.cloud.ces.v1.TriggerAction.RespondImmediately.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.transferAgent = $root.google.cloud.ces.v1.TriggerAction.TransferAgent.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.generativeAnswer = $root.google.cloud.ces.v1.TriggerAction.GenerativeAnswer.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a TriggerAction message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.TriggerAction} TriggerAction
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TriggerAction.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a TriggerAction message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TriggerAction.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.respondImmediately != null && message.hasOwnProperty("respondImmediately")) {
                                properties.action = 1;
                                {
                                    var error = $root.google.cloud.ces.v1.TriggerAction.RespondImmediately.verify(message.respondImmediately);
                                    if (error)
                                        return "respondImmediately." + error;
                                }
                            }
                            if (message.transferAgent != null && message.hasOwnProperty("transferAgent")) {
                                if (properties.action === 1)
                                    return "action: multiple values";
                                properties.action = 1;
                                {
                                    var error = $root.google.cloud.ces.v1.TriggerAction.TransferAgent.verify(message.transferAgent);
                                    if (error)
                                        return "transferAgent." + error;
                                }
                            }
                            if (message.generativeAnswer != null && message.hasOwnProperty("generativeAnswer")) {
                                if (properties.action === 1)
                                    return "action: multiple values";
                                properties.action = 1;
                                {
                                    var error = $root.google.cloud.ces.v1.TriggerAction.GenerativeAnswer.verify(message.generativeAnswer);
                                    if (error)
                                        return "generativeAnswer." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a TriggerAction message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.TriggerAction} TriggerAction
                         */
                        TriggerAction.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.TriggerAction)
                                return object;
                            var message = new $root.google.cloud.ces.v1.TriggerAction();
                            if (object.respondImmediately != null) {
                                if (typeof object.respondImmediately !== "object")
                                    throw TypeError(".google.cloud.ces.v1.TriggerAction.respondImmediately: object expected");
                                message.respondImmediately = $root.google.cloud.ces.v1.TriggerAction.RespondImmediately.fromObject(object.respondImmediately);
                            }
                            if (object.transferAgent != null) {
                                if (typeof object.transferAgent !== "object")
                                    throw TypeError(".google.cloud.ces.v1.TriggerAction.transferAgent: object expected");
                                message.transferAgent = $root.google.cloud.ces.v1.TriggerAction.TransferAgent.fromObject(object.transferAgent);
                            }
                            if (object.generativeAnswer != null) {
                                if (typeof object.generativeAnswer !== "object")
                                    throw TypeError(".google.cloud.ces.v1.TriggerAction.generativeAnswer: object expected");
                                message.generativeAnswer = $root.google.cloud.ces.v1.TriggerAction.GenerativeAnswer.fromObject(object.generativeAnswer);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a TriggerAction message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @static
                         * @param {google.cloud.ces.v1.TriggerAction} message TriggerAction
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TriggerAction.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.respondImmediately != null && message.hasOwnProperty("respondImmediately")) {
                                object.respondImmediately = $root.google.cloud.ces.v1.TriggerAction.RespondImmediately.toObject(message.respondImmediately, options);
                                if (options.oneofs)
                                    object.action = "respondImmediately";
                            }
                            if (message.transferAgent != null && message.hasOwnProperty("transferAgent")) {
                                object.transferAgent = $root.google.cloud.ces.v1.TriggerAction.TransferAgent.toObject(message.transferAgent, options);
                                if (options.oneofs)
                                    object.action = "transferAgent";
                            }
                            if (message.generativeAnswer != null && message.hasOwnProperty("generativeAnswer")) {
                                object.generativeAnswer = $root.google.cloud.ces.v1.TriggerAction.GenerativeAnswer.toObject(message.generativeAnswer, options);
                                if (options.oneofs)
                                    object.action = "generativeAnswer";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this TriggerAction to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TriggerAction.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for TriggerAction
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.TriggerAction
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        TriggerAction.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.TriggerAction";
                        };
    
                        TriggerAction.Response = (function() {
    
                            /**
                             * Properties of a Response.
                             * @memberof google.cloud.ces.v1.TriggerAction
                             * @interface IResponse
                             * @property {string|null} [text] Response text
                             * @property {boolean|null} [disabled] Response disabled
                             */
    
                            /**
                             * Constructs a new Response.
                             * @memberof google.cloud.ces.v1.TriggerAction
                             * @classdesc Represents a Response.
                             * @implements IResponse
                             * @constructor
                             * @param {google.cloud.ces.v1.TriggerAction.IResponse=} [properties] Properties to set
                             */
                            function Response(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * Response text.
                             * @member {string} text
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @instance
                             */
                            Response.prototype.text = "";
    
                            /**
                             * Response disabled.
                             * @member {boolean} disabled
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @instance
                             */
                            Response.prototype.disabled = false;
    
                            /**
                             * Creates a new Response instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.IResponse=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.TriggerAction.Response} Response instance
                             */
                            Response.create = function create(properties) {
                                return new Response(properties);
                            };
    
                            /**
                             * Encodes the specified Response message. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.Response.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.IResponse} message Response message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Response.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
                                if (message.disabled != null && Object.hasOwnProperty.call(message, "disabled"))
                                    writer.uint32(/* id 2, wireType 0 =*/16).bool(message.disabled);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified Response message, length delimited. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.Response.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.IResponse} message Response message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Response.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a Response message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.TriggerAction.Response} Response
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Response.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.TriggerAction.Response();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.text = reader.string();
                                            break;
                                        }
                                    case 2: {
                                            message.disabled = reader.bool();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a Response message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.TriggerAction.Response} Response
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Response.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a Response message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            Response.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.text != null && message.hasOwnProperty("text"))
                                    if (!$util.isString(message.text))
                                        return "text: string expected";
                                if (message.disabled != null && message.hasOwnProperty("disabled"))
                                    if (typeof message.disabled !== "boolean")
                                        return "disabled: boolean expected";
                                return null;
                            };
    
                            /**
                             * Creates a Response message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.TriggerAction.Response} Response
                             */
                            Response.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.TriggerAction.Response)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.TriggerAction.Response();
                                if (object.text != null)
                                    message.text = String(object.text);
                                if (object.disabled != null)
                                    message.disabled = Boolean(object.disabled);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a Response message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.Response} message Response
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            Response.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.text = "";
                                    object.disabled = false;
                                }
                                if (message.text != null && message.hasOwnProperty("text"))
                                    object.text = message.text;
                                if (message.disabled != null && message.hasOwnProperty("disabled"))
                                    object.disabled = message.disabled;
                                return object;
                            };
    
                            /**
                             * Converts this Response to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            Response.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for Response
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.TriggerAction.Response
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            Response.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.TriggerAction.Response";
                            };
    
                            return Response;
                        })();
    
                        TriggerAction.RespondImmediately = (function() {
    
                            /**
                             * Properties of a RespondImmediately.
                             * @memberof google.cloud.ces.v1.TriggerAction
                             * @interface IRespondImmediately
                             * @property {Array.<google.cloud.ces.v1.TriggerAction.IResponse>|null} [responses] RespondImmediately responses
                             */
    
                            /**
                             * Constructs a new RespondImmediately.
                             * @memberof google.cloud.ces.v1.TriggerAction
                             * @classdesc Represents a RespondImmediately.
                             * @implements IRespondImmediately
                             * @constructor
                             * @param {google.cloud.ces.v1.TriggerAction.IRespondImmediately=} [properties] Properties to set
                             */
                            function RespondImmediately(properties) {
                                this.responses = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * RespondImmediately responses.
                             * @member {Array.<google.cloud.ces.v1.TriggerAction.IResponse>} responses
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @instance
                             */
                            RespondImmediately.prototype.responses = $util.emptyArray;
    
                            /**
                             * Creates a new RespondImmediately instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.IRespondImmediately=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.TriggerAction.RespondImmediately} RespondImmediately instance
                             */
                            RespondImmediately.create = function create(properties) {
                                return new RespondImmediately(properties);
                            };
    
                            /**
                             * Encodes the specified RespondImmediately message. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.RespondImmediately.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.IRespondImmediately} message RespondImmediately message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            RespondImmediately.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.responses != null && message.responses.length)
                                    for (var i = 0; i < message.responses.length; ++i)
                                        $root.google.cloud.ces.v1.TriggerAction.Response.encode(message.responses[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified RespondImmediately message, length delimited. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.RespondImmediately.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.IRespondImmediately} message RespondImmediately message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            RespondImmediately.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a RespondImmediately message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.TriggerAction.RespondImmediately} RespondImmediately
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            RespondImmediately.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.TriggerAction.RespondImmediately();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            if (!(message.responses && message.responses.length))
                                                message.responses = [];
                                            message.responses.push($root.google.cloud.ces.v1.TriggerAction.Response.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a RespondImmediately message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.TriggerAction.RespondImmediately} RespondImmediately
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            RespondImmediately.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a RespondImmediately message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            RespondImmediately.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.responses != null && message.hasOwnProperty("responses")) {
                                    if (!Array.isArray(message.responses))
                                        return "responses: array expected";
                                    for (var i = 0; i < message.responses.length; ++i) {
                                        var error = $root.google.cloud.ces.v1.TriggerAction.Response.verify(message.responses[i]);
                                        if (error)
                                            return "responses." + error;
                                    }
                                }
                                return null;
                            };
    
                            /**
                             * Creates a RespondImmediately message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.TriggerAction.RespondImmediately} RespondImmediately
                             */
                            RespondImmediately.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.TriggerAction.RespondImmediately)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.TriggerAction.RespondImmediately();
                                if (object.responses) {
                                    if (!Array.isArray(object.responses))
                                        throw TypeError(".google.cloud.ces.v1.TriggerAction.RespondImmediately.responses: array expected");
                                    message.responses = [];
                                    for (var i = 0; i < object.responses.length; ++i) {
                                        if (typeof object.responses[i] !== "object")
                                            throw TypeError(".google.cloud.ces.v1.TriggerAction.RespondImmediately.responses: object expected");
                                        message.responses[i] = $root.google.cloud.ces.v1.TriggerAction.Response.fromObject(object.responses[i]);
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a RespondImmediately message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.RespondImmediately} message RespondImmediately
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            RespondImmediately.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.responses = [];
                                if (message.responses && message.responses.length) {
                                    object.responses = [];
                                    for (var j = 0; j < message.responses.length; ++j)
                                        object.responses[j] = $root.google.cloud.ces.v1.TriggerAction.Response.toObject(message.responses[j], options);
                                }
                                return object;
                            };
    
                            /**
                             * Converts this RespondImmediately to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            RespondImmediately.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for RespondImmediately
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.TriggerAction.RespondImmediately
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            RespondImmediately.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.TriggerAction.RespondImmediately";
                            };
    
                            return RespondImmediately;
                        })();
    
                        TriggerAction.GenerativeAnswer = (function() {
    
                            /**
                             * Properties of a GenerativeAnswer.
                             * @memberof google.cloud.ces.v1.TriggerAction
                             * @interface IGenerativeAnswer
                             * @property {string|null} [prompt] GenerativeAnswer prompt
                             */
    
                            /**
                             * Constructs a new GenerativeAnswer.
                             * @memberof google.cloud.ces.v1.TriggerAction
                             * @classdesc Represents a GenerativeAnswer.
                             * @implements IGenerativeAnswer
                             * @constructor
                             * @param {google.cloud.ces.v1.TriggerAction.IGenerativeAnswer=} [properties] Properties to set
                             */
                            function GenerativeAnswer(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * GenerativeAnswer prompt.
                             * @member {string} prompt
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @instance
                             */
                            GenerativeAnswer.prototype.prompt = "";
    
                            /**
                             * Creates a new GenerativeAnswer instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.IGenerativeAnswer=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.TriggerAction.GenerativeAnswer} GenerativeAnswer instance
                             */
                            GenerativeAnswer.create = function create(properties) {
                                return new GenerativeAnswer(properties);
                            };
    
                            /**
                             * Encodes the specified GenerativeAnswer message. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.GenerativeAnswer.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.IGenerativeAnswer} message GenerativeAnswer message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            GenerativeAnswer.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.prompt != null && Object.hasOwnProperty.call(message, "prompt"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.prompt);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified GenerativeAnswer message, length delimited. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.GenerativeAnswer.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.IGenerativeAnswer} message GenerativeAnswer message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            GenerativeAnswer.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a GenerativeAnswer message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.TriggerAction.GenerativeAnswer} GenerativeAnswer
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            GenerativeAnswer.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.TriggerAction.GenerativeAnswer();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.prompt = reader.string();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a GenerativeAnswer message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.TriggerAction.GenerativeAnswer} GenerativeAnswer
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            GenerativeAnswer.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a GenerativeAnswer message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            GenerativeAnswer.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.prompt != null && message.hasOwnProperty("prompt"))
                                    if (!$util.isString(message.prompt))
                                        return "prompt: string expected";
                                return null;
                            };
    
                            /**
                             * Creates a GenerativeAnswer message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.TriggerAction.GenerativeAnswer} GenerativeAnswer
                             */
                            GenerativeAnswer.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.TriggerAction.GenerativeAnswer)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.TriggerAction.GenerativeAnswer();
                                if (object.prompt != null)
                                    message.prompt = String(object.prompt);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a GenerativeAnswer message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.GenerativeAnswer} message GenerativeAnswer
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            GenerativeAnswer.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults)
                                    object.prompt = "";
                                if (message.prompt != null && message.hasOwnProperty("prompt"))
                                    object.prompt = message.prompt;
                                return object;
                            };
    
                            /**
                             * Converts this GenerativeAnswer to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            GenerativeAnswer.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for GenerativeAnswer
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.TriggerAction.GenerativeAnswer
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            GenerativeAnswer.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.TriggerAction.GenerativeAnswer";
                            };
    
                            return GenerativeAnswer;
                        })();
    
                        TriggerAction.TransferAgent = (function() {
    
                            /**
                             * Properties of a TransferAgent.
                             * @memberof google.cloud.ces.v1.TriggerAction
                             * @interface ITransferAgent
                             * @property {string|null} [agent] TransferAgent agent
                             */
    
                            /**
                             * Constructs a new TransferAgent.
                             * @memberof google.cloud.ces.v1.TriggerAction
                             * @classdesc Represents a TransferAgent.
                             * @implements ITransferAgent
                             * @constructor
                             * @param {google.cloud.ces.v1.TriggerAction.ITransferAgent=} [properties] Properties to set
                             */
                            function TransferAgent(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * TransferAgent agent.
                             * @member {string} agent
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @instance
                             */
                            TransferAgent.prototype.agent = "";
    
                            /**
                             * Creates a new TransferAgent instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.ITransferAgent=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.TriggerAction.TransferAgent} TransferAgent instance
                             */
                            TransferAgent.create = function create(properties) {
                                return new TransferAgent(properties);
                            };
    
                            /**
                             * Encodes the specified TransferAgent message. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.TransferAgent.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.ITransferAgent} message TransferAgent message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TransferAgent.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.agent != null && Object.hasOwnProperty.call(message, "agent"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.agent);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified TransferAgent message, length delimited. Does not implicitly {@link google.cloud.ces.v1.TriggerAction.TransferAgent.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.ITransferAgent} message TransferAgent message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TransferAgent.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a TransferAgent message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.TriggerAction.TransferAgent} TransferAgent
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TransferAgent.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.TriggerAction.TransferAgent();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.agent = reader.string();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a TransferAgent message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.TriggerAction.TransferAgent} TransferAgent
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TransferAgent.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a TransferAgent message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            TransferAgent.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.agent != null && message.hasOwnProperty("agent"))
                                    if (!$util.isString(message.agent))
                                        return "agent: string expected";
                                return null;
                            };
    
                            /**
                             * Creates a TransferAgent message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.TriggerAction.TransferAgent} TransferAgent
                             */
                            TransferAgent.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.TriggerAction.TransferAgent)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.TriggerAction.TransferAgent();
                                if (object.agent != null)
                                    message.agent = String(object.agent);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a TransferAgent message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @static
                             * @param {google.cloud.ces.v1.TriggerAction.TransferAgent} message TransferAgent
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            TransferAgent.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults)
                                    object.agent = "";
                                if (message.agent != null && message.hasOwnProperty("agent"))
                                    object.agent = message.agent;
                                return object;
                            };
    
                            /**
                             * Converts this TransferAgent to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            TransferAgent.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for TransferAgent
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.TriggerAction.TransferAgent
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            TransferAgent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.TriggerAction.TransferAgent";
                            };
    
                            return TransferAgent;
                        })();
    
                        return TriggerAction;
                    })();
    
                    v1.TlsConfig = (function() {
    
                        /**
                         * Properties of a TlsConfig.
                         * @memberof google.cloud.ces.v1
                         * @interface ITlsConfig
                         * @property {Array.<google.cloud.ces.v1.TlsConfig.ICaCert>|null} [caCerts] TlsConfig caCerts
                         */
    
                        /**
                         * Constructs a new TlsConfig.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a TlsConfig.
                         * @implements ITlsConfig
                         * @constructor
                         * @param {google.cloud.ces.v1.ITlsConfig=} [properties] Properties to set
                         */
                        function TlsConfig(properties) {
                            this.caCerts = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * TlsConfig caCerts.
                         * @member {Array.<google.cloud.ces.v1.TlsConfig.ICaCert>} caCerts
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @instance
                         */
                        TlsConfig.prototype.caCerts = $util.emptyArray;
    
                        /**
                         * Creates a new TlsConfig instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @static
                         * @param {google.cloud.ces.v1.ITlsConfig=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.TlsConfig} TlsConfig instance
                         */
                        TlsConfig.create = function create(properties) {
                            return new TlsConfig(properties);
                        };
    
                        /**
                         * Encodes the specified TlsConfig message. Does not implicitly {@link google.cloud.ces.v1.TlsConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @static
                         * @param {google.cloud.ces.v1.ITlsConfig} message TlsConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TlsConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.caCerts != null && message.caCerts.length)
                                for (var i = 0; i < message.caCerts.length; ++i)
                                    $root.google.cloud.ces.v1.TlsConfig.CaCert.encode(message.caCerts[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified TlsConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1.TlsConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @static
                         * @param {google.cloud.ces.v1.ITlsConfig} message TlsConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TlsConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a TlsConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.TlsConfig} TlsConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TlsConfig.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.TlsConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.caCerts && message.caCerts.length))
                                            message.caCerts = [];
                                        message.caCerts.push($root.google.cloud.ces.v1.TlsConfig.CaCert.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a TlsConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.TlsConfig} TlsConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TlsConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a TlsConfig message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TlsConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.caCerts != null && message.hasOwnProperty("caCerts")) {
                                if (!Array.isArray(message.caCerts))
                                    return "caCerts: array expected";
                                for (var i = 0; i < message.caCerts.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.TlsConfig.CaCert.verify(message.caCerts[i]);
                                    if (error)
                                        return "caCerts." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a TlsConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.TlsConfig} TlsConfig
                         */
                        TlsConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.TlsConfig)
                                return object;
                            var message = new $root.google.cloud.ces.v1.TlsConfig();
                            if (object.caCerts) {
                                if (!Array.isArray(object.caCerts))
                                    throw TypeError(".google.cloud.ces.v1.TlsConfig.caCerts: array expected");
                                message.caCerts = [];
                                for (var i = 0; i < object.caCerts.length; ++i) {
                                    if (typeof object.caCerts[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.TlsConfig.caCerts: object expected");
                                    message.caCerts[i] = $root.google.cloud.ces.v1.TlsConfig.CaCert.fromObject(object.caCerts[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a TlsConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @static
                         * @param {google.cloud.ces.v1.TlsConfig} message TlsConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TlsConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.caCerts = [];
                            if (message.caCerts && message.caCerts.length) {
                                object.caCerts = [];
                                for (var j = 0; j < message.caCerts.length; ++j)
                                    object.caCerts[j] = $root.google.cloud.ces.v1.TlsConfig.CaCert.toObject(message.caCerts[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this TlsConfig to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TlsConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for TlsConfig
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.TlsConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        TlsConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.TlsConfig";
                        };
    
                        TlsConfig.CaCert = (function() {
    
                            /**
                             * Properties of a CaCert.
                             * @memberof google.cloud.ces.v1.TlsConfig
                             * @interface ICaCert
                             * @property {string|null} [displayName] CaCert displayName
                             * @property {Uint8Array|null} [cert] CaCert cert
                             */
    
                            /**
                             * Constructs a new CaCert.
                             * @memberof google.cloud.ces.v1.TlsConfig
                             * @classdesc Represents a CaCert.
                             * @implements ICaCert
                             * @constructor
                             * @param {google.cloud.ces.v1.TlsConfig.ICaCert=} [properties] Properties to set
                             */
                            function CaCert(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * CaCert displayName.
                             * @member {string} displayName
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @instance
                             */
                            CaCert.prototype.displayName = "";
    
                            /**
                             * CaCert cert.
                             * @member {Uint8Array} cert
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @instance
                             */
                            CaCert.prototype.cert = $util.newBuffer([]);
    
                            /**
                             * Creates a new CaCert instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @static
                             * @param {google.cloud.ces.v1.TlsConfig.ICaCert=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.TlsConfig.CaCert} CaCert instance
                             */
                            CaCert.create = function create(properties) {
                                return new CaCert(properties);
                            };
    
                            /**
                             * Encodes the specified CaCert message. Does not implicitly {@link google.cloud.ces.v1.TlsConfig.CaCert.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @static
                             * @param {google.cloud.ces.v1.TlsConfig.ICaCert} message CaCert message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            CaCert.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayName);
                                if (message.cert != null && Object.hasOwnProperty.call(message, "cert"))
                                    writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.cert);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified CaCert message, length delimited. Does not implicitly {@link google.cloud.ces.v1.TlsConfig.CaCert.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @static
                             * @param {google.cloud.ces.v1.TlsConfig.ICaCert} message CaCert message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            CaCert.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a CaCert message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.TlsConfig.CaCert} CaCert
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            CaCert.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.TlsConfig.CaCert();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.displayName = reader.string();
                                            break;
                                        }
                                    case 2: {
                                            message.cert = reader.bytes();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a CaCert message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.TlsConfig.CaCert} CaCert
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            CaCert.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a CaCert message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            CaCert.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.displayName != null && message.hasOwnProperty("displayName"))
                                    if (!$util.isString(message.displayName))
                                        return "displayName: string expected";
                                if (message.cert != null && message.hasOwnProperty("cert"))
                                    if (!(message.cert && typeof message.cert.length === "number" || $util.isString(message.cert)))
                                        return "cert: buffer expected";
                                return null;
                            };
    
                            /**
                             * Creates a CaCert message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.TlsConfig.CaCert} CaCert
                             */
                            CaCert.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.TlsConfig.CaCert)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.TlsConfig.CaCert();
                                if (object.displayName != null)
                                    message.displayName = String(object.displayName);
                                if (object.cert != null)
                                    if (typeof object.cert === "string")
                                        $util.base64.decode(object.cert, message.cert = $util.newBuffer($util.base64.length(object.cert)), 0);
                                    else if (object.cert.length >= 0)
                                        message.cert = object.cert;
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a CaCert message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @static
                             * @param {google.cloud.ces.v1.TlsConfig.CaCert} message CaCert
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            CaCert.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.displayName = "";
                                    if (options.bytes === String)
                                        object.cert = "";
                                    else {
                                        object.cert = [];
                                        if (options.bytes !== Array)
                                            object.cert = $util.newBuffer(object.cert);
                                    }
                                }
                                if (message.displayName != null && message.hasOwnProperty("displayName"))
                                    object.displayName = message.displayName;
                                if (message.cert != null && message.hasOwnProperty("cert"))
                                    object.cert = options.bytes === String ? $util.base64.encode(message.cert, 0, message.cert.length) : options.bytes === Array ? Array.prototype.slice.call(message.cert) : message.cert;
                                return object;
                            };
    
                            /**
                             * Converts this CaCert to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            CaCert.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for CaCert
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.TlsConfig.CaCert
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            CaCert.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.TlsConfig.CaCert";
                            };
    
                            return CaCert;
                        })();
    
                        return TlsConfig;
                    })();
    
                    v1.ServiceDirectoryConfig = (function() {
    
                        /**
                         * Properties of a ServiceDirectoryConfig.
                         * @memberof google.cloud.ces.v1
                         * @interface IServiceDirectoryConfig
                         * @property {string|null} [service] ServiceDirectoryConfig service
                         */
    
                        /**
                         * Constructs a new ServiceDirectoryConfig.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ServiceDirectoryConfig.
                         * @implements IServiceDirectoryConfig
                         * @constructor
                         * @param {google.cloud.ces.v1.IServiceDirectoryConfig=} [properties] Properties to set
                         */
                        function ServiceDirectoryConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ServiceDirectoryConfig service.
                         * @member {string} service
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @instance
                         */
                        ServiceDirectoryConfig.prototype.service = "";
    
                        /**
                         * Creates a new ServiceDirectoryConfig instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @static
                         * @param {google.cloud.ces.v1.IServiceDirectoryConfig=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ServiceDirectoryConfig} ServiceDirectoryConfig instance
                         */
                        ServiceDirectoryConfig.create = function create(properties) {
                            return new ServiceDirectoryConfig(properties);
                        };
    
                        /**
                         * Encodes the specified ServiceDirectoryConfig message. Does not implicitly {@link google.cloud.ces.v1.ServiceDirectoryConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @static
                         * @param {google.cloud.ces.v1.IServiceDirectoryConfig} message ServiceDirectoryConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ServiceDirectoryConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.service != null && Object.hasOwnProperty.call(message, "service"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.service);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ServiceDirectoryConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ServiceDirectoryConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @static
                         * @param {google.cloud.ces.v1.IServiceDirectoryConfig} message ServiceDirectoryConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ServiceDirectoryConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ServiceDirectoryConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ServiceDirectoryConfig} ServiceDirectoryConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ServiceDirectoryConfig.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ServiceDirectoryConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.service = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ServiceDirectoryConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ServiceDirectoryConfig} ServiceDirectoryConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ServiceDirectoryConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ServiceDirectoryConfig message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ServiceDirectoryConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.service != null && message.hasOwnProperty("service"))
                                if (!$util.isString(message.service))
                                    return "service: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ServiceDirectoryConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ServiceDirectoryConfig} ServiceDirectoryConfig
                         */
                        ServiceDirectoryConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ServiceDirectoryConfig)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ServiceDirectoryConfig();
                            if (object.service != null)
                                message.service = String(object.service);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ServiceDirectoryConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @static
                         * @param {google.cloud.ces.v1.ServiceDirectoryConfig} message ServiceDirectoryConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ServiceDirectoryConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.service = "";
                            if (message.service != null && message.hasOwnProperty("service"))
                                object.service = message.service;
                            return object;
                        };
    
                        /**
                         * Converts this ServiceDirectoryConfig to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ServiceDirectoryConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ServiceDirectoryConfig
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ServiceDirectoryConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ServiceDirectoryConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ServiceDirectoryConfig";
                        };
    
                        return ServiceDirectoryConfig;
                    })();
    
                    v1.ChannelProfile = (function() {
    
                        /**
                         * Properties of a ChannelProfile.
                         * @memberof google.cloud.ces.v1
                         * @interface IChannelProfile
                         * @property {string|null} [profileId] ChannelProfile profileId
                         * @property {google.cloud.ces.v1.ChannelProfile.ChannelType|null} [channelType] ChannelProfile channelType
                         * @property {google.cloud.ces.v1.ChannelProfile.IPersonaProperty|null} [personaProperty] ChannelProfile personaProperty
                         * @property {boolean|null} [disableDtmf] ChannelProfile disableDtmf
                         * @property {boolean|null} [disableBargeInControl] ChannelProfile disableBargeInControl
                         * @property {google.cloud.ces.v1.ChannelProfile.IWebWidgetConfig|null} [webWidgetConfig] ChannelProfile webWidgetConfig
                         * @property {string|null} [noiseSuppressionLevel] ChannelProfile noiseSuppressionLevel
                         */
    
                        /**
                         * Constructs a new ChannelProfile.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ChannelProfile.
                         * @implements IChannelProfile
                         * @constructor
                         * @param {google.cloud.ces.v1.IChannelProfile=} [properties] Properties to set
                         */
                        function ChannelProfile(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ChannelProfile profileId.
                         * @member {string} profileId
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @instance
                         */
                        ChannelProfile.prototype.profileId = "";
    
                        /**
                         * ChannelProfile channelType.
                         * @member {google.cloud.ces.v1.ChannelProfile.ChannelType} channelType
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @instance
                         */
                        ChannelProfile.prototype.channelType = 0;
    
                        /**
                         * ChannelProfile personaProperty.
                         * @member {google.cloud.ces.v1.ChannelProfile.IPersonaProperty|null|undefined} personaProperty
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @instance
                         */
                        ChannelProfile.prototype.personaProperty = null;
    
                        /**
                         * ChannelProfile disableDtmf.
                         * @member {boolean} disableDtmf
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @instance
                         */
                        ChannelProfile.prototype.disableDtmf = false;
    
                        /**
                         * ChannelProfile disableBargeInControl.
                         * @member {boolean} disableBargeInControl
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @instance
                         */
                        ChannelProfile.prototype.disableBargeInControl = false;
    
                        /**
                         * ChannelProfile webWidgetConfig.
                         * @member {google.cloud.ces.v1.ChannelProfile.IWebWidgetConfig|null|undefined} webWidgetConfig
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @instance
                         */
                        ChannelProfile.prototype.webWidgetConfig = null;
    
                        /**
                         * ChannelProfile noiseSuppressionLevel.
                         * @member {string} noiseSuppressionLevel
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @instance
                         */
                        ChannelProfile.prototype.noiseSuppressionLevel = "";
    
                        /**
                         * Creates a new ChannelProfile instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @static
                         * @param {google.cloud.ces.v1.IChannelProfile=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ChannelProfile} ChannelProfile instance
                         */
                        ChannelProfile.create = function create(properties) {
                            return new ChannelProfile(properties);
                        };
    
                        /**
                         * Encodes the specified ChannelProfile message. Does not implicitly {@link google.cloud.ces.v1.ChannelProfile.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @static
                         * @param {google.cloud.ces.v1.IChannelProfile} message ChannelProfile message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ChannelProfile.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.profileId != null && Object.hasOwnProperty.call(message, "profileId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.profileId);
                            if (message.personaProperty != null && Object.hasOwnProperty.call(message, "personaProperty"))
                                $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty.encode(message.personaProperty, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.channelType != null && Object.hasOwnProperty.call(message, "channelType"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.channelType);
                            if (message.disableDtmf != null && Object.hasOwnProperty.call(message, "disableDtmf"))
                                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.disableDtmf);
                            if (message.disableBargeInControl != null && Object.hasOwnProperty.call(message, "disableBargeInControl"))
                                writer.uint32(/* id 5, wireType 0 =*/40).bool(message.disableBargeInControl);
                            if (message.webWidgetConfig != null && Object.hasOwnProperty.call(message, "webWidgetConfig"))
                                $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.encode(message.webWidgetConfig, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.noiseSuppressionLevel != null && Object.hasOwnProperty.call(message, "noiseSuppressionLevel"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.noiseSuppressionLevel);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ChannelProfile message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ChannelProfile.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @static
                         * @param {google.cloud.ces.v1.IChannelProfile} message ChannelProfile message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ChannelProfile.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ChannelProfile message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ChannelProfile} ChannelProfile
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ChannelProfile.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ChannelProfile();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.profileId = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.channelType = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.personaProperty = $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        message.disableDtmf = reader.bool();
                                        break;
                                    }
                                case 5: {
                                        message.disableBargeInControl = reader.bool();
                                        break;
                                    }
                                case 7: {
                                        message.webWidgetConfig = $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.noiseSuppressionLevel = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ChannelProfile message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ChannelProfile} ChannelProfile
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ChannelProfile.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ChannelProfile message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ChannelProfile.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.profileId != null && message.hasOwnProperty("profileId"))
                                if (!$util.isString(message.profileId))
                                    return "profileId: string expected";
                            if (message.channelType != null && message.hasOwnProperty("channelType"))
                                switch (message.channelType) {
                                default:
                                    return "channelType: enum value expected";
                                case 0:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                case 7:
                                    break;
                                }
                            if (message.personaProperty != null && message.hasOwnProperty("personaProperty")) {
                                var error = $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty.verify(message.personaProperty);
                                if (error)
                                    return "personaProperty." + error;
                            }
                            if (message.disableDtmf != null && message.hasOwnProperty("disableDtmf"))
                                if (typeof message.disableDtmf !== "boolean")
                                    return "disableDtmf: boolean expected";
                            if (message.disableBargeInControl != null && message.hasOwnProperty("disableBargeInControl"))
                                if (typeof message.disableBargeInControl !== "boolean")
                                    return "disableBargeInControl: boolean expected";
                            if (message.webWidgetConfig != null && message.hasOwnProperty("webWidgetConfig")) {
                                var error = $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.verify(message.webWidgetConfig);
                                if (error)
                                    return "webWidgetConfig." + error;
                            }
                            if (message.noiseSuppressionLevel != null && message.hasOwnProperty("noiseSuppressionLevel"))
                                if (!$util.isString(message.noiseSuppressionLevel))
                                    return "noiseSuppressionLevel: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ChannelProfile message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ChannelProfile} ChannelProfile
                         */
                        ChannelProfile.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ChannelProfile)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ChannelProfile();
                            if (object.profileId != null)
                                message.profileId = String(object.profileId);
                            switch (object.channelType) {
                            default:
                                if (typeof object.channelType === "number") {
                                    message.channelType = object.channelType;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.channelType = 0;
                                break;
                            case "WEB_UI":
                            case 2:
                                message.channelType = 2;
                                break;
                            case "API":
                            case 3:
                                message.channelType = 3;
                                break;
                            case "TWILIO":
                            case 4:
                                message.channelType = 4;
                                break;
                            case "GOOGLE_TELEPHONY_PLATFORM":
                            case 5:
                                message.channelType = 5;
                                break;
                            case "CONTACT_CENTER_AS_A_SERVICE":
                            case 6:
                                message.channelType = 6;
                                break;
                            case "FIVE9":
                            case 7:
                                message.channelType = 7;
                                break;
                            }
                            if (object.personaProperty != null) {
                                if (typeof object.personaProperty !== "object")
                                    throw TypeError(".google.cloud.ces.v1.ChannelProfile.personaProperty: object expected");
                                message.personaProperty = $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty.fromObject(object.personaProperty);
                            }
                            if (object.disableDtmf != null)
                                message.disableDtmf = Boolean(object.disableDtmf);
                            if (object.disableBargeInControl != null)
                                message.disableBargeInControl = Boolean(object.disableBargeInControl);
                            if (object.webWidgetConfig != null) {
                                if (typeof object.webWidgetConfig !== "object")
                                    throw TypeError(".google.cloud.ces.v1.ChannelProfile.webWidgetConfig: object expected");
                                message.webWidgetConfig = $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.fromObject(object.webWidgetConfig);
                            }
                            if (object.noiseSuppressionLevel != null)
                                message.noiseSuppressionLevel = String(object.noiseSuppressionLevel);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ChannelProfile message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @static
                         * @param {google.cloud.ces.v1.ChannelProfile} message ChannelProfile
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ChannelProfile.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.profileId = "";
                                object.personaProperty = null;
                                object.channelType = options.enums === String ? "UNKNOWN" : 0;
                                object.disableDtmf = false;
                                object.disableBargeInControl = false;
                                object.webWidgetConfig = null;
                                object.noiseSuppressionLevel = "";
                            }
                            if (message.profileId != null && message.hasOwnProperty("profileId"))
                                object.profileId = message.profileId;
                            if (message.personaProperty != null && message.hasOwnProperty("personaProperty"))
                                object.personaProperty = $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty.toObject(message.personaProperty, options);
                            if (message.channelType != null && message.hasOwnProperty("channelType"))
                                object.channelType = options.enums === String ? $root.google.cloud.ces.v1.ChannelProfile.ChannelType[message.channelType] === undefined ? message.channelType : $root.google.cloud.ces.v1.ChannelProfile.ChannelType[message.channelType] : message.channelType;
                            if (message.disableDtmf != null && message.hasOwnProperty("disableDtmf"))
                                object.disableDtmf = message.disableDtmf;
                            if (message.disableBargeInControl != null && message.hasOwnProperty("disableBargeInControl"))
                                object.disableBargeInControl = message.disableBargeInControl;
                            if (message.webWidgetConfig != null && message.hasOwnProperty("webWidgetConfig"))
                                object.webWidgetConfig = $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.toObject(message.webWidgetConfig, options);
                            if (message.noiseSuppressionLevel != null && message.hasOwnProperty("noiseSuppressionLevel"))
                                object.noiseSuppressionLevel = message.noiseSuppressionLevel;
                            return object;
                        };
    
                        /**
                         * Converts this ChannelProfile to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ChannelProfile.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ChannelProfile
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ChannelProfile
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ChannelProfile.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ChannelProfile";
                        };
    
                        ChannelProfile.PersonaProperty = (function() {
    
                            /**
                             * Properties of a PersonaProperty.
                             * @memberof google.cloud.ces.v1.ChannelProfile
                             * @interface IPersonaProperty
                             * @property {google.cloud.ces.v1.ChannelProfile.PersonaProperty.Persona|null} [persona] PersonaProperty persona
                             */
    
                            /**
                             * Constructs a new PersonaProperty.
                             * @memberof google.cloud.ces.v1.ChannelProfile
                             * @classdesc Represents a PersonaProperty.
                             * @implements IPersonaProperty
                             * @constructor
                             * @param {google.cloud.ces.v1.ChannelProfile.IPersonaProperty=} [properties] Properties to set
                             */
                            function PersonaProperty(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * PersonaProperty persona.
                             * @member {google.cloud.ces.v1.ChannelProfile.PersonaProperty.Persona} persona
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @instance
                             */
                            PersonaProperty.prototype.persona = 0;
    
                            /**
                             * Creates a new PersonaProperty instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @static
                             * @param {google.cloud.ces.v1.ChannelProfile.IPersonaProperty=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.ChannelProfile.PersonaProperty} PersonaProperty instance
                             */
                            PersonaProperty.create = function create(properties) {
                                return new PersonaProperty(properties);
                            };
    
                            /**
                             * Encodes the specified PersonaProperty message. Does not implicitly {@link google.cloud.ces.v1.ChannelProfile.PersonaProperty.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @static
                             * @param {google.cloud.ces.v1.ChannelProfile.IPersonaProperty} message PersonaProperty message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            PersonaProperty.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.persona != null && Object.hasOwnProperty.call(message, "persona"))
                                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.persona);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified PersonaProperty message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ChannelProfile.PersonaProperty.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @static
                             * @param {google.cloud.ces.v1.ChannelProfile.IPersonaProperty} message PersonaProperty message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            PersonaProperty.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a PersonaProperty message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.ChannelProfile.PersonaProperty} PersonaProperty
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            PersonaProperty.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.persona = reader.int32();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a PersonaProperty message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.ChannelProfile.PersonaProperty} PersonaProperty
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            PersonaProperty.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a PersonaProperty message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            PersonaProperty.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.persona != null && message.hasOwnProperty("persona"))
                                    switch (message.persona) {
                                    default:
                                        return "persona: enum value expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                        break;
                                    }
                                return null;
                            };
    
                            /**
                             * Creates a PersonaProperty message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.ChannelProfile.PersonaProperty} PersonaProperty
                             */
                            PersonaProperty.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty();
                                switch (object.persona) {
                                default:
                                    if (typeof object.persona === "number") {
                                        message.persona = object.persona;
                                        break;
                                    }
                                    break;
                                case "UNKNOWN":
                                case 0:
                                    message.persona = 0;
                                    break;
                                case "CONCISE":
                                case 1:
                                    message.persona = 1;
                                    break;
                                case "CHATTY":
                                case 2:
                                    message.persona = 2;
                                    break;
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a PersonaProperty message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @static
                             * @param {google.cloud.ces.v1.ChannelProfile.PersonaProperty} message PersonaProperty
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            PersonaProperty.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults)
                                    object.persona = options.enums === String ? "UNKNOWN" : 0;
                                if (message.persona != null && message.hasOwnProperty("persona"))
                                    object.persona = options.enums === String ? $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty.Persona[message.persona] === undefined ? message.persona : $root.google.cloud.ces.v1.ChannelProfile.PersonaProperty.Persona[message.persona] : message.persona;
                                return object;
                            };
    
                            /**
                             * Converts this PersonaProperty to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            PersonaProperty.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for PersonaProperty
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.ChannelProfile.PersonaProperty
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            PersonaProperty.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.ChannelProfile.PersonaProperty";
                            };
    
                            /**
                             * Persona enum.
                             * @name google.cloud.ces.v1.ChannelProfile.PersonaProperty.Persona
                             * @enum {number}
                             * @property {number} UNKNOWN=0 UNKNOWN value
                             * @property {number} CONCISE=1 CONCISE value
                             * @property {number} CHATTY=2 CHATTY value
                             */
                            PersonaProperty.Persona = (function() {
                                var valuesById = {}, values = Object.create(valuesById);
                                values[valuesById[0] = "UNKNOWN"] = 0;
                                values[valuesById[1] = "CONCISE"] = 1;
                                values[valuesById[2] = "CHATTY"] = 2;
                                return values;
                            })();
    
                            return PersonaProperty;
                        })();
    
                        ChannelProfile.WebWidgetConfig = (function() {
    
                            /**
                             * Properties of a WebWidgetConfig.
                             * @memberof google.cloud.ces.v1.ChannelProfile
                             * @interface IWebWidgetConfig
                             * @property {google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Modality|null} [modality] WebWidgetConfig modality
                             * @property {google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Theme|null} [theme] WebWidgetConfig theme
                             * @property {string|null} [webWidgetTitle] WebWidgetConfig webWidgetTitle
                             */
    
                            /**
                             * Constructs a new WebWidgetConfig.
                             * @memberof google.cloud.ces.v1.ChannelProfile
                             * @classdesc Represents a WebWidgetConfig.
                             * @implements IWebWidgetConfig
                             * @constructor
                             * @param {google.cloud.ces.v1.ChannelProfile.IWebWidgetConfig=} [properties] Properties to set
                             */
                            function WebWidgetConfig(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * WebWidgetConfig modality.
                             * @member {google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Modality} modality
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @instance
                             */
                            WebWidgetConfig.prototype.modality = 0;
    
                            /**
                             * WebWidgetConfig theme.
                             * @member {google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Theme} theme
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @instance
                             */
                            WebWidgetConfig.prototype.theme = 0;
    
                            /**
                             * WebWidgetConfig webWidgetTitle.
                             * @member {string} webWidgetTitle
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @instance
                             */
                            WebWidgetConfig.prototype.webWidgetTitle = "";
    
                            /**
                             * Creates a new WebWidgetConfig instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @static
                             * @param {google.cloud.ces.v1.ChannelProfile.IWebWidgetConfig=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.ChannelProfile.WebWidgetConfig} WebWidgetConfig instance
                             */
                            WebWidgetConfig.create = function create(properties) {
                                return new WebWidgetConfig(properties);
                            };
    
                            /**
                             * Encodes the specified WebWidgetConfig message. Does not implicitly {@link google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @static
                             * @param {google.cloud.ces.v1.ChannelProfile.IWebWidgetConfig} message WebWidgetConfig message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            WebWidgetConfig.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.modality != null && Object.hasOwnProperty.call(message, "modality"))
                                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.modality);
                                if (message.theme != null && Object.hasOwnProperty.call(message, "theme"))
                                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.theme);
                                if (message.webWidgetTitle != null && Object.hasOwnProperty.call(message, "webWidgetTitle"))
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.webWidgetTitle);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified WebWidgetConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @static
                             * @param {google.cloud.ces.v1.ChannelProfile.IWebWidgetConfig} message WebWidgetConfig message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            WebWidgetConfig.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a WebWidgetConfig message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.ChannelProfile.WebWidgetConfig} WebWidgetConfig
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            WebWidgetConfig.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.modality = reader.int32();
                                            break;
                                        }
                                    case 2: {
                                            message.theme = reader.int32();
                                            break;
                                        }
                                    case 3: {
                                            message.webWidgetTitle = reader.string();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a WebWidgetConfig message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.ChannelProfile.WebWidgetConfig} WebWidgetConfig
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            WebWidgetConfig.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a WebWidgetConfig message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            WebWidgetConfig.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.modality != null && message.hasOwnProperty("modality"))
                                    switch (message.modality) {
                                    default:
                                        return "modality: enum value expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                        break;
                                    }
                                if (message.theme != null && message.hasOwnProperty("theme"))
                                    switch (message.theme) {
                                    default:
                                        return "theme: enum value expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                        break;
                                    }
                                if (message.webWidgetTitle != null && message.hasOwnProperty("webWidgetTitle"))
                                    if (!$util.isString(message.webWidgetTitle))
                                        return "webWidgetTitle: string expected";
                                return null;
                            };
    
                            /**
                             * Creates a WebWidgetConfig message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.ChannelProfile.WebWidgetConfig} WebWidgetConfig
                             */
                            WebWidgetConfig.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig();
                                switch (object.modality) {
                                default:
                                    if (typeof object.modality === "number") {
                                        message.modality = object.modality;
                                        break;
                                    }
                                    break;
                                case "MODALITY_UNSPECIFIED":
                                case 0:
                                    message.modality = 0;
                                    break;
                                case "CHAT_AND_VOICE":
                                case 1:
                                    message.modality = 1;
                                    break;
                                case "VOICE_ONLY":
                                case 2:
                                    message.modality = 2;
                                    break;
                                case "CHAT_ONLY":
                                case 3:
                                    message.modality = 3;
                                    break;
                                }
                                switch (object.theme) {
                                default:
                                    if (typeof object.theme === "number") {
                                        message.theme = object.theme;
                                        break;
                                    }
                                    break;
                                case "THEME_UNSPECIFIED":
                                case 0:
                                    message.theme = 0;
                                    break;
                                case "LIGHT":
                                case 1:
                                    message.theme = 1;
                                    break;
                                case "DARK":
                                case 2:
                                    message.theme = 2;
                                    break;
                                }
                                if (object.webWidgetTitle != null)
                                    message.webWidgetTitle = String(object.webWidgetTitle);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a WebWidgetConfig message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @static
                             * @param {google.cloud.ces.v1.ChannelProfile.WebWidgetConfig} message WebWidgetConfig
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            WebWidgetConfig.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.modality = options.enums === String ? "MODALITY_UNSPECIFIED" : 0;
                                    object.theme = options.enums === String ? "THEME_UNSPECIFIED" : 0;
                                    object.webWidgetTitle = "";
                                }
                                if (message.modality != null && message.hasOwnProperty("modality"))
                                    object.modality = options.enums === String ? $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Modality[message.modality] === undefined ? message.modality : $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Modality[message.modality] : message.modality;
                                if (message.theme != null && message.hasOwnProperty("theme"))
                                    object.theme = options.enums === String ? $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Theme[message.theme] === undefined ? message.theme : $root.google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Theme[message.theme] : message.theme;
                                if (message.webWidgetTitle != null && message.hasOwnProperty("webWidgetTitle"))
                                    object.webWidgetTitle = message.webWidgetTitle;
                                return object;
                            };
    
                            /**
                             * Converts this WebWidgetConfig to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            WebWidgetConfig.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for WebWidgetConfig
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.ChannelProfile.WebWidgetConfig
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            WebWidgetConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.ChannelProfile.WebWidgetConfig";
                            };
    
                            /**
                             * Modality enum.
                             * @name google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Modality
                             * @enum {number}
                             * @property {number} MODALITY_UNSPECIFIED=0 MODALITY_UNSPECIFIED value
                             * @property {number} CHAT_AND_VOICE=1 CHAT_AND_VOICE value
                             * @property {number} VOICE_ONLY=2 VOICE_ONLY value
                             * @property {number} CHAT_ONLY=3 CHAT_ONLY value
                             */
                            WebWidgetConfig.Modality = (function() {
                                var valuesById = {}, values = Object.create(valuesById);
                                values[valuesById[0] = "MODALITY_UNSPECIFIED"] = 0;
                                values[valuesById[1] = "CHAT_AND_VOICE"] = 1;
                                values[valuesById[2] = "VOICE_ONLY"] = 2;
                                values[valuesById[3] = "CHAT_ONLY"] = 3;
                                return values;
                            })();
    
                            /**
                             * Theme enum.
                             * @name google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.Theme
                             * @enum {number}
                             * @property {number} THEME_UNSPECIFIED=0 THEME_UNSPECIFIED value
                             * @property {number} LIGHT=1 LIGHT value
                             * @property {number} DARK=2 DARK value
                             */
                            WebWidgetConfig.Theme = (function() {
                                var valuesById = {}, values = Object.create(valuesById);
                                values[valuesById[0] = "THEME_UNSPECIFIED"] = 0;
                                values[valuesById[1] = "LIGHT"] = 1;
                                values[valuesById[2] = "DARK"] = 2;
                                return values;
                            })();
    
                            return WebWidgetConfig;
                        })();
    
                        /**
                         * ChannelType enum.
                         * @name google.cloud.ces.v1.ChannelProfile.ChannelType
                         * @enum {number}
                         * @property {number} UNKNOWN=0 UNKNOWN value
                         * @property {number} WEB_UI=2 WEB_UI value
                         * @property {number} API=3 API value
                         * @property {number} TWILIO=4 TWILIO value
                         * @property {number} GOOGLE_TELEPHONY_PLATFORM=5 GOOGLE_TELEPHONY_PLATFORM value
                         * @property {number} CONTACT_CENTER_AS_A_SERVICE=6 CONTACT_CENTER_AS_A_SERVICE value
                         * @property {number} FIVE9=7 FIVE9 value
                         */
                        ChannelProfile.ChannelType = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "UNKNOWN"] = 0;
                            values[valuesById[2] = "WEB_UI"] = 2;
                            values[valuesById[3] = "API"] = 3;
                            values[valuesById[4] = "TWILIO"] = 4;
                            values[valuesById[5] = "GOOGLE_TELEPHONY_PLATFORM"] = 5;
                            values[valuesById[6] = "CONTACT_CENTER_AS_A_SERVICE"] = 6;
                            values[valuesById[7] = "FIVE9"] = 7;
                            return values;
                        })();
    
                        return ChannelProfile;
                    })();
    
                    v1.Span = (function() {
    
                        /**
                         * Properties of a Span.
                         * @memberof google.cloud.ces.v1
                         * @interface ISpan
                         * @property {string|null} [name] Span name
                         * @property {google.protobuf.ITimestamp|null} [startTime] Span startTime
                         * @property {google.protobuf.ITimestamp|null} [endTime] Span endTime
                         * @property {google.protobuf.IDuration|null} [duration] Span duration
                         * @property {google.protobuf.IStruct|null} [attributes] Span attributes
                         * @property {Array.<google.cloud.ces.v1.ISpan>|null} [childSpans] Span childSpans
                         */
    
                        /**
                         * Constructs a new Span.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a Span.
                         * @implements ISpan
                         * @constructor
                         * @param {google.cloud.ces.v1.ISpan=} [properties] Properties to set
                         */
                        function Span(properties) {
                            this.childSpans = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Span name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.Span
                         * @instance
                         */
                        Span.prototype.name = "";
    
                        /**
                         * Span startTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} startTime
                         * @memberof google.cloud.ces.v1.Span
                         * @instance
                         */
                        Span.prototype.startTime = null;
    
                        /**
                         * Span endTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} endTime
                         * @memberof google.cloud.ces.v1.Span
                         * @instance
                         */
                        Span.prototype.endTime = null;
    
                        /**
                         * Span duration.
                         * @member {google.protobuf.IDuration|null|undefined} duration
                         * @memberof google.cloud.ces.v1.Span
                         * @instance
                         */
                        Span.prototype.duration = null;
    
                        /**
                         * Span attributes.
                         * @member {google.protobuf.IStruct|null|undefined} attributes
                         * @memberof google.cloud.ces.v1.Span
                         * @instance
                         */
                        Span.prototype.attributes = null;
    
                        /**
                         * Span childSpans.
                         * @member {Array.<google.cloud.ces.v1.ISpan>} childSpans
                         * @memberof google.cloud.ces.v1.Span
                         * @instance
                         */
                        Span.prototype.childSpans = $util.emptyArray;
    
                        /**
                         * Creates a new Span instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.Span
                         * @static
                         * @param {google.cloud.ces.v1.ISpan=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.Span} Span instance
                         */
                        Span.create = function create(properties) {
                            return new Span(properties);
                        };
    
                        /**
                         * Encodes the specified Span message. Does not implicitly {@link google.cloud.ces.v1.Span.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.Span
                         * @static
                         * @param {google.cloud.ces.v1.ISpan} message Span message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Span.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.startTime != null && Object.hasOwnProperty.call(message, "startTime"))
                                $root.google.protobuf.Timestamp.encode(message.startTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.endTime != null && Object.hasOwnProperty.call(message, "endTime"))
                                $root.google.protobuf.Timestamp.encode(message.endTime, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.attributes != null && Object.hasOwnProperty.call(message, "attributes"))
                                $root.google.protobuf.Struct.encode(message.attributes, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.childSpans != null && message.childSpans.length)
                                for (var i = 0; i < message.childSpans.length; ++i)
                                    $root.google.cloud.ces.v1.Span.encode(message.childSpans[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.duration != null && Object.hasOwnProperty.call(message, "duration"))
                                $root.google.protobuf.Duration.encode(message.duration, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Span message, length delimited. Does not implicitly {@link google.cloud.ces.v1.Span.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.Span
                         * @static
                         * @param {google.cloud.ces.v1.ISpan} message Span message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Span.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Span message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.Span
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.Span} Span
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Span.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.Span();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.startTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.endTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.duration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        message.attributes = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 5: {
                                        if (!(message.childSpans && message.childSpans.length))
                                            message.childSpans = [];
                                        message.childSpans.push($root.google.cloud.ces.v1.Span.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Span message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.Span
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.Span} Span
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Span.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Span message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.Span
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Span.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.startTime != null && message.hasOwnProperty("startTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.startTime);
                                if (error)
                                    return "startTime." + error;
                            }
                            if (message.endTime != null && message.hasOwnProperty("endTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.endTime);
                                if (error)
                                    return "endTime." + error;
                            }
                            if (message.duration != null && message.hasOwnProperty("duration")) {
                                var error = $root.google.protobuf.Duration.verify(message.duration);
                                if (error)
                                    return "duration." + error;
                            }
                            if (message.attributes != null && message.hasOwnProperty("attributes")) {
                                var error = $root.google.protobuf.Struct.verify(message.attributes);
                                if (error)
                                    return "attributes." + error;
                            }
                            if (message.childSpans != null && message.hasOwnProperty("childSpans")) {
                                if (!Array.isArray(message.childSpans))
                                    return "childSpans: array expected";
                                for (var i = 0; i < message.childSpans.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Span.verify(message.childSpans[i]);
                                    if (error)
                                        return "childSpans." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Span message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.Span
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.Span} Span
                         */
                        Span.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.Span)
                                return object;
                            var message = new $root.google.cloud.ces.v1.Span();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.startTime != null) {
                                if (typeof object.startTime !== "object")
                                    throw TypeError(".google.cloud.ces.v1.Span.startTime: object expected");
                                message.startTime = $root.google.protobuf.Timestamp.fromObject(object.startTime);
                            }
                            if (object.endTime != null) {
                                if (typeof object.endTime !== "object")
                                    throw TypeError(".google.cloud.ces.v1.Span.endTime: object expected");
                                message.endTime = $root.google.protobuf.Timestamp.fromObject(object.endTime);
                            }
                            if (object.duration != null) {
                                if (typeof object.duration !== "object")
                                    throw TypeError(".google.cloud.ces.v1.Span.duration: object expected");
                                message.duration = $root.google.protobuf.Duration.fromObject(object.duration);
                            }
                            if (object.attributes != null) {
                                if (typeof object.attributes !== "object")
                                    throw TypeError(".google.cloud.ces.v1.Span.attributes: object expected");
                                message.attributes = $root.google.protobuf.Struct.fromObject(object.attributes);
                            }
                            if (object.childSpans) {
                                if (!Array.isArray(object.childSpans))
                                    throw TypeError(".google.cloud.ces.v1.Span.childSpans: array expected");
                                message.childSpans = [];
                                for (var i = 0; i < object.childSpans.length; ++i) {
                                    if (typeof object.childSpans[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.Span.childSpans: object expected");
                                    message.childSpans[i] = $root.google.cloud.ces.v1.Span.fromObject(object.childSpans[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Span message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.Span
                         * @static
                         * @param {google.cloud.ces.v1.Span} message Span
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Span.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.childSpans = [];
                            if (options.defaults) {
                                object.name = "";
                                object.startTime = null;
                                object.endTime = null;
                                object.attributes = null;
                                object.duration = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.startTime != null && message.hasOwnProperty("startTime"))
                                object.startTime = $root.google.protobuf.Timestamp.toObject(message.startTime, options);
                            if (message.endTime != null && message.hasOwnProperty("endTime"))
                                object.endTime = $root.google.protobuf.Timestamp.toObject(message.endTime, options);
                            if (message.attributes != null && message.hasOwnProperty("attributes"))
                                object.attributes = $root.google.protobuf.Struct.toObject(message.attributes, options);
                            if (message.childSpans && message.childSpans.length) {
                                object.childSpans = [];
                                for (var j = 0; j < message.childSpans.length; ++j)
                                    object.childSpans[j] = $root.google.cloud.ces.v1.Span.toObject(message.childSpans[j], options);
                            }
                            if (message.duration != null && message.hasOwnProperty("duration"))
                                object.duration = $root.google.protobuf.Duration.toObject(message.duration, options);
                            return object;
                        };
    
                        /**
                         * Converts this Span to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.Span
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Span.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Span
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.Span
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Span.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.Span";
                        };
    
                        return Span;
                    })();
    
                    v1.AgentService = (function() {
    
                        /**
                         * Constructs a new AgentService service.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an AgentService
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function AgentService(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (AgentService.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = AgentService;
    
                        /**
                         * Creates new AgentService service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.ces.v1.AgentService
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {AgentService} RPC service. Useful where requests and/or responses are streamed.
                         */
                        AgentService.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listApps}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListAppsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListAppsResponse} [response] ListAppsResponse
                         */
    
                        /**
                         * Calls ListApps.
                         * @function listApps
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListAppsRequest} request ListAppsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListAppsCallback} callback Node-style callback called with the error, if any, and ListAppsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listApps = function listApps(request, callback) {
                            return this.rpcCall(listApps, $root.google.cloud.ces.v1.ListAppsRequest, $root.google.cloud.ces.v1.ListAppsResponse, request, callback);
                        }, "name", { value: "ListApps" });
    
                        /**
                         * Calls ListApps.
                         * @function listApps
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListAppsRequest} request ListAppsRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListAppsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getApp}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetAppCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.App} [response] App
                         */
    
                        /**
                         * Calls GetApp.
                         * @function getApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetAppRequest} request GetAppRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetAppCallback} callback Node-style callback called with the error, if any, and App
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getApp = function getApp(request, callback) {
                            return this.rpcCall(getApp, $root.google.cloud.ces.v1.GetAppRequest, $root.google.cloud.ces.v1.App, request, callback);
                        }, "name", { value: "GetApp" });
    
                        /**
                         * Calls GetApp.
                         * @function getApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetAppRequest} request GetAppRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.App>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|createApp}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef CreateAppCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateApp.
                         * @function createApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateAppRequest} request CreateAppRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.CreateAppCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.createApp = function createApp(request, callback) {
                            return this.rpcCall(createApp, $root.google.cloud.ces.v1.CreateAppRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateApp" });
    
                        /**
                         * Calls CreateApp.
                         * @function createApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateAppRequest} request CreateAppRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|updateApp}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef UpdateAppCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.App} [response] App
                         */
    
                        /**
                         * Calls UpdateApp.
                         * @function updateApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateAppRequest} request UpdateAppRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.UpdateAppCallback} callback Node-style callback called with the error, if any, and App
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.updateApp = function updateApp(request, callback) {
                            return this.rpcCall(updateApp, $root.google.cloud.ces.v1.UpdateAppRequest, $root.google.cloud.ces.v1.App, request, callback);
                        }, "name", { value: "UpdateApp" });
    
                        /**
                         * Calls UpdateApp.
                         * @function updateApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateAppRequest} request UpdateAppRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.App>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|deleteApp}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef DeleteAppCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteApp.
                         * @function deleteApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteAppRequest} request DeleteAppRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.DeleteAppCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.deleteApp = function deleteApp(request, callback) {
                            return this.rpcCall(deleteApp, $root.google.cloud.ces.v1.DeleteAppRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteApp" });
    
                        /**
                         * Calls DeleteApp.
                         * @function deleteApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteAppRequest} request DeleteAppRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|exportApp}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ExportAppCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls ExportApp.
                         * @function exportApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IExportAppRequest} request ExportAppRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ExportAppCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.exportApp = function exportApp(request, callback) {
                            return this.rpcCall(exportApp, $root.google.cloud.ces.v1.ExportAppRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "ExportApp" });
    
                        /**
                         * Calls ExportApp.
                         * @function exportApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IExportAppRequest} request ExportAppRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|importApp}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ImportAppCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls ImportApp.
                         * @function importApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IImportAppRequest} request ImportAppRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ImportAppCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.importApp = function importApp(request, callback) {
                            return this.rpcCall(importApp, $root.google.cloud.ces.v1.ImportAppRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "ImportApp" });
    
                        /**
                         * Calls ImportApp.
                         * @function importApp
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IImportAppRequest} request ImportAppRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listAgents}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListAgentsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListAgentsResponse} [response] ListAgentsResponse
                         */
    
                        /**
                         * Calls ListAgents.
                         * @function listAgents
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListAgentsRequest} request ListAgentsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListAgentsCallback} callback Node-style callback called with the error, if any, and ListAgentsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listAgents = function listAgents(request, callback) {
                            return this.rpcCall(listAgents, $root.google.cloud.ces.v1.ListAgentsRequest, $root.google.cloud.ces.v1.ListAgentsResponse, request, callback);
                        }, "name", { value: "ListAgents" });
    
                        /**
                         * Calls ListAgents.
                         * @function listAgents
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListAgentsRequest} request ListAgentsRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListAgentsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getAgent}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Agent} [response] Agent
                         */
    
                        /**
                         * Calls GetAgent.
                         * @function getAgent
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetAgentRequest} request GetAgentRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetAgentCallback} callback Node-style callback called with the error, if any, and Agent
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getAgent = function getAgent(request, callback) {
                            return this.rpcCall(getAgent, $root.google.cloud.ces.v1.GetAgentRequest, $root.google.cloud.ces.v1.Agent, request, callback);
                        }, "name", { value: "GetAgent" });
    
                        /**
                         * Calls GetAgent.
                         * @function getAgent
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetAgentRequest} request GetAgentRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Agent>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|createAgent}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef CreateAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Agent} [response] Agent
                         */
    
                        /**
                         * Calls CreateAgent.
                         * @function createAgent
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateAgentRequest} request CreateAgentRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.CreateAgentCallback} callback Node-style callback called with the error, if any, and Agent
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.createAgent = function createAgent(request, callback) {
                            return this.rpcCall(createAgent, $root.google.cloud.ces.v1.CreateAgentRequest, $root.google.cloud.ces.v1.Agent, request, callback);
                        }, "name", { value: "CreateAgent" });
    
                        /**
                         * Calls CreateAgent.
                         * @function createAgent
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateAgentRequest} request CreateAgentRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Agent>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|updateAgent}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef UpdateAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Agent} [response] Agent
                         */
    
                        /**
                         * Calls UpdateAgent.
                         * @function updateAgent
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateAgentRequest} request UpdateAgentRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.UpdateAgentCallback} callback Node-style callback called with the error, if any, and Agent
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.updateAgent = function updateAgent(request, callback) {
                            return this.rpcCall(updateAgent, $root.google.cloud.ces.v1.UpdateAgentRequest, $root.google.cloud.ces.v1.Agent, request, callback);
                        }, "name", { value: "UpdateAgent" });
    
                        /**
                         * Calls UpdateAgent.
                         * @function updateAgent
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateAgentRequest} request UpdateAgentRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Agent>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|deleteAgent}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef DeleteAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteAgent.
                         * @function deleteAgent
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteAgentRequest} request DeleteAgentRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.DeleteAgentCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.deleteAgent = function deleteAgent(request, callback) {
                            return this.rpcCall(deleteAgent, $root.google.cloud.ces.v1.DeleteAgentRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteAgent" });
    
                        /**
                         * Calls DeleteAgent.
                         * @function deleteAgent
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteAgentRequest} request DeleteAgentRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listExamples}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListExamplesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListExamplesResponse} [response] ListExamplesResponse
                         */
    
                        /**
                         * Calls ListExamples.
                         * @function listExamples
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListExamplesRequest} request ListExamplesRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListExamplesCallback} callback Node-style callback called with the error, if any, and ListExamplesResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listExamples = function listExamples(request, callback) {
                            return this.rpcCall(listExamples, $root.google.cloud.ces.v1.ListExamplesRequest, $root.google.cloud.ces.v1.ListExamplesResponse, request, callback);
                        }, "name", { value: "ListExamples" });
    
                        /**
                         * Calls ListExamples.
                         * @function listExamples
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListExamplesRequest} request ListExamplesRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListExamplesResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getExample}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetExampleCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Example} [response] Example
                         */
    
                        /**
                         * Calls GetExample.
                         * @function getExample
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetExampleRequest} request GetExampleRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetExampleCallback} callback Node-style callback called with the error, if any, and Example
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getExample = function getExample(request, callback) {
                            return this.rpcCall(getExample, $root.google.cloud.ces.v1.GetExampleRequest, $root.google.cloud.ces.v1.Example, request, callback);
                        }, "name", { value: "GetExample" });
    
                        /**
                         * Calls GetExample.
                         * @function getExample
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetExampleRequest} request GetExampleRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Example>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|createExample}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef CreateExampleCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Example} [response] Example
                         */
    
                        /**
                         * Calls CreateExample.
                         * @function createExample
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateExampleRequest} request CreateExampleRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.CreateExampleCallback} callback Node-style callback called with the error, if any, and Example
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.createExample = function createExample(request, callback) {
                            return this.rpcCall(createExample, $root.google.cloud.ces.v1.CreateExampleRequest, $root.google.cloud.ces.v1.Example, request, callback);
                        }, "name", { value: "CreateExample" });
    
                        /**
                         * Calls CreateExample.
                         * @function createExample
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateExampleRequest} request CreateExampleRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Example>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|updateExample}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef UpdateExampleCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Example} [response] Example
                         */
    
                        /**
                         * Calls UpdateExample.
                         * @function updateExample
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateExampleRequest} request UpdateExampleRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.UpdateExampleCallback} callback Node-style callback called with the error, if any, and Example
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.updateExample = function updateExample(request, callback) {
                            return this.rpcCall(updateExample, $root.google.cloud.ces.v1.UpdateExampleRequest, $root.google.cloud.ces.v1.Example, request, callback);
                        }, "name", { value: "UpdateExample" });
    
                        /**
                         * Calls UpdateExample.
                         * @function updateExample
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateExampleRequest} request UpdateExampleRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Example>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|deleteExample}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef DeleteExampleCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteExample.
                         * @function deleteExample
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteExampleRequest} request DeleteExampleRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.DeleteExampleCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.deleteExample = function deleteExample(request, callback) {
                            return this.rpcCall(deleteExample, $root.google.cloud.ces.v1.DeleteExampleRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteExample" });
    
                        /**
                         * Calls DeleteExample.
                         * @function deleteExample
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteExampleRequest} request DeleteExampleRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listTools}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListToolsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListToolsResponse} [response] ListToolsResponse
                         */
    
                        /**
                         * Calls ListTools.
                         * @function listTools
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListToolsRequest} request ListToolsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListToolsCallback} callback Node-style callback called with the error, if any, and ListToolsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listTools = function listTools(request, callback) {
                            return this.rpcCall(listTools, $root.google.cloud.ces.v1.ListToolsRequest, $root.google.cloud.ces.v1.ListToolsResponse, request, callback);
                        }, "name", { value: "ListTools" });
    
                        /**
                         * Calls ListTools.
                         * @function listTools
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListToolsRequest} request ListToolsRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListToolsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getTool}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetToolCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Tool} [response] Tool
                         */
    
                        /**
                         * Calls GetTool.
                         * @function getTool
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetToolRequest} request GetToolRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetToolCallback} callback Node-style callback called with the error, if any, and Tool
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getTool = function getTool(request, callback) {
                            return this.rpcCall(getTool, $root.google.cloud.ces.v1.GetToolRequest, $root.google.cloud.ces.v1.Tool, request, callback);
                        }, "name", { value: "GetTool" });
    
                        /**
                         * Calls GetTool.
                         * @function getTool
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetToolRequest} request GetToolRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Tool>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listConversations}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListConversationsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListConversationsResponse} [response] ListConversationsResponse
                         */
    
                        /**
                         * Calls ListConversations.
                         * @function listConversations
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListConversationsRequest} request ListConversationsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListConversationsCallback} callback Node-style callback called with the error, if any, and ListConversationsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listConversations = function listConversations(request, callback) {
                            return this.rpcCall(listConversations, $root.google.cloud.ces.v1.ListConversationsRequest, $root.google.cloud.ces.v1.ListConversationsResponse, request, callback);
                        }, "name", { value: "ListConversations" });
    
                        /**
                         * Calls ListConversations.
                         * @function listConversations
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListConversationsRequest} request ListConversationsRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListConversationsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getConversation}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetConversationCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Conversation} [response] Conversation
                         */
    
                        /**
                         * Calls GetConversation.
                         * @function getConversation
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetConversationRequest} request GetConversationRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetConversationCallback} callback Node-style callback called with the error, if any, and Conversation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getConversation = function getConversation(request, callback) {
                            return this.rpcCall(getConversation, $root.google.cloud.ces.v1.GetConversationRequest, $root.google.cloud.ces.v1.Conversation, request, callback);
                        }, "name", { value: "GetConversation" });
    
                        /**
                         * Calls GetConversation.
                         * @function getConversation
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetConversationRequest} request GetConversationRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Conversation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|deleteConversation}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef DeleteConversationCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteConversation.
                         * @function deleteConversation
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteConversationRequest} request DeleteConversationRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.DeleteConversationCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.deleteConversation = function deleteConversation(request, callback) {
                            return this.rpcCall(deleteConversation, $root.google.cloud.ces.v1.DeleteConversationRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteConversation" });
    
                        /**
                         * Calls DeleteConversation.
                         * @function deleteConversation
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteConversationRequest} request DeleteConversationRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|batchDeleteConversations}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef BatchDeleteConversationsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls BatchDeleteConversations.
                         * @function batchDeleteConversations
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsRequest} request BatchDeleteConversationsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.BatchDeleteConversationsCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.batchDeleteConversations = function batchDeleteConversations(request, callback) {
                            return this.rpcCall(batchDeleteConversations, $root.google.cloud.ces.v1.BatchDeleteConversationsRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "BatchDeleteConversations" });
    
                        /**
                         * Calls BatchDeleteConversations.
                         * @function batchDeleteConversations
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsRequest} request BatchDeleteConversationsRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|createTool}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef CreateToolCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Tool} [response] Tool
                         */
    
                        /**
                         * Calls CreateTool.
                         * @function createTool
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateToolRequest} request CreateToolRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.CreateToolCallback} callback Node-style callback called with the error, if any, and Tool
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.createTool = function createTool(request, callback) {
                            return this.rpcCall(createTool, $root.google.cloud.ces.v1.CreateToolRequest, $root.google.cloud.ces.v1.Tool, request, callback);
                        }, "name", { value: "CreateTool" });
    
                        /**
                         * Calls CreateTool.
                         * @function createTool
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateToolRequest} request CreateToolRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Tool>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|updateTool}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef UpdateToolCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Tool} [response] Tool
                         */
    
                        /**
                         * Calls UpdateTool.
                         * @function updateTool
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateToolRequest} request UpdateToolRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.UpdateToolCallback} callback Node-style callback called with the error, if any, and Tool
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.updateTool = function updateTool(request, callback) {
                            return this.rpcCall(updateTool, $root.google.cloud.ces.v1.UpdateToolRequest, $root.google.cloud.ces.v1.Tool, request, callback);
                        }, "name", { value: "UpdateTool" });
    
                        /**
                         * Calls UpdateTool.
                         * @function updateTool
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateToolRequest} request UpdateToolRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Tool>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|deleteTool}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef DeleteToolCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteTool.
                         * @function deleteTool
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteToolRequest} request DeleteToolRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.DeleteToolCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.deleteTool = function deleteTool(request, callback) {
                            return this.rpcCall(deleteTool, $root.google.cloud.ces.v1.DeleteToolRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteTool" });
    
                        /**
                         * Calls DeleteTool.
                         * @function deleteTool
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteToolRequest} request DeleteToolRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listGuardrails}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListGuardrailsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListGuardrailsResponse} [response] ListGuardrailsResponse
                         */
    
                        /**
                         * Calls ListGuardrails.
                         * @function listGuardrails
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListGuardrailsRequest} request ListGuardrailsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListGuardrailsCallback} callback Node-style callback called with the error, if any, and ListGuardrailsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listGuardrails = function listGuardrails(request, callback) {
                            return this.rpcCall(listGuardrails, $root.google.cloud.ces.v1.ListGuardrailsRequest, $root.google.cloud.ces.v1.ListGuardrailsResponse, request, callback);
                        }, "name", { value: "ListGuardrails" });
    
                        /**
                         * Calls ListGuardrails.
                         * @function listGuardrails
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListGuardrailsRequest} request ListGuardrailsRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListGuardrailsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getGuardrail}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetGuardrailCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Guardrail} [response] Guardrail
                         */
    
                        /**
                         * Calls GetGuardrail.
                         * @function getGuardrail
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetGuardrailRequest} request GetGuardrailRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetGuardrailCallback} callback Node-style callback called with the error, if any, and Guardrail
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getGuardrail = function getGuardrail(request, callback) {
                            return this.rpcCall(getGuardrail, $root.google.cloud.ces.v1.GetGuardrailRequest, $root.google.cloud.ces.v1.Guardrail, request, callback);
                        }, "name", { value: "GetGuardrail" });
    
                        /**
                         * Calls GetGuardrail.
                         * @function getGuardrail
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetGuardrailRequest} request GetGuardrailRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Guardrail>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|createGuardrail}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef CreateGuardrailCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Guardrail} [response] Guardrail
                         */
    
                        /**
                         * Calls CreateGuardrail.
                         * @function createGuardrail
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateGuardrailRequest} request CreateGuardrailRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.CreateGuardrailCallback} callback Node-style callback called with the error, if any, and Guardrail
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.createGuardrail = function createGuardrail(request, callback) {
                            return this.rpcCall(createGuardrail, $root.google.cloud.ces.v1.CreateGuardrailRequest, $root.google.cloud.ces.v1.Guardrail, request, callback);
                        }, "name", { value: "CreateGuardrail" });
    
                        /**
                         * Calls CreateGuardrail.
                         * @function createGuardrail
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateGuardrailRequest} request CreateGuardrailRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Guardrail>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|updateGuardrail}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef UpdateGuardrailCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Guardrail} [response] Guardrail
                         */
    
                        /**
                         * Calls UpdateGuardrail.
                         * @function updateGuardrail
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateGuardrailRequest} request UpdateGuardrailRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.UpdateGuardrailCallback} callback Node-style callback called with the error, if any, and Guardrail
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.updateGuardrail = function updateGuardrail(request, callback) {
                            return this.rpcCall(updateGuardrail, $root.google.cloud.ces.v1.UpdateGuardrailRequest, $root.google.cloud.ces.v1.Guardrail, request, callback);
                        }, "name", { value: "UpdateGuardrail" });
    
                        /**
                         * Calls UpdateGuardrail.
                         * @function updateGuardrail
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateGuardrailRequest} request UpdateGuardrailRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Guardrail>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|deleteGuardrail}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef DeleteGuardrailCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteGuardrail.
                         * @function deleteGuardrail
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteGuardrailRequest} request DeleteGuardrailRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.DeleteGuardrailCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.deleteGuardrail = function deleteGuardrail(request, callback) {
                            return this.rpcCall(deleteGuardrail, $root.google.cloud.ces.v1.DeleteGuardrailRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteGuardrail" });
    
                        /**
                         * Calls DeleteGuardrail.
                         * @function deleteGuardrail
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteGuardrailRequest} request DeleteGuardrailRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listDeployments}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListDeploymentsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListDeploymentsResponse} [response] ListDeploymentsResponse
                         */
    
                        /**
                         * Calls ListDeployments.
                         * @function listDeployments
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListDeploymentsRequest} request ListDeploymentsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListDeploymentsCallback} callback Node-style callback called with the error, if any, and ListDeploymentsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listDeployments = function listDeployments(request, callback) {
                            return this.rpcCall(listDeployments, $root.google.cloud.ces.v1.ListDeploymentsRequest, $root.google.cloud.ces.v1.ListDeploymentsResponse, request, callback);
                        }, "name", { value: "ListDeployments" });
    
                        /**
                         * Calls ListDeployments.
                         * @function listDeployments
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListDeploymentsRequest} request ListDeploymentsRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListDeploymentsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getDeployment}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetDeploymentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Deployment} [response] Deployment
                         */
    
                        /**
                         * Calls GetDeployment.
                         * @function getDeployment
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetDeploymentRequest} request GetDeploymentRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetDeploymentCallback} callback Node-style callback called with the error, if any, and Deployment
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getDeployment = function getDeployment(request, callback) {
                            return this.rpcCall(getDeployment, $root.google.cloud.ces.v1.GetDeploymentRequest, $root.google.cloud.ces.v1.Deployment, request, callback);
                        }, "name", { value: "GetDeployment" });
    
                        /**
                         * Calls GetDeployment.
                         * @function getDeployment
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetDeploymentRequest} request GetDeploymentRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Deployment>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|createDeployment}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef CreateDeploymentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Deployment} [response] Deployment
                         */
    
                        /**
                         * Calls CreateDeployment.
                         * @function createDeployment
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateDeploymentRequest} request CreateDeploymentRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.CreateDeploymentCallback} callback Node-style callback called with the error, if any, and Deployment
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.createDeployment = function createDeployment(request, callback) {
                            return this.rpcCall(createDeployment, $root.google.cloud.ces.v1.CreateDeploymentRequest, $root.google.cloud.ces.v1.Deployment, request, callback);
                        }, "name", { value: "CreateDeployment" });
    
                        /**
                         * Calls CreateDeployment.
                         * @function createDeployment
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateDeploymentRequest} request CreateDeploymentRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Deployment>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|updateDeployment}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef UpdateDeploymentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Deployment} [response] Deployment
                         */
    
                        /**
                         * Calls UpdateDeployment.
                         * @function updateDeployment
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateDeploymentRequest} request UpdateDeploymentRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.UpdateDeploymentCallback} callback Node-style callback called with the error, if any, and Deployment
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.updateDeployment = function updateDeployment(request, callback) {
                            return this.rpcCall(updateDeployment, $root.google.cloud.ces.v1.UpdateDeploymentRequest, $root.google.cloud.ces.v1.Deployment, request, callback);
                        }, "name", { value: "UpdateDeployment" });
    
                        /**
                         * Calls UpdateDeployment.
                         * @function updateDeployment
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateDeploymentRequest} request UpdateDeploymentRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Deployment>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|deleteDeployment}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef DeleteDeploymentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteDeployment.
                         * @function deleteDeployment
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteDeploymentRequest} request DeleteDeploymentRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.DeleteDeploymentCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.deleteDeployment = function deleteDeployment(request, callback) {
                            return this.rpcCall(deleteDeployment, $root.google.cloud.ces.v1.DeleteDeploymentRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteDeployment" });
    
                        /**
                         * Calls DeleteDeployment.
                         * @function deleteDeployment
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteDeploymentRequest} request DeleteDeploymentRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listToolsets}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListToolsetsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListToolsetsResponse} [response] ListToolsetsResponse
                         */
    
                        /**
                         * Calls ListToolsets.
                         * @function listToolsets
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListToolsetsRequest} request ListToolsetsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListToolsetsCallback} callback Node-style callback called with the error, if any, and ListToolsetsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listToolsets = function listToolsets(request, callback) {
                            return this.rpcCall(listToolsets, $root.google.cloud.ces.v1.ListToolsetsRequest, $root.google.cloud.ces.v1.ListToolsetsResponse, request, callback);
                        }, "name", { value: "ListToolsets" });
    
                        /**
                         * Calls ListToolsets.
                         * @function listToolsets
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListToolsetsRequest} request ListToolsetsRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListToolsetsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getToolset}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetToolsetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Toolset} [response] Toolset
                         */
    
                        /**
                         * Calls GetToolset.
                         * @function getToolset
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetToolsetRequest} request GetToolsetRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetToolsetCallback} callback Node-style callback called with the error, if any, and Toolset
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getToolset = function getToolset(request, callback) {
                            return this.rpcCall(getToolset, $root.google.cloud.ces.v1.GetToolsetRequest, $root.google.cloud.ces.v1.Toolset, request, callback);
                        }, "name", { value: "GetToolset" });
    
                        /**
                         * Calls GetToolset.
                         * @function getToolset
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetToolsetRequest} request GetToolsetRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Toolset>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|createToolset}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef CreateToolsetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Toolset} [response] Toolset
                         */
    
                        /**
                         * Calls CreateToolset.
                         * @function createToolset
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateToolsetRequest} request CreateToolsetRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.CreateToolsetCallback} callback Node-style callback called with the error, if any, and Toolset
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.createToolset = function createToolset(request, callback) {
                            return this.rpcCall(createToolset, $root.google.cloud.ces.v1.CreateToolsetRequest, $root.google.cloud.ces.v1.Toolset, request, callback);
                        }, "name", { value: "CreateToolset" });
    
                        /**
                         * Calls CreateToolset.
                         * @function createToolset
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateToolsetRequest} request CreateToolsetRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Toolset>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|updateToolset}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef UpdateToolsetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Toolset} [response] Toolset
                         */
    
                        /**
                         * Calls UpdateToolset.
                         * @function updateToolset
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateToolsetRequest} request UpdateToolsetRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.UpdateToolsetCallback} callback Node-style callback called with the error, if any, and Toolset
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.updateToolset = function updateToolset(request, callback) {
                            return this.rpcCall(updateToolset, $root.google.cloud.ces.v1.UpdateToolsetRequest, $root.google.cloud.ces.v1.Toolset, request, callback);
                        }, "name", { value: "UpdateToolset" });
    
                        /**
                         * Calls UpdateToolset.
                         * @function updateToolset
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IUpdateToolsetRequest} request UpdateToolsetRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Toolset>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|deleteToolset}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef DeleteToolsetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteToolset.
                         * @function deleteToolset
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteToolsetRequest} request DeleteToolsetRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.DeleteToolsetCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.deleteToolset = function deleteToolset(request, callback) {
                            return this.rpcCall(deleteToolset, $root.google.cloud.ces.v1.DeleteToolsetRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteToolset" });
    
                        /**
                         * Calls DeleteToolset.
                         * @function deleteToolset
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteToolsetRequest} request DeleteToolsetRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listAppVersions}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListAppVersionsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListAppVersionsResponse} [response] ListAppVersionsResponse
                         */
    
                        /**
                         * Calls ListAppVersions.
                         * @function listAppVersions
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListAppVersionsRequest} request ListAppVersionsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListAppVersionsCallback} callback Node-style callback called with the error, if any, and ListAppVersionsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listAppVersions = function listAppVersions(request, callback) {
                            return this.rpcCall(listAppVersions, $root.google.cloud.ces.v1.ListAppVersionsRequest, $root.google.cloud.ces.v1.ListAppVersionsResponse, request, callback);
                        }, "name", { value: "ListAppVersions" });
    
                        /**
                         * Calls ListAppVersions.
                         * @function listAppVersions
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListAppVersionsRequest} request ListAppVersionsRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListAppVersionsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getAppVersion}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetAppVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.AppVersion} [response] AppVersion
                         */
    
                        /**
                         * Calls GetAppVersion.
                         * @function getAppVersion
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetAppVersionRequest} request GetAppVersionRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetAppVersionCallback} callback Node-style callback called with the error, if any, and AppVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getAppVersion = function getAppVersion(request, callback) {
                            return this.rpcCall(getAppVersion, $root.google.cloud.ces.v1.GetAppVersionRequest, $root.google.cloud.ces.v1.AppVersion, request, callback);
                        }, "name", { value: "GetAppVersion" });
    
                        /**
                         * Calls GetAppVersion.
                         * @function getAppVersion
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetAppVersionRequest} request GetAppVersionRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.AppVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|createAppVersion}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef CreateAppVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.AppVersion} [response] AppVersion
                         */
    
                        /**
                         * Calls CreateAppVersion.
                         * @function createAppVersion
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateAppVersionRequest} request CreateAppVersionRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.CreateAppVersionCallback} callback Node-style callback called with the error, if any, and AppVersion
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.createAppVersion = function createAppVersion(request, callback) {
                            return this.rpcCall(createAppVersion, $root.google.cloud.ces.v1.CreateAppVersionRequest, $root.google.cloud.ces.v1.AppVersion, request, callback);
                        }, "name", { value: "CreateAppVersion" });
    
                        /**
                         * Calls CreateAppVersion.
                         * @function createAppVersion
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.ICreateAppVersionRequest} request CreateAppVersionRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.AppVersion>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|deleteAppVersion}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef DeleteAppVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteAppVersion.
                         * @function deleteAppVersion
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteAppVersionRequest} request DeleteAppVersionRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.DeleteAppVersionCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.deleteAppVersion = function deleteAppVersion(request, callback) {
                            return this.rpcCall(deleteAppVersion, $root.google.cloud.ces.v1.DeleteAppVersionRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteAppVersion" });
    
                        /**
                         * Calls DeleteAppVersion.
                         * @function deleteAppVersion
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IDeleteAppVersionRequest} request DeleteAppVersionRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|restoreAppVersion}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef RestoreAppVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls RestoreAppVersion.
                         * @function restoreAppVersion
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IRestoreAppVersionRequest} request RestoreAppVersionRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.RestoreAppVersionCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.restoreAppVersion = function restoreAppVersion(request, callback) {
                            return this.rpcCall(restoreAppVersion, $root.google.cloud.ces.v1.RestoreAppVersionRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "RestoreAppVersion" });
    
                        /**
                         * Calls RestoreAppVersion.
                         * @function restoreAppVersion
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IRestoreAppVersionRequest} request RestoreAppVersionRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|listChangelogs}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef ListChangelogsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.ListChangelogsResponse} [response] ListChangelogsResponse
                         */
    
                        /**
                         * Calls ListChangelogs.
                         * @function listChangelogs
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListChangelogsRequest} request ListChangelogsRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.ListChangelogsCallback} callback Node-style callback called with the error, if any, and ListChangelogsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.listChangelogs = function listChangelogs(request, callback) {
                            return this.rpcCall(listChangelogs, $root.google.cloud.ces.v1.ListChangelogsRequest, $root.google.cloud.ces.v1.ListChangelogsResponse, request, callback);
                        }, "name", { value: "ListChangelogs" });
    
                        /**
                         * Calls ListChangelogs.
                         * @function listChangelogs
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IListChangelogsRequest} request ListChangelogsRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.ListChangelogsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.ces.v1.AgentService|getChangelog}.
                         * @memberof google.cloud.ces.v1.AgentService
                         * @typedef GetChangelogCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.ces.v1.Changelog} [response] Changelog
                         */
    
                        /**
                         * Calls GetChangelog.
                         * @function getChangelog
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetChangelogRequest} request GetChangelogRequest message or plain object
                         * @param {google.cloud.ces.v1.AgentService.GetChangelogCallback} callback Node-style callback called with the error, if any, and Changelog
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AgentService.prototype.getChangelog = function getChangelog(request, callback) {
                            return this.rpcCall(getChangelog, $root.google.cloud.ces.v1.GetChangelogRequest, $root.google.cloud.ces.v1.Changelog, request, callback);
                        }, "name", { value: "GetChangelog" });
    
                        /**
                         * Calls GetChangelog.
                         * @function getChangelog
                         * @memberof google.cloud.ces.v1.AgentService
                         * @instance
                         * @param {google.cloud.ces.v1.IGetChangelogRequest} request GetChangelogRequest message or plain object
                         * @returns {Promise<google.cloud.ces.v1.Changelog>} Promise
                         * @variation 2
                         */
    
                        return AgentService;
                    })();
    
                    v1.ListAppsRequest = (function() {
    
                        /**
                         * Properties of a ListAppsRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IListAppsRequest
                         * @property {string|null} [parent] ListAppsRequest parent
                         * @property {number|null} [pageSize] ListAppsRequest pageSize
                         * @property {string|null} [pageToken] ListAppsRequest pageToken
                         * @property {string|null} [filter] ListAppsRequest filter
                         * @property {string|null} [orderBy] ListAppsRequest orderBy
                         */
    
                        /**
                         * Constructs a new ListAppsRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListAppsRequest.
                         * @implements IListAppsRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IListAppsRequest=} [properties] Properties to set
                         */
                        function ListAppsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAppsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @instance
                         */
                        ListAppsRequest.prototype.parent = "";
    
                        /**
                         * ListAppsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @instance
                         */
                        ListAppsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListAppsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @instance
                         */
                        ListAppsRequest.prototype.pageToken = "";
    
                        /**
                         * ListAppsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @instance
                         */
                        ListAppsRequest.prototype.filter = "";
    
                        /**
                         * ListAppsRequest orderBy.
                         * @member {string} orderBy
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @instance
                         */
                        ListAppsRequest.prototype.orderBy = "";
    
                        /**
                         * Creates a new ListAppsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListAppsRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListAppsRequest} ListAppsRequest instance
                         */
                        ListAppsRequest.create = function create(properties) {
                            return new ListAppsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListAppsRequest message. Does not implicitly {@link google.cloud.ces.v1.ListAppsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListAppsRequest} message ListAppsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAppsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            if (message.orderBy != null && Object.hasOwnProperty.call(message, "orderBy"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.orderBy);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAppsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListAppsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListAppsRequest} message ListAppsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAppsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAppsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListAppsRequest} ListAppsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAppsRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListAppsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.orderBy = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAppsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListAppsRequest} ListAppsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAppsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAppsRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAppsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            if (message.orderBy != null && message.hasOwnProperty("orderBy"))
                                if (!$util.isString(message.orderBy))
                                    return "orderBy: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListAppsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListAppsRequest} ListAppsRequest
                         */
                        ListAppsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListAppsRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListAppsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.orderBy != null)
                                message.orderBy = String(object.orderBy);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAppsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @static
                         * @param {google.cloud.ces.v1.ListAppsRequest} message ListAppsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAppsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                                object.orderBy = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            if (message.orderBy != null && message.hasOwnProperty("orderBy"))
                                object.orderBy = message.orderBy;
                            return object;
                        };
    
                        /**
                         * Converts this ListAppsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAppsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListAppsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListAppsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListAppsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListAppsRequest";
                        };
    
                        return ListAppsRequest;
                    })();
    
                    v1.ListAppsResponse = (function() {
    
                        /**
                         * Properties of a ListAppsResponse.
                         * @memberof google.cloud.ces.v1
                         * @interface IListAppsResponse
                         * @property {Array.<google.cloud.ces.v1.IApp>|null} [apps] ListAppsResponse apps
                         * @property {string|null} [nextPageToken] ListAppsResponse nextPageToken
                         * @property {Array.<string>|null} [unreachable] ListAppsResponse unreachable
                         */
    
                        /**
                         * Constructs a new ListAppsResponse.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListAppsResponse.
                         * @implements IListAppsResponse
                         * @constructor
                         * @param {google.cloud.ces.v1.IListAppsResponse=} [properties] Properties to set
                         */
                        function ListAppsResponse(properties) {
                            this.apps = [];
                            this.unreachable = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAppsResponse apps.
                         * @member {Array.<google.cloud.ces.v1.IApp>} apps
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @instance
                         */
                        ListAppsResponse.prototype.apps = $util.emptyArray;
    
                        /**
                         * ListAppsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @instance
                         */
                        ListAppsResponse.prototype.nextPageToken = "";
    
                        /**
                         * ListAppsResponse unreachable.
                         * @member {Array.<string>} unreachable
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @instance
                         */
                        ListAppsResponse.prototype.unreachable = $util.emptyArray;
    
                        /**
                         * Creates a new ListAppsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListAppsResponse=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListAppsResponse} ListAppsResponse instance
                         */
                        ListAppsResponse.create = function create(properties) {
                            return new ListAppsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListAppsResponse message. Does not implicitly {@link google.cloud.ces.v1.ListAppsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListAppsResponse} message ListAppsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAppsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.apps != null && message.apps.length)
                                for (var i = 0; i < message.apps.length; ++i)
                                    $root.google.cloud.ces.v1.App.encode(message.apps[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            if (message.unreachable != null && message.unreachable.length)
                                for (var i = 0; i < message.unreachable.length; ++i)
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.unreachable[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAppsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListAppsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListAppsResponse} message ListAppsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAppsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAppsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListAppsResponse} ListAppsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAppsResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListAppsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.apps && message.apps.length))
                                            message.apps = [];
                                        message.apps.push($root.google.cloud.ces.v1.App.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                case 3: {
                                        if (!(message.unreachable && message.unreachable.length))
                                            message.unreachable = [];
                                        message.unreachable.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAppsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListAppsResponse} ListAppsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAppsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAppsResponse message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAppsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.apps != null && message.hasOwnProperty("apps")) {
                                if (!Array.isArray(message.apps))
                                    return "apps: array expected";
                                for (var i = 0; i < message.apps.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.App.verify(message.apps[i]);
                                    if (error)
                                        return "apps." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            if (message.unreachable != null && message.hasOwnProperty("unreachable")) {
                                if (!Array.isArray(message.unreachable))
                                    return "unreachable: array expected";
                                for (var i = 0; i < message.unreachable.length; ++i)
                                    if (!$util.isString(message.unreachable[i]))
                                        return "unreachable: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ListAppsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListAppsResponse} ListAppsResponse
                         */
                        ListAppsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListAppsResponse)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListAppsResponse();
                            if (object.apps) {
                                if (!Array.isArray(object.apps))
                                    throw TypeError(".google.cloud.ces.v1.ListAppsResponse.apps: array expected");
                                message.apps = [];
                                for (var i = 0; i < object.apps.length; ++i) {
                                    if (typeof object.apps[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.ListAppsResponse.apps: object expected");
                                    message.apps[i] = $root.google.cloud.ces.v1.App.fromObject(object.apps[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            if (object.unreachable) {
                                if (!Array.isArray(object.unreachable))
                                    throw TypeError(".google.cloud.ces.v1.ListAppsResponse.unreachable: array expected");
                                message.unreachable = [];
                                for (var i = 0; i < object.unreachable.length; ++i)
                                    message.unreachable[i] = String(object.unreachable[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAppsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @static
                         * @param {google.cloud.ces.v1.ListAppsResponse} message ListAppsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAppsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.apps = [];
                                object.unreachable = [];
                            }
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.apps && message.apps.length) {
                                object.apps = [];
                                for (var j = 0; j < message.apps.length; ++j)
                                    object.apps[j] = $root.google.cloud.ces.v1.App.toObject(message.apps[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            if (message.unreachable && message.unreachable.length) {
                                object.unreachable = [];
                                for (var j = 0; j < message.unreachable.length; ++j)
                                    object.unreachable[j] = message.unreachable[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ListAppsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAppsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListAppsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListAppsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListAppsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListAppsResponse";
                        };
    
                        return ListAppsResponse;
                    })();
    
                    v1.GetAppRequest = (function() {
    
                        /**
                         * Properties of a GetAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IGetAppRequest
                         * @property {string|null} [name] GetAppRequest name
                         */
    
                        /**
                         * Constructs a new GetAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a GetAppRequest.
                         * @implements IGetAppRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IGetAppRequest=} [properties] Properties to set
                         */
                        function GetAppRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetAppRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @instance
                         */
                        GetAppRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetAppRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetAppRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.GetAppRequest} GetAppRequest instance
                         */
                        GetAppRequest.create = function create(properties) {
                            return new GetAppRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetAppRequest message. Does not implicitly {@link google.cloud.ces.v1.GetAppRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetAppRequest} message GetAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAppRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.GetAppRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetAppRequest} message GetAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAppRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetAppRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.GetAppRequest} GetAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAppRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.GetAppRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetAppRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.GetAppRequest} GetAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAppRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetAppRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetAppRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetAppRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.GetAppRequest} GetAppRequest
                         */
                        GetAppRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.GetAppRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.GetAppRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetAppRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.GetAppRequest} message GetAppRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetAppRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetAppRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetAppRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetAppRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.GetAppRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetAppRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.GetAppRequest";
                        };
    
                        return GetAppRequest;
                    })();
    
                    v1.CreateAppRequest = (function() {
    
                        /**
                         * Properties of a CreateAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface ICreateAppRequest
                         * @property {string|null} [parent] CreateAppRequest parent
                         * @property {string|null} [appId] CreateAppRequest appId
                         * @property {google.cloud.ces.v1.IApp|null} [app] CreateAppRequest app
                         */
    
                        /**
                         * Constructs a new CreateAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a CreateAppRequest.
                         * @implements ICreateAppRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.ICreateAppRequest=} [properties] Properties to set
                         */
                        function CreateAppRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateAppRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @instance
                         */
                        CreateAppRequest.prototype.parent = "";
    
                        /**
                         * CreateAppRequest appId.
                         * @member {string} appId
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @instance
                         */
                        CreateAppRequest.prototype.appId = "";
    
                        /**
                         * CreateAppRequest app.
                         * @member {google.cloud.ces.v1.IApp|null|undefined} app
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @instance
                         */
                        CreateAppRequest.prototype.app = null;
    
                        /**
                         * Creates a new CreateAppRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateAppRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.CreateAppRequest} CreateAppRequest instance
                         */
                        CreateAppRequest.create = function create(properties) {
                            return new CreateAppRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateAppRequest message. Does not implicitly {@link google.cloud.ces.v1.CreateAppRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateAppRequest} message CreateAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateAppRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.appId != null && Object.hasOwnProperty.call(message, "appId"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.appId);
                            if (message.app != null && Object.hasOwnProperty.call(message, "app"))
                                $root.google.cloud.ces.v1.App.encode(message.app, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.CreateAppRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateAppRequest} message CreateAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateAppRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateAppRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.CreateAppRequest} CreateAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateAppRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.CreateAppRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.appId = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.app = $root.google.cloud.ces.v1.App.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateAppRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.CreateAppRequest} CreateAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateAppRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateAppRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateAppRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.appId != null && message.hasOwnProperty("appId"))
                                if (!$util.isString(message.appId))
                                    return "appId: string expected";
                            if (message.app != null && message.hasOwnProperty("app")) {
                                var error = $root.google.cloud.ces.v1.App.verify(message.app);
                                if (error)
                                    return "app." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateAppRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.CreateAppRequest} CreateAppRequest
                         */
                        CreateAppRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.CreateAppRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.CreateAppRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.appId != null)
                                message.appId = String(object.appId);
                            if (object.app != null) {
                                if (typeof object.app !== "object")
                                    throw TypeError(".google.cloud.ces.v1.CreateAppRequest.app: object expected");
                                message.app = $root.google.cloud.ces.v1.App.fromObject(object.app);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateAppRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.CreateAppRequest} message CreateAppRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateAppRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.appId = "";
                                object.app = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.appId != null && message.hasOwnProperty("appId"))
                                object.appId = message.appId;
                            if (message.app != null && message.hasOwnProperty("app"))
                                object.app = $root.google.cloud.ces.v1.App.toObject(message.app, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateAppRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateAppRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateAppRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.CreateAppRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateAppRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.CreateAppRequest";
                        };
    
                        return CreateAppRequest;
                    })();
    
                    v1.UpdateAppRequest = (function() {
    
                        /**
                         * Properties of an UpdateAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IUpdateAppRequest
                         * @property {google.cloud.ces.v1.IApp|null} [app] UpdateAppRequest app
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateAppRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an UpdateAppRequest.
                         * @implements IUpdateAppRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IUpdateAppRequest=} [properties] Properties to set
                         */
                        function UpdateAppRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateAppRequest app.
                         * @member {google.cloud.ces.v1.IApp|null|undefined} app
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @instance
                         */
                        UpdateAppRequest.prototype.app = null;
    
                        /**
                         * UpdateAppRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @instance
                         */
                        UpdateAppRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateAppRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateAppRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.UpdateAppRequest} UpdateAppRequest instance
                         */
                        UpdateAppRequest.create = function create(properties) {
                            return new UpdateAppRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateAppRequest message. Does not implicitly {@link google.cloud.ces.v1.UpdateAppRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateAppRequest} message UpdateAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAppRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.app != null && Object.hasOwnProperty.call(message, "app"))
                                $root.google.cloud.ces.v1.App.encode(message.app, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.UpdateAppRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateAppRequest} message UpdateAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAppRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateAppRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.UpdateAppRequest} UpdateAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAppRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.UpdateAppRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.app = $root.google.cloud.ces.v1.App.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateAppRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.UpdateAppRequest} UpdateAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAppRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateAppRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateAppRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.app != null && message.hasOwnProperty("app")) {
                                var error = $root.google.cloud.ces.v1.App.verify(message.app);
                                if (error)
                                    return "app." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateAppRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.UpdateAppRequest} UpdateAppRequest
                         */
                        UpdateAppRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.UpdateAppRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.UpdateAppRequest();
                            if (object.app != null) {
                                if (typeof object.app !== "object")
                                    throw TypeError(".google.cloud.ces.v1.UpdateAppRequest.app: object expected");
                                message.app = $root.google.cloud.ces.v1.App.fromObject(object.app);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.ces.v1.UpdateAppRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateAppRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.UpdateAppRequest} message UpdateAppRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateAppRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.app = null;
                                object.updateMask = null;
                            }
                            if (message.app != null && message.hasOwnProperty("app"))
                                object.app = $root.google.cloud.ces.v1.App.toObject(message.app, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateAppRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateAppRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateAppRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.UpdateAppRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateAppRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.UpdateAppRequest";
                        };
    
                        return UpdateAppRequest;
                    })();
    
                    v1.DeleteAppRequest = (function() {
    
                        /**
                         * Properties of a DeleteAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IDeleteAppRequest
                         * @property {string|null} [name] DeleteAppRequest name
                         * @property {string|null} [etag] DeleteAppRequest etag
                         */
    
                        /**
                         * Constructs a new DeleteAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a DeleteAppRequest.
                         * @implements IDeleteAppRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IDeleteAppRequest=} [properties] Properties to set
                         */
                        function DeleteAppRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteAppRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @instance
                         */
                        DeleteAppRequest.prototype.name = "";
    
                        /**
                         * DeleteAppRequest etag.
                         * @member {string} etag
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @instance
                         */
                        DeleteAppRequest.prototype.etag = "";
    
                        /**
                         * Creates a new DeleteAppRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteAppRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.DeleteAppRequest} DeleteAppRequest instance
                         */
                        DeleteAppRequest.create = function create(properties) {
                            return new DeleteAppRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteAppRequest message. Does not implicitly {@link google.cloud.ces.v1.DeleteAppRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteAppRequest} message DeleteAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAppRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.DeleteAppRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteAppRequest} message DeleteAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAppRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteAppRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.DeleteAppRequest} DeleteAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAppRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.DeleteAppRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteAppRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.DeleteAppRequest} DeleteAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAppRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteAppRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteAppRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteAppRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.DeleteAppRequest} DeleteAppRequest
                         */
                        DeleteAppRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.DeleteAppRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.DeleteAppRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteAppRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.DeleteAppRequest} message DeleteAppRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteAppRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteAppRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteAppRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteAppRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.DeleteAppRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteAppRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.DeleteAppRequest";
                        };
    
                        return DeleteAppRequest;
                    })();
    
                    v1.ExportAppRequest = (function() {
    
                        /**
                         * Properties of an ExportAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IExportAppRequest
                         * @property {string|null} [name] ExportAppRequest name
                         * @property {google.cloud.ces.v1.ExportAppRequest.ExportFormat|null} [exportFormat] ExportAppRequest exportFormat
                         * @property {string|null} [gcsUri] ExportAppRequest gcsUri
                         */
    
                        /**
                         * Constructs a new ExportAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an ExportAppRequest.
                         * @implements IExportAppRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IExportAppRequest=} [properties] Properties to set
                         */
                        function ExportAppRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ExportAppRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @instance
                         */
                        ExportAppRequest.prototype.name = "";
    
                        /**
                         * ExportAppRequest exportFormat.
                         * @member {google.cloud.ces.v1.ExportAppRequest.ExportFormat} exportFormat
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @instance
                         */
                        ExportAppRequest.prototype.exportFormat = 0;
    
                        /**
                         * ExportAppRequest gcsUri.
                         * @member {string} gcsUri
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @instance
                         */
                        ExportAppRequest.prototype.gcsUri = "";
    
                        /**
                         * Creates a new ExportAppRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IExportAppRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ExportAppRequest} ExportAppRequest instance
                         */
                        ExportAppRequest.create = function create(properties) {
                            return new ExportAppRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ExportAppRequest message. Does not implicitly {@link google.cloud.ces.v1.ExportAppRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IExportAppRequest} message ExportAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportAppRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.exportFormat != null && Object.hasOwnProperty.call(message, "exportFormat"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.exportFormat);
                            if (message.gcsUri != null && Object.hasOwnProperty.call(message, "gcsUri"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.gcsUri);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ExportAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ExportAppRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IExportAppRequest} message ExportAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportAppRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ExportAppRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ExportAppRequest} ExportAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportAppRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ExportAppRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.exportFormat = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.gcsUri = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ExportAppRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ExportAppRequest} ExportAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportAppRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ExportAppRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ExportAppRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.exportFormat != null && message.hasOwnProperty("exportFormat"))
                                switch (message.exportFormat) {
                                default:
                                    return "exportFormat: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            if (message.gcsUri != null && message.hasOwnProperty("gcsUri"))
                                if (!$util.isString(message.gcsUri))
                                    return "gcsUri: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an ExportAppRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ExportAppRequest} ExportAppRequest
                         */
                        ExportAppRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ExportAppRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ExportAppRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            switch (object.exportFormat) {
                            default:
                                if (typeof object.exportFormat === "number") {
                                    message.exportFormat = object.exportFormat;
                                    break;
                                }
                                break;
                            case "EXPORT_FORMAT_UNSPECIFIED":
                            case 0:
                                message.exportFormat = 0;
                                break;
                            case "JSON":
                            case 1:
                                message.exportFormat = 1;
                                break;
                            case "YAML":
                            case 2:
                                message.exportFormat = 2;
                                break;
                            }
                            if (object.gcsUri != null)
                                message.gcsUri = String(object.gcsUri);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ExportAppRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.ExportAppRequest} message ExportAppRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ExportAppRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.exportFormat = options.enums === String ? "EXPORT_FORMAT_UNSPECIFIED" : 0;
                                object.gcsUri = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.exportFormat != null && message.hasOwnProperty("exportFormat"))
                                object.exportFormat = options.enums === String ? $root.google.cloud.ces.v1.ExportAppRequest.ExportFormat[message.exportFormat] === undefined ? message.exportFormat : $root.google.cloud.ces.v1.ExportAppRequest.ExportFormat[message.exportFormat] : message.exportFormat;
                            if (message.gcsUri != null && message.hasOwnProperty("gcsUri"))
                                object.gcsUri = message.gcsUri;
                            return object;
                        };
    
                        /**
                         * Converts this ExportAppRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ExportAppRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ExportAppRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ExportAppRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ExportAppRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ExportAppRequest";
                        };
    
                        /**
                         * ExportFormat enum.
                         * @name google.cloud.ces.v1.ExportAppRequest.ExportFormat
                         * @enum {number}
                         * @property {number} EXPORT_FORMAT_UNSPECIFIED=0 EXPORT_FORMAT_UNSPECIFIED value
                         * @property {number} JSON=1 JSON value
                         * @property {number} YAML=2 YAML value
                         */
                        ExportAppRequest.ExportFormat = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "EXPORT_FORMAT_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "JSON"] = 1;
                            values[valuesById[2] = "YAML"] = 2;
                            return values;
                        })();
    
                        return ExportAppRequest;
                    })();
    
                    v1.ExportAppResponse = (function() {
    
                        /**
                         * Properties of an ExportAppResponse.
                         * @memberof google.cloud.ces.v1
                         * @interface IExportAppResponse
                         * @property {Uint8Array|null} [appContent] ExportAppResponse appContent
                         * @property {string|null} [appUri] ExportAppResponse appUri
                         */
    
                        /**
                         * Constructs a new ExportAppResponse.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an ExportAppResponse.
                         * @implements IExportAppResponse
                         * @constructor
                         * @param {google.cloud.ces.v1.IExportAppResponse=} [properties] Properties to set
                         */
                        function ExportAppResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ExportAppResponse appContent.
                         * @member {Uint8Array|null|undefined} appContent
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @instance
                         */
                        ExportAppResponse.prototype.appContent = null;
    
                        /**
                         * ExportAppResponse appUri.
                         * @member {string|null|undefined} appUri
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @instance
                         */
                        ExportAppResponse.prototype.appUri = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * ExportAppResponse app.
                         * @member {"appContent"|"appUri"|undefined} app
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @instance
                         */
                        Object.defineProperty(ExportAppResponse.prototype, "app", {
                            get: $util.oneOfGetter($oneOfFields = ["appContent", "appUri"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new ExportAppResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @static
                         * @param {google.cloud.ces.v1.IExportAppResponse=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ExportAppResponse} ExportAppResponse instance
                         */
                        ExportAppResponse.create = function create(properties) {
                            return new ExportAppResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ExportAppResponse message. Does not implicitly {@link google.cloud.ces.v1.ExportAppResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @static
                         * @param {google.cloud.ces.v1.IExportAppResponse} message ExportAppResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportAppResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.appContent != null && Object.hasOwnProperty.call(message, "appContent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.appContent);
                            if (message.appUri != null && Object.hasOwnProperty.call(message, "appUri"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.appUri);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ExportAppResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ExportAppResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @static
                         * @param {google.cloud.ces.v1.IExportAppResponse} message ExportAppResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportAppResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ExportAppResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ExportAppResponse} ExportAppResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportAppResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ExportAppResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.appContent = reader.bytes();
                                        break;
                                    }
                                case 2: {
                                        message.appUri = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ExportAppResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ExportAppResponse} ExportAppResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportAppResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ExportAppResponse message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ExportAppResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.appContent != null && message.hasOwnProperty("appContent")) {
                                properties.app = 1;
                                if (!(message.appContent && typeof message.appContent.length === "number" || $util.isString(message.appContent)))
                                    return "appContent: buffer expected";
                            }
                            if (message.appUri != null && message.hasOwnProperty("appUri")) {
                                if (properties.app === 1)
                                    return "app: multiple values";
                                properties.app = 1;
                                if (!$util.isString(message.appUri))
                                    return "appUri: string expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an ExportAppResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ExportAppResponse} ExportAppResponse
                         */
                        ExportAppResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ExportAppResponse)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ExportAppResponse();
                            if (object.appContent != null)
                                if (typeof object.appContent === "string")
                                    $util.base64.decode(object.appContent, message.appContent = $util.newBuffer($util.base64.length(object.appContent)), 0);
                                else if (object.appContent.length >= 0)
                                    message.appContent = object.appContent;
                            if (object.appUri != null)
                                message.appUri = String(object.appUri);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ExportAppResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @static
                         * @param {google.cloud.ces.v1.ExportAppResponse} message ExportAppResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ExportAppResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.appContent != null && message.hasOwnProperty("appContent")) {
                                object.appContent = options.bytes === String ? $util.base64.encode(message.appContent, 0, message.appContent.length) : options.bytes === Array ? Array.prototype.slice.call(message.appContent) : message.appContent;
                                if (options.oneofs)
                                    object.app = "appContent";
                            }
                            if (message.appUri != null && message.hasOwnProperty("appUri")) {
                                object.appUri = message.appUri;
                                if (options.oneofs)
                                    object.app = "appUri";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ExportAppResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ExportAppResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ExportAppResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ExportAppResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ExportAppResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ExportAppResponse";
                        };
    
                        return ExportAppResponse;
                    })();
    
                    v1.ImportAppRequest = (function() {
    
                        /**
                         * Properties of an ImportAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IImportAppRequest
                         * @property {string|null} [gcsUri] ImportAppRequest gcsUri
                         * @property {Uint8Array|null} [appContent] ImportAppRequest appContent
                         * @property {string|null} [parent] ImportAppRequest parent
                         * @property {string|null} [displayName] ImportAppRequest displayName
                         * @property {string|null} [appId] ImportAppRequest appId
                         * @property {google.cloud.ces.v1.ImportAppRequest.IImportOptions|null} [importOptions] ImportAppRequest importOptions
                         */
    
                        /**
                         * Constructs a new ImportAppRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an ImportAppRequest.
                         * @implements IImportAppRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IImportAppRequest=} [properties] Properties to set
                         */
                        function ImportAppRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ImportAppRequest gcsUri.
                         * @member {string|null|undefined} gcsUri
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @instance
                         */
                        ImportAppRequest.prototype.gcsUri = null;
    
                        /**
                         * ImportAppRequest appContent.
                         * @member {Uint8Array|null|undefined} appContent
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @instance
                         */
                        ImportAppRequest.prototype.appContent = null;
    
                        /**
                         * ImportAppRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @instance
                         */
                        ImportAppRequest.prototype.parent = "";
    
                        /**
                         * ImportAppRequest displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @instance
                         */
                        ImportAppRequest.prototype.displayName = "";
    
                        /**
                         * ImportAppRequest appId.
                         * @member {string} appId
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @instance
                         */
                        ImportAppRequest.prototype.appId = "";
    
                        /**
                         * ImportAppRequest importOptions.
                         * @member {google.cloud.ces.v1.ImportAppRequest.IImportOptions|null|undefined} importOptions
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @instance
                         */
                        ImportAppRequest.prototype.importOptions = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * ImportAppRequest app.
                         * @member {"gcsUri"|"appContent"|undefined} app
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @instance
                         */
                        Object.defineProperty(ImportAppRequest.prototype, "app", {
                            get: $util.oneOfGetter($oneOfFields = ["gcsUri", "appContent"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new ImportAppRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IImportAppRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ImportAppRequest} ImportAppRequest instance
                         */
                        ImportAppRequest.create = function create(properties) {
                            return new ImportAppRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ImportAppRequest message. Does not implicitly {@link google.cloud.ces.v1.ImportAppRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IImportAppRequest} message ImportAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportAppRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.displayName);
                            if (message.appId != null && Object.hasOwnProperty.call(message, "appId"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.appId);
                            if (message.gcsUri != null && Object.hasOwnProperty.call(message, "gcsUri"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.gcsUri);
                            if (message.appContent != null && Object.hasOwnProperty.call(message, "appContent"))
                                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.appContent);
                            if (message.importOptions != null && Object.hasOwnProperty.call(message, "importOptions"))
                                $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions.encode(message.importOptions, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ImportAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ImportAppRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.IImportAppRequest} message ImportAppRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportAppRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ImportAppRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ImportAppRequest} ImportAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportAppRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ImportAppRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 4: {
                                        message.gcsUri = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.appContent = reader.bytes();
                                        break;
                                    }
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.appId = reader.string();
                                        break;
                                    }
                                case 6: {
                                        message.importOptions = $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ImportAppRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ImportAppRequest} ImportAppRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportAppRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ImportAppRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ImportAppRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.gcsUri != null && message.hasOwnProperty("gcsUri")) {
                                properties.app = 1;
                                if (!$util.isString(message.gcsUri))
                                    return "gcsUri: string expected";
                            }
                            if (message.appContent != null && message.hasOwnProperty("appContent")) {
                                if (properties.app === 1)
                                    return "app: multiple values";
                                properties.app = 1;
                                if (!(message.appContent && typeof message.appContent.length === "number" || $util.isString(message.appContent)))
                                    return "appContent: buffer expected";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.appId != null && message.hasOwnProperty("appId"))
                                if (!$util.isString(message.appId))
                                    return "appId: string expected";
                            if (message.importOptions != null && message.hasOwnProperty("importOptions")) {
                                var error = $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions.verify(message.importOptions);
                                if (error)
                                    return "importOptions." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an ImportAppRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ImportAppRequest} ImportAppRequest
                         */
                        ImportAppRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ImportAppRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ImportAppRequest();
                            if (object.gcsUri != null)
                                message.gcsUri = String(object.gcsUri);
                            if (object.appContent != null)
                                if (typeof object.appContent === "string")
                                    $util.base64.decode(object.appContent, message.appContent = $util.newBuffer($util.base64.length(object.appContent)), 0);
                                else if (object.appContent.length >= 0)
                                    message.appContent = object.appContent;
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.appId != null)
                                message.appId = String(object.appId);
                            if (object.importOptions != null) {
                                if (typeof object.importOptions !== "object")
                                    throw TypeError(".google.cloud.ces.v1.ImportAppRequest.importOptions: object expected");
                                message.importOptions = $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions.fromObject(object.importOptions);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ImportAppRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @static
                         * @param {google.cloud.ces.v1.ImportAppRequest} message ImportAppRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ImportAppRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.displayName = "";
                                object.appId = "";
                                object.importOptions = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.appId != null && message.hasOwnProperty("appId"))
                                object.appId = message.appId;
                            if (message.gcsUri != null && message.hasOwnProperty("gcsUri")) {
                                object.gcsUri = message.gcsUri;
                                if (options.oneofs)
                                    object.app = "gcsUri";
                            }
                            if (message.appContent != null && message.hasOwnProperty("appContent")) {
                                object.appContent = options.bytes === String ? $util.base64.encode(message.appContent, 0, message.appContent.length) : options.bytes === Array ? Array.prototype.slice.call(message.appContent) : message.appContent;
                                if (options.oneofs)
                                    object.app = "appContent";
                            }
                            if (message.importOptions != null && message.hasOwnProperty("importOptions"))
                                object.importOptions = $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions.toObject(message.importOptions, options);
                            return object;
                        };
    
                        /**
                         * Converts this ImportAppRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ImportAppRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ImportAppRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ImportAppRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ImportAppRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ImportAppRequest";
                        };
    
                        ImportAppRequest.ImportOptions = (function() {
    
                            /**
                             * Properties of an ImportOptions.
                             * @memberof google.cloud.ces.v1.ImportAppRequest
                             * @interface IImportOptions
                             * @property {google.cloud.ces.v1.ImportAppRequest.ImportOptions.ConflictResolutionStrategy|null} [conflictResolutionStrategy] ImportOptions conflictResolutionStrategy
                             */
    
                            /**
                             * Constructs a new ImportOptions.
                             * @memberof google.cloud.ces.v1.ImportAppRequest
                             * @classdesc Represents an ImportOptions.
                             * @implements IImportOptions
                             * @constructor
                             * @param {google.cloud.ces.v1.ImportAppRequest.IImportOptions=} [properties] Properties to set
                             */
                            function ImportOptions(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * ImportOptions conflictResolutionStrategy.
                             * @member {google.cloud.ces.v1.ImportAppRequest.ImportOptions.ConflictResolutionStrategy} conflictResolutionStrategy
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @instance
                             */
                            ImportOptions.prototype.conflictResolutionStrategy = 0;
    
                            /**
                             * Creates a new ImportOptions instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @static
                             * @param {google.cloud.ces.v1.ImportAppRequest.IImportOptions=} [properties] Properties to set
                             * @returns {google.cloud.ces.v1.ImportAppRequest.ImportOptions} ImportOptions instance
                             */
                            ImportOptions.create = function create(properties) {
                                return new ImportOptions(properties);
                            };
    
                            /**
                             * Encodes the specified ImportOptions message. Does not implicitly {@link google.cloud.ces.v1.ImportAppRequest.ImportOptions.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @static
                             * @param {google.cloud.ces.v1.ImportAppRequest.IImportOptions} message ImportOptions message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            ImportOptions.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.conflictResolutionStrategy != null && Object.hasOwnProperty.call(message, "conflictResolutionStrategy"))
                                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.conflictResolutionStrategy);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified ImportOptions message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ImportAppRequest.ImportOptions.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @static
                             * @param {google.cloud.ces.v1.ImportAppRequest.IImportOptions} message ImportOptions message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            ImportOptions.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an ImportOptions message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.ces.v1.ImportAppRequest.ImportOptions} ImportOptions
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            ImportOptions.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.conflictResolutionStrategy = reader.int32();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an ImportOptions message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.ces.v1.ImportAppRequest.ImportOptions} ImportOptions
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            ImportOptions.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an ImportOptions message.
                             * @function verify
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            ImportOptions.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.conflictResolutionStrategy != null && message.hasOwnProperty("conflictResolutionStrategy"))
                                    switch (message.conflictResolutionStrategy) {
                                    default:
                                        return "conflictResolutionStrategy: enum value expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                        break;
                                    }
                                return null;
                            };
    
                            /**
                             * Creates an ImportOptions message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.ces.v1.ImportAppRequest.ImportOptions} ImportOptions
                             */
                            ImportOptions.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions)
                                    return object;
                                var message = new $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions();
                                switch (object.conflictResolutionStrategy) {
                                default:
                                    if (typeof object.conflictResolutionStrategy === "number") {
                                        message.conflictResolutionStrategy = object.conflictResolutionStrategy;
                                        break;
                                    }
                                    break;
                                case "CONFLICT_RESOLUTION_STRATEGY_UNSPECIFIED":
                                case 0:
                                    message.conflictResolutionStrategy = 0;
                                    break;
                                case "REPLACE":
                                case 1:
                                    message.conflictResolutionStrategy = 1;
                                    break;
                                case "OVERWRITE":
                                case 2:
                                    message.conflictResolutionStrategy = 2;
                                    break;
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an ImportOptions message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @static
                             * @param {google.cloud.ces.v1.ImportAppRequest.ImportOptions} message ImportOptions
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            ImportOptions.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults)
                                    object.conflictResolutionStrategy = options.enums === String ? "CONFLICT_RESOLUTION_STRATEGY_UNSPECIFIED" : 0;
                                if (message.conflictResolutionStrategy != null && message.hasOwnProperty("conflictResolutionStrategy"))
                                    object.conflictResolutionStrategy = options.enums === String ? $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions.ConflictResolutionStrategy[message.conflictResolutionStrategy] === undefined ? message.conflictResolutionStrategy : $root.google.cloud.ces.v1.ImportAppRequest.ImportOptions.ConflictResolutionStrategy[message.conflictResolutionStrategy] : message.conflictResolutionStrategy;
                                return object;
                            };
    
                            /**
                             * Converts this ImportOptions to JSON.
                             * @function toJSON
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            ImportOptions.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for ImportOptions
                             * @function getTypeUrl
                             * @memberof google.cloud.ces.v1.ImportAppRequest.ImportOptions
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            ImportOptions.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.ces.v1.ImportAppRequest.ImportOptions";
                            };
    
                            /**
                             * ConflictResolutionStrategy enum.
                             * @name google.cloud.ces.v1.ImportAppRequest.ImportOptions.ConflictResolutionStrategy
                             * @enum {number}
                             * @property {number} CONFLICT_RESOLUTION_STRATEGY_UNSPECIFIED=0 CONFLICT_RESOLUTION_STRATEGY_UNSPECIFIED value
                             * @property {number} REPLACE=1 REPLACE value
                             * @property {number} OVERWRITE=2 OVERWRITE value
                             */
                            ImportOptions.ConflictResolutionStrategy = (function() {
                                var valuesById = {}, values = Object.create(valuesById);
                                values[valuesById[0] = "CONFLICT_RESOLUTION_STRATEGY_UNSPECIFIED"] = 0;
                                values[valuesById[1] = "REPLACE"] = 1;
                                values[valuesById[2] = "OVERWRITE"] = 2;
                                return values;
                            })();
    
                            return ImportOptions;
                        })();
    
                        return ImportAppRequest;
                    })();
    
                    v1.ImportAppResponse = (function() {
    
                        /**
                         * Properties of an ImportAppResponse.
                         * @memberof google.cloud.ces.v1
                         * @interface IImportAppResponse
                         * @property {string|null} [name] ImportAppResponse name
                         * @property {Array.<string>|null} [warnings] ImportAppResponse warnings
                         */
    
                        /**
                         * Constructs a new ImportAppResponse.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an ImportAppResponse.
                         * @implements IImportAppResponse
                         * @constructor
                         * @param {google.cloud.ces.v1.IImportAppResponse=} [properties] Properties to set
                         */
                        function ImportAppResponse(properties) {
                            this.warnings = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ImportAppResponse name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @instance
                         */
                        ImportAppResponse.prototype.name = "";
    
                        /**
                         * ImportAppResponse warnings.
                         * @member {Array.<string>} warnings
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @instance
                         */
                        ImportAppResponse.prototype.warnings = $util.emptyArray;
    
                        /**
                         * Creates a new ImportAppResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @static
                         * @param {google.cloud.ces.v1.IImportAppResponse=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ImportAppResponse} ImportAppResponse instance
                         */
                        ImportAppResponse.create = function create(properties) {
                            return new ImportAppResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ImportAppResponse message. Does not implicitly {@link google.cloud.ces.v1.ImportAppResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @static
                         * @param {google.cloud.ces.v1.IImportAppResponse} message ImportAppResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportAppResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.warnings != null && message.warnings.length)
                                for (var i = 0; i < message.warnings.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.warnings[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ImportAppResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ImportAppResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @static
                         * @param {google.cloud.ces.v1.IImportAppResponse} message ImportAppResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportAppResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ImportAppResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ImportAppResponse} ImportAppResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportAppResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ImportAppResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.warnings && message.warnings.length))
                                            message.warnings = [];
                                        message.warnings.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ImportAppResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ImportAppResponse} ImportAppResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportAppResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ImportAppResponse message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ImportAppResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.warnings != null && message.hasOwnProperty("warnings")) {
                                if (!Array.isArray(message.warnings))
                                    return "warnings: array expected";
                                for (var i = 0; i < message.warnings.length; ++i)
                                    if (!$util.isString(message.warnings[i]))
                                        return "warnings: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an ImportAppResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ImportAppResponse} ImportAppResponse
                         */
                        ImportAppResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ImportAppResponse)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ImportAppResponse();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.warnings) {
                                if (!Array.isArray(object.warnings))
                                    throw TypeError(".google.cloud.ces.v1.ImportAppResponse.warnings: array expected");
                                message.warnings = [];
                                for (var i = 0; i < object.warnings.length; ++i)
                                    message.warnings[i] = String(object.warnings[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ImportAppResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @static
                         * @param {google.cloud.ces.v1.ImportAppResponse} message ImportAppResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ImportAppResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.warnings = [];
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.warnings && message.warnings.length) {
                                object.warnings = [];
                                for (var j = 0; j < message.warnings.length; ++j)
                                    object.warnings[j] = message.warnings[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ImportAppResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ImportAppResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ImportAppResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ImportAppResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ImportAppResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ImportAppResponse";
                        };
    
                        return ImportAppResponse;
                    })();
    
                    v1.ListAgentsRequest = (function() {
    
                        /**
                         * Properties of a ListAgentsRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IListAgentsRequest
                         * @property {string|null} [parent] ListAgentsRequest parent
                         * @property {number|null} [pageSize] ListAgentsRequest pageSize
                         * @property {string|null} [pageToken] ListAgentsRequest pageToken
                         * @property {string|null} [filter] ListAgentsRequest filter
                         * @property {string|null} [orderBy] ListAgentsRequest orderBy
                         */
    
                        /**
                         * Constructs a new ListAgentsRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListAgentsRequest.
                         * @implements IListAgentsRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IListAgentsRequest=} [properties] Properties to set
                         */
                        function ListAgentsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAgentsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @instance
                         */
                        ListAgentsRequest.prototype.parent = "";
    
                        /**
                         * ListAgentsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @instance
                         */
                        ListAgentsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListAgentsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @instance
                         */
                        ListAgentsRequest.prototype.pageToken = "";
    
                        /**
                         * ListAgentsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @instance
                         */
                        ListAgentsRequest.prototype.filter = "";
    
                        /**
                         * ListAgentsRequest orderBy.
                         * @member {string} orderBy
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @instance
                         */
                        ListAgentsRequest.prototype.orderBy = "";
    
                        /**
                         * Creates a new ListAgentsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListAgentsRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListAgentsRequest} ListAgentsRequest instance
                         */
                        ListAgentsRequest.create = function create(properties) {
                            return new ListAgentsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListAgentsRequest message. Does not implicitly {@link google.cloud.ces.v1.ListAgentsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListAgentsRequest} message ListAgentsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAgentsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            if (message.orderBy != null && Object.hasOwnProperty.call(message, "orderBy"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.orderBy);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAgentsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListAgentsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListAgentsRequest} message ListAgentsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAgentsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAgentsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListAgentsRequest} ListAgentsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAgentsRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListAgentsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.orderBy = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAgentsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListAgentsRequest} ListAgentsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAgentsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAgentsRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAgentsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            if (message.orderBy != null && message.hasOwnProperty("orderBy"))
                                if (!$util.isString(message.orderBy))
                                    return "orderBy: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListAgentsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListAgentsRequest} ListAgentsRequest
                         */
                        ListAgentsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListAgentsRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListAgentsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.orderBy != null)
                                message.orderBy = String(object.orderBy);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAgentsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @static
                         * @param {google.cloud.ces.v1.ListAgentsRequest} message ListAgentsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAgentsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                                object.orderBy = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            if (message.orderBy != null && message.hasOwnProperty("orderBy"))
                                object.orderBy = message.orderBy;
                            return object;
                        };
    
                        /**
                         * Converts this ListAgentsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAgentsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListAgentsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListAgentsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListAgentsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListAgentsRequest";
                        };
    
                        return ListAgentsRequest;
                    })();
    
                    v1.ListAgentsResponse = (function() {
    
                        /**
                         * Properties of a ListAgentsResponse.
                         * @memberof google.cloud.ces.v1
                         * @interface IListAgentsResponse
                         * @property {Array.<google.cloud.ces.v1.IAgent>|null} [agents] ListAgentsResponse agents
                         * @property {string|null} [nextPageToken] ListAgentsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListAgentsResponse.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListAgentsResponse.
                         * @implements IListAgentsResponse
                         * @constructor
                         * @param {google.cloud.ces.v1.IListAgentsResponse=} [properties] Properties to set
                         */
                        function ListAgentsResponse(properties) {
                            this.agents = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAgentsResponse agents.
                         * @member {Array.<google.cloud.ces.v1.IAgent>} agents
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @instance
                         */
                        ListAgentsResponse.prototype.agents = $util.emptyArray;
    
                        /**
                         * ListAgentsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @instance
                         */
                        ListAgentsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListAgentsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListAgentsResponse=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListAgentsResponse} ListAgentsResponse instance
                         */
                        ListAgentsResponse.create = function create(properties) {
                            return new ListAgentsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListAgentsResponse message. Does not implicitly {@link google.cloud.ces.v1.ListAgentsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListAgentsResponse} message ListAgentsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAgentsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.agents != null && message.agents.length)
                                for (var i = 0; i < message.agents.length; ++i)
                                    $root.google.cloud.ces.v1.Agent.encode(message.agents[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAgentsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListAgentsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListAgentsResponse} message ListAgentsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAgentsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAgentsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListAgentsResponse} ListAgentsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAgentsResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListAgentsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.agents && message.agents.length))
                                            message.agents = [];
                                        message.agents.push($root.google.cloud.ces.v1.Agent.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAgentsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListAgentsResponse} ListAgentsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAgentsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAgentsResponse message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAgentsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.agents != null && message.hasOwnProperty("agents")) {
                                if (!Array.isArray(message.agents))
                                    return "agents: array expected";
                                for (var i = 0; i < message.agents.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Agent.verify(message.agents[i]);
                                    if (error)
                                        return "agents." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListAgentsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListAgentsResponse} ListAgentsResponse
                         */
                        ListAgentsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListAgentsResponse)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListAgentsResponse();
                            if (object.agents) {
                                if (!Array.isArray(object.agents))
                                    throw TypeError(".google.cloud.ces.v1.ListAgentsResponse.agents: array expected");
                                message.agents = [];
                                for (var i = 0; i < object.agents.length; ++i) {
                                    if (typeof object.agents[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.ListAgentsResponse.agents: object expected");
                                    message.agents[i] = $root.google.cloud.ces.v1.Agent.fromObject(object.agents[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAgentsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @static
                         * @param {google.cloud.ces.v1.ListAgentsResponse} message ListAgentsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAgentsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.agents = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.agents && message.agents.length) {
                                object.agents = [];
                                for (var j = 0; j < message.agents.length; ++j)
                                    object.agents[j] = $root.google.cloud.ces.v1.Agent.toObject(message.agents[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListAgentsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAgentsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListAgentsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListAgentsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListAgentsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListAgentsResponse";
                        };
    
                        return ListAgentsResponse;
                    })();
    
                    v1.GetAgentRequest = (function() {
    
                        /**
                         * Properties of a GetAgentRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IGetAgentRequest
                         * @property {string|null} [name] GetAgentRequest name
                         */
    
                        /**
                         * Constructs a new GetAgentRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a GetAgentRequest.
                         * @implements IGetAgentRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IGetAgentRequest=} [properties] Properties to set
                         */
                        function GetAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetAgentRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @instance
                         */
                        GetAgentRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.GetAgentRequest} GetAgentRequest instance
                         */
                        GetAgentRequest.create = function create(properties) {
                            return new GetAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetAgentRequest message. Does not implicitly {@link google.cloud.ces.v1.GetAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetAgentRequest} message GetAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetAgentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.GetAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetAgentRequest} message GetAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.GetAgentRequest} GetAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAgentRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.GetAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.GetAgentRequest} GetAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.GetAgentRequest} GetAgentRequest
                         */
                        GetAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.GetAgentRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.GetAgentRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.GetAgentRequest} message GetAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetAgentRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.GetAgentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetAgentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.GetAgentRequest";
                        };
    
                        return GetAgentRequest;
                    })();
    
                    v1.CreateAgentRequest = (function() {
    
                        /**
                         * Properties of a CreateAgentRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface ICreateAgentRequest
                         * @property {string|null} [parent] CreateAgentRequest parent
                         * @property {string|null} [agentId] CreateAgentRequest agentId
                         * @property {google.cloud.ces.v1.IAgent|null} [agent] CreateAgentRequest agent
                         */
    
                        /**
                         * Constructs a new CreateAgentRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a CreateAgentRequest.
                         * @implements ICreateAgentRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.ICreateAgentRequest=} [properties] Properties to set
                         */
                        function CreateAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateAgentRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @instance
                         */
                        CreateAgentRequest.prototype.parent = "";
    
                        /**
                         * CreateAgentRequest agentId.
                         * @member {string} agentId
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @instance
                         */
                        CreateAgentRequest.prototype.agentId = "";
    
                        /**
                         * CreateAgentRequest agent.
                         * @member {google.cloud.ces.v1.IAgent|null|undefined} agent
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @instance
                         */
                        CreateAgentRequest.prototype.agent = null;
    
                        /**
                         * Creates a new CreateAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.CreateAgentRequest} CreateAgentRequest instance
                         */
                        CreateAgentRequest.create = function create(properties) {
                            return new CreateAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateAgentRequest message. Does not implicitly {@link google.cloud.ces.v1.CreateAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateAgentRequest} message CreateAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.agentId != null && Object.hasOwnProperty.call(message, "agentId"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.agentId);
                            if (message.agent != null && Object.hasOwnProperty.call(message, "agent"))
                                $root.google.cloud.ces.v1.Agent.encode(message.agent, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateAgentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.CreateAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateAgentRequest} message CreateAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.CreateAgentRequest} CreateAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateAgentRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.CreateAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.agentId = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.agent = $root.google.cloud.ces.v1.Agent.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.CreateAgentRequest} CreateAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.agentId != null && message.hasOwnProperty("agentId"))
                                if (!$util.isString(message.agentId))
                                    return "agentId: string expected";
                            if (message.agent != null && message.hasOwnProperty("agent")) {
                                var error = $root.google.cloud.ces.v1.Agent.verify(message.agent);
                                if (error)
                                    return "agent." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.CreateAgentRequest} CreateAgentRequest
                         */
                        CreateAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.CreateAgentRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.CreateAgentRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.agentId != null)
                                message.agentId = String(object.agentId);
                            if (object.agent != null) {
                                if (typeof object.agent !== "object")
                                    throw TypeError(".google.cloud.ces.v1.CreateAgentRequest.agent: object expected");
                                message.agent = $root.google.cloud.ces.v1.Agent.fromObject(object.agent);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.CreateAgentRequest} message CreateAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.agentId = "";
                                object.agent = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.agentId != null && message.hasOwnProperty("agentId"))
                                object.agentId = message.agentId;
                            if (message.agent != null && message.hasOwnProperty("agent"))
                                object.agent = $root.google.cloud.ces.v1.Agent.toObject(message.agent, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateAgentRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.CreateAgentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateAgentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.CreateAgentRequest";
                        };
    
                        return CreateAgentRequest;
                    })();
    
                    v1.UpdateAgentRequest = (function() {
    
                        /**
                         * Properties of an UpdateAgentRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IUpdateAgentRequest
                         * @property {google.cloud.ces.v1.IAgent|null} [agent] UpdateAgentRequest agent
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateAgentRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateAgentRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an UpdateAgentRequest.
                         * @implements IUpdateAgentRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IUpdateAgentRequest=} [properties] Properties to set
                         */
                        function UpdateAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateAgentRequest agent.
                         * @member {google.cloud.ces.v1.IAgent|null|undefined} agent
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @instance
                         */
                        UpdateAgentRequest.prototype.agent = null;
    
                        /**
                         * UpdateAgentRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @instance
                         */
                        UpdateAgentRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.UpdateAgentRequest} UpdateAgentRequest instance
                         */
                        UpdateAgentRequest.create = function create(properties) {
                            return new UpdateAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateAgentRequest message. Does not implicitly {@link google.cloud.ces.v1.UpdateAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateAgentRequest} message UpdateAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.agent != null && Object.hasOwnProperty.call(message, "agent"))
                                $root.google.cloud.ces.v1.Agent.encode(message.agent, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateAgentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.UpdateAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateAgentRequest} message UpdateAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.UpdateAgentRequest} UpdateAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAgentRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.UpdateAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.agent = $root.google.cloud.ces.v1.Agent.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.UpdateAgentRequest} UpdateAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.agent != null && message.hasOwnProperty("agent")) {
                                var error = $root.google.cloud.ces.v1.Agent.verify(message.agent);
                                if (error)
                                    return "agent." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.UpdateAgentRequest} UpdateAgentRequest
                         */
                        UpdateAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.UpdateAgentRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.UpdateAgentRequest();
                            if (object.agent != null) {
                                if (typeof object.agent !== "object")
                                    throw TypeError(".google.cloud.ces.v1.UpdateAgentRequest.agent: object expected");
                                message.agent = $root.google.cloud.ces.v1.Agent.fromObject(object.agent);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.ces.v1.UpdateAgentRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.UpdateAgentRequest} message UpdateAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.agent = null;
                                object.updateMask = null;
                            }
                            if (message.agent != null && message.hasOwnProperty("agent"))
                                object.agent = $root.google.cloud.ces.v1.Agent.toObject(message.agent, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateAgentRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.UpdateAgentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateAgentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.UpdateAgentRequest";
                        };
    
                        return UpdateAgentRequest;
                    })();
    
                    v1.DeleteAgentRequest = (function() {
    
                        /**
                         * Properties of a DeleteAgentRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IDeleteAgentRequest
                         * @property {string|null} [name] DeleteAgentRequest name
                         * @property {boolean|null} [force] DeleteAgentRequest force
                         * @property {string|null} [etag] DeleteAgentRequest etag
                         */
    
                        /**
                         * Constructs a new DeleteAgentRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a DeleteAgentRequest.
                         * @implements IDeleteAgentRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IDeleteAgentRequest=} [properties] Properties to set
                         */
                        function DeleteAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteAgentRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @instance
                         */
                        DeleteAgentRequest.prototype.name = "";
    
                        /**
                         * DeleteAgentRequest force.
                         * @member {boolean} force
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @instance
                         */
                        DeleteAgentRequest.prototype.force = false;
    
                        /**
                         * DeleteAgentRequest etag.
                         * @member {string} etag
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @instance
                         */
                        DeleteAgentRequest.prototype.etag = "";
    
                        /**
                         * Creates a new DeleteAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.DeleteAgentRequest} DeleteAgentRequest instance
                         */
                        DeleteAgentRequest.create = function create(properties) {
                            return new DeleteAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteAgentRequest message. Does not implicitly {@link google.cloud.ces.v1.DeleteAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteAgentRequest} message DeleteAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.force != null && Object.hasOwnProperty.call(message, "force"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.force);
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteAgentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.DeleteAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteAgentRequest} message DeleteAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.DeleteAgentRequest} DeleteAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAgentRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.DeleteAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.force = reader.bool();
                                        break;
                                    }
                                case 3: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.DeleteAgentRequest} DeleteAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.force != null && message.hasOwnProperty("force"))
                                if (typeof message.force !== "boolean")
                                    return "force: boolean expected";
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.DeleteAgentRequest} DeleteAgentRequest
                         */
                        DeleteAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.DeleteAgentRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.DeleteAgentRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.force != null)
                                message.force = Boolean(object.force);
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @static
                         * @param {google.cloud.ces.v1.DeleteAgentRequest} message DeleteAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.force = false;
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.force != null && message.hasOwnProperty("force"))
                                object.force = message.force;
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteAgentRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.DeleteAgentRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteAgentRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.DeleteAgentRequest";
                        };
    
                        return DeleteAgentRequest;
                    })();
    
                    v1.OperationMetadata = (function() {
    
                        /**
                         * Properties of an OperationMetadata.
                         * @memberof google.cloud.ces.v1
                         * @interface IOperationMetadata
                         * @property {google.protobuf.ITimestamp|null} [createTime] OperationMetadata createTime
                         * @property {google.protobuf.ITimestamp|null} [endTime] OperationMetadata endTime
                         * @property {string|null} [statusMessage] OperationMetadata statusMessage
                         * @property {boolean|null} [requestedCancellation] OperationMetadata requestedCancellation
                         */
    
                        /**
                         * Constructs a new OperationMetadata.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an OperationMetadata.
                         * @implements IOperationMetadata
                         * @constructor
                         * @param {google.cloud.ces.v1.IOperationMetadata=} [properties] Properties to set
                         */
                        function OperationMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * OperationMetadata createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @instance
                         */
                        OperationMetadata.prototype.createTime = null;
    
                        /**
                         * OperationMetadata endTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} endTime
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @instance
                         */
                        OperationMetadata.prototype.endTime = null;
    
                        /**
                         * OperationMetadata statusMessage.
                         * @member {string} statusMessage
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @instance
                         */
                        OperationMetadata.prototype.statusMessage = "";
    
                        /**
                         * OperationMetadata requestedCancellation.
                         * @member {boolean} requestedCancellation
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @instance
                         */
                        OperationMetadata.prototype.requestedCancellation = false;
    
                        /**
                         * Creates a new OperationMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @static
                         * @param {google.cloud.ces.v1.IOperationMetadata=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.OperationMetadata} OperationMetadata instance
                         */
                        OperationMetadata.create = function create(properties) {
                            return new OperationMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified OperationMetadata message. Does not implicitly {@link google.cloud.ces.v1.OperationMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @static
                         * @param {google.cloud.ces.v1.IOperationMetadata} message OperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.endTime != null && Object.hasOwnProperty.call(message, "endTime"))
                                $root.google.protobuf.Timestamp.encode(message.endTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.statusMessage != null && Object.hasOwnProperty.call(message, "statusMessage"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.statusMessage);
                            if (message.requestedCancellation != null && Object.hasOwnProperty.call(message, "requestedCancellation"))
                                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.requestedCancellation);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified OperationMetadata message, length delimited. Does not implicitly {@link google.cloud.ces.v1.OperationMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @static
                         * @param {google.cloud.ces.v1.IOperationMetadata} message OperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an OperationMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.OperationMetadata} OperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationMetadata.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.OperationMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.endTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.statusMessage = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.requestedCancellation = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an OperationMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.OperationMetadata} OperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an OperationMetadata message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OperationMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.endTime != null && message.hasOwnProperty("endTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.endTime);
                                if (error)
                                    return "endTime." + error;
                            }
                            if (message.statusMessage != null && message.hasOwnProperty("statusMessage"))
                                if (!$util.isString(message.statusMessage))
                                    return "statusMessage: string expected";
                            if (message.requestedCancellation != null && message.hasOwnProperty("requestedCancellation"))
                                if (typeof message.requestedCancellation !== "boolean")
                                    return "requestedCancellation: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates an OperationMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.OperationMetadata} OperationMetadata
                         */
                        OperationMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.OperationMetadata)
                                return object;
                            var message = new $root.google.cloud.ces.v1.OperationMetadata();
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.ces.v1.OperationMetadata.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.endTime != null) {
                                if (typeof object.endTime !== "object")
                                    throw TypeError(".google.cloud.ces.v1.OperationMetadata.endTime: object expected");
                                message.endTime = $root.google.protobuf.Timestamp.fromObject(object.endTime);
                            }
                            if (object.statusMessage != null)
                                message.statusMessage = String(object.statusMessage);
                            if (object.requestedCancellation != null)
                                message.requestedCancellation = Boolean(object.requestedCancellation);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an OperationMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @static
                         * @param {google.cloud.ces.v1.OperationMetadata} message OperationMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OperationMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.createTime = null;
                                object.endTime = null;
                                object.statusMessage = "";
                                object.requestedCancellation = false;
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.endTime != null && message.hasOwnProperty("endTime"))
                                object.endTime = $root.google.protobuf.Timestamp.toObject(message.endTime, options);
                            if (message.statusMessage != null && message.hasOwnProperty("statusMessage"))
                                object.statusMessage = message.statusMessage;
                            if (message.requestedCancellation != null && message.hasOwnProperty("requestedCancellation"))
                                object.requestedCancellation = message.requestedCancellation;
                            return object;
                        };
    
                        /**
                         * Converts this OperationMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OperationMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for OperationMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.OperationMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        OperationMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.OperationMetadata";
                        };
    
                        return OperationMetadata;
                    })();
    
                    v1.ListExamplesRequest = (function() {
    
                        /**
                         * Properties of a ListExamplesRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IListExamplesRequest
                         * @property {string|null} [parent] ListExamplesRequest parent
                         * @property {number|null} [pageSize] ListExamplesRequest pageSize
                         * @property {string|null} [pageToken] ListExamplesRequest pageToken
                         * @property {string|null} [filter] ListExamplesRequest filter
                         * @property {string|null} [orderBy] ListExamplesRequest orderBy
                         */
    
                        /**
                         * Constructs a new ListExamplesRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListExamplesRequest.
                         * @implements IListExamplesRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IListExamplesRequest=} [properties] Properties to set
                         */
                        function ListExamplesRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListExamplesRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @instance
                         */
                        ListExamplesRequest.prototype.parent = "";
    
                        /**
                         * ListExamplesRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @instance
                         */
                        ListExamplesRequest.prototype.pageSize = 0;
    
                        /**
                         * ListExamplesRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @instance
                         */
                        ListExamplesRequest.prototype.pageToken = "";
    
                        /**
                         * ListExamplesRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @instance
                         */
                        ListExamplesRequest.prototype.filter = "";
    
                        /**
                         * ListExamplesRequest orderBy.
                         * @member {string} orderBy
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @instance
                         */
                        ListExamplesRequest.prototype.orderBy = "";
    
                        /**
                         * Creates a new ListExamplesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListExamplesRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListExamplesRequest} ListExamplesRequest instance
                         */
                        ListExamplesRequest.create = function create(properties) {
                            return new ListExamplesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListExamplesRequest message. Does not implicitly {@link google.cloud.ces.v1.ListExamplesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListExamplesRequest} message ListExamplesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListExamplesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            if (message.orderBy != null && Object.hasOwnProperty.call(message, "orderBy"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.orderBy);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListExamplesRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListExamplesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListExamplesRequest} message ListExamplesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListExamplesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListExamplesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListExamplesRequest} ListExamplesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListExamplesRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListExamplesRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.orderBy = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListExamplesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListExamplesRequest} ListExamplesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListExamplesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListExamplesRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListExamplesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            if (message.orderBy != null && message.hasOwnProperty("orderBy"))
                                if (!$util.isString(message.orderBy))
                                    return "orderBy: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListExamplesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListExamplesRequest} ListExamplesRequest
                         */
                        ListExamplesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListExamplesRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListExamplesRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.orderBy != null)
                                message.orderBy = String(object.orderBy);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListExamplesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @static
                         * @param {google.cloud.ces.v1.ListExamplesRequest} message ListExamplesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListExamplesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                                object.orderBy = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            if (message.orderBy != null && message.hasOwnProperty("orderBy"))
                                object.orderBy = message.orderBy;
                            return object;
                        };
    
                        /**
                         * Converts this ListExamplesRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListExamplesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListExamplesRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListExamplesRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListExamplesRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListExamplesRequest";
                        };
    
                        return ListExamplesRequest;
                    })();
    
                    v1.ListExamplesResponse = (function() {
    
                        /**
                         * Properties of a ListExamplesResponse.
                         * @memberof google.cloud.ces.v1
                         * @interface IListExamplesResponse
                         * @property {Array.<google.cloud.ces.v1.IExample>|null} [examples] ListExamplesResponse examples
                         * @property {string|null} [nextPageToken] ListExamplesResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListExamplesResponse.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListExamplesResponse.
                         * @implements IListExamplesResponse
                         * @constructor
                         * @param {google.cloud.ces.v1.IListExamplesResponse=} [properties] Properties to set
                         */
                        function ListExamplesResponse(properties) {
                            this.examples = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListExamplesResponse examples.
                         * @member {Array.<google.cloud.ces.v1.IExample>} examples
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @instance
                         */
                        ListExamplesResponse.prototype.examples = $util.emptyArray;
    
                        /**
                         * ListExamplesResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @instance
                         */
                        ListExamplesResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListExamplesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListExamplesResponse=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListExamplesResponse} ListExamplesResponse instance
                         */
                        ListExamplesResponse.create = function create(properties) {
                            return new ListExamplesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListExamplesResponse message. Does not implicitly {@link google.cloud.ces.v1.ListExamplesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListExamplesResponse} message ListExamplesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListExamplesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.examples != null && message.examples.length)
                                for (var i = 0; i < message.examples.length; ++i)
                                    $root.google.cloud.ces.v1.Example.encode(message.examples[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListExamplesResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListExamplesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListExamplesResponse} message ListExamplesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListExamplesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListExamplesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListExamplesResponse} ListExamplesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListExamplesResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListExamplesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.examples && message.examples.length))
                                            message.examples = [];
                                        message.examples.push($root.google.cloud.ces.v1.Example.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListExamplesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListExamplesResponse} ListExamplesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListExamplesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListExamplesResponse message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListExamplesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.examples != null && message.hasOwnProperty("examples")) {
                                if (!Array.isArray(message.examples))
                                    return "examples: array expected";
                                for (var i = 0; i < message.examples.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Example.verify(message.examples[i]);
                                    if (error)
                                        return "examples." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListExamplesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListExamplesResponse} ListExamplesResponse
                         */
                        ListExamplesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListExamplesResponse)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListExamplesResponse();
                            if (object.examples) {
                                if (!Array.isArray(object.examples))
                                    throw TypeError(".google.cloud.ces.v1.ListExamplesResponse.examples: array expected");
                                message.examples = [];
                                for (var i = 0; i < object.examples.length; ++i) {
                                    if (typeof object.examples[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.ListExamplesResponse.examples: object expected");
                                    message.examples[i] = $root.google.cloud.ces.v1.Example.fromObject(object.examples[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListExamplesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @static
                         * @param {google.cloud.ces.v1.ListExamplesResponse} message ListExamplesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListExamplesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.examples = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.examples && message.examples.length) {
                                object.examples = [];
                                for (var j = 0; j < message.examples.length; ++j)
                                    object.examples[j] = $root.google.cloud.ces.v1.Example.toObject(message.examples[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListExamplesResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListExamplesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListExamplesResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListExamplesResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListExamplesResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListExamplesResponse";
                        };
    
                        return ListExamplesResponse;
                    })();
    
                    v1.GetExampleRequest = (function() {
    
                        /**
                         * Properties of a GetExampleRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IGetExampleRequest
                         * @property {string|null} [name] GetExampleRequest name
                         */
    
                        /**
                         * Constructs a new GetExampleRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a GetExampleRequest.
                         * @implements IGetExampleRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IGetExampleRequest=} [properties] Properties to set
                         */
                        function GetExampleRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetExampleRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @instance
                         */
                        GetExampleRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetExampleRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetExampleRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.GetExampleRequest} GetExampleRequest instance
                         */
                        GetExampleRequest.create = function create(properties) {
                            return new GetExampleRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetExampleRequest message. Does not implicitly {@link google.cloud.ces.v1.GetExampleRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetExampleRequest} message GetExampleRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetExampleRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetExampleRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.GetExampleRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetExampleRequest} message GetExampleRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetExampleRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetExampleRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.GetExampleRequest} GetExampleRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetExampleRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.GetExampleRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetExampleRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.GetExampleRequest} GetExampleRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetExampleRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetExampleRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetExampleRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetExampleRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.GetExampleRequest} GetExampleRequest
                         */
                        GetExampleRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.GetExampleRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.GetExampleRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetExampleRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.GetExampleRequest} message GetExampleRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetExampleRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetExampleRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetExampleRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetExampleRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.GetExampleRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetExampleRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.GetExampleRequest";
                        };
    
                        return GetExampleRequest;
                    })();
    
                    v1.CreateExampleRequest = (function() {
    
                        /**
                         * Properties of a CreateExampleRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface ICreateExampleRequest
                         * @property {string|null} [parent] CreateExampleRequest parent
                         * @property {string|null} [exampleId] CreateExampleRequest exampleId
                         * @property {google.cloud.ces.v1.IExample|null} [example] CreateExampleRequest example
                         */
    
                        /**
                         * Constructs a new CreateExampleRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a CreateExampleRequest.
                         * @implements ICreateExampleRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.ICreateExampleRequest=} [properties] Properties to set
                         */
                        function CreateExampleRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateExampleRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @instance
                         */
                        CreateExampleRequest.prototype.parent = "";
    
                        /**
                         * CreateExampleRequest exampleId.
                         * @member {string} exampleId
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @instance
                         */
                        CreateExampleRequest.prototype.exampleId = "";
    
                        /**
                         * CreateExampleRequest example.
                         * @member {google.cloud.ces.v1.IExample|null|undefined} example
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @instance
                         */
                        CreateExampleRequest.prototype.example = null;
    
                        /**
                         * Creates a new CreateExampleRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateExampleRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.CreateExampleRequest} CreateExampleRequest instance
                         */
                        CreateExampleRequest.create = function create(properties) {
                            return new CreateExampleRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateExampleRequest message. Does not implicitly {@link google.cloud.ces.v1.CreateExampleRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateExampleRequest} message CreateExampleRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateExampleRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.exampleId != null && Object.hasOwnProperty.call(message, "exampleId"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.exampleId);
                            if (message.example != null && Object.hasOwnProperty.call(message, "example"))
                                $root.google.cloud.ces.v1.Example.encode(message.example, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateExampleRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.CreateExampleRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateExampleRequest} message CreateExampleRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateExampleRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateExampleRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.CreateExampleRequest} CreateExampleRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateExampleRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.CreateExampleRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.exampleId = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.example = $root.google.cloud.ces.v1.Example.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateExampleRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.CreateExampleRequest} CreateExampleRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateExampleRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateExampleRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateExampleRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.exampleId != null && message.hasOwnProperty("exampleId"))
                                if (!$util.isString(message.exampleId))
                                    return "exampleId: string expected";
                            if (message.example != null && message.hasOwnProperty("example")) {
                                var error = $root.google.cloud.ces.v1.Example.verify(message.example);
                                if (error)
                                    return "example." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateExampleRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.CreateExampleRequest} CreateExampleRequest
                         */
                        CreateExampleRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.CreateExampleRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.CreateExampleRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.exampleId != null)
                                message.exampleId = String(object.exampleId);
                            if (object.example != null) {
                                if (typeof object.example !== "object")
                                    throw TypeError(".google.cloud.ces.v1.CreateExampleRequest.example: object expected");
                                message.example = $root.google.cloud.ces.v1.Example.fromObject(object.example);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateExampleRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.CreateExampleRequest} message CreateExampleRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateExampleRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.exampleId = "";
                                object.example = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.exampleId != null && message.hasOwnProperty("exampleId"))
                                object.exampleId = message.exampleId;
                            if (message.example != null && message.hasOwnProperty("example"))
                                object.example = $root.google.cloud.ces.v1.Example.toObject(message.example, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateExampleRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateExampleRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateExampleRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.CreateExampleRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateExampleRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.CreateExampleRequest";
                        };
    
                        return CreateExampleRequest;
                    })();
    
                    v1.UpdateExampleRequest = (function() {
    
                        /**
                         * Properties of an UpdateExampleRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IUpdateExampleRequest
                         * @property {google.cloud.ces.v1.IExample|null} [example] UpdateExampleRequest example
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateExampleRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateExampleRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an UpdateExampleRequest.
                         * @implements IUpdateExampleRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IUpdateExampleRequest=} [properties] Properties to set
                         */
                        function UpdateExampleRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateExampleRequest example.
                         * @member {google.cloud.ces.v1.IExample|null|undefined} example
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @instance
                         */
                        UpdateExampleRequest.prototype.example = null;
    
                        /**
                         * UpdateExampleRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @instance
                         */
                        UpdateExampleRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateExampleRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateExampleRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.UpdateExampleRequest} UpdateExampleRequest instance
                         */
                        UpdateExampleRequest.create = function create(properties) {
                            return new UpdateExampleRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateExampleRequest message. Does not implicitly {@link google.cloud.ces.v1.UpdateExampleRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateExampleRequest} message UpdateExampleRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateExampleRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.example != null && Object.hasOwnProperty.call(message, "example"))
                                $root.google.cloud.ces.v1.Example.encode(message.example, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateExampleRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.UpdateExampleRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateExampleRequest} message UpdateExampleRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateExampleRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateExampleRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.UpdateExampleRequest} UpdateExampleRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateExampleRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.UpdateExampleRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.example = $root.google.cloud.ces.v1.Example.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateExampleRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.UpdateExampleRequest} UpdateExampleRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateExampleRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateExampleRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateExampleRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.example != null && message.hasOwnProperty("example")) {
                                var error = $root.google.cloud.ces.v1.Example.verify(message.example);
                                if (error)
                                    return "example." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateExampleRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.UpdateExampleRequest} UpdateExampleRequest
                         */
                        UpdateExampleRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.UpdateExampleRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.UpdateExampleRequest();
                            if (object.example != null) {
                                if (typeof object.example !== "object")
                                    throw TypeError(".google.cloud.ces.v1.UpdateExampleRequest.example: object expected");
                                message.example = $root.google.cloud.ces.v1.Example.fromObject(object.example);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.ces.v1.UpdateExampleRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateExampleRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.UpdateExampleRequest} message UpdateExampleRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateExampleRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.example = null;
                                object.updateMask = null;
                            }
                            if (message.example != null && message.hasOwnProperty("example"))
                                object.example = $root.google.cloud.ces.v1.Example.toObject(message.example, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateExampleRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateExampleRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateExampleRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.UpdateExampleRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateExampleRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.UpdateExampleRequest";
                        };
    
                        return UpdateExampleRequest;
                    })();
    
                    v1.DeleteExampleRequest = (function() {
    
                        /**
                         * Properties of a DeleteExampleRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IDeleteExampleRequest
                         * @property {string|null} [name] DeleteExampleRequest name
                         * @property {string|null} [etag] DeleteExampleRequest etag
                         */
    
                        /**
                         * Constructs a new DeleteExampleRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a DeleteExampleRequest.
                         * @implements IDeleteExampleRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IDeleteExampleRequest=} [properties] Properties to set
                         */
                        function DeleteExampleRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteExampleRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @instance
                         */
                        DeleteExampleRequest.prototype.name = "";
    
                        /**
                         * DeleteExampleRequest etag.
                         * @member {string} etag
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @instance
                         */
                        DeleteExampleRequest.prototype.etag = "";
    
                        /**
                         * Creates a new DeleteExampleRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteExampleRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.DeleteExampleRequest} DeleteExampleRequest instance
                         */
                        DeleteExampleRequest.create = function create(properties) {
                            return new DeleteExampleRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteExampleRequest message. Does not implicitly {@link google.cloud.ces.v1.DeleteExampleRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteExampleRequest} message DeleteExampleRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteExampleRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteExampleRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.DeleteExampleRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteExampleRequest} message DeleteExampleRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteExampleRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteExampleRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.DeleteExampleRequest} DeleteExampleRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteExampleRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.DeleteExampleRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteExampleRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.DeleteExampleRequest} DeleteExampleRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteExampleRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteExampleRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteExampleRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteExampleRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.DeleteExampleRequest} DeleteExampleRequest
                         */
                        DeleteExampleRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.DeleteExampleRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.DeleteExampleRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteExampleRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @static
                         * @param {google.cloud.ces.v1.DeleteExampleRequest} message DeleteExampleRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteExampleRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteExampleRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteExampleRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteExampleRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.DeleteExampleRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteExampleRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.DeleteExampleRequest";
                        };
    
                        return DeleteExampleRequest;
                    })();
    
                    v1.ListToolsRequest = (function() {
    
                        /**
                         * Properties of a ListToolsRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IListToolsRequest
                         * @property {string|null} [parent] ListToolsRequest parent
                         * @property {number|null} [pageSize] ListToolsRequest pageSize
                         * @property {string|null} [pageToken] ListToolsRequest pageToken
                         * @property {string|null} [filter] ListToolsRequest filter
                         * @property {string|null} [orderBy] ListToolsRequest orderBy
                         */
    
                        /**
                         * Constructs a new ListToolsRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListToolsRequest.
                         * @implements IListToolsRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IListToolsRequest=} [properties] Properties to set
                         */
                        function ListToolsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListToolsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @instance
                         */
                        ListToolsRequest.prototype.parent = "";
    
                        /**
                         * ListToolsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @instance
                         */
                        ListToolsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListToolsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @instance
                         */
                        ListToolsRequest.prototype.pageToken = "";
    
                        /**
                         * ListToolsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @instance
                         */
                        ListToolsRequest.prototype.filter = "";
    
                        /**
                         * ListToolsRequest orderBy.
                         * @member {string} orderBy
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @instance
                         */
                        ListToolsRequest.prototype.orderBy = "";
    
                        /**
                         * Creates a new ListToolsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListToolsRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListToolsRequest} ListToolsRequest instance
                         */
                        ListToolsRequest.create = function create(properties) {
                            return new ListToolsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListToolsRequest message. Does not implicitly {@link google.cloud.ces.v1.ListToolsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListToolsRequest} message ListToolsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListToolsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            if (message.orderBy != null && Object.hasOwnProperty.call(message, "orderBy"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.orderBy);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListToolsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListToolsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListToolsRequest} message ListToolsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListToolsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListToolsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListToolsRequest} ListToolsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListToolsRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListToolsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.orderBy = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListToolsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListToolsRequest} ListToolsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListToolsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListToolsRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListToolsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            if (message.orderBy != null && message.hasOwnProperty("orderBy"))
                                if (!$util.isString(message.orderBy))
                                    return "orderBy: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListToolsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListToolsRequest} ListToolsRequest
                         */
                        ListToolsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListToolsRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListToolsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.orderBy != null)
                                message.orderBy = String(object.orderBy);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListToolsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @static
                         * @param {google.cloud.ces.v1.ListToolsRequest} message ListToolsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListToolsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                                object.orderBy = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            if (message.orderBy != null && message.hasOwnProperty("orderBy"))
                                object.orderBy = message.orderBy;
                            return object;
                        };
    
                        /**
                         * Converts this ListToolsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListToolsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListToolsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListToolsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListToolsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListToolsRequest";
                        };
    
                        return ListToolsRequest;
                    })();
    
                    v1.ListToolsResponse = (function() {
    
                        /**
                         * Properties of a ListToolsResponse.
                         * @memberof google.cloud.ces.v1
                         * @interface IListToolsResponse
                         * @property {Array.<google.cloud.ces.v1.ITool>|null} [tools] ListToolsResponse tools
                         * @property {string|null} [nextPageToken] ListToolsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListToolsResponse.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListToolsResponse.
                         * @implements IListToolsResponse
                         * @constructor
                         * @param {google.cloud.ces.v1.IListToolsResponse=} [properties] Properties to set
                         */
                        function ListToolsResponse(properties) {
                            this.tools = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListToolsResponse tools.
                         * @member {Array.<google.cloud.ces.v1.ITool>} tools
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @instance
                         */
                        ListToolsResponse.prototype.tools = $util.emptyArray;
    
                        /**
                         * ListToolsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @instance
                         */
                        ListToolsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListToolsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListToolsResponse=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListToolsResponse} ListToolsResponse instance
                         */
                        ListToolsResponse.create = function create(properties) {
                            return new ListToolsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListToolsResponse message. Does not implicitly {@link google.cloud.ces.v1.ListToolsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListToolsResponse} message ListToolsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListToolsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.tools != null && message.tools.length)
                                for (var i = 0; i < message.tools.length; ++i)
                                    $root.google.cloud.ces.v1.Tool.encode(message.tools[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListToolsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListToolsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListToolsResponse} message ListToolsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListToolsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListToolsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListToolsResponse} ListToolsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListToolsResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListToolsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.tools && message.tools.length))
                                            message.tools = [];
                                        message.tools.push($root.google.cloud.ces.v1.Tool.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListToolsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListToolsResponse} ListToolsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListToolsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListToolsResponse message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListToolsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.tools != null && message.hasOwnProperty("tools")) {
                                if (!Array.isArray(message.tools))
                                    return "tools: array expected";
                                for (var i = 0; i < message.tools.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Tool.verify(message.tools[i]);
                                    if (error)
                                        return "tools." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListToolsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListToolsResponse} ListToolsResponse
                         */
                        ListToolsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListToolsResponse)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListToolsResponse();
                            if (object.tools) {
                                if (!Array.isArray(object.tools))
                                    throw TypeError(".google.cloud.ces.v1.ListToolsResponse.tools: array expected");
                                message.tools = [];
                                for (var i = 0; i < object.tools.length; ++i) {
                                    if (typeof object.tools[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.ListToolsResponse.tools: object expected");
                                    message.tools[i] = $root.google.cloud.ces.v1.Tool.fromObject(object.tools[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListToolsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @static
                         * @param {google.cloud.ces.v1.ListToolsResponse} message ListToolsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListToolsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.tools = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.tools && message.tools.length) {
                                object.tools = [];
                                for (var j = 0; j < message.tools.length; ++j)
                                    object.tools[j] = $root.google.cloud.ces.v1.Tool.toObject(message.tools[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListToolsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListToolsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListToolsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListToolsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListToolsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListToolsResponse";
                        };
    
                        return ListToolsResponse;
                    })();
    
                    v1.GetToolRequest = (function() {
    
                        /**
                         * Properties of a GetToolRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IGetToolRequest
                         * @property {string|null} [name] GetToolRequest name
                         */
    
                        /**
                         * Constructs a new GetToolRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a GetToolRequest.
                         * @implements IGetToolRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IGetToolRequest=} [properties] Properties to set
                         */
                        function GetToolRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetToolRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @instance
                         */
                        GetToolRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetToolRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetToolRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.GetToolRequest} GetToolRequest instance
                         */
                        GetToolRequest.create = function create(properties) {
                            return new GetToolRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetToolRequest message. Does not implicitly {@link google.cloud.ces.v1.GetToolRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetToolRequest} message GetToolRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetToolRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetToolRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.GetToolRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetToolRequest} message GetToolRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetToolRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetToolRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.GetToolRequest} GetToolRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetToolRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.GetToolRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetToolRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.GetToolRequest} GetToolRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetToolRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetToolRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetToolRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetToolRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.GetToolRequest} GetToolRequest
                         */
                        GetToolRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.GetToolRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.GetToolRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetToolRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.GetToolRequest} message GetToolRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetToolRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetToolRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetToolRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetToolRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.GetToolRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetToolRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.GetToolRequest";
                        };
    
                        return GetToolRequest;
                    })();
    
                    v1.CreateToolRequest = (function() {
    
                        /**
                         * Properties of a CreateToolRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface ICreateToolRequest
                         * @property {string|null} [parent] CreateToolRequest parent
                         * @property {string|null} [toolId] CreateToolRequest toolId
                         * @property {google.cloud.ces.v1.ITool|null} [tool] CreateToolRequest tool
                         */
    
                        /**
                         * Constructs a new CreateToolRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a CreateToolRequest.
                         * @implements ICreateToolRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.ICreateToolRequest=} [properties] Properties to set
                         */
                        function CreateToolRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateToolRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @instance
                         */
                        CreateToolRequest.prototype.parent = "";
    
                        /**
                         * CreateToolRequest toolId.
                         * @member {string} toolId
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @instance
                         */
                        CreateToolRequest.prototype.toolId = "";
    
                        /**
                         * CreateToolRequest tool.
                         * @member {google.cloud.ces.v1.ITool|null|undefined} tool
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @instance
                         */
                        CreateToolRequest.prototype.tool = null;
    
                        /**
                         * Creates a new CreateToolRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateToolRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.CreateToolRequest} CreateToolRequest instance
                         */
                        CreateToolRequest.create = function create(properties) {
                            return new CreateToolRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateToolRequest message. Does not implicitly {@link google.cloud.ces.v1.CreateToolRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateToolRequest} message CreateToolRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateToolRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.toolId != null && Object.hasOwnProperty.call(message, "toolId"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.toolId);
                            if (message.tool != null && Object.hasOwnProperty.call(message, "tool"))
                                $root.google.cloud.ces.v1.Tool.encode(message.tool, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateToolRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.CreateToolRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.ICreateToolRequest} message CreateToolRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateToolRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateToolRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.CreateToolRequest} CreateToolRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateToolRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.CreateToolRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.toolId = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.tool = $root.google.cloud.ces.v1.Tool.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateToolRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.CreateToolRequest} CreateToolRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateToolRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateToolRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateToolRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.toolId != null && message.hasOwnProperty("toolId"))
                                if (!$util.isString(message.toolId))
                                    return "toolId: string expected";
                            if (message.tool != null && message.hasOwnProperty("tool")) {
                                var error = $root.google.cloud.ces.v1.Tool.verify(message.tool);
                                if (error)
                                    return "tool." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateToolRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.CreateToolRequest} CreateToolRequest
                         */
                        CreateToolRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.CreateToolRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.CreateToolRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.toolId != null)
                                message.toolId = String(object.toolId);
                            if (object.tool != null) {
                                if (typeof object.tool !== "object")
                                    throw TypeError(".google.cloud.ces.v1.CreateToolRequest.tool: object expected");
                                message.tool = $root.google.cloud.ces.v1.Tool.fromObject(object.tool);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateToolRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.CreateToolRequest} message CreateToolRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateToolRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.toolId = "";
                                object.tool = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.toolId != null && message.hasOwnProperty("toolId"))
                                object.toolId = message.toolId;
                            if (message.tool != null && message.hasOwnProperty("tool"))
                                object.tool = $root.google.cloud.ces.v1.Tool.toObject(message.tool, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateToolRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateToolRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateToolRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.CreateToolRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateToolRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.CreateToolRequest";
                        };
    
                        return CreateToolRequest;
                    })();
    
                    v1.UpdateToolRequest = (function() {
    
                        /**
                         * Properties of an UpdateToolRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IUpdateToolRequest
                         * @property {google.cloud.ces.v1.ITool|null} [tool] UpdateToolRequest tool
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateToolRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateToolRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents an UpdateToolRequest.
                         * @implements IUpdateToolRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IUpdateToolRequest=} [properties] Properties to set
                         */
                        function UpdateToolRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateToolRequest tool.
                         * @member {google.cloud.ces.v1.ITool|null|undefined} tool
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @instance
                         */
                        UpdateToolRequest.prototype.tool = null;
    
                        /**
                         * UpdateToolRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @instance
                         */
                        UpdateToolRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateToolRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateToolRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.UpdateToolRequest} UpdateToolRequest instance
                         */
                        UpdateToolRequest.create = function create(properties) {
                            return new UpdateToolRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateToolRequest message. Does not implicitly {@link google.cloud.ces.v1.UpdateToolRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateToolRequest} message UpdateToolRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateToolRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.tool != null && Object.hasOwnProperty.call(message, "tool"))
                                $root.google.cloud.ces.v1.Tool.encode(message.tool, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateToolRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.UpdateToolRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.IUpdateToolRequest} message UpdateToolRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateToolRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateToolRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.UpdateToolRequest} UpdateToolRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateToolRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.UpdateToolRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.tool = $root.google.cloud.ces.v1.Tool.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateToolRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.UpdateToolRequest} UpdateToolRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateToolRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateToolRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateToolRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.tool != null && message.hasOwnProperty("tool")) {
                                var error = $root.google.cloud.ces.v1.Tool.verify(message.tool);
                                if (error)
                                    return "tool." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateToolRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.UpdateToolRequest} UpdateToolRequest
                         */
                        UpdateToolRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.UpdateToolRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.UpdateToolRequest();
                            if (object.tool != null) {
                                if (typeof object.tool !== "object")
                                    throw TypeError(".google.cloud.ces.v1.UpdateToolRequest.tool: object expected");
                                message.tool = $root.google.cloud.ces.v1.Tool.fromObject(object.tool);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.ces.v1.UpdateToolRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateToolRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.UpdateToolRequest} message UpdateToolRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateToolRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.tool = null;
                                object.updateMask = null;
                            }
                            if (message.tool != null && message.hasOwnProperty("tool"))
                                object.tool = $root.google.cloud.ces.v1.Tool.toObject(message.tool, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateToolRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateToolRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateToolRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.UpdateToolRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateToolRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.UpdateToolRequest";
                        };
    
                        return UpdateToolRequest;
                    })();
    
                    v1.DeleteToolRequest = (function() {
    
                        /**
                         * Properties of a DeleteToolRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IDeleteToolRequest
                         * @property {string|null} [name] DeleteToolRequest name
                         * @property {boolean|null} [force] DeleteToolRequest force
                         * @property {string|null} [etag] DeleteToolRequest etag
                         */
    
                        /**
                         * Constructs a new DeleteToolRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a DeleteToolRequest.
                         * @implements IDeleteToolRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IDeleteToolRequest=} [properties] Properties to set
                         */
                        function DeleteToolRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteToolRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @instance
                         */
                        DeleteToolRequest.prototype.name = "";
    
                        /**
                         * DeleteToolRequest force.
                         * @member {boolean} force
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @instance
                         */
                        DeleteToolRequest.prototype.force = false;
    
                        /**
                         * DeleteToolRequest etag.
                         * @member {string} etag
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @instance
                         */
                        DeleteToolRequest.prototype.etag = "";
    
                        /**
                         * Creates a new DeleteToolRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteToolRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.DeleteToolRequest} DeleteToolRequest instance
                         */
                        DeleteToolRequest.create = function create(properties) {
                            return new DeleteToolRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteToolRequest message. Does not implicitly {@link google.cloud.ces.v1.DeleteToolRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteToolRequest} message DeleteToolRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteToolRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.force != null && Object.hasOwnProperty.call(message, "force"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.force);
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteToolRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.DeleteToolRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteToolRequest} message DeleteToolRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteToolRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteToolRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.DeleteToolRequest} DeleteToolRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteToolRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.DeleteToolRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.force = reader.bool();
                                        break;
                                    }
                                case 3: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteToolRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.DeleteToolRequest} DeleteToolRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteToolRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteToolRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteToolRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.force != null && message.hasOwnProperty("force"))
                                if (typeof message.force !== "boolean")
                                    return "force: boolean expected";
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteToolRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.DeleteToolRequest} DeleteToolRequest
                         */
                        DeleteToolRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.DeleteToolRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.DeleteToolRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.force != null)
                                message.force = Boolean(object.force);
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteToolRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @static
                         * @param {google.cloud.ces.v1.DeleteToolRequest} message DeleteToolRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteToolRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.force = false;
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.force != null && message.hasOwnProperty("force"))
                                object.force = message.force;
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteToolRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteToolRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteToolRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.DeleteToolRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteToolRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.DeleteToolRequest";
                        };
    
                        return DeleteToolRequest;
                    })();
    
                    v1.ListConversationsRequest = (function() {
    
                        /**
                         * Properties of a ListConversationsRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IListConversationsRequest
                         * @property {string|null} [parent] ListConversationsRequest parent
                         * @property {number|null} [pageSize] ListConversationsRequest pageSize
                         * @property {string|null} [pageToken] ListConversationsRequest pageToken
                         * @property {string|null} [filter] ListConversationsRequest filter
                         * @property {google.cloud.ces.v1.Conversation.Source|null} [source] ListConversationsRequest source
                         */
    
                        /**
                         * Constructs a new ListConversationsRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListConversationsRequest.
                         * @implements IListConversationsRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IListConversationsRequest=} [properties] Properties to set
                         */
                        function ListConversationsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListConversationsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @instance
                         */
                        ListConversationsRequest.prototype.parent = "";
    
                        /**
                         * ListConversationsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @instance
                         */
                        ListConversationsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListConversationsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @instance
                         */
                        ListConversationsRequest.prototype.pageToken = "";
    
                        /**
                         * ListConversationsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @instance
                         */
                        ListConversationsRequest.prototype.filter = "";
    
                        /**
                         * ListConversationsRequest source.
                         * @member {google.cloud.ces.v1.Conversation.Source} source
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @instance
                         */
                        ListConversationsRequest.prototype.source = 0;
    
                        /**
                         * Creates a new ListConversationsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListConversationsRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListConversationsRequest} ListConversationsRequest instance
                         */
                        ListConversationsRequest.create = function create(properties) {
                            return new ListConversationsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListConversationsRequest message. Does not implicitly {@link google.cloud.ces.v1.ListConversationsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListConversationsRequest} message ListConversationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListConversationsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.filter);
                            if (message.source != null && Object.hasOwnProperty.call(message, "source"))
                                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.source);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListConversationsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListConversationsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IListConversationsRequest} message ListConversationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListConversationsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListConversationsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListConversationsRequest} ListConversationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListConversationsRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListConversationsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.source = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListConversationsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListConversationsRequest} ListConversationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListConversationsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListConversationsRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListConversationsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            if (message.source != null && message.hasOwnProperty("source"))
                                switch (message.source) {
                                default:
                                    return "source: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a ListConversationsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListConversationsRequest} ListConversationsRequest
                         */
                        ListConversationsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListConversationsRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListConversationsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            switch (object.source) {
                            default:
                                if (typeof object.source === "number") {
                                    message.source = object.source;
                                    break;
                                }
                                break;
                            case "SOURCE_UNSPECIFIED":
                            case 0:
                                message.source = 0;
                                break;
                            case "LIVE":
                            case 1:
                                message.source = 1;
                                break;
                            case "SIMULATOR":
                            case 2:
                                message.source = 2;
                                break;
                            case "EVAL":
                            case 3:
                                message.source = 3;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListConversationsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @static
                         * @param {google.cloud.ces.v1.ListConversationsRequest} message ListConversationsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListConversationsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.filter = "";
                                object.source = options.enums === String ? "SOURCE_UNSPECIFIED" : 0;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            if (message.source != null && message.hasOwnProperty("source"))
                                object.source = options.enums === String ? $root.google.cloud.ces.v1.Conversation.Source[message.source] === undefined ? message.source : $root.google.cloud.ces.v1.Conversation.Source[message.source] : message.source;
                            return object;
                        };
    
                        /**
                         * Converts this ListConversationsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListConversationsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListConversationsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListConversationsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListConversationsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListConversationsRequest";
                        };
    
                        return ListConversationsRequest;
                    })();
    
                    v1.ListConversationsResponse = (function() {
    
                        /**
                         * Properties of a ListConversationsResponse.
                         * @memberof google.cloud.ces.v1
                         * @interface IListConversationsResponse
                         * @property {Array.<google.cloud.ces.v1.IConversation>|null} [conversations] ListConversationsResponse conversations
                         * @property {string|null} [nextPageToken] ListConversationsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListConversationsResponse.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a ListConversationsResponse.
                         * @implements IListConversationsResponse
                         * @constructor
                         * @param {google.cloud.ces.v1.IListConversationsResponse=} [properties] Properties to set
                         */
                        function ListConversationsResponse(properties) {
                            this.conversations = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListConversationsResponse conversations.
                         * @member {Array.<google.cloud.ces.v1.IConversation>} conversations
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @instance
                         */
                        ListConversationsResponse.prototype.conversations = $util.emptyArray;
    
                        /**
                         * ListConversationsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @instance
                         */
                        ListConversationsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListConversationsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListConversationsResponse=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.ListConversationsResponse} ListConversationsResponse instance
                         */
                        ListConversationsResponse.create = function create(properties) {
                            return new ListConversationsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListConversationsResponse message. Does not implicitly {@link google.cloud.ces.v1.ListConversationsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListConversationsResponse} message ListConversationsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListConversationsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.conversations != null && message.conversations.length)
                                for (var i = 0; i < message.conversations.length; ++i)
                                    $root.google.cloud.ces.v1.Conversation.encode(message.conversations[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListConversationsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1.ListConversationsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IListConversationsResponse} message ListConversationsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListConversationsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListConversationsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.ListConversationsResponse} ListConversationsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListConversationsResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.ListConversationsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.conversations && message.conversations.length))
                                            message.conversations = [];
                                        message.conversations.push($root.google.cloud.ces.v1.Conversation.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListConversationsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.ListConversationsResponse} ListConversationsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListConversationsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListConversationsResponse message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListConversationsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.conversations != null && message.hasOwnProperty("conversations")) {
                                if (!Array.isArray(message.conversations))
                                    return "conversations: array expected";
                                for (var i = 0; i < message.conversations.length; ++i) {
                                    var error = $root.google.cloud.ces.v1.Conversation.verify(message.conversations[i]);
                                    if (error)
                                        return "conversations." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListConversationsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.ListConversationsResponse} ListConversationsResponse
                         */
                        ListConversationsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.ListConversationsResponse)
                                return object;
                            var message = new $root.google.cloud.ces.v1.ListConversationsResponse();
                            if (object.conversations) {
                                if (!Array.isArray(object.conversations))
                                    throw TypeError(".google.cloud.ces.v1.ListConversationsResponse.conversations: array expected");
                                message.conversations = [];
                                for (var i = 0; i < object.conversations.length; ++i) {
                                    if (typeof object.conversations[i] !== "object")
                                        throw TypeError(".google.cloud.ces.v1.ListConversationsResponse.conversations: object expected");
                                    message.conversations[i] = $root.google.cloud.ces.v1.Conversation.fromObject(object.conversations[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListConversationsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @static
                         * @param {google.cloud.ces.v1.ListConversationsResponse} message ListConversationsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListConversationsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.conversations = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.conversations && message.conversations.length) {
                                object.conversations = [];
                                for (var j = 0; j < message.conversations.length; ++j)
                                    object.conversations[j] = $root.google.cloud.ces.v1.Conversation.toObject(message.conversations[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListConversationsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListConversationsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListConversationsResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.ListConversationsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListConversationsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.ListConversationsResponse";
                        };
    
                        return ListConversationsResponse;
                    })();
    
                    v1.GetConversationRequest = (function() {
    
                        /**
                         * Properties of a GetConversationRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IGetConversationRequest
                         * @property {string|null} [name] GetConversationRequest name
                         * @property {google.cloud.ces.v1.Conversation.Source|null} [source] GetConversationRequest source
                         */
    
                        /**
                         * Constructs a new GetConversationRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a GetConversationRequest.
                         * @implements IGetConversationRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IGetConversationRequest=} [properties] Properties to set
                         */
                        function GetConversationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetConversationRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @instance
                         */
                        GetConversationRequest.prototype.name = "";
    
                        /**
                         * GetConversationRequest source.
                         * @member {google.cloud.ces.v1.Conversation.Source} source
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @instance
                         */
                        GetConversationRequest.prototype.source = 0;
    
                        /**
                         * Creates a new GetConversationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetConversationRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.GetConversationRequest} GetConversationRequest instance
                         */
                        GetConversationRequest.create = function create(properties) {
                            return new GetConversationRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetConversationRequest message. Does not implicitly {@link google.cloud.ces.v1.GetConversationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetConversationRequest} message GetConversationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetConversationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.source != null && Object.hasOwnProperty.call(message, "source"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.source);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetConversationRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.GetConversationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @static
                         * @param {google.cloud.ces.v1.IGetConversationRequest} message GetConversationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetConversationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetConversationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.GetConversationRequest} GetConversationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetConversationRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.GetConversationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.source = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetConversationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.GetConversationRequest} GetConversationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetConversationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetConversationRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetConversationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.source != null && message.hasOwnProperty("source"))
                                switch (message.source) {
                                default:
                                    return "source: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a GetConversationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.GetConversationRequest} GetConversationRequest
                         */
                        GetConversationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.GetConversationRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.GetConversationRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            switch (object.source) {
                            default:
                                if (typeof object.source === "number") {
                                    message.source = object.source;
                                    break;
                                }
                                break;
                            case "SOURCE_UNSPECIFIED":
                            case 0:
                                message.source = 0;
                                break;
                            case "LIVE":
                            case 1:
                                message.source = 1;
                                break;
                            case "SIMULATOR":
                            case 2:
                                message.source = 2;
                                break;
                            case "EVAL":
                            case 3:
                                message.source = 3;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetConversationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @static
                         * @param {google.cloud.ces.v1.GetConversationRequest} message GetConversationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetConversationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.source = options.enums === String ? "SOURCE_UNSPECIFIED" : 0;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.source != null && message.hasOwnProperty("source"))
                                object.source = options.enums === String ? $root.google.cloud.ces.v1.Conversation.Source[message.source] === undefined ? message.source : $root.google.cloud.ces.v1.Conversation.Source[message.source] : message.source;
                            return object;
                        };
    
                        /**
                         * Converts this GetConversationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetConversationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetConversationRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.GetConversationRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetConversationRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.GetConversationRequest";
                        };
    
                        return GetConversationRequest;
                    })();
    
                    v1.DeleteConversationRequest = (function() {
    
                        /**
                         * Properties of a DeleteConversationRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IDeleteConversationRequest
                         * @property {string|null} [name] DeleteConversationRequest name
                         * @property {google.cloud.ces.v1.Conversation.Source|null} [source] DeleteConversationRequest source
                         */
    
                        /**
                         * Constructs a new DeleteConversationRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a DeleteConversationRequest.
                         * @implements IDeleteConversationRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IDeleteConversationRequest=} [properties] Properties to set
                         */
                        function DeleteConversationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteConversationRequest name.
                         * @member {string} name
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @instance
                         */
                        DeleteConversationRequest.prototype.name = "";
    
                        /**
                         * DeleteConversationRequest source.
                         * @member {google.cloud.ces.v1.Conversation.Source} source
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @instance
                         */
                        DeleteConversationRequest.prototype.source = 0;
    
                        /**
                         * Creates a new DeleteConversationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteConversationRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.DeleteConversationRequest} DeleteConversationRequest instance
                         */
                        DeleteConversationRequest.create = function create(properties) {
                            return new DeleteConversationRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteConversationRequest message. Does not implicitly {@link google.cloud.ces.v1.DeleteConversationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteConversationRequest} message DeleteConversationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteConversationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.source != null && Object.hasOwnProperty.call(message, "source"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.source);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteConversationRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.DeleteConversationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @static
                         * @param {google.cloud.ces.v1.IDeleteConversationRequest} message DeleteConversationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteConversationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteConversationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.DeleteConversationRequest} DeleteConversationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteConversationRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.DeleteConversationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.source = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteConversationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.DeleteConversationRequest} DeleteConversationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteConversationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteConversationRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteConversationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.source != null && message.hasOwnProperty("source"))
                                switch (message.source) {
                                default:
                                    return "source: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a DeleteConversationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.DeleteConversationRequest} DeleteConversationRequest
                         */
                        DeleteConversationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.DeleteConversationRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.DeleteConversationRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            switch (object.source) {
                            default:
                                if (typeof object.source === "number") {
                                    message.source = object.source;
                                    break;
                                }
                                break;
                            case "SOURCE_UNSPECIFIED":
                            case 0:
                                message.source = 0;
                                break;
                            case "LIVE":
                            case 1:
                                message.source = 1;
                                break;
                            case "SIMULATOR":
                            case 2:
                                message.source = 2;
                                break;
                            case "EVAL":
                            case 3:
                                message.source = 3;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteConversationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @static
                         * @param {google.cloud.ces.v1.DeleteConversationRequest} message DeleteConversationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteConversationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.source = options.enums === String ? "SOURCE_UNSPECIFIED" : 0;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.source != null && message.hasOwnProperty("source"))
                                object.source = options.enums === String ? $root.google.cloud.ces.v1.Conversation.Source[message.source] === undefined ? message.source : $root.google.cloud.ces.v1.Conversation.Source[message.source] : message.source;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteConversationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteConversationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteConversationRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.DeleteConversationRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteConversationRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.DeleteConversationRequest";
                        };
    
                        return DeleteConversationRequest;
                    })();
    
                    v1.BatchDeleteConversationsRequest = (function() {
    
                        /**
                         * Properties of a BatchDeleteConversationsRequest.
                         * @memberof google.cloud.ces.v1
                         * @interface IBatchDeleteConversationsRequest
                         * @property {string|null} [parent] BatchDeleteConversationsRequest parent
                         * @property {Array.<string>|null} [conversations] BatchDeleteConversationsRequest conversations
                         */
    
                        /**
                         * Constructs a new BatchDeleteConversationsRequest.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a BatchDeleteConversationsRequest.
                         * @implements IBatchDeleteConversationsRequest
                         * @constructor
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsRequest=} [properties] Properties to set
                         */
                        function BatchDeleteConversationsRequest(properties) {
                            this.conversations = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BatchDeleteConversationsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @instance
                         */
                        BatchDeleteConversationsRequest.prototype.parent = "";
    
                        /**
                         * BatchDeleteConversationsRequest conversations.
                         * @member {Array.<string>} conversations
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @instance
                         */
                        BatchDeleteConversationsRequest.prototype.conversations = $util.emptyArray;
    
                        /**
                         * Creates a new BatchDeleteConversationsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsRequest=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.BatchDeleteConversationsRequest} BatchDeleteConversationsRequest instance
                         */
                        BatchDeleteConversationsRequest.create = function create(properties) {
                            return new BatchDeleteConversationsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified BatchDeleteConversationsRequest message. Does not implicitly {@link google.cloud.ces.v1.BatchDeleteConversationsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsRequest} message BatchDeleteConversationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchDeleteConversationsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.conversations != null && message.conversations.length)
                                for (var i = 0; i < message.conversations.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.conversations[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BatchDeleteConversationsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1.BatchDeleteConversationsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @static
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsRequest} message BatchDeleteConversationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchDeleteConversationsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BatchDeleteConversationsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.BatchDeleteConversationsRequest} BatchDeleteConversationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchDeleteConversationsRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.BatchDeleteConversationsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.conversations && message.conversations.length))
                                            message.conversations = [];
                                        message.conversations.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BatchDeleteConversationsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.BatchDeleteConversationsRequest} BatchDeleteConversationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchDeleteConversationsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BatchDeleteConversationsRequest message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BatchDeleteConversationsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.conversations != null && message.hasOwnProperty("conversations")) {
                                if (!Array.isArray(message.conversations))
                                    return "conversations: array expected";
                                for (var i = 0; i < message.conversations.length; ++i)
                                    if (!$util.isString(message.conversations[i]))
                                        return "conversations: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a BatchDeleteConversationsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.BatchDeleteConversationsRequest} BatchDeleteConversationsRequest
                         */
                        BatchDeleteConversationsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.BatchDeleteConversationsRequest)
                                return object;
                            var message = new $root.google.cloud.ces.v1.BatchDeleteConversationsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.conversations) {
                                if (!Array.isArray(object.conversations))
                                    throw TypeError(".google.cloud.ces.v1.BatchDeleteConversationsRequest.conversations: array expected");
                                message.conversations = [];
                                for (var i = 0; i < object.conversations.length; ++i)
                                    message.conversations[i] = String(object.conversations[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a BatchDeleteConversationsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @static
                         * @param {google.cloud.ces.v1.BatchDeleteConversationsRequest} message BatchDeleteConversationsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        BatchDeleteConversationsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.conversations = [];
                            if (options.defaults)
                                object.parent = "";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.conversations && message.conversations.length) {
                                object.conversations = [];
                                for (var j = 0; j < message.conversations.length; ++j)
                                    object.conversations[j] = message.conversations[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this BatchDeleteConversationsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        BatchDeleteConversationsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for BatchDeleteConversationsRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        BatchDeleteConversationsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.ces.v1.BatchDeleteConversationsRequest";
                        };
    
                        return BatchDeleteConversationsRequest;
                    })();
    
                    v1.BatchDeleteConversationsResponse = (function() {
    
                        /**
                         * Properties of a BatchDeleteConversationsResponse.
                         * @memberof google.cloud.ces.v1
                         * @interface IBatchDeleteConversationsResponse
                         * @property {Array.<string>|null} [deletedConversations] BatchDeleteConversationsResponse deletedConversations
                         * @property {Array.<string>|null} [failedConversations] BatchDeleteConversationsResponse failedConversations
                         * @property {Array.<string>|null} [errorMessages] BatchDeleteConversationsResponse errorMessages
                         */
    
                        /**
                         * Constructs a new BatchDeleteConversationsResponse.
                         * @memberof google.cloud.ces.v1
                         * @classdesc Represents a BatchDeleteConversationsResponse.
                         * @implements IBatchDeleteConversationsResponse
                         * @constructor
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsResponse=} [properties] Properties to set
                         */
                        function BatchDeleteConversationsResponse(properties) {
                            this.deletedConversations = [];
                            this.failedConversations = [];
                            this.errorMessages = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BatchDeleteConversationsResponse deletedConversations.
                         * @member {Array.<string>} deletedConversations
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @instance
                         */
                        BatchDeleteConversationsResponse.prototype.deletedConversations = $util.emptyArray;
    
                        /**
                         * BatchDeleteConversationsResponse failedConversations.
                         * @member {Array.<string>} failedConversations
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @instance
                         */
                        BatchDeleteConversationsResponse.prototype.failedConversations = $util.emptyArray;
    
                        /**
                         * BatchDeleteConversationsResponse errorMessages.
                         * @member {Array.<string>} errorMessages
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @instance
                         */
                        BatchDeleteConversationsResponse.prototype.errorMessages = $util.emptyArray;
    
                        /**
                         * Creates a new BatchDeleteConversationsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsResponse=} [properties] Properties to set
                         * @returns {google.cloud.ces.v1.BatchDeleteConversationsResponse} BatchDeleteConversationsResponse instance
                         */
                        BatchDeleteConversationsResponse.create = function create(properties) {
                            return new BatchDeleteConversationsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified BatchDeleteConversationsResponse message. Does not implicitly {@link google.cloud.ces.v1.BatchDeleteConversationsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsResponse} message BatchDeleteConversationsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchDeleteConversationsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.deletedConversations != null && message.deletedConversations.length)
                                for (var i = 0; i < message.deletedConversations.length; ++i)
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.deletedConversations[i]);
                            if (message.failedConversations != null && message.failedConversations.length)
                                for (var i = 0; i < message.failedConversations.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.failedConversations[i]);
                            if (message.errorMessages != null && message.errorMessages.length)
                                for (var i = 0; i < message.errorMessages.length; ++i)
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.errorMessages[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BatchDeleteConversationsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1.BatchDeleteConversationsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @static
                         * @param {google.cloud.ces.v1.IBatchDeleteConversationsResponse} message BatchDeleteConversationsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchDeleteConversationsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BatchDeleteConversationsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.ces.v1.BatchDeleteConversationsResponse} BatchDeleteConversationsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchDeleteConversationsResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.ces.v1.BatchDeleteConversationsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.deletedConversations && message.deletedConversations.length))
                                            message.deletedConversations = [];
                                        message.deletedConversations.push(reader.string());
                                        break;
                                    }
                                case 2: {
                                        if (!(message.failedConversations && message.failedConversations.length))
                                            message.failedConversations = [];
                                        message.failedConversations.push(reader.string());
                                        break;
                                    }
                                case 3: {
                                        if (!(message.errorMessages && message.errorMessages.length))
                                            message.errorMessages = [];
                                        message.errorMessages.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BatchDeleteConversationsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.ces.v1.BatchDeleteConversationsResponse} BatchDeleteConversationsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchDeleteConversationsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BatchDeleteConversationsResponse message.
                         * @function verify
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BatchDeleteConversationsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.deletedConversations != null && message.hasOwnProperty("deletedConversations")) {
                                if (!Array.isArray(message.deletedConversations))
                                    return "deletedConversations: array expected";
                                for (var i = 0; i < message.deletedConversations.length; ++i)
                                    if (!$util.isString(message.deletedConversations[i]))
                                        return "deletedConversations: string[] expected";
                            }
                            if (message.failedConversations != null && message.hasOwnProperty("failedConversations")) {
                                if (!Array.isArray(message.failedConversations))
                                    return "failedConversations: array expected";
                                for (var i = 0; i < message.failedConversations.length; ++i)
                                    if (!$util.isString(message.failedConversations[i]))
                                        return "failedConversations: string[] expected";
                            }
                            if (message.errorMessages != null && message.hasOwnProperty("errorMessages")) {
                                if (!Array.isArray(message.errorMessages))
                                    return "errorMessages: array expected";
                                for (var i = 0; i < message.errorMessages.length; ++i)
                                    if (!$util.isString(message.errorMessages[i]))
                                        return "errorMessages: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a BatchDeleteConversationsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.ces.v1.BatchDeleteConversationsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.ces.v1.BatchDeleteConversationsResponse} BatchDeleteConversationsResponse
                         */
                        BatchDeleteConversationsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.ces.v1.BatchDeleteConversationsResponse)
                                return object;
                            var message = new $root.google.cloud.ces.v1.BatchDeleteConversationsResponse();
                            if (object.deletedConversations) {
                                if (!Array.isArray(object.deletedConversations))
                                    throw TypeError(".google.cloud.ces.v1.BatchDeleteConversationsResponse.deletedConversations: array expected");
                                message.deletedConversations = [];
                                for (var i = 0; i < object.deletedConversations.length; ++i)
                                    message.deletedConversations[i] = String(object.deletedConversations[i]);
                            }
                            if (object.failedConversations) {
                                if (!Array.isArray(object.failedConversations))
                                    throw TypeError(".google.cloud.ces.v1.BatchDeleteConversatio