// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(parent) {
  // [START ces_v1_generated_ToolService_RetrieveToolSchema_async]
  /**
   * This snippet has been automatically generated and should be regarded as a code template only.
   * It will require modifications to work.
   * It may require correct/in-range values for request initialization.
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  Optional. The name of the tool to retrieve the schema for.
   *  Format:
   *  projects/{project}/locations/{location}/apps/{app}/tools/{tool}
   */
  // const tool = 'abc123'
  /**
   *  Optional. The toolset tool to retrieve the schema for. Only one tool
   *  should match the predicate from the toolset. Otherwise, an error will be
   *  returned.
   */
  // const toolsetTool = {}
  /**
   *  Required. The resource name of the app which the tool/toolset belongs to.
   *  Format: `projects/{project}/locations/{location}/apps/{app}`
   */
  // const parent = 'abc123'

  // Imports the Ces library
  const {ToolServiceClient} = require('@google-cloud/ces').v1;

  // Instantiates a client
  const cesClient = new ToolServiceClient();

  async function callRetrieveToolSchema() {
    // Construct request
    const request = {
      parent,
    };

    // Run request
    const response = await cesClient.retrieveToolSchema(request);
    console.log(response);
  }

  callRetrieveToolSchema();
  // [END ces_v1_generated_ToolService_RetrieveToolSchema_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
