// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

/* global window */
import type * as gax from 'google-gax';
import type {Callback, CallOptions, Descriptors, ClientOptions, LocationsClient, LocationProtos} from 'google-gax';
import {PassThrough} from 'stream';
import * as protos from '../../protos/protos';
import jsonProtos = require('../../protos/protos.json');
import {loggingUtils as logging, decodeAnyProtosInArray} from 'google-gax';

/**
 * Client JSON configuration object, loaded from
 * `src/v1/session_service_client_config.json`.
 * This file defines retry strategy and timeouts for all API methods in this library.
 */
import * as gapicConfig from './session_service_client_config.json';
const version = require('../../../package.json').version;

/**
 *  Session service provides APIs for interacting with CES agents.
 * @class
 * @memberof v1
 */
export class SessionServiceClient {
  private _terminated = false;
  private _opts: ClientOptions;
  private _providedCustomServicePath: boolean;
  private _gaxModule: typeof gax | typeof gax.fallback;
  private _gaxGrpc: gax.GrpcClient | gax.fallback.GrpcClient;
  private _protos: {};
  private _defaults: {[method: string]: gax.CallSettings};
  private _universeDomain: string;
  private _servicePath: string;
  private _log = logging.log('ces');

  auth: gax.GoogleAuth;
  descriptors: Descriptors = {
    page: {},
    stream: {},
    longrunning: {},
    batching: {},
  };
  warn: (code: string, message: string, warnType?: string) => void;
  innerApiCalls: {[name: string]: Function};
  locationsClient: LocationsClient;
  pathTemplates: {[name: string]: gax.PathTemplate};
  sessionServiceStub?: Promise<{[name: string]: Function}>;

  /**
   * Construct an instance of SessionServiceClient.
   *
   * @param {object} [options] - The configuration object.
   * The options accepted by the constructor are described in detail
   * in [this document](https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#creating-the-client-instance).
   * The common options are:
   * @param {object} [options.credentials] - Credentials object.
   * @param {string} [options.credentials.client_email]
   * @param {string} [options.credentials.private_key]
   * @param {string} [options.email] - Account email address. Required when
   *     using a .pem or .p12 keyFilename.
   * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
   *     .p12 key downloaded from the Google Developers Console. If you provide
   *     a path to a JSON file, the projectId option below is not necessary.
   *     NOTE: .pem and .p12 require you to specify options.email as well.
   * @param {number} [options.port] - The port on which to connect to
   *     the remote host.
   * @param {string} [options.projectId] - The project ID from the Google
   *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
   *     the environment variable GCLOUD_PROJECT for your project ID. If your
   *     app is running in an environment which supports
   *     {@link https://cloud.google.com/docs/authentication/application-default-credentials Application Default Credentials},
   *     your project ID will be detected automatically.
   * @param {string} [options.apiEndpoint] - The domain name of the
   *     API remote host.
   * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
   *     Follows the structure of {@link gapicConfig}.
   * @param {boolean} [options.fallback] - Use HTTP/1.1 REST mode.
   *     For more information, please check the
   *     {@link https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#http11-rest-api-mode documentation}.
   * @param {gax} [gaxInstance]: loaded instance of `google-gax`. Useful if you
   *     need to avoid loading the default gRPC version and want to use the fallback
   *     HTTP implementation. Load only fallback version and pass it to the constructor:
   *     ```
   *     const gax = require('google-gax/build/src/fallback'); // avoids loading google-gax with gRPC
   *     const client = new SessionServiceClient({fallback: true}, gax);
   *     ```
   */
  constructor(opts?: ClientOptions, gaxInstance?: typeof gax | typeof gax.fallback) {
    // Ensure that options include all the required fields.
    const staticMembers = this.constructor as typeof SessionServiceClient;
    if (opts?.universe_domain && opts?.universeDomain && opts?.universe_domain !== opts?.universeDomain) {
      throw new Error('Please set either universe_domain or universeDomain, but not both.');
    }
    const universeDomainEnvVar = (typeof process === 'object' && typeof process.env === 'object') ? process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] : undefined;
    this._universeDomain = opts?.universeDomain ?? opts?.universe_domain ?? universeDomainEnvVar ?? 'googleapis.com';
    this._servicePath = 'ces.' + this._universeDomain;
    const servicePath = opts?.servicePath || opts?.apiEndpoint || this._servicePath;
    this._providedCustomServicePath = !!(opts?.servicePath || opts?.apiEndpoint);
    const port = opts?.port || staticMembers.port;
    const clientConfig = opts?.clientConfig ?? {};
    const fallback = opts?.fallback ?? (typeof window !== 'undefined' && typeof window?.fetch === 'function');
    opts = Object.assign({servicePath, port, clientConfig, fallback}, opts);

    // Request numeric enum values if REST transport is used.
    opts.numericEnums = true;

    // If scopes are unset in options and we're connecting to a non-default endpoint, set scopes just in case.
    if (servicePath !== this._servicePath && !('scopes' in opts)) {
      opts['scopes'] = staticMembers.scopes;
    }

    // Load google-gax module synchronously if needed
    if (!gaxInstance) {
      gaxInstance = require('google-gax') as typeof gax;
    }

    // Choose either gRPC or proto-over-HTTP implementation of google-gax.
    this._gaxModule = opts.fallback ? gaxInstance.fallback : gaxInstance;

    // Create a `gaxGrpc` object, with any grpc-specific options sent to the client.
    this._gaxGrpc = new this._gaxModule.GrpcClient(opts);

    // Save options to use in initialize() method.
    this._opts = opts;

    // Save the auth object to the client, for use by other methods.
    this.auth = (this._gaxGrpc.auth as gax.GoogleAuth);

    // Set useJWTAccessWithScope on the auth object.
    this.auth.useJWTAccessWithScope = true;

    // Set defaultServicePath on the auth object.
    this.auth.defaultServicePath = this._servicePath;

    // Set the default scopes in auth client if needed.
    if (servicePath === this._servicePath) {
      this.auth.defaultScopes = staticMembers.scopes;
    }
    this.locationsClient = new this._gaxModule.LocationsClient(
      this._gaxGrpc,
      opts
    );
  

    // Determine the client header string.
    const clientHeader = [
      `gax/${this._gaxModule.version}`,
      `gapic/${version}`,
    ];
    if (typeof process === 'object' && 'versions' in process) {
      clientHeader.push(`gl-node/${process.versions.node}`);
    } else {
      clientHeader.push(`gl-web/${this._gaxModule.version}`);
    }
    if (!opts.fallback) {
      clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
    } else {
      clientHeader.push(`rest/${this._gaxGrpc.grpcVersion}`);
    }
    if (opts.libName && opts.libVersion) {
      clientHeader.push(`${opts.libName}/${opts.libVersion}`);
    }
    // Load the applicable protos.
    this._protos = this._gaxGrpc.loadProtoJSON(jsonProtos);

    // This API contains "path templates"; forward-slash-separated
    // identifiers to uniquely identify resources within the API.
    // Create useful helper objects for these.
    this.pathTemplates = {
      agentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/agents/{agent}'
      ),
      appPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}'
      ),
      appVersionPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/versions/{version}'
      ),
      changelogPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/changelogs/{changelog}'
      ),
      conversationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}'
      ),
      deploymentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}'
      ),
      examplePathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/examples/{example}'
      ),
      guardrailPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}'
      ),
      omnichannelPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/omnichannels/{omnichannel}'
      ),
      sessionPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/sessions/{session}'
      ),
      toolPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/tools/{tool}'
      ),
      toolsetPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}'
      ),
    };

    // Some of the methods on this service provide streaming responses.
    // Provide descriptors for these.
    this.descriptors.stream = {
      bidiRunSession: new this._gaxModule.StreamDescriptor(this._gaxModule.StreamType.BIDI_STREAMING, !!opts.fallback, !!opts.gaxServerStreamingRetries)
    };

    // Put together the default options sent with requests.
    this._defaults = this._gaxGrpc.constructSettings(
        'google.cloud.ces.v1.SessionService', gapicConfig as gax.ClientConfig,
        opts.clientConfig || {}, {'x-goog-api-client': clientHeader.join(' ')});

    // Set up a dictionary of "inner API calls"; the core implementation
    // of calling the API is handled in `google-gax`, with this code
    // merely providing the destination and request information.
    this.innerApiCalls = {};

    // Add a warn function to the client constructor so it can be easily tested.
    this.warn = this._gaxModule.warn;
  }

  /**
   * Initialize the client.
   * Performs asynchronous operations (such as authentication) and prepares the client.
   * This function will be called automatically when any class method is called for the
   * first time, but if you need to initialize it before calling an actual method,
   * feel free to call initialize() directly.
   *
   * You can await on this method if you want to make sure the client is initialized.
   *
   * @returns {Promise} A promise that resolves to an authenticated service stub.
   */
  initialize() {
    // If the client stub promise is already initialized, return immediately.
    if (this.sessionServiceStub) {
      return this.sessionServiceStub;
    }

    // Put together the "service stub" for
    // google.cloud.ces.v1.SessionService.
    this.sessionServiceStub = this._gaxGrpc.createStub(
        this._opts.fallback ?
          (this._protos as protobuf.Root).lookupService('google.cloud.ces.v1.SessionService') :
          // eslint-disable-next-line @typescript-eslint/no-explicit-any
          (this._protos as any).google.cloud.ces.v1.SessionService,
        this._opts, this._providedCustomServicePath) as Promise<{[method: string]: Function}>;

    // Iterate over each of the methods that the service provides
    // and create an API call method for each.
    const sessionServiceStubMethods =
        ['runSession', 'bidiRunSession'];
    for (const methodName of sessionServiceStubMethods) {
      const callPromise = this.sessionServiceStub.then(
        stub => (...args: Array<{}>) => {
          if (this._terminated) {
            if (methodName in this.descriptors.stream) {
              const stream = new PassThrough({objectMode: true});
              setImmediate(() => {
                stream.emit('error', new this._gaxModule.GoogleError('The client has already been closed.'));
              });
              return stream;
            }
            return Promise.reject('The client has already been closed.');
          }
          const func = stub[methodName];
          return func.apply(stub, args);
        },
        (err: Error|null|undefined) => () => {
          throw err;
        });

      const descriptor =
        this.descriptors.stream[methodName] ||
        undefined;
      const apiCall = this._gaxModule.createApiCall(
        callPromise,
        this._defaults[methodName],
        descriptor,
        this._opts.fallback
      );

      this.innerApiCalls[methodName] = apiCall;
    }

    return this.sessionServiceStub;
  }

  /**
   * The DNS address for this API service.
   * @deprecated Use the apiEndpoint method of the client instance.
   * @returns {string} The DNS address for this service.
   */
  static get servicePath() {
    if (typeof process === 'object' && typeof process.emitWarning === 'function') {
      process.emitWarning('Static servicePath is deprecated, please use the instance method instead.', 'DeprecationWarning');
    }
    return 'ces.googleapis.com';
  }

  /**
   * The DNS address for this API service - same as servicePath.
   * @deprecated Use the apiEndpoint method of the client instance.
   * @returns {string} The DNS address for this service.
   */
  static get apiEndpoint() {
    if (typeof process === 'object' && typeof process.emitWarning === 'function') {
      process.emitWarning('Static apiEndpoint is deprecated, please use the instance method instead.', 'DeprecationWarning');
    }
    return 'ces.googleapis.com';
  }

  /**
   * The DNS address for this API service.
   * @returns {string} The DNS address for this service.
   */
  get apiEndpoint() {
    return this._servicePath;
  }

  get universeDomain() {
    return this._universeDomain;
  }

  /**
   * The port for this API service.
   * @returns {number} The default port for this service.
   */
  static get port() {
    return 443;
  }

  /**
   * The scopes needed to make gRPC calls for every method defined
   * in this service.
   * @returns {string[]} List of default scopes.
   */
  static get scopes() {
    return [
      'https://www.googleapis.com/auth/cloud-platform'
    ];
  }

  getProjectId(): Promise<string>;
  getProjectId(callback: Callback<string, undefined, undefined>): void;
  /**
   * Return the project ID used by this class.
   * @returns {Promise} A promise that resolves to string containing the project ID.
   */
  getProjectId(callback?: Callback<string, undefined, undefined>):
      Promise<string>|void {
    if (callback) {
      this.auth.getProjectId(callback);
      return;
    }
    return this.auth.getProjectId();
  }

  // -------------------
  // -- Service calls --
  // -------------------
/**
 * Initiates a single turn interaction with the CES agent within a
 * session.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1.SessionConfig} request.config
 *   Required. The configuration for the session.
 * @param {number[]} request.inputs
 *   Required. Inputs for the session.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1.RunSessionResponse|RunSessionResponse}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1/session_service.run_session.js</caption>
 * region_tag:ces_v1_generated_SessionService_RunSession_async
 */
  runSession(
      request?: protos.google.cloud.ces.v1.IRunSessionRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1.IRunSessionResponse,
        protos.google.cloud.ces.v1.IRunSessionRequest|undefined, {}|undefined
      ]>;
  runSession(
      request: protos.google.cloud.ces.v1.IRunSessionRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1.IRunSessionResponse,
          protos.google.cloud.ces.v1.IRunSessionRequest|null|undefined,
          {}|null|undefined>): void;
  runSession(
      request: protos.google.cloud.ces.v1.IRunSessionRequest,
      callback: Callback<
          protos.google.cloud.ces.v1.IRunSessionResponse,
          protos.google.cloud.ces.v1.IRunSessionRequest|null|undefined,
          {}|null|undefined>): void;
  runSession(
      request?: protos.google.cloud.ces.v1.IRunSessionRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1.IRunSessionResponse,
          protos.google.cloud.ces.v1.IRunSessionRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1.IRunSessionResponse,
          protos.google.cloud.ces.v1.IRunSessionRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1.IRunSessionResponse,
        protos.google.cloud.ces.v1.IRunSessionRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'config.session': request.config!.session ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('runSession request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1.IRunSessionResponse,
        protos.google.cloud.ces.v1.IRunSessionRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('runSession response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.runSession(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1.IRunSessionResponse,
        protos.google.cloud.ces.v1.IRunSessionRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('runSession response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }

/**
 * Establishes a bidirectional streaming connection with the CES agent. The
 * agent will process continuous client inputs across multiple modalities
 * (e.g., text, audio) and generates real-time multimodal output streams.
 *
 * For an audio session, the client is expected to stream audio data
 * continuously to the agent, even when the end user is silent. A chunk size
 * of **40-120 milliseconds** is recommended, balancing network efficiency and
 * low latency for real-time processing.
 *
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which is both readable and writable. It accepts objects
 *   representing {@link protos.google.cloud.ces.v1.BidiSessionClientMessage|BidiSessionClientMessage} for write() method, and
 *   will emit objects representing {@link protos.google.cloud.ces.v1.BidiSessionServerMessage|BidiSessionServerMessage} on 'data' event asynchronously.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#bi-directional-streaming | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1/session_service.bidi_run_session.js</caption>
 * region_tag:ces_v1_generated_SessionService_BidiRunSession_async
 */
  bidiRunSession(
      options?: CallOptions):
    gax.CancellableStream {
    this.initialize().catch(err => {throw err});
    this._log.info('bidiRunSession stream %j', options);
    return this.innerApiCalls.bidiRunSession(null, options);
  }

/**
   * Gets information about a location.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Resource name for the location.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html | CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link google.cloud.location.Location | Location}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   * @example
   * ```
   * const [response] = await client.getLocation(request);
   * ```
   */
  getLocation(
    request: LocationProtos.google.cloud.location.IGetLocationRequest,
    options?:
      | gax.CallOptions
      | Callback<
          LocationProtos.google.cloud.location.ILocation,
          | LocationProtos.google.cloud.location.IGetLocationRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LocationProtos.google.cloud.location.ILocation,
      | LocationProtos.google.cloud.location.IGetLocationRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<LocationProtos.google.cloud.location.ILocation> {
    return this.locationsClient.getLocation(request, options, callback);
  }

/**
   * Lists information about the supported locations for this service. Returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   The resource that owns the locations collection, if applicable.
   * @param {string} request.filter
   *   The standard list filter.
   * @param {number} request.pageSize
   *   The standard list page size.
   * @param {string} request.pageToken
   *   The standard list page token.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
   *   When you iterate the returned iterable, each element will be an object representing
   *   {@link google.cloud.location.Location | Location}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   * @example
   * ```
   * const iterable = client.listLocationsAsync(request);
   * for await (const response of iterable) {
   *   // process response
   * }
   * ```
   */
  listLocationsAsync(
    request: LocationProtos.google.cloud.location.IListLocationsRequest,
    options?: CallOptions
  ): AsyncIterable<LocationProtos.google.cloud.location.ILocation> {
    return this.locationsClient.listLocationsAsync(request, options);
  }

  // --------------------
  // -- Path templates --
  // --------------------

  /**
   * Return a fully-qualified agent resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} agent
   * @returns {string} Resource name string.
   */
  agentPath(project:string,location:string,app:string,agent:string) {
    return this.pathTemplates.agentPathTemplate.render({
      project: project,
      location: location,
      app: app,
      agent: agent,
    });
  }

  /**
   * Parse the project from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).project;
  }

  /**
   * Parse the location from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).location;
  }

  /**
   * Parse the app from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).app;
  }

  /**
   * Parse the agent from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the agent.
   */
  matchAgentFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).agent;
  }

  /**
   * Return a fully-qualified app resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @returns {string} Resource name string.
   */
  appPath(project:string,location:string,app:string) {
    return this.pathTemplates.appPathTemplate.render({
      project: project,
      location: location,
      app: app,
    });
  }

  /**
   * Parse the project from App resource.
   *
   * @param {string} appName
   *   A fully-qualified path representing App resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromAppName(appName: string) {
    return this.pathTemplates.appPathTemplate.match(appName).project;
  }

  /**
   * Parse the location from App resource.
   *
   * @param {string} appName
   *   A fully-qualified path representing App resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromAppName(appName: string) {
    return this.pathTemplates.appPathTemplate.match(appName).location;
  }

  /**
   * Parse the app from App resource.
   *
   * @param {string} appName
   *   A fully-qualified path representing App resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromAppName(appName: string) {
    return this.pathTemplates.appPathTemplate.match(appName).app;
  }

  /**
   * Return a fully-qualified appVersion resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} version
   * @returns {string} Resource name string.
   */
  appVersionPath(project:string,location:string,app:string,version:string) {
    return this.pathTemplates.appVersionPathTemplate.render({
      project: project,
      location: location,
      app: app,
      version: version,
    });
  }

  /**
   * Parse the project from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).project;
  }

  /**
   * Parse the location from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).location;
  }

  /**
   * Parse the app from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).app;
  }

  /**
   * Parse the version from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the version.
   */
  matchVersionFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).version;
  }

  /**
   * Return a fully-qualified changelog resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} changelog
   * @returns {string} Resource name string.
   */
  changelogPath(project:string,location:string,app:string,changelog:string) {
    return this.pathTemplates.changelogPathTemplate.render({
      project: project,
      location: location,
      app: app,
      changelog: changelog,
    });
  }

  /**
   * Parse the project from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).project;
  }

  /**
   * Parse the location from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).location;
  }

  /**
   * Parse the app from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).app;
  }

  /**
   * Parse the changelog from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the changelog.
   */
  matchChangelogFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).changelog;
  }

  /**
   * Return a fully-qualified conversation resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} conversation
   * @returns {string} Resource name string.
   */
  conversationPath(project:string,location:string,app:string,conversation:string) {
    return this.pathTemplates.conversationPathTemplate.render({
      project: project,
      location: location,
      app: app,
      conversation: conversation,
    });
  }

  /**
   * Parse the project from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).project;
  }

  /**
   * Parse the location from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).location;
  }

  /**
   * Parse the app from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).app;
  }

  /**
   * Parse the conversation from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the conversation.
   */
  matchConversationFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).conversation;
  }

  /**
   * Return a fully-qualified deployment resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} deployment
   * @returns {string} Resource name string.
   */
  deploymentPath(project:string,location:string,app:string,deployment:string) {
    return this.pathTemplates.deploymentPathTemplate.render({
      project: project,
      location: location,
      app: app,
      deployment: deployment,
    });
  }

  /**
   * Parse the project from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).project;
  }

  /**
   * Parse the location from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).location;
  }

  /**
   * Parse the app from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).app;
  }

  /**
   * Parse the deployment from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the deployment.
   */
  matchDeploymentFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).deployment;
  }

  /**
   * Return a fully-qualified example resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} example
   * @returns {string} Resource name string.
   */
  examplePath(project:string,location:string,app:string,example:string) {
    return this.pathTemplates.examplePathTemplate.render({
      project: project,
      location: location,
      app: app,
      example: example,
    });
  }

  /**
   * Parse the project from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).project;
  }

  /**
   * Parse the location from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).location;
  }

  /**
   * Parse the app from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).app;
  }

  /**
   * Parse the example from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the example.
   */
  matchExampleFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).example;
  }

  /**
   * Return a fully-qualified guardrail resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} guardrail
   * @returns {string} Resource name string.
   */
  guardrailPath(project:string,location:string,app:string,guardrail:string) {
    return this.pathTemplates.guardrailPathTemplate.render({
      project: project,
      location: location,
      app: app,
      guardrail: guardrail,
    });
  }

  /**
   * Parse the project from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).project;
  }

  /**
   * Parse the location from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).location;
  }

  /**
   * Parse the app from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).app;
  }

  /**
   * Parse the guardrail from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the guardrail.
   */
  matchGuardrailFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).guardrail;
  }

  /**
   * Return a fully-qualified omnichannel resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} omnichannel
   * @returns {string} Resource name string.
   */
  omnichannelPath(project:string,location:string,omnichannel:string) {
    return this.pathTemplates.omnichannelPathTemplate.render({
      project: project,
      location: location,
      omnichannel: omnichannel,
    });
  }

  /**
   * Parse the project from Omnichannel resource.
   *
   * @param {string} omnichannelName
   *   A fully-qualified path representing Omnichannel resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromOmnichannelName(omnichannelName: string) {
    return this.pathTemplates.omnichannelPathTemplate.match(omnichannelName).project;
  }

  /**
   * Parse the location from Omnichannel resource.
   *
   * @param {string} omnichannelName
   *   A fully-qualified path representing Omnichannel resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromOmnichannelName(omnichannelName: string) {
    return this.pathTemplates.omnichannelPathTemplate.match(omnichannelName).location;
  }

  /**
   * Parse the omnichannel from Omnichannel resource.
   *
   * @param {string} omnichannelName
   *   A fully-qualified path representing Omnichannel resource.
   * @returns {string} A string representing the omnichannel.
   */
  matchOmnichannelFromOmnichannelName(omnichannelName: string) {
    return this.pathTemplates.omnichannelPathTemplate.match(omnichannelName).omnichannel;
  }

  /**
   * Return a fully-qualified session resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} session
   * @returns {string} Resource name string.
   */
  sessionPath(project:string,location:string,app:string,session:string) {
    return this.pathTemplates.sessionPathTemplate.render({
      project: project,
      location: location,
      app: app,
      session: session,
    });
  }

  /**
   * Parse the project from Session resource.
   *
   * @param {string} sessionName
   *   A fully-qualified path representing Session resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromSessionName(sessionName: string) {
    return this.pathTemplates.sessionPathTemplate.match(sessionName).project;
  }

  /**
   * Parse the location from Session resource.
   *
   * @param {string} sessionName
   *   A fully-qualified path representing Session resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromSessionName(sessionName: string) {
    return this.pathTemplates.sessionPathTemplate.match(sessionName).location;
  }

  /**
   * Parse the app from Session resource.
   *
   * @param {string} sessionName
   *   A fully-qualified path representing Session resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromSessionName(sessionName: string) {
    return this.pathTemplates.sessionPathTemplate.match(sessionName).app;
  }

  /**
   * Parse the session from Session resource.
   *
   * @param {string} sessionName
   *   A fully-qualified path representing Session resource.
   * @returns {string} A string representing the session.
   */
  matchSessionFromSessionName(sessionName: string) {
    return this.pathTemplates.sessionPathTemplate.match(sessionName).session;
  }

  /**
   * Return a fully-qualified tool resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} tool
   * @returns {string} Resource name string.
   */
  toolPath(project:string,location:string,app:string,tool:string) {
    return this.pathTemplates.toolPathTemplate.render({
      project: project,
      location: location,
      app: app,
      tool: tool,
    });
  }

  /**
   * Parse the project from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).project;
  }

  /**
   * Parse the location from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).location;
  }

  /**
   * Parse the app from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).app;
  }

  /**
   * Parse the tool from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the tool.
   */
  matchToolFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).tool;
  }

  /**
   * Return a fully-qualified toolset resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} toolset
   * @returns {string} Resource name string.
   */
  toolsetPath(project:string,location:string,app:string,toolset:string) {
    return this.pathTemplates.toolsetPathTemplate.render({
      project: project,
      location: location,
      app: app,
      toolset: toolset,
    });
  }

  /**
   * Parse the project from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).project;
  }

  /**
   * Parse the location from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).location;
  }

  /**
   * Parse the app from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).app;
  }

  /**
   * Parse the toolset from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the toolset.
   */
  matchToolsetFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).toolset;
  }

  /**
   * Terminate the gRPC channel and close the client.
   *
   * The client will no longer be usable and all future behavior is undefined.
   * @returns {Promise} A promise that resolves when the client is closed.
   */
  close(): Promise<void> {
    if (this.sessionServiceStub && !this._terminated) {
      return this.sessionServiceStub.then(stub => {
        this._log.info('ending gRPC channel');
        this._terminated = true;
        stub.close();
        this.locationsClient.close().catch(err => {throw err});
      });
    }
    return Promise.resolve();
  }
}