// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

import * as protos from '../protos/protos';
import * as assert from 'assert';
import * as sinon from 'sinon';
import {SinonStub} from 'sinon';
import {describe, it} from 'mocha';
import * as toolserviceModule from '../src';

import {protobuf, LocationProtos} from 'google-gax';

// Dynamically loaded proto JSON is needed to get the type information
// to fill in default values for request objects
const root = protobuf.Root.fromJSON(require('../protos/protos.json')).resolveAll();

// eslint-disable-next-line @typescript-eslint/no-unused-vars
function getTypeDefaultValue(typeName: string, fields: string[]) {
    let type = root.lookupType(typeName) as protobuf.Type;
    for (const field of fields.slice(0, -1)) {
        type = type.fields[field]?.resolvedType as protobuf.Type;
    }
    return type.fields[fields[fields.length - 1]]?.defaultValue;
}

function generateSampleMessage<T extends object>(instance: T) {
    const filledObject = (instance.constructor as typeof protobuf.Message)
        .toObject(instance as protobuf.Message<T>, {defaults: true});
    return (instance.constructor as typeof protobuf.Message).fromObject(filledObject) as T;
}

function stubSimpleCall<ResponseType>(response?: ResponseType, error?: Error) {
    return error ? sinon.stub().rejects(error) : sinon.stub().resolves([response]);
}

function stubSimpleCallWithCallback<ResponseType>(response?: ResponseType, error?: Error) {
    return error ? sinon.stub().callsArgWith(2, error) : sinon.stub().callsArgWith(2, null, response);
}

function stubAsyncIterationCall<ResponseType>(responses?: ResponseType[], error?: Error) {
    let counter = 0;
    const asyncIterable = {
        [Symbol.asyncIterator]() {
            return {
                async next() {
                    if (error) {
                        return Promise.reject(error);
                    }
                    if (counter >= responses!.length) {
                        return Promise.resolve({done: true, value: undefined});
                    }
                    return Promise.resolve({done: false, value: responses![counter++]});
                }
            };
        }
    };
    return sinon.stub().returns(asyncIterable);
}

describe('v1.ToolServiceClient', () => {
    describe('Common methods', () => {
        it('has apiEndpoint', () => {
            const client = new toolserviceModule.v1.ToolServiceClient();
            const apiEndpoint = client.apiEndpoint;
            assert.strictEqual(apiEndpoint, 'ces.googleapis.com');
        });

        it('has universeDomain', () => {
            const client = new toolserviceModule.v1.ToolServiceClient();
            const universeDomain = client.universeDomain;
            assert.strictEqual(universeDomain, "googleapis.com");
        });

        if (typeof process === 'object' && typeof process.emitWarning === 'function') {
            it('throws DeprecationWarning if static servicePath is used', () => {
                const stub = sinon.stub(process, 'emitWarning');
                const servicePath = toolserviceModule.v1.ToolServiceClient.servicePath;
                assert.strictEqual(servicePath, 'ces.googleapis.com');
                assert(stub.called);
                stub.restore();
            });

            it('throws DeprecationWarning if static apiEndpoint is used', () => {
                const stub = sinon.stub(process, 'emitWarning');
                const apiEndpoint = toolserviceModule.v1.ToolServiceClient.apiEndpoint;
                assert.strictEqual(apiEndpoint, 'ces.googleapis.com');
                assert(stub.called);
                stub.restore();
            });
        }
        it('sets apiEndpoint according to universe domain camelCase', () => {
            const client = new toolserviceModule.v1.ToolServiceClient({universeDomain: 'example.com'});
            const servicePath = client.apiEndpoint;
            assert.strictEqual(servicePath, 'ces.example.com');
        });

        it('sets apiEndpoint according to universe domain snakeCase', () => {
            const client = new toolserviceModule.v1.ToolServiceClient({universe_domain: 'example.com'});
            const servicePath = client.apiEndpoint;
            assert.strictEqual(servicePath, 'ces.example.com');
        });

        if (typeof process === 'object' && 'env' in process) {
            describe('GOOGLE_CLOUD_UNIVERSE_DOMAIN environment variable', () => {
                it('sets apiEndpoint from environment variable', () => {
                    const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
                    const client = new toolserviceModule.v1.ToolServiceClient();
                    const servicePath = client.apiEndpoint;
                    assert.strictEqual(servicePath, 'ces.example.com');
                    if (saved) {
                        process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
                    } else {
                        delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    }
                });

                it('value configured in code has priority over environment variable', () => {
                    const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
                    const client = new toolserviceModule.v1.ToolServiceClient({universeDomain: 'configured.example.com'});
                    const servicePath = client.apiEndpoint;
                    assert.strictEqual(servicePath, 'ces.configured.example.com');
                    if (saved) {
                        process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
                    } else {
                        delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    }
                });
            });
        }
        it('does not allow setting both universeDomain and universe_domain', () => {
            assert.throws(() => { new toolserviceModule.v1.ToolServiceClient({universe_domain: 'example.com', universeDomain: 'example.net'}); });
        });

        it('has port', () => {
            const port = toolserviceModule.v1.ToolServiceClient.port;
            assert(port);
            assert(typeof port === 'number');
        });

        it('should create a client with no option', () => {
            const client = new toolserviceModule.v1.ToolServiceClient();
            assert(client);
        });

        it('should create a client with gRPC fallback', () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
                fallback: true,
            });
            assert(client);
        });

        it('has initialize method and supports deferred initialization', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            assert.strictEqual(client.toolServiceStub, undefined);
            await client.initialize();
            assert(client.toolServiceStub);
        });

        it('has close method for the initialized client', done => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            client.initialize().catch(err => {throw err});
            assert(client.toolServiceStub);
            client.close().then(() => {
                done();
            }).catch(err => {throw err});
        });

        it('has close method for the non-initialized client', done => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            assert.strictEqual(client.toolServiceStub, undefined);
            client.close().then(() => {
                done();
            }).catch(err => {throw err});
        });

        it('has getProjectId method', async () => {
            const fakeProjectId = 'fake-project-id';
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            client.auth.getProjectId = sinon.stub().resolves(fakeProjectId);
            const result = await client.getProjectId();
            assert.strictEqual(result, fakeProjectId);
            assert((client.auth.getProjectId as SinonStub).calledWithExactly());
        });

        it('has getProjectId method with callback', async () => {
            const fakeProjectId = 'fake-project-id';
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            client.auth.getProjectId = sinon.stub().callsArgWith(0, null, fakeProjectId);
            const promise = new Promise((resolve, reject) => {
                client.getProjectId((err?: Error|null, projectId?: string|null) => {
                    if (err) {
                        reject(err);
                    } else {
                        resolve(projectId);
                    }
                });
            });
            const result = await promise;
            assert.strictEqual(result, fakeProjectId);
        });
    });

    describe('executeTool', () => {
        it('invokes executeTool without error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.ExecuteToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.ExecuteToolRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1.ExecuteToolResponse()
            );
            client.innerApiCalls.executeTool = stubSimpleCall(expectedResponse);
            const [response] = await client.executeTool(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.executeTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.executeTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes executeTool without error using callback', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.ExecuteToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.ExecuteToolRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1.ExecuteToolResponse()
            );
            client.innerApiCalls.executeTool = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.executeTool(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1.IExecuteToolResponse|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.executeTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.executeTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes executeTool with error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.ExecuteToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.ExecuteToolRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.executeTool = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.executeTool(request), expectedError);
            const actualRequest = (client.innerApiCalls.executeTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.executeTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes executeTool with closed client', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.ExecuteToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.ExecuteToolRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.executeTool(request), expectedError);
        });
    });

    describe('retrieveToolSchema', () => {
        it('invokes retrieveToolSchema without error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolSchemaRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.RetrieveToolSchemaRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolSchemaResponse()
            );
            client.innerApiCalls.retrieveToolSchema = stubSimpleCall(expectedResponse);
            const [response] = await client.retrieveToolSchema(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.retrieveToolSchema as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.retrieveToolSchema as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes retrieveToolSchema without error using callback', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolSchemaRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.RetrieveToolSchemaRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolSchemaResponse()
            );
            client.innerApiCalls.retrieveToolSchema = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.retrieveToolSchema(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1.IRetrieveToolSchemaResponse|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.retrieveToolSchema as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.retrieveToolSchema as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes retrieveToolSchema with error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolSchemaRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.RetrieveToolSchemaRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.retrieveToolSchema = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.retrieveToolSchema(request), expectedError);
            const actualRequest = (client.innerApiCalls.retrieveToolSchema as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.retrieveToolSchema as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes retrieveToolSchema with closed client', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolSchemaRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.RetrieveToolSchemaRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.retrieveToolSchema(request), expectedError);
        });
    });

    describe('retrieveTools', () => {
        it('invokes retrieveTools without error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.RetrieveToolsRequest', ['toolset']);
            request.toolset = defaultValue1;
            const expectedHeaderRequestParams = `toolset=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolsResponse()
            );
            client.innerApiCalls.retrieveTools = stubSimpleCall(expectedResponse);
            const [response] = await client.retrieveTools(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.retrieveTools as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.retrieveTools as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes retrieveTools without error using callback', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.RetrieveToolsRequest', ['toolset']);
            request.toolset = defaultValue1;
            const expectedHeaderRequestParams = `toolset=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolsResponse()
            );
            client.innerApiCalls.retrieveTools = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.retrieveTools(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1.IRetrieveToolsResponse|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.retrieveTools as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.retrieveTools as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes retrieveTools with error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.RetrieveToolsRequest', ['toolset']);
            request.toolset = defaultValue1;
            const expectedHeaderRequestParams = `toolset=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.retrieveTools = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.retrieveTools(request), expectedError);
            const actualRequest = (client.innerApiCalls.retrieveTools as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.retrieveTools as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes retrieveTools with closed client', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1.RetrieveToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1.RetrieveToolsRequest', ['toolset']);
            request.toolset = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.retrieveTools(request), expectedError);
        });
    });
    describe('getLocation', () => {
        it('invokes getLocation without error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.GetLocationRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedOptions = {
                otherArgs: {
                    headers: {
                        'x-goog-request-params': expectedHeaderRequestParams,
                    },
                },
            };
            const expectedResponse = generateSampleMessage(
              new LocationProtos.google.cloud.location.Location()
            );
            client.locationsClient.getLocation = stubSimpleCall(expectedResponse);
            const response = await client.getLocation(request, expectedOptions);
            assert.deepStrictEqual(response, [expectedResponse]);
            assert((client.locationsClient.getLocation as SinonStub)
                .getCall(0).calledWith(request, expectedOptions, undefined));
        });
        it('invokes getLocation without error using callback', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.GetLocationRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedOptions = {
                otherArgs: {
                    headers: {
                        'x-goog-request-params': expectedHeaderRequestParams,
                    },
                },
            };
            const expectedResponse = generateSampleMessage(
              new LocationProtos.google.cloud.location.Location()
            );
            client.locationsClient.getLocation = sinon.stub().callsArgWith(2, null, expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getLocation(
                    request,
                    expectedOptions,
                    (
                        err?: Error | null,
                        result?: LocationProtos.google.cloud.location.ILocation | null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            assert((client.locationsClient.getLocation as SinonStub)
                .getCall(0));
        });
        it('invokes getLocation with error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.GetLocationRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedOptions = {
                otherArgs: {
                    headers: {
                        'x-goog-request-params': expectedHeaderRequestParams,
                    },
                },
            };
            const expectedError = new Error('expected');
            client.locationsClient.getLocation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getLocation(request, expectedOptions), expectedError);
            assert((client.locationsClient.getLocation as SinonStub)
                .getCall(0).calledWith(request, expectedOptions, undefined));
        });
    });
    describe('listLocationsAsync', () => {
        it('uses async iteration with listLocations without error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
                new LocationProtos.google.cloud.location.ListLocationsRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedResponse = [
                generateSampleMessage(
                    new LocationProtos.google.cloud.location.Location()
                ),
                generateSampleMessage(
                    new LocationProtos.google.cloud.location.Location()
                ),
                generateSampleMessage(
                    new LocationProtos.google.cloud.location.Location()
                ),
            ];
            client.locationsClient.descriptors.page.listLocations.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: LocationProtos.google.cloud.location.ILocation[] = [];
            const iterable = client.listLocationsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
        it('uses async iteration with listLocations with error', async () => {
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.ListLocationsRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedError = new Error('expected');
            client.locationsClient.descriptors.page.listLocations.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listLocationsAsync(request);
            await assert.rejects(async () => {
                const responses: LocationProtos.google.cloud.location.ILocation[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('Path templates', () => {

        describe('agent', async () => {
            const fakePath = "/rendered/path/agent";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                agent: "agentValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.agentPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.agentPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('agentPath', () => {
                const result = client.agentPath("projectValue", "locationValue", "appValue", "agentValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.agentPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromAgentName', () => {
                const result = client.matchProjectFromAgentName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromAgentName', () => {
                const result = client.matchLocationFromAgentName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromAgentName', () => {
                const result = client.matchAppFromAgentName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAgentFromAgentName', () => {
                const result = client.matchAgentFromAgentName(fakePath);
                assert.strictEqual(result, "agentValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('app', async () => {
            const fakePath = "/rendered/path/app";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.appPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.appPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('appPath', () => {
                const result = client.appPath("projectValue", "locationValue", "appValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.appPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromAppName', () => {
                const result = client.matchProjectFromAppName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.appPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromAppName', () => {
                const result = client.matchLocationFromAppName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.appPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromAppName', () => {
                const result = client.matchAppFromAppName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.appPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('appVersion', async () => {
            const fakePath = "/rendered/path/appVersion";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                version: "versionValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.appVersionPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.appVersionPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('appVersionPath', () => {
                const result = client.appVersionPath("projectValue", "locationValue", "appValue", "versionValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.appVersionPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromAppVersionName', () => {
                const result = client.matchProjectFromAppVersionName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromAppVersionName', () => {
                const result = client.matchLocationFromAppVersionName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromAppVersionName', () => {
                const result = client.matchAppFromAppVersionName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchVersionFromAppVersionName', () => {
                const result = client.matchVersionFromAppVersionName(fakePath);
                assert.strictEqual(result, "versionValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('changelog', async () => {
            const fakePath = "/rendered/path/changelog";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                changelog: "changelogValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.changelogPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.changelogPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('changelogPath', () => {
                const result = client.changelogPath("projectValue", "locationValue", "appValue", "changelogValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.changelogPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromChangelogName', () => {
                const result = client.matchProjectFromChangelogName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromChangelogName', () => {
                const result = client.matchLocationFromChangelogName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromChangelogName', () => {
                const result = client.matchAppFromChangelogName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchChangelogFromChangelogName', () => {
                const result = client.matchChangelogFromChangelogName(fakePath);
                assert.strictEqual(result, "changelogValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('conversation', async () => {
            const fakePath = "/rendered/path/conversation";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                conversation: "conversationValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.conversationPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.conversationPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('conversationPath', () => {
                const result = client.conversationPath("projectValue", "locationValue", "appValue", "conversationValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.conversationPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromConversationName', () => {
                const result = client.matchProjectFromConversationName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromConversationName', () => {
                const result = client.matchLocationFromConversationName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromConversationName', () => {
                const result = client.matchAppFromConversationName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchConversationFromConversationName', () => {
                const result = client.matchConversationFromConversationName(fakePath);
                assert.strictEqual(result, "conversationValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('deployment', async () => {
            const fakePath = "/rendered/path/deployment";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                deployment: "deploymentValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.deploymentPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.deploymentPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('deploymentPath', () => {
                const result = client.deploymentPath("projectValue", "locationValue", "appValue", "deploymentValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.deploymentPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromDeploymentName', () => {
                const result = client.matchProjectFromDeploymentName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromDeploymentName', () => {
                const result = client.matchLocationFromDeploymentName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromDeploymentName', () => {
                const result = client.matchAppFromDeploymentName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchDeploymentFromDeploymentName', () => {
                const result = client.matchDeploymentFromDeploymentName(fakePath);
                assert.strictEqual(result, "deploymentValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('example', async () => {
            const fakePath = "/rendered/path/example";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                example: "exampleValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.examplePathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.examplePathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('examplePath', () => {
                const result = client.examplePath("projectValue", "locationValue", "appValue", "exampleValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.examplePathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromExampleName', () => {
                const result = client.matchProjectFromExampleName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromExampleName', () => {
                const result = client.matchLocationFromExampleName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromExampleName', () => {
                const result = client.matchAppFromExampleName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchExampleFromExampleName', () => {
                const result = client.matchExampleFromExampleName(fakePath);
                assert.strictEqual(result, "exampleValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('guardrail', async () => {
            const fakePath = "/rendered/path/guardrail";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                guardrail: "guardrailValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.guardrailPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.guardrailPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('guardrailPath', () => {
                const result = client.guardrailPath("projectValue", "locationValue", "appValue", "guardrailValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.guardrailPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromGuardrailName', () => {
                const result = client.matchProjectFromGuardrailName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromGuardrailName', () => {
                const result = client.matchLocationFromGuardrailName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromGuardrailName', () => {
                const result = client.matchAppFromGuardrailName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchGuardrailFromGuardrailName', () => {
                const result = client.matchGuardrailFromGuardrailName(fakePath);
                assert.strictEqual(result, "guardrailValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('omnichannel', async () => {
            const fakePath = "/rendered/path/omnichannel";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                omnichannel: "omnichannelValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.omnichannelPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.omnichannelPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('omnichannelPath', () => {
                const result = client.omnichannelPath("projectValue", "locationValue", "omnichannelValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.omnichannelPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromOmnichannelName', () => {
                const result = client.matchProjectFromOmnichannelName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.omnichannelPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromOmnichannelName', () => {
                const result = client.matchLocationFromOmnichannelName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.omnichannelPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchOmnichannelFromOmnichannelName', () => {
                const result = client.matchOmnichannelFromOmnichannelName(fakePath);
                assert.strictEqual(result, "omnichannelValue");
                assert((client.pathTemplates.omnichannelPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('tool', async () => {
            const fakePath = "/rendered/path/tool";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                tool: "toolValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.toolPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.toolPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('toolPath', () => {
                const result = client.toolPath("projectValue", "locationValue", "appValue", "toolValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.toolPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromToolName', () => {
                const result = client.matchProjectFromToolName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromToolName', () => {
                const result = client.matchLocationFromToolName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromToolName', () => {
                const result = client.matchAppFromToolName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchToolFromToolName', () => {
                const result = client.matchToolFromToolName(fakePath);
                assert.strictEqual(result, "toolValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('toolset', async () => {
            const fakePath = "/rendered/path/toolset";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                toolset: "toolsetValue",
            };
            const client = new toolserviceModule.v1.ToolServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.toolsetPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.toolsetPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('toolsetPath', () => {
                const result = client.toolsetPath("projectValue", "locationValue", "appValue", "toolsetValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.toolsetPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromToolsetName', () => {
                const result = client.matchProjectFromToolsetName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromToolsetName', () => {
                const result = client.matchLocationFromToolsetName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromToolsetName', () => {
                const result = client.matchAppFromToolsetName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchToolsetFromToolsetName', () => {
                const result = client.matchToolsetFromToolsetName(fakePath);
                assert.strictEqual(result, "toolsetValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });
    });
});
