// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated code. DO NOT EDIT!

#pragma warning disable CS8981
using gax = Google.Api.Gax;
using gccv = Google.Cloud.Ces.V1;
using sys = System;

namespace Google.Cloud.Ces.V1
{
    /// <summary>Resource name for the <c>Omnichannel</c> resource.</summary>
    public sealed partial class OmnichannelName : gax::IResourceName, sys::IEquatable<OmnichannelName>
    {
        /// <summary>The possible contents of <see cref="OmnichannelName"/>.</summary>
        public enum ResourceNameType
        {
            /// <summary>An unparsed resource name.</summary>
            Unparsed = 0,

            /// <summary>
            /// A resource name with pattern <c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c>.
            /// </summary>
            ProjectLocationOmnichannel = 1,
        }

        private static gax::PathTemplate s_projectLocationOmnichannel = new gax::PathTemplate("projects/{project}/locations/{location}/omnichannels/{omnichannel}");

        /// <summary>Creates a <see cref="OmnichannelName"/> containing an unparsed resource name.</summary>
        /// <param name="unparsedResourceName">The unparsed resource name. Must not be <c>null</c>.</param>
        /// <returns>
        /// A new instance of <see cref="OmnichannelName"/> containing the provided
        /// <paramref name="unparsedResourceName"/>.
        /// </returns>
        public static OmnichannelName FromUnparsed(gax::UnparsedResourceName unparsedResourceName) =>
            new OmnichannelName(ResourceNameType.Unparsed, gax::GaxPreconditions.CheckNotNull(unparsedResourceName, nameof(unparsedResourceName)));

        /// <summary>
        /// Creates a <see cref="OmnichannelName"/> with the pattern
        /// <c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c>.
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="omnichannelId">The <c>Omnichannel</c> ID. Must not be <c>null</c> or empty.</param>
        /// <returns>A new instance of <see cref="OmnichannelName"/> constructed from the provided ids.</returns>
        public static OmnichannelName FromProjectLocationOmnichannel(string projectId, string locationId, string omnichannelId) =>
            new OmnichannelName(ResourceNameType.ProjectLocationOmnichannel, projectId: gax::GaxPreconditions.CheckNotNullOrEmpty(projectId, nameof(projectId)), locationId: gax::GaxPreconditions.CheckNotNullOrEmpty(locationId, nameof(locationId)), omnichannelId: gax::GaxPreconditions.CheckNotNullOrEmpty(omnichannelId, nameof(omnichannelId)));

        /// <summary>
        /// Formats the IDs into the string representation of this <see cref="OmnichannelName"/> with pattern
        /// <c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c>.
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="omnichannelId">The <c>Omnichannel</c> ID. Must not be <c>null</c> or empty.</param>
        /// <returns>
        /// The string representation of this <see cref="OmnichannelName"/> with pattern
        /// <c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c>.
        /// </returns>
        public static string Format(string projectId, string locationId, string omnichannelId) =>
            FormatProjectLocationOmnichannel(projectId, locationId, omnichannelId);

        /// <summary>
        /// Formats the IDs into the string representation of this <see cref="OmnichannelName"/> with pattern
        /// <c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c>.
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="omnichannelId">The <c>Omnichannel</c> ID. Must not be <c>null</c> or empty.</param>
        /// <returns>
        /// The string representation of this <see cref="OmnichannelName"/> with pattern
        /// <c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c>.
        /// </returns>
        public static string FormatProjectLocationOmnichannel(string projectId, string locationId, string omnichannelId) =>
            s_projectLocationOmnichannel.Expand(gax::GaxPreconditions.CheckNotNullOrEmpty(projectId, nameof(projectId)), gax::GaxPreconditions.CheckNotNullOrEmpty(locationId, nameof(locationId)), gax::GaxPreconditions.CheckNotNullOrEmpty(omnichannelId, nameof(omnichannelId)));

        /// <summary>Parses the given resource name string into a new <see cref="OmnichannelName"/> instance.</summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item>
        /// <description><c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c></description>
        /// </item>
        /// </list>
        /// </remarks>
        /// <param name="omnichannelName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <returns>The parsed <see cref="OmnichannelName"/> if successful.</returns>
        public static OmnichannelName Parse(string omnichannelName) => Parse(omnichannelName, false);

        /// <summary>
        /// Parses the given resource name string into a new <see cref="OmnichannelName"/> instance; optionally allowing
        /// an unparseable resource name.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item>
        /// <description><c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c></description>
        /// </item>
        /// </list>
        /// Or may be in any format if <paramref name="allowUnparsed"/> is <c>true</c>.
        /// </remarks>
        /// <param name="omnichannelName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <param name="allowUnparsed">
        /// If <c>true</c> will successfully store an unparseable resource name into the <see cref="UnparsedResource"/>
        /// property; otherwise will throw an <see cref="sys::ArgumentException"/> if an unparseable resource name is
        /// specified.
        /// </param>
        /// <returns>The parsed <see cref="OmnichannelName"/> if successful.</returns>
        public static OmnichannelName Parse(string omnichannelName, bool allowUnparsed) =>
            TryParse(omnichannelName, allowUnparsed, out OmnichannelName result) ? result : throw new sys::ArgumentException("The given resource-name matches no pattern.");

        /// <summary>
        /// Tries to parse the given resource name string into a new <see cref="OmnichannelName"/> instance.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item>
        /// <description><c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c></description>
        /// </item>
        /// </list>
        /// </remarks>
        /// <param name="omnichannelName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <param name="result">
        /// When this method returns, the parsed <see cref="OmnichannelName"/>, or <c>null</c> if parsing failed.
        /// </param>
        /// <returns><c>true</c> if the name was parsed successfully; <c>false</c> otherwise.</returns>
        public static bool TryParse(string omnichannelName, out OmnichannelName result) =>
            TryParse(omnichannelName, false, out result);

        /// <summary>
        /// Tries to parse the given resource name string into a new <see cref="OmnichannelName"/> instance; optionally
        /// allowing an unparseable resource name.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item>
        /// <description><c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c></description>
        /// </item>
        /// </list>
        /// Or may be in any format if <paramref name="allowUnparsed"/> is <c>true</c>.
        /// </remarks>
        /// <param name="omnichannelName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <param name="allowUnparsed">
        /// If <c>true</c> will successfully store an unparseable resource name into the <see cref="UnparsedResource"/>
        /// property; otherwise will throw an <see cref="sys::ArgumentException"/> if an unparseable resource name is
        /// specified.
        /// </param>
        /// <param name="result">
        /// When this method returns, the parsed <see cref="OmnichannelName"/>, or <c>null</c> if parsing failed.
        /// </param>
        /// <returns><c>true</c> if the name was parsed successfully; <c>false</c> otherwise.</returns>
        public static bool TryParse(string omnichannelName, bool allowUnparsed, out OmnichannelName result)
        {
            gax::GaxPreconditions.CheckNotNull(omnichannelName, nameof(omnichannelName));
            gax::TemplatedResourceName resourceName;
            if (s_projectLocationOmnichannel.TryParseName(omnichannelName, out resourceName))
            {
                result = FromProjectLocationOmnichannel(resourceName[0], resourceName[1], resourceName[2]);
                return true;
            }
            if (allowUnparsed)
            {
                if (gax::UnparsedResourceName.TryParse(omnichannelName, out gax::UnparsedResourceName unparsedResourceName))
                {
                    result = FromUnparsed(unparsedResourceName);
                    return true;
                }
            }
            result = null;
            return false;
        }

        private OmnichannelName(ResourceNameType type, gax::UnparsedResourceName unparsedResourceName = null, string locationId = null, string omnichannelId = null, string projectId = null)
        {
            Type = type;
            UnparsedResource = unparsedResourceName;
            LocationId = locationId;
            OmnichannelId = omnichannelId;
            ProjectId = projectId;
        }

        /// <summary>
        /// Constructs a new instance of a <see cref="OmnichannelName"/> class from the component parts of pattern
        /// <c>projects/{project}/locations/{location}/omnichannels/{omnichannel}</c>
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="omnichannelId">The <c>Omnichannel</c> ID. Must not be <c>null</c> or empty.</param>
        public OmnichannelName(string projectId, string locationId, string omnichannelId) : this(ResourceNameType.ProjectLocationOmnichannel, projectId: gax::GaxPreconditions.CheckNotNullOrEmpty(projectId, nameof(projectId)), locationId: gax::GaxPreconditions.CheckNotNullOrEmpty(locationId, nameof(locationId)), omnichannelId: gax::GaxPreconditions.CheckNotNullOrEmpty(omnichannelId, nameof(omnichannelId)))
        {
        }

        /// <summary>The <see cref="ResourceNameType"/> of the contained resource name.</summary>
        public ResourceNameType Type { get; }

        /// <summary>
        /// The contained <see cref="gax::UnparsedResourceName"/>. Only non-<c>null</c> if this instance contains an
        /// unparsed resource name.
        /// </summary>
        public gax::UnparsedResourceName UnparsedResource { get; }

        /// <summary>
        /// The <c>Location</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string LocationId { get; }

        /// <summary>
        /// The <c>Omnichannel</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string OmnichannelId { get; }

        /// <summary>
        /// The <c>Project</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string ProjectId { get; }

        /// <summary>Whether this instance contains a resource name with a known pattern.</summary>
        public bool IsKnownPattern => Type != ResourceNameType.Unparsed;

        /// <summary>The string representation of the resource name.</summary>
        /// <returns>The string representation of the resource name.</returns>
        public override string ToString()
        {
            switch (Type)
            {
                case ResourceNameType.Unparsed: return UnparsedResource.ToString();
                case ResourceNameType.ProjectLocationOmnichannel: return s_projectLocationOmnichannel.Expand(ProjectId, LocationId, OmnichannelId);
                default: throw new sys::InvalidOperationException("Unrecognized resource-type.");
            }
        }

        /// <summary>Returns a hash code for this resource name.</summary>
        public override int GetHashCode() => ToString().GetHashCode();

        /// <inheritdoc/>
        public override bool Equals(object obj) => Equals(obj as OmnichannelName);

        /// <inheritdoc/>
        public bool Equals(OmnichannelName other) => ToString() == other?.ToString();

        /// <summary>Determines whether two specified resource names have the same value.</summary>
        /// <param name="a">The first resource name to compare, or null.</param>
        /// <param name="b">The second resource name to compare, or null.</param>
        /// <returns>
        /// true if the value of <paramref name="a"/> is the same as the value of <paramref name="b"/>; otherwise,
        /// false.
        /// </returns>
        public static bool operator ==(OmnichannelName a, OmnichannelName b) => ReferenceEquals(a, b) || (a?.Equals(b) ?? false);

        /// <summary>Determines whether two specified resource names have different values.</summary>
        /// <param name="a">The first resource name to compare, or null.</param>
        /// <param name="b">The second resource name to compare, or null.</param>
        /// <returns>
        /// true if the value of <paramref name="a"/> is different from the value of <paramref name="b"/>; otherwise,
        /// false.
        /// </returns>
        public static bool operator !=(OmnichannelName a, OmnichannelName b) => !(a == b);
    }

    public partial class Omnichannel
    {
        /// <summary>
        /// <see cref="gccv::OmnichannelName"/>-typed view over the <see cref="Name"/> resource name property.
        /// </summary>
        public gccv::OmnichannelName OmnichannelName
        {
            get => string.IsNullOrEmpty(Name) ? null : gccv::OmnichannelName.Parse(Name, allowUnparsed: true);
            set => Name = value?.ToString() ?? "";
        }
    }

    public partial class OmnichannelIntegrationConfig
    {
        public partial class Types
        {
            public partial class CesAppConfig
            {
                /// <summary>
                /// <see cref="AppName"/>-typed view over the <see cref="App"/> resource name property.
                /// </summary>
                public AppName AppAsAppName
                {
                    get => string.IsNullOrEmpty(App) ? null : AppName.Parse(App, allowUnparsed: true);
                    set => App = value?.ToString() ?? "";
                }
            }
        }
    }
}
