<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/agent.proto

namespace Google\Cloud\Ces\V1\Agent;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The agent which will transfer execution to a remote
 * [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
 * agent flow. The Dialogflow agent will process subsequent user queries until
 * the session ends or flow ends, and the control is transferred back to the
 * parent CES agent.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.Agent.RemoteDialogflowAgent</code>
 */
class RemoteDialogflowAgent extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The
     * [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents
     * agent resource name.
     * Format: `projects/{project}/locations/{location}/agents/{agent}`
     *
     * Generated from protobuf field <code>string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $agent = '';
    /**
     * Required. The flow ID of the flow in the Dialogflow agent.
     *
     * Generated from protobuf field <code>string flow_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $flow_id = '';
    /**
     * Optional. The environment ID of the Dialogflow agent to be used for the
     * agent execution. If not specified, the draft environment will be used.
     *
     * Generated from protobuf field <code>string environment_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $environment_id = '';
    /**
     * Optional. The mapping of the app variables names to the Dialogflow
     * session parameters names to be sent to the Dialogflow agent as input.
     *
     * Generated from protobuf field <code>map<string, string> input_variable_mapping = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $input_variable_mapping;
    /**
     * Optional. The mapping of the Dialogflow session parameters names to the
     * app variables names to be sent back to the CES agent after the Dialogflow
     * agent execution ends.
     *
     * Generated from protobuf field <code>map<string, string> output_variable_mapping = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $output_variable_mapping;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $agent
     *           Required. The
     *           [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents
     *           agent resource name.
     *           Format: `projects/{project}/locations/{location}/agents/{agent}`
     *     @type string $flow_id
     *           Required. The flow ID of the flow in the Dialogflow agent.
     *     @type string $environment_id
     *           Optional. The environment ID of the Dialogflow agent to be used for the
     *           agent execution. If not specified, the draft environment will be used.
     *     @type array|\Google\Protobuf\Internal\MapField $input_variable_mapping
     *           Optional. The mapping of the app variables names to the Dialogflow
     *           session parameters names to be sent to the Dialogflow agent as input.
     *     @type array|\Google\Protobuf\Internal\MapField $output_variable_mapping
     *           Optional. The mapping of the Dialogflow session parameters names to the
     *           app variables names to be sent back to the CES agent after the Dialogflow
     *           agent execution ends.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\Agent::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The
     * [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents
     * agent resource name.
     * Format: `projects/{project}/locations/{location}/agents/{agent}`
     *
     * Generated from protobuf field <code>string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAgent()
    {
        return $this->agent;
    }

    /**
     * Required. The
     * [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents
     * agent resource name.
     * Format: `projects/{project}/locations/{location}/agents/{agent}`
     *
     * Generated from protobuf field <code>string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAgent($var)
    {
        GPBUtil::checkString($var, True);
        $this->agent = $var;

        return $this;
    }

    /**
     * Required. The flow ID of the flow in the Dialogflow agent.
     *
     * Generated from protobuf field <code>string flow_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getFlowId()
    {
        return $this->flow_id;
    }

    /**
     * Required. The flow ID of the flow in the Dialogflow agent.
     *
     * Generated from protobuf field <code>string flow_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setFlowId($var)
    {
        GPBUtil::checkString($var, True);
        $this->flow_id = $var;

        return $this;
    }

    /**
     * Optional. The environment ID of the Dialogflow agent to be used for the
     * agent execution. If not specified, the draft environment will be used.
     *
     * Generated from protobuf field <code>string environment_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEnvironmentId()
    {
        return $this->environment_id;
    }

    /**
     * Optional. The environment ID of the Dialogflow agent to be used for the
     * agent execution. If not specified, the draft environment will be used.
     *
     * Generated from protobuf field <code>string environment_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEnvironmentId($var)
    {
        GPBUtil::checkString($var, True);
        $this->environment_id = $var;

        return $this;
    }

    /**
     * Optional. The mapping of the app variables names to the Dialogflow
     * session parameters names to be sent to the Dialogflow agent as input.
     *
     * Generated from protobuf field <code>map<string, string> input_variable_mapping = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getInputVariableMapping()
    {
        return $this->input_variable_mapping;
    }

    /**
     * Optional. The mapping of the app variables names to the Dialogflow
     * session parameters names to be sent to the Dialogflow agent as input.
     *
     * Generated from protobuf field <code>map<string, string> input_variable_mapping = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setInputVariableMapping($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->input_variable_mapping = $arr;

        return $this;
    }

    /**
     * Optional. The mapping of the Dialogflow session parameters names to the
     * app variables names to be sent back to the CES agent after the Dialogflow
     * agent execution ends.
     *
     * Generated from protobuf field <code>map<string, string> output_variable_mapping = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getOutputVariableMapping()
    {
        return $this->output_variable_mapping;
    }

    /**
     * Optional. The mapping of the Dialogflow session parameters names to the
     * app variables names to be sent back to the CES agent after the Dialogflow
     * agent execution ends.
     *
     * Generated from protobuf field <code>map<string, string> output_variable_mapping = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setOutputVariableMapping($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->output_variable_mapping = $arr;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RemoteDialogflowAgent::class, \Google\Cloud\Ces\V1\Agent_RemoteDialogflowAgent::class);

