<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/app.proto

namespace Google\Cloud\Ces\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for the ambient sound to be played with the synthesized agent
 * response, to enhance the naturalness of the conversation.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.AmbientSoundConfig</code>
 */
class AmbientSoundConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Volume gain (in dB) of the normal native volume supported by
     * ambient noise, in the range [-96.0, 16.0]. If unset, or set to a value of
     * 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
     * will play at approximately half the amplitude of the normal native signal
     * amplitude. A value of +6.0 (dB) will play at approximately twice the
     * amplitude of the normal native signal amplitude. We strongly recommend not
     * to exceed +10 (dB) as there's usually no effective increase in loudness for
     * any value greater than that.
     *
     * Generated from protobuf field <code>double volume_gain_db = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $volume_gain_db = 0.0;
    protected $source;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $prebuilt_ambient_noise
     *           Optional. Prebuilt ambient noise.
     *     @type string $gcs_uri
     *           Optional. Ambient noise as a mono-channel, 16kHz WAV file stored in
     *           [Cloud Storage](https://cloud.google.com/storage).
     *           Note: Please make sure the CES service agent
     *           `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com` has
     *           `storage.objects.get` permission to the Cloud Storage object.
     *     @type string $prebuilt_ambient_sound
     *           Optional. Name of the prebuilt ambient sound.
     *           Valid values are:
     *           - "coffee_shop"
     *           - "keyboard"
     *           - "keypad"
     *           - "hum"
     *           - "office_1"
     *           - "office_2"
     *           - "office_3"
     *           - "room_1"
     *           - "room_2"
     *           - "room_3"
     *           - "room_4"
     *           - "room_5"
     *           - "air_conditioner"
     *     @type float $volume_gain_db
     *           Optional. Volume gain (in dB) of the normal native volume supported by
     *           ambient noise, in the range [-96.0, 16.0]. If unset, or set to a value of
     *           0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
     *           will play at approximately half the amplitude of the normal native signal
     *           amplitude. A value of +6.0 (dB) will play at approximately twice the
     *           amplitude of the normal native signal amplitude. We strongly recommend not
     *           to exceed +10 (dB) as there's usually no effective increase in loudness for
     *           any value greater than that.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\App::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Prebuilt ambient noise.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.AmbientSoundConfig.PrebuiltAmbientNoise prebuilt_ambient_noise = 1 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     * @deprecated
     */
    public function getPrebuiltAmbientNoise()
    {
        if ($this->hasOneof(1)) {
            @trigger_error('prebuilt_ambient_noise is deprecated.', E_USER_DEPRECATED);
        }
        return $this->readOneof(1);
    }

    public function hasPrebuiltAmbientNoise()
    {
        if ($this->hasOneof(1)) {
            @trigger_error('prebuilt_ambient_noise is deprecated.', E_USER_DEPRECATED);
        }
        return $this->hasOneof(1);
    }

    /**
     * Optional. Prebuilt ambient noise.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.AmbientSoundConfig.PrebuiltAmbientNoise prebuilt_ambient_noise = 1 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setPrebuiltAmbientNoise($var)
    {
        @trigger_error('prebuilt_ambient_noise is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkEnum($var, \Google\Cloud\Ces\V1\AmbientSoundConfig\PrebuiltAmbientNoise::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Optional. Ambient noise as a mono-channel, 16kHz WAV file stored in
     * [Cloud Storage](https://cloud.google.com/storage).
     * Note: Please make sure the CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com` has
     * `storage.objects.get` permission to the Cloud Storage object.
     *
     * Generated from protobuf field <code>string gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getGcsUri()
    {
        return $this->readOneof(2);
    }

    public function hasGcsUri()
    {
        return $this->hasOneof(2);
    }

    /**
     * Optional. Ambient noise as a mono-channel, 16kHz WAV file stored in
     * [Cloud Storage](https://cloud.google.com/storage).
     * Note: Please make sure the CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com` has
     * `storage.objects.get` permission to the Cloud Storage object.
     *
     * Generated from protobuf field <code>string gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setGcsUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Optional. Name of the prebuilt ambient sound.
     * Valid values are:
     * - "coffee_shop"
     * - "keyboard"
     * - "keypad"
     * - "hum"
     * - "office_1"
     * - "office_2"
     * - "office_3"
     * - "room_1"
     * - "room_2"
     * - "room_3"
     * - "room_4"
     * - "room_5"
     * - "air_conditioner"
     *
     * Generated from protobuf field <code>string prebuilt_ambient_sound = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPrebuiltAmbientSound()
    {
        return $this->readOneof(4);
    }

    public function hasPrebuiltAmbientSound()
    {
        return $this->hasOneof(4);
    }

    /**
     * Optional. Name of the prebuilt ambient sound.
     * Valid values are:
     * - "coffee_shop"
     * - "keyboard"
     * - "keypad"
     * - "hum"
     * - "office_1"
     * - "office_2"
     * - "office_3"
     * - "room_1"
     * - "room_2"
     * - "room_3"
     * - "room_4"
     * - "room_5"
     * - "air_conditioner"
     *
     * Generated from protobuf field <code>string prebuilt_ambient_sound = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPrebuiltAmbientSound($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Optional. Volume gain (in dB) of the normal native volume supported by
     * ambient noise, in the range [-96.0, 16.0]. If unset, or set to a value of
     * 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
     * will play at approximately half the amplitude of the normal native signal
     * amplitude. A value of +6.0 (dB) will play at approximately twice the
     * amplitude of the normal native signal amplitude. We strongly recommend not
     * to exceed +10 (dB) as there's usually no effective increase in loudness for
     * any value greater than that.
     *
     * Generated from protobuf field <code>double volume_gain_db = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return float
     */
    public function getVolumeGainDb()
    {
        return $this->volume_gain_db;
    }

    /**
     * Optional. Volume gain (in dB) of the normal native volume supported by
     * ambient noise, in the range [-96.0, 16.0]. If unset, or set to a value of
     * 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
     * will play at approximately half the amplitude of the normal native signal
     * amplitude. A value of +6.0 (dB) will play at approximately twice the
     * amplitude of the normal native signal amplitude. We strongly recommend not
     * to exceed +10 (dB) as there's usually no effective increase in loudness for
     * any value greater than that.
     *
     * Generated from protobuf field <code>double volume_gain_db = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param float $var
     * @return $this
     */
    public function setVolumeGainDb($var)
    {
        GPBUtil::checkDouble($var);
        $this->volume_gain_db = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->whichOneof("source");
    }

}

