<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/agent_service.proto

namespace Google\Cloud\Ces\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [AgentService.ImportApp][google.cloud.ces.v1.AgentService.ImportApp].
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.ImportAppRequest</code>
 */
class ImportAppRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource name with the location of the app to import.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The display name of the app to import.
     * * If the app is created on import, and the display name is specified,
     * the imported app will use this display name. If a conflict is detected
     * with an existing app, a timestamp will be appended to the display name
     * to make it unique.
     * * If the app is a reimport, this field should not be set. Providing a
     * display name during reimport will result in an INVALID_ARGUMENT error.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Optional. The ID to use for the imported app.
     * *  If not specified, a unique ID will be automatically assigned for
     * the app.
     * *  Otherwise, the imported app will use this ID as the final component of
     * its resource name. If an app with the same ID already exists at the
     * specified location in the project, the content of the existing app will be
     * replaced.
     *
     * Generated from protobuf field <code>string app_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $app_id = '';
    /**
     * Optional. Options governing the import process for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ImportAppRequest.ImportOptions import_options = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $import_options = null;
    protected $app;

    /**
     * @param string $parent      Required. The parent resource name with the location of the app to import. Please see
     *                            {@see AgentServiceClient::locationName()} for help formatting this field.
     * @param string $displayName Optional. The display name of the app to import.
     *                            * If the app is created on import, and the display name is specified,
     *                            the imported app will use this display name. If a conflict is detected
     *                            with an existing app, a timestamp will be appended to the display name
     *                            to make it unique.
     *                            * If the app is a reimport, this field should not be set. Providing a
     *                            display name during reimport will result in an INVALID_ARGUMENT error.
     * @param string $appId       Optional. The ID to use for the imported app.
     *                            *  If not specified, a unique ID will be automatically assigned for
     *                            the app.
     *                            *  Otherwise, the imported app will use this ID as the final component of
     *                            its resource name. If an app with the same ID already exists at the
     *                            specified location in the project, the content of the existing app will be
     *                            replaced.
     *
     * @return \Google\Cloud\Ces\V1\ImportAppRequest
     *
     * @experimental
     */
    public static function build(string $parent, string $displayName, string $appId): self
    {
        return (new self())
            ->setParent($parent)
            ->setDisplayName($displayName)
            ->setAppId($appId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $gcs_uri
     *           The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     *           from which to import app. The format of this URI must be
     *           `gs://<bucket-name>/<object-name>`.
     *     @type string $app_content
     *           Raw bytes representing the compressed zip file with the app folder
     *           structure.
     *     @type string $parent
     *           Required. The parent resource name with the location of the app to import.
     *     @type string $display_name
     *           Optional. The display name of the app to import.
     *           * If the app is created on import, and the display name is specified,
     *           the imported app will use this display name. If a conflict is detected
     *           with an existing app, a timestamp will be appended to the display name
     *           to make it unique.
     *           * If the app is a reimport, this field should not be set. Providing a
     *           display name during reimport will result in an INVALID_ARGUMENT error.
     *     @type string $app_id
     *           Optional. The ID to use for the imported app.
     *           *  If not specified, a unique ID will be automatically assigned for
     *           the app.
     *           *  Otherwise, the imported app will use this ID as the final component of
     *           its resource name. If an app with the same ID already exists at the
     *           specified location in the project, the content of the existing app will be
     *           replaced.
     *     @type \Google\Cloud\Ces\V1\ImportAppRequest\ImportOptions $import_options
     *           Optional. Options governing the import process for the app.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\AgentService::initOnce();
        parent::__construct($data);
    }

    /**
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * from which to import app. The format of this URI must be
     * `gs://<bucket-name>/<object-name>`.
     *
     * Generated from protobuf field <code>string gcs_uri = 4;</code>
     * @return string
     */
    public function getGcsUri()
    {
        return $this->readOneof(4);
    }

    public function hasGcsUri()
    {
        return $this->hasOneof(4);
    }

    /**
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * from which to import app. The format of this URI must be
     * `gs://<bucket-name>/<object-name>`.
     *
     * Generated from protobuf field <code>string gcs_uri = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setGcsUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Raw bytes representing the compressed zip file with the app folder
     * structure.
     *
     * Generated from protobuf field <code>bytes app_content = 5;</code>
     * @return string
     */
    public function getAppContent()
    {
        return $this->readOneof(5);
    }

    public function hasAppContent()
    {
        return $this->hasOneof(5);
    }

    /**
     * Raw bytes representing the compressed zip file with the app folder
     * structure.
     *
     * Generated from protobuf field <code>bytes app_content = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setAppContent($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Required. The parent resource name with the location of the app to import.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource name with the location of the app to import.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The display name of the app to import.
     * * If the app is created on import, and the display name is specified,
     * the imported app will use this display name. If a conflict is detected
     * with an existing app, a timestamp will be appended to the display name
     * to make it unique.
     * * If the app is a reimport, this field should not be set. Providing a
     * display name during reimport will result in an INVALID_ARGUMENT error.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. The display name of the app to import.
     * * If the app is created on import, and the display name is specified,
     * the imported app will use this display name. If a conflict is detected
     * with an existing app, a timestamp will be appended to the display name
     * to make it unique.
     * * If the app is a reimport, this field should not be set. Providing a
     * display name during reimport will result in an INVALID_ARGUMENT error.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. The ID to use for the imported app.
     * *  If not specified, a unique ID will be automatically assigned for
     * the app.
     * *  Otherwise, the imported app will use this ID as the final component of
     * its resource name. If an app with the same ID already exists at the
     * specified location in the project, the content of the existing app will be
     * replaced.
     *
     * Generated from protobuf field <code>string app_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAppId()
    {
        return $this->app_id;
    }

    /**
     * Optional. The ID to use for the imported app.
     * *  If not specified, a unique ID will be automatically assigned for
     * the app.
     * *  Otherwise, the imported app will use this ID as the final component of
     * its resource name. If an app with the same ID already exists at the
     * specified location in the project, the content of the existing app will be
     * replaced.
     *
     * Generated from protobuf field <code>string app_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAppId($var)
    {
        GPBUtil::checkString($var, True);
        $this->app_id = $var;

        return $this;
    }

    /**
     * Optional. Options governing the import process for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ImportAppRequest.ImportOptions import_options = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\ImportAppRequest\ImportOptions|null
     */
    public function getImportOptions()
    {
        return $this->import_options;
    }

    public function hasImportOptions()
    {
        return isset($this->import_options);
    }

    public function clearImportOptions()
    {
        unset($this->import_options);
    }

    /**
     * Optional. Options governing the import process for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ImportAppRequest.ImportOptions import_options = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\ImportAppRequest\ImportOptions $var
     * @return $this
     */
    public function setImportOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\ImportAppRequest\ImportOptions::class);
        $this->import_options = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getApp()
    {
        return $this->whichOneof("app");
    }

}

