<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/mcp_toolset.proto

namespace Google\Cloud\Ces\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A toolset that contains a list of tools that are offered by the MCP
 * server.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.McpToolset</code>
 */
class McpToolset extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The server address of the MCP server, example,
     * "https://example.com/mcp/". If the server is built with the MCP SDK,
     * the url should be suffixed with "/mcp/". Only Streamable HTTP transport
     * based servers are supported. See
     * https://modelcontextprotocol.io/specification/2025-03-26/basic/transports#streamable-http
     * for more details.
     *
     * Generated from protobuf field <code>string server_address = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $server_address = '';
    /**
     * Optional. Authentication information required to access tools and execute a
     * tool against the MCP server. For API key auth, the API key can only be sent
     * in the request header; sending it via query parameters is not supported.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ApiAuthentication api_authentication = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $api_authentication = null;
    /**
     * Optional. Service Directory configuration for VPC-SC, used to resolve
     * service names within a perimeter.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ServiceDirectoryConfig service_directory_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_directory_config = null;
    /**
     * Optional. The TLS configuration. Includes the custom server certificates
     * that the client should trust.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.TlsConfig tls_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $tls_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $server_address
     *           Required. The server address of the MCP server, example,
     *           "https://example.com/mcp/". If the server is built with the MCP SDK,
     *           the url should be suffixed with "/mcp/". Only Streamable HTTP transport
     *           based servers are supported. See
     *           https://modelcontextprotocol.io/specification/2025-03-26/basic/transports#streamable-http
     *           for more details.
     *     @type \Google\Cloud\Ces\V1\ApiAuthentication $api_authentication
     *           Optional. Authentication information required to access tools and execute a
     *           tool against the MCP server. For API key auth, the API key can only be sent
     *           in the request header; sending it via query parameters is not supported.
     *     @type \Google\Cloud\Ces\V1\ServiceDirectoryConfig $service_directory_config
     *           Optional. Service Directory configuration for VPC-SC, used to resolve
     *           service names within a perimeter.
     *     @type \Google\Cloud\Ces\V1\TlsConfig $tls_config
     *           Optional. The TLS configuration. Includes the custom server certificates
     *           that the client should trust.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\McpToolset::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The server address of the MCP server, example,
     * "https://example.com/mcp/". If the server is built with the MCP SDK,
     * the url should be suffixed with "/mcp/". Only Streamable HTTP transport
     * based servers are supported. See
     * https://modelcontextprotocol.io/specification/2025-03-26/basic/transports#streamable-http
     * for more details.
     *
     * Generated from protobuf field <code>string server_address = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getServerAddress()
    {
        return $this->server_address;
    }

    /**
     * Required. The server address of the MCP server, example,
     * "https://example.com/mcp/". If the server is built with the MCP SDK,
     * the url should be suffixed with "/mcp/". Only Streamable HTTP transport
     * based servers are supported. See
     * https://modelcontextprotocol.io/specification/2025-03-26/basic/transports#streamable-http
     * for more details.
     *
     * Generated from protobuf field <code>string server_address = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setServerAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->server_address = $var;

        return $this;
    }

    /**
     * Optional. Authentication information required to access tools and execute a
     * tool against the MCP server. For API key auth, the API key can only be sent
     * in the request header; sending it via query parameters is not supported.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ApiAuthentication api_authentication = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\ApiAuthentication|null
     */
    public function getApiAuthentication()
    {
        return $this->api_authentication;
    }

    public function hasApiAuthentication()
    {
        return isset($this->api_authentication);
    }

    public function clearApiAuthentication()
    {
        unset($this->api_authentication);
    }

    /**
     * Optional. Authentication information required to access tools and execute a
     * tool against the MCP server. For API key auth, the API key can only be sent
     * in the request header; sending it via query parameters is not supported.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ApiAuthentication api_authentication = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\ApiAuthentication $var
     * @return $this
     */
    public function setApiAuthentication($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\ApiAuthentication::class);
        $this->api_authentication = $var;

        return $this;
    }

    /**
     * Optional. Service Directory configuration for VPC-SC, used to resolve
     * service names within a perimeter.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ServiceDirectoryConfig service_directory_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\ServiceDirectoryConfig|null
     */
    public function getServiceDirectoryConfig()
    {
        return $this->service_directory_config;
    }

    public function hasServiceDirectoryConfig()
    {
        return isset($this->service_directory_config);
    }

    public function clearServiceDirectoryConfig()
    {
        unset($this->service_directory_config);
    }

    /**
     * Optional. Service Directory configuration for VPC-SC, used to resolve
     * service names within a perimeter.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ServiceDirectoryConfig service_directory_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\ServiceDirectoryConfig $var
     * @return $this
     */
    public function setServiceDirectoryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\ServiceDirectoryConfig::class);
        $this->service_directory_config = $var;

        return $this;
    }

    /**
     * Optional. The TLS configuration. Includes the custom server certificates
     * that the client should trust.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.TlsConfig tls_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\TlsConfig|null
     */
    public function getTlsConfig()
    {
        return $this->tls_config;
    }

    public function hasTlsConfig()
    {
        return isset($this->tls_config);
    }

    public function clearTlsConfig()
    {
        unset($this->tls_config);
    }

    /**
     * Optional. The TLS configuration. Includes the custom server certificates
     * that the client should trust.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.TlsConfig tls_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\TlsConfig $var
     * @return $this
     */
    public function setTlsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\TlsConfig::class);
        $this->tls_config = $var;

        return $this;
    }

}

