<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/open_api_toolset.proto

namespace Google\Cloud\Ces\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A toolset that contains a list of tools that are defined by an OpenAPI
 * schema.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.OpenApiToolset</code>
 */
class OpenApiToolset extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The OpenAPI schema of the toolset.
     *
     * Generated from protobuf field <code>string open_api_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $open_api_schema = '';
    /**
     * Optional. Authentication information required by the API.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ApiAuthentication api_authentication = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $api_authentication = null;
    /**
     * Optional. The TLS configuration. Includes the custom server certificates
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.TlsConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $tls_config = null;
    /**
     * Optional. Service Directory configuration.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_directory_config = null;
    /**
     * Optional. If true, the agent will ignore unknown fields in the API response
     * for all operations defined in the OpenAPI schema.
     *
     * Generated from protobuf field <code>bool ignore_unknown_fields = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ignore_unknown_fields = false;
    /**
     * Optional. The server URL of the Open API schema.
     * This field is only set in toolsets in the environment dependencies during
     * the export process if the schema contains a server url. During the import
     * process, if this url is present in the environment dependencies and the
     * schema has the $env_var placeholder, it will replace the placeholder in the
     * schema.
     *
     * Generated from protobuf field <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $url = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $open_api_schema
     *           Required. The OpenAPI schema of the toolset.
     *     @type \Google\Cloud\Ces\V1\ApiAuthentication $api_authentication
     *           Optional. Authentication information required by the API.
     *     @type \Google\Cloud\Ces\V1\TlsConfig $tls_config
     *           Optional. The TLS configuration. Includes the custom server certificates
     *     @type \Google\Cloud\Ces\V1\ServiceDirectoryConfig $service_directory_config
     *           Optional. Service Directory configuration.
     *     @type bool $ignore_unknown_fields
     *           Optional. If true, the agent will ignore unknown fields in the API response
     *           for all operations defined in the OpenAPI schema.
     *     @type string $url
     *           Optional. The server URL of the Open API schema.
     *           This field is only set in toolsets in the environment dependencies during
     *           the export process if the schema contains a server url. During the import
     *           process, if this url is present in the environment dependencies and the
     *           schema has the $env_var placeholder, it will replace the placeholder in the
     *           schema.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\OpenApiToolset::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The OpenAPI schema of the toolset.
     *
     * Generated from protobuf field <code>string open_api_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getOpenApiSchema()
    {
        return $this->open_api_schema;
    }

    /**
     * Required. The OpenAPI schema of the toolset.
     *
     * Generated from protobuf field <code>string open_api_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setOpenApiSchema($var)
    {
        GPBUtil::checkString($var, True);
        $this->open_api_schema = $var;

        return $this;
    }

    /**
     * Optional. Authentication information required by the API.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ApiAuthentication api_authentication = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\ApiAuthentication|null
     */
    public function getApiAuthentication()
    {
        return $this->api_authentication;
    }

    public function hasApiAuthentication()
    {
        return isset($this->api_authentication);
    }

    public function clearApiAuthentication()
    {
        unset($this->api_authentication);
    }

    /**
     * Optional. Authentication information required by the API.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ApiAuthentication api_authentication = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\ApiAuthentication $var
     * @return $this
     */
    public function setApiAuthentication($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\ApiAuthentication::class);
        $this->api_authentication = $var;

        return $this;
    }

    /**
     * Optional. The TLS configuration. Includes the custom server certificates
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.TlsConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\TlsConfig|null
     */
    public function getTlsConfig()
    {
        return $this->tls_config;
    }

    public function hasTlsConfig()
    {
        return isset($this->tls_config);
    }

    public function clearTlsConfig()
    {
        unset($this->tls_config);
    }

    /**
     * Optional. The TLS configuration. Includes the custom server certificates
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.TlsConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\TlsConfig $var
     * @return $this
     */
    public function setTlsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\TlsConfig::class);
        $this->tls_config = $var;

        return $this;
    }

    /**
     * Optional. Service Directory configuration.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\ServiceDirectoryConfig|null
     */
    public function getServiceDirectoryConfig()
    {
        return $this->service_directory_config;
    }

    public function hasServiceDirectoryConfig()
    {
        return isset($this->service_directory_config);
    }

    public function clearServiceDirectoryConfig()
    {
        unset($this->service_directory_config);
    }

    /**
     * Optional. Service Directory configuration.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\ServiceDirectoryConfig $var
     * @return $this
     */
    public function setServiceDirectoryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\ServiceDirectoryConfig::class);
        $this->service_directory_config = $var;

        return $this;
    }

    /**
     * Optional. If true, the agent will ignore unknown fields in the API response
     * for all operations defined in the OpenAPI schema.
     *
     * Generated from protobuf field <code>bool ignore_unknown_fields = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getIgnoreUnknownFields()
    {
        return $this->ignore_unknown_fields;
    }

    /**
     * Optional. If true, the agent will ignore unknown fields in the API response
     * for all operations defined in the OpenAPI schema.
     *
     * Generated from protobuf field <code>bool ignore_unknown_fields = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreUnknownFields($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_unknown_fields = $var;

        return $this;
    }

    /**
     * Optional. The server URL of the Open API schema.
     * This field is only set in toolsets in the environment dependencies during
     * the export process if the schema contains a server url. During the import
     * process, if this url is present in the environment dependencies and the
     * schema has the $env_var placeholder, it will replace the placeholder in the
     * schema.
     *
     * Generated from protobuf field <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Optional. The server URL of the Open API schema.
     * This field is only set in toolsets in the environment dependencies during
     * the export process if the schema contains a server url. During the import
     * process, if this url is present in the environment dependencies and the
     * schema has the $env_var placeholder, it will replace the placeholder in the
     * schema.
     *
     * Generated from protobuf field <code>string url = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->url = $var;

        return $this;
    }

}

