<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/session_service.proto

namespace Google\Cloud\Ces\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The configuration for the session.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.SessionConfig</code>
 */
class SessionConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The unique identifier of the session.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/sessions/{session}`
     *
     * Generated from protobuf field <code>string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $session = '';
    /**
     * Optional. Configuration for processing the input audio.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.InputAudioConfig input_audio_config = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $input_audio_config = null;
    /**
     * Optional. Configuration for generating the output audio.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.OutputAudioConfig output_audio_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $output_audio_config = null;
    /**
     * Optional. The historical context of the session, including user inputs,
     * agent responses, and other messages. Typically, CES agent would manage
     * session automatically so client doesn't need to explicitly populate this
     * field. However, client can optionally override the historical contexts to
     * force the session start from certain state.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1.Message historical_contexts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $historical_contexts;
    /**
     * Optional. The entry agent to handle the session. If not specified, the
     * session will be handled by the [root
     * agent][google.cloud.ces.v1.App.root_agent] of the app. Format:
     * `projects/{project}/locations/{location}/agents/{agent}`
     *
     * Generated from protobuf field <code>string entry_agent = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $entry_agent = '';
    /**
     * Optional. The deployment of the app to use for the session.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>string deployment = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $deployment = '';
    /**
     * Optional. The time zone of the user. If provided, the agent will use the
     * time zone for date and time related variables. Otherwise, the agent will
     * use the time zone specified in the App.time_zone_settings.
     * The format is the IANA Time Zone Database time zone, e.g.
     * "America/Los_Angeles".
     *
     * Generated from protobuf field <code>string time_zone = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $time_zone = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $session
     *           Required. The unique identifier of the session.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/sessions/{session}`
     *     @type \Google\Cloud\Ces\V1\InputAudioConfig $input_audio_config
     *           Optional. Configuration for processing the input audio.
     *     @type \Google\Cloud\Ces\V1\OutputAudioConfig $output_audio_config
     *           Optional. Configuration for generating the output audio.
     *     @type array<\Google\Cloud\Ces\V1\Message>|\Google\Protobuf\Internal\RepeatedField $historical_contexts
     *           Optional. The historical context of the session, including user inputs,
     *           agent responses, and other messages. Typically, CES agent would manage
     *           session automatically so client doesn't need to explicitly populate this
     *           field. However, client can optionally override the historical contexts to
     *           force the session start from certain state.
     *     @type string $entry_agent
     *           Optional. The entry agent to handle the session. If not specified, the
     *           session will be handled by the [root
     *           agent][google.cloud.ces.v1.App.root_agent] of the app. Format:
     *           `projects/{project}/locations/{location}/agents/{agent}`
     *     @type string $deployment
     *           Optional. The deployment of the app to use for the session.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
     *     @type string $time_zone
     *           Optional. The time zone of the user. If provided, the agent will use the
     *           time zone for date and time related variables. Otherwise, the agent will
     *           use the time zone specified in the App.time_zone_settings.
     *           The format is the IANA Time Zone Database time zone, e.g.
     *           "America/Los_Angeles".
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\SessionService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The unique identifier of the session.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/sessions/{session}`
     *
     * Generated from protobuf field <code>string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Required. The unique identifier of the session.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/sessions/{session}`
     *
     * Generated from protobuf field <code>string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSession($var)
    {
        GPBUtil::checkString($var, True);
        $this->session = $var;

        return $this;
    }

    /**
     * Optional. Configuration for processing the input audio.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.InputAudioConfig input_audio_config = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\InputAudioConfig|null
     */
    public function getInputAudioConfig()
    {
        return $this->input_audio_config;
    }

    public function hasInputAudioConfig()
    {
        return isset($this->input_audio_config);
    }

    public function clearInputAudioConfig()
    {
        unset($this->input_audio_config);
    }

    /**
     * Optional. Configuration for processing the input audio.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.InputAudioConfig input_audio_config = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\InputAudioConfig $var
     * @return $this
     */
    public function setInputAudioConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\InputAudioConfig::class);
        $this->input_audio_config = $var;

        return $this;
    }

    /**
     * Optional. Configuration for generating the output audio.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.OutputAudioConfig output_audio_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\OutputAudioConfig|null
     */
    public function getOutputAudioConfig()
    {
        return $this->output_audio_config;
    }

    public function hasOutputAudioConfig()
    {
        return isset($this->output_audio_config);
    }

    public function clearOutputAudioConfig()
    {
        unset($this->output_audio_config);
    }

    /**
     * Optional. Configuration for generating the output audio.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.OutputAudioConfig output_audio_config = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\OutputAudioConfig $var
     * @return $this
     */
    public function setOutputAudioConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\OutputAudioConfig::class);
        $this->output_audio_config = $var;

        return $this;
    }

    /**
     * Optional. The historical context of the session, including user inputs,
     * agent responses, and other messages. Typically, CES agent would manage
     * session automatically so client doesn't need to explicitly populate this
     * field. However, client can optionally override the historical contexts to
     * force the session start from certain state.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1.Message historical_contexts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHistoricalContexts()
    {
        return $this->historical_contexts;
    }

    /**
     * Optional. The historical context of the session, including user inputs,
     * agent responses, and other messages. Typically, CES agent would manage
     * session automatically so client doesn't need to explicitly populate this
     * field. However, client can optionally override the historical contexts to
     * force the session start from certain state.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1.Message historical_contexts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1\Message>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHistoricalContexts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1\Message::class);
        $this->historical_contexts = $arr;

        return $this;
    }

    /**
     * Optional. The entry agent to handle the session. If not specified, the
     * session will be handled by the [root
     * agent][google.cloud.ces.v1.App.root_agent] of the app. Format:
     * `projects/{project}/locations/{location}/agents/{agent}`
     *
     * Generated from protobuf field <code>string entry_agent = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEntryAgent()
    {
        return $this->entry_agent;
    }

    /**
     * Optional. The entry agent to handle the session. If not specified, the
     * session will be handled by the [root
     * agent][google.cloud.ces.v1.App.root_agent] of the app. Format:
     * `projects/{project}/locations/{location}/agents/{agent}`
     *
     * Generated from protobuf field <code>string entry_agent = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEntryAgent($var)
    {
        GPBUtil::checkString($var, True);
        $this->entry_agent = $var;

        return $this;
    }

    /**
     * Optional. The deployment of the app to use for the session.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>string deployment = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDeployment()
    {
        return $this->deployment;
    }

    /**
     * Optional. The deployment of the app to use for the session.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>string deployment = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDeployment($var)
    {
        GPBUtil::checkString($var, True);
        $this->deployment = $var;

        return $this;
    }

    /**
     * Optional. The time zone of the user. If provided, the agent will use the
     * time zone for date and time related variables. Otherwise, the agent will
     * use the time zone specified in the App.time_zone_settings.
     * The format is the IANA Time Zone Database time zone, e.g.
     * "America/Los_Angeles".
     *
     * Generated from protobuf field <code>string time_zone = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    /**
     * Optional. The time zone of the user. If provided, the agent will use the
     * time zone for date and time related variables. Otherwise, the agent will
     * use the time zone specified in the App.time_zone_settings.
     * The format is the IANA Time Zone Database time zone, e.g.
     * "America/Los_Angeles".
     *
     * Generated from protobuf field <code>string time_zone = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

}

