<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/session_service.proto

namespace Google\Cloud\Ces\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Output for the session.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.SessionOutput</code>
 */
class SessionOutput extends \Google\Protobuf\Internal\Message
{
    /**
     * Indicates the sequential order of conversation turn to which this output
     * belongs to, starting from 1.
     *
     * Generated from protobuf field <code>int32 turn_index = 6;</code>
     */
    protected $turn_index = 0;
    /**
     * If true, the CES agent has detected the end of the current conversation
     * turn and will provide no further output for this turn.
     *
     * Generated from protobuf field <code>bool turn_completed = 4;</code>
     */
    protected $turn_completed = false;
    /**
     * Optional. Diagnostic information contains execution details during the
     * processing of the input. Only populated in the last SessionOutput (with
     * `turn_completed=true`) for each turn.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.SessionOutput.DiagnosticInfo diagnostic_info = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $diagnostic_info = null;
    protected $output_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $text
     *           Output text from the CES agent.
     *     @type string $audio
     *           Output audio from the CES agent.
     *     @type \Google\Cloud\Ces\V1\ToolCalls $tool_calls
     *           Request for the client to execute the tools.
     *     @type \Google\Cloud\Ces\V1\Citations $citations
     *           Citations that provide the source information for the agent's generated
     *           text.
     *     @type \Google\Cloud\Ces\V1\GoogleSearchSuggestions $google_search_suggestions
     *           The suggestions returned from Google Search as a result of invoking the
     *           [GoogleSearchTool][google.cloud.ces.v1.GoogleSearchTool].
     *     @type \Google\Cloud\Ces\V1\EndSession $end_session
     *           Indicates the session has ended.
     *     @type \Google\Protobuf\Struct $payload
     *           Custom payload with structured output from the CES agent.
     *     @type int $turn_index
     *           Indicates the sequential order of conversation turn to which this output
     *           belongs to, starting from 1.
     *     @type bool $turn_completed
     *           If true, the CES agent has detected the end of the current conversation
     *           turn and will provide no further output for this turn.
     *     @type \Google\Cloud\Ces\V1\SessionOutput\DiagnosticInfo $diagnostic_info
     *           Optional. Diagnostic information contains execution details during the
     *           processing of the input. Only populated in the last SessionOutput (with
     *           `turn_completed=true`) for each turn.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\SessionService::initOnce();
        parent::__construct($data);
    }

    /**
     * Output text from the CES agent.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     * @return string
     */
    public function getText()
    {
        return $this->readOneof(1);
    }

    public function hasText()
    {
        return $this->hasOneof(1);
    }

    /**
     * Output text from the CES agent.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setText($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Output audio from the CES agent.
     *
     * Generated from protobuf field <code>bytes audio = 2;</code>
     * @return string
     */
    public function getAudio()
    {
        return $this->readOneof(2);
    }

    public function hasAudio()
    {
        return $this->hasOneof(2);
    }

    /**
     * Output audio from the CES agent.
     *
     * Generated from protobuf field <code>bytes audio = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAudio($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Request for the client to execute the tools.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ToolCalls tool_calls = 3;</code>
     * @return \Google\Cloud\Ces\V1\ToolCalls|null
     */
    public function getToolCalls()
    {
        return $this->readOneof(3);
    }

    public function hasToolCalls()
    {
        return $this->hasOneof(3);
    }

    /**
     * Request for the client to execute the tools.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ToolCalls tool_calls = 3;</code>
     * @param \Google\Cloud\Ces\V1\ToolCalls $var
     * @return $this
     */
    public function setToolCalls($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\ToolCalls::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Citations that provide the source information for the agent's generated
     * text.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.Citations citations = 8;</code>
     * @return \Google\Cloud\Ces\V1\Citations|null
     */
    public function getCitations()
    {
        return $this->readOneof(8);
    }

    public function hasCitations()
    {
        return $this->hasOneof(8);
    }

    /**
     * Citations that provide the source information for the agent's generated
     * text.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.Citations citations = 8;</code>
     * @param \Google\Cloud\Ces\V1\Citations $var
     * @return $this
     */
    public function setCitations($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\Citations::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * The suggestions returned from Google Search as a result of invoking the
     * [GoogleSearchTool][google.cloud.ces.v1.GoogleSearchTool].
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.GoogleSearchSuggestions google_search_suggestions = 10;</code>
     * @return \Google\Cloud\Ces\V1\GoogleSearchSuggestions|null
     */
    public function getGoogleSearchSuggestions()
    {
        return $this->readOneof(10);
    }

    public function hasGoogleSearchSuggestions()
    {
        return $this->hasOneof(10);
    }

    /**
     * The suggestions returned from Google Search as a result of invoking the
     * [GoogleSearchTool][google.cloud.ces.v1.GoogleSearchTool].
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.GoogleSearchSuggestions google_search_suggestions = 10;</code>
     * @param \Google\Cloud\Ces\V1\GoogleSearchSuggestions $var
     * @return $this
     */
    public function setGoogleSearchSuggestions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\GoogleSearchSuggestions::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * Indicates the session has ended.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.EndSession end_session = 9;</code>
     * @return \Google\Cloud\Ces\V1\EndSession|null
     */
    public function getEndSession()
    {
        return $this->readOneof(9);
    }

    public function hasEndSession()
    {
        return $this->hasOneof(9);
    }

    /**
     * Indicates the session has ended.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.EndSession end_session = 9;</code>
     * @param \Google\Cloud\Ces\V1\EndSession $var
     * @return $this
     */
    public function setEndSession($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\EndSession::class);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * Custom payload with structured output from the CES agent.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct payload = 11;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getPayload()
    {
        return $this->readOneof(11);
    }

    public function hasPayload()
    {
        return $this->hasOneof(11);
    }

    /**
     * Custom payload with structured output from the CES agent.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct payload = 11;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setPayload($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Indicates the sequential order of conversation turn to which this output
     * belongs to, starting from 1.
     *
     * Generated from protobuf field <code>int32 turn_index = 6;</code>
     * @return int
     */
    public function getTurnIndex()
    {
        return $this->turn_index;
    }

    /**
     * Indicates the sequential order of conversation turn to which this output
     * belongs to, starting from 1.
     *
     * Generated from protobuf field <code>int32 turn_index = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setTurnIndex($var)
    {
        GPBUtil::checkInt32($var);
        $this->turn_index = $var;

        return $this;
    }

    /**
     * If true, the CES agent has detected the end of the current conversation
     * turn and will provide no further output for this turn.
     *
     * Generated from protobuf field <code>bool turn_completed = 4;</code>
     * @return bool
     */
    public function getTurnCompleted()
    {
        return $this->turn_completed;
    }

    /**
     * If true, the CES agent has detected the end of the current conversation
     * turn and will provide no further output for this turn.
     *
     * Generated from protobuf field <code>bool turn_completed = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setTurnCompleted($var)
    {
        GPBUtil::checkBool($var);
        $this->turn_completed = $var;

        return $this;
    }

    /**
     * Optional. Diagnostic information contains execution details during the
     * processing of the input. Only populated in the last SessionOutput (with
     * `turn_completed=true`) for each turn.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.SessionOutput.DiagnosticInfo diagnostic_info = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1\SessionOutput\DiagnosticInfo|null
     */
    public function getDiagnosticInfo()
    {
        return $this->diagnostic_info;
    }

    public function hasDiagnosticInfo()
    {
        return isset($this->diagnostic_info);
    }

    public function clearDiagnosticInfo()
    {
        unset($this->diagnostic_info);
    }

    /**
     * Optional. Diagnostic information contains execution details during the
     * processing of the input. Only populated in the last SessionOutput (with
     * `turn_completed=true`) for each turn.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.SessionOutput.DiagnosticInfo diagnostic_info = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1\SessionOutput\DiagnosticInfo $var
     * @return $this
     */
    public function setDiagnosticInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\SessionOutput\DiagnosticInfo::class);
        $this->diagnostic_info = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getOutputType()
    {
        return $this->whichOneof("output_type");
    }

}

