# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # An agent acts as the fundamental building block that provides instructions to
        # the Large Language Model (LLM) for executing specific tasks.
        # @!attribute [rw] llm_agent
        #   @return [::Google::Cloud::Ces::V1::Agent::LlmAgent]
        #     Optional. The default agent type.
        #
        #     Note: The following fields are mutually exclusive: `llm_agent`, `remote_dialogflow_agent`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] remote_dialogflow_agent
        #   @return [::Google::Cloud::Ces::V1::Agent::RemoteDialogflowAgent]
        #     Optional. The remote
        #     [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
        #     agent to be used for the agent execution. If this field is set, all other
        #     agent level properties will be ignored.
        #
        #     Note: If the Dialogflow agent is in a different project from the app, you
        #     should grant `roles/dialogflow.client` to the CES service agent
        #     `service-<PROJECT-NUMBER>@gcp-sa-ces.iam.gserviceaccount.com`.
        #
        #     Note: The following fields are mutually exclusive: `remote_dialogflow_agent`, `llm_agent`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the agent.
        #     Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the agent.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Human-readable description of the agent.
        # @!attribute [rw] model_settings
        #   @return [::Google::Cloud::Ces::V1::ModelSettings]
        #     Optional. Configurations for the LLM model.
        # @!attribute [rw] instruction
        #   @return [::String]
        #     Optional. Instructions for the LLM model to guide the agent's behavior.
        # @!attribute [rw] tools
        #   @return [::Array<::String>]
        #     Optional. List of available tools for the agent.
        #     Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
        # @!attribute [rw] child_agents
        #   @return [::Array<::String>]
        #     Optional. List of child agents in the agent tree.
        #     Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        # @!attribute [rw] before_agent_callbacks
        #   @return [::Array<::Google::Cloud::Ces::V1::Callback>]
        #     Optional. The callbacks to execute before the agent is called.
        #     The provided callbacks are executed sequentially in the exact order they
        #     are given in the list. If a callback returns an overridden response,
        #     execution stops and any remaining callbacks are skipped.
        # @!attribute [rw] after_agent_callbacks
        #   @return [::Array<::Google::Cloud::Ces::V1::Callback>]
        #     Optional. The callbacks to execute after the agent is called.
        #     The provided callbacks are executed sequentially in the exact order they
        #     are given in the list. If a callback returns an overridden response,
        #     execution stops and any remaining callbacks are skipped.
        # @!attribute [rw] before_model_callbacks
        #   @return [::Array<::Google::Cloud::Ces::V1::Callback>]
        #     Optional. The callbacks to execute before the model is called. If there are
        #     multiple calls to the model, the callback will be executed multiple times.
        #     The provided callbacks are executed sequentially in the exact order they
        #     are given in the list. If a callback returns an overridden response,
        #     execution stops and any remaining callbacks are skipped.
        # @!attribute [rw] after_model_callbacks
        #   @return [::Array<::Google::Cloud::Ces::V1::Callback>]
        #     Optional. The callbacks to execute after the model is called. If there are
        #     multiple calls to the model, the callback will be executed multiple times.
        #     The provided callbacks are executed sequentially in the exact order they
        #     are given in the list. If a callback returns an overridden response,
        #     execution stops and any remaining callbacks are skipped.
        # @!attribute [rw] before_tool_callbacks
        #   @return [::Array<::Google::Cloud::Ces::V1::Callback>]
        #     Optional. The callbacks to execute before the tool is invoked. If there are
        #     multiple tool invocations, the callback will be executed multiple times.
        #     The provided callbacks are executed sequentially in the exact order they
        #     are given in the list. If a callback returns an overridden response,
        #     execution stops and any remaining callbacks are skipped.
        # @!attribute [rw] after_tool_callbacks
        #   @return [::Array<::Google::Cloud::Ces::V1::Callback>]
        #     Optional. The callbacks to execute after the tool is invoked. If there are
        #     multiple tool invocations, the callback will be executed multiple times.
        #     The provided callbacks are executed sequentially in the exact order they
        #     are given in the list. If a callback returns an overridden response,
        #     execution stops and any remaining callbacks are skipped.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the agent was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the agent was last updated.
        # @!attribute [rw] guardrails
        #   @return [::Array<::String>]
        #     Optional. List of guardrails for the agent.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Etag used to ensure the object hasn't changed during a read-modify-write
        #     operation. If the etag is empty, the update will overwrite any concurrent
        #     changes.
        # @!attribute [rw] toolsets
        #   @return [::Array<::Google::Cloud::Ces::V1::Agent::AgentToolset>]
        #     Optional. List of toolsets for the agent.
        # @!attribute [r] generated_summary
        #   @return [::String]
        #     Output only. If the agent is generated by the LLM assistant, this field
        #     contains a descriptive summary of the generation.
        class Agent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Default agent type. The agent uses instructions and callbacks specified in
          # the agent to perform the task using a large language model.
          class LlmAgent
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The agent which will transfer execution to a remote
          # [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
          # agent flow. The Dialogflow agent will process subsequent user queries until
          # the session ends or flow ends, and the control is transferred back to the
          # parent CES agent.
          # @!attribute [rw] agent
          #   @return [::String]
          #     Required. The
          #     [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents
          #     agent resource name.
          #     Format: `projects/{project}/locations/{location}/agents/{agent}`
          # @!attribute [rw] flow_id
          #   @return [::String]
          #     Required. The flow ID of the flow in the Dialogflow agent.
          # @!attribute [rw] environment_id
          #   @return [::String]
          #     Optional. The environment ID of the Dialogflow agent to be used for the
          #     agent execution. If not specified, the draft environment will be used.
          # @!attribute [rw] input_variable_mapping
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The mapping of the app variables names to the Dialogflow
          #     session parameters names to be sent to the Dialogflow agent as input.
          # @!attribute [rw] output_variable_mapping
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The mapping of the Dialogflow session parameters names to the
          #     app variables names to be sent back to the CES agent after the Dialogflow
          #     agent execution ends.
          class RemoteDialogflowAgent
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class InputVariableMappingEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class OutputVariableMappingEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A toolset with a selection of its tools.
          # @!attribute [rw] toolset
          #   @return [::String]
          #     Required. The resource name of the toolset.
          #     Format:
          #     `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
          # @!attribute [rw] tool_ids
          #   @return [::Array<::String>]
          #     Optional. The tools IDs to filter the toolset.
          class AgentToolset
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
