# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # An app serves as a top-level container for a group of agents, including the
        # root agent and its sub-agents, along with their associated configurations.
        # These agents work together to achieve specific goals within the app's
        # context.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the app.
        #     Format: `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the app.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Human-readable description of the app.
        # @!attribute [rw] pinned
        #   @return [::Boolean]
        #     Optional. Whether the app is pinned in the app list.
        # @!attribute [rw] root_agent
        #   @return [::String]
        #     Optional. The root agent is the entry point of the app.
        #     Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        # @!attribute [rw] language_settings
        #   @return [::Google::Cloud::Ces::V1::LanguageSettings]
        #     Optional. Language settings of the app.
        # @!attribute [rw] time_zone_settings
        #   @return [::Google::Cloud::Ces::V1::TimeZoneSettings]
        #     Optional. TimeZone settings of the app.
        # @!attribute [rw] audio_processing_config
        #   @return [::Google::Cloud::Ces::V1::AudioProcessingConfig]
        #     Optional. Audio processing configuration of the app.
        # @!attribute [rw] logging_settings
        #   @return [::Google::Cloud::Ces::V1::LoggingSettings]
        #     Optional. Logging settings of the app.
        # @!attribute [rw] model_settings
        #   @return [::Google::Cloud::Ces::V1::ModelSettings]
        #     Optional. The default LLM model settings for the app.
        #     Individual resources (e.g. agents, guardrails) can override these
        #     configurations as needed.
        # @!attribute [rw] tool_execution_mode
        #   @return [::Google::Cloud::Ces::V1::App::ToolExecutionMode]
        #     Optional. The tool execution mode for the app. If not provided, will
        #     default to PARALLEL.
        # @!attribute [rw] evaluation_metrics_thresholds
        #   @return [::Google::Cloud::Ces::V1::EvaluationMetricsThresholds]
        #     Optional. The evaluation thresholds for the app.
        # @!attribute [rw] variable_declarations
        #   @return [::Array<::Google::Cloud::Ces::V1::App::VariableDeclaration>]
        #     Optional. The declarations of the variables.
        # @!attribute [r] predefined_variable_declarations
        #   @return [::Array<::Google::Cloud::Ces::V1::App::VariableDeclaration>]
        #     Output only. The declarations of predefined variables for the app.
        # @!attribute [rw] global_instruction
        #   @return [::String]
        #     Optional. Instructions for all the agents in the app.
        #     You can use this instruction to set up a stable identity or personality
        #     across all the agents.
        # @!attribute [rw] guardrails
        #   @return [::Array<::String>]
        #     Optional. List of guardrails for the app.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        # @!attribute [rw] data_store_settings
        #   @return [::Google::Cloud::Ces::V1::DataStoreSettings]
        #     Optional. The data store settings for the app.
        # @!attribute [rw] default_channel_profile
        #   @return [::Google::Cloud::Ces::V1::ChannelProfile]
        #     Optional. The default channel profile used by the app.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Metadata about the app. This field can be used to store
        #     additional information relevant to the app's details or intended usages.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the app was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the app was last updated.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. Etag used to ensure the object hasn't changed during a
        #     read-modify-write operation. If the etag is empty, the update will
        #     overwrite any concurrent changes.
        # @!attribute [r] deployment_count
        #   @return [::Integer]
        #     Output only. Number of deployments in the app.
        # @!attribute [rw] client_certificate_settings
        #   @return [::Google::Cloud::Ces::V1::ClientCertificateSettings]
        #     Optional. The default client certificate settings for the app.
        # @!attribute [rw] evaluation_settings
        #   @return [::Google::Cloud::Ces::V1::EvaluationSettings]
        #     Optional. The evaluation settings for the app.
        class App
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines the structure and metadata for a variable.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the variable. The name must start with a letter or
          #     underscore and contain only letters, numbers, or underscores.
          # @!attribute [rw] description
          #   @return [::String]
          #     Required. The description of the variable.
          # @!attribute [rw] schema
          #   @return [::Google::Cloud::Ces::V1::Schema]
          #     Required. The schema of the variable.
          class VariableDeclaration
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines the tool execution behavior if there are **multiple** tools being
          # selected by the agent **at the same time**.
          module ToolExecutionMode
            # Unspecified tool execution mode. Default to PARALLEL.
            TOOL_EXECUTION_MODE_UNSPECIFIED = 0

            # If there are multiple tools being selected, they will be executed in
            # parallel, with the same
            # [ToolContext](https://google.github.io/adk-docs/context/#the-different-types-of-context).
            PARALLEL = 1

            # If there are multiple tools being selected, they will be executed
            # sequentially. The next tool will only be executed after the previous tool
            # completes and it can see updated
            # [ToolContext](https://google.github.io/adk-docs/context/#the-different-types-of-context)
            # from the previous tool.
            SEQUENTIAL = 2
          end
        end

        # TimeZone settings of the app.
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     Optional. The time zone of the app from the [time zone
        #     database](https://www.iana.org/time-zones), e.g., America/Los_Angeles,
        #     Europe/Paris.
        class TimeZoneSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Language settings of the app.
        # @!attribute [rw] default_language_code
        #   @return [::String]
        #     Optional. The default language code of the app.
        # @!attribute [rw] supported_language_codes
        #   @return [::Array<::String>]
        #     Optional. List of languages codes supported by the app, in addition to the
        #     `default_language_code`.
        # @!attribute [rw] enable_multilingual_support
        #   @return [::Boolean]
        #     Optional. Enables multilingual support. If true, agents in the app will use
        #     pre-built instructions to improve handling of multilingual input.
        # @!attribute [rw] fallback_action
        #   @return [::String]
        #     Optional. The action to perform when an agent receives input in an
        #     unsupported language.
        #
        #     This can be a predefined action or a custom tool call.
        #     Valid values are:
        #     - A tool's full resource name, which triggers a specific tool execution.
        #     - A predefined system action, such as "escalate" or "exit", which triggers
        #     an {::Google::Cloud::Ces::V1::EndSession EndSession} signal with corresponding
        #     {::Google::Cloud::Ces::V1::EndSession#metadata metadata} to terminate the
        #     conversation.
        class LanguageSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for how the input and output audio should be processed and
        # delivered.
        # @!attribute [rw] synthesize_speech_configs
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Ces::V1::SynthesizeSpeechConfig}]
        #     Optional. Configuration of how the agent response should be synthesized,
        #     mapping from the language code to
        #     {::Google::Cloud::Ces::V1::SynthesizeSpeechConfig SynthesizeSpeechConfig}.
        #
        #     If the configuration for the specified language code is not found, the
        #     configuration for the root language code will be used. For example, if the
        #     map contains "en-us" and "en", and the specified language code is "en-gb",
        #     then "en" configuration will be used.
        #
        #     Note: Language code is case-insensitive.
        # @!attribute [rw] barge_in_config
        #   @return [::Google::Cloud::Ces::V1::BargeInConfig]
        #     Optional. Configures the agent behavior for the user barge-in activities.
        # @!attribute [rw] inactivity_timeout
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The duration of user inactivity (no speech or interaction) before
        #     the agent prompts the user for reengagement. If not set, the agent will not
        #     prompt the user for reengagement.
        # @!attribute [rw] ambient_sound_config
        #   @return [::Google::Cloud::Ces::V1::AmbientSoundConfig]
        #     Optional. Configuration for the ambient sound to be played with the
        #     synthesized agent response, to enhance the naturalness of the conversation.
        class AudioProcessingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Ces::V1::SynthesizeSpeechConfig]
          class SynthesizeSpeechConfigsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration for the ambient sound to be played with the synthesized agent
        # response, to enhance the naturalness of the conversation.
        # @!attribute [rw] prebuilt_ambient_noise
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Ces::V1::AmbientSoundConfig::PrebuiltAmbientNoise]
        #     Optional. Prebuilt ambient noise.
        #
        #     Note: The following fields are mutually exclusive: `prebuilt_ambient_noise`, `gcs_uri`, `prebuilt_ambient_sound`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_uri
        #   @return [::String]
        #     Optional. Ambient noise as a mono-channel, 16kHz WAV file stored in
        #     [Cloud Storage](https://cloud.google.com/storage).
        #
        #     Note: Please make sure the CES service agent
        #     `service-<PROJECT-NUMBER>@gcp-sa-ces.iam.gserviceaccount.com` has
        #     `storage.objects.get` permission to the Cloud Storage object.
        #
        #     Note: The following fields are mutually exclusive: `gcs_uri`, `prebuilt_ambient_noise`, `prebuilt_ambient_sound`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] prebuilt_ambient_sound
        #   @return [::String]
        #     Optional. Name of the prebuilt ambient sound.
        #     Valid values are:
        #     - "coffee_shop"
        #     - "keyboard"
        #     - "keypad"
        #     - "hum"
        #     - "office_1"
        #     - "office_2"
        #     - "office_3"
        #     - "room_1"
        #     - "room_2"
        #     - "room_3"
        #     - "room_4"
        #     - "room_5"
        #     - "air_conditioner"
        #
        #     Note: The following fields are mutually exclusive: `prebuilt_ambient_sound`, `prebuilt_ambient_noise`, `gcs_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] volume_gain_db
        #   @return [::Float]
        #     Optional. Volume gain (in dB) of the normal native volume supported by
        #     ambient noise, in the range [-96.0, 16.0]. If unset, or set to a value of
        #     0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
        #     will play at approximately half the amplitude of the normal native signal
        #     amplitude. A value of +6.0 (dB) will play at approximately twice the
        #     amplitude of the normal native signal amplitude. We strongly recommend not
        #     to exceed +10 (dB) as there's usually no effective increase in loudness for
        #     any value greater than that.
        class AmbientSoundConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Prebuilt ambient noise.
          module PrebuiltAmbientNoise
            # Not specified.
            PREBUILT_AMBIENT_NOISE_UNSPECIFIED = 0

            # Ambient noise of a retail store.
            RETAIL_STORE = 1

            # Ambient noise of a convention hall.
            CONVENTION_HALL = 2

            # Ambient noise of a street.
            OUTDOOR = 3
          end
        end

        # Configuration for how the user barge-in activities should be handled.
        # @!attribute [rw] disable_barge_in
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Optional. Disables user barge-in while the agent is speaking. If true, user
        #     input during agent response playback will be ignored.
        #
        #     Deprecated. This field is deprecated in favor of
        #     {::Google::Cloud::Ces::V1::ChannelProfile#disable_barge_in_control `disable_barge_in_control`}
        #     in ChannelProfile.
        # @!attribute [rw] barge_in_awareness
        #   @return [::Boolean]
        #     Optional. If enabled, the agent will adapt its next response based on the
        #     assumption that the user hasn't heard the full preceding agent message.
        #     This should not be used in scenarios where agent responses are displayed
        #     visually.
        class BargeInConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for how the agent response should be synthesized.
        # @!attribute [rw] voice
        #   @return [::String]
        #     Optional. The name of the voice. If not set, the service will choose a
        #     voice based on the other parameters such as language_code.
        #
        #     For the list of available voices, please refer to [Supported voices and
        #     languages](https://cloud.google.com/text-to-speech/docs/voices) from Cloud
        #     Text-to-Speech.
        # @!attribute [rw] speaking_rate
        #   @return [::Float]
        #     Optional. The speaking rate/speed in the range [0.25, 2.0]. 1.0 is the
        #     normal native speed supported by the specific voice. 2.0 is twice as fast,
        #     and 0.5 is half as fast. Values outside of the range [0.25, 2.0] will
        #     return an error.
        class SynthesizeSpeechConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings to describe the logging behaviors for the app.
        # @!attribute [rw] redaction_config
        #   @return [::Google::Cloud::Ces::V1::RedactionConfig]
        #     Optional. Configuration for how sensitive data should be redacted.
        # @!attribute [rw] audio_recording_config
        #   @return [::Google::Cloud::Ces::V1::AudioRecordingConfig]
        #     Optional. Configuration for how audio interactions should be recorded.
        # @!attribute [rw] bigquery_export_settings
        #   @return [::Google::Cloud::Ces::V1::BigQueryExportSettings]
        #     Optional. Settings to describe the BigQuery export behaviors for the app.
        #     The conversation data will be exported to BigQuery tables if it is enabled.
        # @!attribute [rw] cloud_logging_settings
        #   @return [::Google::Cloud::Ces::V1::CloudLoggingSettings]
        #     Optional. Settings to describe the Cloud Logging behaviors for the app.
        # @!attribute [rw] conversation_logging_settings
        #   @return [::Google::Cloud::Ces::V1::ConversationLoggingSettings]
        #     Optional. Settings to describe the conversation logging behaviors for the
        #     app.
        # @!attribute [rw] evaluation_audio_recording_config
        #   @return [::Google::Cloud::Ces::V1::AudioRecordingConfig]
        #     Optional. Configuration for how audio interactions should be recorded for
        #     the evaluation. By default, audio recording is not enabled for evaluation
        #     sessions.
        class LoggingSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Threshold settings for metrics in an Evaluation.
        # @!attribute [rw] golden_evaluation_metrics_thresholds
        #   @return [::Google::Cloud::Ces::V1::EvaluationMetricsThresholds::GoldenEvaluationMetricsThresholds]
        #     Optional. The golden evaluation metrics thresholds.
        # @!attribute [rw] hallucination_metric_behavior
        #   @return [::Google::Cloud::Ces::V1::EvaluationMetricsThresholds::HallucinationMetricBehavior]
        #     Optional. The hallucination metric behavior.
        class EvaluationMetricsThresholds
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Settings for golden evaluations.
          # @!attribute [rw] turn_level_metrics_thresholds
          #   @return [::Google::Cloud::Ces::V1::EvaluationMetricsThresholds::GoldenEvaluationMetricsThresholds::TurnLevelMetricsThresholds]
          #     Optional. The turn level metrics thresholds.
          # @!attribute [rw] expectation_level_metrics_thresholds
          #   @return [::Google::Cloud::Ces::V1::EvaluationMetricsThresholds::GoldenEvaluationMetricsThresholds::ExpectationLevelMetricsThresholds]
          #     Optional. The expectation level metrics thresholds.
          class GoldenEvaluationMetricsThresholds
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Turn level metrics thresholds.
            # @!attribute [rw] semantic_similarity_success_threshold
            #   @return [::Integer]
            #     Optional. The success threshold for semantic similarity. Must be an
            #     integer between 0 and 4. Default is >= 3.
            # @!attribute [rw] overall_tool_invocation_correctness_threshold
            #   @return [::Float]
            #     Optional. The success threshold for overall tool invocation
            #     correctness. Must be a float between 0 and 1. Default is 1.0.
            class TurnLevelMetricsThresholds
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Expectation level metrics thresholds.
            # @!attribute [rw] tool_invocation_parameter_correctness_threshold
            #   @return [::Float]
            #     Optional. The success threshold for individual tool invocation
            #     parameter correctness. Must be a float between 0 and 1. Default is 1.0.
            class ExpectationLevelMetricsThresholds
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The hallucination metric behavior. Regardless of the behavior, the metric
          # will always be calculated. The difference is that when disabled, the
          # metric is not used to calculate the overall evaluation score.
          module HallucinationMetricBehavior
            # Unspecified hallucination metric behavior.
            HALLUCINATION_METRIC_BEHAVIOR_UNSPECIFIED = 0

            # Disable hallucination metric.
            DISABLED = 1

            # Enable hallucination metric.
            ENABLED = 2
          end
        end

        # Settings for evaluation.
        # @!attribute [rw] scenario_conversation_initiator
        #   @return [::Google::Cloud::Ces::V1::EvaluationSettings::ScenarioConversationInitiator]
        #     Optional. Who starts the conversation in a scenario evaluation.
        class EvaluationSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Determines who starts the conversation in a scenario evaluation session.
          module ScenarioConversationInitiator
            # Unspecified. Defaults to USER.
            SCENARIO_CONVERSATION_INITIATOR_UNSPECIFIED = 0

            # The user starts the conversation.
            USER = 1

            # The agent starts the conversation.
            AGENT = 2
          end
        end

        # Settings for custom client certificates.
        # @!attribute [rw] tls_certificate
        #   @return [::String]
        #     Required. The TLS certificate encoded in PEM format. This string must
        #     include the begin header and end footer lines.
        # @!attribute [rw] private_key
        #   @return [::String]
        #     Required. The name of the SecretManager secret version resource storing the
        #     private key encoded in PEM format.
        #     Format: `projects/{project}/secrets/{secret}/versions/{version}`
        # @!attribute [rw] passphrase
        #   @return [::String]
        #     Optional. The name of the SecretManager secret version resource storing the
        #     passphrase to decrypt the private key. Should be left unset if the private
        #     key is not encrypted.
        #     Format: `projects/{project}/secrets/{secret}/versions/{version}`
        class ClientCertificateSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings to describe the conversation logging behaviors for the app.
        # @!attribute [rw] disable_conversation_logging
        #   @return [::Boolean]
        #     Optional. Whether to disable conversation logging for the sessions.
        class ConversationLoggingSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings to describe the Cloud Logging behaviors for the app.
        # @!attribute [rw] enable_cloud_logging
        #   @return [::Boolean]
        #     Optional. Whether to enable Cloud Logging for the sessions.
        class CloudLoggingSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for how the audio interactions should be recorded.
        # @!attribute [rw] gcs_bucket
        #   @return [::String]
        #     Optional. The [Cloud Storage](https://cloud.google.com/storage) bucket to
        #     store the session audio recordings. The URI must start with "gs://".
        #
        #     Please choose a bucket location that meets your data residency
        #     requirements.
        #
        #     Note: If the Cloud Storage bucket is in a different project from the app,
        #     you should grant `storage.objects.create` permission to the CES service
        #     agent `service-<PROJECT-NUMBER>@gcp-sa-ces.iam.gserviceaccount.com`.
        # @!attribute [rw] gcs_path_prefix
        #   @return [::String]
        #     Optional. The Cloud Storage path prefix for audio recordings.
        #
        #     This prefix can include the following placeholders, which will be
        #     dynamically substituted at serving time:
        #       - $project:   project ID
        #       - $location:  app location
        #       - $app:       app ID
        #       - $date:      session date in YYYY-MM-DD format
        #       - $session:   session ID
        #
        #     If the path prefix is not specified, the default prefix
        #     `$project/$location/$app/$date/$session/` will be used.
        class AudioRecordingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration to instruct how sensitive data should be handled.
        # @!attribute [rw] enable_redaction
        #   @return [::Boolean]
        #     Optional. If true, redaction will be applied in various logging scenarios,
        #     including conversation history, Cloud Logging and audio recording.
        # @!attribute [rw] inspect_template
        #   @return [::String]
        #     Optional. [DLP](https://cloud.google.com/dlp/docs) inspect template name to
        #     configure detection of sensitive data types.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/inspectTemplates/{inspect_template}`
        # @!attribute [rw] deidentify_template
        #   @return [::String]
        #     Optional. [DLP](https://cloud.google.com/dlp/docs) deidentify template name
        #     to instruct on how to de-identify content.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}`
        class RedactionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Data store related settings for the app.
        # @!attribute [r] engines
        #   @return [::Array<::Google::Cloud::Ces::V1::DataStoreSettings::Engine>]
        #     Output only. The engines for the app.
        class DataStoreSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An engine to which the data stores are connected.
          # See Vertex AI Search:
          # https://cloud.google.com/generative-ai-app-builder/docs/enterprise-search-introduction.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the engine.
          #     Format:
          #     `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
          # @!attribute [r] type
          #   @return [::Google::Cloud::Ces::V1::DataStoreSettings::Engine::Type]
          #     Output only. The type of the engine.
          class Engine
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the engine.
            # See the documentation available at
            # https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/SolutionType
            # and
            # https://cloud.google.com/generative-ai-app-builder/docs/create-datastore-ingest.
            module Type
              # Unspecified engine type.
              TYPE_UNSPECIFIED = 0

              # The SOLUTION_TYPE_SEARCH engine for the app. All connector data stores
              # added to the app will be added to this engine.
              ENGINE_TYPE_SEARCH = 1

              # Chat engine type.
              # The SOLUTION_TYPE_CHAT engine for the app. All connector data stores
              # added to the app will be added to this engine.
              ENGINE_TYPE_CHAT = 2
            end
          end
        end
      end
    end
  end
end
