# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # A snapshot of the app.
        # @!attribute [rw] app
        #   @return [::Google::Cloud::Ces::V1::App]
        #     Optional. The basic settings for the app.
        # @!attribute [rw] agents
        #   @return [::Array<::Google::Cloud::Ces::V1::Agent>]
        #     Optional. List of agents in the app.
        # @!attribute [rw] tools
        #   @return [::Array<::Google::Cloud::Ces::V1::Tool>]
        #     Optional. List of tools in the app.
        # @!attribute [rw] examples
        #   @return [::Array<::Google::Cloud::Ces::V1::Example>]
        #     Optional. List of examples in the app.
        # @!attribute [rw] guardrails
        #   @return [::Array<::Google::Cloud::Ces::V1::Guardrail>]
        #     Optional. List of guardrails in the app.
        # @!attribute [rw] toolsets
        #   @return [::Array<::Google::Cloud::Ces::V1::Toolset>]
        #     Optional. List of toolsets in the app.
        class AppSnapshot
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # In Customer Engagement Suite (CES), an app version is a snapshot of the app
        # at a specific point in time. It is immutable and cannot be modified once
        # created.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the app version.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name of the app version.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the app version.
        # @!attribute [r] creator
        #   @return [::String]
        #     Output only. Email of the user who created the app version.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the app version was created.
        # @!attribute [r] snapshot
        #   @return [::Google::Cloud::Ces::V1::AppSnapshot]
        #     Output only. The snapshot of the app when the version is created.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. Etag used to ensure the object hasn't changed during a
        #     read-modify-write operation. If the etag is empty, the update will
        #     overwrite any concurrent changes.
        class AppVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
