# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # Configurations for authentication with API key.
        # @!attribute [rw] key_name
        #   @return [::String]
        #     Required. The parameter name or the header name of the API key.
        #     E.g., If the API request is "https://example.com/act?X-Api-Key=<API
        #     KEY>", "X-Api-Key" would be the parameter name.
        # @!attribute [rw] api_key_secret_version
        #   @return [::String]
        #     Required. The name of the SecretManager secret version resource storing the
        #     API key. Format: `projects/{project}/secrets/{secret}/versions/{version}`
        #
        #     Note: You should grant `roles/secretmanager.secretAccessor` role to the CES
        #     service agent
        #     `service-<PROJECT-NUMBER>@gcp-sa-ces.iam.gserviceaccount.com`.
        # @!attribute [rw] request_location
        #   @return [::Google::Cloud::Ces::V1::ApiKeyConfig::RequestLocation]
        #     Required. Key location in the request.
        class ApiKeyConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The location of the API key in the request.
          module RequestLocation
            # Unspecified. This value should not be unused.
            REQUEST_LOCATION_UNSPECIFIED = 0

            # Represents the key in http header.
            HEADER = 1

            # Represents the key in query string.
            QUERY_STRING = 2
          end
        end

        # Configurations for authentication with OAuth.
        # @!attribute [rw] oauth_grant_type
        #   @return [::Google::Cloud::Ces::V1::OAuthConfig::OauthGrantType]
        #     Required. OAuth grant types.
        # @!attribute [rw] client_id
        #   @return [::String]
        #     Required. The client ID from the OAuth provider.
        # @!attribute [rw] client_secret_version
        #   @return [::String]
        #     Required. The name of the SecretManager secret version resource storing the
        #     client secret.
        #     Format: `projects/{project}/secrets/{secret}/versions/{version}`
        #
        #     Note: You should grant `roles/secretmanager.secretAccessor` role to the CES
        #     service agent
        #     `service-<PROJECT-NUMBER>@gcp-sa-ces.iam.gserviceaccount.com`.
        # @!attribute [rw] token_endpoint
        #   @return [::String]
        #     Required. The token endpoint in the OAuth provider to exchange for an
        #     access token.
        # @!attribute [rw] scopes
        #   @return [::Array<::String>]
        #     Optional. The OAuth scopes to grant.
        class OAuthConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # OAuth grant types. Only [client credential
          # grant](https://oauth.net/2/grant-types/client-credentials) is supported.
          module OauthGrantType
            # Unspecified. Defaults to CLIENT_CREDENTIAL.
            OAUTH_GRANT_TYPE_UNSPECIFIED = 0

            # Represents the [client credential
            # flow](https://oauth.net/2/grant-types/client-credentials).
            CLIENT_CREDENTIAL = 1
          end
        end

        # Configurations for authentication with [ID
        # token](https://cloud.google.com/docs/authentication/token-types#id) generated
        # from service agent.
        class ServiceAgentIdTokenAuthConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configurations for authentication using a custom service account.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Required. The email address of the service account used for
        #     authenticatation. CES uses this service account to exchange an access token
        #     and the access token is then sent in the `Authorization` header of the
        #     request.
        #
        #     The service account must have the
        #     `roles/iam.serviceAccountTokenCreator` role granted to the
        #     CES service agent
        #     `service-<PROJECT-NUMBER>@gcp-sa-ces.iam.gserviceaccount.com`.
        class ServiceAccountAuthConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configurations for authentication with a bearer token.
        # @!attribute [rw] token
        #   @return [::String]
        #     Required. The bearer token.
        #     Must be in the format `$context.variables.<name_of_variable>`.
        class BearerTokenConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # End-user authentication configuration used for Connection calls.
        # The field values must be the names of context variables in the format
        # `$context.variables.<name_of_variable>`.
        # @!attribute [rw] oauth2_auth_code_config
        #   @return [::Google::Cloud::Ces::V1::EndUserAuthConfig::Oauth2AuthCodeConfig]
        #     Oauth 2.0 Authorization Code authentication.
        #
        #     Note: The following fields are mutually exclusive: `oauth2_auth_code_config`, `oauth2_jwt_bearer_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oauth2_jwt_bearer_config
        #   @return [::Google::Cloud::Ces::V1::EndUserAuthConfig::Oauth2JwtBearerConfig]
        #     JWT Profile Oauth 2.0 Authorization Grant authentication.
        #
        #     Note: The following fields are mutually exclusive: `oauth2_jwt_bearer_config`, `oauth2_auth_code_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class EndUserAuthConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Oauth 2.0 Authorization Code authentication configuration.
          # @!attribute [rw] oauth_token
          #   @return [::String]
          #     Required. Oauth token parameter name to pass through.
          #     Must be in the format `$context.variables.<name_of_variable>`.
          class Oauth2AuthCodeConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # JWT Profile Oauth 2.0 Authorization Grant authentication configuration.
          # @!attribute [rw] issuer
          #   @return [::String]
          #     Required. Issuer parameter name to pass through.
          #     Must be in the format `$context.variables.<name_of_variable>`.
          # @!attribute [rw] subject
          #   @return [::String]
          #     Required. Subject parameter name to pass through.
          #     Must be in the format `$context.variables.<name_of_variable>`.
          # @!attribute [rw] client_key
          #   @return [::String]
          #     Required. Client parameter name to pass through.
          #     Must be in the format `$context.variables.<name_of_variable>`.
          class Oauth2JwtBearerConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Authentication information required for API calls.
        # @!attribute [rw] api_key_config
        #   @return [::Google::Cloud::Ces::V1::ApiKeyConfig]
        #     Optional. Config for API key auth.
        #
        #     Note: The following fields are mutually exclusive: `api_key_config`, `oauth_config`, `service_agent_id_token_auth_config`, `service_account_auth_config`, `bearer_token_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oauth_config
        #   @return [::Google::Cloud::Ces::V1::OAuthConfig]
        #     Optional. Config for OAuth.
        #
        #     Note: The following fields are mutually exclusive: `oauth_config`, `api_key_config`, `service_agent_id_token_auth_config`, `service_account_auth_config`, `bearer_token_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] service_agent_id_token_auth_config
        #   @return [::Google::Cloud::Ces::V1::ServiceAgentIdTokenAuthConfig]
        #     Optional. Config for ID token auth generated from CES service agent.
        #
        #     Note: The following fields are mutually exclusive: `service_agent_id_token_auth_config`, `api_key_config`, `oauth_config`, `service_account_auth_config`, `bearer_token_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] service_account_auth_config
        #   @return [::Google::Cloud::Ces::V1::ServiceAccountAuthConfig]
        #     Optional. Config for service account authentication.
        #
        #     Note: The following fields are mutually exclusive: `service_account_auth_config`, `api_key_config`, `oauth_config`, `service_agent_id_token_auth_config`, `bearer_token_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bearer_token_config
        #   @return [::Google::Cloud::Ces::V1::BearerTokenConfig]
        #     Optional. Config for bearer token auth.
        #
        #     Note: The following fields are mutually exclusive: `bearer_token_config`, `api_key_config`, `oauth_config`, `service_agent_id_token_auth_config`, `service_account_auth_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ApiAuthentication
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
