# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # A callback defines the custom logic to be executed at various stages of
        # agent interaction.
        # @!attribute [rw] python_code
        #   @return [::String]
        #     Required. The python code to execute for the callback.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Human-readable description of the callback.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Optional. Whether the callback is disabled. Disabled callbacks are ignored
        #     by the agent.
        class Callback
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Model settings contains various configurations for the LLM model.
        # @!attribute [rw] model
        #   @return [::String]
        #     Optional. The LLM model that the agent should use.
        #     If not set, the agent will inherit the model from its parent agent.
        # @!attribute [rw] temperature
        #   @return [::Float]
        #     Optional. If set, this temperature will be used for the LLM model.
        #     Temperature controls the randomness of the model's responses. Lower
        #     temperatures produce responses that are more predictable. Higher
        #     temperatures produce responses that are more creative.
        class ModelSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Action that is taken when a certain precondition is met.
        # @!attribute [rw] respond_immediately
        #   @return [::Google::Cloud::Ces::V1::TriggerAction::RespondImmediately]
        #     Optional. Immediately respond with a preconfigured response.
        #
        #     Note: The following fields are mutually exclusive: `respond_immediately`, `transfer_agent`, `generative_answer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] transfer_agent
        #   @return [::Google::Cloud::Ces::V1::TriggerAction::TransferAgent]
        #     Optional. Transfer the conversation to a different agent.
        #
        #     Note: The following fields are mutually exclusive: `transfer_agent`, `respond_immediately`, `generative_answer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] generative_answer
        #   @return [::Google::Cloud::Ces::V1::TriggerAction::GenerativeAnswer]
        #     Optional. Respond with a generative answer.
        #
        #     Note: The following fields are mutually exclusive: `generative_answer`, `respond_immediately`, `transfer_agent`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class TriggerAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a response from the agent.
          # @!attribute [rw] text
          #   @return [::String]
          #     Required. Text for the agent to respond with.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Optional. Whether the response is disabled. Disabled responses are not
          #     used by the agent.
          class Response
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The agent will immediately respond with a preconfigured response.
          # @!attribute [rw] responses
          #   @return [::Array<::Google::Cloud::Ces::V1::TriggerAction::Response>]
          #     Required. The canned responses for the agent to choose from. The response
          #     is chosen randomly.
          class RespondImmediately
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The agent will immediately respond with a generative answer.
          # @!attribute [rw] prompt
          #   @return [::String]
          #     Required. The prompt to use for the generative answer.
          class GenerativeAnswer
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The agent will transfer the conversation to a different agent.
          # @!attribute [rw] agent
          #   @return [::String]
          #     Required. The name of the agent to transfer the conversation to. The
          #     agent must be in the same app as the current agent. Format:
          #     `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
          class TransferAgent
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The TLS configuration.
        # @!attribute [rw] ca_certs
        #   @return [::Array<::Google::Cloud::Ces::V1::TlsConfig::CaCert>]
        #     Required. Specifies a list of allowed custom CA certificates for HTTPS
        #     verification.
        class TlsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The CA certificate.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. The name of the allowed custom CA certificates. This
          #     can be used to disambiguate the custom CA certificates.
          # @!attribute [rw] cert
          #   @return [::String]
          #     Required. The allowed custom CA certificates (in DER format) for
          #     HTTPS verification. This overrides the default SSL trust store. If this
          #     is empty or unspecified, CES will use Google's default trust
          #     store to verify certificates. N.B. Make sure the HTTPS server
          #     certificates are signed with "subject alt name". For instance a
          #     certificate can be self-signed using the following command,
          #        openssl x509 -req -days 200 -in example.com.csr \
          #          -signkey example.com.key \
          #          -out example.com.crt \
          #          -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
          class CaCert
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration for tools using Service Directory.
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. The name of [Service
        #     Directory](https://cloud.google.com/service-directory) service.
        #     Format:
        #     `projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}`.
        #     Location of the service directory must be the same as the location of the
        #     app.
        class ServiceDirectoryConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A ChannelProfile configures the agent's behavior for a specific communication
        # channel, such as web UI or telephony.
        # @!attribute [rw] profile_id
        #   @return [::String]
        #     Optional. The unique identifier of the channel profile.
        # @!attribute [rw] channel_type
        #   @return [::Google::Cloud::Ces::V1::ChannelProfile::ChannelType]
        #     Optional. The type of the channel profile.
        # @!attribute [rw] persona_property
        #   @return [::Google::Cloud::Ces::V1::ChannelProfile::PersonaProperty]
        #     Optional. The persona property of the channel profile.
        # @!attribute [rw] disable_dtmf
        #   @return [::Boolean]
        #     Optional. Whether to disable DTMF (dual-tone multi-frequency).
        # @!attribute [rw] disable_barge_in_control
        #   @return [::Boolean]
        #     Optional. Whether to disable user barge-in control in the conversation.
        #     - **true**: User interruptions are disabled while the agent is speaking.
        #     - **false**: The agent retains automatic control over when the user can
        #     interrupt.
        # @!attribute [rw] web_widget_config
        #   @return [::Google::Cloud::Ces::V1::ChannelProfile::WebWidgetConfig]
        #     Optional. The configuration for the web widget.
        # @!attribute [rw] noise_suppression_level
        #   @return [::String]
        #     Optional. The noise suppression level of the channel profile.
        #     Available values are "low", "moderate", "high", "very_high".
        class ChannelProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the persona property of a channel.
          # @!attribute [rw] persona
          #   @return [::Google::Cloud::Ces::V1::ChannelProfile::PersonaProperty::Persona]
          #     Optional. The persona of the channel.
          class PersonaProperty
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The persona of the channel.
            module Persona
              # UNKNOWN persona.
              UNKNOWN = 0

              # The agent keeps the responses concise and to the point
              CONCISE = 1

              # The agent provides additional context, explanations, and details
              CHATTY = 2
            end
          end

          # Message for configuration for the web widget.
          # @!attribute [rw] modality
          #   @return [::Google::Cloud::Ces::V1::ChannelProfile::WebWidgetConfig::Modality]
          #     Optional. The modality of the web widget.
          # @!attribute [rw] theme
          #   @return [::Google::Cloud::Ces::V1::ChannelProfile::WebWidgetConfig::Theme]
          #     Optional. The theme of the web widget.
          # @!attribute [rw] web_widget_title
          #   @return [::String]
          #     Optional. The title of the web widget.
          class WebWidgetConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Modality of the web widget.
            module Modality
              # Unknown modality.
              MODALITY_UNSPECIFIED = 0

              # Widget supports both chat and voice input.
              CHAT_AND_VOICE = 1

              # Widget supports only voice input.
              VOICE_ONLY = 2

              # Widget supports only chat input.
              CHAT_ONLY = 3
            end

            # Theme of the web widget.
            module Theme
              # Unknown theme.
              THEME_UNSPECIFIED = 0

              # Light theme.
              LIGHT = 1

              # Dark theme.
              DARK = 2
            end
          end

          # The type of the channel profile.
          module ChannelType
            # Unknown channel type.
            UNKNOWN = 0

            # Web UI channel.
            WEB_UI = 2

            # API channel.
            API = 3

            # Twilio channel.
            TWILIO = 4

            # Google Telephony Platform channel.
            GOOGLE_TELEPHONY_PLATFORM = 5

            # Contact Center as a Service (CCaaS) channel.
            CONTACT_CENTER_AS_A_SERVICE = 6

            # Five9 channel.
            FIVE9 = 7
          end
        end

        # A span is a unit of work or a single operation during the request processing.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the span.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The start time of the span.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The end time of the span.
        # @!attribute [r] duration
        #   @return [::Google::Protobuf::Duration]
        #     Output only. The duration of the span.
        # @!attribute [r] attributes
        #   @return [::Google::Protobuf::Struct]
        #     Output only. Key-value attributes associated with the span.
        # @!attribute [r] child_spans
        #   @return [::Array<::Google::Cloud::Ces::V1::Span>]
        #     Output only. The child spans that are nested under this span.
        class Span
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The execution type of the tool or toolset.
        module ExecutionType
          # The execution type is unspecified. Defaults to `SYNCHRONOUS` if
          # unspecified.
          EXECUTION_TYPE_UNSPECIFIED = 0

          # The tool is executed synchronously. The session is blocked
          # until the tool returns.
          SYNCHRONOUS = 1

          # The tool is executed asynchronously. The session will
          # continue while the tool is executing.
          ASYNCHRONOUS = 2
        end
      end
    end
  end
end
