# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # A conversation represents an interaction between an end user and the CES app.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the conversation.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}`
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the conversation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the conversation was completed.
        # @!attribute [rw] turns
        #   @return [::Array<::Google::Cloud::Ces::V1::Conversation::Turn>]
        #     Required. The turns in the conversation.
        # @!attribute [r] turn_count
        #   @return [::Integer]
        #     Output only. The number of turns in the conversation.
        # @!attribute [rw] channel_type
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Ces::V1::Conversation::ChannelType]
        #     DEPRECATED. Please use
        #     {::Google::Cloud::Ces::V1::Conversation#input_types input_types} instead.
        # @!attribute [r] source
        #   @return [::Google::Cloud::Ces::V1::Conversation::Source]
        #     Output only. Indicate the source of the conversation.
        # @!attribute [r] input_types
        #   @return [::Array<::Google::Cloud::Ces::V1::Conversation::InputType>]
        #     Output only. The input types of the conversation.
        # @!attribute [r] entry_agent
        #   @return [::String]
        #     Output only. The agent that initially handles the conversation. If not
        #     specified, the conversation is handled by the root agent. Format:
        #     `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        # @!attribute [r] deployment
        #   @return [::String]
        #     Output only. The deployment of the app used for processing the
        #     conversation. Format:
        #     `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
        # @!attribute [r] app_version
        #   @return [::String]
        #     Output only. The version of the app used for processing the conversation.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
        # @!attribute [rw] messages
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::Ces::V1::Message>]
        #     Deprecated. Use turns instead.
        class Conversation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # All information about a single turn in the conversation.
          # @!attribute [rw] messages
          #   @return [::Array<::Google::Cloud::Ces::V1::Message>]
          #     Optional. List of messages in the conversation turn, including user
          #     input, agent responses and intermediate events during the processing.
          # @!attribute [rw] root_span
          #   @return [::Google::Cloud::Ces::V1::Span]
          #     Optional. The root span of the action processing.
          class Turn
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The channel type of the conversation.
          module ChannelType
            # Unspecified channel type.
            CHANNEL_TYPE_UNSPECIFIED = 0

            # The conversation only contains text messages between the end user and the
            # agent.
            TEXT = 1

            # The conversation contains audio messages between the end user and the
            # agent.
            AUDIO = 2

            # The conversation multi-modal messages (e.g. image) between the end user
            # and the agent.
            MULTIMODAL = 3
          end

          # The source of the conversation.
          module Source
            # Unspecified source.
            SOURCE_UNSPECIFIED = 0

            # The conversation is from the live end user.
            LIVE = 1

            # The conversation is from the simulator.
            SIMULATOR = 2

            # The conversation is from the evaluation.
            EVAL = 3
          end

          # Type of the input message.
          module InputType
            # Unspecified input type.
            INPUT_TYPE_UNSPECIFIED = 0

            # The input message is text.
            INPUT_TYPE_TEXT = 1

            # The input message is audio.
            INPUT_TYPE_AUDIO = 2

            # The input message is image.
            INPUT_TYPE_IMAGE = 3

            # The input message is blob file.
            INPUT_TYPE_BLOB = 4
          end
        end
      end
    end
  end
end
