# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # A DataStore resource in Vertex AI Search.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of the DataStore.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
        # @!attribute [r] type
        #   @return [::Google::Cloud::Ces::V1::DataStore::DataStoreType]
        #     Output only. The type of the data store. This field is readonly and
        #     populated by the server.
        # @!attribute [r] document_processing_mode
        #   @return [::Google::Cloud::Ces::V1::DataStore::DocumentProcessingMode]
        #     Output only. The document processing mode for the data store connection.
        #     Only set for PUBLIC_WEB and UNSTRUCTURED data stores.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of the data store.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the data store was created.
        # @!attribute [r] connector_config
        #   @return [::Google::Cloud::Ces::V1::DataStore::ConnectorConfig]
        #     Output only. The connector config for the data store connection.
        class DataStore
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The connector config for the data store connection.
          # @!attribute [rw] collection
          #   @return [::String]
          #     Resource name of the collection the data store belongs to.
          # @!attribute [rw] collection_display_name
          #   @return [::String]
          #     Display name of the collection the data store belongs to.
          # @!attribute [rw] data_source
          #   @return [::String]
          #     The name of the data source.
          #     Example: `salesforce`, `jira`, `confluence`, `bigquery`.
          class ConnectorConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of the data store.
          module DataStoreType
            # Not specified. This value indicates that the data store type is not
            # specified, so it will not be used during search.
            DATA_STORE_TYPE_UNSPECIFIED = 0

            # A data store that contains public web content.
            PUBLIC_WEB = 1

            # A data store that contains unstructured private data.
            UNSTRUCTURED = 2

            # A data store that contains structured data used as FAQ.
            FAQ = 3

            # A data store that is a connector to a first-party or a third-party
            # service.
            CONNECTOR = 4
          end

          # The document processing mode of the data store.
          module DocumentProcessingMode
            # Not specified.
            DOCUMENT_PROCESSING_MODE_UNSPECIFIED = 0

            # Documents are processed as documents.
            DOCUMENTS = 1

            # Documents are converted to chunks.
            CHUNKS = 2
          end
        end
      end
    end
  end
end
