# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # Tool to retrieve from Vertex AI Search datastore or engine for grounding.
        # Accepts either a datastore or an engine, but not both.
        # See Vertex AI Search:
        # https://cloud.google.com/generative-ai-app-builder/docs/enterprise-search-introduction.
        # @!attribute [rw] data_store_source
        #   @return [::Google::Cloud::Ces::V1::DataStoreTool::DataStoreSource]
        #     Optional. Search within a single specific DataStore.
        #
        #     Note: The following fields are mutually exclusive: `data_store_source`, `engine_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] engine_source
        #   @return [::Google::Cloud::Ces::V1::DataStoreTool::EngineSource]
        #     Optional. Search within an Engine (potentially across multiple
        #     DataStores).
        #
        #     Note: The following fields are mutually exclusive: `engine_source`, `data_store_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The data store tool name.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The tool description.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     Optional. Number of search results to return per query.
        #     The default value is 10. The maximum allowed value is 10.
        # @!attribute [rw] boost_specs
        #   @return [::Array<::Google::Cloud::Ces::V1::DataStoreTool::BoostSpecs>]
        #     Optional. Boost specification to boost certain documents.
        # @!attribute [rw] modality_configs
        #   @return [::Array<::Google::Cloud::Ces::V1::DataStoreTool::ModalityConfig>]
        #     Optional. The modality configs for the data store.
        class DataStoreTool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Rewriter configuration.
          # @!attribute [rw] model_settings
          #   @return [::Google::Cloud::Ces::V1::ModelSettings]
          #     Required. Configurations for the LLM model.
          # @!attribute [rw] prompt
          #   @return [::String]
          #     Optional. The prompt definition. If not set, default prompt will be used.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Optional. Whether the rewriter is disabled.
          class RewriterConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Summarization configuration.
          # @!attribute [rw] model_settings
          #   @return [::Google::Cloud::Ces::V1::ModelSettings]
          #     Optional. Configurations for the LLM model.
          # @!attribute [rw] prompt
          #   @return [::String]
          #     Optional. The prompt definition. If not set, default prompt will be used.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Optional. Whether summarization is disabled.
          class SummarizationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Grounding configuration.
          # @!attribute [rw] grounding_level
          #   @return [::Float]
          #     Optional. The groundedness threshold of the answer based on the retrieved
          #     sources. The value has a configurable range of [1, 5]. The level is used
          #     to threshold the groundedness of the answer, meaning that all responses
          #     with a groundedness score below the threshold will fall back to returning
          #     relevant snippets only.
          #
          #     For example, a level of 3 means that the groundedness score must be
          #     3 or higher for the response to be returned.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Optional. Whether grounding is disabled.
          class GroundingConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for searching within a specific DataStore.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Filter specification for the DataStore.
          #     See:
          #     https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata
          # @!attribute [rw] data_store
          #   @return [::Google::Cloud::Ces::V1::DataStore]
          #     Optional. The data store.
          class DataStoreSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for searching within an Engine, potentially targeting
          # specific DataStores.
          # @!attribute [rw] engine
          #   @return [::String]
          #     Required. Full resource name of the Engine.
          #     Format:
          #     `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
          # @!attribute [rw] data_store_sources
          #   @return [::Array<::Google::Cloud::Ces::V1::DataStoreTool::DataStoreSource>]
          #     Optional. Use to target specific DataStores within the Engine.
          #     If empty, the search applies to all DataStores associated with the
          #     Engine.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. A filter applied to the search across the Engine. Not relevant
          #     and not used if 'data_store_sources' is provided. See:
          #     https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata
          class EngineSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Boost specifications to boost certain documents.
          # For more information, please refer to
          # https://cloud.google.com/generative-ai-app-builder/docs/boosting.
          # @!attribute [rw] data_stores
          #   @return [::Array<::String>]
          #     Required. The Data Store where the boosting configuration is applied.
          #     Full resource name of DataStore, such as
          #     projects/\\{project}/locations/\\{location}/collections/\\{collection}/dataStores/\\{dataStore}.
          # @!attribute [rw] spec
          #   @return [::Array<::Google::Cloud::Ces::V1::DataStoreTool::BoostSpec>]
          #     Required. A list of boosting specifications.
          class BoostSpecs
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Boost specification to boost certain documents.
          # @!attribute [rw] condition_boost_specs
          #   @return [::Array<::Google::Cloud::Ces::V1::DataStoreTool::BoostSpec::ConditionBoostSpec>]
          #     Required. A list of boosting specifications.
          class BoostSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Boost specification for a condition.
            # @!attribute [rw] condition
            #   @return [::String]
            #     Required. An expression which specifies a boost condition. The syntax
            #     is the same as filter expression syntax. Currently, the only supported
            #     condition is a list of BCP-47 lang codes. Example: To boost suggestions
            #     in languages en or fr: (lang_code: ANY("en", "fr"))
            # @!attribute [rw] boost
            #   @return [::Float]
            #     Optional. Strength of the boost, which should be in [-1, 1]. Negative
            #     boost means demotion. Default is 0.0.
            #
            #     Setting to 1.0 gives the suggestions a big promotion. However, it does
            #     not necessarily mean that the top result will be a boosted suggestion.
            #
            #     Setting to -1.0 gives the suggestions a big demotion. However, other
            #     suggestions that are relevant might still be shown.
            #
            #     Setting to 0.0 means no boost applied. The boosting condition is
            #     ignored.
            # @!attribute [rw] boost_control_spec
            #   @return [::Google::Cloud::Ces::V1::DataStoreTool::BoostSpec::ConditionBoostSpec::BoostControlSpec]
            #     Optional. Complex specification for custom ranking based on customer
            #     defined attribute value.
            class ConditionBoostSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Specification for custom ranking based on customer specified attribute
              # value. It provides more controls for customized ranking than the simple
              # (condition, boost) combination above.
              # @!attribute [rw] field_name
              #   @return [::String]
              #     Optional. The name of the field whose value will be used to determine
              #     the boost amount.
              # @!attribute [rw] attribute_type
              #   @return [::Google::Cloud::Ces::V1::DataStoreTool::BoostSpec::ConditionBoostSpec::BoostControlSpec::AttributeType]
              #     Optional. The attribute type to be used to determine the boost
              #     amount. The attribute value can be derived from the field value of
              #     the specified field_name. In the case of numerical it is
              #     straightforward i.e. attribute_value = numerical_field_value. In the
              #     case of freshness however, attribute_value = (time.now() -
              #     datetime_field_value).
              # @!attribute [rw] interpolation_type
              #   @return [::Google::Cloud::Ces::V1::DataStoreTool::BoostSpec::ConditionBoostSpec::BoostControlSpec::InterpolationType]
              #     Optional. The interpolation type to be applied to connect the control
              #     points listed below.
              # @!attribute [rw] control_points
              #   @return [::Array<::Google::Cloud::Ces::V1::DataStoreTool::BoostSpec::ConditionBoostSpec::BoostControlSpec::ControlPoint>]
              #     Optional. The control points used to define the curve. The monotonic
              #     function (defined through the interpolation_type above) passes
              #     through the control points listed here.
              class BoostControlSpec
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # The control points used to define the curve. The curve defined
                # through these control points can only be monotonically increasing
                # or decreasing(constant values are acceptable).
                # @!attribute [rw] attribute_value
                #   @return [::String]
                #     Optional. Can be one of:
                #     1. The numerical field value.
                #     2. The duration spec for freshness:
                #     The value must be formatted as an XSD `dayTimeDuration` value (a
                #     restricted subset of an ISO 8601 duration value). The pattern for
                #     this is: `[nD][T[nH][nM][nS]]`.
                # @!attribute [rw] boost_amount
                #   @return [::Float]
                #     Optional. The value between -1 to 1 by which to boost the score if
                #     the attribute_value evaluates to the value specified above.
                class ControlPoint
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end

                # The attribute(or function) for which the custom ranking is to be
                # applied.
                module AttributeType
                  # Unspecified AttributeType.
                  ATTRIBUTE_TYPE_UNSPECIFIED = 0

                  # The value of the numerical field will be used to dynamically update
                  # the boost amount. In this case, the attribute_value (the x value)
                  # of the control point will be the actual value of the numerical
                  # field for which the boost_amount is specified.
                  NUMERICAL = 1

                  # For the freshness use case the attribute value will be the duration
                  # between the current time and the date in the datetime field
                  # specified. The value must be formatted as an XSD `dayTimeDuration`
                  # value (a restricted subset of an ISO 8601 duration value). The
                  # pattern for this is: `[nD][T[nH][nM][nS]]`.
                  # E.g. `5D`, `3DT12H30M`, `T24H`.
                  FRESHNESS = 2
                end

                # The interpolation type to be applied. Default will be linear
                # (Piecewise Linear).
                module InterpolationType
                  # Interpolation type is unspecified. In this case, it defaults to
                  # Linear.
                  INTERPOLATION_TYPE_UNSPECIFIED = 0

                  # Piecewise linear interpolation will be applied.
                  LINEAR = 1
                end
              end
            end
          end

          # If specified, will apply the given configuration for the specified
          # modality.
          # @!attribute [rw] modality_type
          #   @return [::Google::Cloud::Ces::V1::DataStoreTool::ModalityConfig::ModalityType]
          #     Required. The modality type.
          # @!attribute [rw] rewriter_config
          #   @return [::Google::Cloud::Ces::V1::DataStoreTool::RewriterConfig]
          #     Optional. The rewriter config.
          # @!attribute [rw] summarization_config
          #   @return [::Google::Cloud::Ces::V1::DataStoreTool::SummarizationConfig]
          #     Optional. The summarization config.
          # @!attribute [rw] grounding_config
          #   @return [::Google::Cloud::Ces::V1::DataStoreTool::GroundingConfig]
          #     Optional. The grounding configuration.
          class ModalityConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The modality type.
            module ModalityType
              # Unspecified modality type.
              MODALITY_TYPE_UNSPECIFIED = 0

              # Text modality.
              TEXT = 1

              # Audio modality.
              AUDIO = 2
            end
          end
        end
      end
    end
  end
end
