# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # A deployment represents an immutable, queryable version of the app.
        # It is used to deploy an app version with a specific channel profile.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the deployment.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/apps/\\{app}/deployments/\\{deployment}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the deployment.
        # @!attribute [rw] app_version
        #   @return [::String]
        #     Required. The resource name of the app version to deploy.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/apps/\\{app}/versions/\\{version}
        # @!attribute [rw] channel_profile
        #   @return [::Google::Cloud::Ces::V1::ChannelProfile]
        #     Required. The channel profile used in the deployment.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this deployment was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this deployment was last updated.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. Etag used to ensure the object hasn't changed during a
        #     read-modify-write operation. If the etag is empty, the update will
        #     overwrite any concurrent changes.
        class Deployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
