# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # An example represents a sample conversation between the user and the
        # agent(s).
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the example.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/examples/{example}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the example.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Human-readable description of the example.
        # @!attribute [rw] entry_agent
        #   @return [::String]
        #     Optional. The agent that initially handles the conversation. If not
        #     specified, the example represents a conversation that is handled by the
        #     root agent. Format:
        #     `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Cloud::Ces::V1::Message>]
        #     Optional. The collection of messages that make up the conversation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the example was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the example was last updated.
        # @!attribute [r] invalid
        #   @return [::Boolean]
        #     Output only. The example may become invalid if referencing resources are
        #     deleted. Invalid examples will not be used as few-shot examples.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Etag used to ensure the object hasn't changed during a read-modify-write
        #     operation. If the etag is empty, the update will overwrite any concurrent
        #     changes.
        class Example
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message within a conversation.
        # @!attribute [rw] role
        #   @return [::String]
        #     Optional. The role within the conversation, e.g., user, agent.
        # @!attribute [rw] chunks
        #   @return [::Array<::Google::Cloud::Ces::V1::Chunk>]
        #     Optional. Content of the message as a series of chunks.
        # @!attribute [rw] event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp when the message was sent or received. Should not be
        #     used if the message is part of an {::Google::Cloud::Ces::V1::Example example}.
        class Message
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A chunk of content within a message.
        # @!attribute [rw] text
        #   @return [::String]
        #     Optional. Text data.
        #
        #     Note: The following fields are mutually exclusive: `text`, `transcript`, `payload`, `image`, `tool_call`, `tool_response`, `agent_transfer`, `updated_variables`, `default_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] transcript
        #   @return [::String]
        #     Optional. Transcript associated with the audio.
        #
        #     Note: The following fields are mutually exclusive: `transcript`, `text`, `payload`, `image`, `tool_call`, `tool_response`, `agent_transfer`, `updated_variables`, `default_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] payload
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Custom payload data.
        #
        #     Note: The following fields are mutually exclusive: `payload`, `text`, `transcript`, `image`, `tool_call`, `tool_response`, `agent_transfer`, `updated_variables`, `default_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image
        #   @return [::Google::Cloud::Ces::V1::Image]
        #     Optional. Image data.
        #
        #     Note: The following fields are mutually exclusive: `image`, `text`, `transcript`, `payload`, `tool_call`, `tool_response`, `agent_transfer`, `updated_variables`, `default_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_call
        #   @return [::Google::Cloud::Ces::V1::ToolCall]
        #     Optional. Tool execution request.
        #
        #     Note: The following fields are mutually exclusive: `tool_call`, `text`, `transcript`, `payload`, `image`, `tool_response`, `agent_transfer`, `updated_variables`, `default_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_response
        #   @return [::Google::Cloud::Ces::V1::ToolResponse]
        #     Optional. Tool execution response.
        #
        #     Note: The following fields are mutually exclusive: `tool_response`, `text`, `transcript`, `payload`, `image`, `tool_call`, `agent_transfer`, `updated_variables`, `default_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] agent_transfer
        #   @return [::Google::Cloud::Ces::V1::AgentTransfer]
        #     Optional. Agent transfer event.
        #
        #     Note: The following fields are mutually exclusive: `agent_transfer`, `text`, `transcript`, `payload`, `image`, `tool_call`, `tool_response`, `updated_variables`, `default_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] updated_variables
        #   @return [::Google::Protobuf::Struct]
        #     A struct represents variables that were updated in the conversation,
        #     keyed by variable names.
        #
        #     Note: The following fields are mutually exclusive: `updated_variables`, `text`, `transcript`, `payload`, `image`, `tool_call`, `tool_response`, `agent_transfer`, `default_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] default_variables
        #   @return [::Google::Protobuf::Struct]
        #     A struct represents default variables at the start of the conversation,
        #     keyed by variable names.
        #
        #     Note: The following fields are mutually exclusive: `default_variables`, `text`, `transcript`, `payload`, `image`, `tool_call`, `tool_response`, `agent_transfer`, `updated_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Chunk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a blob input or output in the conversation.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Required. The IANA standard MIME type of the source data.
        # @!attribute [rw] data
        #   @return [::String]
        #     Required. Raw bytes of the blob.
        class Blob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an image input or output in the conversation.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Required. The IANA standard MIME type of the source data.
        #     Supported image types includes:
        #      * image/png
        #      * image/jpeg
        #      * image/webp
        # @!attribute [rw] data
        #   @return [::String]
        #     Required. Raw bytes of the image.
        class Image
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the client or the agent to execute the specified tool.
        # @!attribute [rw] tool
        #   @return [::String]
        #     Optional. The name of the tool to execute.
        #     Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
        #
        #     Note: The following fields are mutually exclusive: `tool`, `toolset_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] toolset_tool
        #   @return [::Google::Cloud::Ces::V1::ToolsetTool]
        #     Optional. The toolset tool to execute.
        #
        #     Note: The following fields are mutually exclusive: `toolset_tool`, `tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] id
        #   @return [::String]
        #     Optional. The unique identifier of the tool call. If populated, the client
        #     should return the execution result with the matching ID in
        #     {::Google::Cloud::Ces::V1::ToolResponse#id ToolResponse}.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name of the tool.
        # @!attribute [rw] args
        #   @return [::Google::Protobuf::Struct]
        #     Optional. The input parameters and values for the tool in JSON object
        #     format.
        class ToolCall
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The execution result of a specific tool from the client or the agent.
        # @!attribute [rw] tool
        #   @return [::String]
        #     Optional. The name of the tool to execute.
        #     Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
        #
        #     Note: The following fields are mutually exclusive: `tool`, `toolset_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] toolset_tool
        #   @return [::Google::Cloud::Ces::V1::ToolsetTool]
        #     Optional. The toolset tool that got executed.
        #
        #     Note: The following fields are mutually exclusive: `toolset_tool`, `tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] id
        #   @return [::String]
        #     Optional. The matching ID of the {::Google::Cloud::Ces::V1::ToolCall tool call}
        #     the response is for.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name of the tool.
        # @!attribute [rw] response
        #   @return [::Google::Protobuf::Struct]
        #     Required. The tool execution result in JSON object format.
        #     Use "output" key to specify tool response and "error" key to specify
        #     error details (if any). If "output" and "error" keys are not specified,
        #     then whole "response" is treated as tool execution result.
        class ToolResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an event indicating the transfer of a conversation to a different
        # agent.
        # @!attribute [rw] target_agent
        #   @return [::String]
        #     Required. The agent to which the conversation is being transferred. The
        #     agent will handle the conversation from this point forward. Format:
        #     `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name of the agent.
        class AgentTransfer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
