# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # Represents a tool to perform Google web searches for grounding.
        # See
        # https://cloud.google.com/customer-engagement-ai/conversational-agents/ps/tool#google-search.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tool.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the tool's purpose.
        # @!attribute [rw] context_urls
        #   @return [::Array<::String>]
        #     Optional. Content will be fetched directly from these URLs for context and
        #     grounding. More details:
        #     https://cloud.google.com/vertex-ai/generative-ai/docs/url-context. Example:
        #     "https://example.com/path.html". A maximum of 20 URLs are allowed.
        # @!attribute [rw] preferred_domains
        #   @return [::Array<::String>]
        #     Optional. Specifies domain names to guide the search.
        #     The model will be instructed to prioritize these domains when
        #     formulating queries for google search. This is a best-effort hint and these
        #     domains may or may not be exclusively reflected in the final search
        #     results. Example: "example.com", "another.site". A maximum of 20 domains
        #     can be specified.
        # @!attribute [rw] exclude_domains
        #   @return [::Array<::String>]
        #     Optional. List of domains to be excluded from the search results.
        #     Example: "example.com".
        #     A maximum of 2000 domains can be excluded.
        class GoogleSearchTool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
