# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # An MCP tool.
        # See https://modelcontextprotocol.io/specification/2025-06-18/server/tools for
        # more details.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the MCP tool.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the MCP tool.
        # @!attribute [rw] input_schema
        #   @return [::Google::Cloud::Ces::V1::Schema]
        #     Optional. The schema of the input arguments of the MCP tool.
        # @!attribute [rw] output_schema
        #   @return [::Google::Cloud::Ces::V1::Schema]
        #     Optional. The schema of the output arguments of the MCP tool.
        # @!attribute [rw] server_address
        #   @return [::String]
        #     Required. The server address of the MCP server, e.g.,
        #     "https://example.com/mcp/". If the server is built with the MCP SDK, the
        #     url should be suffixed with
        #     "/mcp/". Only Streamable HTTP transport based servers are supported. This
        #     is the same as the server_address in the McpToolset. See
        #     https://modelcontextprotocol.io/specification/2025-03-26/basic/transports#streamable-http
        #     for more details.
        # @!attribute [rw] api_authentication
        #   @return [::Google::Cloud::Ces::V1::ApiAuthentication]
        #     Optional. Authentication information required to execute the tool against
        #     the MCP server.
        # @!attribute [rw] tls_config
        #   @return [::Google::Cloud::Ces::V1::TlsConfig]
        #     Optional. The TLS configuration. Includes the custom server certificates
        #     that the client should trust.
        # @!attribute [rw] service_directory_config
        #   @return [::Google::Cloud::Ces::V1::ServiceDirectoryConfig]
        #     Optional. Service Directory configuration for VPC-SC, used to resolve
        #     service names within a perimeter.
        class McpTool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
