# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # A toolset that contains a list of tools that are offered by the MCP
        # server.
        # @!attribute [rw] server_address
        #   @return [::String]
        #     Required. The server address of the MCP server, example,
        #     "https://example.com/mcp/". If the server is built with the MCP SDK,
        #     the url should be suffixed with "/mcp/". Only Streamable HTTP transport
        #     based servers are supported. See
        #     https://modelcontextprotocol.io/specification/2025-03-26/basic/transports#streamable-http
        #     for more details.
        # @!attribute [rw] api_authentication
        #   @return [::Google::Cloud::Ces::V1::ApiAuthentication]
        #     Optional. Authentication information required to access tools and execute a
        #     tool against the MCP server. For API key auth, the API key can only be sent
        #     in the request header; sending it via query parameters is not supported.
        # @!attribute [rw] service_directory_config
        #   @return [::Google::Cloud::Ces::V1::ServiceDirectoryConfig]
        #     Optional. Service Directory configuration for VPC-SC, used to resolve
        #     service names within a perimeter.
        # @!attribute [rw] tls_config
        #   @return [::Google::Cloud::Ces::V1::TlsConfig]
        #     Optional. The TLS configuration. Includes the custom server certificates
        #     that the client should trust.
        class McpToolset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
