# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # Search suggestions from [Google Search
        # Tool][google.cloud.ces.v1.GoogleSearchTool].
        # @!attribute [rw] htmls
        #   @return [::Array<::String>]
        #     Compliant HTML and CSS styling for search suggestions.
        #     The provided HTML and CSS automatically adapts to your device settings,
        #     displaying in either light or dark mode indicated by
        #     `@media(prefers-color-scheme)`.
        # @!attribute [rw] web_search_queries
        #   @return [::Array<::Google::Cloud::Ces::V1::WebSearchQuery>]
        #     List of queries used to perform the google search along with the search
        #     result URIs forming the search suggestions.
        class GoogleSearchSuggestions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a single web search query and its associated search uri.
        # @!attribute [rw] query
        #   @return [::String]
        #     The search query text.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI to the Google Search results page for the query.
        class WebSearchQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
