# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1
        # A tool represents an action that the CES agent can take to achieve certain
        # goals.
        # @!attribute [rw] client_function
        #   @return [::Google::Cloud::Ces::V1::ClientFunction]
        #     Optional. The client function.
        #
        #     Note: The following fields are mutually exclusive: `client_function`, `open_api_tool`, `google_search_tool`, `connector_tool`, `data_store_tool`, `python_function`, `mcp_tool`, `system_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] open_api_tool
        #   @return [::Google::Cloud::Ces::V1::OpenApiTool]
        #     Optional. The open API tool.
        #
        #     Note: The following fields are mutually exclusive: `open_api_tool`, `client_function`, `google_search_tool`, `connector_tool`, `data_store_tool`, `python_function`, `mcp_tool`, `system_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] google_search_tool
        #   @return [::Google::Cloud::Ces::V1::GoogleSearchTool]
        #     Optional. The google search tool.
        #
        #     Note: The following fields are mutually exclusive: `google_search_tool`, `client_function`, `open_api_tool`, `connector_tool`, `data_store_tool`, `python_function`, `mcp_tool`, `system_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] connector_tool
        #   @return [::Google::Cloud::Ces::V1::ConnectorTool]
        #     Optional. The Integration Connector tool.
        #
        #     Note: The following fields are mutually exclusive: `connector_tool`, `client_function`, `open_api_tool`, `google_search_tool`, `data_store_tool`, `python_function`, `mcp_tool`, `system_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] data_store_tool
        #   @return [::Google::Cloud::Ces::V1::DataStoreTool]
        #     Optional. The data store tool.
        #
        #     Note: The following fields are mutually exclusive: `data_store_tool`, `client_function`, `open_api_tool`, `google_search_tool`, `connector_tool`, `python_function`, `mcp_tool`, `system_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] python_function
        #   @return [::Google::Cloud::Ces::V1::PythonFunction]
        #     Optional. The python function tool.
        #
        #     Note: The following fields are mutually exclusive: `python_function`, `client_function`, `open_api_tool`, `google_search_tool`, `connector_tool`, `data_store_tool`, `mcp_tool`, `system_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mcp_tool
        #   @return [::Google::Cloud::Ces::V1::McpTool]
        #     Optional. The MCP tool. An MCP tool cannot be created or updated directly
        #     and is managed by the MCP toolset.
        #
        #     Note: The following fields are mutually exclusive: `mcp_tool`, `client_function`, `open_api_tool`, `google_search_tool`, `connector_tool`, `data_store_tool`, `python_function`, `system_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] system_tool
        #   @return [::Google::Cloud::Ces::V1::SystemTool]
        #     Optional. The system tool.
        #
        #     Note: The following fields are mutually exclusive: `system_tool`, `client_function`, `open_api_tool`, `google_search_tool`, `connector_tool`, `data_store_tool`, `python_function`, `mcp_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the tool.
        #     Format:
        #     - `projects/{project}/locations/{location}/apps/{app}/tools/{tool}` for
        #     ## standalone tools.
        #
        #     `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}/tools/{tool}`
        #     for tools retrieved from a toolset. These tools are dynamic and
        #     output-only, they cannot be referenced directly where a tool is expected.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of the tool, derived based on the tool's
        #     type. For example, display name of a [ClientFunction][Tool.ClientFunction]
        #     is derived from its `name` property.
        # @!attribute [rw] execution_type
        #   @return [::Google::Cloud::Ces::V1::ExecutionType]
        #     Optional. The execution type of the tool.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the tool was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the tool was last updated.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Etag used to ensure the object hasn't changed during a read-modify-write
        #     operation. If the etag is empty, the update will overwrite any concurrent
        #     changes.
        # @!attribute [r] generated_summary
        #   @return [::String]
        #     Output only. If the tool is generated by the LLM assistant, this field
        #     contains a descriptive summary of the generation.
        class Tool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
