# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/ces/v1/tool_service_pb"
require "google/cloud/ces/v1/tool_service"

class ::Google::Cloud::Ces::V1::ToolService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_execute_tool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1::ExecuteToolResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tool = "hello world"
    parent = "hello world"
    args = {}

    execute_tool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :execute_tool, name
      assert_kind_of ::Google::Cloud::Ces::V1::ExecuteToolRequest, request
      assert_equal "hello world", request["tool"]
      assert_equal :tool, request.tool_identifier
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Struct), request["args"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, execute_tool_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1::ToolService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.execute_tool({ tool: tool, parent: parent, args: args }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.execute_tool tool: tool, parent: parent, args: args do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.execute_tool ::Google::Cloud::Ces::V1::ExecuteToolRequest.new(tool: tool, parent: parent, args: args) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.execute_tool({ tool: tool, parent: parent, args: args }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.execute_tool(::Google::Cloud::Ces::V1::ExecuteToolRequest.new(tool: tool, parent: parent, args: args), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, execute_tool_client_stub.call_rpc_count
    end
  end

  def test_retrieve_tool_schema
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1::RetrieveToolSchemaResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tool = "hello world"
    parent = "hello world"

    retrieve_tool_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retrieve_tool_schema, name
      assert_kind_of ::Google::Cloud::Ces::V1::RetrieveToolSchemaRequest, request
      assert_equal "hello world", request["tool"]
      assert_equal :tool, request.tool_identifier
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retrieve_tool_schema_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1::ToolService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retrieve_tool_schema({ tool: tool, parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retrieve_tool_schema tool: tool, parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retrieve_tool_schema ::Google::Cloud::Ces::V1::RetrieveToolSchemaRequest.new(tool: tool, parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retrieve_tool_schema({ tool: tool, parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retrieve_tool_schema(::Google::Cloud::Ces::V1::RetrieveToolSchemaRequest.new(tool: tool, parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retrieve_tool_schema_client_stub.call_rpc_count
    end
  end

  def test_retrieve_tools
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1::RetrieveToolsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    toolset = "hello world"
    tool_ids = ["hello world"]

    retrieve_tools_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retrieve_tools, name
      assert_kind_of ::Google::Cloud::Ces::V1::RetrieveToolsRequest, request
      assert_equal "hello world", request["toolset"]
      assert_equal ["hello world"], request["tool_ids"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retrieve_tools_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1::ToolService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retrieve_tools({ toolset: toolset, tool_ids: tool_ids }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retrieve_tools toolset: toolset, tool_ids: tool_ids do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retrieve_tools ::Google::Cloud::Ces::V1::RetrieveToolsRequest.new(toolset: toolset, tool_ids: tool_ids) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retrieve_tools({ toolset: toolset, tool_ids: tool_ids }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retrieve_tools(::Google::Cloud::Ces::V1::RetrieveToolsRequest.new(toolset: toolset, tool_ids: tool_ids), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retrieve_tools_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1::ToolService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Ces::V1::ToolService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1::ToolService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Ces::V1::ToolService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
