// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import type {protobuf as $protobuf} from "google-gax";
import Long = require("long");
/** Namespace google. */
export namespace google {

    /** Namespace cloud. */
    namespace cloud {

        /** Namespace ces. */
        namespace ces {

            /** Namespace v1beta. */
            namespace v1beta {

                /** Properties of an Agent. */
                interface IAgent {

                    /** Agent llmAgent */
                    llmAgent?: (google.cloud.ces.v1beta.Agent.ILlmAgent|null);

                    /** Agent remoteDialogflowAgent */
                    remoteDialogflowAgent?: (google.cloud.ces.v1beta.Agent.IRemoteDialogflowAgent|null);

                    /** Agent name */
                    name?: (string|null);

                    /** Agent displayName */
                    displayName?: (string|null);

                    /** Agent description */
                    description?: (string|null);

                    /** Agent modelSettings */
                    modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                    /** Agent instruction */
                    instruction?: (string|null);

                    /** Agent tools */
                    tools?: (string[]|null);

                    /** Agent childAgents */
                    childAgents?: (string[]|null);

                    /** Agent beforeAgentCallbacks */
                    beforeAgentCallbacks?: (google.cloud.ces.v1beta.ICallback[]|null);

                    /** Agent afterAgentCallbacks */
                    afterAgentCallbacks?: (google.cloud.ces.v1beta.ICallback[]|null);

                    /** Agent beforeModelCallbacks */
                    beforeModelCallbacks?: (google.cloud.ces.v1beta.ICallback[]|null);

                    /** Agent afterModelCallbacks */
                    afterModelCallbacks?: (google.cloud.ces.v1beta.ICallback[]|null);

                    /** Agent beforeToolCallbacks */
                    beforeToolCallbacks?: (google.cloud.ces.v1beta.ICallback[]|null);

                    /** Agent afterToolCallbacks */
                    afterToolCallbacks?: (google.cloud.ces.v1beta.ICallback[]|null);

                    /** Agent createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** Agent updateTime */
                    updateTime?: (google.protobuf.ITimestamp|null);

                    /** Agent guardrails */
                    guardrails?: (string[]|null);

                    /** Agent etag */
                    etag?: (string|null);

                    /** Agent toolsets */
                    toolsets?: (google.cloud.ces.v1beta.Agent.IAgentToolset[]|null);

                    /** Agent generatedSummary */
                    generatedSummary?: (string|null);
                }

                /** Represents an Agent. */
                class Agent implements IAgent {

                    /**
                     * Constructs a new Agent.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IAgent);

                    /** Agent llmAgent. */
                    public llmAgent?: (google.cloud.ces.v1beta.Agent.ILlmAgent|null);

                    /** Agent remoteDialogflowAgent. */
                    public remoteDialogflowAgent?: (google.cloud.ces.v1beta.Agent.IRemoteDialogflowAgent|null);

                    /** Agent name. */
                    public name: string;

                    /** Agent displayName. */
                    public displayName: string;

                    /** Agent description. */
                    public description: string;

                    /** Agent modelSettings. */
                    public modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                    /** Agent instruction. */
                    public instruction: string;

                    /** Agent tools. */
                    public tools: string[];

                    /** Agent childAgents. */
                    public childAgents: string[];

                    /** Agent beforeAgentCallbacks. */
                    public beforeAgentCallbacks: google.cloud.ces.v1beta.ICallback[];

                    /** Agent afterAgentCallbacks. */
                    public afterAgentCallbacks: google.cloud.ces.v1beta.ICallback[];

                    /** Agent beforeModelCallbacks. */
                    public beforeModelCallbacks: google.cloud.ces.v1beta.ICallback[];

                    /** Agent afterModelCallbacks. */
                    public afterModelCallbacks: google.cloud.ces.v1beta.ICallback[];

                    /** Agent beforeToolCallbacks. */
                    public beforeToolCallbacks: google.cloud.ces.v1beta.ICallback[];

                    /** Agent afterToolCallbacks. */
                    public afterToolCallbacks: google.cloud.ces.v1beta.ICallback[];

                    /** Agent createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** Agent updateTime. */
                    public updateTime?: (google.protobuf.ITimestamp|null);

                    /** Agent guardrails. */
                    public guardrails: string[];

                    /** Agent etag. */
                    public etag: string;

                    /** Agent toolsets. */
                    public toolsets: google.cloud.ces.v1beta.Agent.IAgentToolset[];

                    /** Agent generatedSummary. */
                    public generatedSummary: string;

                    /** Agent agentType. */
                    public agentType?: ("llmAgent"|"remoteDialogflowAgent");

                    /**
                     * Creates a new Agent instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Agent instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IAgent): google.cloud.ces.v1beta.Agent;

                    /**
                     * Encodes the specified Agent message. Does not implicitly {@link google.cloud.ces.v1beta.Agent.verify|verify} messages.
                     * @param message Agent message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Agent message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Agent.verify|verify} messages.
                     * @param message Agent message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an Agent message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Agent
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Agent;

                    /**
                     * Decodes an Agent message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Agent
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Agent;

                    /**
                     * Verifies an Agent message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an Agent message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Agent
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Agent;

                    /**
                     * Creates a plain object from an Agent message. Also converts values to other types if specified.
                     * @param message Agent
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Agent, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Agent to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Agent
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Agent {

                    /** Properties of a LlmAgent. */
                    interface ILlmAgent {
                    }

                    /** Represents a LlmAgent. */
                    class LlmAgent implements ILlmAgent {

                        /**
                         * Constructs a new LlmAgent.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.Agent.ILlmAgent);

                        /**
                         * Creates a new LlmAgent instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns LlmAgent instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.Agent.ILlmAgent): google.cloud.ces.v1beta.Agent.LlmAgent;

                        /**
                         * Encodes the specified LlmAgent message. Does not implicitly {@link google.cloud.ces.v1beta.Agent.LlmAgent.verify|verify} messages.
                         * @param message LlmAgent message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.Agent.ILlmAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified LlmAgent message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Agent.LlmAgent.verify|verify} messages.
                         * @param message LlmAgent message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.Agent.ILlmAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a LlmAgent message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns LlmAgent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Agent.LlmAgent;

                        /**
                         * Decodes a LlmAgent message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns LlmAgent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Agent.LlmAgent;

                        /**
                         * Verifies a LlmAgent message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a LlmAgent message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns LlmAgent
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Agent.LlmAgent;

                        /**
                         * Creates a plain object from a LlmAgent message. Also converts values to other types if specified.
                         * @param message LlmAgent
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.Agent.LlmAgent, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this LlmAgent to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for LlmAgent
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a RemoteDialogflowAgent. */
                    interface IRemoteDialogflowAgent {

                        /** RemoteDialogflowAgent agent */
                        agent?: (string|null);

                        /** RemoteDialogflowAgent flowId */
                        flowId?: (string|null);

                        /** RemoteDialogflowAgent environmentId */
                        environmentId?: (string|null);

                        /** RemoteDialogflowAgent inputVariableMapping */
                        inputVariableMapping?: ({ [k: string]: string }|null);

                        /** RemoteDialogflowAgent outputVariableMapping */
                        outputVariableMapping?: ({ [k: string]: string }|null);

                        /** RemoteDialogflowAgent respectResponseInterruptionSettings */
                        respectResponseInterruptionSettings?: (boolean|null);
                    }

                    /** Represents a RemoteDialogflowAgent. */
                    class RemoteDialogflowAgent implements IRemoteDialogflowAgent {

                        /**
                         * Constructs a new RemoteDialogflowAgent.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.Agent.IRemoteDialogflowAgent);

                        /** RemoteDialogflowAgent agent. */
                        public agent: string;

                        /** RemoteDialogflowAgent flowId. */
                        public flowId: string;

                        /** RemoteDialogflowAgent environmentId. */
                        public environmentId: string;

                        /** RemoteDialogflowAgent inputVariableMapping. */
                        public inputVariableMapping: { [k: string]: string };

                        /** RemoteDialogflowAgent outputVariableMapping. */
                        public outputVariableMapping: { [k: string]: string };

                        /** RemoteDialogflowAgent respectResponseInterruptionSettings. */
                        public respectResponseInterruptionSettings: boolean;

                        /**
                         * Creates a new RemoteDialogflowAgent instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns RemoteDialogflowAgent instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.Agent.IRemoteDialogflowAgent): google.cloud.ces.v1beta.Agent.RemoteDialogflowAgent;

                        /**
                         * Encodes the specified RemoteDialogflowAgent message. Does not implicitly {@link google.cloud.ces.v1beta.Agent.RemoteDialogflowAgent.verify|verify} messages.
                         * @param message RemoteDialogflowAgent message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.Agent.IRemoteDialogflowAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified RemoteDialogflowAgent message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Agent.RemoteDialogflowAgent.verify|verify} messages.
                         * @param message RemoteDialogflowAgent message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.Agent.IRemoteDialogflowAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a RemoteDialogflowAgent message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns RemoteDialogflowAgent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Agent.RemoteDialogflowAgent;

                        /**
                         * Decodes a RemoteDialogflowAgent message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns RemoteDialogflowAgent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Agent.RemoteDialogflowAgent;

                        /**
                         * Verifies a RemoteDialogflowAgent message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a RemoteDialogflowAgent message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns RemoteDialogflowAgent
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Agent.RemoteDialogflowAgent;

                        /**
                         * Creates a plain object from a RemoteDialogflowAgent message. Also converts values to other types if specified.
                         * @param message RemoteDialogflowAgent
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.Agent.RemoteDialogflowAgent, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this RemoteDialogflowAgent to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for RemoteDialogflowAgent
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of an AgentToolset. */
                    interface IAgentToolset {

                        /** AgentToolset toolset */
                        toolset?: (string|null);

                        /** AgentToolset toolIds */
                        toolIds?: (string[]|null);
                    }

                    /** Represents an AgentToolset. */
                    class AgentToolset implements IAgentToolset {

                        /**
                         * Constructs a new AgentToolset.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.Agent.IAgentToolset);

                        /** AgentToolset toolset. */
                        public toolset: string;

                        /** AgentToolset toolIds. */
                        public toolIds: string[];

                        /**
                         * Creates a new AgentToolset instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns AgentToolset instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.Agent.IAgentToolset): google.cloud.ces.v1beta.Agent.AgentToolset;

                        /**
                         * Encodes the specified AgentToolset message. Does not implicitly {@link google.cloud.ces.v1beta.Agent.AgentToolset.verify|verify} messages.
                         * @param message AgentToolset message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.Agent.IAgentToolset, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified AgentToolset message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Agent.AgentToolset.verify|verify} messages.
                         * @param message AgentToolset message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.Agent.IAgentToolset, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an AgentToolset message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns AgentToolset
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Agent.AgentToolset;

                        /**
                         * Decodes an AgentToolset message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns AgentToolset
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Agent.AgentToolset;

                        /**
                         * Verifies an AgentToolset message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an AgentToolset message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns AgentToolset
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Agent.AgentToolset;

                        /**
                         * Creates a plain object from an AgentToolset message. Also converts values to other types if specified.
                         * @param message AgentToolset
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.Agent.AgentToolset, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this AgentToolset to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for AgentToolset
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** ExecutionType enum. */
                enum ExecutionType {
                    EXECUTION_TYPE_UNSPECIFIED = 0,
                    SYNCHRONOUS = 1,
                    ASYNCHRONOUS = 2
                }

                /** Properties of a Callback. */
                interface ICallback {

                    /** Callback pythonCode */
                    pythonCode?: (string|null);

                    /** Callback description */
                    description?: (string|null);

                    /** Callback disabled */
                    disabled?: (boolean|null);
                }

                /** Represents a Callback. */
                class Callback implements ICallback {

                    /**
                     * Constructs a new Callback.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICallback);

                    /** Callback pythonCode. */
                    public pythonCode?: (string|null);

                    /** Callback description. */
                    public description: string;

                    /** Callback disabled. */
                    public disabled: boolean;

                    /** Callback callback. */
                    public callback?: "pythonCode";

                    /**
                     * Creates a new Callback instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Callback instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICallback): google.cloud.ces.v1beta.Callback;

                    /**
                     * Encodes the specified Callback message. Does not implicitly {@link google.cloud.ces.v1beta.Callback.verify|verify} messages.
                     * @param message Callback message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICallback, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Callback message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Callback.verify|verify} messages.
                     * @param message Callback message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICallback, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Callback message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Callback
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Callback;

                    /**
                     * Decodes a Callback message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Callback
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Callback;

                    /**
                     * Verifies a Callback message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Callback message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Callback
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Callback;

                    /**
                     * Creates a plain object from a Callback message. Also converts values to other types if specified.
                     * @param message Callback
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Callback, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Callback to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Callback
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ModelSettings. */
                interface IModelSettings {

                    /** ModelSettings model */
                    model?: (string|null);

                    /** ModelSettings temperature */
                    temperature?: (number|null);
                }

                /** Represents a ModelSettings. */
                class ModelSettings implements IModelSettings {

                    /**
                     * Constructs a new ModelSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IModelSettings);

                    /** ModelSettings model. */
                    public model: string;

                    /** ModelSettings temperature. */
                    public temperature?: (number|null);

                    /**
                     * Creates a new ModelSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ModelSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IModelSettings): google.cloud.ces.v1beta.ModelSettings;

                    /**
                     * Encodes the specified ModelSettings message. Does not implicitly {@link google.cloud.ces.v1beta.ModelSettings.verify|verify} messages.
                     * @param message ModelSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IModelSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ModelSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ModelSettings.verify|verify} messages.
                     * @param message ModelSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IModelSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ModelSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ModelSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ModelSettings;

                    /**
                     * Decodes a ModelSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ModelSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ModelSettings;

                    /**
                     * Verifies a ModelSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ModelSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ModelSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ModelSettings;

                    /**
                     * Creates a plain object from a ModelSettings message. Also converts values to other types if specified.
                     * @param message ModelSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ModelSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ModelSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ModelSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a TriggerAction. */
                interface ITriggerAction {

                    /** TriggerAction respondImmediately */
                    respondImmediately?: (google.cloud.ces.v1beta.TriggerAction.IRespondImmediately|null);

                    /** TriggerAction transferAgent */
                    transferAgent?: (google.cloud.ces.v1beta.TriggerAction.ITransferAgent|null);

                    /** TriggerAction generativeAnswer */
                    generativeAnswer?: (google.cloud.ces.v1beta.TriggerAction.IGenerativeAnswer|null);
                }

                /** Represents a TriggerAction. */
                class TriggerAction implements ITriggerAction {

                    /**
                     * Constructs a new TriggerAction.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ITriggerAction);

                    /** TriggerAction respondImmediately. */
                    public respondImmediately?: (google.cloud.ces.v1beta.TriggerAction.IRespondImmediately|null);

                    /** TriggerAction transferAgent. */
                    public transferAgent?: (google.cloud.ces.v1beta.TriggerAction.ITransferAgent|null);

                    /** TriggerAction generativeAnswer. */
                    public generativeAnswer?: (google.cloud.ces.v1beta.TriggerAction.IGenerativeAnswer|null);

                    /** TriggerAction action. */
                    public action?: ("respondImmediately"|"transferAgent"|"generativeAnswer");

                    /**
                     * Creates a new TriggerAction instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TriggerAction instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ITriggerAction): google.cloud.ces.v1beta.TriggerAction;

                    /**
                     * Encodes the specified TriggerAction message. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.verify|verify} messages.
                     * @param message TriggerAction message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ITriggerAction, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TriggerAction message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.verify|verify} messages.
                     * @param message TriggerAction message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ITriggerAction, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TriggerAction message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TriggerAction
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.TriggerAction;

                    /**
                     * Decodes a TriggerAction message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TriggerAction
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.TriggerAction;

                    /**
                     * Verifies a TriggerAction message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TriggerAction message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TriggerAction
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.TriggerAction;

                    /**
                     * Creates a plain object from a TriggerAction message. Also converts values to other types if specified.
                     * @param message TriggerAction
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.TriggerAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TriggerAction to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for TriggerAction
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace TriggerAction {

                    /** Properties of a Response. */
                    interface IResponse {

                        /** Response text */
                        text?: (string|null);

                        /** Response disabled */
                        disabled?: (boolean|null);
                    }

                    /** Represents a Response. */
                    class Response implements IResponse {

                        /**
                         * Constructs a new Response.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.TriggerAction.IResponse);

                        /** Response text. */
                        public text: string;

                        /** Response disabled. */
                        public disabled: boolean;

                        /**
                         * Creates a new Response instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Response instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.TriggerAction.IResponse): google.cloud.ces.v1beta.TriggerAction.Response;

                        /**
                         * Encodes the specified Response message. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.Response.verify|verify} messages.
                         * @param message Response message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.TriggerAction.IResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Response message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.Response.verify|verify} messages.
                         * @param message Response message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.TriggerAction.IResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Response message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Response
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.TriggerAction.Response;

                        /**
                         * Decodes a Response message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Response
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.TriggerAction.Response;

                        /**
                         * Verifies a Response message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Response message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Response
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.TriggerAction.Response;

                        /**
                         * Creates a plain object from a Response message. Also converts values to other types if specified.
                         * @param message Response
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.TriggerAction.Response, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Response to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Response
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a RespondImmediately. */
                    interface IRespondImmediately {

                        /** RespondImmediately responses */
                        responses?: (google.cloud.ces.v1beta.TriggerAction.IResponse[]|null);
                    }

                    /** Represents a RespondImmediately. */
                    class RespondImmediately implements IRespondImmediately {

                        /**
                         * Constructs a new RespondImmediately.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.TriggerAction.IRespondImmediately);

                        /** RespondImmediately responses. */
                        public responses: google.cloud.ces.v1beta.TriggerAction.IResponse[];

                        /**
                         * Creates a new RespondImmediately instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns RespondImmediately instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.TriggerAction.IRespondImmediately): google.cloud.ces.v1beta.TriggerAction.RespondImmediately;

                        /**
                         * Encodes the specified RespondImmediately message. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.RespondImmediately.verify|verify} messages.
                         * @param message RespondImmediately message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.TriggerAction.IRespondImmediately, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified RespondImmediately message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.RespondImmediately.verify|verify} messages.
                         * @param message RespondImmediately message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.TriggerAction.IRespondImmediately, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a RespondImmediately message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns RespondImmediately
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.TriggerAction.RespondImmediately;

                        /**
                         * Decodes a RespondImmediately message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns RespondImmediately
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.TriggerAction.RespondImmediately;

                        /**
                         * Verifies a RespondImmediately message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a RespondImmediately message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns RespondImmediately
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.TriggerAction.RespondImmediately;

                        /**
                         * Creates a plain object from a RespondImmediately message. Also converts values to other types if specified.
                         * @param message RespondImmediately
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.TriggerAction.RespondImmediately, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this RespondImmediately to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for RespondImmediately
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a GenerativeAnswer. */
                    interface IGenerativeAnswer {

                        /** GenerativeAnswer prompt */
                        prompt?: (string|null);
                    }

                    /** Represents a GenerativeAnswer. */
                    class GenerativeAnswer implements IGenerativeAnswer {

                        /**
                         * Constructs a new GenerativeAnswer.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.TriggerAction.IGenerativeAnswer);

                        /** GenerativeAnswer prompt. */
                        public prompt: string;

                        /**
                         * Creates a new GenerativeAnswer instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GenerativeAnswer instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.TriggerAction.IGenerativeAnswer): google.cloud.ces.v1beta.TriggerAction.GenerativeAnswer;

                        /**
                         * Encodes the specified GenerativeAnswer message. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.GenerativeAnswer.verify|verify} messages.
                         * @param message GenerativeAnswer message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.TriggerAction.IGenerativeAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GenerativeAnswer message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.GenerativeAnswer.verify|verify} messages.
                         * @param message GenerativeAnswer message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.TriggerAction.IGenerativeAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GenerativeAnswer message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GenerativeAnswer
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.TriggerAction.GenerativeAnswer;

                        /**
                         * Decodes a GenerativeAnswer message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GenerativeAnswer
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.TriggerAction.GenerativeAnswer;

                        /**
                         * Verifies a GenerativeAnswer message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GenerativeAnswer message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GenerativeAnswer
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.TriggerAction.GenerativeAnswer;

                        /**
                         * Creates a plain object from a GenerativeAnswer message. Also converts values to other types if specified.
                         * @param message GenerativeAnswer
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.TriggerAction.GenerativeAnswer, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GenerativeAnswer to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for GenerativeAnswer
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a TransferAgent. */
                    interface ITransferAgent {

                        /** TransferAgent agent */
                        agent?: (string|null);
                    }

                    /** Represents a TransferAgent. */
                    class TransferAgent implements ITransferAgent {

                        /**
                         * Constructs a new TransferAgent.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.TriggerAction.ITransferAgent);

                        /** TransferAgent agent. */
                        public agent: string;

                        /**
                         * Creates a new TransferAgent instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TransferAgent instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.TriggerAction.ITransferAgent): google.cloud.ces.v1beta.TriggerAction.TransferAgent;

                        /**
                         * Encodes the specified TransferAgent message. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.TransferAgent.verify|verify} messages.
                         * @param message TransferAgent message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.TriggerAction.ITransferAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TransferAgent message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.TriggerAction.TransferAgent.verify|verify} messages.
                         * @param message TransferAgent message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.TriggerAction.ITransferAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TransferAgent message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TransferAgent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.TriggerAction.TransferAgent;

                        /**
                         * Decodes a TransferAgent message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TransferAgent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.TriggerAction.TransferAgent;

                        /**
                         * Verifies a TransferAgent message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TransferAgent message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TransferAgent
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.TriggerAction.TransferAgent;

                        /**
                         * Creates a plain object from a TransferAgent message. Also converts values to other types if specified.
                         * @param message TransferAgent
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.TriggerAction.TransferAgent, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TransferAgent to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for TransferAgent
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** Properties of a TlsConfig. */
                interface ITlsConfig {

                    /** TlsConfig caCerts */
                    caCerts?: (google.cloud.ces.v1beta.TlsConfig.ICaCert[]|null);
                }

                /** Represents a TlsConfig. */
                class TlsConfig implements ITlsConfig {

                    /**
                     * Constructs a new TlsConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ITlsConfig);

                    /** TlsConfig caCerts. */
                    public caCerts: google.cloud.ces.v1beta.TlsConfig.ICaCert[];

                    /**
                     * Creates a new TlsConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TlsConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ITlsConfig): google.cloud.ces.v1beta.TlsConfig;

                    /**
                     * Encodes the specified TlsConfig message. Does not implicitly {@link google.cloud.ces.v1beta.TlsConfig.verify|verify} messages.
                     * @param message TlsConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ITlsConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TlsConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.TlsConfig.verify|verify} messages.
                     * @param message TlsConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ITlsConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TlsConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TlsConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.TlsConfig;

                    /**
                     * Decodes a TlsConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TlsConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.TlsConfig;

                    /**
                     * Verifies a TlsConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TlsConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TlsConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.TlsConfig;

                    /**
                     * Creates a plain object from a TlsConfig message. Also converts values to other types if specified.
                     * @param message TlsConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.TlsConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TlsConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for TlsConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace TlsConfig {

                    /** Properties of a CaCert. */
                    interface ICaCert {

                        /** CaCert displayName */
                        displayName?: (string|null);

                        /** CaCert cert */
                        cert?: (Uint8Array|Buffer|string|null);
                    }

                    /** Represents a CaCert. */
                    class CaCert implements ICaCert {

                        /**
                         * Constructs a new CaCert.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.TlsConfig.ICaCert);

                        /** CaCert displayName. */
                        public displayName: string;

                        /** CaCert cert. */
                        public cert: (Uint8Array|Buffer|string);

                        /**
                         * Creates a new CaCert instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CaCert instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.TlsConfig.ICaCert): google.cloud.ces.v1beta.TlsConfig.CaCert;

                        /**
                         * Encodes the specified CaCert message. Does not implicitly {@link google.cloud.ces.v1beta.TlsConfig.CaCert.verify|verify} messages.
                         * @param message CaCert message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.TlsConfig.ICaCert, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CaCert message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.TlsConfig.CaCert.verify|verify} messages.
                         * @param message CaCert message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.TlsConfig.ICaCert, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CaCert message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CaCert
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.TlsConfig.CaCert;

                        /**
                         * Decodes a CaCert message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CaCert
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.TlsConfig.CaCert;

                        /**
                         * Verifies a CaCert message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CaCert message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CaCert
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.TlsConfig.CaCert;

                        /**
                         * Creates a plain object from a CaCert message. Also converts values to other types if specified.
                         * @param message CaCert
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.TlsConfig.CaCert, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CaCert to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for CaCert
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** Properties of a ServiceDirectoryConfig. */
                interface IServiceDirectoryConfig {

                    /** ServiceDirectoryConfig service */
                    service?: (string|null);
                }

                /** Represents a ServiceDirectoryConfig. */
                class ServiceDirectoryConfig implements IServiceDirectoryConfig {

                    /**
                     * Constructs a new ServiceDirectoryConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IServiceDirectoryConfig);

                    /** ServiceDirectoryConfig service. */
                    public service: string;

                    /**
                     * Creates a new ServiceDirectoryConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ServiceDirectoryConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IServiceDirectoryConfig): google.cloud.ces.v1beta.ServiceDirectoryConfig;

                    /**
                     * Encodes the specified ServiceDirectoryConfig message. Does not implicitly {@link google.cloud.ces.v1beta.ServiceDirectoryConfig.verify|verify} messages.
                     * @param message ServiceDirectoryConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IServiceDirectoryConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ServiceDirectoryConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ServiceDirectoryConfig.verify|verify} messages.
                     * @param message ServiceDirectoryConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IServiceDirectoryConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ServiceDirectoryConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ServiceDirectoryConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ServiceDirectoryConfig;

                    /**
                     * Decodes a ServiceDirectoryConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ServiceDirectoryConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ServiceDirectoryConfig;

                    /**
                     * Verifies a ServiceDirectoryConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ServiceDirectoryConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ServiceDirectoryConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ServiceDirectoryConfig;

                    /**
                     * Creates a plain object from a ServiceDirectoryConfig message. Also converts values to other types if specified.
                     * @param message ServiceDirectoryConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ServiceDirectoryConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ServiceDirectoryConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ServiceDirectoryConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ChannelProfile. */
                interface IChannelProfile {

                    /** ChannelProfile profileId */
                    profileId?: (string|null);

                    /** ChannelProfile channelType */
                    channelType?: (google.cloud.ces.v1beta.ChannelProfile.ChannelType|keyof typeof google.cloud.ces.v1beta.ChannelProfile.ChannelType|null);

                    /** ChannelProfile personaProperty */
                    personaProperty?: (google.cloud.ces.v1beta.ChannelProfile.IPersonaProperty|null);

                    /** ChannelProfile disableDtmf */
                    disableDtmf?: (boolean|null);

                    /** ChannelProfile disableBargeInControl */
                    disableBargeInControl?: (boolean|null);

                    /** ChannelProfile webWidgetConfig */
                    webWidgetConfig?: (google.cloud.ces.v1beta.ChannelProfile.IWebWidgetConfig|null);

                    /** ChannelProfile noiseSuppressionLevel */
                    noiseSuppressionLevel?: (string|null);
                }

                /** Represents a ChannelProfile. */
                class ChannelProfile implements IChannelProfile {

                    /**
                     * Constructs a new ChannelProfile.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IChannelProfile);

                    /** ChannelProfile profileId. */
                    public profileId: string;

                    /** ChannelProfile channelType. */
                    public channelType: (google.cloud.ces.v1beta.ChannelProfile.ChannelType|keyof typeof google.cloud.ces.v1beta.ChannelProfile.ChannelType);

                    /** ChannelProfile personaProperty. */
                    public personaProperty?: (google.cloud.ces.v1beta.ChannelProfile.IPersonaProperty|null);

                    /** ChannelProfile disableDtmf. */
                    public disableDtmf: boolean;

                    /** ChannelProfile disableBargeInControl. */
                    public disableBargeInControl: boolean;

                    /** ChannelProfile webWidgetConfig. */
                    public webWidgetConfig?: (google.cloud.ces.v1beta.ChannelProfile.IWebWidgetConfig|null);

                    /** ChannelProfile noiseSuppressionLevel. */
                    public noiseSuppressionLevel: string;

                    /**
                     * Creates a new ChannelProfile instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ChannelProfile instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IChannelProfile): google.cloud.ces.v1beta.ChannelProfile;

                    /**
                     * Encodes the specified ChannelProfile message. Does not implicitly {@link google.cloud.ces.v1beta.ChannelProfile.verify|verify} messages.
                     * @param message ChannelProfile message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IChannelProfile, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ChannelProfile message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ChannelProfile.verify|verify} messages.
                     * @param message ChannelProfile message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IChannelProfile, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ChannelProfile message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ChannelProfile
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ChannelProfile;

                    /**
                     * Decodes a ChannelProfile message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ChannelProfile
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ChannelProfile;

                    /**
                     * Verifies a ChannelProfile message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ChannelProfile message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ChannelProfile
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ChannelProfile;

                    /**
                     * Creates a plain object from a ChannelProfile message. Also converts values to other types if specified.
                     * @param message ChannelProfile
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ChannelProfile, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ChannelProfile to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ChannelProfile
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace ChannelProfile {

                    /** Properties of a PersonaProperty. */
                    interface IPersonaProperty {

                        /** PersonaProperty persona */
                        persona?: (google.cloud.ces.v1beta.ChannelProfile.PersonaProperty.Persona|keyof typeof google.cloud.ces.v1beta.ChannelProfile.PersonaProperty.Persona|null);
                    }

                    /** Represents a PersonaProperty. */
                    class PersonaProperty implements IPersonaProperty {

                        /**
                         * Constructs a new PersonaProperty.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.ChannelProfile.IPersonaProperty);

                        /** PersonaProperty persona. */
                        public persona: (google.cloud.ces.v1beta.ChannelProfile.PersonaProperty.Persona|keyof typeof google.cloud.ces.v1beta.ChannelProfile.PersonaProperty.Persona);

                        /**
                         * Creates a new PersonaProperty instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns PersonaProperty instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.ChannelProfile.IPersonaProperty): google.cloud.ces.v1beta.ChannelProfile.PersonaProperty;

                        /**
                         * Encodes the specified PersonaProperty message. Does not implicitly {@link google.cloud.ces.v1beta.ChannelProfile.PersonaProperty.verify|verify} messages.
                         * @param message PersonaProperty message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.ChannelProfile.IPersonaProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified PersonaProperty message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ChannelProfile.PersonaProperty.verify|verify} messages.
                         * @param message PersonaProperty message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.ChannelProfile.IPersonaProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a PersonaProperty message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns PersonaProperty
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ChannelProfile.PersonaProperty;

                        /**
                         * Decodes a PersonaProperty message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns PersonaProperty
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ChannelProfile.PersonaProperty;

                        /**
                         * Verifies a PersonaProperty message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a PersonaProperty message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns PersonaProperty
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ChannelProfile.PersonaProperty;

                        /**
                         * Creates a plain object from a PersonaProperty message. Also converts values to other types if specified.
                         * @param message PersonaProperty
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.ChannelProfile.PersonaProperty, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this PersonaProperty to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for PersonaProperty
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace PersonaProperty {

                        /** Persona enum. */
                        enum Persona {
                            UNKNOWN = 0,
                            CONCISE = 1,
                            CHATTY = 2
                        }
                    }

                    /** Properties of a WebWidgetConfig. */
                    interface IWebWidgetConfig {

                        /** WebWidgetConfig modality */
                        modality?: (google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.Modality|keyof typeof google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.Modality|null);

                        /** WebWidgetConfig theme */
                        theme?: (google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.Theme|keyof typeof google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.Theme|null);

                        /** WebWidgetConfig webWidgetTitle */
                        webWidgetTitle?: (string|null);
                    }

                    /** Represents a WebWidgetConfig. */
                    class WebWidgetConfig implements IWebWidgetConfig {

                        /**
                         * Constructs a new WebWidgetConfig.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.ChannelProfile.IWebWidgetConfig);

                        /** WebWidgetConfig modality. */
                        public modality: (google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.Modality|keyof typeof google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.Modality);

                        /** WebWidgetConfig theme. */
                        public theme: (google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.Theme|keyof typeof google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.Theme);

                        /** WebWidgetConfig webWidgetTitle. */
                        public webWidgetTitle: string;

                        /**
                         * Creates a new WebWidgetConfig instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns WebWidgetConfig instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.ChannelProfile.IWebWidgetConfig): google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig;

                        /**
                         * Encodes the specified WebWidgetConfig message. Does not implicitly {@link google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.verify|verify} messages.
                         * @param message WebWidgetConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.ChannelProfile.IWebWidgetConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified WebWidgetConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig.verify|verify} messages.
                         * @param message WebWidgetConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.ChannelProfile.IWebWidgetConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a WebWidgetConfig message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns WebWidgetConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig;

                        /**
                         * Decodes a WebWidgetConfig message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns WebWidgetConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig;

                        /**
                         * Verifies a WebWidgetConfig message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a WebWidgetConfig message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns WebWidgetConfig
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig;

                        /**
                         * Creates a plain object from a WebWidgetConfig message. Also converts values to other types if specified.
                         * @param message WebWidgetConfig
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.ChannelProfile.WebWidgetConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this WebWidgetConfig to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for WebWidgetConfig
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace WebWidgetConfig {

                        /** Modality enum. */
                        enum Modality {
                            MODALITY_UNSPECIFIED = 0,
                            CHAT_AND_VOICE = 1,
                            VOICE_ONLY = 2,
                            CHAT_ONLY = 3
                        }

                        /** Theme enum. */
                        enum Theme {
                            THEME_UNSPECIFIED = 0,
                            LIGHT = 1,
                            DARK = 2
                        }
                    }

                    /** ChannelType enum. */
                    enum ChannelType {
                        UNKNOWN = 0,
                        WEB_UI = 2,
                        API = 3,
                        TWILIO = 4,
                        GOOGLE_TELEPHONY_PLATFORM = 5,
                        CONTACT_CENTER_AS_A_SERVICE = 6,
                        FIVE9 = 7
                    }
                }

                /** Properties of a Span. */
                interface ISpan {

                    /** Span name */
                    name?: (string|null);

                    /** Span startTime */
                    startTime?: (google.protobuf.ITimestamp|null);

                    /** Span endTime */
                    endTime?: (google.protobuf.ITimestamp|null);

                    /** Span duration */
                    duration?: (google.protobuf.IDuration|null);

                    /** Span attributes */
                    attributes?: (google.protobuf.IStruct|null);

                    /** Span childSpans */
                    childSpans?: (google.cloud.ces.v1beta.ISpan[]|null);
                }

                /** Represents a Span. */
                class Span implements ISpan {

                    /**
                     * Constructs a new Span.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ISpan);

                    /** Span name. */
                    public name: string;

                    /** Span startTime. */
                    public startTime?: (google.protobuf.ITimestamp|null);

                    /** Span endTime. */
                    public endTime?: (google.protobuf.ITimestamp|null);

                    /** Span duration. */
                    public duration?: (google.protobuf.IDuration|null);

                    /** Span attributes. */
                    public attributes?: (google.protobuf.IStruct|null);

                    /** Span childSpans. */
                    public childSpans: google.cloud.ces.v1beta.ISpan[];

                    /**
                     * Creates a new Span instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Span instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ISpan): google.cloud.ces.v1beta.Span;

                    /**
                     * Encodes the specified Span message. Does not implicitly {@link google.cloud.ces.v1beta.Span.verify|verify} messages.
                     * @param message Span message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ISpan, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Span message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Span.verify|verify} messages.
                     * @param message Span message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ISpan, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Span message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Span
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Span;

                    /**
                     * Decodes a Span message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Span
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Span;

                    /**
                     * Verifies a Span message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Span message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Span
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Span;

                    /**
                     * Creates a plain object from a Span message. Also converts values to other types if specified.
                     * @param message Span
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Span, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Span to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Span
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Represents an AgentService */
                class AgentService extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new AgentService service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new AgentService service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): AgentService;

                    /**
                     * Calls ListApps.
                     * @param request ListAppsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListAppsResponse
                     */
                    public listApps(request: google.cloud.ces.v1beta.IListAppsRequest, callback: google.cloud.ces.v1beta.AgentService.ListAppsCallback): void;

                    /**
                     * Calls ListApps.
                     * @param request ListAppsRequest message or plain object
                     * @returns Promise
                     */
                    public listApps(request: google.cloud.ces.v1beta.IListAppsRequest): Promise<google.cloud.ces.v1beta.ListAppsResponse>;

                    /**
                     * Calls GetApp.
                     * @param request GetAppRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and App
                     */
                    public getApp(request: google.cloud.ces.v1beta.IGetAppRequest, callback: google.cloud.ces.v1beta.AgentService.GetAppCallback): void;

                    /**
                     * Calls GetApp.
                     * @param request GetAppRequest message or plain object
                     * @returns Promise
                     */
                    public getApp(request: google.cloud.ces.v1beta.IGetAppRequest): Promise<google.cloud.ces.v1beta.App>;

                    /**
                     * Calls CreateApp.
                     * @param request CreateAppRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public createApp(request: google.cloud.ces.v1beta.ICreateAppRequest, callback: google.cloud.ces.v1beta.AgentService.CreateAppCallback): void;

                    /**
                     * Calls CreateApp.
                     * @param request CreateAppRequest message or plain object
                     * @returns Promise
                     */
                    public createApp(request: google.cloud.ces.v1beta.ICreateAppRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls UpdateApp.
                     * @param request UpdateAppRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and App
                     */
                    public updateApp(request: google.cloud.ces.v1beta.IUpdateAppRequest, callback: google.cloud.ces.v1beta.AgentService.UpdateAppCallback): void;

                    /**
                     * Calls UpdateApp.
                     * @param request UpdateAppRequest message or plain object
                     * @returns Promise
                     */
                    public updateApp(request: google.cloud.ces.v1beta.IUpdateAppRequest): Promise<google.cloud.ces.v1beta.App>;

                    /**
                     * Calls DeleteApp.
                     * @param request DeleteAppRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public deleteApp(request: google.cloud.ces.v1beta.IDeleteAppRequest, callback: google.cloud.ces.v1beta.AgentService.DeleteAppCallback): void;

                    /**
                     * Calls DeleteApp.
                     * @param request DeleteAppRequest message or plain object
                     * @returns Promise
                     */
                    public deleteApp(request: google.cloud.ces.v1beta.IDeleteAppRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls ExportApp.
                     * @param request ExportAppRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public exportApp(request: google.cloud.ces.v1beta.IExportAppRequest, callback: google.cloud.ces.v1beta.AgentService.ExportAppCallback): void;

                    /**
                     * Calls ExportApp.
                     * @param request ExportAppRequest message or plain object
                     * @returns Promise
                     */
                    public exportApp(request: google.cloud.ces.v1beta.IExportAppRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls ImportApp.
                     * @param request ImportAppRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public importApp(request: google.cloud.ces.v1beta.IImportAppRequest, callback: google.cloud.ces.v1beta.AgentService.ImportAppCallback): void;

                    /**
                     * Calls ImportApp.
                     * @param request ImportAppRequest message or plain object
                     * @returns Promise
                     */
                    public importApp(request: google.cloud.ces.v1beta.IImportAppRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls ListAgents.
                     * @param request ListAgentsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListAgentsResponse
                     */
                    public listAgents(request: google.cloud.ces.v1beta.IListAgentsRequest, callback: google.cloud.ces.v1beta.AgentService.ListAgentsCallback): void;

                    /**
                     * Calls ListAgents.
                     * @param request ListAgentsRequest message or plain object
                     * @returns Promise
                     */
                    public listAgents(request: google.cloud.ces.v1beta.IListAgentsRequest): Promise<google.cloud.ces.v1beta.ListAgentsResponse>;

                    /**
                     * Calls GetAgent.
                     * @param request GetAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Agent
                     */
                    public getAgent(request: google.cloud.ces.v1beta.IGetAgentRequest, callback: google.cloud.ces.v1beta.AgentService.GetAgentCallback): void;

                    /**
                     * Calls GetAgent.
                     * @param request GetAgentRequest message or plain object
                     * @returns Promise
                     */
                    public getAgent(request: google.cloud.ces.v1beta.IGetAgentRequest): Promise<google.cloud.ces.v1beta.Agent>;

                    /**
                     * Calls CreateAgent.
                     * @param request CreateAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Agent
                     */
                    public createAgent(request: google.cloud.ces.v1beta.ICreateAgentRequest, callback: google.cloud.ces.v1beta.AgentService.CreateAgentCallback): void;

                    /**
                     * Calls CreateAgent.
                     * @param request CreateAgentRequest message or plain object
                     * @returns Promise
                     */
                    public createAgent(request: google.cloud.ces.v1beta.ICreateAgentRequest): Promise<google.cloud.ces.v1beta.Agent>;

                    /**
                     * Calls UpdateAgent.
                     * @param request UpdateAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Agent
                     */
                    public updateAgent(request: google.cloud.ces.v1beta.IUpdateAgentRequest, callback: google.cloud.ces.v1beta.AgentService.UpdateAgentCallback): void;

                    /**
                     * Calls UpdateAgent.
                     * @param request UpdateAgentRequest message or plain object
                     * @returns Promise
                     */
                    public updateAgent(request: google.cloud.ces.v1beta.IUpdateAgentRequest): Promise<google.cloud.ces.v1beta.Agent>;

                    /**
                     * Calls DeleteAgent.
                     * @param request DeleteAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteAgent(request: google.cloud.ces.v1beta.IDeleteAgentRequest, callback: google.cloud.ces.v1beta.AgentService.DeleteAgentCallback): void;

                    /**
                     * Calls DeleteAgent.
                     * @param request DeleteAgentRequest message or plain object
                     * @returns Promise
                     */
                    public deleteAgent(request: google.cloud.ces.v1beta.IDeleteAgentRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls ListExamples.
                     * @param request ListExamplesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListExamplesResponse
                     */
                    public listExamples(request: google.cloud.ces.v1beta.IListExamplesRequest, callback: google.cloud.ces.v1beta.AgentService.ListExamplesCallback): void;

                    /**
                     * Calls ListExamples.
                     * @param request ListExamplesRequest message or plain object
                     * @returns Promise
                     */
                    public listExamples(request: google.cloud.ces.v1beta.IListExamplesRequest): Promise<google.cloud.ces.v1beta.ListExamplesResponse>;

                    /**
                     * Calls GetExample.
                     * @param request GetExampleRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Example
                     */
                    public getExample(request: google.cloud.ces.v1beta.IGetExampleRequest, callback: google.cloud.ces.v1beta.AgentService.GetExampleCallback): void;

                    /**
                     * Calls GetExample.
                     * @param request GetExampleRequest message or plain object
                     * @returns Promise
                     */
                    public getExample(request: google.cloud.ces.v1beta.IGetExampleRequest): Promise<google.cloud.ces.v1beta.Example>;

                    /**
                     * Calls CreateExample.
                     * @param request CreateExampleRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Example
                     */
                    public createExample(request: google.cloud.ces.v1beta.ICreateExampleRequest, callback: google.cloud.ces.v1beta.AgentService.CreateExampleCallback): void;

                    /**
                     * Calls CreateExample.
                     * @param request CreateExampleRequest message or plain object
                     * @returns Promise
                     */
                    public createExample(request: google.cloud.ces.v1beta.ICreateExampleRequest): Promise<google.cloud.ces.v1beta.Example>;

                    /**
                     * Calls UpdateExample.
                     * @param request UpdateExampleRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Example
                     */
                    public updateExample(request: google.cloud.ces.v1beta.IUpdateExampleRequest, callback: google.cloud.ces.v1beta.AgentService.UpdateExampleCallback): void;

                    /**
                     * Calls UpdateExample.
                     * @param request UpdateExampleRequest message or plain object
                     * @returns Promise
                     */
                    public updateExample(request: google.cloud.ces.v1beta.IUpdateExampleRequest): Promise<google.cloud.ces.v1beta.Example>;

                    /**
                     * Calls DeleteExample.
                     * @param request DeleteExampleRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteExample(request: google.cloud.ces.v1beta.IDeleteExampleRequest, callback: google.cloud.ces.v1beta.AgentService.DeleteExampleCallback): void;

                    /**
                     * Calls DeleteExample.
                     * @param request DeleteExampleRequest message or plain object
                     * @returns Promise
                     */
                    public deleteExample(request: google.cloud.ces.v1beta.IDeleteExampleRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls ListTools.
                     * @param request ListToolsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListToolsResponse
                     */
                    public listTools(request: google.cloud.ces.v1beta.IListToolsRequest, callback: google.cloud.ces.v1beta.AgentService.ListToolsCallback): void;

                    /**
                     * Calls ListTools.
                     * @param request ListToolsRequest message or plain object
                     * @returns Promise
                     */
                    public listTools(request: google.cloud.ces.v1beta.IListToolsRequest): Promise<google.cloud.ces.v1beta.ListToolsResponse>;

                    /**
                     * Calls GetTool.
                     * @param request GetToolRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Tool
                     */
                    public getTool(request: google.cloud.ces.v1beta.IGetToolRequest, callback: google.cloud.ces.v1beta.AgentService.GetToolCallback): void;

                    /**
                     * Calls GetTool.
                     * @param request GetToolRequest message or plain object
                     * @returns Promise
                     */
                    public getTool(request: google.cloud.ces.v1beta.IGetToolRequest): Promise<google.cloud.ces.v1beta.Tool>;

                    /**
                     * Calls ListConversations.
                     * @param request ListConversationsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListConversationsResponse
                     */
                    public listConversations(request: google.cloud.ces.v1beta.IListConversationsRequest, callback: google.cloud.ces.v1beta.AgentService.ListConversationsCallback): void;

                    /**
                     * Calls ListConversations.
                     * @param request ListConversationsRequest message or plain object
                     * @returns Promise
                     */
                    public listConversations(request: google.cloud.ces.v1beta.IListConversationsRequest): Promise<google.cloud.ces.v1beta.ListConversationsResponse>;

                    /**
                     * Calls GetConversation.
                     * @param request GetConversationRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Conversation
                     */
                    public getConversation(request: google.cloud.ces.v1beta.IGetConversationRequest, callback: google.cloud.ces.v1beta.AgentService.GetConversationCallback): void;

                    /**
                     * Calls GetConversation.
                     * @param request GetConversationRequest message or plain object
                     * @returns Promise
                     */
                    public getConversation(request: google.cloud.ces.v1beta.IGetConversationRequest): Promise<google.cloud.ces.v1beta.Conversation>;

                    /**
                     * Calls DeleteConversation.
                     * @param request DeleteConversationRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteConversation(request: google.cloud.ces.v1beta.IDeleteConversationRequest, callback: google.cloud.ces.v1beta.AgentService.DeleteConversationCallback): void;

                    /**
                     * Calls DeleteConversation.
                     * @param request DeleteConversationRequest message or plain object
                     * @returns Promise
                     */
                    public deleteConversation(request: google.cloud.ces.v1beta.IDeleteConversationRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls BatchDeleteConversations.
                     * @param request BatchDeleteConversationsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public batchDeleteConversations(request: google.cloud.ces.v1beta.IBatchDeleteConversationsRequest, callback: google.cloud.ces.v1beta.AgentService.BatchDeleteConversationsCallback): void;

                    /**
                     * Calls BatchDeleteConversations.
                     * @param request BatchDeleteConversationsRequest message or plain object
                     * @returns Promise
                     */
                    public batchDeleteConversations(request: google.cloud.ces.v1beta.IBatchDeleteConversationsRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls CreateTool.
                     * @param request CreateToolRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Tool
                     */
                    public createTool(request: google.cloud.ces.v1beta.ICreateToolRequest, callback: google.cloud.ces.v1beta.AgentService.CreateToolCallback): void;

                    /**
                     * Calls CreateTool.
                     * @param request CreateToolRequest message or plain object
                     * @returns Promise
                     */
                    public createTool(request: google.cloud.ces.v1beta.ICreateToolRequest): Promise<google.cloud.ces.v1beta.Tool>;

                    /**
                     * Calls UpdateTool.
                     * @param request UpdateToolRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Tool
                     */
                    public updateTool(request: google.cloud.ces.v1beta.IUpdateToolRequest, callback: google.cloud.ces.v1beta.AgentService.UpdateToolCallback): void;

                    /**
                     * Calls UpdateTool.
                     * @param request UpdateToolRequest message or plain object
                     * @returns Promise
                     */
                    public updateTool(request: google.cloud.ces.v1beta.IUpdateToolRequest): Promise<google.cloud.ces.v1beta.Tool>;

                    /**
                     * Calls DeleteTool.
                     * @param request DeleteToolRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteTool(request: google.cloud.ces.v1beta.IDeleteToolRequest, callback: google.cloud.ces.v1beta.AgentService.DeleteToolCallback): void;

                    /**
                     * Calls DeleteTool.
                     * @param request DeleteToolRequest message or plain object
                     * @returns Promise
                     */
                    public deleteTool(request: google.cloud.ces.v1beta.IDeleteToolRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls ListGuardrails.
                     * @param request ListGuardrailsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListGuardrailsResponse
                     */
                    public listGuardrails(request: google.cloud.ces.v1beta.IListGuardrailsRequest, callback: google.cloud.ces.v1beta.AgentService.ListGuardrailsCallback): void;

                    /**
                     * Calls ListGuardrails.
                     * @param request ListGuardrailsRequest message or plain object
                     * @returns Promise
                     */
                    public listGuardrails(request: google.cloud.ces.v1beta.IListGuardrailsRequest): Promise<google.cloud.ces.v1beta.ListGuardrailsResponse>;

                    /**
                     * Calls GetGuardrail.
                     * @param request GetGuardrailRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Guardrail
                     */
                    public getGuardrail(request: google.cloud.ces.v1beta.IGetGuardrailRequest, callback: google.cloud.ces.v1beta.AgentService.GetGuardrailCallback): void;

                    /**
                     * Calls GetGuardrail.
                     * @param request GetGuardrailRequest message or plain object
                     * @returns Promise
                     */
                    public getGuardrail(request: google.cloud.ces.v1beta.IGetGuardrailRequest): Promise<google.cloud.ces.v1beta.Guardrail>;

                    /**
                     * Calls CreateGuardrail.
                     * @param request CreateGuardrailRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Guardrail
                     */
                    public createGuardrail(request: google.cloud.ces.v1beta.ICreateGuardrailRequest, callback: google.cloud.ces.v1beta.AgentService.CreateGuardrailCallback): void;

                    /**
                     * Calls CreateGuardrail.
                     * @param request CreateGuardrailRequest message or plain object
                     * @returns Promise
                     */
                    public createGuardrail(request: google.cloud.ces.v1beta.ICreateGuardrailRequest): Promise<google.cloud.ces.v1beta.Guardrail>;

                    /**
                     * Calls UpdateGuardrail.
                     * @param request UpdateGuardrailRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Guardrail
                     */
                    public updateGuardrail(request: google.cloud.ces.v1beta.IUpdateGuardrailRequest, callback: google.cloud.ces.v1beta.AgentService.UpdateGuardrailCallback): void;

                    /**
                     * Calls UpdateGuardrail.
                     * @param request UpdateGuardrailRequest message or plain object
                     * @returns Promise
                     */
                    public updateGuardrail(request: google.cloud.ces.v1beta.IUpdateGuardrailRequest): Promise<google.cloud.ces.v1beta.Guardrail>;

                    /**
                     * Calls DeleteGuardrail.
                     * @param request DeleteGuardrailRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteGuardrail(request: google.cloud.ces.v1beta.IDeleteGuardrailRequest, callback: google.cloud.ces.v1beta.AgentService.DeleteGuardrailCallback): void;

                    /**
                     * Calls DeleteGuardrail.
                     * @param request DeleteGuardrailRequest message or plain object
                     * @returns Promise
                     */
                    public deleteGuardrail(request: google.cloud.ces.v1beta.IDeleteGuardrailRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls ListDeployments.
                     * @param request ListDeploymentsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListDeploymentsResponse
                     */
                    public listDeployments(request: google.cloud.ces.v1beta.IListDeploymentsRequest, callback: google.cloud.ces.v1beta.AgentService.ListDeploymentsCallback): void;

                    /**
                     * Calls ListDeployments.
                     * @param request ListDeploymentsRequest message or plain object
                     * @returns Promise
                     */
                    public listDeployments(request: google.cloud.ces.v1beta.IListDeploymentsRequest): Promise<google.cloud.ces.v1beta.ListDeploymentsResponse>;

                    /**
                     * Calls GetDeployment.
                     * @param request GetDeploymentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Deployment
                     */
                    public getDeployment(request: google.cloud.ces.v1beta.IGetDeploymentRequest, callback: google.cloud.ces.v1beta.AgentService.GetDeploymentCallback): void;

                    /**
                     * Calls GetDeployment.
                     * @param request GetDeploymentRequest message or plain object
                     * @returns Promise
                     */
                    public getDeployment(request: google.cloud.ces.v1beta.IGetDeploymentRequest): Promise<google.cloud.ces.v1beta.Deployment>;

                    /**
                     * Calls CreateDeployment.
                     * @param request CreateDeploymentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Deployment
                     */
                    public createDeployment(request: google.cloud.ces.v1beta.ICreateDeploymentRequest, callback: google.cloud.ces.v1beta.AgentService.CreateDeploymentCallback): void;

                    /**
                     * Calls CreateDeployment.
                     * @param request CreateDeploymentRequest message or plain object
                     * @returns Promise
                     */
                    public createDeployment(request: google.cloud.ces.v1beta.ICreateDeploymentRequest): Promise<google.cloud.ces.v1beta.Deployment>;

                    /**
                     * Calls UpdateDeployment.
                     * @param request UpdateDeploymentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Deployment
                     */
                    public updateDeployment(request: google.cloud.ces.v1beta.IUpdateDeploymentRequest, callback: google.cloud.ces.v1beta.AgentService.UpdateDeploymentCallback): void;

                    /**
                     * Calls UpdateDeployment.
                     * @param request UpdateDeploymentRequest message or plain object
                     * @returns Promise
                     */
                    public updateDeployment(request: google.cloud.ces.v1beta.IUpdateDeploymentRequest): Promise<google.cloud.ces.v1beta.Deployment>;

                    /**
                     * Calls DeleteDeployment.
                     * @param request DeleteDeploymentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteDeployment(request: google.cloud.ces.v1beta.IDeleteDeploymentRequest, callback: google.cloud.ces.v1beta.AgentService.DeleteDeploymentCallback): void;

                    /**
                     * Calls DeleteDeployment.
                     * @param request DeleteDeploymentRequest message or plain object
                     * @returns Promise
                     */
                    public deleteDeployment(request: google.cloud.ces.v1beta.IDeleteDeploymentRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls ListToolsets.
                     * @param request ListToolsetsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListToolsetsResponse
                     */
                    public listToolsets(request: google.cloud.ces.v1beta.IListToolsetsRequest, callback: google.cloud.ces.v1beta.AgentService.ListToolsetsCallback): void;

                    /**
                     * Calls ListToolsets.
                     * @param request ListToolsetsRequest message or plain object
                     * @returns Promise
                     */
                    public listToolsets(request: google.cloud.ces.v1beta.IListToolsetsRequest): Promise<google.cloud.ces.v1beta.ListToolsetsResponse>;

                    /**
                     * Calls GetToolset.
                     * @param request GetToolsetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Toolset
                     */
                    public getToolset(request: google.cloud.ces.v1beta.IGetToolsetRequest, callback: google.cloud.ces.v1beta.AgentService.GetToolsetCallback): void;

                    /**
                     * Calls GetToolset.
                     * @param request GetToolsetRequest message or plain object
                     * @returns Promise
                     */
                    public getToolset(request: google.cloud.ces.v1beta.IGetToolsetRequest): Promise<google.cloud.ces.v1beta.Toolset>;

                    /**
                     * Calls CreateToolset.
                     * @param request CreateToolsetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Toolset
                     */
                    public createToolset(request: google.cloud.ces.v1beta.ICreateToolsetRequest, callback: google.cloud.ces.v1beta.AgentService.CreateToolsetCallback): void;

                    /**
                     * Calls CreateToolset.
                     * @param request CreateToolsetRequest message or plain object
                     * @returns Promise
                     */
                    public createToolset(request: google.cloud.ces.v1beta.ICreateToolsetRequest): Promise<google.cloud.ces.v1beta.Toolset>;

                    /**
                     * Calls UpdateToolset.
                     * @param request UpdateToolsetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Toolset
                     */
                    public updateToolset(request: google.cloud.ces.v1beta.IUpdateToolsetRequest, callback: google.cloud.ces.v1beta.AgentService.UpdateToolsetCallback): void;

                    /**
                     * Calls UpdateToolset.
                     * @param request UpdateToolsetRequest message or plain object
                     * @returns Promise
                     */
                    public updateToolset(request: google.cloud.ces.v1beta.IUpdateToolsetRequest): Promise<google.cloud.ces.v1beta.Toolset>;

                    /**
                     * Calls DeleteToolset.
                     * @param request DeleteToolsetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteToolset(request: google.cloud.ces.v1beta.IDeleteToolsetRequest, callback: google.cloud.ces.v1beta.AgentService.DeleteToolsetCallback): void;

                    /**
                     * Calls DeleteToolset.
                     * @param request DeleteToolsetRequest message or plain object
                     * @returns Promise
                     */
                    public deleteToolset(request: google.cloud.ces.v1beta.IDeleteToolsetRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls ListAppVersions.
                     * @param request ListAppVersionsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListAppVersionsResponse
                     */
                    public listAppVersions(request: google.cloud.ces.v1beta.IListAppVersionsRequest, callback: google.cloud.ces.v1beta.AgentService.ListAppVersionsCallback): void;

                    /**
                     * Calls ListAppVersions.
                     * @param request ListAppVersionsRequest message or plain object
                     * @returns Promise
                     */
                    public listAppVersions(request: google.cloud.ces.v1beta.IListAppVersionsRequest): Promise<google.cloud.ces.v1beta.ListAppVersionsResponse>;

                    /**
                     * Calls GetAppVersion.
                     * @param request GetAppVersionRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and AppVersion
                     */
                    public getAppVersion(request: google.cloud.ces.v1beta.IGetAppVersionRequest, callback: google.cloud.ces.v1beta.AgentService.GetAppVersionCallback): void;

                    /**
                     * Calls GetAppVersion.
                     * @param request GetAppVersionRequest message or plain object
                     * @returns Promise
                     */
                    public getAppVersion(request: google.cloud.ces.v1beta.IGetAppVersionRequest): Promise<google.cloud.ces.v1beta.AppVersion>;

                    /**
                     * Calls CreateAppVersion.
                     * @param request CreateAppVersionRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and AppVersion
                     */
                    public createAppVersion(request: google.cloud.ces.v1beta.ICreateAppVersionRequest, callback: google.cloud.ces.v1beta.AgentService.CreateAppVersionCallback): void;

                    /**
                     * Calls CreateAppVersion.
                     * @param request CreateAppVersionRequest message or plain object
                     * @returns Promise
                     */
                    public createAppVersion(request: google.cloud.ces.v1beta.ICreateAppVersionRequest): Promise<google.cloud.ces.v1beta.AppVersion>;

                    /**
                     * Calls DeleteAppVersion.
                     * @param request DeleteAppVersionRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteAppVersion(request: google.cloud.ces.v1beta.IDeleteAppVersionRequest, callback: google.cloud.ces.v1beta.AgentService.DeleteAppVersionCallback): void;

                    /**
                     * Calls DeleteAppVersion.
                     * @param request DeleteAppVersionRequest message or plain object
                     * @returns Promise
                     */
                    public deleteAppVersion(request: google.cloud.ces.v1beta.IDeleteAppVersionRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls RestoreAppVersion.
                     * @param request RestoreAppVersionRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public restoreAppVersion(request: google.cloud.ces.v1beta.IRestoreAppVersionRequest, callback: google.cloud.ces.v1beta.AgentService.RestoreAppVersionCallback): void;

                    /**
                     * Calls RestoreAppVersion.
                     * @param request RestoreAppVersionRequest message or plain object
                     * @returns Promise
                     */
                    public restoreAppVersion(request: google.cloud.ces.v1beta.IRestoreAppVersionRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls ListChangelogs.
                     * @param request ListChangelogsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListChangelogsResponse
                     */
                    public listChangelogs(request: google.cloud.ces.v1beta.IListChangelogsRequest, callback: google.cloud.ces.v1beta.AgentService.ListChangelogsCallback): void;

                    /**
                     * Calls ListChangelogs.
                     * @param request ListChangelogsRequest message or plain object
                     * @returns Promise
                     */
                    public listChangelogs(request: google.cloud.ces.v1beta.IListChangelogsRequest): Promise<google.cloud.ces.v1beta.ListChangelogsResponse>;

                    /**
                     * Calls GetChangelog.
                     * @param request GetChangelogRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Changelog
                     */
                    public getChangelog(request: google.cloud.ces.v1beta.IGetChangelogRequest, callback: google.cloud.ces.v1beta.AgentService.GetChangelogCallback): void;

                    /**
                     * Calls GetChangelog.
                     * @param request GetChangelogRequest message or plain object
                     * @returns Promise
                     */
                    public getChangelog(request: google.cloud.ces.v1beta.IGetChangelogRequest): Promise<google.cloud.ces.v1beta.Changelog>;
                }

                namespace AgentService {

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listApps}.
                     * @param error Error, if any
                     * @param [response] ListAppsResponse
                     */
                    type ListAppsCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListAppsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getApp}.
                     * @param error Error, if any
                     * @param [response] App
                     */
                    type GetAppCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.App) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|createApp}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type CreateAppCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|updateApp}.
                     * @param error Error, if any
                     * @param [response] App
                     */
                    type UpdateAppCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.App) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|deleteApp}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type DeleteAppCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|exportApp}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type ExportAppCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|importApp}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type ImportAppCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listAgents}.
                     * @param error Error, if any
                     * @param [response] ListAgentsResponse
                     */
                    type ListAgentsCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListAgentsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getAgent}.
                     * @param error Error, if any
                     * @param [response] Agent
                     */
                    type GetAgentCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Agent) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|createAgent}.
                     * @param error Error, if any
                     * @param [response] Agent
                     */
                    type CreateAgentCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Agent) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|updateAgent}.
                     * @param error Error, if any
                     * @param [response] Agent
                     */
                    type UpdateAgentCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Agent) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|deleteAgent}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteAgentCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listExamples}.
                     * @param error Error, if any
                     * @param [response] ListExamplesResponse
                     */
                    type ListExamplesCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListExamplesResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getExample}.
                     * @param error Error, if any
                     * @param [response] Example
                     */
                    type GetExampleCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Example) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|createExample}.
                     * @param error Error, if any
                     * @param [response] Example
                     */
                    type CreateExampleCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Example) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|updateExample}.
                     * @param error Error, if any
                     * @param [response] Example
                     */
                    type UpdateExampleCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Example) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|deleteExample}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteExampleCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listTools}.
                     * @param error Error, if any
                     * @param [response] ListToolsResponse
                     */
                    type ListToolsCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListToolsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getTool}.
                     * @param error Error, if any
                     * @param [response] Tool
                     */
                    type GetToolCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Tool) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listConversations}.
                     * @param error Error, if any
                     * @param [response] ListConversationsResponse
                     */
                    type ListConversationsCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListConversationsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getConversation}.
                     * @param error Error, if any
                     * @param [response] Conversation
                     */
                    type GetConversationCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Conversation) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|deleteConversation}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteConversationCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|batchDeleteConversations}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type BatchDeleteConversationsCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|createTool}.
                     * @param error Error, if any
                     * @param [response] Tool
                     */
                    type CreateToolCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Tool) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|updateTool}.
                     * @param error Error, if any
                     * @param [response] Tool
                     */
                    type UpdateToolCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Tool) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|deleteTool}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteToolCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listGuardrails}.
                     * @param error Error, if any
                     * @param [response] ListGuardrailsResponse
                     */
                    type ListGuardrailsCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListGuardrailsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getGuardrail}.
                     * @param error Error, if any
                     * @param [response] Guardrail
                     */
                    type GetGuardrailCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Guardrail) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|createGuardrail}.
                     * @param error Error, if any
                     * @param [response] Guardrail
                     */
                    type CreateGuardrailCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Guardrail) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|updateGuardrail}.
                     * @param error Error, if any
                     * @param [response] Guardrail
                     */
                    type UpdateGuardrailCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Guardrail) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|deleteGuardrail}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteGuardrailCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listDeployments}.
                     * @param error Error, if any
                     * @param [response] ListDeploymentsResponse
                     */
                    type ListDeploymentsCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListDeploymentsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getDeployment}.
                     * @param error Error, if any
                     * @param [response] Deployment
                     */
                    type GetDeploymentCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Deployment) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|createDeployment}.
                     * @param error Error, if any
                     * @param [response] Deployment
                     */
                    type CreateDeploymentCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Deployment) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|updateDeployment}.
                     * @param error Error, if any
                     * @param [response] Deployment
                     */
                    type UpdateDeploymentCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Deployment) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|deleteDeployment}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteDeploymentCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listToolsets}.
                     * @param error Error, if any
                     * @param [response] ListToolsetsResponse
                     */
                    type ListToolsetsCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListToolsetsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getToolset}.
                     * @param error Error, if any
                     * @param [response] Toolset
                     */
                    type GetToolsetCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Toolset) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|createToolset}.
                     * @param error Error, if any
                     * @param [response] Toolset
                     */
                    type CreateToolsetCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Toolset) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|updateToolset}.
                     * @param error Error, if any
                     * @param [response] Toolset
                     */
                    type UpdateToolsetCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Toolset) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|deleteToolset}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteToolsetCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listAppVersions}.
                     * @param error Error, if any
                     * @param [response] ListAppVersionsResponse
                     */
                    type ListAppVersionsCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListAppVersionsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getAppVersion}.
                     * @param error Error, if any
                     * @param [response] AppVersion
                     */
                    type GetAppVersionCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.AppVersion) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|createAppVersion}.
                     * @param error Error, if any
                     * @param [response] AppVersion
                     */
                    type CreateAppVersionCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.AppVersion) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|deleteAppVersion}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteAppVersionCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|restoreAppVersion}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type RestoreAppVersionCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|listChangelogs}.
                     * @param error Error, if any
                     * @param [response] ListChangelogsResponse
                     */
                    type ListChangelogsCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.ListChangelogsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.ces.v1beta.AgentService|getChangelog}.
                     * @param error Error, if any
                     * @param [response] Changelog
                     */
                    type GetChangelogCallback = (error: (Error|null), response?: google.cloud.ces.v1beta.Changelog) => void;
                }

                /** Properties of a ListAppsRequest. */
                interface IListAppsRequest {

                    /** ListAppsRequest parent */
                    parent?: (string|null);

                    /** ListAppsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListAppsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListAppsRequest filter */
                    filter?: (string|null);

                    /** ListAppsRequest orderBy */
                    orderBy?: (string|null);
                }

                /** Represents a ListAppsRequest. */
                class ListAppsRequest implements IListAppsRequest {

                    /**
                     * Constructs a new ListAppsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListAppsRequest);

                    /** ListAppsRequest parent. */
                    public parent: string;

                    /** ListAppsRequest pageSize. */
                    public pageSize: number;

                    /** ListAppsRequest pageToken. */
                    public pageToken: string;

                    /** ListAppsRequest filter. */
                    public filter: string;

                    /** ListAppsRequest orderBy. */
                    public orderBy: string;

                    /**
                     * Creates a new ListAppsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListAppsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListAppsRequest): google.cloud.ces.v1beta.ListAppsRequest;

                    /**
                     * Encodes the specified ListAppsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListAppsRequest.verify|verify} messages.
                     * @param message ListAppsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListAppsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListAppsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListAppsRequest.verify|verify} messages.
                     * @param message ListAppsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListAppsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListAppsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListAppsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListAppsRequest;

                    /**
                     * Decodes a ListAppsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListAppsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListAppsRequest;

                    /**
                     * Verifies a ListAppsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListAppsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListAppsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListAppsRequest;

                    /**
                     * Creates a plain object from a ListAppsRequest message. Also converts values to other types if specified.
                     * @param message ListAppsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListAppsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListAppsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListAppsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListAppsResponse. */
                interface IListAppsResponse {

                    /** ListAppsResponse apps */
                    apps?: (google.cloud.ces.v1beta.IApp[]|null);

                    /** ListAppsResponse nextPageToken */
                    nextPageToken?: (string|null);

                    /** ListAppsResponse unreachable */
                    unreachable?: (string[]|null);
                }

                /** Represents a ListAppsResponse. */
                class ListAppsResponse implements IListAppsResponse {

                    /**
                     * Constructs a new ListAppsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListAppsResponse);

                    /** ListAppsResponse apps. */
                    public apps: google.cloud.ces.v1beta.IApp[];

                    /** ListAppsResponse nextPageToken. */
                    public nextPageToken: string;

                    /** ListAppsResponse unreachable. */
                    public unreachable: string[];

                    /**
                     * Creates a new ListAppsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListAppsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListAppsResponse): google.cloud.ces.v1beta.ListAppsResponse;

                    /**
                     * Encodes the specified ListAppsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListAppsResponse.verify|verify} messages.
                     * @param message ListAppsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListAppsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListAppsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListAppsResponse.verify|verify} messages.
                     * @param message ListAppsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListAppsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListAppsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListAppsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListAppsResponse;

                    /**
                     * Decodes a ListAppsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListAppsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListAppsResponse;

                    /**
                     * Verifies a ListAppsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListAppsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListAppsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListAppsResponse;

                    /**
                     * Creates a plain object from a ListAppsResponse message. Also converts values to other types if specified.
                     * @param message ListAppsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListAppsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListAppsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListAppsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetAppRequest. */
                interface IGetAppRequest {

                    /** GetAppRequest name */
                    name?: (string|null);
                }

                /** Represents a GetAppRequest. */
                class GetAppRequest implements IGetAppRequest {

                    /**
                     * Constructs a new GetAppRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetAppRequest);

                    /** GetAppRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetAppRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetAppRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetAppRequest): google.cloud.ces.v1beta.GetAppRequest;

                    /**
                     * Encodes the specified GetAppRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetAppRequest.verify|verify} messages.
                     * @param message GetAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetAppRequest.verify|verify} messages.
                     * @param message GetAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetAppRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetAppRequest;

                    /**
                     * Decodes a GetAppRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetAppRequest;

                    /**
                     * Verifies a GetAppRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetAppRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetAppRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetAppRequest;

                    /**
                     * Creates a plain object from a GetAppRequest message. Also converts values to other types if specified.
                     * @param message GetAppRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetAppRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetAppRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetAppRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateAppRequest. */
                interface ICreateAppRequest {

                    /** CreateAppRequest parent */
                    parent?: (string|null);

                    /** CreateAppRequest appId */
                    appId?: (string|null);

                    /** CreateAppRequest app */
                    app?: (google.cloud.ces.v1beta.IApp|null);
                }

                /** Represents a CreateAppRequest. */
                class CreateAppRequest implements ICreateAppRequest {

                    /**
                     * Constructs a new CreateAppRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICreateAppRequest);

                    /** CreateAppRequest parent. */
                    public parent: string;

                    /** CreateAppRequest appId. */
                    public appId: string;

                    /** CreateAppRequest app. */
                    public app?: (google.cloud.ces.v1beta.IApp|null);

                    /**
                     * Creates a new CreateAppRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateAppRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICreateAppRequest): google.cloud.ces.v1beta.CreateAppRequest;

                    /**
                     * Encodes the specified CreateAppRequest message. Does not implicitly {@link google.cloud.ces.v1beta.CreateAppRequest.verify|verify} messages.
                     * @param message CreateAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICreateAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.CreateAppRequest.verify|verify} messages.
                     * @param message CreateAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICreateAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateAppRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.CreateAppRequest;

                    /**
                     * Decodes a CreateAppRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.CreateAppRequest;

                    /**
                     * Verifies a CreateAppRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateAppRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateAppRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.CreateAppRequest;

                    /**
                     * Creates a plain object from a CreateAppRequest message. Also converts values to other types if specified.
                     * @param message CreateAppRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.CreateAppRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateAppRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateAppRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an UpdateAppRequest. */
                interface IUpdateAppRequest {

                    /** UpdateAppRequest app */
                    app?: (google.cloud.ces.v1beta.IApp|null);

                    /** UpdateAppRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateAppRequest. */
                class UpdateAppRequest implements IUpdateAppRequest {

                    /**
                     * Constructs a new UpdateAppRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IUpdateAppRequest);

                    /** UpdateAppRequest app. */
                    public app?: (google.cloud.ces.v1beta.IApp|null);

                    /** UpdateAppRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateAppRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateAppRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IUpdateAppRequest): google.cloud.ces.v1beta.UpdateAppRequest;

                    /**
                     * Encodes the specified UpdateAppRequest message. Does not implicitly {@link google.cloud.ces.v1beta.UpdateAppRequest.verify|verify} messages.
                     * @param message UpdateAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IUpdateAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.UpdateAppRequest.verify|verify} messages.
                     * @param message UpdateAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IUpdateAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateAppRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.UpdateAppRequest;

                    /**
                     * Decodes an UpdateAppRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.UpdateAppRequest;

                    /**
                     * Verifies an UpdateAppRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateAppRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateAppRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.UpdateAppRequest;

                    /**
                     * Creates a plain object from an UpdateAppRequest message. Also converts values to other types if specified.
                     * @param message UpdateAppRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.UpdateAppRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateAppRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for UpdateAppRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteAppRequest. */
                interface IDeleteAppRequest {

                    /** DeleteAppRequest name */
                    name?: (string|null);

                    /** DeleteAppRequest etag */
                    etag?: (string|null);
                }

                /** Represents a DeleteAppRequest. */
                class DeleteAppRequest implements IDeleteAppRequest {

                    /**
                     * Constructs a new DeleteAppRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDeleteAppRequest);

                    /** DeleteAppRequest name. */
                    public name: string;

                    /** DeleteAppRequest etag. */
                    public etag: string;

                    /**
                     * Creates a new DeleteAppRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteAppRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDeleteAppRequest): google.cloud.ces.v1beta.DeleteAppRequest;

                    /**
                     * Encodes the specified DeleteAppRequest message. Does not implicitly {@link google.cloud.ces.v1beta.DeleteAppRequest.verify|verify} messages.
                     * @param message DeleteAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDeleteAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DeleteAppRequest.verify|verify} messages.
                     * @param message DeleteAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDeleteAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteAppRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DeleteAppRequest;

                    /**
                     * Decodes a DeleteAppRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DeleteAppRequest;

                    /**
                     * Verifies a DeleteAppRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteAppRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteAppRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DeleteAppRequest;

                    /**
                     * Creates a plain object from a DeleteAppRequest message. Also converts values to other types if specified.
                     * @param message DeleteAppRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DeleteAppRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteAppRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteAppRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ExportAppRequest. */
                interface IExportAppRequest {

                    /** ExportAppRequest name */
                    name?: (string|null);

                    /** ExportAppRequest exportFormat */
                    exportFormat?: (google.cloud.ces.v1beta.ExportAppRequest.ExportFormat|keyof typeof google.cloud.ces.v1beta.ExportAppRequest.ExportFormat|null);

                    /** ExportAppRequest gcsUri */
                    gcsUri?: (string|null);
                }

                /** Represents an ExportAppRequest. */
                class ExportAppRequest implements IExportAppRequest {

                    /**
                     * Constructs a new ExportAppRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IExportAppRequest);

                    /** ExportAppRequest name. */
                    public name: string;

                    /** ExportAppRequest exportFormat. */
                    public exportFormat: (google.cloud.ces.v1beta.ExportAppRequest.ExportFormat|keyof typeof google.cloud.ces.v1beta.ExportAppRequest.ExportFormat);

                    /** ExportAppRequest gcsUri. */
                    public gcsUri: string;

                    /**
                     * Creates a new ExportAppRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ExportAppRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IExportAppRequest): google.cloud.ces.v1beta.ExportAppRequest;

                    /**
                     * Encodes the specified ExportAppRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ExportAppRequest.verify|verify} messages.
                     * @param message ExportAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IExportAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ExportAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ExportAppRequest.verify|verify} messages.
                     * @param message ExportAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IExportAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ExportAppRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ExportAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ExportAppRequest;

                    /**
                     * Decodes an ExportAppRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ExportAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ExportAppRequest;

                    /**
                     * Verifies an ExportAppRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ExportAppRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ExportAppRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ExportAppRequest;

                    /**
                     * Creates a plain object from an ExportAppRequest message. Also converts values to other types if specified.
                     * @param message ExportAppRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ExportAppRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ExportAppRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ExportAppRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace ExportAppRequest {

                    /** ExportFormat enum. */
                    enum ExportFormat {
                        EXPORT_FORMAT_UNSPECIFIED = 0,
                        JSON = 1,
                        YAML = 2
                    }
                }

                /** Properties of an ExportAppResponse. */
                interface IExportAppResponse {

                    /** ExportAppResponse appContent */
                    appContent?: (Uint8Array|Buffer|string|null);

                    /** ExportAppResponse appUri */
                    appUri?: (string|null);
                }

                /** Represents an ExportAppResponse. */
                class ExportAppResponse implements IExportAppResponse {

                    /**
                     * Constructs a new ExportAppResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IExportAppResponse);

                    /** ExportAppResponse appContent. */
                    public appContent?: (Uint8Array|Buffer|string|null);

                    /** ExportAppResponse appUri. */
                    public appUri?: (string|null);

                    /** ExportAppResponse app. */
                    public app?: ("appContent"|"appUri");

                    /**
                     * Creates a new ExportAppResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ExportAppResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IExportAppResponse): google.cloud.ces.v1beta.ExportAppResponse;

                    /**
                     * Encodes the specified ExportAppResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ExportAppResponse.verify|verify} messages.
                     * @param message ExportAppResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IExportAppResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ExportAppResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ExportAppResponse.verify|verify} messages.
                     * @param message ExportAppResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IExportAppResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ExportAppResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ExportAppResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ExportAppResponse;

                    /**
                     * Decodes an ExportAppResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ExportAppResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ExportAppResponse;

                    /**
                     * Verifies an ExportAppResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ExportAppResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ExportAppResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ExportAppResponse;

                    /**
                     * Creates a plain object from an ExportAppResponse message. Also converts values to other types if specified.
                     * @param message ExportAppResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ExportAppResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ExportAppResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ExportAppResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImportAppRequest. */
                interface IImportAppRequest {

                    /** ImportAppRequest gcsUri */
                    gcsUri?: (string|null);

                    /** ImportAppRequest appContent */
                    appContent?: (Uint8Array|Buffer|string|null);

                    /** ImportAppRequest parent */
                    parent?: (string|null);

                    /** ImportAppRequest displayName */
                    displayName?: (string|null);

                    /** ImportAppRequest appId */
                    appId?: (string|null);

                    /** ImportAppRequest importOptions */
                    importOptions?: (google.cloud.ces.v1beta.ImportAppRequest.IImportOptions|null);
                }

                /** Represents an ImportAppRequest. */
                class ImportAppRequest implements IImportAppRequest {

                    /**
                     * Constructs a new ImportAppRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IImportAppRequest);

                    /** ImportAppRequest gcsUri. */
                    public gcsUri?: (string|null);

                    /** ImportAppRequest appContent. */
                    public appContent?: (Uint8Array|Buffer|string|null);

                    /** ImportAppRequest parent. */
                    public parent: string;

                    /** ImportAppRequest displayName. */
                    public displayName: string;

                    /** ImportAppRequest appId. */
                    public appId: string;

                    /** ImportAppRequest importOptions. */
                    public importOptions?: (google.cloud.ces.v1beta.ImportAppRequest.IImportOptions|null);

                    /** ImportAppRequest app. */
                    public app?: ("gcsUri"|"appContent");

                    /**
                     * Creates a new ImportAppRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImportAppRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IImportAppRequest): google.cloud.ces.v1beta.ImportAppRequest;

                    /**
                     * Encodes the specified ImportAppRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ImportAppRequest.verify|verify} messages.
                     * @param message ImportAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IImportAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImportAppRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ImportAppRequest.verify|verify} messages.
                     * @param message ImportAppRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IImportAppRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImportAppRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImportAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ImportAppRequest;

                    /**
                     * Decodes an ImportAppRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImportAppRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ImportAppRequest;

                    /**
                     * Verifies an ImportAppRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImportAppRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImportAppRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ImportAppRequest;

                    /**
                     * Creates a plain object from an ImportAppRequest message. Also converts values to other types if specified.
                     * @param message ImportAppRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ImportAppRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImportAppRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImportAppRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace ImportAppRequest {

                    /** Properties of an ImportOptions. */
                    interface IImportOptions {

                        /** ImportOptions conflictResolutionStrategy */
                        conflictResolutionStrategy?: (google.cloud.ces.v1beta.ImportAppRequest.ImportOptions.ConflictResolutionStrategy|keyof typeof google.cloud.ces.v1beta.ImportAppRequest.ImportOptions.ConflictResolutionStrategy|null);
                    }

                    /** Represents an ImportOptions. */
                    class ImportOptions implements IImportOptions {

                        /**
                         * Constructs a new ImportOptions.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.ImportAppRequest.IImportOptions);

                        /** ImportOptions conflictResolutionStrategy. */
                        public conflictResolutionStrategy: (google.cloud.ces.v1beta.ImportAppRequest.ImportOptions.ConflictResolutionStrategy|keyof typeof google.cloud.ces.v1beta.ImportAppRequest.ImportOptions.ConflictResolutionStrategy);

                        /**
                         * Creates a new ImportOptions instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ImportOptions instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.ImportAppRequest.IImportOptions): google.cloud.ces.v1beta.ImportAppRequest.ImportOptions;

                        /**
                         * Encodes the specified ImportOptions message. Does not implicitly {@link google.cloud.ces.v1beta.ImportAppRequest.ImportOptions.verify|verify} messages.
                         * @param message ImportOptions message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.ImportAppRequest.IImportOptions, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ImportOptions message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ImportAppRequest.ImportOptions.verify|verify} messages.
                         * @param message ImportOptions message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.ImportAppRequest.IImportOptions, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an ImportOptions message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ImportOptions
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ImportAppRequest.ImportOptions;

                        /**
                         * Decodes an ImportOptions message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ImportOptions
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ImportAppRequest.ImportOptions;

                        /**
                         * Verifies an ImportOptions message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an ImportOptions message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ImportOptions
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ImportAppRequest.ImportOptions;

                        /**
                         * Creates a plain object from an ImportOptions message. Also converts values to other types if specified.
                         * @param message ImportOptions
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.ImportAppRequest.ImportOptions, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ImportOptions to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for ImportOptions
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace ImportOptions {

                        /** ConflictResolutionStrategy enum. */
                        enum ConflictResolutionStrategy {
                            CONFLICT_RESOLUTION_STRATEGY_UNSPECIFIED = 0,
                            REPLACE = 1,
                            OVERWRITE = 2
                        }
                    }
                }

                /** Properties of an ImportAppResponse. */
                interface IImportAppResponse {

                    /** ImportAppResponse name */
                    name?: (string|null);

                    /** ImportAppResponse warnings */
                    warnings?: (string[]|null);
                }

                /** Represents an ImportAppResponse. */
                class ImportAppResponse implements IImportAppResponse {

                    /**
                     * Constructs a new ImportAppResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IImportAppResponse);

                    /** ImportAppResponse name. */
                    public name: string;

                    /** ImportAppResponse warnings. */
                    public warnings: string[];

                    /**
                     * Creates a new ImportAppResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImportAppResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IImportAppResponse): google.cloud.ces.v1beta.ImportAppResponse;

                    /**
                     * Encodes the specified ImportAppResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ImportAppResponse.verify|verify} messages.
                     * @param message ImportAppResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IImportAppResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImportAppResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ImportAppResponse.verify|verify} messages.
                     * @param message ImportAppResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IImportAppResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImportAppResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImportAppResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ImportAppResponse;

                    /**
                     * Decodes an ImportAppResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImportAppResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ImportAppResponse;

                    /**
                     * Verifies an ImportAppResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImportAppResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImportAppResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ImportAppResponse;

                    /**
                     * Creates a plain object from an ImportAppResponse message. Also converts values to other types if specified.
                     * @param message ImportAppResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ImportAppResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImportAppResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImportAppResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListAgentsRequest. */
                interface IListAgentsRequest {

                    /** ListAgentsRequest parent */
                    parent?: (string|null);

                    /** ListAgentsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListAgentsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListAgentsRequest filter */
                    filter?: (string|null);

                    /** ListAgentsRequest orderBy */
                    orderBy?: (string|null);
                }

                /** Represents a ListAgentsRequest. */
                class ListAgentsRequest implements IListAgentsRequest {

                    /**
                     * Constructs a new ListAgentsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListAgentsRequest);

                    /** ListAgentsRequest parent. */
                    public parent: string;

                    /** ListAgentsRequest pageSize. */
                    public pageSize: number;

                    /** ListAgentsRequest pageToken. */
                    public pageToken: string;

                    /** ListAgentsRequest filter. */
                    public filter: string;

                    /** ListAgentsRequest orderBy. */
                    public orderBy: string;

                    /**
                     * Creates a new ListAgentsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListAgentsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListAgentsRequest): google.cloud.ces.v1beta.ListAgentsRequest;

                    /**
                     * Encodes the specified ListAgentsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListAgentsRequest.verify|verify} messages.
                     * @param message ListAgentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListAgentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListAgentsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListAgentsRequest.verify|verify} messages.
                     * @param message ListAgentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListAgentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListAgentsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListAgentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListAgentsRequest;

                    /**
                     * Decodes a ListAgentsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListAgentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListAgentsRequest;

                    /**
                     * Verifies a ListAgentsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListAgentsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListAgentsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListAgentsRequest;

                    /**
                     * Creates a plain object from a ListAgentsRequest message. Also converts values to other types if specified.
                     * @param message ListAgentsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListAgentsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListAgentsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListAgentsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListAgentsResponse. */
                interface IListAgentsResponse {

                    /** ListAgentsResponse agents */
                    agents?: (google.cloud.ces.v1beta.IAgent[]|null);

                    /** ListAgentsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListAgentsResponse. */
                class ListAgentsResponse implements IListAgentsResponse {

                    /**
                     * Constructs a new ListAgentsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListAgentsResponse);

                    /** ListAgentsResponse agents. */
                    public agents: google.cloud.ces.v1beta.IAgent[];

                    /** ListAgentsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListAgentsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListAgentsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListAgentsResponse): google.cloud.ces.v1beta.ListAgentsResponse;

                    /**
                     * Encodes the specified ListAgentsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListAgentsResponse.verify|verify} messages.
                     * @param message ListAgentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListAgentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListAgentsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListAgentsResponse.verify|verify} messages.
                     * @param message ListAgentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListAgentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListAgentsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListAgentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListAgentsResponse;

                    /**
                     * Decodes a ListAgentsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListAgentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListAgentsResponse;

                    /**
                     * Verifies a ListAgentsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListAgentsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListAgentsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListAgentsResponse;

                    /**
                     * Creates a plain object from a ListAgentsResponse message. Also converts values to other types if specified.
                     * @param message ListAgentsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListAgentsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListAgentsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListAgentsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetAgentRequest. */
                interface IGetAgentRequest {

                    /** GetAgentRequest name */
                    name?: (string|null);
                }

                /** Represents a GetAgentRequest. */
                class GetAgentRequest implements IGetAgentRequest {

                    /**
                     * Constructs a new GetAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetAgentRequest);

                    /** GetAgentRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetAgentRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetAgentRequest): google.cloud.ces.v1beta.GetAgentRequest;

                    /**
                     * Encodes the specified GetAgentRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetAgentRequest.verify|verify} messages.
                     * @param message GetAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetAgentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetAgentRequest.verify|verify} messages.
                     * @param message GetAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetAgentRequest;

                    /**
                     * Decodes a GetAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetAgentRequest;

                    /**
                     * Verifies a GetAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetAgentRequest;

                    /**
                     * Creates a plain object from a GetAgentRequest message. Also converts values to other types if specified.
                     * @param message GetAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetAgentRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateAgentRequest. */
                interface ICreateAgentRequest {

                    /** CreateAgentRequest parent */
                    parent?: (string|null);

                    /** CreateAgentRequest agentId */
                    agentId?: (string|null);

                    /** CreateAgentRequest agent */
                    agent?: (google.cloud.ces.v1beta.IAgent|null);
                }

                /** Represents a CreateAgentRequest. */
                class CreateAgentRequest implements ICreateAgentRequest {

                    /**
                     * Constructs a new CreateAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICreateAgentRequest);

                    /** CreateAgentRequest parent. */
                    public parent: string;

                    /** CreateAgentRequest agentId. */
                    public agentId: string;

                    /** CreateAgentRequest agent. */
                    public agent?: (google.cloud.ces.v1beta.IAgent|null);

                    /**
                     * Creates a new CreateAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateAgentRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICreateAgentRequest): google.cloud.ces.v1beta.CreateAgentRequest;

                    /**
                     * Encodes the specified CreateAgentRequest message. Does not implicitly {@link google.cloud.ces.v1beta.CreateAgentRequest.verify|verify} messages.
                     * @param message CreateAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICreateAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateAgentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.CreateAgentRequest.verify|verify} messages.
                     * @param message CreateAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICreateAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.CreateAgentRequest;

                    /**
                     * Decodes a CreateAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.CreateAgentRequest;

                    /**
                     * Verifies a CreateAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.CreateAgentRequest;

                    /**
                     * Creates a plain object from a CreateAgentRequest message. Also converts values to other types if specified.
                     * @param message CreateAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.CreateAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateAgentRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an UpdateAgentRequest. */
                interface IUpdateAgentRequest {

                    /** UpdateAgentRequest agent */
                    agent?: (google.cloud.ces.v1beta.IAgent|null);

                    /** UpdateAgentRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateAgentRequest. */
                class UpdateAgentRequest implements IUpdateAgentRequest {

                    /**
                     * Constructs a new UpdateAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IUpdateAgentRequest);

                    /** UpdateAgentRequest agent. */
                    public agent?: (google.cloud.ces.v1beta.IAgent|null);

                    /** UpdateAgentRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateAgentRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IUpdateAgentRequest): google.cloud.ces.v1beta.UpdateAgentRequest;

                    /**
                     * Encodes the specified UpdateAgentRequest message. Does not implicitly {@link google.cloud.ces.v1beta.UpdateAgentRequest.verify|verify} messages.
                     * @param message UpdateAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IUpdateAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateAgentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.UpdateAgentRequest.verify|verify} messages.
                     * @param message UpdateAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IUpdateAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.UpdateAgentRequest;

                    /**
                     * Decodes an UpdateAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.UpdateAgentRequest;

                    /**
                     * Verifies an UpdateAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.UpdateAgentRequest;

                    /**
                     * Creates a plain object from an UpdateAgentRequest message. Also converts values to other types if specified.
                     * @param message UpdateAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.UpdateAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for UpdateAgentRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteAgentRequest. */
                interface IDeleteAgentRequest {

                    /** DeleteAgentRequest name */
                    name?: (string|null);

                    /** DeleteAgentRequest force */
                    force?: (boolean|null);

                    /** DeleteAgentRequest etag */
                    etag?: (string|null);
                }

                /** Represents a DeleteAgentRequest. */
                class DeleteAgentRequest implements IDeleteAgentRequest {

                    /**
                     * Constructs a new DeleteAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDeleteAgentRequest);

                    /** DeleteAgentRequest name. */
                    public name: string;

                    /** DeleteAgentRequest force. */
                    public force: boolean;

                    /** DeleteAgentRequest etag. */
                    public etag: string;

                    /**
                     * Creates a new DeleteAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteAgentRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDeleteAgentRequest): google.cloud.ces.v1beta.DeleteAgentRequest;

                    /**
                     * Encodes the specified DeleteAgentRequest message. Does not implicitly {@link google.cloud.ces.v1beta.DeleteAgentRequest.verify|verify} messages.
                     * @param message DeleteAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDeleteAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteAgentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DeleteAgentRequest.verify|verify} messages.
                     * @param message DeleteAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDeleteAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DeleteAgentRequest;

                    /**
                     * Decodes a DeleteAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DeleteAgentRequest;

                    /**
                     * Verifies a DeleteAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DeleteAgentRequest;

                    /**
                     * Creates a plain object from a DeleteAgentRequest message. Also converts values to other types if specified.
                     * @param message DeleteAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DeleteAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteAgentRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an OperationMetadata. */
                interface IOperationMetadata {

                    /** OperationMetadata createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** OperationMetadata endTime */
                    endTime?: (google.protobuf.ITimestamp|null);

                    /** OperationMetadata statusMessage */
                    statusMessage?: (string|null);

                    /** OperationMetadata requestedCancellation */
                    requestedCancellation?: (boolean|null);
                }

                /** Represents an OperationMetadata. */
                class OperationMetadata implements IOperationMetadata {

                    /**
                     * Constructs a new OperationMetadata.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IOperationMetadata);

                    /** OperationMetadata createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** OperationMetadata endTime. */
                    public endTime?: (google.protobuf.ITimestamp|null);

                    /** OperationMetadata statusMessage. */
                    public statusMessage: string;

                    /** OperationMetadata requestedCancellation. */
                    public requestedCancellation: boolean;

                    /**
                     * Creates a new OperationMetadata instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns OperationMetadata instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IOperationMetadata): google.cloud.ces.v1beta.OperationMetadata;

                    /**
                     * Encodes the specified OperationMetadata message. Does not implicitly {@link google.cloud.ces.v1beta.OperationMetadata.verify|verify} messages.
                     * @param message OperationMetadata message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IOperationMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified OperationMetadata message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.OperationMetadata.verify|verify} messages.
                     * @param message OperationMetadata message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IOperationMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an OperationMetadata message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns OperationMetadata
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.OperationMetadata;

                    /**
                     * Decodes an OperationMetadata message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns OperationMetadata
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.OperationMetadata;

                    /**
                     * Verifies an OperationMetadata message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an OperationMetadata message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns OperationMetadata
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.OperationMetadata;

                    /**
                     * Creates a plain object from an OperationMetadata message. Also converts values to other types if specified.
                     * @param message OperationMetadata
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.OperationMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this OperationMetadata to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for OperationMetadata
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListExamplesRequest. */
                interface IListExamplesRequest {

                    /** ListExamplesRequest parent */
                    parent?: (string|null);

                    /** ListExamplesRequest pageSize */
                    pageSize?: (number|null);

                    /** ListExamplesRequest pageToken */
                    pageToken?: (string|null);

                    /** ListExamplesRequest filter */
                    filter?: (string|null);

                    /** ListExamplesRequest orderBy */
                    orderBy?: (string|null);
                }

                /** Represents a ListExamplesRequest. */
                class ListExamplesRequest implements IListExamplesRequest {

                    /**
                     * Constructs a new ListExamplesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListExamplesRequest);

                    /** ListExamplesRequest parent. */
                    public parent: string;

                    /** ListExamplesRequest pageSize. */
                    public pageSize: number;

                    /** ListExamplesRequest pageToken. */
                    public pageToken: string;

                    /** ListExamplesRequest filter. */
                    public filter: string;

                    /** ListExamplesRequest orderBy. */
                    public orderBy: string;

                    /**
                     * Creates a new ListExamplesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListExamplesRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListExamplesRequest): google.cloud.ces.v1beta.ListExamplesRequest;

                    /**
                     * Encodes the specified ListExamplesRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListExamplesRequest.verify|verify} messages.
                     * @param message ListExamplesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListExamplesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListExamplesRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListExamplesRequest.verify|verify} messages.
                     * @param message ListExamplesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListExamplesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListExamplesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListExamplesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListExamplesRequest;

                    /**
                     * Decodes a ListExamplesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListExamplesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListExamplesRequest;

                    /**
                     * Verifies a ListExamplesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListExamplesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListExamplesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListExamplesRequest;

                    /**
                     * Creates a plain object from a ListExamplesRequest message. Also converts values to other types if specified.
                     * @param message ListExamplesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListExamplesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListExamplesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListExamplesRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListExamplesResponse. */
                interface IListExamplesResponse {

                    /** ListExamplesResponse examples */
                    examples?: (google.cloud.ces.v1beta.IExample[]|null);

                    /** ListExamplesResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListExamplesResponse. */
                class ListExamplesResponse implements IListExamplesResponse {

                    /**
                     * Constructs a new ListExamplesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListExamplesResponse);

                    /** ListExamplesResponse examples. */
                    public examples: google.cloud.ces.v1beta.IExample[];

                    /** ListExamplesResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListExamplesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListExamplesResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListExamplesResponse): google.cloud.ces.v1beta.ListExamplesResponse;

                    /**
                     * Encodes the specified ListExamplesResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListExamplesResponse.verify|verify} messages.
                     * @param message ListExamplesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListExamplesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListExamplesResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListExamplesResponse.verify|verify} messages.
                     * @param message ListExamplesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListExamplesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListExamplesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListExamplesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListExamplesResponse;

                    /**
                     * Decodes a ListExamplesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListExamplesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListExamplesResponse;

                    /**
                     * Verifies a ListExamplesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListExamplesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListExamplesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListExamplesResponse;

                    /**
                     * Creates a plain object from a ListExamplesResponse message. Also converts values to other types if specified.
                     * @param message ListExamplesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListExamplesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListExamplesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListExamplesResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetExampleRequest. */
                interface IGetExampleRequest {

                    /** GetExampleRequest name */
                    name?: (string|null);
                }

                /** Represents a GetExampleRequest. */
                class GetExampleRequest implements IGetExampleRequest {

                    /**
                     * Constructs a new GetExampleRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetExampleRequest);

                    /** GetExampleRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetExampleRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetExampleRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetExampleRequest): google.cloud.ces.v1beta.GetExampleRequest;

                    /**
                     * Encodes the specified GetExampleRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetExampleRequest.verify|verify} messages.
                     * @param message GetExampleRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetExampleRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetExampleRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetExampleRequest.verify|verify} messages.
                     * @param message GetExampleRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetExampleRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetExampleRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetExampleRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetExampleRequest;

                    /**
                     * Decodes a GetExampleRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetExampleRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetExampleRequest;

                    /**
                     * Verifies a GetExampleRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetExampleRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetExampleRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetExampleRequest;

                    /**
                     * Creates a plain object from a GetExampleRequest message. Also converts values to other types if specified.
                     * @param message GetExampleRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetExampleRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetExampleRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetExampleRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateExampleRequest. */
                interface ICreateExampleRequest {

                    /** CreateExampleRequest parent */
                    parent?: (string|null);

                    /** CreateExampleRequest exampleId */
                    exampleId?: (string|null);

                    /** CreateExampleRequest example */
                    example?: (google.cloud.ces.v1beta.IExample|null);
                }

                /** Represents a CreateExampleRequest. */
                class CreateExampleRequest implements ICreateExampleRequest {

                    /**
                     * Constructs a new CreateExampleRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICreateExampleRequest);

                    /** CreateExampleRequest parent. */
                    public parent: string;

                    /** CreateExampleRequest exampleId. */
                    public exampleId: string;

                    /** CreateExampleRequest example. */
                    public example?: (google.cloud.ces.v1beta.IExample|null);

                    /**
                     * Creates a new CreateExampleRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateExampleRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICreateExampleRequest): google.cloud.ces.v1beta.CreateExampleRequest;

                    /**
                     * Encodes the specified CreateExampleRequest message. Does not implicitly {@link google.cloud.ces.v1beta.CreateExampleRequest.verify|verify} messages.
                     * @param message CreateExampleRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICreateExampleRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateExampleRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.CreateExampleRequest.verify|verify} messages.
                     * @param message CreateExampleRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICreateExampleRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateExampleRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateExampleRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.CreateExampleRequest;

                    /**
                     * Decodes a CreateExampleRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateExampleRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.CreateExampleRequest;

                    /**
                     * Verifies a CreateExampleRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateExampleRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateExampleRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.CreateExampleRequest;

                    /**
                     * Creates a plain object from a CreateExampleRequest message. Also converts values to other types if specified.
                     * @param message CreateExampleRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.CreateExampleRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateExampleRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateExampleRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an UpdateExampleRequest. */
                interface IUpdateExampleRequest {

                    /** UpdateExampleRequest example */
                    example?: (google.cloud.ces.v1beta.IExample|null);

                    /** UpdateExampleRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateExampleRequest. */
                class UpdateExampleRequest implements IUpdateExampleRequest {

                    /**
                     * Constructs a new UpdateExampleRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IUpdateExampleRequest);

                    /** UpdateExampleRequest example. */
                    public example?: (google.cloud.ces.v1beta.IExample|null);

                    /** UpdateExampleRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateExampleRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateExampleRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IUpdateExampleRequest): google.cloud.ces.v1beta.UpdateExampleRequest;

                    /**
                     * Encodes the specified UpdateExampleRequest message. Does not implicitly {@link google.cloud.ces.v1beta.UpdateExampleRequest.verify|verify} messages.
                     * @param message UpdateExampleRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IUpdateExampleRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateExampleRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.UpdateExampleRequest.verify|verify} messages.
                     * @param message UpdateExampleRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IUpdateExampleRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateExampleRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateExampleRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.UpdateExampleRequest;

                    /**
                     * Decodes an UpdateExampleRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateExampleRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.UpdateExampleRequest;

                    /**
                     * Verifies an UpdateExampleRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateExampleRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateExampleRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.UpdateExampleRequest;

                    /**
                     * Creates a plain object from an UpdateExampleRequest message. Also converts values to other types if specified.
                     * @param message UpdateExampleRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.UpdateExampleRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateExampleRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for UpdateExampleRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteExampleRequest. */
                interface IDeleteExampleRequest {

                    /** DeleteExampleRequest name */
                    name?: (string|null);

                    /** DeleteExampleRequest etag */
                    etag?: (string|null);
                }

                /** Represents a DeleteExampleRequest. */
                class DeleteExampleRequest implements IDeleteExampleRequest {

                    /**
                     * Constructs a new DeleteExampleRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDeleteExampleRequest);

                    /** DeleteExampleRequest name. */
                    public name: string;

                    /** DeleteExampleRequest etag. */
                    public etag: string;

                    /**
                     * Creates a new DeleteExampleRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteExampleRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDeleteExampleRequest): google.cloud.ces.v1beta.DeleteExampleRequest;

                    /**
                     * Encodes the specified DeleteExampleRequest message. Does not implicitly {@link google.cloud.ces.v1beta.DeleteExampleRequest.verify|verify} messages.
                     * @param message DeleteExampleRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDeleteExampleRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteExampleRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DeleteExampleRequest.verify|verify} messages.
                     * @param message DeleteExampleRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDeleteExampleRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteExampleRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteExampleRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DeleteExampleRequest;

                    /**
                     * Decodes a DeleteExampleRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteExampleRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DeleteExampleRequest;

                    /**
                     * Verifies a DeleteExampleRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteExampleRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteExampleRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DeleteExampleRequest;

                    /**
                     * Creates a plain object from a DeleteExampleRequest message. Also converts values to other types if specified.
                     * @param message DeleteExampleRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DeleteExampleRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteExampleRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteExampleRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListToolsRequest. */
                interface IListToolsRequest {

                    /** ListToolsRequest parent */
                    parent?: (string|null);

                    /** ListToolsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListToolsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListToolsRequest filter */
                    filter?: (string|null);

                    /** ListToolsRequest orderBy */
                    orderBy?: (string|null);
                }

                /** Represents a ListToolsRequest. */
                class ListToolsRequest implements IListToolsRequest {

                    /**
                     * Constructs a new ListToolsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListToolsRequest);

                    /** ListToolsRequest parent. */
                    public parent: string;

                    /** ListToolsRequest pageSize. */
                    public pageSize: number;

                    /** ListToolsRequest pageToken. */
                    public pageToken: string;

                    /** ListToolsRequest filter. */
                    public filter: string;

                    /** ListToolsRequest orderBy. */
                    public orderBy: string;

                    /**
                     * Creates a new ListToolsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListToolsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListToolsRequest): google.cloud.ces.v1beta.ListToolsRequest;

                    /**
                     * Encodes the specified ListToolsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListToolsRequest.verify|verify} messages.
                     * @param message ListToolsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListToolsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListToolsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListToolsRequest.verify|verify} messages.
                     * @param message ListToolsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListToolsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListToolsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListToolsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListToolsRequest;

                    /**
                     * Decodes a ListToolsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListToolsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListToolsRequest;

                    /**
                     * Verifies a ListToolsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListToolsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListToolsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListToolsRequest;

                    /**
                     * Creates a plain object from a ListToolsRequest message. Also converts values to other types if specified.
                     * @param message ListToolsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListToolsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListToolsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListToolsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListToolsResponse. */
                interface IListToolsResponse {

                    /** ListToolsResponse tools */
                    tools?: (google.cloud.ces.v1beta.ITool[]|null);

                    /** ListToolsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListToolsResponse. */
                class ListToolsResponse implements IListToolsResponse {

                    /**
                     * Constructs a new ListToolsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListToolsResponse);

                    /** ListToolsResponse tools. */
                    public tools: google.cloud.ces.v1beta.ITool[];

                    /** ListToolsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListToolsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListToolsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListToolsResponse): google.cloud.ces.v1beta.ListToolsResponse;

                    /**
                     * Encodes the specified ListToolsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListToolsResponse.verify|verify} messages.
                     * @param message ListToolsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListToolsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListToolsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListToolsResponse.verify|verify} messages.
                     * @param message ListToolsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListToolsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListToolsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListToolsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListToolsResponse;

                    /**
                     * Decodes a ListToolsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListToolsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListToolsResponse;

                    /**
                     * Verifies a ListToolsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListToolsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListToolsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListToolsResponse;

                    /**
                     * Creates a plain object from a ListToolsResponse message. Also converts values to other types if specified.
                     * @param message ListToolsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListToolsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListToolsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListToolsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetToolRequest. */
                interface IGetToolRequest {

                    /** GetToolRequest name */
                    name?: (string|null);
                }

                /** Represents a GetToolRequest. */
                class GetToolRequest implements IGetToolRequest {

                    /**
                     * Constructs a new GetToolRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetToolRequest);

                    /** GetToolRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetToolRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetToolRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetToolRequest): google.cloud.ces.v1beta.GetToolRequest;

                    /**
                     * Encodes the specified GetToolRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetToolRequest.verify|verify} messages.
                     * @param message GetToolRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetToolRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetToolRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetToolRequest.verify|verify} messages.
                     * @param message GetToolRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetToolRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetToolRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetToolRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetToolRequest;

                    /**
                     * Decodes a GetToolRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetToolRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetToolRequest;

                    /**
                     * Verifies a GetToolRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetToolRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetToolRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetToolRequest;

                    /**
                     * Creates a plain object from a GetToolRequest message. Also converts values to other types if specified.
                     * @param message GetToolRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetToolRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetToolRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetToolRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateToolRequest. */
                interface ICreateToolRequest {

                    /** CreateToolRequest parent */
                    parent?: (string|null);

                    /** CreateToolRequest toolId */
                    toolId?: (string|null);

                    /** CreateToolRequest tool */
                    tool?: (google.cloud.ces.v1beta.ITool|null);
                }

                /** Represents a CreateToolRequest. */
                class CreateToolRequest implements ICreateToolRequest {

                    /**
                     * Constructs a new CreateToolRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICreateToolRequest);

                    /** CreateToolRequest parent. */
                    public parent: string;

                    /** CreateToolRequest toolId. */
                    public toolId: string;

                    /** CreateToolRequest tool. */
                    public tool?: (google.cloud.ces.v1beta.ITool|null);

                    /**
                     * Creates a new CreateToolRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateToolRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICreateToolRequest): google.cloud.ces.v1beta.CreateToolRequest;

                    /**
                     * Encodes the specified CreateToolRequest message. Does not implicitly {@link google.cloud.ces.v1beta.CreateToolRequest.verify|verify} messages.
                     * @param message CreateToolRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICreateToolRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateToolRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.CreateToolRequest.verify|verify} messages.
                     * @param message CreateToolRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICreateToolRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateToolRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateToolRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.CreateToolRequest;

                    /**
                     * Decodes a CreateToolRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateToolRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.CreateToolRequest;

                    /**
                     * Verifies a CreateToolRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateToolRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateToolRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.CreateToolRequest;

                    /**
                     * Creates a plain object from a CreateToolRequest message. Also converts values to other types if specified.
                     * @param message CreateToolRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.CreateToolRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateToolRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateToolRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an UpdateToolRequest. */
                interface IUpdateToolRequest {

                    /** UpdateToolRequest tool */
                    tool?: (google.cloud.ces.v1beta.ITool|null);

                    /** UpdateToolRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateToolRequest. */
                class UpdateToolRequest implements IUpdateToolRequest {

                    /**
                     * Constructs a new UpdateToolRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IUpdateToolRequest);

                    /** UpdateToolRequest tool. */
                    public tool?: (google.cloud.ces.v1beta.ITool|null);

                    /** UpdateToolRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateToolRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateToolRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IUpdateToolRequest): google.cloud.ces.v1beta.UpdateToolRequest;

                    /**
                     * Encodes the specified UpdateToolRequest message. Does not implicitly {@link google.cloud.ces.v1beta.UpdateToolRequest.verify|verify} messages.
                     * @param message UpdateToolRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IUpdateToolRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateToolRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.UpdateToolRequest.verify|verify} messages.
                     * @param message UpdateToolRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IUpdateToolRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateToolRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateToolRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.UpdateToolRequest;

                    /**
                     * Decodes an UpdateToolRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateToolRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.UpdateToolRequest;

                    /**
                     * Verifies an UpdateToolRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateToolRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateToolRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.UpdateToolRequest;

                    /**
                     * Creates a plain object from an UpdateToolRequest message. Also converts values to other types if specified.
                     * @param message UpdateToolRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.UpdateToolRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateToolRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for UpdateToolRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteToolRequest. */
                interface IDeleteToolRequest {

                    /** DeleteToolRequest name */
                    name?: (string|null);

                    /** DeleteToolRequest force */
                    force?: (boolean|null);

                    /** DeleteToolRequest etag */
                    etag?: (string|null);
                }

                /** Represents a DeleteToolRequest. */
                class DeleteToolRequest implements IDeleteToolRequest {

                    /**
                     * Constructs a new DeleteToolRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDeleteToolRequest);

                    /** DeleteToolRequest name. */
                    public name: string;

                    /** DeleteToolRequest force. */
                    public force: boolean;

                    /** DeleteToolRequest etag. */
                    public etag: string;

                    /**
                     * Creates a new DeleteToolRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteToolRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDeleteToolRequest): google.cloud.ces.v1beta.DeleteToolRequest;

                    /**
                     * Encodes the specified DeleteToolRequest message. Does not implicitly {@link google.cloud.ces.v1beta.DeleteToolRequest.verify|verify} messages.
                     * @param message DeleteToolRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDeleteToolRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteToolRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DeleteToolRequest.verify|verify} messages.
                     * @param message DeleteToolRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDeleteToolRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteToolRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteToolRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DeleteToolRequest;

                    /**
                     * Decodes a DeleteToolRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteToolRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DeleteToolRequest;

                    /**
                     * Verifies a DeleteToolRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteToolRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteToolRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DeleteToolRequest;

                    /**
                     * Creates a plain object from a DeleteToolRequest message. Also converts values to other types if specified.
                     * @param message DeleteToolRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DeleteToolRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteToolRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteToolRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListConversationsRequest. */
                interface IListConversationsRequest {

                    /** ListConversationsRequest parent */
                    parent?: (string|null);

                    /** ListConversationsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListConversationsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListConversationsRequest filter */
                    filter?: (string|null);

                    /** ListConversationsRequest source */
                    source?: (google.cloud.ces.v1beta.Conversation.Source|keyof typeof google.cloud.ces.v1beta.Conversation.Source|null);
                }

                /** Represents a ListConversationsRequest. */
                class ListConversationsRequest implements IListConversationsRequest {

                    /**
                     * Constructs a new ListConversationsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListConversationsRequest);

                    /** ListConversationsRequest parent. */
                    public parent: string;

                    /** ListConversationsRequest pageSize. */
                    public pageSize: number;

                    /** ListConversationsRequest pageToken. */
                    public pageToken: string;

                    /** ListConversationsRequest filter. */
                    public filter: string;

                    /** ListConversationsRequest source. */
                    public source: (google.cloud.ces.v1beta.Conversation.Source|keyof typeof google.cloud.ces.v1beta.Conversation.Source);

                    /**
                     * Creates a new ListConversationsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListConversationsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListConversationsRequest): google.cloud.ces.v1beta.ListConversationsRequest;

                    /**
                     * Encodes the specified ListConversationsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListConversationsRequest.verify|verify} messages.
                     * @param message ListConversationsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListConversationsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListConversationsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListConversationsRequest.verify|verify} messages.
                     * @param message ListConversationsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListConversationsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListConversationsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListConversationsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListConversationsRequest;

                    /**
                     * Decodes a ListConversationsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListConversationsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListConversationsRequest;

                    /**
                     * Verifies a ListConversationsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListConversationsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListConversationsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListConversationsRequest;

                    /**
                     * Creates a plain object from a ListConversationsRequest message. Also converts values to other types if specified.
                     * @param message ListConversationsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListConversationsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListConversationsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListConversationsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListConversationsResponse. */
                interface IListConversationsResponse {

                    /** ListConversationsResponse conversations */
                    conversations?: (google.cloud.ces.v1beta.IConversation[]|null);

                    /** ListConversationsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListConversationsResponse. */
                class ListConversationsResponse implements IListConversationsResponse {

                    /**
                     * Constructs a new ListConversationsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListConversationsResponse);

                    /** ListConversationsResponse conversations. */
                    public conversations: google.cloud.ces.v1beta.IConversation[];

                    /** ListConversationsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListConversationsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListConversationsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListConversationsResponse): google.cloud.ces.v1beta.ListConversationsResponse;

                    /**
                     * Encodes the specified ListConversationsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListConversationsResponse.verify|verify} messages.
                     * @param message ListConversationsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListConversationsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListConversationsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListConversationsResponse.verify|verify} messages.
                     * @param message ListConversationsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListConversationsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListConversationsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListConversationsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListConversationsResponse;

                    /**
                     * Decodes a ListConversationsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListConversationsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListConversationsResponse;

                    /**
                     * Verifies a ListConversationsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListConversationsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListConversationsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListConversationsResponse;

                    /**
                     * Creates a plain object from a ListConversationsResponse message. Also converts values to other types if specified.
                     * @param message ListConversationsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListConversationsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListConversationsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListConversationsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetConversationRequest. */
                interface IGetConversationRequest {

                    /** GetConversationRequest name */
                    name?: (string|null);

                    /** GetConversationRequest source */
                    source?: (google.cloud.ces.v1beta.Conversation.Source|keyof typeof google.cloud.ces.v1beta.Conversation.Source|null);
                }

                /** Represents a GetConversationRequest. */
                class GetConversationRequest implements IGetConversationRequest {

                    /**
                     * Constructs a new GetConversationRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetConversationRequest);

                    /** GetConversationRequest name. */
                    public name: string;

                    /** GetConversationRequest source. */
                    public source: (google.cloud.ces.v1beta.Conversation.Source|keyof typeof google.cloud.ces.v1beta.Conversation.Source);

                    /**
                     * Creates a new GetConversationRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetConversationRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetConversationRequest): google.cloud.ces.v1beta.GetConversationRequest;

                    /**
                     * Encodes the specified GetConversationRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetConversationRequest.verify|verify} messages.
                     * @param message GetConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetConversationRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetConversationRequest.verify|verify} messages.
                     * @param message GetConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetConversationRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetConversationRequest;

                    /**
                     * Decodes a GetConversationRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetConversationRequest;

                    /**
                     * Verifies a GetConversationRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetConversationRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetConversationRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetConversationRequest;

                    /**
                     * Creates a plain object from a GetConversationRequest message. Also converts values to other types if specified.
                     * @param message GetConversationRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetConversationRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetConversationRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetConversationRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteConversationRequest. */
                interface IDeleteConversationRequest {

                    /** DeleteConversationRequest name */
                    name?: (string|null);

                    /** DeleteConversationRequest source */
                    source?: (google.cloud.ces.v1beta.Conversation.Source|keyof typeof google.cloud.ces.v1beta.Conversation.Source|null);
                }

                /** Represents a DeleteConversationRequest. */
                class DeleteConversationRequest implements IDeleteConversationRequest {

                    /**
                     * Constructs a new DeleteConversationRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDeleteConversationRequest);

                    /** DeleteConversationRequest name. */
                    public name: string;

                    /** DeleteConversationRequest source. */
                    public source: (google.cloud.ces.v1beta.Conversation.Source|keyof typeof google.cloud.ces.v1beta.Conversation.Source);

                    /**
                     * Creates a new DeleteConversationRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteConversationRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDeleteConversationRequest): google.cloud.ces.v1beta.DeleteConversationRequest;

                    /**
                     * Encodes the specified DeleteConversationRequest message. Does not implicitly {@link google.cloud.ces.v1beta.DeleteConversationRequest.verify|verify} messages.
                     * @param message DeleteConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDeleteConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteConversationRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DeleteConversationRequest.verify|verify} messages.
                     * @param message DeleteConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDeleteConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteConversationRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DeleteConversationRequest;

                    /**
                     * Decodes a DeleteConversationRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DeleteConversationRequest;

                    /**
                     * Verifies a DeleteConversationRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteConversationRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteConversationRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DeleteConversationRequest;

                    /**
                     * Creates a plain object from a DeleteConversationRequest message. Also converts values to other types if specified.
                     * @param message DeleteConversationRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DeleteConversationRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteConversationRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteConversationRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BatchDeleteConversationsRequest. */
                interface IBatchDeleteConversationsRequest {

                    /** BatchDeleteConversationsRequest parent */
                    parent?: (string|null);

                    /** BatchDeleteConversationsRequest conversations */
                    conversations?: (string[]|null);
                }

                /** Represents a BatchDeleteConversationsRequest. */
                class BatchDeleteConversationsRequest implements IBatchDeleteConversationsRequest {

                    /**
                     * Constructs a new BatchDeleteConversationsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IBatchDeleteConversationsRequest);

                    /** BatchDeleteConversationsRequest parent. */
                    public parent: string;

                    /** BatchDeleteConversationsRequest conversations. */
                    public conversations: string[];

                    /**
                     * Creates a new BatchDeleteConversationsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchDeleteConversationsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IBatchDeleteConversationsRequest): google.cloud.ces.v1beta.BatchDeleteConversationsRequest;

                    /**
                     * Encodes the specified BatchDeleteConversationsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.BatchDeleteConversationsRequest.verify|verify} messages.
                     * @param message BatchDeleteConversationsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IBatchDeleteConversationsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchDeleteConversationsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.BatchDeleteConversationsRequest.verify|verify} messages.
                     * @param message BatchDeleteConversationsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IBatchDeleteConversationsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchDeleteConversationsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchDeleteConversationsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.BatchDeleteConversationsRequest;

                    /**
                     * Decodes a BatchDeleteConversationsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchDeleteConversationsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.BatchDeleteConversationsRequest;

                    /**
                     * Verifies a BatchDeleteConversationsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchDeleteConversationsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchDeleteConversationsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.BatchDeleteConversationsRequest;

                    /**
                     * Creates a plain object from a BatchDeleteConversationsRequest message. Also converts values to other types if specified.
                     * @param message BatchDeleteConversationsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.BatchDeleteConversationsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchDeleteConversationsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BatchDeleteConversationsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BatchDeleteConversationsResponse. */
                interface IBatchDeleteConversationsResponse {

                    /** BatchDeleteConversationsResponse deletedConversations */
                    deletedConversations?: (string[]|null);

                    /** BatchDeleteConversationsResponse failedConversations */
                    failedConversations?: (string[]|null);

                    /** BatchDeleteConversationsResponse errorMessages */
                    errorMessages?: (string[]|null);
                }

                /** Represents a BatchDeleteConversationsResponse. */
                class BatchDeleteConversationsResponse implements IBatchDeleteConversationsResponse {

                    /**
                     * Constructs a new BatchDeleteConversationsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IBatchDeleteConversationsResponse);

                    /** BatchDeleteConversationsResponse deletedConversations. */
                    public deletedConversations: string[];

                    /** BatchDeleteConversationsResponse failedConversations. */
                    public failedConversations: string[];

                    /** BatchDeleteConversationsResponse errorMessages. */
                    public errorMessages: string[];

                    /**
                     * Creates a new BatchDeleteConversationsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchDeleteConversationsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IBatchDeleteConversationsResponse): google.cloud.ces.v1beta.BatchDeleteConversationsResponse;

                    /**
                     * Encodes the specified BatchDeleteConversationsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.BatchDeleteConversationsResponse.verify|verify} messages.
                     * @param message BatchDeleteConversationsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchDeleteConversationsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.BatchDeleteConversationsResponse.verify|verify} messages.
                     * @param message BatchDeleteConversationsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchDeleteConversationsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchDeleteConversationsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.BatchDeleteConversationsResponse;

                    /**
                     * Decodes a BatchDeleteConversationsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchDeleteConversationsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.BatchDeleteConversationsResponse;

                    /**
                     * Verifies a BatchDeleteConversationsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchDeleteConversationsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchDeleteConversationsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.BatchDeleteConversationsResponse;

                    /**
                     * Creates a plain object from a BatchDeleteConversationsResponse message. Also converts values to other types if specified.
                     * @param message BatchDeleteConversationsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.BatchDeleteConversationsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchDeleteConversationsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BatchDeleteConversationsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListGuardrailsRequest. */
                interface IListGuardrailsRequest {

                    /** ListGuardrailsRequest parent */
                    parent?: (string|null);

                    /** ListGuardrailsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListGuardrailsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListGuardrailsRequest filter */
                    filter?: (string|null);

                    /** ListGuardrailsRequest orderBy */
                    orderBy?: (string|null);
                }

                /** Represents a ListGuardrailsRequest. */
                class ListGuardrailsRequest implements IListGuardrailsRequest {

                    /**
                     * Constructs a new ListGuardrailsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListGuardrailsRequest);

                    /** ListGuardrailsRequest parent. */
                    public parent: string;

                    /** ListGuardrailsRequest pageSize. */
                    public pageSize: number;

                    /** ListGuardrailsRequest pageToken. */
                    public pageToken: string;

                    /** ListGuardrailsRequest filter. */
                    public filter: string;

                    /** ListGuardrailsRequest orderBy. */
                    public orderBy: string;

                    /**
                     * Creates a new ListGuardrailsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListGuardrailsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListGuardrailsRequest): google.cloud.ces.v1beta.ListGuardrailsRequest;

                    /**
                     * Encodes the specified ListGuardrailsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListGuardrailsRequest.verify|verify} messages.
                     * @param message ListGuardrailsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListGuardrailsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListGuardrailsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListGuardrailsRequest.verify|verify} messages.
                     * @param message ListGuardrailsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListGuardrailsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListGuardrailsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListGuardrailsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListGuardrailsRequest;

                    /**
                     * Decodes a ListGuardrailsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListGuardrailsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListGuardrailsRequest;

                    /**
                     * Verifies a ListGuardrailsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListGuardrailsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListGuardrailsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListGuardrailsRequest;

                    /**
                     * Creates a plain object from a ListGuardrailsRequest message. Also converts values to other types if specified.
                     * @param message ListGuardrailsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListGuardrailsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListGuardrailsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListGuardrailsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListGuardrailsResponse. */
                interface IListGuardrailsResponse {

                    /** ListGuardrailsResponse guardrails */
                    guardrails?: (google.cloud.ces.v1beta.IGuardrail[]|null);

                    /** ListGuardrailsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListGuardrailsResponse. */
                class ListGuardrailsResponse implements IListGuardrailsResponse {

                    /**
                     * Constructs a new ListGuardrailsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListGuardrailsResponse);

                    /** ListGuardrailsResponse guardrails. */
                    public guardrails: google.cloud.ces.v1beta.IGuardrail[];

                    /** ListGuardrailsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListGuardrailsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListGuardrailsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListGuardrailsResponse): google.cloud.ces.v1beta.ListGuardrailsResponse;

                    /**
                     * Encodes the specified ListGuardrailsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListGuardrailsResponse.verify|verify} messages.
                     * @param message ListGuardrailsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListGuardrailsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListGuardrailsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListGuardrailsResponse.verify|verify} messages.
                     * @param message ListGuardrailsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListGuardrailsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListGuardrailsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListGuardrailsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListGuardrailsResponse;

                    /**
                     * Decodes a ListGuardrailsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListGuardrailsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListGuardrailsResponse;

                    /**
                     * Verifies a ListGuardrailsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListGuardrailsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListGuardrailsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListGuardrailsResponse;

                    /**
                     * Creates a plain object from a ListGuardrailsResponse message. Also converts values to other types if specified.
                     * @param message ListGuardrailsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListGuardrailsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListGuardrailsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListGuardrailsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetGuardrailRequest. */
                interface IGetGuardrailRequest {

                    /** GetGuardrailRequest name */
                    name?: (string|null);
                }

                /** Represents a GetGuardrailRequest. */
                class GetGuardrailRequest implements IGetGuardrailRequest {

                    /**
                     * Constructs a new GetGuardrailRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetGuardrailRequest);

                    /** GetGuardrailRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetGuardrailRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetGuardrailRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetGuardrailRequest): google.cloud.ces.v1beta.GetGuardrailRequest;

                    /**
                     * Encodes the specified GetGuardrailRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetGuardrailRequest.verify|verify} messages.
                     * @param message GetGuardrailRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetGuardrailRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetGuardrailRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetGuardrailRequest.verify|verify} messages.
                     * @param message GetGuardrailRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetGuardrailRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetGuardrailRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetGuardrailRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetGuardrailRequest;

                    /**
                     * Decodes a GetGuardrailRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetGuardrailRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetGuardrailRequest;

                    /**
                     * Verifies a GetGuardrailRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetGuardrailRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetGuardrailRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetGuardrailRequest;

                    /**
                     * Creates a plain object from a GetGuardrailRequest message. Also converts values to other types if specified.
                     * @param message GetGuardrailRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetGuardrailRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetGuardrailRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetGuardrailRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateGuardrailRequest. */
                interface ICreateGuardrailRequest {

                    /** CreateGuardrailRequest parent */
                    parent?: (string|null);

                    /** CreateGuardrailRequest guardrailId */
                    guardrailId?: (string|null);

                    /** CreateGuardrailRequest guardrail */
                    guardrail?: (google.cloud.ces.v1beta.IGuardrail|null);
                }

                /** Represents a CreateGuardrailRequest. */
                class CreateGuardrailRequest implements ICreateGuardrailRequest {

                    /**
                     * Constructs a new CreateGuardrailRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICreateGuardrailRequest);

                    /** CreateGuardrailRequest parent. */
                    public parent: string;

                    /** CreateGuardrailRequest guardrailId. */
                    public guardrailId: string;

                    /** CreateGuardrailRequest guardrail. */
                    public guardrail?: (google.cloud.ces.v1beta.IGuardrail|null);

                    /**
                     * Creates a new CreateGuardrailRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateGuardrailRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICreateGuardrailRequest): google.cloud.ces.v1beta.CreateGuardrailRequest;

                    /**
                     * Encodes the specified CreateGuardrailRequest message. Does not implicitly {@link google.cloud.ces.v1beta.CreateGuardrailRequest.verify|verify} messages.
                     * @param message CreateGuardrailRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICreateGuardrailRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateGuardrailRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.CreateGuardrailRequest.verify|verify} messages.
                     * @param message CreateGuardrailRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICreateGuardrailRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateGuardrailRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateGuardrailRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.CreateGuardrailRequest;

                    /**
                     * Decodes a CreateGuardrailRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateGuardrailRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.CreateGuardrailRequest;

                    /**
                     * Verifies a CreateGuardrailRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateGuardrailRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateGuardrailRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.CreateGuardrailRequest;

                    /**
                     * Creates a plain object from a CreateGuardrailRequest message. Also converts values to other types if specified.
                     * @param message CreateGuardrailRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.CreateGuardrailRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateGuardrailRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateGuardrailRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an UpdateGuardrailRequest. */
                interface IUpdateGuardrailRequest {

                    /** UpdateGuardrailRequest guardrail */
                    guardrail?: (google.cloud.ces.v1beta.IGuardrail|null);

                    /** UpdateGuardrailRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateGuardrailRequest. */
                class UpdateGuardrailRequest implements IUpdateGuardrailRequest {

                    /**
                     * Constructs a new UpdateGuardrailRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IUpdateGuardrailRequest);

                    /** UpdateGuardrailRequest guardrail. */
                    public guardrail?: (google.cloud.ces.v1beta.IGuardrail|null);

                    /** UpdateGuardrailRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateGuardrailRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateGuardrailRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IUpdateGuardrailRequest): google.cloud.ces.v1beta.UpdateGuardrailRequest;

                    /**
                     * Encodes the specified UpdateGuardrailRequest message. Does not implicitly {@link google.cloud.ces.v1beta.UpdateGuardrailRequest.verify|verify} messages.
                     * @param message UpdateGuardrailRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IUpdateGuardrailRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateGuardrailRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.UpdateGuardrailRequest.verify|verify} messages.
                     * @param message UpdateGuardrailRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IUpdateGuardrailRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateGuardrailRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateGuardrailRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.UpdateGuardrailRequest;

                    /**
                     * Decodes an UpdateGuardrailRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateGuardrailRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.UpdateGuardrailRequest;

                    /**
                     * Verifies an UpdateGuardrailRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateGuardrailRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateGuardrailRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.UpdateGuardrailRequest;

                    /**
                     * Creates a plain object from an UpdateGuardrailRequest message. Also converts values to other types if specified.
                     * @param message UpdateGuardrailRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.UpdateGuardrailRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateGuardrailRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for UpdateGuardrailRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteGuardrailRequest. */
                interface IDeleteGuardrailRequest {

                    /** DeleteGuardrailRequest name */
                    name?: (string|null);

                    /** DeleteGuardrailRequest force */
                    force?: (boolean|null);

                    /** DeleteGuardrailRequest etag */
                    etag?: (string|null);
                }

                /** Represents a DeleteGuardrailRequest. */
                class DeleteGuardrailRequest implements IDeleteGuardrailRequest {

                    /**
                     * Constructs a new DeleteGuardrailRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDeleteGuardrailRequest);

                    /** DeleteGuardrailRequest name. */
                    public name: string;

                    /** DeleteGuardrailRequest force. */
                    public force: boolean;

                    /** DeleteGuardrailRequest etag. */
                    public etag: string;

                    /**
                     * Creates a new DeleteGuardrailRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteGuardrailRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDeleteGuardrailRequest): google.cloud.ces.v1beta.DeleteGuardrailRequest;

                    /**
                     * Encodes the specified DeleteGuardrailRequest message. Does not implicitly {@link google.cloud.ces.v1beta.DeleteGuardrailRequest.verify|verify} messages.
                     * @param message DeleteGuardrailRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDeleteGuardrailRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteGuardrailRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DeleteGuardrailRequest.verify|verify} messages.
                     * @param message DeleteGuardrailRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDeleteGuardrailRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteGuardrailRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteGuardrailRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DeleteGuardrailRequest;

                    /**
                     * Decodes a DeleteGuardrailRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteGuardrailRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DeleteGuardrailRequest;

                    /**
                     * Verifies a DeleteGuardrailRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteGuardrailRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteGuardrailRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DeleteGuardrailRequest;

                    /**
                     * Creates a plain object from a DeleteGuardrailRequest message. Also converts values to other types if specified.
                     * @param message DeleteGuardrailRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DeleteGuardrailRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteGuardrailRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteGuardrailRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListDeploymentsRequest. */
                interface IListDeploymentsRequest {

                    /** ListDeploymentsRequest parent */
                    parent?: (string|null);

                    /** ListDeploymentsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListDeploymentsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListDeploymentsRequest orderBy */
                    orderBy?: (string|null);
                }

                /** Represents a ListDeploymentsRequest. */
                class ListDeploymentsRequest implements IListDeploymentsRequest {

                    /**
                     * Constructs a new ListDeploymentsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListDeploymentsRequest);

                    /** ListDeploymentsRequest parent. */
                    public parent: string;

                    /** ListDeploymentsRequest pageSize. */
                    public pageSize: number;

                    /** ListDeploymentsRequest pageToken. */
                    public pageToken: string;

                    /** ListDeploymentsRequest orderBy. */
                    public orderBy: string;

                    /**
                     * Creates a new ListDeploymentsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListDeploymentsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListDeploymentsRequest): google.cloud.ces.v1beta.ListDeploymentsRequest;

                    /**
                     * Encodes the specified ListDeploymentsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListDeploymentsRequest.verify|verify} messages.
                     * @param message ListDeploymentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListDeploymentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListDeploymentsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListDeploymentsRequest.verify|verify} messages.
                     * @param message ListDeploymentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListDeploymentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListDeploymentsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListDeploymentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListDeploymentsRequest;

                    /**
                     * Decodes a ListDeploymentsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListDeploymentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListDeploymentsRequest;

                    /**
                     * Verifies a ListDeploymentsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListDeploymentsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListDeploymentsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListDeploymentsRequest;

                    /**
                     * Creates a plain object from a ListDeploymentsRequest message. Also converts values to other types if specified.
                     * @param message ListDeploymentsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListDeploymentsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListDeploymentsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListDeploymentsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListDeploymentsResponse. */
                interface IListDeploymentsResponse {

                    /** ListDeploymentsResponse deployments */
                    deployments?: (google.cloud.ces.v1beta.IDeployment[]|null);

                    /** ListDeploymentsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListDeploymentsResponse. */
                class ListDeploymentsResponse implements IListDeploymentsResponse {

                    /**
                     * Constructs a new ListDeploymentsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListDeploymentsResponse);

                    /** ListDeploymentsResponse deployments. */
                    public deployments: google.cloud.ces.v1beta.IDeployment[];

                    /** ListDeploymentsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListDeploymentsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListDeploymentsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListDeploymentsResponse): google.cloud.ces.v1beta.ListDeploymentsResponse;

                    /**
                     * Encodes the specified ListDeploymentsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListDeploymentsResponse.verify|verify} messages.
                     * @param message ListDeploymentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListDeploymentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListDeploymentsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListDeploymentsResponse.verify|verify} messages.
                     * @param message ListDeploymentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListDeploymentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListDeploymentsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListDeploymentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListDeploymentsResponse;

                    /**
                     * Decodes a ListDeploymentsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListDeploymentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListDeploymentsResponse;

                    /**
                     * Verifies a ListDeploymentsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListDeploymentsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListDeploymentsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListDeploymentsResponse;

                    /**
                     * Creates a plain object from a ListDeploymentsResponse message. Also converts values to other types if specified.
                     * @param message ListDeploymentsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListDeploymentsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListDeploymentsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListDeploymentsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetDeploymentRequest. */
                interface IGetDeploymentRequest {

                    /** GetDeploymentRequest name */
                    name?: (string|null);
                }

                /** Represents a GetDeploymentRequest. */
                class GetDeploymentRequest implements IGetDeploymentRequest {

                    /**
                     * Constructs a new GetDeploymentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetDeploymentRequest);

                    /** GetDeploymentRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetDeploymentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetDeploymentRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetDeploymentRequest): google.cloud.ces.v1beta.GetDeploymentRequest;

                    /**
                     * Encodes the specified GetDeploymentRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetDeploymentRequest.verify|verify} messages.
                     * @param message GetDeploymentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetDeploymentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetDeploymentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetDeploymentRequest.verify|verify} messages.
                     * @param message GetDeploymentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetDeploymentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetDeploymentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetDeploymentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetDeploymentRequest;

                    /**
                     * Decodes a GetDeploymentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetDeploymentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetDeploymentRequest;

                    /**
                     * Verifies a GetDeploymentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetDeploymentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetDeploymentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetDeploymentRequest;

                    /**
                     * Creates a plain object from a GetDeploymentRequest message. Also converts values to other types if specified.
                     * @param message GetDeploymentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetDeploymentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetDeploymentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetDeploymentRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateDeploymentRequest. */
                interface ICreateDeploymentRequest {

                    /** CreateDeploymentRequest parent */
                    parent?: (string|null);

                    /** CreateDeploymentRequest deploymentId */
                    deploymentId?: (string|null);

                    /** CreateDeploymentRequest deployment */
                    deployment?: (google.cloud.ces.v1beta.IDeployment|null);
                }

                /** Represents a CreateDeploymentRequest. */
                class CreateDeploymentRequest implements ICreateDeploymentRequest {

                    /**
                     * Constructs a new CreateDeploymentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICreateDeploymentRequest);

                    /** CreateDeploymentRequest parent. */
                    public parent: string;

                    /** CreateDeploymentRequest deploymentId. */
                    public deploymentId: string;

                    /** CreateDeploymentRequest deployment. */
                    public deployment?: (google.cloud.ces.v1beta.IDeployment|null);

                    /**
                     * Creates a new CreateDeploymentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateDeploymentRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICreateDeploymentRequest): google.cloud.ces.v1beta.CreateDeploymentRequest;

                    /**
                     * Encodes the specified CreateDeploymentRequest message. Does not implicitly {@link google.cloud.ces.v1beta.CreateDeploymentRequest.verify|verify} messages.
                     * @param message CreateDeploymentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICreateDeploymentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateDeploymentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.CreateDeploymentRequest.verify|verify} messages.
                     * @param message CreateDeploymentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICreateDeploymentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateDeploymentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateDeploymentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.CreateDeploymentRequest;

                    /**
                     * Decodes a CreateDeploymentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateDeploymentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.CreateDeploymentRequest;

                    /**
                     * Verifies a CreateDeploymentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateDeploymentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateDeploymentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.CreateDeploymentRequest;

                    /**
                     * Creates a plain object from a CreateDeploymentRequest message. Also converts values to other types if specified.
                     * @param message CreateDeploymentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.CreateDeploymentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateDeploymentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateDeploymentRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an UpdateDeploymentRequest. */
                interface IUpdateDeploymentRequest {

                    /** UpdateDeploymentRequest deployment */
                    deployment?: (google.cloud.ces.v1beta.IDeployment|null);

                    /** UpdateDeploymentRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateDeploymentRequest. */
                class UpdateDeploymentRequest implements IUpdateDeploymentRequest {

                    /**
                     * Constructs a new UpdateDeploymentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IUpdateDeploymentRequest);

                    /** UpdateDeploymentRequest deployment. */
                    public deployment?: (google.cloud.ces.v1beta.IDeployment|null);

                    /** UpdateDeploymentRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateDeploymentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateDeploymentRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IUpdateDeploymentRequest): google.cloud.ces.v1beta.UpdateDeploymentRequest;

                    /**
                     * Encodes the specified UpdateDeploymentRequest message. Does not implicitly {@link google.cloud.ces.v1beta.UpdateDeploymentRequest.verify|verify} messages.
                     * @param message UpdateDeploymentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IUpdateDeploymentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateDeploymentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.UpdateDeploymentRequest.verify|verify} messages.
                     * @param message UpdateDeploymentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IUpdateDeploymentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateDeploymentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateDeploymentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.UpdateDeploymentRequest;

                    /**
                     * Decodes an UpdateDeploymentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateDeploymentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.UpdateDeploymentRequest;

                    /**
                     * Verifies an UpdateDeploymentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateDeploymentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateDeploymentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.UpdateDeploymentRequest;

                    /**
                     * Creates a plain object from an UpdateDeploymentRequest message. Also converts values to other types if specified.
                     * @param message UpdateDeploymentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.UpdateDeploymentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateDeploymentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for UpdateDeploymentRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteDeploymentRequest. */
                interface IDeleteDeploymentRequest {

                    /** DeleteDeploymentRequest name */
                    name?: (string|null);

                    /** DeleteDeploymentRequest etag */
                    etag?: (string|null);
                }

                /** Represents a DeleteDeploymentRequest. */
                class DeleteDeploymentRequest implements IDeleteDeploymentRequest {

                    /**
                     * Constructs a new DeleteDeploymentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDeleteDeploymentRequest);

                    /** DeleteDeploymentRequest name. */
                    public name: string;

                    /** DeleteDeploymentRequest etag. */
                    public etag: string;

                    /**
                     * Creates a new DeleteDeploymentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteDeploymentRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDeleteDeploymentRequest): google.cloud.ces.v1beta.DeleteDeploymentRequest;

                    /**
                     * Encodes the specified DeleteDeploymentRequest message. Does not implicitly {@link google.cloud.ces.v1beta.DeleteDeploymentRequest.verify|verify} messages.
                     * @param message DeleteDeploymentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDeleteDeploymentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteDeploymentRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DeleteDeploymentRequest.verify|verify} messages.
                     * @param message DeleteDeploymentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDeleteDeploymentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteDeploymentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteDeploymentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DeleteDeploymentRequest;

                    /**
                     * Decodes a DeleteDeploymentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteDeploymentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DeleteDeploymentRequest;

                    /**
                     * Verifies a DeleteDeploymentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteDeploymentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteDeploymentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DeleteDeploymentRequest;

                    /**
                     * Creates a plain object from a DeleteDeploymentRequest message. Also converts values to other types if specified.
                     * @param message DeleteDeploymentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DeleteDeploymentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteDeploymentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteDeploymentRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListToolsetsRequest. */
                interface IListToolsetsRequest {

                    /** ListToolsetsRequest parent */
                    parent?: (string|null);

                    /** ListToolsetsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListToolsetsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListToolsetsRequest filter */
                    filter?: (string|null);

                    /** ListToolsetsRequest orderBy */
                    orderBy?: (string|null);
                }

                /** Represents a ListToolsetsRequest. */
                class ListToolsetsRequest implements IListToolsetsRequest {

                    /**
                     * Constructs a new ListToolsetsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListToolsetsRequest);

                    /** ListToolsetsRequest parent. */
                    public parent: string;

                    /** ListToolsetsRequest pageSize. */
                    public pageSize: number;

                    /** ListToolsetsRequest pageToken. */
                    public pageToken: string;

                    /** ListToolsetsRequest filter. */
                    public filter: string;

                    /** ListToolsetsRequest orderBy. */
                    public orderBy: string;

                    /**
                     * Creates a new ListToolsetsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListToolsetsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListToolsetsRequest): google.cloud.ces.v1beta.ListToolsetsRequest;

                    /**
                     * Encodes the specified ListToolsetsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListToolsetsRequest.verify|verify} messages.
                     * @param message ListToolsetsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListToolsetsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListToolsetsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListToolsetsRequest.verify|verify} messages.
                     * @param message ListToolsetsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListToolsetsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListToolsetsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListToolsetsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListToolsetsRequest;

                    /**
                     * Decodes a ListToolsetsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListToolsetsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListToolsetsRequest;

                    /**
                     * Verifies a ListToolsetsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListToolsetsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListToolsetsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListToolsetsRequest;

                    /**
                     * Creates a plain object from a ListToolsetsRequest message. Also converts values to other types if specified.
                     * @param message ListToolsetsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListToolsetsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListToolsetsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListToolsetsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListToolsetsResponse. */
                interface IListToolsetsResponse {

                    /** ListToolsetsResponse toolsets */
                    toolsets?: (google.cloud.ces.v1beta.IToolset[]|null);

                    /** ListToolsetsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListToolsetsResponse. */
                class ListToolsetsResponse implements IListToolsetsResponse {

                    /**
                     * Constructs a new ListToolsetsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListToolsetsResponse);

                    /** ListToolsetsResponse toolsets. */
                    public toolsets: google.cloud.ces.v1beta.IToolset[];

                    /** ListToolsetsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListToolsetsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListToolsetsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListToolsetsResponse): google.cloud.ces.v1beta.ListToolsetsResponse;

                    /**
                     * Encodes the specified ListToolsetsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListToolsetsResponse.verify|verify} messages.
                     * @param message ListToolsetsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListToolsetsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListToolsetsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListToolsetsResponse.verify|verify} messages.
                     * @param message ListToolsetsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListToolsetsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListToolsetsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListToolsetsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListToolsetsResponse;

                    /**
                     * Decodes a ListToolsetsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListToolsetsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListToolsetsResponse;

                    /**
                     * Verifies a ListToolsetsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListToolsetsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListToolsetsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListToolsetsResponse;

                    /**
                     * Creates a plain object from a ListToolsetsResponse message. Also converts values to other types if specified.
                     * @param message ListToolsetsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListToolsetsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListToolsetsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListToolsetsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetToolsetRequest. */
                interface IGetToolsetRequest {

                    /** GetToolsetRequest name */
                    name?: (string|null);
                }

                /** Represents a GetToolsetRequest. */
                class GetToolsetRequest implements IGetToolsetRequest {

                    /**
                     * Constructs a new GetToolsetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetToolsetRequest);

                    /** GetToolsetRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetToolsetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetToolsetRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetToolsetRequest): google.cloud.ces.v1beta.GetToolsetRequest;

                    /**
                     * Encodes the specified GetToolsetRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetToolsetRequest.verify|verify} messages.
                     * @param message GetToolsetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetToolsetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetToolsetRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetToolsetRequest.verify|verify} messages.
                     * @param message GetToolsetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetToolsetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetToolsetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetToolsetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetToolsetRequest;

                    /**
                     * Decodes a GetToolsetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetToolsetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetToolsetRequest;

                    /**
                     * Verifies a GetToolsetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetToolsetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetToolsetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetToolsetRequest;

                    /**
                     * Creates a plain object from a GetToolsetRequest message. Also converts values to other types if specified.
                     * @param message GetToolsetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetToolsetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetToolsetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetToolsetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateToolsetRequest. */
                interface ICreateToolsetRequest {

                    /** CreateToolsetRequest parent */
                    parent?: (string|null);

                    /** CreateToolsetRequest toolsetId */
                    toolsetId?: (string|null);

                    /** CreateToolsetRequest toolset */
                    toolset?: (google.cloud.ces.v1beta.IToolset|null);
                }

                /** Represents a CreateToolsetRequest. */
                class CreateToolsetRequest implements ICreateToolsetRequest {

                    /**
                     * Constructs a new CreateToolsetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICreateToolsetRequest);

                    /** CreateToolsetRequest parent. */
                    public parent: string;

                    /** CreateToolsetRequest toolsetId. */
                    public toolsetId: string;

                    /** CreateToolsetRequest toolset. */
                    public toolset?: (google.cloud.ces.v1beta.IToolset|null);

                    /**
                     * Creates a new CreateToolsetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateToolsetRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICreateToolsetRequest): google.cloud.ces.v1beta.CreateToolsetRequest;

                    /**
                     * Encodes the specified CreateToolsetRequest message. Does not implicitly {@link google.cloud.ces.v1beta.CreateToolsetRequest.verify|verify} messages.
                     * @param message CreateToolsetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICreateToolsetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateToolsetRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.CreateToolsetRequest.verify|verify} messages.
                     * @param message CreateToolsetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICreateToolsetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateToolsetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateToolsetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.CreateToolsetRequest;

                    /**
                     * Decodes a CreateToolsetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateToolsetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.CreateToolsetRequest;

                    /**
                     * Verifies a CreateToolsetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateToolsetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateToolsetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.CreateToolsetRequest;

                    /**
                     * Creates a plain object from a CreateToolsetRequest message. Also converts values to other types if specified.
                     * @param message CreateToolsetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.CreateToolsetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateToolsetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateToolsetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an UpdateToolsetRequest. */
                interface IUpdateToolsetRequest {

                    /** UpdateToolsetRequest toolset */
                    toolset?: (google.cloud.ces.v1beta.IToolset|null);

                    /** UpdateToolsetRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateToolsetRequest. */
                class UpdateToolsetRequest implements IUpdateToolsetRequest {

                    /**
                     * Constructs a new UpdateToolsetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IUpdateToolsetRequest);

                    /** UpdateToolsetRequest toolset. */
                    public toolset?: (google.cloud.ces.v1beta.IToolset|null);

                    /** UpdateToolsetRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateToolsetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateToolsetRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IUpdateToolsetRequest): google.cloud.ces.v1beta.UpdateToolsetRequest;

                    /**
                     * Encodes the specified UpdateToolsetRequest message. Does not implicitly {@link google.cloud.ces.v1beta.UpdateToolsetRequest.verify|verify} messages.
                     * @param message UpdateToolsetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IUpdateToolsetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateToolsetRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.UpdateToolsetRequest.verify|verify} messages.
                     * @param message UpdateToolsetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IUpdateToolsetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateToolsetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateToolsetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.UpdateToolsetRequest;

                    /**
                     * Decodes an UpdateToolsetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateToolsetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.UpdateToolsetRequest;

                    /**
                     * Verifies an UpdateToolsetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateToolsetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateToolsetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.UpdateToolsetRequest;

                    /**
                     * Creates a plain object from an UpdateToolsetRequest message. Also converts values to other types if specified.
                     * @param message UpdateToolsetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.UpdateToolsetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateToolsetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for UpdateToolsetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteToolsetRequest. */
                interface IDeleteToolsetRequest {

                    /** DeleteToolsetRequest name */
                    name?: (string|null);

                    /** DeleteToolsetRequest force */
                    force?: (boolean|null);

                    /** DeleteToolsetRequest etag */
                    etag?: (string|null);
                }

                /** Represents a DeleteToolsetRequest. */
                class DeleteToolsetRequest implements IDeleteToolsetRequest {

                    /**
                     * Constructs a new DeleteToolsetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDeleteToolsetRequest);

                    /** DeleteToolsetRequest name. */
                    public name: string;

                    /** DeleteToolsetRequest force. */
                    public force: boolean;

                    /** DeleteToolsetRequest etag. */
                    public etag: string;

                    /**
                     * Creates a new DeleteToolsetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteToolsetRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDeleteToolsetRequest): google.cloud.ces.v1beta.DeleteToolsetRequest;

                    /**
                     * Encodes the specified DeleteToolsetRequest message. Does not implicitly {@link google.cloud.ces.v1beta.DeleteToolsetRequest.verify|verify} messages.
                     * @param message DeleteToolsetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDeleteToolsetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteToolsetRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DeleteToolsetRequest.verify|verify} messages.
                     * @param message DeleteToolsetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDeleteToolsetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteToolsetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteToolsetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DeleteToolsetRequest;

                    /**
                     * Decodes a DeleteToolsetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteToolsetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DeleteToolsetRequest;

                    /**
                     * Verifies a DeleteToolsetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteToolsetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteToolsetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DeleteToolsetRequest;

                    /**
                     * Creates a plain object from a DeleteToolsetRequest message. Also converts values to other types if specified.
                     * @param message DeleteToolsetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DeleteToolsetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteToolsetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteToolsetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListAppVersionsRequest. */
                interface IListAppVersionsRequest {

                    /** ListAppVersionsRequest parent */
                    parent?: (string|null);

                    /** ListAppVersionsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListAppVersionsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListAppVersionsRequest filter */
                    filter?: (string|null);

                    /** ListAppVersionsRequest orderBy */
                    orderBy?: (string|null);
                }

                /** Represents a ListAppVersionsRequest. */
                class ListAppVersionsRequest implements IListAppVersionsRequest {

                    /**
                     * Constructs a new ListAppVersionsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListAppVersionsRequest);

                    /** ListAppVersionsRequest parent. */
                    public parent: string;

                    /** ListAppVersionsRequest pageSize. */
                    public pageSize: number;

                    /** ListAppVersionsRequest pageToken. */
                    public pageToken: string;

                    /** ListAppVersionsRequest filter. */
                    public filter: string;

                    /** ListAppVersionsRequest orderBy. */
                    public orderBy: string;

                    /**
                     * Creates a new ListAppVersionsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListAppVersionsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListAppVersionsRequest): google.cloud.ces.v1beta.ListAppVersionsRequest;

                    /**
                     * Encodes the specified ListAppVersionsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListAppVersionsRequest.verify|verify} messages.
                     * @param message ListAppVersionsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListAppVersionsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListAppVersionsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListAppVersionsRequest.verify|verify} messages.
                     * @param message ListAppVersionsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListAppVersionsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListAppVersionsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListAppVersionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListAppVersionsRequest;

                    /**
                     * Decodes a ListAppVersionsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListAppVersionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListAppVersionsRequest;

                    /**
                     * Verifies a ListAppVersionsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListAppVersionsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListAppVersionsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListAppVersionsRequest;

                    /**
                     * Creates a plain object from a ListAppVersionsRequest message. Also converts values to other types if specified.
                     * @param message ListAppVersionsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListAppVersionsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListAppVersionsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListAppVersionsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListAppVersionsResponse. */
                interface IListAppVersionsResponse {

                    /** ListAppVersionsResponse appVersions */
                    appVersions?: (google.cloud.ces.v1beta.IAppVersion[]|null);

                    /** ListAppVersionsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListAppVersionsResponse. */
                class ListAppVersionsResponse implements IListAppVersionsResponse {

                    /**
                     * Constructs a new ListAppVersionsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListAppVersionsResponse);

                    /** ListAppVersionsResponse appVersions. */
                    public appVersions: google.cloud.ces.v1beta.IAppVersion[];

                    /** ListAppVersionsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListAppVersionsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListAppVersionsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListAppVersionsResponse): google.cloud.ces.v1beta.ListAppVersionsResponse;

                    /**
                     * Encodes the specified ListAppVersionsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListAppVersionsResponse.verify|verify} messages.
                     * @param message ListAppVersionsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListAppVersionsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListAppVersionsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListAppVersionsResponse.verify|verify} messages.
                     * @param message ListAppVersionsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListAppVersionsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListAppVersionsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListAppVersionsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListAppVersionsResponse;

                    /**
                     * Decodes a ListAppVersionsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListAppVersionsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListAppVersionsResponse;

                    /**
                     * Verifies a ListAppVersionsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListAppVersionsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListAppVersionsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListAppVersionsResponse;

                    /**
                     * Creates a plain object from a ListAppVersionsResponse message. Also converts values to other types if specified.
                     * @param message ListAppVersionsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListAppVersionsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListAppVersionsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListAppVersionsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetAppVersionRequest. */
                interface IGetAppVersionRequest {

                    /** GetAppVersionRequest name */
                    name?: (string|null);
                }

                /** Represents a GetAppVersionRequest. */
                class GetAppVersionRequest implements IGetAppVersionRequest {

                    /**
                     * Constructs a new GetAppVersionRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetAppVersionRequest);

                    /** GetAppVersionRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetAppVersionRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetAppVersionRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetAppVersionRequest): google.cloud.ces.v1beta.GetAppVersionRequest;

                    /**
                     * Encodes the specified GetAppVersionRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetAppVersionRequest.verify|verify} messages.
                     * @param message GetAppVersionRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetAppVersionRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetAppVersionRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetAppVersionRequest.verify|verify} messages.
                     * @param message GetAppVersionRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetAppVersionRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetAppVersionRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetAppVersionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetAppVersionRequest;

                    /**
                     * Decodes a GetAppVersionRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetAppVersionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetAppVersionRequest;

                    /**
                     * Verifies a GetAppVersionRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetAppVersionRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetAppVersionRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetAppVersionRequest;

                    /**
                     * Creates a plain object from a GetAppVersionRequest message. Also converts values to other types if specified.
                     * @param message GetAppVersionRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetAppVersionRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetAppVersionRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetAppVersionRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteAppVersionRequest. */
                interface IDeleteAppVersionRequest {

                    /** DeleteAppVersionRequest name */
                    name?: (string|null);

                    /** DeleteAppVersionRequest etag */
                    etag?: (string|null);
                }

                /** Represents a DeleteAppVersionRequest. */
                class DeleteAppVersionRequest implements IDeleteAppVersionRequest {

                    /**
                     * Constructs a new DeleteAppVersionRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDeleteAppVersionRequest);

                    /** DeleteAppVersionRequest name. */
                    public name: string;

                    /** DeleteAppVersionRequest etag. */
                    public etag: string;

                    /**
                     * Creates a new DeleteAppVersionRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteAppVersionRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDeleteAppVersionRequest): google.cloud.ces.v1beta.DeleteAppVersionRequest;

                    /**
                     * Encodes the specified DeleteAppVersionRequest message. Does not implicitly {@link google.cloud.ces.v1beta.DeleteAppVersionRequest.verify|verify} messages.
                     * @param message DeleteAppVersionRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDeleteAppVersionRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteAppVersionRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DeleteAppVersionRequest.verify|verify} messages.
                     * @param message DeleteAppVersionRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDeleteAppVersionRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteAppVersionRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteAppVersionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DeleteAppVersionRequest;

                    /**
                     * Decodes a DeleteAppVersionRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteAppVersionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DeleteAppVersionRequest;

                    /**
                     * Verifies a DeleteAppVersionRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteAppVersionRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteAppVersionRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DeleteAppVersionRequest;

                    /**
                     * Creates a plain object from a DeleteAppVersionRequest message. Also converts values to other types if specified.
                     * @param message DeleteAppVersionRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DeleteAppVersionRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteAppVersionRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteAppVersionRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateAppVersionRequest. */
                interface ICreateAppVersionRequest {

                    /** CreateAppVersionRequest parent */
                    parent?: (string|null);

                    /** CreateAppVersionRequest appVersionId */
                    appVersionId?: (string|null);

                    /** CreateAppVersionRequest appVersion */
                    appVersion?: (google.cloud.ces.v1beta.IAppVersion|null);
                }

                /** Represents a CreateAppVersionRequest. */
                class CreateAppVersionRequest implements ICreateAppVersionRequest {

                    /**
                     * Constructs a new CreateAppVersionRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICreateAppVersionRequest);

                    /** CreateAppVersionRequest parent. */
                    public parent: string;

                    /** CreateAppVersionRequest appVersionId. */
                    public appVersionId: string;

                    /** CreateAppVersionRequest appVersion. */
                    public appVersion?: (google.cloud.ces.v1beta.IAppVersion|null);

                    /**
                     * Creates a new CreateAppVersionRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateAppVersionRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICreateAppVersionRequest): google.cloud.ces.v1beta.CreateAppVersionRequest;

                    /**
                     * Encodes the specified CreateAppVersionRequest message. Does not implicitly {@link google.cloud.ces.v1beta.CreateAppVersionRequest.verify|verify} messages.
                     * @param message CreateAppVersionRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICreateAppVersionRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateAppVersionRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.CreateAppVersionRequest.verify|verify} messages.
                     * @param message CreateAppVersionRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICreateAppVersionRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateAppVersionRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateAppVersionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.CreateAppVersionRequest;

                    /**
                     * Decodes a CreateAppVersionRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateAppVersionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.CreateAppVersionRequest;

                    /**
                     * Verifies a CreateAppVersionRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateAppVersionRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateAppVersionRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.CreateAppVersionRequest;

                    /**
                     * Creates a plain object from a CreateAppVersionRequest message. Also converts values to other types if specified.
                     * @param message CreateAppVersionRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.CreateAppVersionRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateAppVersionRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateAppVersionRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a RestoreAppVersionRequest. */
                interface IRestoreAppVersionRequest {

                    /** RestoreAppVersionRequest name */
                    name?: (string|null);
                }

                /** Represents a RestoreAppVersionRequest. */
                class RestoreAppVersionRequest implements IRestoreAppVersionRequest {

                    /**
                     * Constructs a new RestoreAppVersionRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IRestoreAppVersionRequest);

                    /** RestoreAppVersionRequest name. */
                    public name: string;

                    /**
                     * Creates a new RestoreAppVersionRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns RestoreAppVersionRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IRestoreAppVersionRequest): google.cloud.ces.v1beta.RestoreAppVersionRequest;

                    /**
                     * Encodes the specified RestoreAppVersionRequest message. Does not implicitly {@link google.cloud.ces.v1beta.RestoreAppVersionRequest.verify|verify} messages.
                     * @param message RestoreAppVersionRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IRestoreAppVersionRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified RestoreAppVersionRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.RestoreAppVersionRequest.verify|verify} messages.
                     * @param message RestoreAppVersionRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IRestoreAppVersionRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a RestoreAppVersionRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns RestoreAppVersionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.RestoreAppVersionRequest;

                    /**
                     * Decodes a RestoreAppVersionRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns RestoreAppVersionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.RestoreAppVersionRequest;

                    /**
                     * Verifies a RestoreAppVersionRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a RestoreAppVersionRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns RestoreAppVersionRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.RestoreAppVersionRequest;

                    /**
                     * Creates a plain object from a RestoreAppVersionRequest message. Also converts values to other types if specified.
                     * @param message RestoreAppVersionRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.RestoreAppVersionRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this RestoreAppVersionRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for RestoreAppVersionRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a RestoreAppVersionResponse. */
                interface IRestoreAppVersionResponse {
                }

                /** Represents a RestoreAppVersionResponse. */
                class RestoreAppVersionResponse implements IRestoreAppVersionResponse {

                    /**
                     * Constructs a new RestoreAppVersionResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IRestoreAppVersionResponse);

                    /**
                     * Creates a new RestoreAppVersionResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns RestoreAppVersionResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IRestoreAppVersionResponse): google.cloud.ces.v1beta.RestoreAppVersionResponse;

                    /**
                     * Encodes the specified RestoreAppVersionResponse message. Does not implicitly {@link google.cloud.ces.v1beta.RestoreAppVersionResponse.verify|verify} messages.
                     * @param message RestoreAppVersionResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IRestoreAppVersionResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified RestoreAppVersionResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.RestoreAppVersionResponse.verify|verify} messages.
                     * @param message RestoreAppVersionResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IRestoreAppVersionResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a RestoreAppVersionResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns RestoreAppVersionResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.RestoreAppVersionResponse;

                    /**
                     * Decodes a RestoreAppVersionResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns RestoreAppVersionResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.RestoreAppVersionResponse;

                    /**
                     * Verifies a RestoreAppVersionResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a RestoreAppVersionResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns RestoreAppVersionResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.RestoreAppVersionResponse;

                    /**
                     * Creates a plain object from a RestoreAppVersionResponse message. Also converts values to other types if specified.
                     * @param message RestoreAppVersionResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.RestoreAppVersionResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this RestoreAppVersionResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for RestoreAppVersionResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GenerateAppResourceResponse. */
                interface IGenerateAppResourceResponse {

                    /** GenerateAppResourceResponse agent */
                    agent?: (google.cloud.ces.v1beta.IAgent|null);

                    /** GenerateAppResourceResponse toolset */
                    toolset?: (google.cloud.ces.v1beta.IToolset|null);

                    /** GenerateAppResourceResponse appSnapshot */
                    appSnapshot?: (google.cloud.ces.v1beta.IAppSnapshot|null);

                    /** GenerateAppResourceResponse tools */
                    tools?: (google.cloud.ces.v1beta.GenerateAppResourceResponse.ITools|null);

                    /** GenerateAppResourceResponse evaluations */
                    evaluations?: (google.cloud.ces.v1beta.GenerateAppResourceResponse.IEvaluations|null);

                    /** GenerateAppResourceResponse appResources */
                    appResources?: (google.cloud.ces.v1beta.GenerateAppResourceResponse.IAppResources|null);

                    /** GenerateAppResourceResponse generateResultInfo */
                    generateResultInfo?: (google.cloud.ces.v1beta.GenerateAppResourceResponse.IGenerateResultInfo|null);
                }

                /** Represents a GenerateAppResourceResponse. */
                class GenerateAppResourceResponse implements IGenerateAppResourceResponse {

                    /**
                     * Constructs a new GenerateAppResourceResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGenerateAppResourceResponse);

                    /** GenerateAppResourceResponse agent. */
                    public agent?: (google.cloud.ces.v1beta.IAgent|null);

                    /** GenerateAppResourceResponse toolset. */
                    public toolset?: (google.cloud.ces.v1beta.IToolset|null);

                    /** GenerateAppResourceResponse appSnapshot. */
                    public appSnapshot?: (google.cloud.ces.v1beta.IAppSnapshot|null);

                    /** GenerateAppResourceResponse tools. */
                    public tools?: (google.cloud.ces.v1beta.GenerateAppResourceResponse.ITools|null);

                    /** GenerateAppResourceResponse evaluations. */
                    public evaluations?: (google.cloud.ces.v1beta.GenerateAppResourceResponse.IEvaluations|null);

                    /** GenerateAppResourceResponse appResources. */
                    public appResources?: (google.cloud.ces.v1beta.GenerateAppResourceResponse.IAppResources|null);

                    /** GenerateAppResourceResponse generateResultInfo. */
                    public generateResultInfo?: (google.cloud.ces.v1beta.GenerateAppResourceResponse.IGenerateResultInfo|null);

                    /** GenerateAppResourceResponse generatedResource. */
                    public generatedResource?: ("agent"|"toolset"|"appSnapshot"|"tools"|"evaluations"|"appResources");

                    /**
                     * Creates a new GenerateAppResourceResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GenerateAppResourceResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGenerateAppResourceResponse): google.cloud.ces.v1beta.GenerateAppResourceResponse;

                    /**
                     * Encodes the specified GenerateAppResourceResponse message. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.verify|verify} messages.
                     * @param message GenerateAppResourceResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGenerateAppResourceResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GenerateAppResourceResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.verify|verify} messages.
                     * @param message GenerateAppResourceResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGenerateAppResourceResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GenerateAppResourceResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GenerateAppResourceResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GenerateAppResourceResponse;

                    /**
                     * Decodes a GenerateAppResourceResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GenerateAppResourceResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GenerateAppResourceResponse;

                    /**
                     * Verifies a GenerateAppResourceResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GenerateAppResourceResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GenerateAppResourceResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GenerateAppResourceResponse;

                    /**
                     * Creates a plain object from a GenerateAppResourceResponse message. Also converts values to other types if specified.
                     * @param message GenerateAppResourceResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GenerateAppResourceResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GenerateAppResourceResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GenerateAppResourceResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace GenerateAppResourceResponse {

                    /** Properties of an Evaluations. */
                    interface IEvaluations {

                        /** Evaluations evaluations */
                        evaluations?: (google.cloud.ces.v1beta.IEvaluation[]|null);
                    }

                    /** Represents an Evaluations. */
                    class Evaluations implements IEvaluations {

                        /**
                         * Constructs a new Evaluations.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.GenerateAppResourceResponse.IEvaluations);

                        /** Evaluations evaluations. */
                        public evaluations: google.cloud.ces.v1beta.IEvaluation[];

                        /**
                         * Creates a new Evaluations instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Evaluations instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.GenerateAppResourceResponse.IEvaluations): google.cloud.ces.v1beta.GenerateAppResourceResponse.Evaluations;

                        /**
                         * Encodes the specified Evaluations message. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.Evaluations.verify|verify} messages.
                         * @param message Evaluations message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.IEvaluations, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Evaluations message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.Evaluations.verify|verify} messages.
                         * @param message Evaluations message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.IEvaluations, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an Evaluations message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Evaluations
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GenerateAppResourceResponse.Evaluations;

                        /**
                         * Decodes an Evaluations message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Evaluations
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GenerateAppResourceResponse.Evaluations;

                        /**
                         * Verifies an Evaluations message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an Evaluations message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Evaluations
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GenerateAppResourceResponse.Evaluations;

                        /**
                         * Creates a plain object from an Evaluations message. Also converts values to other types if specified.
                         * @param message Evaluations
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.Evaluations, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Evaluations to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Evaluations
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a Tools. */
                    interface ITools {

                        /** Tools tools */
                        tools?: (google.cloud.ces.v1beta.ITool[]|null);
                    }

                    /** Represents a Tools. */
                    class Tools implements ITools {

                        /**
                         * Constructs a new Tools.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.GenerateAppResourceResponse.ITools);

                        /** Tools tools. */
                        public tools: google.cloud.ces.v1beta.ITool[];

                        /**
                         * Creates a new Tools instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Tools instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.GenerateAppResourceResponse.ITools): google.cloud.ces.v1beta.GenerateAppResourceResponse.Tools;

                        /**
                         * Encodes the specified Tools message. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.Tools.verify|verify} messages.
                         * @param message Tools message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.ITools, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Tools message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.Tools.verify|verify} messages.
                         * @param message Tools message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.ITools, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Tools message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Tools
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GenerateAppResourceResponse.Tools;

                        /**
                         * Decodes a Tools message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Tools
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GenerateAppResourceResponse.Tools;

                        /**
                         * Verifies a Tools message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Tools message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Tools
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GenerateAppResourceResponse.Tools;

                        /**
                         * Creates a plain object from a Tools message. Also converts values to other types if specified.
                         * @param message Tools
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.Tools, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Tools to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Tools
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of an AppResources. */
                    interface IAppResources {

                        /** AppResources appSnapshot */
                        appSnapshot?: (google.cloud.ces.v1beta.IAppSnapshot|null);

                        /** AppResources evaluations */
                        evaluations?: (google.cloud.ces.v1beta.IEvaluation[]|null);
                    }

                    /** Represents an AppResources. */
                    class AppResources implements IAppResources {

                        /**
                         * Constructs a new AppResources.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.GenerateAppResourceResponse.IAppResources);

                        /** AppResources appSnapshot. */
                        public appSnapshot?: (google.cloud.ces.v1beta.IAppSnapshot|null);

                        /** AppResources evaluations. */
                        public evaluations: google.cloud.ces.v1beta.IEvaluation[];

                        /**
                         * Creates a new AppResources instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns AppResources instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.GenerateAppResourceResponse.IAppResources): google.cloud.ces.v1beta.GenerateAppResourceResponse.AppResources;

                        /**
                         * Encodes the specified AppResources message. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.AppResources.verify|verify} messages.
                         * @param message AppResources message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.IAppResources, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified AppResources message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.AppResources.verify|verify} messages.
                         * @param message AppResources message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.IAppResources, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an AppResources message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns AppResources
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GenerateAppResourceResponse.AppResources;

                        /**
                         * Decodes an AppResources message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns AppResources
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GenerateAppResourceResponse.AppResources;

                        /**
                         * Verifies an AppResources message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an AppResources message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns AppResources
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GenerateAppResourceResponse.AppResources;

                        /**
                         * Creates a plain object from an AppResources message. Also converts values to other types if specified.
                         * @param message AppResources
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.AppResources, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this AppResources to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for AppResources
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a GenerateResultInfo. */
                    interface IGenerateResultInfo {

                        /** GenerateResultInfo explanation */
                        explanation?: (string|null);
                    }

                    /** Represents a GenerateResultInfo. */
                    class GenerateResultInfo implements IGenerateResultInfo {

                        /**
                         * Constructs a new GenerateResultInfo.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.GenerateAppResourceResponse.IGenerateResultInfo);

                        /** GenerateResultInfo explanation. */
                        public explanation: string;

                        /**
                         * Creates a new GenerateResultInfo instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GenerateResultInfo instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.GenerateAppResourceResponse.IGenerateResultInfo): google.cloud.ces.v1beta.GenerateAppResourceResponse.GenerateResultInfo;

                        /**
                         * Encodes the specified GenerateResultInfo message. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.GenerateResultInfo.verify|verify} messages.
                         * @param message GenerateResultInfo message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.IGenerateResultInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GenerateResultInfo message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GenerateAppResourceResponse.GenerateResultInfo.verify|verify} messages.
                         * @param message GenerateResultInfo message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.IGenerateResultInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GenerateResultInfo message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GenerateResultInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GenerateAppResourceResponse.GenerateResultInfo;

                        /**
                         * Decodes a GenerateResultInfo message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GenerateResultInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GenerateAppResourceResponse.GenerateResultInfo;

                        /**
                         * Verifies a GenerateResultInfo message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GenerateResultInfo message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GenerateResultInfo
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GenerateAppResourceResponse.GenerateResultInfo;

                        /**
                         * Creates a plain object from a GenerateResultInfo message. Also converts values to other types if specified.
                         * @param message GenerateResultInfo
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.GenerateAppResourceResponse.GenerateResultInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GenerateResultInfo to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for GenerateResultInfo
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** Properties of a ListChangelogsRequest. */
                interface IListChangelogsRequest {

                    /** ListChangelogsRequest parent */
                    parent?: (string|null);

                    /** ListChangelogsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListChangelogsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListChangelogsRequest filter */
                    filter?: (string|null);

                    /** ListChangelogsRequest orderBy */
                    orderBy?: (string|null);
                }

                /** Represents a ListChangelogsRequest. */
                class ListChangelogsRequest implements IListChangelogsRequest {

                    /**
                     * Constructs a new ListChangelogsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListChangelogsRequest);

                    /** ListChangelogsRequest parent. */
                    public parent: string;

                    /** ListChangelogsRequest pageSize. */
                    public pageSize: number;

                    /** ListChangelogsRequest pageToken. */
                    public pageToken: string;

                    /** ListChangelogsRequest filter. */
                    public filter: string;

                    /** ListChangelogsRequest orderBy. */
                    public orderBy: string;

                    /**
                     * Creates a new ListChangelogsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListChangelogsRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListChangelogsRequest): google.cloud.ces.v1beta.ListChangelogsRequest;

                    /**
                     * Encodes the specified ListChangelogsRequest message. Does not implicitly {@link google.cloud.ces.v1beta.ListChangelogsRequest.verify|verify} messages.
                     * @param message ListChangelogsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListChangelogsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListChangelogsRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListChangelogsRequest.verify|verify} messages.
                     * @param message ListChangelogsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListChangelogsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListChangelogsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListChangelogsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListChangelogsRequest;

                    /**
                     * Decodes a ListChangelogsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListChangelogsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListChangelogsRequest;

                    /**
                     * Verifies a ListChangelogsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListChangelogsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListChangelogsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListChangelogsRequest;

                    /**
                     * Creates a plain object from a ListChangelogsRequest message. Also converts values to other types if specified.
                     * @param message ListChangelogsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListChangelogsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListChangelogsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListChangelogsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListChangelogsResponse. */
                interface IListChangelogsResponse {

                    /** ListChangelogsResponse changelogs */
                    changelogs?: (google.cloud.ces.v1beta.IChangelog[]|null);

                    /** ListChangelogsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListChangelogsResponse. */
                class ListChangelogsResponse implements IListChangelogsResponse {

                    /**
                     * Constructs a new ListChangelogsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IListChangelogsResponse);

                    /** ListChangelogsResponse changelogs. */
                    public changelogs: google.cloud.ces.v1beta.IChangelog[];

                    /** ListChangelogsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListChangelogsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListChangelogsResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IListChangelogsResponse): google.cloud.ces.v1beta.ListChangelogsResponse;

                    /**
                     * Encodes the specified ListChangelogsResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ListChangelogsResponse.verify|verify} messages.
                     * @param message ListChangelogsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IListChangelogsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListChangelogsResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ListChangelogsResponse.verify|verify} messages.
                     * @param message ListChangelogsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IListChangelogsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListChangelogsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListChangelogsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ListChangelogsResponse;

                    /**
                     * Decodes a ListChangelogsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListChangelogsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ListChangelogsResponse;

                    /**
                     * Verifies a ListChangelogsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListChangelogsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListChangelogsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ListChangelogsResponse;

                    /**
                     * Creates a plain object from a ListChangelogsResponse message. Also converts values to other types if specified.
                     * @param message ListChangelogsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ListChangelogsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListChangelogsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListChangelogsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetChangelogRequest. */
                interface IGetChangelogRequest {

                    /** GetChangelogRequest name */
                    name?: (string|null);
                }

                /** Represents a GetChangelogRequest. */
                class GetChangelogRequest implements IGetChangelogRequest {

                    /**
                     * Constructs a new GetChangelogRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGetChangelogRequest);

                    /** GetChangelogRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetChangelogRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetChangelogRequest instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGetChangelogRequest): google.cloud.ces.v1beta.GetChangelogRequest;

                    /**
                     * Encodes the specified GetChangelogRequest message. Does not implicitly {@link google.cloud.ces.v1beta.GetChangelogRequest.verify|verify} messages.
                     * @param message GetChangelogRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGetChangelogRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetChangelogRequest message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.GetChangelogRequest.verify|verify} messages.
                     * @param message GetChangelogRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGetChangelogRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetChangelogRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetChangelogRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.GetChangelogRequest;

                    /**
                     * Decodes a GetChangelogRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetChangelogRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.GetChangelogRequest;

                    /**
                     * Verifies a GetChangelogRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetChangelogRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetChangelogRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.GetChangelogRequest;

                    /**
                     * Creates a plain object from a GetChangelogRequest message. Also converts values to other types if specified.
                     * @param message GetChangelogRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.GetChangelogRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetChangelogRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetChangelogRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an App. */
                interface IApp {

                    /** App name */
                    name?: (string|null);

                    /** App displayName */
                    displayName?: (string|null);

                    /** App description */
                    description?: (string|null);

                    /** App pinned */
                    pinned?: (boolean|null);

                    /** App rootAgent */
                    rootAgent?: (string|null);

                    /** App languageSettings */
                    languageSettings?: (google.cloud.ces.v1beta.ILanguageSettings|null);

                    /** App timeZoneSettings */
                    timeZoneSettings?: (google.cloud.ces.v1beta.ITimeZoneSettings|null);

                    /** App audioProcessingConfig */
                    audioProcessingConfig?: (google.cloud.ces.v1beta.IAudioProcessingConfig|null);

                    /** App loggingSettings */
                    loggingSettings?: (google.cloud.ces.v1beta.ILoggingSettings|null);

                    /** App modelSettings */
                    modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                    /** App toolExecutionMode */
                    toolExecutionMode?: (google.cloud.ces.v1beta.App.ToolExecutionMode|keyof typeof google.cloud.ces.v1beta.App.ToolExecutionMode|null);

                    /** App evaluationMetricsThresholds */
                    evaluationMetricsThresholds?: (google.cloud.ces.v1beta.IEvaluationMetricsThresholds|null);

                    /** App variableDeclarations */
                    variableDeclarations?: (google.cloud.ces.v1beta.App.IVariableDeclaration[]|null);

                    /** App predefinedVariableDeclarations */
                    predefinedVariableDeclarations?: (google.cloud.ces.v1beta.App.IVariableDeclaration[]|null);

                    /** App globalInstruction */
                    globalInstruction?: (string|null);

                    /** App guardrails */
                    guardrails?: (string[]|null);

                    /** App dataStoreSettings */
                    dataStoreSettings?: (google.cloud.ces.v1beta.IDataStoreSettings|null);

                    /** App defaultChannelProfile */
                    defaultChannelProfile?: (google.cloud.ces.v1beta.IChannelProfile|null);

                    /** App metadata */
                    metadata?: ({ [k: string]: string }|null);

                    /** App createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** App updateTime */
                    updateTime?: (google.protobuf.ITimestamp|null);

                    /** App etag */
                    etag?: (string|null);

                    /** App deploymentCount */
                    deploymentCount?: (number|null);

                    /** App clientCertificateSettings */
                    clientCertificateSettings?: (google.cloud.ces.v1beta.IClientCertificateSettings|null);

                    /** App evaluationPersonas */
                    evaluationPersonas?: (google.cloud.ces.v1beta.IEvaluationPersona[]|null);

                    /** App evaluationSettings */
                    evaluationSettings?: (google.cloud.ces.v1beta.IEvaluationSettings|null);
                }

                /** Represents an App. */
                class App implements IApp {

                    /**
                     * Constructs a new App.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IApp);

                    /** App name. */
                    public name: string;

                    /** App displayName. */
                    public displayName: string;

                    /** App description. */
                    public description: string;

                    /** App pinned. */
                    public pinned: boolean;

                    /** App rootAgent. */
                    public rootAgent: string;

                    /** App languageSettings. */
                    public languageSettings?: (google.cloud.ces.v1beta.ILanguageSettings|null);

                    /** App timeZoneSettings. */
                    public timeZoneSettings?: (google.cloud.ces.v1beta.ITimeZoneSettings|null);

                    /** App audioProcessingConfig. */
                    public audioProcessingConfig?: (google.cloud.ces.v1beta.IAudioProcessingConfig|null);

                    /** App loggingSettings. */
                    public loggingSettings?: (google.cloud.ces.v1beta.ILoggingSettings|null);

                    /** App modelSettings. */
                    public modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                    /** App toolExecutionMode. */
                    public toolExecutionMode: (google.cloud.ces.v1beta.App.ToolExecutionMode|keyof typeof google.cloud.ces.v1beta.App.ToolExecutionMode);

                    /** App evaluationMetricsThresholds. */
                    public evaluationMetricsThresholds?: (google.cloud.ces.v1beta.IEvaluationMetricsThresholds|null);

                    /** App variableDeclarations. */
                    public variableDeclarations: google.cloud.ces.v1beta.App.IVariableDeclaration[];

                    /** App predefinedVariableDeclarations. */
                    public predefinedVariableDeclarations: google.cloud.ces.v1beta.App.IVariableDeclaration[];

                    /** App globalInstruction. */
                    public globalInstruction: string;

                    /** App guardrails. */
                    public guardrails: string[];

                    /** App dataStoreSettings. */
                    public dataStoreSettings?: (google.cloud.ces.v1beta.IDataStoreSettings|null);

                    /** App defaultChannelProfile. */
                    public defaultChannelProfile?: (google.cloud.ces.v1beta.IChannelProfile|null);

                    /** App metadata. */
                    public metadata: { [k: string]: string };

                    /** App createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** App updateTime. */
                    public updateTime?: (google.protobuf.ITimestamp|null);

                    /** App etag. */
                    public etag: string;

                    /** App deploymentCount. */
                    public deploymentCount: number;

                    /** App clientCertificateSettings. */
                    public clientCertificateSettings?: (google.cloud.ces.v1beta.IClientCertificateSettings|null);

                    /** App evaluationPersonas. */
                    public evaluationPersonas: google.cloud.ces.v1beta.IEvaluationPersona[];

                    /** App evaluationSettings. */
                    public evaluationSettings?: (google.cloud.ces.v1beta.IEvaluationSettings|null);

                    /**
                     * Creates a new App instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns App instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IApp): google.cloud.ces.v1beta.App;

                    /**
                     * Encodes the specified App message. Does not implicitly {@link google.cloud.ces.v1beta.App.verify|verify} messages.
                     * @param message App message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IApp, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified App message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.App.verify|verify} messages.
                     * @param message App message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IApp, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an App message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns App
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.App;

                    /**
                     * Decodes an App message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns App
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.App;

                    /**
                     * Verifies an App message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an App message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns App
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.App;

                    /**
                     * Creates a plain object from an App message. Also converts values to other types if specified.
                     * @param message App
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.App, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this App to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for App
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace App {

                    /** Properties of a VariableDeclaration. */
                    interface IVariableDeclaration {

                        /** VariableDeclaration name */
                        name?: (string|null);

                        /** VariableDeclaration description */
                        description?: (string|null);

                        /** VariableDeclaration schema */
                        schema?: (google.cloud.ces.v1beta.ISchema|null);
                    }

                    /** Represents a VariableDeclaration. */
                    class VariableDeclaration implements IVariableDeclaration {

                        /**
                         * Constructs a new VariableDeclaration.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.App.IVariableDeclaration);

                        /** VariableDeclaration name. */
                        public name: string;

                        /** VariableDeclaration description. */
                        public description: string;

                        /** VariableDeclaration schema. */
                        public schema?: (google.cloud.ces.v1beta.ISchema|null);

                        /**
                         * Creates a new VariableDeclaration instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns VariableDeclaration instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.App.IVariableDeclaration): google.cloud.ces.v1beta.App.VariableDeclaration;

                        /**
                         * Encodes the specified VariableDeclaration message. Does not implicitly {@link google.cloud.ces.v1beta.App.VariableDeclaration.verify|verify} messages.
                         * @param message VariableDeclaration message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.App.IVariableDeclaration, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified VariableDeclaration message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.App.VariableDeclaration.verify|verify} messages.
                         * @param message VariableDeclaration message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.App.IVariableDeclaration, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a VariableDeclaration message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns VariableDeclaration
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.App.VariableDeclaration;

                        /**
                         * Decodes a VariableDeclaration message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns VariableDeclaration
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.App.VariableDeclaration;

                        /**
                         * Verifies a VariableDeclaration message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a VariableDeclaration message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns VariableDeclaration
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.App.VariableDeclaration;

                        /**
                         * Creates a plain object from a VariableDeclaration message. Also converts values to other types if specified.
                         * @param message VariableDeclaration
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.App.VariableDeclaration, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this VariableDeclaration to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for VariableDeclaration
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** ToolExecutionMode enum. */
                    enum ToolExecutionMode {
                        TOOL_EXECUTION_MODE_UNSPECIFIED = 0,
                        PARALLEL = 1,
                        SEQUENTIAL = 2
                    }
                }

                /** Properties of a TimeZoneSettings. */
                interface ITimeZoneSettings {

                    /** TimeZoneSettings timeZone */
                    timeZone?: (string|null);
                }

                /** Represents a TimeZoneSettings. */
                class TimeZoneSettings implements ITimeZoneSettings {

                    /**
                     * Constructs a new TimeZoneSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ITimeZoneSettings);

                    /** TimeZoneSettings timeZone. */
                    public timeZone: string;

                    /**
                     * Creates a new TimeZoneSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TimeZoneSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ITimeZoneSettings): google.cloud.ces.v1beta.TimeZoneSettings;

                    /**
                     * Encodes the specified TimeZoneSettings message. Does not implicitly {@link google.cloud.ces.v1beta.TimeZoneSettings.verify|verify} messages.
                     * @param message TimeZoneSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ITimeZoneSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TimeZoneSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.TimeZoneSettings.verify|verify} messages.
                     * @param message TimeZoneSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ITimeZoneSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TimeZoneSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TimeZoneSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.TimeZoneSettings;

                    /**
                     * Decodes a TimeZoneSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TimeZoneSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.TimeZoneSettings;

                    /**
                     * Verifies a TimeZoneSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TimeZoneSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TimeZoneSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.TimeZoneSettings;

                    /**
                     * Creates a plain object from a TimeZoneSettings message. Also converts values to other types if specified.
                     * @param message TimeZoneSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.TimeZoneSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TimeZoneSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for TimeZoneSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a LanguageSettings. */
                interface ILanguageSettings {

                    /** LanguageSettings defaultLanguageCode */
                    defaultLanguageCode?: (string|null);

                    /** LanguageSettings supportedLanguageCodes */
                    supportedLanguageCodes?: (string[]|null);

                    /** LanguageSettings enableMultilingualSupport */
                    enableMultilingualSupport?: (boolean|null);

                    /** LanguageSettings fallbackAction */
                    fallbackAction?: (string|null);
                }

                /** Represents a LanguageSettings. */
                class LanguageSettings implements ILanguageSettings {

                    /**
                     * Constructs a new LanguageSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ILanguageSettings);

                    /** LanguageSettings defaultLanguageCode. */
                    public defaultLanguageCode: string;

                    /** LanguageSettings supportedLanguageCodes. */
                    public supportedLanguageCodes: string[];

                    /** LanguageSettings enableMultilingualSupport. */
                    public enableMultilingualSupport: boolean;

                    /** LanguageSettings fallbackAction. */
                    public fallbackAction: string;

                    /**
                     * Creates a new LanguageSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LanguageSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ILanguageSettings): google.cloud.ces.v1beta.LanguageSettings;

                    /**
                     * Encodes the specified LanguageSettings message. Does not implicitly {@link google.cloud.ces.v1beta.LanguageSettings.verify|verify} messages.
                     * @param message LanguageSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ILanguageSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LanguageSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.LanguageSettings.verify|verify} messages.
                     * @param message LanguageSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ILanguageSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LanguageSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LanguageSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.LanguageSettings;

                    /**
                     * Decodes a LanguageSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LanguageSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.LanguageSettings;

                    /**
                     * Verifies a LanguageSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LanguageSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LanguageSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.LanguageSettings;

                    /**
                     * Creates a plain object from a LanguageSettings message. Also converts values to other types if specified.
                     * @param message LanguageSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.LanguageSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LanguageSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for LanguageSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AudioProcessingConfig. */
                interface IAudioProcessingConfig {

                    /** AudioProcessingConfig synthesizeSpeechConfigs */
                    synthesizeSpeechConfigs?: ({ [k: string]: google.cloud.ces.v1beta.ISynthesizeSpeechConfig }|null);

                    /** AudioProcessingConfig bargeInConfig */
                    bargeInConfig?: (google.cloud.ces.v1beta.IBargeInConfig|null);

                    /** AudioProcessingConfig inactivityTimeout */
                    inactivityTimeout?: (google.protobuf.IDuration|null);

                    /** AudioProcessingConfig ambientSoundConfig */
                    ambientSoundConfig?: (google.cloud.ces.v1beta.IAmbientSoundConfig|null);
                }

                /** Represents an AudioProcessingConfig. */
                class AudioProcessingConfig implements IAudioProcessingConfig {

                    /**
                     * Constructs a new AudioProcessingConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IAudioProcessingConfig);

                    /** AudioProcessingConfig synthesizeSpeechConfigs. */
                    public synthesizeSpeechConfigs: { [k: string]: google.cloud.ces.v1beta.ISynthesizeSpeechConfig };

                    /** AudioProcessingConfig bargeInConfig. */
                    public bargeInConfig?: (google.cloud.ces.v1beta.IBargeInConfig|null);

                    /** AudioProcessingConfig inactivityTimeout. */
                    public inactivityTimeout?: (google.protobuf.IDuration|null);

                    /** AudioProcessingConfig ambientSoundConfig. */
                    public ambientSoundConfig?: (google.cloud.ces.v1beta.IAmbientSoundConfig|null);

                    /**
                     * Creates a new AudioProcessingConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AudioProcessingConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IAudioProcessingConfig): google.cloud.ces.v1beta.AudioProcessingConfig;

                    /**
                     * Encodes the specified AudioProcessingConfig message. Does not implicitly {@link google.cloud.ces.v1beta.AudioProcessingConfig.verify|verify} messages.
                     * @param message AudioProcessingConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IAudioProcessingConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AudioProcessingConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.AudioProcessingConfig.verify|verify} messages.
                     * @param message AudioProcessingConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IAudioProcessingConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AudioProcessingConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AudioProcessingConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.AudioProcessingConfig;

                    /**
                     * Decodes an AudioProcessingConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AudioProcessingConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.AudioProcessingConfig;

                    /**
                     * Verifies an AudioProcessingConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AudioProcessingConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AudioProcessingConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.AudioProcessingConfig;

                    /**
                     * Creates a plain object from an AudioProcessingConfig message. Also converts values to other types if specified.
                     * @param message AudioProcessingConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.AudioProcessingConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AudioProcessingConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AudioProcessingConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AmbientSoundConfig. */
                interface IAmbientSoundConfig {

                    /** AmbientSoundConfig prebuiltAmbientNoise */
                    prebuiltAmbientNoise?: (google.cloud.ces.v1beta.AmbientSoundConfig.PrebuiltAmbientNoise|keyof typeof google.cloud.ces.v1beta.AmbientSoundConfig.PrebuiltAmbientNoise|null);

                    /** AmbientSoundConfig gcsUri */
                    gcsUri?: (string|null);

                    /** AmbientSoundConfig prebuiltAmbientSound */
                    prebuiltAmbientSound?: (string|null);

                    /** AmbientSoundConfig volumeGainDb */
                    volumeGainDb?: (number|null);
                }

                /** Represents an AmbientSoundConfig. */
                class AmbientSoundConfig implements IAmbientSoundConfig {

                    /**
                     * Constructs a new AmbientSoundConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IAmbientSoundConfig);

                    /** AmbientSoundConfig prebuiltAmbientNoise. */
                    public prebuiltAmbientNoise?: (google.cloud.ces.v1beta.AmbientSoundConfig.PrebuiltAmbientNoise|keyof typeof google.cloud.ces.v1beta.AmbientSoundConfig.PrebuiltAmbientNoise|null);

                    /** AmbientSoundConfig gcsUri. */
                    public gcsUri?: (string|null);

                    /** AmbientSoundConfig prebuiltAmbientSound. */
                    public prebuiltAmbientSound?: (string|null);

                    /** AmbientSoundConfig volumeGainDb. */
                    public volumeGainDb: number;

                    /** AmbientSoundConfig source. */
                    public source?: ("prebuiltAmbientNoise"|"gcsUri"|"prebuiltAmbientSound");

                    /**
                     * Creates a new AmbientSoundConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AmbientSoundConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IAmbientSoundConfig): google.cloud.ces.v1beta.AmbientSoundConfig;

                    /**
                     * Encodes the specified AmbientSoundConfig message. Does not implicitly {@link google.cloud.ces.v1beta.AmbientSoundConfig.verify|verify} messages.
                     * @param message AmbientSoundConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IAmbientSoundConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AmbientSoundConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.AmbientSoundConfig.verify|verify} messages.
                     * @param message AmbientSoundConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IAmbientSoundConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AmbientSoundConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AmbientSoundConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.AmbientSoundConfig;

                    /**
                     * Decodes an AmbientSoundConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AmbientSoundConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.AmbientSoundConfig;

                    /**
                     * Verifies an AmbientSoundConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AmbientSoundConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AmbientSoundConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.AmbientSoundConfig;

                    /**
                     * Creates a plain object from an AmbientSoundConfig message. Also converts values to other types if specified.
                     * @param message AmbientSoundConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.AmbientSoundConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AmbientSoundConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AmbientSoundConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace AmbientSoundConfig {

                    /** PrebuiltAmbientNoise enum. */
                    enum PrebuiltAmbientNoise {
                        PREBUILT_AMBIENT_NOISE_UNSPECIFIED = 0,
                        RETAIL_STORE = 1,
                        CONVENTION_HALL = 2,
                        OUTDOOR = 3
                    }
                }

                /** Properties of a BargeInConfig. */
                interface IBargeInConfig {

                    /** BargeInConfig disableBargeIn */
                    disableBargeIn?: (boolean|null);

                    /** BargeInConfig bargeInAwareness */
                    bargeInAwareness?: (boolean|null);
                }

                /** Represents a BargeInConfig. */
                class BargeInConfig implements IBargeInConfig {

                    /**
                     * Constructs a new BargeInConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IBargeInConfig);

                    /** BargeInConfig disableBargeIn. */
                    public disableBargeIn: boolean;

                    /** BargeInConfig bargeInAwareness. */
                    public bargeInAwareness: boolean;

                    /**
                     * Creates a new BargeInConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BargeInConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IBargeInConfig): google.cloud.ces.v1beta.BargeInConfig;

                    /**
                     * Encodes the specified BargeInConfig message. Does not implicitly {@link google.cloud.ces.v1beta.BargeInConfig.verify|verify} messages.
                     * @param message BargeInConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IBargeInConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BargeInConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.BargeInConfig.verify|verify} messages.
                     * @param message BargeInConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IBargeInConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BargeInConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BargeInConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.BargeInConfig;

                    /**
                     * Decodes a BargeInConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BargeInConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.BargeInConfig;

                    /**
                     * Verifies a BargeInConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BargeInConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BargeInConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.BargeInConfig;

                    /**
                     * Creates a plain object from a BargeInConfig message. Also converts values to other types if specified.
                     * @param message BargeInConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.BargeInConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BargeInConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BargeInConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a SynthesizeSpeechConfig. */
                interface ISynthesizeSpeechConfig {

                    /** SynthesizeSpeechConfig voice */
                    voice?: (string|null);

                    /** SynthesizeSpeechConfig speakingRate */
                    speakingRate?: (number|null);
                }

                /** Represents a SynthesizeSpeechConfig. */
                class SynthesizeSpeechConfig implements ISynthesizeSpeechConfig {

                    /**
                     * Constructs a new SynthesizeSpeechConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ISynthesizeSpeechConfig);

                    /** SynthesizeSpeechConfig voice. */
                    public voice: string;

                    /** SynthesizeSpeechConfig speakingRate. */
                    public speakingRate: number;

                    /**
                     * Creates a new SynthesizeSpeechConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SynthesizeSpeechConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ISynthesizeSpeechConfig): google.cloud.ces.v1beta.SynthesizeSpeechConfig;

                    /**
                     * Encodes the specified SynthesizeSpeechConfig message. Does not implicitly {@link google.cloud.ces.v1beta.SynthesizeSpeechConfig.verify|verify} messages.
                     * @param message SynthesizeSpeechConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ISynthesizeSpeechConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SynthesizeSpeechConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.SynthesizeSpeechConfig.verify|verify} messages.
                     * @param message SynthesizeSpeechConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ISynthesizeSpeechConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SynthesizeSpeechConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SynthesizeSpeechConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.SynthesizeSpeechConfig;

                    /**
                     * Decodes a SynthesizeSpeechConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SynthesizeSpeechConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.SynthesizeSpeechConfig;

                    /**
                     * Verifies a SynthesizeSpeechConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SynthesizeSpeechConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SynthesizeSpeechConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.SynthesizeSpeechConfig;

                    /**
                     * Creates a plain object from a SynthesizeSpeechConfig message. Also converts values to other types if specified.
                     * @param message SynthesizeSpeechConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.SynthesizeSpeechConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SynthesizeSpeechConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for SynthesizeSpeechConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a LoggingSettings. */
                interface ILoggingSettings {

                    /** LoggingSettings redactionConfig */
                    redactionConfig?: (google.cloud.ces.v1beta.IRedactionConfig|null);

                    /** LoggingSettings audioRecordingConfig */
                    audioRecordingConfig?: (google.cloud.ces.v1beta.IAudioRecordingConfig|null);

                    /** LoggingSettings bigqueryExportSettings */
                    bigqueryExportSettings?: (google.cloud.ces.v1beta.IBigQueryExportSettings|null);

                    /** LoggingSettings cloudLoggingSettings */
                    cloudLoggingSettings?: (google.cloud.ces.v1beta.ICloudLoggingSettings|null);

                    /** LoggingSettings conversationLoggingSettings */
                    conversationLoggingSettings?: (google.cloud.ces.v1beta.IConversationLoggingSettings|null);

                    /** LoggingSettings evaluationAudioRecordingConfig */
                    evaluationAudioRecordingConfig?: (google.cloud.ces.v1beta.IAudioRecordingConfig|null);
                }

                /** Represents a LoggingSettings. */
                class LoggingSettings implements ILoggingSettings {

                    /**
                     * Constructs a new LoggingSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ILoggingSettings);

                    /** LoggingSettings redactionConfig. */
                    public redactionConfig?: (google.cloud.ces.v1beta.IRedactionConfig|null);

                    /** LoggingSettings audioRecordingConfig. */
                    public audioRecordingConfig?: (google.cloud.ces.v1beta.IAudioRecordingConfig|null);

                    /** LoggingSettings bigqueryExportSettings. */
                    public bigqueryExportSettings?: (google.cloud.ces.v1beta.IBigQueryExportSettings|null);

                    /** LoggingSettings cloudLoggingSettings. */
                    public cloudLoggingSettings?: (google.cloud.ces.v1beta.ICloudLoggingSettings|null);

                    /** LoggingSettings conversationLoggingSettings. */
                    public conversationLoggingSettings?: (google.cloud.ces.v1beta.IConversationLoggingSettings|null);

                    /** LoggingSettings evaluationAudioRecordingConfig. */
                    public evaluationAudioRecordingConfig?: (google.cloud.ces.v1beta.IAudioRecordingConfig|null);

                    /**
                     * Creates a new LoggingSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LoggingSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ILoggingSettings): google.cloud.ces.v1beta.LoggingSettings;

                    /**
                     * Encodes the specified LoggingSettings message. Does not implicitly {@link google.cloud.ces.v1beta.LoggingSettings.verify|verify} messages.
                     * @param message LoggingSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ILoggingSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LoggingSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.LoggingSettings.verify|verify} messages.
                     * @param message LoggingSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ILoggingSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LoggingSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LoggingSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.LoggingSettings;

                    /**
                     * Decodes a LoggingSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LoggingSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.LoggingSettings;

                    /**
                     * Verifies a LoggingSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LoggingSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LoggingSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.LoggingSettings;

                    /**
                     * Creates a plain object from a LoggingSettings message. Also converts values to other types if specified.
                     * @param message LoggingSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.LoggingSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LoggingSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for LoggingSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an EvaluationMetricsThresholds. */
                interface IEvaluationMetricsThresholds {

                    /** EvaluationMetricsThresholds goldenEvaluationMetricsThresholds */
                    goldenEvaluationMetricsThresholds?: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.IGoldenEvaluationMetricsThresholds|null);

                    /** EvaluationMetricsThresholds hallucinationMetricBehavior */
                    hallucinationMetricBehavior?: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior|keyof typeof google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior|null);

                    /** EvaluationMetricsThresholds goldenHallucinationMetricBehavior */
                    goldenHallucinationMetricBehavior?: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior|keyof typeof google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior|null);

                    /** EvaluationMetricsThresholds scenarioHallucinationMetricBehavior */
                    scenarioHallucinationMetricBehavior?: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior|keyof typeof google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior|null);
                }

                /** Represents an EvaluationMetricsThresholds. */
                class EvaluationMetricsThresholds implements IEvaluationMetricsThresholds {

                    /**
                     * Constructs a new EvaluationMetricsThresholds.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IEvaluationMetricsThresholds);

                    /** EvaluationMetricsThresholds goldenEvaluationMetricsThresholds. */
                    public goldenEvaluationMetricsThresholds?: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.IGoldenEvaluationMetricsThresholds|null);

                    /** EvaluationMetricsThresholds hallucinationMetricBehavior. */
                    public hallucinationMetricBehavior: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior|keyof typeof google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior);

                    /** EvaluationMetricsThresholds goldenHallucinationMetricBehavior. */
                    public goldenHallucinationMetricBehavior: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior|keyof typeof google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior);

                    /** EvaluationMetricsThresholds scenarioHallucinationMetricBehavior. */
                    public scenarioHallucinationMetricBehavior: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior|keyof typeof google.cloud.ces.v1beta.EvaluationMetricsThresholds.HallucinationMetricBehavior);

                    /**
                     * Creates a new EvaluationMetricsThresholds instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EvaluationMetricsThresholds instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IEvaluationMetricsThresholds): google.cloud.ces.v1beta.EvaluationMetricsThresholds;

                    /**
                     * Encodes the specified EvaluationMetricsThresholds message. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationMetricsThresholds.verify|verify} messages.
                     * @param message EvaluationMetricsThresholds message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IEvaluationMetricsThresholds, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EvaluationMetricsThresholds message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationMetricsThresholds.verify|verify} messages.
                     * @param message EvaluationMetricsThresholds message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IEvaluationMetricsThresholds, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EvaluationMetricsThresholds message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EvaluationMetricsThresholds
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EvaluationMetricsThresholds;

                    /**
                     * Decodes an EvaluationMetricsThresholds message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EvaluationMetricsThresholds
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EvaluationMetricsThresholds;

                    /**
                     * Verifies an EvaluationMetricsThresholds message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EvaluationMetricsThresholds message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EvaluationMetricsThresholds
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EvaluationMetricsThresholds;

                    /**
                     * Creates a plain object from an EvaluationMetricsThresholds message. Also converts values to other types if specified.
                     * @param message EvaluationMetricsThresholds
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EvaluationMetricsThresholds to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for EvaluationMetricsThresholds
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace EvaluationMetricsThresholds {

                    /** Properties of a GoldenEvaluationMetricsThresholds. */
                    interface IGoldenEvaluationMetricsThresholds {

                        /** GoldenEvaluationMetricsThresholds turnLevelMetricsThresholds */
                        turnLevelMetricsThresholds?: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ITurnLevelMetricsThresholds|null);

                        /** GoldenEvaluationMetricsThresholds expectationLevelMetricsThresholds */
                        expectationLevelMetricsThresholds?: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.IExpectationLevelMetricsThresholds|null);
                    }

                    /** Represents a GoldenEvaluationMetricsThresholds. */
                    class GoldenEvaluationMetricsThresholds implements IGoldenEvaluationMetricsThresholds {

                        /**
                         * Constructs a new GoldenEvaluationMetricsThresholds.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.EvaluationMetricsThresholds.IGoldenEvaluationMetricsThresholds);

                        /** GoldenEvaluationMetricsThresholds turnLevelMetricsThresholds. */
                        public turnLevelMetricsThresholds?: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ITurnLevelMetricsThresholds|null);

                        /** GoldenEvaluationMetricsThresholds expectationLevelMetricsThresholds. */
                        public expectationLevelMetricsThresholds?: (google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.IExpectationLevelMetricsThresholds|null);

                        /**
                         * Creates a new GoldenEvaluationMetricsThresholds instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GoldenEvaluationMetricsThresholds instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.EvaluationMetricsThresholds.IGoldenEvaluationMetricsThresholds): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds;

                        /**
                         * Encodes the specified GoldenEvaluationMetricsThresholds message. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.verify|verify} messages.
                         * @param message GoldenEvaluationMetricsThresholds message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds.IGoldenEvaluationMetricsThresholds, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GoldenEvaluationMetricsThresholds message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.verify|verify} messages.
                         * @param message GoldenEvaluationMetricsThresholds message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds.IGoldenEvaluationMetricsThresholds, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GoldenEvaluationMetricsThresholds message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GoldenEvaluationMetricsThresholds
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds;

                        /**
                         * Decodes a GoldenEvaluationMetricsThresholds message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GoldenEvaluationMetricsThresholds
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds;

                        /**
                         * Verifies a GoldenEvaluationMetricsThresholds message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GoldenEvaluationMetricsThresholds message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GoldenEvaluationMetricsThresholds
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds;

                        /**
                         * Creates a plain object from a GoldenEvaluationMetricsThresholds message. Also converts values to other types if specified.
                         * @param message GoldenEvaluationMetricsThresholds
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GoldenEvaluationMetricsThresholds to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for GoldenEvaluationMetricsThresholds
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace GoldenEvaluationMetricsThresholds {

                        /** Properties of a TurnLevelMetricsThresholds. */
                        interface ITurnLevelMetricsThresholds {

                            /** TurnLevelMetricsThresholds semanticSimilaritySuccessThreshold */
                            semanticSimilaritySuccessThreshold?: (number|null);

                            /** TurnLevelMetricsThresholds overallToolInvocationCorrectnessThreshold */
                            overallToolInvocationCorrectnessThreshold?: (number|null);
                        }

                        /** Represents a TurnLevelMetricsThresholds. */
                        class TurnLevelMetricsThresholds implements ITurnLevelMetricsThresholds {

                            /**
                             * Constructs a new TurnLevelMetricsThresholds.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ITurnLevelMetricsThresholds);

                            /** TurnLevelMetricsThresholds semanticSimilaritySuccessThreshold. */
                            public semanticSimilaritySuccessThreshold?: (number|null);

                            /** TurnLevelMetricsThresholds overallToolInvocationCorrectnessThreshold. */
                            public overallToolInvocationCorrectnessThreshold?: (number|null);

                            /**
                             * Creates a new TurnLevelMetricsThresholds instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TurnLevelMetricsThresholds instance
                             */
                            public static create(properties?: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ITurnLevelMetricsThresholds): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.TurnLevelMetricsThresholds;

                            /**
                             * Encodes the specified TurnLevelMetricsThresholds message. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.TurnLevelMetricsThresholds.verify|verify} messages.
                             * @param message TurnLevelMetricsThresholds message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ITurnLevelMetricsThresholds, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TurnLevelMetricsThresholds message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.TurnLevelMetricsThresholds.verify|verify} messages.
                             * @param message TurnLevelMetricsThresholds message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ITurnLevelMetricsThresholds, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TurnLevelMetricsThresholds message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TurnLevelMetricsThresholds
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.TurnLevelMetricsThresholds;

                            /**
                             * Decodes a TurnLevelMetricsThresholds message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TurnLevelMetricsThresholds
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.TurnLevelMetricsThresholds;

                            /**
                             * Verifies a TurnLevelMetricsThresholds message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TurnLevelMetricsThresholds message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TurnLevelMetricsThresholds
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.TurnLevelMetricsThresholds;

                            /**
                             * Creates a plain object from a TurnLevelMetricsThresholds message. Also converts values to other types if specified.
                             * @param message TurnLevelMetricsThresholds
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.TurnLevelMetricsThresholds, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TurnLevelMetricsThresholds to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };

                            /**
                             * Gets the default type url for TurnLevelMetricsThresholds
                             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns The default type url
                             */
                            public static getTypeUrl(typeUrlPrefix?: string): string;
                        }

                        /** Properties of an ExpectationLevelMetricsThresholds. */
                        interface IExpectationLevelMetricsThresholds {

                            /** ExpectationLevelMetricsThresholds toolInvocationParameterCorrectnessThreshold */
                            toolInvocationParameterCorrectnessThreshold?: (number|null);
                        }

                        /** Represents an ExpectationLevelMetricsThresholds. */
                        class ExpectationLevelMetricsThresholds implements IExpectationLevelMetricsThresholds {

                            /**
                             * Constructs a new ExpectationLevelMetricsThresholds.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.IExpectationLevelMetricsThresholds);

                            /** ExpectationLevelMetricsThresholds toolInvocationParameterCorrectnessThreshold. */
                            public toolInvocationParameterCorrectnessThreshold?: (number|null);

                            /**
                             * Creates a new ExpectationLevelMetricsThresholds instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns ExpectationLevelMetricsThresholds instance
                             */
                            public static create(properties?: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.IExpectationLevelMetricsThresholds): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ExpectationLevelMetricsThresholds;

                            /**
                             * Encodes the specified ExpectationLevelMetricsThresholds message. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ExpectationLevelMetricsThresholds.verify|verify} messages.
                             * @param message ExpectationLevelMetricsThresholds message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.IExpectationLevelMetricsThresholds, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified ExpectationLevelMetricsThresholds message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ExpectationLevelMetricsThresholds.verify|verify} messages.
                             * @param message ExpectationLevelMetricsThresholds message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.IExpectationLevelMetricsThresholds, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an ExpectationLevelMetricsThresholds message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns ExpectationLevelMetricsThresholds
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ExpectationLevelMetricsThresholds;

                            /**
                             * Decodes an ExpectationLevelMetricsThresholds message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns ExpectationLevelMetricsThresholds
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ExpectationLevelMetricsThresholds;

                            /**
                             * Verifies an ExpectationLevelMetricsThresholds message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an ExpectationLevelMetricsThresholds message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns ExpectationLevelMetricsThresholds
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ExpectationLevelMetricsThresholds;

                            /**
                             * Creates a plain object from an ExpectationLevelMetricsThresholds message. Also converts values to other types if specified.
                             * @param message ExpectationLevelMetricsThresholds
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.ces.v1beta.EvaluationMetricsThresholds.GoldenEvaluationMetricsThresholds.ExpectationLevelMetricsThresholds, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this ExpectationLevelMetricsThresholds to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };

                            /**
                             * Gets the default type url for ExpectationLevelMetricsThresholds
                             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns The default type url
                             */
                            public static getTypeUrl(typeUrlPrefix?: string): string;
                        }
                    }

                    /** HallucinationMetricBehavior enum. */
                    enum HallucinationMetricBehavior {
                        HALLUCINATION_METRIC_BEHAVIOR_UNSPECIFIED = 0,
                        DISABLED = 1,
                        ENABLED = 2
                    }
                }

                /** Properties of an EvaluationSettings. */
                interface IEvaluationSettings {

                    /** EvaluationSettings scenarioConversationInitiator */
                    scenarioConversationInitiator?: (google.cloud.ces.v1beta.EvaluationSettings.ScenarioConversationInitiator|keyof typeof google.cloud.ces.v1beta.EvaluationSettings.ScenarioConversationInitiator|null);
                }

                /** Represents an EvaluationSettings. */
                class EvaluationSettings implements IEvaluationSettings {

                    /**
                     * Constructs a new EvaluationSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IEvaluationSettings);

                    /** EvaluationSettings scenarioConversationInitiator. */
                    public scenarioConversationInitiator: (google.cloud.ces.v1beta.EvaluationSettings.ScenarioConversationInitiator|keyof typeof google.cloud.ces.v1beta.EvaluationSettings.ScenarioConversationInitiator);

                    /**
                     * Creates a new EvaluationSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EvaluationSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IEvaluationSettings): google.cloud.ces.v1beta.EvaluationSettings;

                    /**
                     * Encodes the specified EvaluationSettings message. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationSettings.verify|verify} messages.
                     * @param message EvaluationSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IEvaluationSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EvaluationSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationSettings.verify|verify} messages.
                     * @param message EvaluationSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IEvaluationSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EvaluationSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EvaluationSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EvaluationSettings;

                    /**
                     * Decodes an EvaluationSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EvaluationSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EvaluationSettings;

                    /**
                     * Verifies an EvaluationSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EvaluationSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EvaluationSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EvaluationSettings;

                    /**
                     * Creates a plain object from an EvaluationSettings message. Also converts values to other types if specified.
                     * @param message EvaluationSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.EvaluationSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EvaluationSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for EvaluationSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace EvaluationSettings {

                    /** ScenarioConversationInitiator enum. */
                    enum ScenarioConversationInitiator {
                        SCENARIO_CONVERSATION_INITIATOR_UNSPECIFIED = 0,
                        USER = 1,
                        AGENT = 2
                    }
                }

                /** Properties of a ClientCertificateSettings. */
                interface IClientCertificateSettings {

                    /** ClientCertificateSettings tlsCertificate */
                    tlsCertificate?: (string|null);

                    /** ClientCertificateSettings privateKey */
                    privateKey?: (string|null);

                    /** ClientCertificateSettings passphrase */
                    passphrase?: (string|null);
                }

                /** Represents a ClientCertificateSettings. */
                class ClientCertificateSettings implements IClientCertificateSettings {

                    /**
                     * Constructs a new ClientCertificateSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IClientCertificateSettings);

                    /** ClientCertificateSettings tlsCertificate. */
                    public tlsCertificate: string;

                    /** ClientCertificateSettings privateKey. */
                    public privateKey: string;

                    /** ClientCertificateSettings passphrase. */
                    public passphrase: string;

                    /**
                     * Creates a new ClientCertificateSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ClientCertificateSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IClientCertificateSettings): google.cloud.ces.v1beta.ClientCertificateSettings;

                    /**
                     * Encodes the specified ClientCertificateSettings message. Does not implicitly {@link google.cloud.ces.v1beta.ClientCertificateSettings.verify|verify} messages.
                     * @param message ClientCertificateSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IClientCertificateSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ClientCertificateSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ClientCertificateSettings.verify|verify} messages.
                     * @param message ClientCertificateSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IClientCertificateSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ClientCertificateSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ClientCertificateSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ClientCertificateSettings;

                    /**
                     * Decodes a ClientCertificateSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ClientCertificateSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ClientCertificateSettings;

                    /**
                     * Verifies a ClientCertificateSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ClientCertificateSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ClientCertificateSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ClientCertificateSettings;

                    /**
                     * Creates a plain object from a ClientCertificateSettings message. Also converts values to other types if specified.
                     * @param message ClientCertificateSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ClientCertificateSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ClientCertificateSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ClientCertificateSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ConversationLoggingSettings. */
                interface IConversationLoggingSettings {

                    /** ConversationLoggingSettings disableConversationLogging */
                    disableConversationLogging?: (boolean|null);
                }

                /** Represents a ConversationLoggingSettings. */
                class ConversationLoggingSettings implements IConversationLoggingSettings {

                    /**
                     * Constructs a new ConversationLoggingSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IConversationLoggingSettings);

                    /** ConversationLoggingSettings disableConversationLogging. */
                    public disableConversationLogging: boolean;

                    /**
                     * Creates a new ConversationLoggingSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ConversationLoggingSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IConversationLoggingSettings): google.cloud.ces.v1beta.ConversationLoggingSettings;

                    /**
                     * Encodes the specified ConversationLoggingSettings message. Does not implicitly {@link google.cloud.ces.v1beta.ConversationLoggingSettings.verify|verify} messages.
                     * @param message ConversationLoggingSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IConversationLoggingSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ConversationLoggingSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ConversationLoggingSettings.verify|verify} messages.
                     * @param message ConversationLoggingSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IConversationLoggingSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ConversationLoggingSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ConversationLoggingSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ConversationLoggingSettings;

                    /**
                     * Decodes a ConversationLoggingSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ConversationLoggingSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ConversationLoggingSettings;

                    /**
                     * Verifies a ConversationLoggingSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ConversationLoggingSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ConversationLoggingSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ConversationLoggingSettings;

                    /**
                     * Creates a plain object from a ConversationLoggingSettings message. Also converts values to other types if specified.
                     * @param message ConversationLoggingSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ConversationLoggingSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ConversationLoggingSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ConversationLoggingSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CloudLoggingSettings. */
                interface ICloudLoggingSettings {

                    /** CloudLoggingSettings enableCloudLogging */
                    enableCloudLogging?: (boolean|null);
                }

                /** Represents a CloudLoggingSettings. */
                class CloudLoggingSettings implements ICloudLoggingSettings {

                    /**
                     * Constructs a new CloudLoggingSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ICloudLoggingSettings);

                    /** CloudLoggingSettings enableCloudLogging. */
                    public enableCloudLogging: boolean;

                    /**
                     * Creates a new CloudLoggingSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CloudLoggingSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ICloudLoggingSettings): google.cloud.ces.v1beta.CloudLoggingSettings;

                    /**
                     * Encodes the specified CloudLoggingSettings message. Does not implicitly {@link google.cloud.ces.v1beta.CloudLoggingSettings.verify|verify} messages.
                     * @param message CloudLoggingSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ICloudLoggingSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CloudLoggingSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.CloudLoggingSettings.verify|verify} messages.
                     * @param message CloudLoggingSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ICloudLoggingSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CloudLoggingSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CloudLoggingSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.CloudLoggingSettings;

                    /**
                     * Decodes a CloudLoggingSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CloudLoggingSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.CloudLoggingSettings;

                    /**
                     * Verifies a CloudLoggingSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CloudLoggingSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CloudLoggingSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.CloudLoggingSettings;

                    /**
                     * Creates a plain object from a CloudLoggingSettings message. Also converts values to other types if specified.
                     * @param message CloudLoggingSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.CloudLoggingSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CloudLoggingSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CloudLoggingSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AudioRecordingConfig. */
                interface IAudioRecordingConfig {

                    /** AudioRecordingConfig gcsBucket */
                    gcsBucket?: (string|null);

                    /** AudioRecordingConfig gcsPathPrefix */
                    gcsPathPrefix?: (string|null);
                }

                /** Represents an AudioRecordingConfig. */
                class AudioRecordingConfig implements IAudioRecordingConfig {

                    /**
                     * Constructs a new AudioRecordingConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IAudioRecordingConfig);

                    /** AudioRecordingConfig gcsBucket. */
                    public gcsBucket: string;

                    /** AudioRecordingConfig gcsPathPrefix. */
                    public gcsPathPrefix: string;

                    /**
                     * Creates a new AudioRecordingConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AudioRecordingConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IAudioRecordingConfig): google.cloud.ces.v1beta.AudioRecordingConfig;

                    /**
                     * Encodes the specified AudioRecordingConfig message. Does not implicitly {@link google.cloud.ces.v1beta.AudioRecordingConfig.verify|verify} messages.
                     * @param message AudioRecordingConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IAudioRecordingConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AudioRecordingConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.AudioRecordingConfig.verify|verify} messages.
                     * @param message AudioRecordingConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IAudioRecordingConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AudioRecordingConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AudioRecordingConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.AudioRecordingConfig;

                    /**
                     * Decodes an AudioRecordingConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AudioRecordingConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.AudioRecordingConfig;

                    /**
                     * Verifies an AudioRecordingConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AudioRecordingConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AudioRecordingConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.AudioRecordingConfig;

                    /**
                     * Creates a plain object from an AudioRecordingConfig message. Also converts values to other types if specified.
                     * @param message AudioRecordingConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.AudioRecordingConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AudioRecordingConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AudioRecordingConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a RedactionConfig. */
                interface IRedactionConfig {

                    /** RedactionConfig enableRedaction */
                    enableRedaction?: (boolean|null);

                    /** RedactionConfig inspectTemplate */
                    inspectTemplate?: (string|null);

                    /** RedactionConfig deidentifyTemplate */
                    deidentifyTemplate?: (string|null);
                }

                /** Represents a RedactionConfig. */
                class RedactionConfig implements IRedactionConfig {

                    /**
                     * Constructs a new RedactionConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IRedactionConfig);

                    /** RedactionConfig enableRedaction. */
                    public enableRedaction: boolean;

                    /** RedactionConfig inspectTemplate. */
                    public inspectTemplate: string;

                    /** RedactionConfig deidentifyTemplate. */
                    public deidentifyTemplate: string;

                    /**
                     * Creates a new RedactionConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns RedactionConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IRedactionConfig): google.cloud.ces.v1beta.RedactionConfig;

                    /**
                     * Encodes the specified RedactionConfig message. Does not implicitly {@link google.cloud.ces.v1beta.RedactionConfig.verify|verify} messages.
                     * @param message RedactionConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IRedactionConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified RedactionConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.RedactionConfig.verify|verify} messages.
                     * @param message RedactionConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IRedactionConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a RedactionConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns RedactionConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.RedactionConfig;

                    /**
                     * Decodes a RedactionConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns RedactionConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.RedactionConfig;

                    /**
                     * Verifies a RedactionConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a RedactionConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns RedactionConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.RedactionConfig;

                    /**
                     * Creates a plain object from a RedactionConfig message. Also converts values to other types if specified.
                     * @param message RedactionConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.RedactionConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this RedactionConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for RedactionConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DataStoreSettings. */
                interface IDataStoreSettings {

                    /** DataStoreSettings engines */
                    engines?: (google.cloud.ces.v1beta.DataStoreSettings.IEngine[]|null);
                }

                /** Represents a DataStoreSettings. */
                class DataStoreSettings implements IDataStoreSettings {

                    /**
                     * Constructs a new DataStoreSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDataStoreSettings);

                    /** DataStoreSettings engines. */
                    public engines: google.cloud.ces.v1beta.DataStoreSettings.IEngine[];

                    /**
                     * Creates a new DataStoreSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DataStoreSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDataStoreSettings): google.cloud.ces.v1beta.DataStoreSettings;

                    /**
                     * Encodes the specified DataStoreSettings message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreSettings.verify|verify} messages.
                     * @param message DataStoreSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDataStoreSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DataStoreSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreSettings.verify|verify} messages.
                     * @param message DataStoreSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDataStoreSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DataStoreSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DataStoreSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreSettings;

                    /**
                     * Decodes a DataStoreSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DataStoreSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreSettings;

                    /**
                     * Verifies a DataStoreSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DataStoreSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DataStoreSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreSettings;

                    /**
                     * Creates a plain object from a DataStoreSettings message. Also converts values to other types if specified.
                     * @param message DataStoreSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DataStoreSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DataStoreSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DataStoreSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace DataStoreSettings {

                    /** Properties of an Engine. */
                    interface IEngine {

                        /** Engine name */
                        name?: (string|null);

                        /** Engine type */
                        type?: (google.cloud.ces.v1beta.DataStoreSettings.Engine.Type|keyof typeof google.cloud.ces.v1beta.DataStoreSettings.Engine.Type|null);
                    }

                    /** Represents an Engine. */
                    class Engine implements IEngine {

                        /**
                         * Constructs a new Engine.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.DataStoreSettings.IEngine);

                        /** Engine name. */
                        public name: string;

                        /** Engine type. */
                        public type: (google.cloud.ces.v1beta.DataStoreSettings.Engine.Type|keyof typeof google.cloud.ces.v1beta.DataStoreSettings.Engine.Type);

                        /**
                         * Creates a new Engine instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Engine instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.DataStoreSettings.IEngine): google.cloud.ces.v1beta.DataStoreSettings.Engine;

                        /**
                         * Encodes the specified Engine message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreSettings.Engine.verify|verify} messages.
                         * @param message Engine message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.DataStoreSettings.IEngine, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Engine message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreSettings.Engine.verify|verify} messages.
                         * @param message Engine message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.DataStoreSettings.IEngine, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an Engine message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Engine
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreSettings.Engine;

                        /**
                         * Decodes an Engine message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Engine
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreSettings.Engine;

                        /**
                         * Verifies an Engine message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an Engine message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Engine
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreSettings.Engine;

                        /**
                         * Creates a plain object from an Engine message. Also converts values to other types if specified.
                         * @param message Engine
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.DataStoreSettings.Engine, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Engine to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Engine
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace Engine {

                        /** Type enum. */
                        enum Type {
                            TYPE_UNSPECIFIED = 0,
                            ENGINE_TYPE_SEARCH = 1,
                            ENGINE_TYPE_CHAT = 2
                        }
                    }
                }

                /** Properties of an EvaluationPersona. */
                interface IEvaluationPersona {

                    /** EvaluationPersona name */
                    name?: (string|null);

                    /** EvaluationPersona description */
                    description?: (string|null);

                    /** EvaluationPersona displayName */
                    displayName?: (string|null);

                    /** EvaluationPersona personality */
                    personality?: (string|null);

                    /** EvaluationPersona speechConfig */
                    speechConfig?: (google.cloud.ces.v1beta.EvaluationPersona.ISpeechConfig|null);
                }

                /** Represents an EvaluationPersona. */
                class EvaluationPersona implements IEvaluationPersona {

                    /**
                     * Constructs a new EvaluationPersona.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IEvaluationPersona);

                    /** EvaluationPersona name. */
                    public name: string;

                    /** EvaluationPersona description. */
                    public description: string;

                    /** EvaluationPersona displayName. */
                    public displayName: string;

                    /** EvaluationPersona personality. */
                    public personality: string;

                    /** EvaluationPersona speechConfig. */
                    public speechConfig?: (google.cloud.ces.v1beta.EvaluationPersona.ISpeechConfig|null);

                    /**
                     * Creates a new EvaluationPersona instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EvaluationPersona instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IEvaluationPersona): google.cloud.ces.v1beta.EvaluationPersona;

                    /**
                     * Encodes the specified EvaluationPersona message. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationPersona.verify|verify} messages.
                     * @param message EvaluationPersona message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IEvaluationPersona, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EvaluationPersona message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationPersona.verify|verify} messages.
                     * @param message EvaluationPersona message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IEvaluationPersona, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EvaluationPersona message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EvaluationPersona
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EvaluationPersona;

                    /**
                     * Decodes an EvaluationPersona message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EvaluationPersona
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EvaluationPersona;

                    /**
                     * Verifies an EvaluationPersona message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EvaluationPersona message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EvaluationPersona
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EvaluationPersona;

                    /**
                     * Creates a plain object from an EvaluationPersona message. Also converts values to other types if specified.
                     * @param message EvaluationPersona
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.EvaluationPersona, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EvaluationPersona to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for EvaluationPersona
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace EvaluationPersona {

                    /** Properties of a SpeechConfig. */
                    interface ISpeechConfig {

                        /** SpeechConfig speakingRate */
                        speakingRate?: (number|null);

                        /** SpeechConfig environment */
                        environment?: (google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig.BackgroundEnvironment|keyof typeof google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig.BackgroundEnvironment|null);

                        /** SpeechConfig voiceId */
                        voiceId?: (string|null);
                    }

                    /** Represents a SpeechConfig. */
                    class SpeechConfig implements ISpeechConfig {

                        /**
                         * Constructs a new SpeechConfig.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.EvaluationPersona.ISpeechConfig);

                        /** SpeechConfig speakingRate. */
                        public speakingRate: number;

                        /** SpeechConfig environment. */
                        public environment: (google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig.BackgroundEnvironment|keyof typeof google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig.BackgroundEnvironment);

                        /** SpeechConfig voiceId. */
                        public voiceId: string;

                        /**
                         * Creates a new SpeechConfig instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns SpeechConfig instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.EvaluationPersona.ISpeechConfig): google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig;

                        /**
                         * Encodes the specified SpeechConfig message. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig.verify|verify} messages.
                         * @param message SpeechConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.EvaluationPersona.ISpeechConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified SpeechConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig.verify|verify} messages.
                         * @param message SpeechConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.EvaluationPersona.ISpeechConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a SpeechConfig message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns SpeechConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig;

                        /**
                         * Decodes a SpeechConfig message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns SpeechConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig;

                        /**
                         * Verifies a SpeechConfig message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a SpeechConfig message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns SpeechConfig
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig;

                        /**
                         * Creates a plain object from a SpeechConfig message. Also converts values to other types if specified.
                         * @param message SpeechConfig
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.EvaluationPersona.SpeechConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this SpeechConfig to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for SpeechConfig
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace SpeechConfig {

                        /** BackgroundEnvironment enum. */
                        enum BackgroundEnvironment {
                            BACKGROUND_ENVIRONMENT_UNSPECIFIED = 0,
                            CALL_CENTER = 3,
                            TRAFFIC = 4,
                            KIDS_NOISE = 5,
                            CAFE = 6
                        }
                    }
                }

                /** Properties of a BigQueryExportSettings. */
                interface IBigQueryExportSettings {

                    /** BigQueryExportSettings enabled */
                    enabled?: (boolean|null);

                    /** BigQueryExportSettings project */
                    project?: (string|null);

                    /** BigQueryExportSettings dataset */
                    dataset?: (string|null);
                }

                /** Represents a BigQueryExportSettings. */
                class BigQueryExportSettings implements IBigQueryExportSettings {

                    /**
                     * Constructs a new BigQueryExportSettings.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IBigQueryExportSettings);

                    /** BigQueryExportSettings enabled. */
                    public enabled: boolean;

                    /** BigQueryExportSettings project. */
                    public project: string;

                    /** BigQueryExportSettings dataset. */
                    public dataset: string;

                    /**
                     * Creates a new BigQueryExportSettings instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BigQueryExportSettings instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IBigQueryExportSettings): google.cloud.ces.v1beta.BigQueryExportSettings;

                    /**
                     * Encodes the specified BigQueryExportSettings message. Does not implicitly {@link google.cloud.ces.v1beta.BigQueryExportSettings.verify|verify} messages.
                     * @param message BigQueryExportSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IBigQueryExportSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BigQueryExportSettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.BigQueryExportSettings.verify|verify} messages.
                     * @param message BigQueryExportSettings message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IBigQueryExportSettings, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BigQueryExportSettings message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BigQueryExportSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.BigQueryExportSettings;

                    /**
                     * Decodes a BigQueryExportSettings message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BigQueryExportSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.BigQueryExportSettings;

                    /**
                     * Verifies a BigQueryExportSettings message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BigQueryExportSettings message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BigQueryExportSettings
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.BigQueryExportSettings;

                    /**
                     * Creates a plain object from a BigQueryExportSettings message. Also converts values to other types if specified.
                     * @param message BigQueryExportSettings
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.BigQueryExportSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BigQueryExportSettings to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BigQueryExportSettings
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Schema. */
                interface ISchema {

                    /** Schema type */
                    type?: (google.cloud.ces.v1beta.Schema.Type|keyof typeof google.cloud.ces.v1beta.Schema.Type|null);

                    /** Schema properties */
                    properties?: ({ [k: string]: google.cloud.ces.v1beta.ISchema }|null);

                    /** Schema required */
                    required?: (string[]|null);

                    /** Schema description */
                    description?: (string|null);

                    /** Schema items */
                    items?: (google.cloud.ces.v1beta.ISchema|null);

                    /** Schema nullable */
                    nullable?: (boolean|null);

                    /** Schema uniqueItems */
                    uniqueItems?: (boolean|null);

                    /** Schema prefixItems */
                    prefixItems?: (google.cloud.ces.v1beta.ISchema[]|null);

                    /** Schema additionalProperties */
                    additionalProperties?: (google.cloud.ces.v1beta.ISchema|null);

                    /** Schema anyOf */
                    anyOf?: (google.cloud.ces.v1beta.ISchema[]|null);

                    /** Schema enum */
                    "enum"?: (string[]|null);

                    /** Schema default */
                    "default"?: (google.protobuf.IValue|null);

                    /** Schema ref */
                    ref?: (string|null);

                    /** Schema defs */
                    defs?: ({ [k: string]: google.cloud.ces.v1beta.ISchema }|null);

                    /** Schema title */
                    title?: (string|null);

                    /** Schema minItems */
                    minItems?: (number|Long|string|null);

                    /** Schema maxItems */
                    maxItems?: (number|Long|string|null);

                    /** Schema minimum */
                    minimum?: (number|null);

                    /** Schema maximum */
                    maximum?: (number|null);
                }

                /** Represents a Schema. */
                class Schema implements ISchema {

                    /**
                     * Constructs a new Schema.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ISchema);

                    /** Schema type. */
                    public type: (google.cloud.ces.v1beta.Schema.Type|keyof typeof google.cloud.ces.v1beta.Schema.Type);

                    /** Schema properties. */
                    public properties: { [k: string]: google.cloud.ces.v1beta.ISchema };

                    /** Schema required. */
                    public required: string[];

                    /** Schema description. */
                    public description: string;

                    /** Schema items. */
                    public items?: (google.cloud.ces.v1beta.ISchema|null);

                    /** Schema nullable. */
                    public nullable: boolean;

                    /** Schema uniqueItems. */
                    public uniqueItems: boolean;

                    /** Schema prefixItems. */
                    public prefixItems: google.cloud.ces.v1beta.ISchema[];

                    /** Schema additionalProperties. */
                    public additionalProperties?: (google.cloud.ces.v1beta.ISchema|null);

                    /** Schema anyOf. */
                    public anyOf: google.cloud.ces.v1beta.ISchema[];

                    /** Schema enum. */
                    public enum: string[];

                    /** Schema default. */
                    public default?: (google.protobuf.IValue|null);

                    /** Schema ref. */
                    public ref: string;

                    /** Schema defs. */
                    public defs: { [k: string]: google.cloud.ces.v1beta.ISchema };

                    /** Schema title. */
                    public title: string;

                    /** Schema minItems. */
                    public minItems: (number|Long|string);

                    /** Schema maxItems. */
                    public maxItems: (number|Long|string);

                    /** Schema minimum. */
                    public minimum?: (number|null);

                    /** Schema maximum. */
                    public maximum?: (number|null);

                    /**
                     * Creates a new Schema instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Schema instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ISchema): google.cloud.ces.v1beta.Schema;

                    /**
                     * Encodes the specified Schema message. Does not implicitly {@link google.cloud.ces.v1beta.Schema.verify|verify} messages.
                     * @param message Schema message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ISchema, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Schema message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Schema.verify|verify} messages.
                     * @param message Schema message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ISchema, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Schema message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Schema
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Schema;

                    /**
                     * Decodes a Schema message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Schema
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Schema;

                    /**
                     * Verifies a Schema message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Schema message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Schema
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Schema;

                    /**
                     * Creates a plain object from a Schema message. Also converts values to other types if specified.
                     * @param message Schema
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Schema, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Schema to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Schema
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Schema {

                    /** Type enum. */
                    enum Type {
                        TYPE_UNSPECIFIED = 0,
                        STRING = 1,
                        INTEGER = 2,
                        NUMBER = 3,
                        BOOLEAN = 4,
                        OBJECT = 5,
                        ARRAY = 6
                    }
                }

                /** Properties of an AppSnapshot. */
                interface IAppSnapshot {

                    /** AppSnapshot app */
                    app?: (google.cloud.ces.v1beta.IApp|null);

                    /** AppSnapshot agents */
                    agents?: (google.cloud.ces.v1beta.IAgent[]|null);

                    /** AppSnapshot tools */
                    tools?: (google.cloud.ces.v1beta.ITool[]|null);

                    /** AppSnapshot examples */
                    examples?: (google.cloud.ces.v1beta.IExample[]|null);

                    /** AppSnapshot guardrails */
                    guardrails?: (google.cloud.ces.v1beta.IGuardrail[]|null);

                    /** AppSnapshot toolsets */
                    toolsets?: (google.cloud.ces.v1beta.IToolset[]|null);
                }

                /** Represents an AppSnapshot. */
                class AppSnapshot implements IAppSnapshot {

                    /**
                     * Constructs a new AppSnapshot.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IAppSnapshot);

                    /** AppSnapshot app. */
                    public app?: (google.cloud.ces.v1beta.IApp|null);

                    /** AppSnapshot agents. */
                    public agents: google.cloud.ces.v1beta.IAgent[];

                    /** AppSnapshot tools. */
                    public tools: google.cloud.ces.v1beta.ITool[];

                    /** AppSnapshot examples. */
                    public examples: google.cloud.ces.v1beta.IExample[];

                    /** AppSnapshot guardrails. */
                    public guardrails: google.cloud.ces.v1beta.IGuardrail[];

                    /** AppSnapshot toolsets. */
                    public toolsets: google.cloud.ces.v1beta.IToolset[];

                    /**
                     * Creates a new AppSnapshot instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AppSnapshot instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IAppSnapshot): google.cloud.ces.v1beta.AppSnapshot;

                    /**
                     * Encodes the specified AppSnapshot message. Does not implicitly {@link google.cloud.ces.v1beta.AppSnapshot.verify|verify} messages.
                     * @param message AppSnapshot message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IAppSnapshot, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AppSnapshot message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.AppSnapshot.verify|verify} messages.
                     * @param message AppSnapshot message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IAppSnapshot, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AppSnapshot message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AppSnapshot
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.AppSnapshot;

                    /**
                     * Decodes an AppSnapshot message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AppSnapshot
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.AppSnapshot;

                    /**
                     * Verifies an AppSnapshot message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AppSnapshot message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AppSnapshot
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.AppSnapshot;

                    /**
                     * Creates a plain object from an AppSnapshot message. Also converts values to other types if specified.
                     * @param message AppSnapshot
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.AppSnapshot, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AppSnapshot to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AppSnapshot
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AppVersion. */
                interface IAppVersion {

                    /** AppVersion name */
                    name?: (string|null);

                    /** AppVersion displayName */
                    displayName?: (string|null);

                    /** AppVersion description */
                    description?: (string|null);

                    /** AppVersion creator */
                    creator?: (string|null);

                    /** AppVersion createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** AppVersion snapshot */
                    snapshot?: (google.cloud.ces.v1beta.IAppSnapshot|null);

                    /** AppVersion etag */
                    etag?: (string|null);
                }

                /** Represents an AppVersion. */
                class AppVersion implements IAppVersion {

                    /**
                     * Constructs a new AppVersion.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IAppVersion);

                    /** AppVersion name. */
                    public name: string;

                    /** AppVersion displayName. */
                    public displayName: string;

                    /** AppVersion description. */
                    public description: string;

                    /** AppVersion creator. */
                    public creator: string;

                    /** AppVersion createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** AppVersion snapshot. */
                    public snapshot?: (google.cloud.ces.v1beta.IAppSnapshot|null);

                    /** AppVersion etag. */
                    public etag: string;

                    /**
                     * Creates a new AppVersion instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AppVersion instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IAppVersion): google.cloud.ces.v1beta.AppVersion;

                    /**
                     * Encodes the specified AppVersion message. Does not implicitly {@link google.cloud.ces.v1beta.AppVersion.verify|verify} messages.
                     * @param message AppVersion message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.AppVersion.verify|verify} messages.
                     * @param message AppVersion message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AppVersion message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AppVersion
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.AppVersion;

                    /**
                     * Decodes an AppVersion message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AppVersion
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.AppVersion;

                    /**
                     * Verifies an AppVersion message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AppVersion
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.AppVersion;

                    /**
                     * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
                     * @param message AppVersion
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.AppVersion, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AppVersion to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AppVersion
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an Example. */
                interface IExample {

                    /** Example name */
                    name?: (string|null);

                    /** Example displayName */
                    displayName?: (string|null);

                    /** Example description */
                    description?: (string|null);

                    /** Example entryAgent */
                    entryAgent?: (string|null);

                    /** Example messages */
                    messages?: (google.cloud.ces.v1beta.IMessage[]|null);

                    /** Example createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** Example updateTime */
                    updateTime?: (google.protobuf.ITimestamp|null);

                    /** Example invalid */
                    invalid?: (boolean|null);

                    /** Example etag */
                    etag?: (string|null);
                }

                /** Represents an Example. */
                class Example implements IExample {

                    /**
                     * Constructs a new Example.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IExample);

                    /** Example name. */
                    public name: string;

                    /** Example displayName. */
                    public displayName: string;

                    /** Example description. */
                    public description: string;

                    /** Example entryAgent. */
                    public entryAgent: string;

                    /** Example messages. */
                    public messages: google.cloud.ces.v1beta.IMessage[];

                    /** Example createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** Example updateTime. */
                    public updateTime?: (google.protobuf.ITimestamp|null);

                    /** Example invalid. */
                    public invalid: boolean;

                    /** Example etag. */
                    public etag: string;

                    /**
                     * Creates a new Example instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Example instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IExample): google.cloud.ces.v1beta.Example;

                    /**
                     * Encodes the specified Example message. Does not implicitly {@link google.cloud.ces.v1beta.Example.verify|verify} messages.
                     * @param message Example message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IExample, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Example message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Example.verify|verify} messages.
                     * @param message Example message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IExample, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an Example message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Example
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Example;

                    /**
                     * Decodes an Example message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Example
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Example;

                    /**
                     * Verifies an Example message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an Example message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Example
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Example;

                    /**
                     * Creates a plain object from an Example message. Also converts values to other types if specified.
                     * @param message Example
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Example, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Example to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Example
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Message. */
                interface IMessage {

                    /** Message role */
                    role?: (string|null);

                    /** Message chunks */
                    chunks?: (google.cloud.ces.v1beta.IChunk[]|null);

                    /** Message eventTime */
                    eventTime?: (google.protobuf.ITimestamp|null);
                }

                /** Represents a Message. */
                class Message implements IMessage {

                    /**
                     * Constructs a new Message.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IMessage);

                    /** Message role. */
                    public role: string;

                    /** Message chunks. */
                    public chunks: google.cloud.ces.v1beta.IChunk[];

                    /** Message eventTime. */
                    public eventTime?: (google.protobuf.ITimestamp|null);

                    /**
                     * Creates a new Message instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Message instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IMessage): google.cloud.ces.v1beta.Message;

                    /**
                     * Encodes the specified Message message. Does not implicitly {@link google.cloud.ces.v1beta.Message.verify|verify} messages.
                     * @param message Message message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Message message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Message.verify|verify} messages.
                     * @param message Message message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Message message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Message
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Message;

                    /**
                     * Decodes a Message message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Message
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Message;

                    /**
                     * Verifies a Message message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Message message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Message
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Message;

                    /**
                     * Creates a plain object from a Message message. Also converts values to other types if specified.
                     * @param message Message
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Message, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Message to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Message
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Chunk. */
                interface IChunk {

                    /** Chunk text */
                    text?: (string|null);

                    /** Chunk transcript */
                    transcript?: (string|null);

                    /** Chunk payload */
                    payload?: (google.protobuf.IStruct|null);

                    /** Chunk image */
                    image?: (google.cloud.ces.v1beta.IImage|null);

                    /** Chunk toolCall */
                    toolCall?: (google.cloud.ces.v1beta.IToolCall|null);

                    /** Chunk toolResponse */
                    toolResponse?: (google.cloud.ces.v1beta.IToolResponse|null);

                    /** Chunk agentTransfer */
                    agentTransfer?: (google.cloud.ces.v1beta.IAgentTransfer|null);

                    /** Chunk updatedVariables */
                    updatedVariables?: (google.protobuf.IStruct|null);

                    /** Chunk defaultVariables */
                    defaultVariables?: (google.protobuf.IStruct|null);
                }

                /** Represents a Chunk. */
                class Chunk implements IChunk {

                    /**
                     * Constructs a new Chunk.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IChunk);

                    /** Chunk text. */
                    public text?: (string|null);

                    /** Chunk transcript. */
                    public transcript?: (string|null);

                    /** Chunk payload. */
                    public payload?: (google.protobuf.IStruct|null);

                    /** Chunk image. */
                    public image?: (google.cloud.ces.v1beta.IImage|null);

                    /** Chunk toolCall. */
                    public toolCall?: (google.cloud.ces.v1beta.IToolCall|null);

                    /** Chunk toolResponse. */
                    public toolResponse?: (google.cloud.ces.v1beta.IToolResponse|null);

                    /** Chunk agentTransfer. */
                    public agentTransfer?: (google.cloud.ces.v1beta.IAgentTransfer|null);

                    /** Chunk updatedVariables. */
                    public updatedVariables?: (google.protobuf.IStruct|null);

                    /** Chunk defaultVariables. */
                    public defaultVariables?: (google.protobuf.IStruct|null);

                    /** Chunk data. */
                    public data?: ("text"|"transcript"|"payload"|"image"|"toolCall"|"toolResponse"|"agentTransfer"|"updatedVariables"|"defaultVariables");

                    /**
                     * Creates a new Chunk instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Chunk instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IChunk): google.cloud.ces.v1beta.Chunk;

                    /**
                     * Encodes the specified Chunk message. Does not implicitly {@link google.cloud.ces.v1beta.Chunk.verify|verify} messages.
                     * @param message Chunk message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IChunk, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Chunk message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Chunk.verify|verify} messages.
                     * @param message Chunk message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IChunk, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Chunk message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Chunk
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Chunk;

                    /**
                     * Decodes a Chunk message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Chunk
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Chunk;

                    /**
                     * Verifies a Chunk message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Chunk message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Chunk
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Chunk;

                    /**
                     * Creates a plain object from a Chunk message. Also converts values to other types if specified.
                     * @param message Chunk
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Chunk, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Chunk to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Chunk
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Blob. */
                interface IBlob {

                    /** Blob mimeType */
                    mimeType?: (string|null);

                    /** Blob data */
                    data?: (Uint8Array|Buffer|string|null);
                }

                /** Represents a Blob. */
                class Blob implements IBlob {

                    /**
                     * Constructs a new Blob.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IBlob);

                    /** Blob mimeType. */
                    public mimeType: string;

                    /** Blob data. */
                    public data: (Uint8Array|Buffer|string);

                    /**
                     * Creates a new Blob instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Blob instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IBlob): google.cloud.ces.v1beta.Blob;

                    /**
                     * Encodes the specified Blob message. Does not implicitly {@link google.cloud.ces.v1beta.Blob.verify|verify} messages.
                     * @param message Blob message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IBlob, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Blob message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Blob.verify|verify} messages.
                     * @param message Blob message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IBlob, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Blob message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Blob
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Blob;

                    /**
                     * Decodes a Blob message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Blob
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Blob;

                    /**
                     * Verifies a Blob message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Blob message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Blob
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Blob;

                    /**
                     * Creates a plain object from a Blob message. Also converts values to other types if specified.
                     * @param message Blob
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Blob, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Blob to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Blob
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an Image. */
                interface IImage {

                    /** Image mimeType */
                    mimeType?: (string|null);

                    /** Image data */
                    data?: (Uint8Array|Buffer|string|null);
                }

                /** Represents an Image. */
                class Image implements IImage {

                    /**
                     * Constructs a new Image.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IImage);

                    /** Image mimeType. */
                    public mimeType: string;

                    /** Image data. */
                    public data: (Uint8Array|Buffer|string);

                    /**
                     * Creates a new Image instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Image instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IImage): google.cloud.ces.v1beta.Image;

                    /**
                     * Encodes the specified Image message. Does not implicitly {@link google.cloud.ces.v1beta.Image.verify|verify} messages.
                     * @param message Image message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Image message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Image.verify|verify} messages.
                     * @param message Image message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an Image message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Image
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Image;

                    /**
                     * Decodes an Image message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Image
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Image;

                    /**
                     * Verifies an Image message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an Image message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Image
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Image;

                    /**
                     * Creates a plain object from an Image message. Also converts values to other types if specified.
                     * @param message Image
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Image, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Image to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Image
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ToolCall. */
                interface IToolCall {

                    /** ToolCall tool */
                    tool?: (string|null);

                    /** ToolCall toolsetTool */
                    toolsetTool?: (google.cloud.ces.v1beta.IToolsetTool|null);

                    /** ToolCall id */
                    id?: (string|null);

                    /** ToolCall displayName */
                    displayName?: (string|null);

                    /** ToolCall args */
                    args?: (google.protobuf.IStruct|null);
                }

                /** Represents a ToolCall. */
                class ToolCall implements IToolCall {

                    /**
                     * Constructs a new ToolCall.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IToolCall);

                    /** ToolCall tool. */
                    public tool?: (string|null);

                    /** ToolCall toolsetTool. */
                    public toolsetTool?: (google.cloud.ces.v1beta.IToolsetTool|null);

                    /** ToolCall id. */
                    public id: string;

                    /** ToolCall displayName. */
                    public displayName: string;

                    /** ToolCall args. */
                    public args?: (google.protobuf.IStruct|null);

                    /** ToolCall toolIdentifier. */
                    public toolIdentifier?: ("tool"|"toolsetTool");

                    /**
                     * Creates a new ToolCall instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ToolCall instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IToolCall): google.cloud.ces.v1beta.ToolCall;

                    /**
                     * Encodes the specified ToolCall message. Does not implicitly {@link google.cloud.ces.v1beta.ToolCall.verify|verify} messages.
                     * @param message ToolCall message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IToolCall, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ToolCall message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ToolCall.verify|verify} messages.
                     * @param message ToolCall message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IToolCall, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ToolCall message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ToolCall
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ToolCall;

                    /**
                     * Decodes a ToolCall message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ToolCall
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ToolCall;

                    /**
                     * Verifies a ToolCall message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ToolCall message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ToolCall
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ToolCall;

                    /**
                     * Creates a plain object from a ToolCall message. Also converts values to other types if specified.
                     * @param message ToolCall
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ToolCall, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ToolCall to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ToolCall
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ToolResponse. */
                interface IToolResponse {

                    /** ToolResponse tool */
                    tool?: (string|null);

                    /** ToolResponse toolsetTool */
                    toolsetTool?: (google.cloud.ces.v1beta.IToolsetTool|null);

                    /** ToolResponse id */
                    id?: (string|null);

                    /** ToolResponse displayName */
                    displayName?: (string|null);

                    /** ToolResponse response */
                    response?: (google.protobuf.IStruct|null);
                }

                /** Represents a ToolResponse. */
                class ToolResponse implements IToolResponse {

                    /**
                     * Constructs a new ToolResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IToolResponse);

                    /** ToolResponse tool. */
                    public tool?: (string|null);

                    /** ToolResponse toolsetTool. */
                    public toolsetTool?: (google.cloud.ces.v1beta.IToolsetTool|null);

                    /** ToolResponse id. */
                    public id: string;

                    /** ToolResponse displayName. */
                    public displayName: string;

                    /** ToolResponse response. */
                    public response?: (google.protobuf.IStruct|null);

                    /** ToolResponse toolIdentifier. */
                    public toolIdentifier?: ("tool"|"toolsetTool");

                    /**
                     * Creates a new ToolResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ToolResponse instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IToolResponse): google.cloud.ces.v1beta.ToolResponse;

                    /**
                     * Encodes the specified ToolResponse message. Does not implicitly {@link google.cloud.ces.v1beta.ToolResponse.verify|verify} messages.
                     * @param message ToolResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IToolResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ToolResponse message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ToolResponse.verify|verify} messages.
                     * @param message ToolResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IToolResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ToolResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ToolResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ToolResponse;

                    /**
                     * Decodes a ToolResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ToolResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ToolResponse;

                    /**
                     * Verifies a ToolResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ToolResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ToolResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ToolResponse;

                    /**
                     * Creates a plain object from a ToolResponse message. Also converts values to other types if specified.
                     * @param message ToolResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ToolResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ToolResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ToolResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AgentTransfer. */
                interface IAgentTransfer {

                    /** AgentTransfer targetAgent */
                    targetAgent?: (string|null);

                    /** AgentTransfer displayName */
                    displayName?: (string|null);
                }

                /** Represents an AgentTransfer. */
                class AgentTransfer implements IAgentTransfer {

                    /**
                     * Constructs a new AgentTransfer.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IAgentTransfer);

                    /** AgentTransfer targetAgent. */
                    public targetAgent: string;

                    /** AgentTransfer displayName. */
                    public displayName: string;

                    /**
                     * Creates a new AgentTransfer instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AgentTransfer instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IAgentTransfer): google.cloud.ces.v1beta.AgentTransfer;

                    /**
                     * Encodes the specified AgentTransfer message. Does not implicitly {@link google.cloud.ces.v1beta.AgentTransfer.verify|verify} messages.
                     * @param message AgentTransfer message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IAgentTransfer, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AgentTransfer message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.AgentTransfer.verify|verify} messages.
                     * @param message AgentTransfer message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IAgentTransfer, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AgentTransfer message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AgentTransfer
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.AgentTransfer;

                    /**
                     * Decodes an AgentTransfer message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AgentTransfer
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.AgentTransfer;

                    /**
                     * Verifies an AgentTransfer message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AgentTransfer message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AgentTransfer
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.AgentTransfer;

                    /**
                     * Creates a plain object from an AgentTransfer message. Also converts values to other types if specified.
                     * @param message AgentTransfer
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.AgentTransfer, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AgentTransfer to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AgentTransfer
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ToolsetTool. */
                interface IToolsetTool {

                    /** ToolsetTool toolset */
                    toolset?: (string|null);

                    /** ToolsetTool toolId */
                    toolId?: (string|null);
                }

                /** Represents a ToolsetTool. */
                class ToolsetTool implements IToolsetTool {

                    /**
                     * Constructs a new ToolsetTool.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IToolsetTool);

                    /** ToolsetTool toolset. */
                    public toolset: string;

                    /** ToolsetTool toolId. */
                    public toolId: string;

                    /**
                     * Creates a new ToolsetTool instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ToolsetTool instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IToolsetTool): google.cloud.ces.v1beta.ToolsetTool;

                    /**
                     * Encodes the specified ToolsetTool message. Does not implicitly {@link google.cloud.ces.v1beta.ToolsetTool.verify|verify} messages.
                     * @param message ToolsetTool message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IToolsetTool, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ToolsetTool message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ToolsetTool.verify|verify} messages.
                     * @param message ToolsetTool message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IToolsetTool, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ToolsetTool message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ToolsetTool
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ToolsetTool;

                    /**
                     * Decodes a ToolsetTool message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ToolsetTool
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ToolsetTool;

                    /**
                     * Verifies a ToolsetTool message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ToolsetTool message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ToolsetTool
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ToolsetTool;

                    /**
                     * Creates a plain object from a ToolsetTool message. Also converts values to other types if specified.
                     * @param message ToolsetTool
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ToolsetTool, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ToolsetTool to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ToolsetTool
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Guardrail. */
                interface IGuardrail {

                    /** Guardrail contentFilter */
                    contentFilter?: (google.cloud.ces.v1beta.Guardrail.IContentFilter|null);

                    /** Guardrail llmPromptSecurity */
                    llmPromptSecurity?: (google.cloud.ces.v1beta.Guardrail.ILlmPromptSecurity|null);

                    /** Guardrail llmPolicy */
                    llmPolicy?: (google.cloud.ces.v1beta.Guardrail.ILlmPolicy|null);

                    /** Guardrail modelSafety */
                    modelSafety?: (google.cloud.ces.v1beta.Guardrail.IModelSafety|null);

                    /** Guardrail codeCallback */
                    codeCallback?: (google.cloud.ces.v1beta.Guardrail.ICodeCallback|null);

                    /** Guardrail name */
                    name?: (string|null);

                    /** Guardrail displayName */
                    displayName?: (string|null);

                    /** Guardrail description */
                    description?: (string|null);

                    /** Guardrail enabled */
                    enabled?: (boolean|null);

                    /** Guardrail action */
                    action?: (google.cloud.ces.v1beta.ITriggerAction|null);

                    /** Guardrail createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** Guardrail updateTime */
                    updateTime?: (google.protobuf.ITimestamp|null);

                    /** Guardrail etag */
                    etag?: (string|null);
                }

                /** Represents a Guardrail. */
                class Guardrail implements IGuardrail {

                    /**
                     * Constructs a new Guardrail.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IGuardrail);

                    /** Guardrail contentFilter. */
                    public contentFilter?: (google.cloud.ces.v1beta.Guardrail.IContentFilter|null);

                    /** Guardrail llmPromptSecurity. */
                    public llmPromptSecurity?: (google.cloud.ces.v1beta.Guardrail.ILlmPromptSecurity|null);

                    /** Guardrail llmPolicy. */
                    public llmPolicy?: (google.cloud.ces.v1beta.Guardrail.ILlmPolicy|null);

                    /** Guardrail modelSafety. */
                    public modelSafety?: (google.cloud.ces.v1beta.Guardrail.IModelSafety|null);

                    /** Guardrail codeCallback. */
                    public codeCallback?: (google.cloud.ces.v1beta.Guardrail.ICodeCallback|null);

                    /** Guardrail name. */
                    public name: string;

                    /** Guardrail displayName. */
                    public displayName: string;

                    /** Guardrail description. */
                    public description: string;

                    /** Guardrail enabled. */
                    public enabled: boolean;

                    /** Guardrail action. */
                    public action?: (google.cloud.ces.v1beta.ITriggerAction|null);

                    /** Guardrail createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** Guardrail updateTime. */
                    public updateTime?: (google.protobuf.ITimestamp|null);

                    /** Guardrail etag. */
                    public etag: string;

                    /** Guardrail guardrailType. */
                    public guardrailType?: ("contentFilter"|"llmPromptSecurity"|"llmPolicy"|"modelSafety"|"codeCallback");

                    /**
                     * Creates a new Guardrail instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Guardrail instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IGuardrail): google.cloud.ces.v1beta.Guardrail;

                    /**
                     * Encodes the specified Guardrail message. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.verify|verify} messages.
                     * @param message Guardrail message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IGuardrail, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Guardrail message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.verify|verify} messages.
                     * @param message Guardrail message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IGuardrail, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Guardrail message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Guardrail
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Guardrail;

                    /**
                     * Decodes a Guardrail message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Guardrail
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Guardrail;

                    /**
                     * Verifies a Guardrail message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Guardrail message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Guardrail
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Guardrail;

                    /**
                     * Creates a plain object from a Guardrail message. Also converts values to other types if specified.
                     * @param message Guardrail
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Guardrail, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Guardrail to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Guardrail
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Guardrail {

                    /** Properties of a ContentFilter. */
                    interface IContentFilter {

                        /** ContentFilter bannedContents */
                        bannedContents?: (string[]|null);

                        /** ContentFilter bannedContentsInUserInput */
                        bannedContentsInUserInput?: (string[]|null);

                        /** ContentFilter bannedContentsInAgentResponse */
                        bannedContentsInAgentResponse?: (string[]|null);

                        /** ContentFilter matchType */
                        matchType?: (google.cloud.ces.v1beta.Guardrail.ContentFilter.MatchType|keyof typeof google.cloud.ces.v1beta.Guardrail.ContentFilter.MatchType|null);

                        /** ContentFilter disregardDiacritics */
                        disregardDiacritics?: (boolean|null);
                    }

                    /** Represents a ContentFilter. */
                    class ContentFilter implements IContentFilter {

                        /**
                         * Constructs a new ContentFilter.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.Guardrail.IContentFilter);

                        /** ContentFilter bannedContents. */
                        public bannedContents: string[];

                        /** ContentFilter bannedContentsInUserInput. */
                        public bannedContentsInUserInput: string[];

                        /** ContentFilter bannedContentsInAgentResponse. */
                        public bannedContentsInAgentResponse: string[];

                        /** ContentFilter matchType. */
                        public matchType: (google.cloud.ces.v1beta.Guardrail.ContentFilter.MatchType|keyof typeof google.cloud.ces.v1beta.Guardrail.ContentFilter.MatchType);

                        /** ContentFilter disregardDiacritics. */
                        public disregardDiacritics: boolean;

                        /**
                         * Creates a new ContentFilter instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ContentFilter instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.Guardrail.IContentFilter): google.cloud.ces.v1beta.Guardrail.ContentFilter;

                        /**
                         * Encodes the specified ContentFilter message. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.ContentFilter.verify|verify} messages.
                         * @param message ContentFilter message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.Guardrail.IContentFilter, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ContentFilter message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.ContentFilter.verify|verify} messages.
                         * @param message ContentFilter message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.Guardrail.IContentFilter, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ContentFilter message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ContentFilter
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Guardrail.ContentFilter;

                        /**
                         * Decodes a ContentFilter message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ContentFilter
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Guardrail.ContentFilter;

                        /**
                         * Verifies a ContentFilter message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ContentFilter message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ContentFilter
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Guardrail.ContentFilter;

                        /**
                         * Creates a plain object from a ContentFilter message. Also converts values to other types if specified.
                         * @param message ContentFilter
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.Guardrail.ContentFilter, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ContentFilter to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for ContentFilter
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace ContentFilter {

                        /** MatchType enum. */
                        enum MatchType {
                            MATCH_TYPE_UNSPECIFIED = 0,
                            SIMPLE_STRING_MATCH = 1,
                            WORD_BOUNDARY_STRING_MATCH = 2,
                            REGEXP_MATCH = 3
                        }
                    }

                    /** Properties of a LlmPromptSecurity. */
                    interface ILlmPromptSecurity {

                        /** LlmPromptSecurity defaultSettings */
                        defaultSettings?: (google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.IDefaultSecuritySettings|null);

                        /** LlmPromptSecurity customPolicy */
                        customPolicy?: (google.cloud.ces.v1beta.Guardrail.ILlmPolicy|null);

                        /** LlmPromptSecurity failOpen */
                        failOpen?: (boolean|null);
                    }

                    /** Represents a LlmPromptSecurity. */
                    class LlmPromptSecurity implements ILlmPromptSecurity {

                        /**
                         * Constructs a new LlmPromptSecurity.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.Guardrail.ILlmPromptSecurity);

                        /** LlmPromptSecurity defaultSettings. */
                        public defaultSettings?: (google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.IDefaultSecuritySettings|null);

                        /** LlmPromptSecurity customPolicy. */
                        public customPolicy?: (google.cloud.ces.v1beta.Guardrail.ILlmPolicy|null);

                        /** LlmPromptSecurity failOpen. */
                        public failOpen: boolean;

                        /** LlmPromptSecurity securityConfig. */
                        public securityConfig?: ("defaultSettings"|"customPolicy");

                        /**
                         * Creates a new LlmPromptSecurity instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns LlmPromptSecurity instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.Guardrail.ILlmPromptSecurity): google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity;

                        /**
                         * Encodes the specified LlmPromptSecurity message. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.verify|verify} messages.
                         * @param message LlmPromptSecurity message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.Guardrail.ILlmPromptSecurity, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified LlmPromptSecurity message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.verify|verify} messages.
                         * @param message LlmPromptSecurity message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.Guardrail.ILlmPromptSecurity, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a LlmPromptSecurity message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns LlmPromptSecurity
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity;

                        /**
                         * Decodes a LlmPromptSecurity message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns LlmPromptSecurity
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity;

                        /**
                         * Verifies a LlmPromptSecurity message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a LlmPromptSecurity message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns LlmPromptSecurity
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity;

                        /**
                         * Creates a plain object from a LlmPromptSecurity message. Also converts values to other types if specified.
                         * @param message LlmPromptSecurity
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this LlmPromptSecurity to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for LlmPromptSecurity
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace LlmPromptSecurity {

                        /** Properties of a DefaultSecuritySettings. */
                        interface IDefaultSecuritySettings {

                            /** DefaultSecuritySettings defaultPromptTemplate */
                            defaultPromptTemplate?: (string|null);
                        }

                        /** Represents a DefaultSecuritySettings. */
                        class DefaultSecuritySettings implements IDefaultSecuritySettings {

                            /**
                             * Constructs a new DefaultSecuritySettings.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.IDefaultSecuritySettings);

                            /** DefaultSecuritySettings defaultPromptTemplate. */
                            public defaultPromptTemplate: string;

                            /**
                             * Creates a new DefaultSecuritySettings instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DefaultSecuritySettings instance
                             */
                            public static create(properties?: google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.IDefaultSecuritySettings): google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.DefaultSecuritySettings;

                            /**
                             * Encodes the specified DefaultSecuritySettings message. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.DefaultSecuritySettings.verify|verify} messages.
                             * @param message DefaultSecuritySettings message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.IDefaultSecuritySettings, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DefaultSecuritySettings message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.DefaultSecuritySettings.verify|verify} messages.
                             * @param message DefaultSecuritySettings message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.IDefaultSecuritySettings, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DefaultSecuritySettings message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DefaultSecuritySettings
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.DefaultSecuritySettings;

                            /**
                             * Decodes a DefaultSecuritySettings message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DefaultSecuritySettings
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.DefaultSecuritySettings;

                            /**
                             * Verifies a DefaultSecuritySettings message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DefaultSecuritySettings message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DefaultSecuritySettings
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.DefaultSecuritySettings;

                            /**
                             * Creates a plain object from a DefaultSecuritySettings message. Also converts values to other types if specified.
                             * @param message DefaultSecuritySettings
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.ces.v1beta.Guardrail.LlmPromptSecurity.DefaultSecuritySettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DefaultSecuritySettings to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };

                            /**
                             * Gets the default type url for DefaultSecuritySettings
                             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns The default type url
                             */
                            public static getTypeUrl(typeUrlPrefix?: string): string;
                        }
                    }

                    /** Properties of a LlmPolicy. */
                    interface ILlmPolicy {

                        /** LlmPolicy maxConversationMessages */
                        maxConversationMessages?: (number|null);

                        /** LlmPolicy modelSettings */
                        modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                        /** LlmPolicy prompt */
                        prompt?: (string|null);

                        /** LlmPolicy policyScope */
                        policyScope?: (google.cloud.ces.v1beta.Guardrail.LlmPolicy.PolicyScope|keyof typeof google.cloud.ces.v1beta.Guardrail.LlmPolicy.PolicyScope|null);

                        /** LlmPolicy failOpen */
                        failOpen?: (boolean|null);

                        /** LlmPolicy allowShortUtterance */
                        allowShortUtterance?: (boolean|null);
                    }

                    /** Represents a LlmPolicy. */
                    class LlmPolicy implements ILlmPolicy {

                        /**
                         * Constructs a new LlmPolicy.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.Guardrail.ILlmPolicy);

                        /** LlmPolicy maxConversationMessages. */
                        public maxConversationMessages: number;

                        /** LlmPolicy modelSettings. */
                        public modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                        /** LlmPolicy prompt. */
                        public prompt: string;

                        /** LlmPolicy policyScope. */
                        public policyScope: (google.cloud.ces.v1beta.Guardrail.LlmPolicy.PolicyScope|keyof typeof google.cloud.ces.v1beta.Guardrail.LlmPolicy.PolicyScope);

                        /** LlmPolicy failOpen. */
                        public failOpen: boolean;

                        /** LlmPolicy allowShortUtterance. */
                        public allowShortUtterance: boolean;

                        /**
                         * Creates a new LlmPolicy instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns LlmPolicy instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.Guardrail.ILlmPolicy): google.cloud.ces.v1beta.Guardrail.LlmPolicy;

                        /**
                         * Encodes the specified LlmPolicy message. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.LlmPolicy.verify|verify} messages.
                         * @param message LlmPolicy message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.Guardrail.ILlmPolicy, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified LlmPolicy message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.LlmPolicy.verify|verify} messages.
                         * @param message LlmPolicy message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.Guardrail.ILlmPolicy, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a LlmPolicy message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns LlmPolicy
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Guardrail.LlmPolicy;

                        /**
                         * Decodes a LlmPolicy message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns LlmPolicy
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Guardrail.LlmPolicy;

                        /**
                         * Verifies a LlmPolicy message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a LlmPolicy message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns LlmPolicy
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Guardrail.LlmPolicy;

                        /**
                         * Creates a plain object from a LlmPolicy message. Also converts values to other types if specified.
                         * @param message LlmPolicy
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.Guardrail.LlmPolicy, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this LlmPolicy to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for LlmPolicy
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace LlmPolicy {

                        /** PolicyScope enum. */
                        enum PolicyScope {
                            POLICY_SCOPE_UNSPECIFIED = 0,
                            USER_QUERY = 1,
                            AGENT_RESPONSE = 2,
                            USER_QUERY_AND_AGENT_RESPONSE = 3
                        }
                    }

                    /** Properties of a ModelSafety. */
                    interface IModelSafety {

                        /** ModelSafety safetySettings */
                        safetySettings?: (google.cloud.ces.v1beta.Guardrail.ModelSafety.ISafetySetting[]|null);
                    }

                    /** Represents a ModelSafety. */
                    class ModelSafety implements IModelSafety {

                        /**
                         * Constructs a new ModelSafety.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.Guardrail.IModelSafety);

                        /** ModelSafety safetySettings. */
                        public safetySettings: google.cloud.ces.v1beta.Guardrail.ModelSafety.ISafetySetting[];

                        /**
                         * Creates a new ModelSafety instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ModelSafety instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.Guardrail.IModelSafety): google.cloud.ces.v1beta.Guardrail.ModelSafety;

                        /**
                         * Encodes the specified ModelSafety message. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.ModelSafety.verify|verify} messages.
                         * @param message ModelSafety message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.Guardrail.IModelSafety, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ModelSafety message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.ModelSafety.verify|verify} messages.
                         * @param message ModelSafety message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.Guardrail.IModelSafety, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ModelSafety message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ModelSafety
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Guardrail.ModelSafety;

                        /**
                         * Decodes a ModelSafety message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ModelSafety
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Guardrail.ModelSafety;

                        /**
                         * Verifies a ModelSafety message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ModelSafety message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ModelSafety
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Guardrail.ModelSafety;

                        /**
                         * Creates a plain object from a ModelSafety message. Also converts values to other types if specified.
                         * @param message ModelSafety
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.Guardrail.ModelSafety, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ModelSafety to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for ModelSafety
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace ModelSafety {

                        /** Properties of a SafetySetting. */
                        interface ISafetySetting {

                            /** SafetySetting category */
                            category?: (google.cloud.ces.v1beta.Guardrail.ModelSafety.HarmCategory|keyof typeof google.cloud.ces.v1beta.Guardrail.ModelSafety.HarmCategory|null);

                            /** SafetySetting threshold */
                            threshold?: (google.cloud.ces.v1beta.Guardrail.ModelSafety.HarmBlockThreshold|keyof typeof google.cloud.ces.v1beta.Guardrail.ModelSafety.HarmBlockThreshold|null);
                        }

                        /** Represents a SafetySetting. */
                        class SafetySetting implements ISafetySetting {

                            /**
                             * Constructs a new SafetySetting.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.ces.v1beta.Guardrail.ModelSafety.ISafetySetting);

                            /** SafetySetting category. */
                            public category: (google.cloud.ces.v1beta.Guardrail.ModelSafety.HarmCategory|keyof typeof google.cloud.ces.v1beta.Guardrail.ModelSafety.HarmCategory);

                            /** SafetySetting threshold. */
                            public threshold: (google.cloud.ces.v1beta.Guardrail.ModelSafety.HarmBlockThreshold|keyof typeof google.cloud.ces.v1beta.Guardrail.ModelSafety.HarmBlockThreshold);

                            /**
                             * Creates a new SafetySetting instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns SafetySetting instance
                             */
                            public static create(properties?: google.cloud.ces.v1beta.Guardrail.ModelSafety.ISafetySetting): google.cloud.ces.v1beta.Guardrail.ModelSafety.SafetySetting;

                            /**
                             * Encodes the specified SafetySetting message. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.ModelSafety.SafetySetting.verify|verify} messages.
                             * @param message SafetySetting message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.ces.v1beta.Guardrail.ModelSafety.ISafetySetting, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified SafetySetting message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.ModelSafety.SafetySetting.verify|verify} messages.
                             * @param message SafetySetting message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.ces.v1beta.Guardrail.ModelSafety.ISafetySetting, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a SafetySetting message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns SafetySetting
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Guardrail.ModelSafety.SafetySetting;

                            /**
                             * Decodes a SafetySetting message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns SafetySetting
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Guardrail.ModelSafety.SafetySetting;

                            /**
                             * Verifies a SafetySetting message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a SafetySetting message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns SafetySetting
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Guardrail.ModelSafety.SafetySetting;

                            /**
                             * Creates a plain object from a SafetySetting message. Also converts values to other types if specified.
                             * @param message SafetySetting
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.ces.v1beta.Guardrail.ModelSafety.SafetySetting, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this SafetySetting to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };

                            /**
                             * Gets the default type url for SafetySetting
                             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns The default type url
                             */
                            public static getTypeUrl(typeUrlPrefix?: string): string;
                        }

                        /** HarmCategory enum. */
                        enum HarmCategory {
                            HARM_CATEGORY_UNSPECIFIED = 0,
                            HARM_CATEGORY_HATE_SPEECH = 1,
                            HARM_CATEGORY_DANGEROUS_CONTENT = 2,
                            HARM_CATEGORY_HARASSMENT = 3,
                            HARM_CATEGORY_SEXUALLY_EXPLICIT = 4
                        }

                        /** HarmBlockThreshold enum. */
                        enum HarmBlockThreshold {
                            HARM_BLOCK_THRESHOLD_UNSPECIFIED = 0,
                            BLOCK_LOW_AND_ABOVE = 1,
                            BLOCK_MEDIUM_AND_ABOVE = 2,
                            BLOCK_ONLY_HIGH = 3,
                            BLOCK_NONE = 4,
                            OFF = 5
                        }
                    }

                    /** Properties of a CodeCallback. */
                    interface ICodeCallback {

                        /** CodeCallback beforeAgentCallback */
                        beforeAgentCallback?: (google.cloud.ces.v1beta.ICallback|null);

                        /** CodeCallback afterAgentCallback */
                        afterAgentCallback?: (google.cloud.ces.v1beta.ICallback|null);

                        /** CodeCallback beforeModelCallback */
                        beforeModelCallback?: (google.cloud.ces.v1beta.ICallback|null);

                        /** CodeCallback afterModelCallback */
                        afterModelCallback?: (google.cloud.ces.v1beta.ICallback|null);
                    }

                    /** Represents a CodeCallback. */
                    class CodeCallback implements ICodeCallback {

                        /**
                         * Constructs a new CodeCallback.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.Guardrail.ICodeCallback);

                        /** CodeCallback beforeAgentCallback. */
                        public beforeAgentCallback?: (google.cloud.ces.v1beta.ICallback|null);

                        /** CodeCallback afterAgentCallback. */
                        public afterAgentCallback?: (google.cloud.ces.v1beta.ICallback|null);

                        /** CodeCallback beforeModelCallback. */
                        public beforeModelCallback?: (google.cloud.ces.v1beta.ICallback|null);

                        /** CodeCallback afterModelCallback. */
                        public afterModelCallback?: (google.cloud.ces.v1beta.ICallback|null);

                        /**
                         * Creates a new CodeCallback instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CodeCallback instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.Guardrail.ICodeCallback): google.cloud.ces.v1beta.Guardrail.CodeCallback;

                        /**
                         * Encodes the specified CodeCallback message. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.CodeCallback.verify|verify} messages.
                         * @param message CodeCallback message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.Guardrail.ICodeCallback, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CodeCallback message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Guardrail.CodeCallback.verify|verify} messages.
                         * @param message CodeCallback message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.Guardrail.ICodeCallback, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CodeCallback message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CodeCallback
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Guardrail.CodeCallback;

                        /**
                         * Decodes a CodeCallback message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CodeCallback
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Guardrail.CodeCallback;

                        /**
                         * Verifies a CodeCallback message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CodeCallback message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CodeCallback
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Guardrail.CodeCallback;

                        /**
                         * Creates a plain object from a CodeCallback message. Also converts values to other types if specified.
                         * @param message CodeCallback
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.Guardrail.CodeCallback, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CodeCallback to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for CodeCallback
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** Properties of a Tool. */
                interface ITool {

                    /** Tool clientFunction */
                    clientFunction?: (google.cloud.ces.v1beta.IClientFunction|null);

                    /** Tool openApiTool */
                    openApiTool?: (google.cloud.ces.v1beta.IOpenApiTool|null);

                    /** Tool googleSearchTool */
                    googleSearchTool?: (google.cloud.ces.v1beta.IGoogleSearchTool|null);

                    /** Tool connectorTool */
                    connectorTool?: (google.cloud.ces.v1beta.IConnectorTool|null);

                    /** Tool dataStoreTool */
                    dataStoreTool?: (google.cloud.ces.v1beta.IDataStoreTool|null);

                    /** Tool pythonFunction */
                    pythonFunction?: (google.cloud.ces.v1beta.IPythonFunction|null);

                    /** Tool mcpTool */
                    mcpTool?: (google.cloud.ces.v1beta.IMcpTool|null);

                    /** Tool fileSearchTool */
                    fileSearchTool?: (google.cloud.ces.v1beta.IFileSearchTool|null);

                    /** Tool systemTool */
                    systemTool?: (google.cloud.ces.v1beta.ISystemTool|null);

                    /** Tool name */
                    name?: (string|null);

                    /** Tool displayName */
                    displayName?: (string|null);

                    /** Tool executionType */
                    executionType?: (google.cloud.ces.v1beta.ExecutionType|keyof typeof google.cloud.ces.v1beta.ExecutionType|null);

                    /** Tool createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** Tool updateTime */
                    updateTime?: (google.protobuf.ITimestamp|null);

                    /** Tool etag */
                    etag?: (string|null);

                    /** Tool generatedSummary */
                    generatedSummary?: (string|null);
                }

                /** Represents a Tool. */
                class Tool implements ITool {

                    /**
                     * Constructs a new Tool.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.ITool);

                    /** Tool clientFunction. */
                    public clientFunction?: (google.cloud.ces.v1beta.IClientFunction|null);

                    /** Tool openApiTool. */
                    public openApiTool?: (google.cloud.ces.v1beta.IOpenApiTool|null);

                    /** Tool googleSearchTool. */
                    public googleSearchTool?: (google.cloud.ces.v1beta.IGoogleSearchTool|null);

                    /** Tool connectorTool. */
                    public connectorTool?: (google.cloud.ces.v1beta.IConnectorTool|null);

                    /** Tool dataStoreTool. */
                    public dataStoreTool?: (google.cloud.ces.v1beta.IDataStoreTool|null);

                    /** Tool pythonFunction. */
                    public pythonFunction?: (google.cloud.ces.v1beta.IPythonFunction|null);

                    /** Tool mcpTool. */
                    public mcpTool?: (google.cloud.ces.v1beta.IMcpTool|null);

                    /** Tool fileSearchTool. */
                    public fileSearchTool?: (google.cloud.ces.v1beta.IFileSearchTool|null);

                    /** Tool systemTool. */
                    public systemTool?: (google.cloud.ces.v1beta.ISystemTool|null);

                    /** Tool name. */
                    public name: string;

                    /** Tool displayName. */
                    public displayName: string;

                    /** Tool executionType. */
                    public executionType: (google.cloud.ces.v1beta.ExecutionType|keyof typeof google.cloud.ces.v1beta.ExecutionType);

                    /** Tool createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** Tool updateTime. */
                    public updateTime?: (google.protobuf.ITimestamp|null);

                    /** Tool etag. */
                    public etag: string;

                    /** Tool generatedSummary. */
                    public generatedSummary: string;

                    /** Tool toolType. */
                    public toolType?: ("clientFunction"|"openApiTool"|"googleSearchTool"|"connectorTool"|"dataStoreTool"|"pythonFunction"|"mcpTool"|"fileSearchTool"|"systemTool");

                    /**
                     * Creates a new Tool instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Tool instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.ITool): google.cloud.ces.v1beta.Tool;

                    /**
                     * Encodes the specified Tool message. Does not implicitly {@link google.cloud.ces.v1beta.Tool.verify|verify} messages.
                     * @param message Tool message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.ITool, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Tool message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Tool.verify|verify} messages.
                     * @param message Tool message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.ITool, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Tool message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Tool
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Tool;

                    /**
                     * Decodes a Tool message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Tool
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Tool;

                    /**
                     * Verifies a Tool message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Tool message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Tool
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Tool;

                    /**
                     * Creates a plain object from a Tool message. Also converts values to other types if specified.
                     * @param message Tool
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Tool, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Tool to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Tool
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ClientFunction. */
                interface IClientFunction {

                    /** ClientFunction name */
                    name?: (string|null);

                    /** ClientFunction description */
                    description?: (string|null);

                    /** ClientFunction parameters */
                    parameters?: (google.cloud.ces.v1beta.ISchema|null);

                    /** ClientFunction response */
                    response?: (google.cloud.ces.v1beta.ISchema|null);
                }

                /** Represents a ClientFunction. */
                class ClientFunction implements IClientFunction {

                    /**
                     * Constructs a new ClientFunction.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IClientFunction);

                    /** ClientFunction name. */
                    public name: string;

                    /** ClientFunction description. */
                    public description: string;

                    /** ClientFunction parameters. */
                    public parameters?: (google.cloud.ces.v1beta.ISchema|null);

                    /** ClientFunction response. */
                    public response?: (google.cloud.ces.v1beta.ISchema|null);

                    /**
                     * Creates a new ClientFunction instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ClientFunction instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IClientFunction): google.cloud.ces.v1beta.ClientFunction;

                    /**
                     * Encodes the specified ClientFunction message. Does not implicitly {@link google.cloud.ces.v1beta.ClientFunction.verify|verify} messages.
                     * @param message ClientFunction message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IClientFunction, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ClientFunction message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ClientFunction.verify|verify} messages.
                     * @param message ClientFunction message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IClientFunction, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ClientFunction message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ClientFunction
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ClientFunction;

                    /**
                     * Decodes a ClientFunction message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ClientFunction
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ClientFunction;

                    /**
                     * Verifies a ClientFunction message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ClientFunction message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ClientFunction
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ClientFunction;

                    /**
                     * Creates a plain object from a ClientFunction message. Also converts values to other types if specified.
                     * @param message ClientFunction
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ClientFunction, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ClientFunction to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ClientFunction
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an Action. */
                interface IAction {

                    /** Action connectionActionId */
                    connectionActionId?: (string|null);

                    /** Action entityOperation */
                    entityOperation?: (google.cloud.ces.v1beta.Action.IEntityOperation|null);

                    /** Action inputFields */
                    inputFields?: (string[]|null);

                    /** Action outputFields */
                    outputFields?: (string[]|null);
                }

                /** Represents an Action. */
                class Action implements IAction {

                    /**
                     * Constructs a new Action.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IAction);

                    /** Action connectionActionId. */
                    public connectionActionId?: (string|null);

                    /** Action entityOperation. */
                    public entityOperation?: (google.cloud.ces.v1beta.Action.IEntityOperation|null);

                    /** Action inputFields. */
                    public inputFields: string[];

                    /** Action outputFields. */
                    public outputFields: string[];

                    /** Action actionSpec. */
                    public actionSpec?: ("connectionActionId"|"entityOperation");

                    /**
                     * Creates a new Action instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Action instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IAction): google.cloud.ces.v1beta.Action;

                    /**
                     * Encodes the specified Action message. Does not implicitly {@link google.cloud.ces.v1beta.Action.verify|verify} messages.
                     * @param message Action message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IAction, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Action message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Action.verify|verify} messages.
                     * @param message Action message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IAction, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an Action message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Action
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Action;

                    /**
                     * Decodes an Action message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Action
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Action;

                    /**
                     * Verifies an Action message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an Action message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Action
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Action;

                    /**
                     * Creates a plain object from an Action message. Also converts values to other types if specified.
                     * @param message Action
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.Action, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Action to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Action
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Action {

                    /** Properties of an EntityOperation. */
                    interface IEntityOperation {

                        /** EntityOperation entityId */
                        entityId?: (string|null);

                        /** EntityOperation operation */
                        operation?: (google.cloud.ces.v1beta.Action.EntityOperation.OperationType|keyof typeof google.cloud.ces.v1beta.Action.EntityOperation.OperationType|null);
                    }

                    /** Represents an EntityOperation. */
                    class EntityOperation implements IEntityOperation {

                        /**
                         * Constructs a new EntityOperation.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.Action.IEntityOperation);

                        /** EntityOperation entityId. */
                        public entityId: string;

                        /** EntityOperation operation. */
                        public operation: (google.cloud.ces.v1beta.Action.EntityOperation.OperationType|keyof typeof google.cloud.ces.v1beta.Action.EntityOperation.OperationType);

                        /**
                         * Creates a new EntityOperation instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns EntityOperation instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.Action.IEntityOperation): google.cloud.ces.v1beta.Action.EntityOperation;

                        /**
                         * Encodes the specified EntityOperation message. Does not implicitly {@link google.cloud.ces.v1beta.Action.EntityOperation.verify|verify} messages.
                         * @param message EntityOperation message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.Action.IEntityOperation, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified EntityOperation message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.Action.EntityOperation.verify|verify} messages.
                         * @param message EntityOperation message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.Action.IEntityOperation, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an EntityOperation message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns EntityOperation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.Action.EntityOperation;

                        /**
                         * Decodes an EntityOperation message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns EntityOperation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.Action.EntityOperation;

                        /**
                         * Verifies an EntityOperation message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an EntityOperation message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns EntityOperation
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.Action.EntityOperation;

                        /**
                         * Creates a plain object from an EntityOperation message. Also converts values to other types if specified.
                         * @param message EntityOperation
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.Action.EntityOperation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this EntityOperation to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for EntityOperation
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace EntityOperation {

                        /** OperationType enum. */
                        enum OperationType {
                            OPERATION_TYPE_UNSPECIFIED = 0,
                            LIST = 1,
                            GET = 2,
                            CREATE = 3,
                            UPDATE = 4,
                            DELETE = 5
                        }
                    }
                }

                /** Properties of a ConnectorTool. */
                interface IConnectorTool {

                    /** ConnectorTool connection */
                    connection?: (string|null);

                    /** ConnectorTool action */
                    action?: (google.cloud.ces.v1beta.IAction|null);

                    /** ConnectorTool authConfig */
                    authConfig?: (google.cloud.ces.v1beta.IEndUserAuthConfig|null);

                    /** ConnectorTool name */
                    name?: (string|null);

                    /** ConnectorTool description */
                    description?: (string|null);
                }

                /** Represents a ConnectorTool. */
                class ConnectorTool implements IConnectorTool {

                    /**
                     * Constructs a new ConnectorTool.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IConnectorTool);

                    /** ConnectorTool connection. */
                    public connection: string;

                    /** ConnectorTool action. */
                    public action?: (google.cloud.ces.v1beta.IAction|null);

                    /** ConnectorTool authConfig. */
                    public authConfig?: (google.cloud.ces.v1beta.IEndUserAuthConfig|null);

                    /** ConnectorTool name. */
                    public name: string;

                    /** ConnectorTool description. */
                    public description: string;

                    /**
                     * Creates a new ConnectorTool instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ConnectorTool instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IConnectorTool): google.cloud.ces.v1beta.ConnectorTool;

                    /**
                     * Encodes the specified ConnectorTool message. Does not implicitly {@link google.cloud.ces.v1beta.ConnectorTool.verify|verify} messages.
                     * @param message ConnectorTool message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IConnectorTool, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ConnectorTool message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ConnectorTool.verify|verify} messages.
                     * @param message ConnectorTool message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IConnectorTool, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ConnectorTool message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ConnectorTool
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ConnectorTool;

                    /**
                     * Decodes a ConnectorTool message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ConnectorTool
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ConnectorTool;

                    /**
                     * Verifies a ConnectorTool message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ConnectorTool message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ConnectorTool
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ConnectorTool;

                    /**
                     * Creates a plain object from a ConnectorTool message. Also converts values to other types if specified.
                     * @param message ConnectorTool
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ConnectorTool, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ConnectorTool to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ConnectorTool
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ApiKeyConfig. */
                interface IApiKeyConfig {

                    /** ApiKeyConfig keyName */
                    keyName?: (string|null);

                    /** ApiKeyConfig apiKeySecretVersion */
                    apiKeySecretVersion?: (string|null);

                    /** ApiKeyConfig requestLocation */
                    requestLocation?: (google.cloud.ces.v1beta.ApiKeyConfig.RequestLocation|keyof typeof google.cloud.ces.v1beta.ApiKeyConfig.RequestLocation|null);
                }

                /** Represents an ApiKeyConfig. */
                class ApiKeyConfig implements IApiKeyConfig {

                    /**
                     * Constructs a new ApiKeyConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IApiKeyConfig);

                    /** ApiKeyConfig keyName. */
                    public keyName: string;

                    /** ApiKeyConfig apiKeySecretVersion. */
                    public apiKeySecretVersion: string;

                    /** ApiKeyConfig requestLocation. */
                    public requestLocation: (google.cloud.ces.v1beta.ApiKeyConfig.RequestLocation|keyof typeof google.cloud.ces.v1beta.ApiKeyConfig.RequestLocation);

                    /**
                     * Creates a new ApiKeyConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ApiKeyConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IApiKeyConfig): google.cloud.ces.v1beta.ApiKeyConfig;

                    /**
                     * Encodes the specified ApiKeyConfig message. Does not implicitly {@link google.cloud.ces.v1beta.ApiKeyConfig.verify|verify} messages.
                     * @param message ApiKeyConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IApiKeyConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ApiKeyConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ApiKeyConfig.verify|verify} messages.
                     * @param message ApiKeyConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IApiKeyConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ApiKeyConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ApiKeyConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ApiKeyConfig;

                    /**
                     * Decodes an ApiKeyConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ApiKeyConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ApiKeyConfig;

                    /**
                     * Verifies an ApiKeyConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ApiKeyConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ApiKeyConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ApiKeyConfig;

                    /**
                     * Creates a plain object from an ApiKeyConfig message. Also converts values to other types if specified.
                     * @param message ApiKeyConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ApiKeyConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ApiKeyConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ApiKeyConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace ApiKeyConfig {

                    /** RequestLocation enum. */
                    enum RequestLocation {
                        REQUEST_LOCATION_UNSPECIFIED = 0,
                        HEADER = 1,
                        QUERY_STRING = 2
                    }
                }

                /** Properties of a OAuthConfig. */
                interface IOAuthConfig {

                    /** OAuthConfig oauthGrantType */
                    oauthGrantType?: (google.cloud.ces.v1beta.OAuthConfig.OauthGrantType|keyof typeof google.cloud.ces.v1beta.OAuthConfig.OauthGrantType|null);

                    /** OAuthConfig clientId */
                    clientId?: (string|null);

                    /** OAuthConfig clientSecretVersion */
                    clientSecretVersion?: (string|null);

                    /** OAuthConfig tokenEndpoint */
                    tokenEndpoint?: (string|null);

                    /** OAuthConfig scopes */
                    scopes?: (string[]|null);
                }

                /** Represents a OAuthConfig. */
                class OAuthConfig implements IOAuthConfig {

                    /**
                     * Constructs a new OAuthConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IOAuthConfig);

                    /** OAuthConfig oauthGrantType. */
                    public oauthGrantType: (google.cloud.ces.v1beta.OAuthConfig.OauthGrantType|keyof typeof google.cloud.ces.v1beta.OAuthConfig.OauthGrantType);

                    /** OAuthConfig clientId. */
                    public clientId: string;

                    /** OAuthConfig clientSecretVersion. */
                    public clientSecretVersion: string;

                    /** OAuthConfig tokenEndpoint. */
                    public tokenEndpoint: string;

                    /** OAuthConfig scopes. */
                    public scopes: string[];

                    /**
                     * Creates a new OAuthConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns OAuthConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IOAuthConfig): google.cloud.ces.v1beta.OAuthConfig;

                    /**
                     * Encodes the specified OAuthConfig message. Does not implicitly {@link google.cloud.ces.v1beta.OAuthConfig.verify|verify} messages.
                     * @param message OAuthConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IOAuthConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified OAuthConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.OAuthConfig.verify|verify} messages.
                     * @param message OAuthConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IOAuthConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a OAuthConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns OAuthConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.OAuthConfig;

                    /**
                     * Decodes a OAuthConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns OAuthConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.OAuthConfig;

                    /**
                     * Verifies a OAuthConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a OAuthConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns OAuthConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.OAuthConfig;

                    /**
                     * Creates a plain object from a OAuthConfig message. Also converts values to other types if specified.
                     * @param message OAuthConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.OAuthConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this OAuthConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for OAuthConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace OAuthConfig {

                    /** OauthGrantType enum. */
                    enum OauthGrantType {
                        OAUTH_GRANT_TYPE_UNSPECIFIED = 0,
                        CLIENT_CREDENTIAL = 1
                    }
                }

                /** Properties of a ServiceAgentIdTokenAuthConfig. */
                interface IServiceAgentIdTokenAuthConfig {
                }

                /** Represents a ServiceAgentIdTokenAuthConfig. */
                class ServiceAgentIdTokenAuthConfig implements IServiceAgentIdTokenAuthConfig {

                    /**
                     * Constructs a new ServiceAgentIdTokenAuthConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IServiceAgentIdTokenAuthConfig);

                    /**
                     * Creates a new ServiceAgentIdTokenAuthConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ServiceAgentIdTokenAuthConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IServiceAgentIdTokenAuthConfig): google.cloud.ces.v1beta.ServiceAgentIdTokenAuthConfig;

                    /**
                     * Encodes the specified ServiceAgentIdTokenAuthConfig message. Does not implicitly {@link google.cloud.ces.v1beta.ServiceAgentIdTokenAuthConfig.verify|verify} messages.
                     * @param message ServiceAgentIdTokenAuthConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IServiceAgentIdTokenAuthConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ServiceAgentIdTokenAuthConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ServiceAgentIdTokenAuthConfig.verify|verify} messages.
                     * @param message ServiceAgentIdTokenAuthConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IServiceAgentIdTokenAuthConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ServiceAgentIdTokenAuthConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ServiceAgentIdTokenAuthConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ServiceAgentIdTokenAuthConfig;

                    /**
                     * Decodes a ServiceAgentIdTokenAuthConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ServiceAgentIdTokenAuthConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ServiceAgentIdTokenAuthConfig;

                    /**
                     * Verifies a ServiceAgentIdTokenAuthConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ServiceAgentIdTokenAuthConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ServiceAgentIdTokenAuthConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ServiceAgentIdTokenAuthConfig;

                    /**
                     * Creates a plain object from a ServiceAgentIdTokenAuthConfig message. Also converts values to other types if specified.
                     * @param message ServiceAgentIdTokenAuthConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ServiceAgentIdTokenAuthConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ServiceAgentIdTokenAuthConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ServiceAgentIdTokenAuthConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ServiceAccountAuthConfig. */
                interface IServiceAccountAuthConfig {

                    /** ServiceAccountAuthConfig serviceAccount */
                    serviceAccount?: (string|null);
                }

                /** Represents a ServiceAccountAuthConfig. */
                class ServiceAccountAuthConfig implements IServiceAccountAuthConfig {

                    /**
                     * Constructs a new ServiceAccountAuthConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IServiceAccountAuthConfig);

                    /** ServiceAccountAuthConfig serviceAccount. */
                    public serviceAccount: string;

                    /**
                     * Creates a new ServiceAccountAuthConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ServiceAccountAuthConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IServiceAccountAuthConfig): google.cloud.ces.v1beta.ServiceAccountAuthConfig;

                    /**
                     * Encodes the specified ServiceAccountAuthConfig message. Does not implicitly {@link google.cloud.ces.v1beta.ServiceAccountAuthConfig.verify|verify} messages.
                     * @param message ServiceAccountAuthConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IServiceAccountAuthConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ServiceAccountAuthConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ServiceAccountAuthConfig.verify|verify} messages.
                     * @param message ServiceAccountAuthConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IServiceAccountAuthConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ServiceAccountAuthConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ServiceAccountAuthConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ServiceAccountAuthConfig;

                    /**
                     * Decodes a ServiceAccountAuthConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ServiceAccountAuthConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ServiceAccountAuthConfig;

                    /**
                     * Verifies a ServiceAccountAuthConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ServiceAccountAuthConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ServiceAccountAuthConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ServiceAccountAuthConfig;

                    /**
                     * Creates a plain object from a ServiceAccountAuthConfig message. Also converts values to other types if specified.
                     * @param message ServiceAccountAuthConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ServiceAccountAuthConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ServiceAccountAuthConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ServiceAccountAuthConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BearerTokenConfig. */
                interface IBearerTokenConfig {

                    /** BearerTokenConfig token */
                    token?: (string|null);
                }

                /** Represents a BearerTokenConfig. */
                class BearerTokenConfig implements IBearerTokenConfig {

                    /**
                     * Constructs a new BearerTokenConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IBearerTokenConfig);

                    /** BearerTokenConfig token. */
                    public token: string;

                    /**
                     * Creates a new BearerTokenConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BearerTokenConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IBearerTokenConfig): google.cloud.ces.v1beta.BearerTokenConfig;

                    /**
                     * Encodes the specified BearerTokenConfig message. Does not implicitly {@link google.cloud.ces.v1beta.BearerTokenConfig.verify|verify} messages.
                     * @param message BearerTokenConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IBearerTokenConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BearerTokenConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.BearerTokenConfig.verify|verify} messages.
                     * @param message BearerTokenConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IBearerTokenConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BearerTokenConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BearerTokenConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.BearerTokenConfig;

                    /**
                     * Decodes a BearerTokenConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BearerTokenConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.BearerTokenConfig;

                    /**
                     * Verifies a BearerTokenConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BearerTokenConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BearerTokenConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.BearerTokenConfig;

                    /**
                     * Creates a plain object from a BearerTokenConfig message. Also converts values to other types if specified.
                     * @param message BearerTokenConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.BearerTokenConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BearerTokenConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BearerTokenConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an EndUserAuthConfig. */
                interface IEndUserAuthConfig {

                    /** EndUserAuthConfig oauth2AuthCodeConfig */
                    oauth2AuthCodeConfig?: (google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2AuthCodeConfig|null);

                    /** EndUserAuthConfig oauth2JwtBearerConfig */
                    oauth2JwtBearerConfig?: (google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2JwtBearerConfig|null);
                }

                /** Represents an EndUserAuthConfig. */
                class EndUserAuthConfig implements IEndUserAuthConfig {

                    /**
                     * Constructs a new EndUserAuthConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IEndUserAuthConfig);

                    /** EndUserAuthConfig oauth2AuthCodeConfig. */
                    public oauth2AuthCodeConfig?: (google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2AuthCodeConfig|null);

                    /** EndUserAuthConfig oauth2JwtBearerConfig. */
                    public oauth2JwtBearerConfig?: (google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2JwtBearerConfig|null);

                    /** EndUserAuthConfig authConfig. */
                    public authConfig?: ("oauth2AuthCodeConfig"|"oauth2JwtBearerConfig");

                    /**
                     * Creates a new EndUserAuthConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EndUserAuthConfig instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IEndUserAuthConfig): google.cloud.ces.v1beta.EndUserAuthConfig;

                    /**
                     * Encodes the specified EndUserAuthConfig message. Does not implicitly {@link google.cloud.ces.v1beta.EndUserAuthConfig.verify|verify} messages.
                     * @param message EndUserAuthConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IEndUserAuthConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EndUserAuthConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EndUserAuthConfig.verify|verify} messages.
                     * @param message EndUserAuthConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IEndUserAuthConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EndUserAuthConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EndUserAuthConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EndUserAuthConfig;

                    /**
                     * Decodes an EndUserAuthConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EndUserAuthConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EndUserAuthConfig;

                    /**
                     * Verifies an EndUserAuthConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EndUserAuthConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EndUserAuthConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EndUserAuthConfig;

                    /**
                     * Creates a plain object from an EndUserAuthConfig message. Also converts values to other types if specified.
                     * @param message EndUserAuthConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.EndUserAuthConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EndUserAuthConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for EndUserAuthConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace EndUserAuthConfig {

                    /** Properties of an Oauth2AuthCodeConfig. */
                    interface IOauth2AuthCodeConfig {

                        /** Oauth2AuthCodeConfig oauthToken */
                        oauthToken?: (string|null);
                    }

                    /** Represents an Oauth2AuthCodeConfig. */
                    class Oauth2AuthCodeConfig implements IOauth2AuthCodeConfig {

                        /**
                         * Constructs a new Oauth2AuthCodeConfig.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2AuthCodeConfig);

                        /** Oauth2AuthCodeConfig oauthToken. */
                        public oauthToken: string;

                        /**
                         * Creates a new Oauth2AuthCodeConfig instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Oauth2AuthCodeConfig instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2AuthCodeConfig): google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2AuthCodeConfig;

                        /**
                         * Encodes the specified Oauth2AuthCodeConfig message. Does not implicitly {@link google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2AuthCodeConfig.verify|verify} messages.
                         * @param message Oauth2AuthCodeConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2AuthCodeConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Oauth2AuthCodeConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2AuthCodeConfig.verify|verify} messages.
                         * @param message Oauth2AuthCodeConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2AuthCodeConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an Oauth2AuthCodeConfig message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Oauth2AuthCodeConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2AuthCodeConfig;

                        /**
                         * Decodes an Oauth2AuthCodeConfig message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Oauth2AuthCodeConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2AuthCodeConfig;

                        /**
                         * Verifies an Oauth2AuthCodeConfig message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an Oauth2AuthCodeConfig message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Oauth2AuthCodeConfig
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2AuthCodeConfig;

                        /**
                         * Creates a plain object from an Oauth2AuthCodeConfig message. Also converts values to other types if specified.
                         * @param message Oauth2AuthCodeConfig
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2AuthCodeConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Oauth2AuthCodeConfig to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Oauth2AuthCodeConfig
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of an Oauth2JwtBearerConfig. */
                    interface IOauth2JwtBearerConfig {

                        /** Oauth2JwtBearerConfig issuer */
                        issuer?: (string|null);

                        /** Oauth2JwtBearerConfig subject */
                        subject?: (string|null);

                        /** Oauth2JwtBearerConfig clientKey */
                        clientKey?: (string|null);
                    }

                    /** Represents an Oauth2JwtBearerConfig. */
                    class Oauth2JwtBearerConfig implements IOauth2JwtBearerConfig {

                        /**
                         * Constructs a new Oauth2JwtBearerConfig.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2JwtBearerConfig);

                        /** Oauth2JwtBearerConfig issuer. */
                        public issuer: string;

                        /** Oauth2JwtBearerConfig subject. */
                        public subject: string;

                        /** Oauth2JwtBearerConfig clientKey. */
                        public clientKey: string;

                        /**
                         * Creates a new Oauth2JwtBearerConfig instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Oauth2JwtBearerConfig instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2JwtBearerConfig): google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2JwtBearerConfig;

                        /**
                         * Encodes the specified Oauth2JwtBearerConfig message. Does not implicitly {@link google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2JwtBearerConfig.verify|verify} messages.
                         * @param message Oauth2JwtBearerConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2JwtBearerConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Oauth2JwtBearerConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2JwtBearerConfig.verify|verify} messages.
                         * @param message Oauth2JwtBearerConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.EndUserAuthConfig.IOauth2JwtBearerConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an Oauth2JwtBearerConfig message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Oauth2JwtBearerConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2JwtBearerConfig;

                        /**
                         * Decodes an Oauth2JwtBearerConfig message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Oauth2JwtBearerConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2JwtBearerConfig;

                        /**
                         * Verifies an Oauth2JwtBearerConfig message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an Oauth2JwtBearerConfig message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Oauth2JwtBearerConfig
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2JwtBearerConfig;

                        /**
                         * Creates a plain object from an Oauth2JwtBearerConfig message. Also converts values to other types if specified.
                         * @param message Oauth2JwtBearerConfig
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.EndUserAuthConfig.Oauth2JwtBearerConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Oauth2JwtBearerConfig to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Oauth2JwtBearerConfig
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** Properties of an ApiAuthentication. */
                interface IApiAuthentication {

                    /** ApiAuthentication apiKeyConfig */
                    apiKeyConfig?: (google.cloud.ces.v1beta.IApiKeyConfig|null);

                    /** ApiAuthentication oauthConfig */
                    oauthConfig?: (google.cloud.ces.v1beta.IOAuthConfig|null);

                    /** ApiAuthentication serviceAgentIdTokenAuthConfig */
                    serviceAgentIdTokenAuthConfig?: (google.cloud.ces.v1beta.IServiceAgentIdTokenAuthConfig|null);

                    /** ApiAuthentication serviceAccountAuthConfig */
                    serviceAccountAuthConfig?: (google.cloud.ces.v1beta.IServiceAccountAuthConfig|null);

                    /** ApiAuthentication bearerTokenConfig */
                    bearerTokenConfig?: (google.cloud.ces.v1beta.IBearerTokenConfig|null);
                }

                /** Represents an ApiAuthentication. */
                class ApiAuthentication implements IApiAuthentication {

                    /**
                     * Constructs a new ApiAuthentication.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IApiAuthentication);

                    /** ApiAuthentication apiKeyConfig. */
                    public apiKeyConfig?: (google.cloud.ces.v1beta.IApiKeyConfig|null);

                    /** ApiAuthentication oauthConfig. */
                    public oauthConfig?: (google.cloud.ces.v1beta.IOAuthConfig|null);

                    /** ApiAuthentication serviceAgentIdTokenAuthConfig. */
                    public serviceAgentIdTokenAuthConfig?: (google.cloud.ces.v1beta.IServiceAgentIdTokenAuthConfig|null);

                    /** ApiAuthentication serviceAccountAuthConfig. */
                    public serviceAccountAuthConfig?: (google.cloud.ces.v1beta.IServiceAccountAuthConfig|null);

                    /** ApiAuthentication bearerTokenConfig. */
                    public bearerTokenConfig?: (google.cloud.ces.v1beta.IBearerTokenConfig|null);

                    /** ApiAuthentication authConfig. */
                    public authConfig?: ("apiKeyConfig"|"oauthConfig"|"serviceAgentIdTokenAuthConfig"|"serviceAccountAuthConfig"|"bearerTokenConfig");

                    /**
                     * Creates a new ApiAuthentication instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ApiAuthentication instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IApiAuthentication): google.cloud.ces.v1beta.ApiAuthentication;

                    /**
                     * Encodes the specified ApiAuthentication message. Does not implicitly {@link google.cloud.ces.v1beta.ApiAuthentication.verify|verify} messages.
                     * @param message ApiAuthentication message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IApiAuthentication, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ApiAuthentication message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.ApiAuthentication.verify|verify} messages.
                     * @param message ApiAuthentication message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IApiAuthentication, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ApiAuthentication message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ApiAuthentication
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.ApiAuthentication;

                    /**
                     * Decodes an ApiAuthentication message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ApiAuthentication
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.ApiAuthentication;

                    /**
                     * Verifies an ApiAuthentication message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ApiAuthentication message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ApiAuthentication
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.ApiAuthentication;

                    /**
                     * Creates a plain object from an ApiAuthentication message. Also converts values to other types if specified.
                     * @param message ApiAuthentication
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.ApiAuthentication, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ApiAuthentication to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ApiAuthentication
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DataStoreTool. */
                interface IDataStoreTool {

                    /** DataStoreTool dataStoreSource */
                    dataStoreSource?: (google.cloud.ces.v1beta.DataStoreTool.IDataStoreSource|null);

                    /** DataStoreTool engineSource */
                    engineSource?: (google.cloud.ces.v1beta.DataStoreTool.IEngineSource|null);

                    /** DataStoreTool name */
                    name?: (string|null);

                    /** DataStoreTool description */
                    description?: (string|null);

                    /** DataStoreTool boostSpecs */
                    boostSpecs?: (google.cloud.ces.v1beta.DataStoreTool.IBoostSpecs[]|null);

                    /** DataStoreTool modalityConfigs */
                    modalityConfigs?: (google.cloud.ces.v1beta.DataStoreTool.IModalityConfig[]|null);

                    /** DataStoreTool filterParameterBehavior */
                    filterParameterBehavior?: (google.cloud.ces.v1beta.DataStoreTool.FilterParameterBehavior|keyof typeof google.cloud.ces.v1beta.DataStoreTool.FilterParameterBehavior|null);
                }

                /** Represents a DataStoreTool. */
                class DataStoreTool implements IDataStoreTool {

                    /**
                     * Constructs a new DataStoreTool.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.ces.v1beta.IDataStoreTool);

                    /** DataStoreTool dataStoreSource. */
                    public dataStoreSource?: (google.cloud.ces.v1beta.DataStoreTool.IDataStoreSource|null);

                    /** DataStoreTool engineSource. */
                    public engineSource?: (google.cloud.ces.v1beta.DataStoreTool.IEngineSource|null);

                    /** DataStoreTool name. */
                    public name: string;

                    /** DataStoreTool description. */
                    public description: string;

                    /** DataStoreTool boostSpecs. */
                    public boostSpecs: google.cloud.ces.v1beta.DataStoreTool.IBoostSpecs[];

                    /** DataStoreTool modalityConfigs. */
                    public modalityConfigs: google.cloud.ces.v1beta.DataStoreTool.IModalityConfig[];

                    /** DataStoreTool filterParameterBehavior. */
                    public filterParameterBehavior: (google.cloud.ces.v1beta.DataStoreTool.FilterParameterBehavior|keyof typeof google.cloud.ces.v1beta.DataStoreTool.FilterParameterBehavior);

                    /** DataStoreTool searchSource. */
                    public searchSource?: ("dataStoreSource"|"engineSource");

                    /**
                     * Creates a new DataStoreTool instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DataStoreTool instance
                     */
                    public static create(properties?: google.cloud.ces.v1beta.IDataStoreTool): google.cloud.ces.v1beta.DataStoreTool;

                    /**
                     * Encodes the specified DataStoreTool message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.verify|verify} messages.
                     * @param message DataStoreTool message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.ces.v1beta.IDataStoreTool, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DataStoreTool message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.verify|verify} messages.
                     * @param message DataStoreTool message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.ces.v1beta.IDataStoreTool, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DataStoreTool message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DataStoreTool
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreTool;

                    /**
                     * Decodes a DataStoreTool message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DataStoreTool
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreTool;

                    /**
                     * Verifies a DataStoreTool message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DataStoreTool message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DataStoreTool
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreTool;

                    /**
                     * Creates a plain object from a DataStoreTool message. Also converts values to other types if specified.
                     * @param message DataStoreTool
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.ces.v1beta.DataStoreTool, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DataStoreTool to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DataStoreTool
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace DataStoreTool {

                    /** Properties of a RewriterConfig. */
                    interface IRewriterConfig {

                        /** RewriterConfig modelSettings */
                        modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                        /** RewriterConfig prompt */
                        prompt?: (string|null);

                        /** RewriterConfig disabled */
                        disabled?: (boolean|null);
                    }

                    /** Represents a RewriterConfig. */
                    class RewriterConfig implements IRewriterConfig {

                        /**
                         * Constructs a new RewriterConfig.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.DataStoreTool.IRewriterConfig);

                        /** RewriterConfig modelSettings. */
                        public modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                        /** RewriterConfig prompt. */
                        public prompt: string;

                        /** RewriterConfig disabled. */
                        public disabled: boolean;

                        /**
                         * Creates a new RewriterConfig instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns RewriterConfig instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.DataStoreTool.IRewriterConfig): google.cloud.ces.v1beta.DataStoreTool.RewriterConfig;

                        /**
                         * Encodes the specified RewriterConfig message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.RewriterConfig.verify|verify} messages.
                         * @param message RewriterConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.DataStoreTool.IRewriterConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified RewriterConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.RewriterConfig.verify|verify} messages.
                         * @param message RewriterConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.DataStoreTool.IRewriterConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a RewriterConfig message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns RewriterConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreTool.RewriterConfig;

                        /**
                         * Decodes a RewriterConfig message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns RewriterConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreTool.RewriterConfig;

                        /**
                         * Verifies a RewriterConfig message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a RewriterConfig message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns RewriterConfig
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreTool.RewriterConfig;

                        /**
                         * Creates a plain object from a RewriterConfig message. Also converts values to other types if specified.
                         * @param message RewriterConfig
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.DataStoreTool.RewriterConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this RewriterConfig to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for RewriterConfig
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a SummarizationConfig. */
                    interface ISummarizationConfig {

                        /** SummarizationConfig modelSettings */
                        modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                        /** SummarizationConfig prompt */
                        prompt?: (string|null);

                        /** SummarizationConfig disabled */
                        disabled?: (boolean|null);
                    }

                    /** Represents a SummarizationConfig. */
                    class SummarizationConfig implements ISummarizationConfig {

                        /**
                         * Constructs a new SummarizationConfig.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.DataStoreTool.ISummarizationConfig);

                        /** SummarizationConfig modelSettings. */
                        public modelSettings?: (google.cloud.ces.v1beta.IModelSettings|null);

                        /** SummarizationConfig prompt. */
                        public prompt: string;

                        /** SummarizationConfig disabled. */
                        public disabled: boolean;

                        /**
                         * Creates a new SummarizationConfig instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns SummarizationConfig instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.DataStoreTool.ISummarizationConfig): google.cloud.ces.v1beta.DataStoreTool.SummarizationConfig;

                        /**
                         * Encodes the specified SummarizationConfig message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.SummarizationConfig.verify|verify} messages.
                         * @param message SummarizationConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.DataStoreTool.ISummarizationConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified SummarizationConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.SummarizationConfig.verify|verify} messages.
                         * @param message SummarizationConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.DataStoreTool.ISummarizationConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a SummarizationConfig message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns SummarizationConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreTool.SummarizationConfig;

                        /**
                         * Decodes a SummarizationConfig message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns SummarizationConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreTool.SummarizationConfig;

                        /**
                         * Verifies a SummarizationConfig message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a SummarizationConfig message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns SummarizationConfig
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreTool.SummarizationConfig;

                        /**
                         * Creates a plain object from a SummarizationConfig message. Also converts values to other types if specified.
                         * @param message SummarizationConfig
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.DataStoreTool.SummarizationConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this SummarizationConfig to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for SummarizationConfig
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a GroundingConfig. */
                    interface IGroundingConfig {

                        /** GroundingConfig groundingLevel */
                        groundingLevel?: (number|null);

                        /** GroundingConfig disabled */
                        disabled?: (boolean|null);
                    }

                    /** Represents a GroundingConfig. */
                    class GroundingConfig implements IGroundingConfig {

                        /**
                         * Constructs a new GroundingConfig.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.DataStoreTool.IGroundingConfig);

                        /** GroundingConfig groundingLevel. */
                        public groundingLevel: number;

                        /** GroundingConfig disabled. */
                        public disabled: boolean;

                        /**
                         * Creates a new GroundingConfig instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GroundingConfig instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.DataStoreTool.IGroundingConfig): google.cloud.ces.v1beta.DataStoreTool.GroundingConfig;

                        /**
                         * Encodes the specified GroundingConfig message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.GroundingConfig.verify|verify} messages.
                         * @param message GroundingConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.DataStoreTool.IGroundingConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GroundingConfig message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.GroundingConfig.verify|verify} messages.
                         * @param message GroundingConfig message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.DataStoreTool.IGroundingConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GroundingConfig message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GroundingConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreTool.GroundingConfig;

                        /**
                         * Decodes a GroundingConfig message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GroundingConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreTool.GroundingConfig;

                        /**
                         * Verifies a GroundingConfig message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GroundingConfig message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GroundingConfig
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreTool.GroundingConfig;

                        /**
                         * Creates a plain object from a GroundingConfig message. Also converts values to other types if specified.
                         * @param message GroundingConfig
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.DataStoreTool.GroundingConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GroundingConfig to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for GroundingConfig
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a DataStoreSource. */
                    interface IDataStoreSource {

                        /** DataStoreSource filter */
                        filter?: (string|null);

                        /** DataStoreSource dataStore */
                        dataStore?: (google.cloud.ces.v1beta.IDataStore|null);
                    }

                    /** Represents a DataStoreSource. */
                    class DataStoreSource implements IDataStoreSource {

                        /**
                         * Constructs a new DataStoreSource.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.DataStoreTool.IDataStoreSource);

                        /** DataStoreSource filter. */
                        public filter: string;

                        /** DataStoreSource dataStore. */
                        public dataStore?: (google.cloud.ces.v1beta.IDataStore|null);

                        /**
                         * Creates a new DataStoreSource instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DataStoreSource instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.DataStoreTool.IDataStoreSource): google.cloud.ces.v1beta.DataStoreTool.DataStoreSource;

                        /**
                         * Encodes the specified DataStoreSource message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.DataStoreSource.verify|verify} messages.
                         * @param message DataStoreSource message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.DataStoreTool.IDataStoreSource, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DataStoreSource message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.DataStoreSource.verify|verify} messages.
                         * @param message DataStoreSource message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.DataStoreTool.IDataStoreSource, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DataStoreSource message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DataStoreSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreTool.DataStoreSource;

                        /**
                         * Decodes a DataStoreSource message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DataStoreSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreTool.DataStoreSource;

                        /**
                         * Verifies a DataStoreSource message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DataStoreSource message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DataStoreSource
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreTool.DataStoreSource;

                        /**
                         * Creates a plain object from a DataStoreSource message. Also converts values to other types if specified.
                         * @param message DataStoreSource
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.DataStoreTool.DataStoreSource, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DataStoreSource to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for DataStoreSource
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of an EngineSource. */
                    interface IEngineSource {

                        /** EngineSource engine */
                        engine?: (string|null);

                        /** EngineSource dataStoreSources */
                        dataStoreSources?: (google.cloud.ces.v1beta.DataStoreTool.IDataStoreSource[]|null);

                        /** EngineSource filter */
                        filter?: (string|null);
                    }

                    /** Represents an EngineSource. */
                    class EngineSource implements IEngineSource {

                        /**
                         * Constructs a new EngineSource.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.DataStoreTool.IEngineSource);

                        /** EngineSource engine. */
                        public engine: string;

                        /** EngineSource dataStoreSources. */
                        public dataStoreSources: google.cloud.ces.v1beta.DataStoreTool.IDataStoreSource[];

                        /** EngineSource filter. */
                        public filter: string;

                        /**
                         * Creates a new EngineSource instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns EngineSource instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.DataStoreTool.IEngineSource): google.cloud.ces.v1beta.DataStoreTool.EngineSource;

                        /**
                         * Encodes the specified EngineSource message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.EngineSource.verify|verify} messages.
                         * @param message EngineSource message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.DataStoreTool.IEngineSource, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified EngineSource message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.EngineSource.verify|verify} messages.
                         * @param message EngineSource message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.DataStoreTool.IEngineSource, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an EngineSource message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns EngineSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreTool.EngineSource;

                        /**
                         * Decodes an EngineSource message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns EngineSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreTool.EngineSource;

                        /**
                         * Verifies an EngineSource message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an EngineSource message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns EngineSource
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreTool.EngineSource;

                        /**
                         * Creates a plain object from an EngineSource message. Also converts values to other types if specified.
                         * @param message EngineSource
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.DataStoreTool.EngineSource, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this EngineSource to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for EngineSource
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a BoostSpecs. */
                    interface IBoostSpecs {

                        /** BoostSpecs dataStores */
                        dataStores?: (string[]|null);

                        /** BoostSpecs spec */
                        spec?: (google.cloud.ces.v1beta.DataStoreTool.IBoostSpec[]|null);
                    }

                    /** Represents a BoostSpecs. */
                    class BoostSpecs implements IBoostSpecs {

                        /**
                         * Constructs a new BoostSpecs.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.DataStoreTool.IBoostSpecs);

                        /** BoostSpecs dataStores. */
                        public dataStores: string[];

                        /** BoostSpecs spec. */
                        public spec: google.cloud.ces.v1beta.DataStoreTool.IBoostSpec[];

                        /**
                         * Creates a new BoostSpecs instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns BoostSpecs instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.DataStoreTool.IBoostSpecs): google.cloud.ces.v1beta.DataStoreTool.BoostSpecs;

                        /**
                         * Encodes the specified BoostSpecs message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.BoostSpecs.verify|verify} messages.
                         * @param message BoostSpecs message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.DataStoreTool.IBoostSpecs, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified BoostSpecs message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.BoostSpecs.verify|verify} messages.
                         * @param message BoostSpecs message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.DataStoreTool.IBoostSpecs, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a BoostSpecs message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns BoostSpecs
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreTool.BoostSpecs;

                        /**
                         * Decodes a BoostSpecs message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns BoostSpecs
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreTool.BoostSpecs;

                        /**
                         * Verifies a BoostSpecs message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a BoostSpecs message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns BoostSpecs
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreTool.BoostSpecs;

                        /**
                         * Creates a plain object from a BoostSpecs message. Also converts values to other types if specified.
                         * @param message BoostSpecs
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.DataStoreTool.BoostSpecs, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this BoostSpecs to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for BoostSpecs
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a BoostSpec. */
                    interface IBoostSpec {

                        /** BoostSpec conditionBoostSpecs */
                        conditionBoostSpecs?: (google.cloud.ces.v1beta.DataStoreTool.BoostSpec.IConditionBoostSpec[]|null);
                    }

                    /** Represents a BoostSpec. */
                    class BoostSpec implements IBoostSpec {

                        /**
                         * Constructs a new BoostSpec.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.ces.v1beta.DataStoreTool.IBoostSpec);

                        /** BoostSpec conditionBoostSpecs. */
                        public conditionBoostSpecs: google.cloud.ces.v1beta.DataStoreTool.BoostSpec.IConditionBoostSpec[];

                        /**
                         * Creates a new BoostSpec instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns BoostSpec instance
                         */
                        public static create(properties?: google.cloud.ces.v1beta.DataStoreTool.IBoostSpec): google.cloud.ces.v1beta.DataStoreTool.BoostSpec;

                        /**
                         * Encodes the specified BoostSpec message. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.BoostSpec.verify|verify} messages.
                         * @param message BoostSpec message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.ces.v1beta.DataStoreTool.IBoostSpec, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified BoostSpec message, length delimited. Does not implicitly {@link google.cloud.ces.v1beta.DataStoreTool.BoostSpec.verify|verify} messages.
                         * @param message BoostSpec message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.ces.v1beta.DataStoreTool.IBoostSpec, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a BoostSpec message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns BoostSpec
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.ces.v1beta.DataStoreTool.BoostSpec;

                        /**
                         * Decodes a BoostSpec message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns BoostSpec
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.ces.v1beta.DataStoreTool.BoostSpec;

                        /**
                         * Verifies a BoostSpec message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a BoostSpec message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns BoostSpec
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.ces.v1beta.DataStoreTool.BoostSpec;

                        /**
                         * Creates a plain object from a BoostSpec message. Also converts values to other types if specified.
                         * @param message BoostSpec
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.ces.v1beta.DataStoreTool.BoostSpec, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this BoostSpec to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for BoostSpec
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace BoostSpec {

                        /** Properties of a ConditionBoostSpec. */
                        interface IConditionBoostSpec {

                            /** ConditionBoostSpec condition */
                            condition?: (string|null);

                            /** ConditionBoostSpec boost */
                            boost?: (number|null);

                            /** ConditionBoostSpec boostControlSpec */
                            boostControlSpec?: (google.cloud.ces.v1beta.DataStoreTool.BoostSpec.ConditionBoostSpec.IBoostControlSpec|null);
                        }

                        /** Represents a ConditionBoostSpec. */
                        class ConditionBoostSpec implements IConditionBoostSpec {

                            /**
                             * Constructs a new ConditionBoostSpec.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.ces.v1beta.DataStoreTool.BoostSpec.IConditionBoostSpec);

                            /** ConditionBoostSpec condition. */
                            public condition: string;

