// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(parent) {
  // [START ces_v1beta_generated_AgentService_ImportApp_async]
  /**
   * This snippet has been automatically generated and should be regarded as a code template only.
   * It will require modifications to work.
   * It may require correct/in-range values for request initialization.
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  The Google Cloud Storage (https://cloud.google.com/storage/docs/) URI
   *  from which to import app. The format of this URI must be
   *  `gs://<bucket-name>/<object-name>`.
   */
  // const gcsUri = 'abc123'
  /**
   *  Raw bytes representing the compressed zip file with the app folder
   *  structure.
   */
  // const appContent = Buffer.from('string')
  /**
   *  Required. The parent resource name with the location of the app to import.
   */
  // const parent = 'abc123'
  /**
   *  Optional. The display name of the app to import.
   *  * If the app is created on import, and the display name is specified,
   *  the imported app will use this display name. If a conflict is detected
   *  with an existing app, a timestamp will be appended to the display name
   *  to make it unique.
   *  * If the app is a reimport, this field should not be set. Providing a
   *  display name during reimport will result in an INVALID_ARGUMENT error.
   */
  // const displayName = 'abc123'
  /**
   *  Optional. The ID to use for the imported app.
   *  *  If not specified, a unique ID will be automatically assigned for
   *  the app.
   *  *  Otherwise, the imported app will use this ID as the final component of
   *  its resource name. If an app with the same ID already exists at the
   *  specified location in the project, the content of the existing app will be
   *  replaced.
   */
  // const appId = 'abc123'
  /**
   *  Optional. Options governing the import process for the app.
   */
  // const importOptions = {}

  // Imports the Ces library
  const {AgentServiceClient} = require('@google-cloud/ces').v1beta;

  // Instantiates a client
  const cesClient = new AgentServiceClient();

  async function callImportApp() {
    // Construct request
    const request = {
      parent,
    };

    // Run request
    const [operation] = await cesClient.importApp(request);
    const [response] = await operation.promise();
    console.log(response);
  }

  callImportApp();
  // [END ces_v1beta_generated_AgentService_ImportApp_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
