// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(parent) {
  // [START ces_v1beta_generated_AgentService_ListChangelogs_async]
  /**
   * This snippet has been automatically generated and should be regarded as a code template only.
   * It will require modifications to work.
   * It may require correct/in-range values for request initialization.
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  Required. The resource name of the app to list changelogs from.
   */
  // const parent = 'abc123'
  /**
   *  Optional. Requested page size. Server may return fewer items than
   *  requested. If unspecified, server will pick an appropriate default.
   */
  // const pageSize = 1234
  /**
   *  Optional. The
   *  next_page_token google.cloud.ces.v1beta.ListChangelogsResponse.next_page_token 
   *  value returned from a previous list
   *  AgentService.ListChangelogs google.cloud.ces.v1beta.AgentService.ListChangelogs 
   *  call.
   */
  // const pageToken = 'abc123'
  /**
   *  Optional. Filter to be applied when listing the changelogs.
   *  See https://google.aip.dev/160 for more details.
   *  The filter string can be used to filter by `action`, `resource_type`,
   *  `resource_name`, `author`, and `create_time`.
   *  The `:` comparator can be used for case-insensitive partial matching on
   *  string fields, while `=` performs an exact case-sensitive match.
   *  Examples:
   *  * `action:update` (case-insensitive partial match)
   *  * `action="Create"` (case-sensitive exact match)
   *  * `resource_type:agent`
   *  * `resource_name:my-agent`
   *  * `author:me@example.com`
   *  * `create_time > "2025-01-01T00:00:00Z"`
   *  * `create_time <= "2025-01-01T00:00:00Z" AND resource_type:tool`
   */
  // const filter = 'abc123'
  /**
   *  Optional. Field to sort by. Only "name" and "create_time" is supported.
   *  See https://google.aip.dev/132#ordering for more details.
   */
  // const orderBy = 'abc123'

  // Imports the Ces library
  const {AgentServiceClient} = require('@google-cloud/ces').v1beta;

  // Instantiates a client
  const cesClient = new AgentServiceClient();

  async function callListChangelogs() {
    // Construct request
    const request = {
      parent,
    };

    // Run request
    const iterable = cesClient.listChangelogsAsync(request);
    for await (const response of iterable) {
        console.log(response);
    }
  }

  callListChangelogs();
  // [END ces_v1beta_generated_AgentService_ListChangelogs_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
