// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(parent, evaluationExpectation) {
  // [START ces_v1beta_generated_EvaluationService_CreateEvaluationExpectation_async]
  /**
   * This snippet has been automatically generated and should be regarded as a code template only.
   * It will require modifications to work.
   * It may require correct/in-range values for request initialization.
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  Required. The app to create the evaluation expectation for.
   *  Format:
   *  `projects/{project}/locations/{location}/apps/{app}`
   */
  // const parent = 'abc123'
  /**
   *  Optional. The ID to use for the evaluation expectation, which will become
   *  the final component of the evaluation expectation's resource name. If not
   *  provided, a unique ID will be automatically assigned for the evaluation
   *  expectation.
   */
  // const evaluationExpectationId = 'abc123'
  /**
   *  Required. The evaluation expectation to create.
   */
  // const evaluationExpectation = {}

  // Imports the Ces library
  const {EvaluationServiceClient} = require('@google-cloud/ces').v1beta;

  // Instantiates a client
  const cesClient = new EvaluationServiceClient();

  async function callCreateEvaluationExpectation() {
    // Construct request
    const request = {
      parent,
      evaluationExpectation,
    };

    // Run request
    const response = await cesClient.createEvaluationExpectation(request);
    console.log(response);
  }

  callCreateEvaluationExpectation();
  // [END ces_v1beta_generated_EvaluationService_CreateEvaluationExpectation_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
