// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(name) {
  // [START ces_v1beta_generated_EvaluationService_DeleteEvaluation_async]
  /**
   * This snippet has been automatically generated and should be regarded as a code template only.
   * It will require modifications to work.
   * It may require correct/in-range values for request initialization.
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  Required. The resource name of the evaluation to delete.
   */
  // const name = 'abc123'
  /**
   *  Optional. Indicates whether to forcefully delete the evaluation, even if it
   *  is still referenced by evaluation datasets.
   *  *  If `force = false`, the deletion will fail if any datasets still
   *  reference the evaluation.
   *  *  If `force = true`, all existing references from datasets will be removed
   *  and the evaluation will be deleted.
   */
  // const force = true
  /**
   *  Optional. The current etag of the evaluation. If an etag is not provided,
   *  the deletion will overwrite any concurrent changes. If an etag is provided
   *  and does not match the current etag of the evaluation, deletion will be
   *  blocked and an ABORTED error will be returned.
   */
  // const etag = 'abc123'

  // Imports the Ces library
  const {EvaluationServiceClient} = require('@google-cloud/ces').v1beta;

  // Instantiates a client
  const cesClient = new EvaluationServiceClient();

  async function callDeleteEvaluation() {
    // Construct request
    const request = {
      name,
    };

    // Run request
    const response = await cesClient.deleteEvaluation(request);
    console.log(response);
  }

  callDeleteEvaluation();
  // [END ces_v1beta_generated_EvaluationService_DeleteEvaluation_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
