// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(parent) {
  // [START ces_v1beta_generated_EvaluationService_ImportEvaluations_async]
  /**
   * This snippet has been automatically generated and should be regarded as a code template only.
   * It will require modifications to work.
   * It may require correct/in-range values for request initialization.
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  The conversations to import the evaluations from.
   */
  // const conversationList = {}
  /**
   *  The Google Cloud Storage (https://cloud.google.com/storage/docs/) URI
   *  from which to import evaluations. The format of this URI must be
   *  `gs://<bucket-name>/<object-name>`.
   */
  // const gcsUri = 'abc123'
  /**
   *  Raw bytes representing the csv file with the evaluations structure.
   */
  // const csvContent = Buffer.from('string')
  /**
   *  Required. The app to import the evaluations into.
   *  Format:
   *  `projects/{project}/locations/{location}/apps/{app}`
   */
  // const parent = 'abc123'
  /**
   *  Optional. Options governing the import process for the evaluations.
   */
  // const importOptions = {}

  // Imports the Ces library
  const {EvaluationServiceClient} = require('@google-cloud/ces').v1beta;

  // Instantiates a client
  const cesClient = new EvaluationServiceClient();

  async function callImportEvaluations() {
    // Construct request
    const request = {
      parent,
    };

    // Run request
    const [operation] = await cesClient.importEvaluations(request);
    const [response] = await operation.promise();
    console.log(response);
  }

  callImportEvaluations();
  // [END ces_v1beta_generated_EvaluationService_ImportEvaluations_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
