// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(parent) {
  // [START ces_v1beta_generated_EvaluationService_ListEvaluations_async]
  /**
   * This snippet has been automatically generated and should be regarded as a code template only.
   * It will require modifications to work.
   * It may require correct/in-range values for request initialization.
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  Required. The resource name of the app to list evaluations from.
   */
  // const parent = 'abc123'
  /**
   *  Optional. Requested page size. Server may return fewer items than
   *  requested. If unspecified, server will pick an appropriate default.
   */
  // const pageSize = 1234
  /**
   *  Optional. The
   *  next_page_token google.cloud.ces.v1beta.ListEvaluationsResponse.next_page_token 
   *  value returned from a previous list
   *  EvaluationService.ListEvaluations google.cloud.ces.v1beta.EvaluationService.ListEvaluations 
   *  call.
   */
  // const pageToken = 'abc123'
  /**
   *  Optional. Filter to be applied when listing the evaluations.
   *  See https://google.aip.dev/160 for more details.
   *  Currently supports filtering by the following fields:
   *  * evaluation_datasets, using the evaluation dataset ID in the format
   *    evaluation_datasets:evaluation_dataset_id.
   *  * tags, using the tag in the format tags:tag.
   */
  // const filter = 'abc123'
  /**
   *  Optional. Field to sort by. Only "name" and "create_time", and
   *  "update_time" are supported. Time fields are ordered in descending order,
   *  and the name field is ordered in ascending order. If not included,
   *  "update_time" will be the default. See https://google.aip.dev/132#ordering
   *  for more details.
   */
  // const orderBy = 'abc123'
  /**
   *  Optional. Whether to include the last 10 evaluation results for each
   *  evaluation in the response.
   */
  // const lastTenResults = true

  // Imports the Ces library
  const {EvaluationServiceClient} = require('@google-cloud/ces').v1beta;

  // Instantiates a client
  const cesClient = new EvaluationServiceClient();

  async function callListEvaluations() {
    // Construct request
    const request = {
      parent,
    };

    // Run request
    const iterable = cesClient.listEvaluationsAsync(request);
    for await (const response of iterable) {
        console.log(response);
    }
  }

  callListEvaluations();
  // [END ces_v1beta_generated_EvaluationService_ListEvaluations_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
