// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(app) {
  // [START ces_v1beta_generated_EvaluationService_RunEvaluation_async]
  /**
   * This snippet has been automatically generated and should be regarded as a code template only.
   * It will require modifications to work.
   * It may require correct/in-range values for request initialization.
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  Required. The app to evaluate.
   *  Format:
   *  `projects/{project}/locations/{location}/apps/{app}`
   */
  // const app = 'abc123'
  /**
   *  Optional. List of evaluations to run.
   *  Format:
   *  `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
   */
  // const evaluations = ['abc','def']
  /**
   *  Optional. An evaluation dataset to run.
   *  Format:
   *  `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
   */
  // const evaluationDataset = 'abc123'
  /**
   *  Optional. The display name of the evaluation run.
   */
  // const displayName = 'abc123'
  /**
   *  Optional. The app version to evaluate.
   *  Format:
   *  `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
   */
  // const appVersion = 'abc123'
  /**
   *  Optional. The configuration to use for the run.
   */
  // const config = {}
  /**
   *  Optional. The number of times to run the evaluation. If not set, the
   *  default value is 1 per golden, and 5 per scenario.
   */
  // const runCount = 1234
  /**
   *  Optional. The configuration to use for the run per persona.
   */
  // const personaRunConfigs = [1,2,3,4]
  /**
   *  Optional. Configuration for running the optimization step after the
   *  evaluation run. If not set, the optimization step will not be run.
   */
  // const optimizationConfig = {}
  /**
   *  Optional. The resource name of the `ScheduledEvaluationRun` that is
   *  triggering this evaluation run.
   *  If this field is set, the `scheduled_evaluation_run` field on the created
   *  `EvaluationRun` resource will be populated from this value.
   *  Format:
   *  `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
   */
  // const scheduledEvaluationRun = 'abc123'
  /**
   *  Optional. The method to run the evaluation if it is a golden evaluation. If
   *  not set, default to STABLE.
   */
  // const goldenRunMethod = {}

  // Imports the Ces library
  const {EvaluationServiceClient} = require('@google-cloud/ces').v1beta;

  // Instantiates a client
  const cesClient = new EvaluationServiceClient();

  async function callRunEvaluation() {
    // Construct request
    const request = {
      app,
    };

    // Run request
    const [operation] = await cesClient.runEvaluation(request);
    const [response] = await operation.promise();
    console.log(response);
  }

  callRunEvaluation();
  // [END ces_v1beta_generated_EvaluationService_RunEvaluation_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
