// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

/* global window */
import type * as gax from 'google-gax';
import type {Callback, CallOptions, Descriptors, ClientOptions, GrpcClientOptions, LROperation, PaginationCallback, GaxCall, LocationsClient, LocationProtos} from 'google-gax';
import {Transform} from 'stream';
import * as protos from '../../protos/protos';
import jsonProtos = require('../../protos/protos.json');
import {loggingUtils as logging, decodeAnyProtosInArray} from 'google-gax';

/**
 * Client JSON configuration object, loaded from
 * `src/v1beta/agent_service_client_config.json`.
 * This file defines retry strategy and timeouts for all API methods in this library.
 */
import * as gapicConfig from './agent_service_client_config.json';
const version = require('../../../package.json').version;

/**
 *  The service that manages agent-related resources in Gemini Enterprise for
 *  Customer Engagement (CES).
 * @class
 * @memberof v1beta
 */
export class AgentServiceClient {
  private _terminated = false;
  private _opts: ClientOptions;
  private _providedCustomServicePath: boolean;
  private _gaxModule: typeof gax | typeof gax.fallback;
  private _gaxGrpc: gax.GrpcClient | gax.fallback.GrpcClient;
  private _protos: {};
  private _defaults: {[method: string]: gax.CallSettings};
  private _universeDomain: string;
  private _servicePath: string;
  private _log = logging.log('ces');

  auth: gax.GoogleAuth;
  descriptors: Descriptors = {
    page: {},
    stream: {},
    longrunning: {},
    batching: {},
  };
  warn: (code: string, message: string, warnType?: string) => void;
  innerApiCalls: {[name: string]: Function};
  locationsClient: LocationsClient;
  pathTemplates: {[name: string]: gax.PathTemplate};
  operationsClient: gax.OperationsClient;
  agentServiceStub?: Promise<{[name: string]: Function}>;

  /**
   * Construct an instance of AgentServiceClient.
   *
   * @param {object} [options] - The configuration object.
   * The options accepted by the constructor are described in detail
   * in [this document](https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#creating-the-client-instance).
   * The common options are:
   * @param {object} [options.credentials] - Credentials object.
   * @param {string} [options.credentials.client_email]
   * @param {string} [options.credentials.private_key]
   * @param {string} [options.email] - Account email address. Required when
   *     using a .pem or .p12 keyFilename.
   * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
   *     .p12 key downloaded from the Google Developers Console. If you provide
   *     a path to a JSON file, the projectId option below is not necessary.
   *     NOTE: .pem and .p12 require you to specify options.email as well.
   * @param {number} [options.port] - The port on which to connect to
   *     the remote host.
   * @param {string} [options.projectId] - The project ID from the Google
   *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
   *     the environment variable GCLOUD_PROJECT for your project ID. If your
   *     app is running in an environment which supports
   *     {@link https://cloud.google.com/docs/authentication/application-default-credentials Application Default Credentials},
   *     your project ID will be detected automatically.
   * @param {string} [options.apiEndpoint] - The domain name of the
   *     API remote host.
   * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
   *     Follows the structure of {@link gapicConfig}.
   * @param {boolean} [options.fallback] - Use HTTP/1.1 REST mode.
   *     For more information, please check the
   *     {@link https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#http11-rest-api-mode documentation}.
   * @param {gax} [gaxInstance]: loaded instance of `google-gax`. Useful if you
   *     need to avoid loading the default gRPC version and want to use the fallback
   *     HTTP implementation. Load only fallback version and pass it to the constructor:
   *     ```
   *     const gax = require('google-gax/build/src/fallback'); // avoids loading google-gax with gRPC
   *     const client = new AgentServiceClient({fallback: true}, gax);
   *     ```
   */
  constructor(opts?: ClientOptions, gaxInstance?: typeof gax | typeof gax.fallback) {
    // Ensure that options include all the required fields.
    const staticMembers = this.constructor as typeof AgentServiceClient;
    if (opts?.universe_domain && opts?.universeDomain && opts?.universe_domain !== opts?.universeDomain) {
      throw new Error('Please set either universe_domain or universeDomain, but not both.');
    }
    const universeDomainEnvVar = (typeof process === 'object' && typeof process.env === 'object') ? process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] : undefined;
    this._universeDomain = opts?.universeDomain ?? opts?.universe_domain ?? universeDomainEnvVar ?? 'googleapis.com';
    this._servicePath = 'ces.' + this._universeDomain;
    const servicePath = opts?.servicePath || opts?.apiEndpoint || this._servicePath;
    this._providedCustomServicePath = !!(opts?.servicePath || opts?.apiEndpoint);
    const port = opts?.port || staticMembers.port;
    const clientConfig = opts?.clientConfig ?? {};
    const fallback = opts?.fallback ?? (typeof window !== 'undefined' && typeof window?.fetch === 'function');
    opts = Object.assign({servicePath, port, clientConfig, fallback}, opts);

    // Request numeric enum values if REST transport is used.
    opts.numericEnums = true;

    // If scopes are unset in options and we're connecting to a non-default endpoint, set scopes just in case.
    if (servicePath !== this._servicePath && !('scopes' in opts)) {
      opts['scopes'] = staticMembers.scopes;
    }

    // Load google-gax module synchronously if needed
    if (!gaxInstance) {
      gaxInstance = require('google-gax') as typeof gax;
    }

    // Choose either gRPC or proto-over-HTTP implementation of google-gax.
    this._gaxModule = opts.fallback ? gaxInstance.fallback : gaxInstance;

    // Create a `gaxGrpc` object, with any grpc-specific options sent to the client.
    this._gaxGrpc = new this._gaxModule.GrpcClient(opts);

    // Save options to use in initialize() method.
    this._opts = opts;

    // Save the auth object to the client, for use by other methods.
    this.auth = (this._gaxGrpc.auth as gax.GoogleAuth);

    // Set useJWTAccessWithScope on the auth object.
    this.auth.useJWTAccessWithScope = true;

    // Set defaultServicePath on the auth object.
    this.auth.defaultServicePath = this._servicePath;

    // Set the default scopes in auth client if needed.
    if (servicePath === this._servicePath) {
      this.auth.defaultScopes = staticMembers.scopes;
    }
    this.locationsClient = new this._gaxModule.LocationsClient(
      this._gaxGrpc,
      opts
    );
  

    // Determine the client header string.
    const clientHeader = [
      `gax/${this._gaxModule.version}`,
      `gapic/${version}`,
    ];
    if (typeof process === 'object' && 'versions' in process) {
      clientHeader.push(`gl-node/${process.versions.node}`);
    } else {
      clientHeader.push(`gl-web/${this._gaxModule.version}`);
    }
    if (!opts.fallback) {
      clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
    } else {
      clientHeader.push(`rest/${this._gaxGrpc.grpcVersion}`);
    }
    if (opts.libName && opts.libVersion) {
      clientHeader.push(`${opts.libName}/${opts.libVersion}`);
    }
    // Load the applicable protos.
    this._protos = this._gaxGrpc.loadProtoJSON(jsonProtos);

    // This API contains "path templates"; forward-slash-separated
    // identifiers to uniquely identify resources within the API.
    // Create useful helper objects for these.
    this.pathTemplates = {
      agentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/agents/{agent}'
      ),
      appPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}'
      ),
      appVersionPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/versions/{version}'
      ),
      changelogPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/changelogs/{changelog}'
      ),
      conversationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}'
      ),
      deploymentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}'
      ),
      evaluationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}'
      ),
      evaluationDatasetPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluation_dataset}'
      ),
      evaluationExpectationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluationExpectations/{evaluation_expectation}'
      ),
      evaluationResultPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{evaluation_result}'
      ),
      evaluationRunPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluation_run}'
      ),
      examplePathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/examples/{example}'
      ),
      guardrailPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}'
      ),
      locationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}'
      ),
      omnichannelPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/omnichannels/{omnichannel}'
      ),
      projectPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}'
      ),
      scheduledEvaluationRunPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}'
      ),
      toolPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/tools/{tool}'
      ),
      toolsetPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}'
      ),
    };

    // Some of the methods on this service return "paged" results,
    // (e.g. 50 results at a time, with tokens to get subsequent
    // pages). Denote the keys used for pagination and results.
    this.descriptors.page = {
      listApps:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'apps'),
      listAgents:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'agents'),
      listExamples:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'examples'),
      listTools:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'tools'),
      listConversations:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'conversations'),
      listGuardrails:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'guardrails'),
      listDeployments:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'deployments'),
      listToolsets:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'toolsets'),
      listAppVersions:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'appVersions'),
      listChangelogs:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'changelogs')
    };

    const protoFilesRoot = this._gaxModule.protobufFromJSON(jsonProtos);
    // This API contains "long-running operations", which return a
    // an Operation object that allows for tracking of the operation,
    // rather than holding a request open.
    const lroOptions: GrpcClientOptions = {
      auth: this.auth,
      grpc: 'grpc' in this._gaxGrpc ? this._gaxGrpc.grpc : undefined
    };
    if (opts.fallback) {
      lroOptions.protoJson = protoFilesRoot;
      lroOptions.httpRules = [{selector: 'google.cloud.location.Locations.GetLocation',get: '/v1beta/{name=projects/*/locations/*}',},{selector: 'google.cloud.location.Locations.ListLocations',get: '/v1beta/{name=projects/*}/locations',},{selector: 'google.longrunning.Operations.CancelOperation',post: '/v1beta/{name=projects/*/locations/*/operations/*}:cancel',body: '*',},{selector: 'google.longrunning.Operations.DeleteOperation',delete: '/v1beta/{name=projects/*/locations/*/operations/*}',},{selector: 'google.longrunning.Operations.GetOperation',get: '/v1beta/{name=projects/*/locations/*/operations/*}',},{selector: 'google.longrunning.Operations.ListOperations',get: '/v1beta/{name=projects/*/locations/*}/operations',}];
    }
    this.operationsClient = this._gaxModule.lro(lroOptions).operationsClient(opts);
    const createAppResponse = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.App') as gax.protobuf.Type;
    const createAppMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.OperationMetadata') as gax.protobuf.Type;
    const deleteAppResponse = protoFilesRoot.lookup(
      '.google.protobuf.Empty') as gax.protobuf.Type;
    const deleteAppMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.OperationMetadata') as gax.protobuf.Type;
    const exportAppResponse = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.ExportAppResponse') as gax.protobuf.Type;
    const exportAppMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.OperationMetadata') as gax.protobuf.Type;
    const importAppResponse = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.ImportAppResponse') as gax.protobuf.Type;
    const importAppMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.OperationMetadata') as gax.protobuf.Type;
    const batchDeleteConversationsResponse = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.BatchDeleteConversationsResponse') as gax.protobuf.Type;
    const batchDeleteConversationsMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.OperationMetadata') as gax.protobuf.Type;
    const restoreAppVersionResponse = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.RestoreAppVersionResponse') as gax.protobuf.Type;
    const restoreAppVersionMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.OperationMetadata') as gax.protobuf.Type;

    this.descriptors.longrunning = {
      createApp: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        createAppResponse.decode.bind(createAppResponse),
        createAppMetadata.decode.bind(createAppMetadata)),
      deleteApp: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        deleteAppResponse.decode.bind(deleteAppResponse),
        deleteAppMetadata.decode.bind(deleteAppMetadata)),
      exportApp: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        exportAppResponse.decode.bind(exportAppResponse),
        exportAppMetadata.decode.bind(exportAppMetadata)),
      importApp: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        importAppResponse.decode.bind(importAppResponse),
        importAppMetadata.decode.bind(importAppMetadata)),
      batchDeleteConversations: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        batchDeleteConversationsResponse.decode.bind(batchDeleteConversationsResponse),
        batchDeleteConversationsMetadata.decode.bind(batchDeleteConversationsMetadata)),
      restoreAppVersion: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        restoreAppVersionResponse.decode.bind(restoreAppVersionResponse),
        restoreAppVersionMetadata.decode.bind(restoreAppVersionMetadata))
    };

    // Put together the default options sent with requests.
    this._defaults = this._gaxGrpc.constructSettings(
        'google.cloud.ces.v1beta.AgentService', gapicConfig as gax.ClientConfig,
        opts.clientConfig || {}, {'x-goog-api-client': clientHeader.join(' ')});

    // Set up a dictionary of "inner API calls"; the core implementation
    // of calling the API is handled in `google-gax`, with this code
    // merely providing the destination and request information.
    this.innerApiCalls = {};

    // Add a warn function to the client constructor so it can be easily tested.
    this.warn = this._gaxModule.warn;
  }

  /**
   * Initialize the client.
   * Performs asynchronous operations (such as authentication) and prepares the client.
   * This function will be called automatically when any class method is called for the
   * first time, but if you need to initialize it before calling an actual method,
   * feel free to call initialize() directly.
   *
   * You can await on this method if you want to make sure the client is initialized.
   *
   * @returns {Promise} A promise that resolves to an authenticated service stub.
   */
  initialize() {
    // If the client stub promise is already initialized, return immediately.
    if (this.agentServiceStub) {
      return this.agentServiceStub;
    }

    // Put together the "service stub" for
    // google.cloud.ces.v1beta.AgentService.
    this.agentServiceStub = this._gaxGrpc.createStub(
        this._opts.fallback ?
          (this._protos as protobuf.Root).lookupService('google.cloud.ces.v1beta.AgentService') :
          // eslint-disable-next-line @typescript-eslint/no-explicit-any
          (this._protos as any).google.cloud.ces.v1beta.AgentService,
        this._opts, this._providedCustomServicePath) as Promise<{[method: string]: Function}>;

    // Iterate over each of the methods that the service provides
    // and create an API call method for each.
    const agentServiceStubMethods =
        ['listApps', 'getApp', 'createApp', 'updateApp', 'deleteApp', 'exportApp', 'importApp', 'listAgents', 'getAgent', 'createAgent', 'updateAgent', 'deleteAgent', 'listExamples', 'getExample', 'createExample', 'updateExample', 'deleteExample', 'listTools', 'getTool', 'listConversations', 'getConversation', 'deleteConversation', 'batchDeleteConversations', 'createTool', 'updateTool', 'deleteTool', 'listGuardrails', 'getGuardrail', 'createGuardrail', 'updateGuardrail', 'deleteGuardrail', 'listDeployments', 'getDeployment', 'createDeployment', 'updateDeployment', 'deleteDeployment', 'listToolsets', 'getToolset', 'createToolset', 'updateToolset', 'deleteToolset', 'listAppVersions', 'getAppVersion', 'createAppVersion', 'deleteAppVersion', 'restoreAppVersion', 'listChangelogs', 'getChangelog'];
    for (const methodName of agentServiceStubMethods) {
      const callPromise = this.agentServiceStub.then(
        stub => (...args: Array<{}>) => {
          if (this._terminated) {
            return Promise.reject('The client has already been closed.');
          }
          const func = stub[methodName];
          return func.apply(stub, args);
        },
        (err: Error|null|undefined) => () => {
          throw err;
        });

      const descriptor =
        this.descriptors.page[methodName] ||
        this.descriptors.longrunning[methodName] ||
        undefined;
      const apiCall = this._gaxModule.createApiCall(
        callPromise,
        this._defaults[methodName],
        descriptor,
        this._opts.fallback
      );

      this.innerApiCalls[methodName] = apiCall;
    }

    return this.agentServiceStub;
  }

  /**
   * The DNS address for this API service.
   * @deprecated Use the apiEndpoint method of the client instance.
   * @returns {string} The DNS address for this service.
   */
  static get servicePath() {
    if (typeof process === 'object' && typeof process.emitWarning === 'function') {
      process.emitWarning('Static servicePath is deprecated, please use the instance method instead.', 'DeprecationWarning');
    }
    return 'ces.googleapis.com';
  }

  /**
   * The DNS address for this API service - same as servicePath.
   * @deprecated Use the apiEndpoint method of the client instance.
   * @returns {string} The DNS address for this service.
   */
  static get apiEndpoint() {
    if (typeof process === 'object' && typeof process.emitWarning === 'function') {
      process.emitWarning('Static apiEndpoint is deprecated, please use the instance method instead.', 'DeprecationWarning');
    }
    return 'ces.googleapis.com';
  }

  /**
   * The DNS address for this API service.
   * @returns {string} The DNS address for this service.
   */
  get apiEndpoint() {
    return this._servicePath;
  }

  get universeDomain() {
    return this._universeDomain;
  }

  /**
   * The port for this API service.
   * @returns {number} The default port for this service.
   */
  static get port() {
    return 443;
  }

  /**
   * The scopes needed to make gRPC calls for every method defined
   * in this service.
   * @returns {string[]} List of default scopes.
   */
  static get scopes() {
    return [
      'https://www.googleapis.com/auth/ces',
      'https://www.googleapis.com/auth/cloud-platform'
    ];
  }

  getProjectId(): Promise<string>;
  getProjectId(callback: Callback<string, undefined, undefined>): void;
  /**
   * Return the project ID used by this class.
   * @returns {Promise} A promise that resolves to string containing the project ID.
   */
  getProjectId(callback?: Callback<string, undefined, undefined>):
      Promise<string>|void {
    if (callback) {
      this.auth.getProjectId(callback);
      return;
    }
    return this.auth.getProjectId();
  }

  // -------------------
  // -- Service calls --
  // -------------------
/**
 * Gets details of the specified app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the app to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.App|App}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetApp_async
 */
  getApp(
      request?: protos.google.cloud.ces.v1beta.IGetAppRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IApp,
        protos.google.cloud.ces.v1beta.IGetAppRequest|undefined, {}|undefined
      ]>;
  getApp(
      request: protos.google.cloud.ces.v1beta.IGetAppRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IApp,
          protos.google.cloud.ces.v1beta.IGetAppRequest|null|undefined,
          {}|null|undefined>): void;
  getApp(
      request: protos.google.cloud.ces.v1beta.IGetAppRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IApp,
          protos.google.cloud.ces.v1beta.IGetAppRequest|null|undefined,
          {}|null|undefined>): void;
  getApp(
      request?: protos.google.cloud.ces.v1beta.IGetAppRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IApp,
          protos.google.cloud.ces.v1beta.IGetAppRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IApp,
          protos.google.cloud.ces.v1beta.IGetAppRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IApp,
        protos.google.cloud.ces.v1beta.IGetAppRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getApp request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IApp,
        protos.google.cloud.ces.v1beta.IGetAppRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getApp response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getApp(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IApp,
        protos.google.cloud.ces.v1beta.IGetAppRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getApp response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates the specified app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.App} request.app
 *   Required. The app to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.App|App}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.update_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_UpdateApp_async
 */
  updateApp(
      request?: protos.google.cloud.ces.v1beta.IUpdateAppRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IApp,
        protos.google.cloud.ces.v1beta.IUpdateAppRequest|undefined, {}|undefined
      ]>;
  updateApp(
      request: protos.google.cloud.ces.v1beta.IUpdateAppRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IApp,
          protos.google.cloud.ces.v1beta.IUpdateAppRequest|null|undefined,
          {}|null|undefined>): void;
  updateApp(
      request: protos.google.cloud.ces.v1beta.IUpdateAppRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IApp,
          protos.google.cloud.ces.v1beta.IUpdateAppRequest|null|undefined,
          {}|null|undefined>): void;
  updateApp(
      request?: protos.google.cloud.ces.v1beta.IUpdateAppRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IApp,
          protos.google.cloud.ces.v1beta.IUpdateAppRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IApp,
          protos.google.cloud.ces.v1beta.IUpdateAppRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IApp,
        protos.google.cloud.ces.v1beta.IUpdateAppRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'app.name': request.app!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateApp request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IApp,
        protos.google.cloud.ces.v1beta.IUpdateAppRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateApp response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateApp(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IApp,
        protos.google.cloud.ces.v1beta.IUpdateAppRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateApp response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified agent.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the agent to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Agent|Agent}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_agent.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetAgent_async
 */
  getAgent(
      request?: protos.google.cloud.ces.v1beta.IGetAgentRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.IGetAgentRequest|undefined, {}|undefined
      ]>;
  getAgent(
      request: protos.google.cloud.ces.v1beta.IGetAgentRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.IGetAgentRequest|null|undefined,
          {}|null|undefined>): void;
  getAgent(
      request: protos.google.cloud.ces.v1beta.IGetAgentRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.IGetAgentRequest|null|undefined,
          {}|null|undefined>): void;
  getAgent(
      request?: protos.google.cloud.ces.v1beta.IGetAgentRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.IGetAgentRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.IGetAgentRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.IGetAgentRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getAgent request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.IGetAgentRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getAgent response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getAgent(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.IGetAgentRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getAgent response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates a new agent in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to create an agent in.
 * @param {string} [request.agentId]
 *   Optional. The ID to use for the agent, which will become the final
 *   component of the agent's resource name. If not provided, a unique ID will
 *   be automatically assigned for the agent.
 * @param {google.cloud.ces.v1beta.Agent} request.agent
 *   Required. The agent to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Agent|Agent}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.create_agent.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_CreateAgent_async
 */
  createAgent(
      request?: protos.google.cloud.ces.v1beta.ICreateAgentRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.ICreateAgentRequest|undefined, {}|undefined
      ]>;
  createAgent(
      request: protos.google.cloud.ces.v1beta.ICreateAgentRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.ICreateAgentRequest|null|undefined,
          {}|null|undefined>): void;
  createAgent(
      request: protos.google.cloud.ces.v1beta.ICreateAgentRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.ICreateAgentRequest|null|undefined,
          {}|null|undefined>): void;
  createAgent(
      request?: protos.google.cloud.ces.v1beta.ICreateAgentRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.ICreateAgentRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.ICreateAgentRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.ICreateAgentRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createAgent request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.ICreateAgentRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createAgent response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createAgent(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.ICreateAgentRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createAgent response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates the specified agent.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.Agent} request.agent
 *   Required. The agent to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Agent|Agent}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.update_agent.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_UpdateAgent_async
 */
  updateAgent(
      request?: protos.google.cloud.ces.v1beta.IUpdateAgentRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.IUpdateAgentRequest|undefined, {}|undefined
      ]>;
  updateAgent(
      request: protos.google.cloud.ces.v1beta.IUpdateAgentRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.IUpdateAgentRequest|null|undefined,
          {}|null|undefined>): void;
  updateAgent(
      request: protos.google.cloud.ces.v1beta.IUpdateAgentRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.IUpdateAgentRequest|null|undefined,
          {}|null|undefined>): void;
  updateAgent(
      request?: protos.google.cloud.ces.v1beta.IUpdateAgentRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.IUpdateAgentRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IAgent,
          protos.google.cloud.ces.v1beta.IUpdateAgentRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.IUpdateAgentRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'agent.name': request.agent!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateAgent request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.IUpdateAgentRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateAgent response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateAgent(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IAgent,
        protos.google.cloud.ces.v1beta.IUpdateAgentRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateAgent response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes the specified agent.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the agent to delete.
 * @param {boolean} [request.force]
 *   Optional. Indicates whether to forcefully delete the agent, even if it is
 *   still referenced by other app/agents/examples.
 *
 *   *  If `force = false`, the deletion fails if other agents/examples
 *   reference it.
 *   *  If `force = true`, delete the agent and remove it from all referencing
 *   apps/agents/examples.
 * @param {string} [request.etag]
 *   Optional. The current etag of the agent. If an etag is not provided, the
 *   deletion will overwrite any concurrent changes. If an etag is provided and
 *   does not match the current etag of the agent, deletion will be blocked and
 *   an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_agent.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteAgent_async
 */
  deleteAgent(
      request?: protos.google.cloud.ces.v1beta.IDeleteAgentRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteAgentRequest|undefined, {}|undefined
      ]>;
  deleteAgent(
      request: protos.google.cloud.ces.v1beta.IDeleteAgentRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteAgentRequest|null|undefined,
          {}|null|undefined>): void;
  deleteAgent(
      request: protos.google.cloud.ces.v1beta.IDeleteAgentRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteAgentRequest|null|undefined,
          {}|null|undefined>): void;
  deleteAgent(
      request?: protos.google.cloud.ces.v1beta.IDeleteAgentRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteAgentRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteAgentRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteAgentRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteAgent request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteAgentRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteAgent response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteAgent(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteAgentRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteAgent response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified example.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the example to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Example|Example}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_example.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetExample_async
 */
  getExample(
      request?: protos.google.cloud.ces.v1beta.IGetExampleRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.IGetExampleRequest|undefined, {}|undefined
      ]>;
  getExample(
      request: protos.google.cloud.ces.v1beta.IGetExampleRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.IGetExampleRequest|null|undefined,
          {}|null|undefined>): void;
  getExample(
      request: protos.google.cloud.ces.v1beta.IGetExampleRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.IGetExampleRequest|null|undefined,
          {}|null|undefined>): void;
  getExample(
      request?: protos.google.cloud.ces.v1beta.IGetExampleRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.IGetExampleRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.IGetExampleRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.IGetExampleRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getExample request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.IGetExampleRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getExample response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getExample(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.IGetExampleRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getExample response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates a new example in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to create an example in.
 * @param {string} [request.exampleId]
 *   Optional. The ID to use for the example, which will become the final
 *   component of the example's resource name. If not provided, a unique ID will
 *   be automatically assigned for the example.
 * @param {google.cloud.ces.v1beta.Example} request.example
 *   Required. The example to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Example|Example}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.create_example.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_CreateExample_async
 */
  createExample(
      request?: protos.google.cloud.ces.v1beta.ICreateExampleRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.ICreateExampleRequest|undefined, {}|undefined
      ]>;
  createExample(
      request: protos.google.cloud.ces.v1beta.ICreateExampleRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.ICreateExampleRequest|null|undefined,
          {}|null|undefined>): void;
  createExample(
      request: protos.google.cloud.ces.v1beta.ICreateExampleRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.ICreateExampleRequest|null|undefined,
          {}|null|undefined>): void;
  createExample(
      request?: protos.google.cloud.ces.v1beta.ICreateExampleRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.ICreateExampleRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.ICreateExampleRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.ICreateExampleRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createExample request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.ICreateExampleRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createExample response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createExample(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.ICreateExampleRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createExample response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates the specified example.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.Example} request.example
 *   Required. The example to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Example|Example}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.update_example.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_UpdateExample_async
 */
  updateExample(
      request?: protos.google.cloud.ces.v1beta.IUpdateExampleRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.IUpdateExampleRequest|undefined, {}|undefined
      ]>;
  updateExample(
      request: protos.google.cloud.ces.v1beta.IUpdateExampleRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.IUpdateExampleRequest|null|undefined,
          {}|null|undefined>): void;
  updateExample(
      request: protos.google.cloud.ces.v1beta.IUpdateExampleRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.IUpdateExampleRequest|null|undefined,
          {}|null|undefined>): void;
  updateExample(
      request?: protos.google.cloud.ces.v1beta.IUpdateExampleRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.IUpdateExampleRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IExample,
          protos.google.cloud.ces.v1beta.IUpdateExampleRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.IUpdateExampleRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'example.name': request.example!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateExample request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.IUpdateExampleRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateExample response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateExample(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IExample,
        protos.google.cloud.ces.v1beta.IUpdateExampleRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateExample response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes the specified example.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the example to delete.
 * @param {string} [request.etag]
 *   Optional. The current etag of the example. If an etag is not provided, the
 *   deletion will overwrite any concurrent changes. If an etag is provided and
 *   does not match the current etag of the example, deletion will be blocked
 *   and an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_example.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteExample_async
 */
  deleteExample(
      request?: protos.google.cloud.ces.v1beta.IDeleteExampleRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteExampleRequest|undefined, {}|undefined
      ]>;
  deleteExample(
      request: protos.google.cloud.ces.v1beta.IDeleteExampleRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteExampleRequest|null|undefined,
          {}|null|undefined>): void;
  deleteExample(
      request: protos.google.cloud.ces.v1beta.IDeleteExampleRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteExampleRequest|null|undefined,
          {}|null|undefined>): void;
  deleteExample(
      request?: protos.google.cloud.ces.v1beta.IDeleteExampleRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteExampleRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteExampleRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteExampleRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteExample request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteExampleRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteExample response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteExample(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteExampleRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteExample response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified tool.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the tool to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Tool|Tool}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_tool.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetTool_async
 */
  getTool(
      request?: protos.google.cloud.ces.v1beta.IGetToolRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.IGetToolRequest|undefined, {}|undefined
      ]>;
  getTool(
      request: protos.google.cloud.ces.v1beta.IGetToolRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.IGetToolRequest|null|undefined,
          {}|null|undefined>): void;
  getTool(
      request: protos.google.cloud.ces.v1beta.IGetToolRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.IGetToolRequest|null|undefined,
          {}|null|undefined>): void;
  getTool(
      request?: protos.google.cloud.ces.v1beta.IGetToolRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.IGetToolRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.IGetToolRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.IGetToolRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getTool request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.IGetToolRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getTool response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getTool(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.IGetToolRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getTool response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified conversation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the conversation to retrieve.
 * @param {google.cloud.ces.v1beta.Conversation.Source} [request.source]
 *   Optional. Indicate the source of the conversation. If not set, all source
 *   will be searched.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Conversation|Conversation}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_conversation.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetConversation_async
 */
  getConversation(
      request?: protos.google.cloud.ces.v1beta.IGetConversationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IConversation,
        protos.google.cloud.ces.v1beta.IGetConversationRequest|undefined, {}|undefined
      ]>;
  getConversation(
      request: protos.google.cloud.ces.v1beta.IGetConversationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IConversation,
          protos.google.cloud.ces.v1beta.IGetConversationRequest|null|undefined,
          {}|null|undefined>): void;
  getConversation(
      request: protos.google.cloud.ces.v1beta.IGetConversationRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IConversation,
          protos.google.cloud.ces.v1beta.IGetConversationRequest|null|undefined,
          {}|null|undefined>): void;
  getConversation(
      request?: protos.google.cloud.ces.v1beta.IGetConversationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IConversation,
          protos.google.cloud.ces.v1beta.IGetConversationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IConversation,
          protos.google.cloud.ces.v1beta.IGetConversationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IConversation,
        protos.google.cloud.ces.v1beta.IGetConversationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getConversation request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IConversation,
        protos.google.cloud.ces.v1beta.IGetConversationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getConversation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getConversation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IConversation,
        protos.google.cloud.ces.v1beta.IGetConversationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getConversation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes the specified conversation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the conversation to delete.
 * @param {google.cloud.ces.v1beta.Conversation.Source} [request.source]
 *   Optional. Indicate the source of the conversation. If not set, Source.Live
 *   will be applied by default.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_conversation.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteConversation_async
 */
  deleteConversation(
      request?: protos.google.cloud.ces.v1beta.IDeleteConversationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteConversationRequest|undefined, {}|undefined
      ]>;
  deleteConversation(
      request: protos.google.cloud.ces.v1beta.IDeleteConversationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteConversationRequest|null|undefined,
          {}|null|undefined>): void;
  deleteConversation(
      request: protos.google.cloud.ces.v1beta.IDeleteConversationRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteConversationRequest|null|undefined,
          {}|null|undefined>): void;
  deleteConversation(
      request?: protos.google.cloud.ces.v1beta.IDeleteConversationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteConversationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteConversationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteConversationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteConversation request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteConversationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteConversation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteConversation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteConversationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteConversation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates a new tool in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to create a tool in.
 * @param {string} [request.toolId]
 *   Optional. The ID to use for the tool, which will become the final component
 *   of the tool's resource name. If not provided, a unique ID will be
 *   automatically assigned for the tool.
 * @param {google.cloud.ces.v1beta.Tool} request.tool
 *   Required. The tool to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Tool|Tool}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.create_tool.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_CreateTool_async
 */
  createTool(
      request?: protos.google.cloud.ces.v1beta.ICreateToolRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.ICreateToolRequest|undefined, {}|undefined
      ]>;
  createTool(
      request: protos.google.cloud.ces.v1beta.ICreateToolRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.ICreateToolRequest|null|undefined,
          {}|null|undefined>): void;
  createTool(
      request: protos.google.cloud.ces.v1beta.ICreateToolRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.ICreateToolRequest|null|undefined,
          {}|null|undefined>): void;
  createTool(
      request?: protos.google.cloud.ces.v1beta.ICreateToolRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.ICreateToolRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.ICreateToolRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.ICreateToolRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createTool request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.ICreateToolRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createTool response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createTool(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.ICreateToolRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createTool response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates the specified tool.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.Tool} request.tool
 *   Required. The tool to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Tool|Tool}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.update_tool.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_UpdateTool_async
 */
  updateTool(
      request?: protos.google.cloud.ces.v1beta.IUpdateToolRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.IUpdateToolRequest|undefined, {}|undefined
      ]>;
  updateTool(
      request: protos.google.cloud.ces.v1beta.IUpdateToolRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.IUpdateToolRequest|null|undefined,
          {}|null|undefined>): void;
  updateTool(
      request: protos.google.cloud.ces.v1beta.IUpdateToolRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.IUpdateToolRequest|null|undefined,
          {}|null|undefined>): void;
  updateTool(
      request?: protos.google.cloud.ces.v1beta.IUpdateToolRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.IUpdateToolRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.ITool,
          protos.google.cloud.ces.v1beta.IUpdateToolRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.IUpdateToolRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'tool.name': request.tool!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateTool request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.IUpdateToolRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateTool response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateTool(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.ITool,
        protos.google.cloud.ces.v1beta.IUpdateToolRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateTool response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes the specified tool.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the tool to delete.
 * @param {boolean} [request.force]
 *   Optional. Indicates whether to forcefully delete the tool, even if it is
 *   still referenced by agents/examples.
 *
 *   *  If `force = false`, the deletion will fail if any agents still
 *   reference the tool.
 *   *  If `force = true`, all existing references from agents will be removed
 *   and the tool will be deleted.
 * @param {string} [request.etag]
 *   Optional. The current etag of the tool. If an etag is not provided, the
 *   deletion will overwrite any concurrent changes. If an etag is provided and
 *   does not match the current etag of the tool, deletion will be blocked and
 *   an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_tool.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteTool_async
 */
  deleteTool(
      request?: protos.google.cloud.ces.v1beta.IDeleteToolRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteToolRequest|undefined, {}|undefined
      ]>;
  deleteTool(
      request: protos.google.cloud.ces.v1beta.IDeleteToolRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteToolRequest|null|undefined,
          {}|null|undefined>): void;
  deleteTool(
      request: protos.google.cloud.ces.v1beta.IDeleteToolRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteToolRequest|null|undefined,
          {}|null|undefined>): void;
  deleteTool(
      request?: protos.google.cloud.ces.v1beta.IDeleteToolRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteToolRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteToolRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteToolRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteTool request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteToolRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteTool response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteTool(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteToolRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteTool response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified guardrail.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the guardrail to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Guardrail|Guardrail}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_guardrail.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetGuardrail_async
 */
  getGuardrail(
      request?: protos.google.cloud.ces.v1beta.IGetGuardrailRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.IGetGuardrailRequest|undefined, {}|undefined
      ]>;
  getGuardrail(
      request: protos.google.cloud.ces.v1beta.IGetGuardrailRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.IGetGuardrailRequest|null|undefined,
          {}|null|undefined>): void;
  getGuardrail(
      request: protos.google.cloud.ces.v1beta.IGetGuardrailRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.IGetGuardrailRequest|null|undefined,
          {}|null|undefined>): void;
  getGuardrail(
      request?: protos.google.cloud.ces.v1beta.IGetGuardrailRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.IGetGuardrailRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.IGetGuardrailRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.IGetGuardrailRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getGuardrail request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.IGetGuardrailRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getGuardrail response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getGuardrail(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.IGetGuardrailRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getGuardrail response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates a new guardrail in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to create a guardrail in.
 * @param {string} [request.guardrailId]
 *   Optional. The ID to use for the guardrail, which will become the final
 *   component of the guardrail's resource name. If not provided, a unique ID
 *   will be automatically assigned for the guardrail.
 * @param {google.cloud.ces.v1beta.Guardrail} request.guardrail
 *   Required. The guardrail to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Guardrail|Guardrail}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.create_guardrail.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_CreateGuardrail_async
 */
  createGuardrail(
      request?: protos.google.cloud.ces.v1beta.ICreateGuardrailRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.ICreateGuardrailRequest|undefined, {}|undefined
      ]>;
  createGuardrail(
      request: protos.google.cloud.ces.v1beta.ICreateGuardrailRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.ICreateGuardrailRequest|null|undefined,
          {}|null|undefined>): void;
  createGuardrail(
      request: protos.google.cloud.ces.v1beta.ICreateGuardrailRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.ICreateGuardrailRequest|null|undefined,
          {}|null|undefined>): void;
  createGuardrail(
      request?: protos.google.cloud.ces.v1beta.ICreateGuardrailRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.ICreateGuardrailRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.ICreateGuardrailRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.ICreateGuardrailRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createGuardrail request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.ICreateGuardrailRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createGuardrail response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createGuardrail(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.ICreateGuardrailRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createGuardrail response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates the specified guardrail.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.Guardrail} request.guardrail
 *   Required. The guardrail to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Guardrail|Guardrail}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.update_guardrail.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_UpdateGuardrail_async
 */
  updateGuardrail(
      request?: protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest|undefined, {}|undefined
      ]>;
  updateGuardrail(
      request: protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest|null|undefined,
          {}|null|undefined>): void;
  updateGuardrail(
      request: protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest|null|undefined,
          {}|null|undefined>): void;
  updateGuardrail(
      request?: protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IGuardrail,
          protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'guardrail.name': request.guardrail!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateGuardrail request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateGuardrail response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateGuardrail(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IGuardrail,
        protos.google.cloud.ces.v1beta.IUpdateGuardrailRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateGuardrail response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes the specified guardrail.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the guardrail to delete.
 * @param {boolean} [request.force]
 *   Optional. Indicates whether to forcefully delete the guardrail, even if it
 *   is still referenced by app/agents.
 *
 *   *  If `force = false`, the deletion fails if any apps/agents still
 *   reference the guardrail.
 *   *  If `force = true`, all existing references from apps/agents will be
 *   removed and the guardrail will be deleted.
 * @param {string} [request.etag]
 *   Optional. The current etag of the guardrail. If an etag is not provided,
 *   the deletion will overwrite any concurrent changes. If an etag is provided
 *   and does not match the current etag of the guardrail, deletion will be
 *   blocked and an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_guardrail.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteGuardrail_async
 */
  deleteGuardrail(
      request?: protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest|undefined, {}|undefined
      ]>;
  deleteGuardrail(
      request: protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest|null|undefined,
          {}|null|undefined>): void;
  deleteGuardrail(
      request: protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest|null|undefined,
          {}|null|undefined>): void;
  deleteGuardrail(
      request?: protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteGuardrail request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteGuardrail response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteGuardrail(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteGuardrailRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteGuardrail response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified deployment.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The name of the deployment.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Deployment|Deployment}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_deployment.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetDeployment_async
 */
  getDeployment(
      request?: protos.google.cloud.ces.v1beta.IGetDeploymentRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.IGetDeploymentRequest|undefined, {}|undefined
      ]>;
  getDeployment(
      request: protos.google.cloud.ces.v1beta.IGetDeploymentRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.IGetDeploymentRequest|null|undefined,
          {}|null|undefined>): void;
  getDeployment(
      request: protos.google.cloud.ces.v1beta.IGetDeploymentRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.IGetDeploymentRequest|null|undefined,
          {}|null|undefined>): void;
  getDeployment(
      request?: protos.google.cloud.ces.v1beta.IGetDeploymentRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.IGetDeploymentRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.IGetDeploymentRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.IGetDeploymentRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getDeployment request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.IGetDeploymentRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getDeployment response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getDeployment(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.IGetDeploymentRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getDeployment response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates a new deployment in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The parent app.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {string} [request.deploymentId]
 *   Optional. The ID to use for the deployment, which will become the final
 *   component of the deployment's resource name. If not provided, a unique ID
 *   will be automatically assigned for the deployment.
 * @param {google.cloud.ces.v1beta.Deployment} request.deployment
 *   Required. The deployment to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Deployment|Deployment}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.create_deployment.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_CreateDeployment_async
 */
  createDeployment(
      request?: protos.google.cloud.ces.v1beta.ICreateDeploymentRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.ICreateDeploymentRequest|undefined, {}|undefined
      ]>;
  createDeployment(
      request: protos.google.cloud.ces.v1beta.ICreateDeploymentRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.ICreateDeploymentRequest|null|undefined,
          {}|null|undefined>): void;
  createDeployment(
      request: protos.google.cloud.ces.v1beta.ICreateDeploymentRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.ICreateDeploymentRequest|null|undefined,
          {}|null|undefined>): void;
  createDeployment(
      request?: protos.google.cloud.ces.v1beta.ICreateDeploymentRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.ICreateDeploymentRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.ICreateDeploymentRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.ICreateDeploymentRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createDeployment request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.ICreateDeploymentRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createDeployment response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createDeployment(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.ICreateDeploymentRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createDeployment response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates the specified deployment.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.Deployment} request.deployment
 *   Required. The deployment to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. The list of fields to update.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Deployment|Deployment}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.update_deployment.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_UpdateDeployment_async
 */
  updateDeployment(
      request?: protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest|undefined, {}|undefined
      ]>;
  updateDeployment(
      request: protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest|null|undefined,
          {}|null|undefined>): void;
  updateDeployment(
      request: protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest|null|undefined,
          {}|null|undefined>): void;
  updateDeployment(
      request?: protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IDeployment,
          protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'deployment.name': request.deployment!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateDeployment request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateDeployment response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateDeployment(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IDeployment,
        protos.google.cloud.ces.v1beta.IUpdateDeploymentRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateDeployment response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes the specified deployment.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The name of the deployment to delete.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
 * @param {string} [request.etag]
 *   Optional. The etag of the deployment.
 *   If an etag is provided and does not match the current etag of the
 *   deployment, deletion will be blocked and an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_deployment.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteDeployment_async
 */
  deleteDeployment(
      request?: protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest|undefined, {}|undefined
      ]>;
  deleteDeployment(
      request: protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest|null|undefined,
          {}|null|undefined>): void;
  deleteDeployment(
      request: protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest|null|undefined,
          {}|null|undefined>): void;
  deleteDeployment(
      request?: protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteDeployment request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteDeployment response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteDeployment(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteDeploymentRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteDeployment response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified toolset.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the toolset to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Toolset|Toolset}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_toolset.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetToolset_async
 */
  getToolset(
      request?: protos.google.cloud.ces.v1beta.IGetToolsetRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.IGetToolsetRequest|undefined, {}|undefined
      ]>;
  getToolset(
      request: protos.google.cloud.ces.v1beta.IGetToolsetRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.IGetToolsetRequest|null|undefined,
          {}|null|undefined>): void;
  getToolset(
      request: protos.google.cloud.ces.v1beta.IGetToolsetRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.IGetToolsetRequest|null|undefined,
          {}|null|undefined>): void;
  getToolset(
      request?: protos.google.cloud.ces.v1beta.IGetToolsetRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.IGetToolsetRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.IGetToolsetRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.IGetToolsetRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getToolset request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.IGetToolsetRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getToolset response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getToolset(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.IGetToolsetRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getToolset response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates a new toolset in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to create a toolset in.
 * @param {string} [request.toolsetId]
 *   Optional. The ID to use for the toolset, which will become the final
 *   component of the toolset's resource name. If not provided, a unique ID will
 *   be automatically assigned for the toolset.
 * @param {google.cloud.ces.v1beta.Toolset} request.toolset
 *   Required. The toolset to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Toolset|Toolset}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.create_toolset.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_CreateToolset_async
 */
  createToolset(
      request?: protos.google.cloud.ces.v1beta.ICreateToolsetRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.ICreateToolsetRequest|undefined, {}|undefined
      ]>;
  createToolset(
      request: protos.google.cloud.ces.v1beta.ICreateToolsetRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.ICreateToolsetRequest|null|undefined,
          {}|null|undefined>): void;
  createToolset(
      request: protos.google.cloud.ces.v1beta.ICreateToolsetRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.ICreateToolsetRequest|null|undefined,
          {}|null|undefined>): void;
  createToolset(
      request?: protos.google.cloud.ces.v1beta.ICreateToolsetRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.ICreateToolsetRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.ICreateToolsetRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.ICreateToolsetRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createToolset request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.ICreateToolsetRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createToolset response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createToolset(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.ICreateToolsetRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createToolset response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates the specified toolset.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.Toolset} request.toolset
 *   Required. The toolset to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Toolset|Toolset}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.update_toolset.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_UpdateToolset_async
 */
  updateToolset(
      request?: protos.google.cloud.ces.v1beta.IUpdateToolsetRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.IUpdateToolsetRequest|undefined, {}|undefined
      ]>;
  updateToolset(
      request: protos.google.cloud.ces.v1beta.IUpdateToolsetRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.IUpdateToolsetRequest|null|undefined,
          {}|null|undefined>): void;
  updateToolset(
      request: protos.google.cloud.ces.v1beta.IUpdateToolsetRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.IUpdateToolsetRequest|null|undefined,
          {}|null|undefined>): void;
  updateToolset(
      request?: protos.google.cloud.ces.v1beta.IUpdateToolsetRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.IUpdateToolsetRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IToolset,
          protos.google.cloud.ces.v1beta.IUpdateToolsetRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.IUpdateToolsetRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'toolset.name': request.toolset!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateToolset request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.IUpdateToolsetRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateToolset response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateToolset(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IToolset,
        protos.google.cloud.ces.v1beta.IUpdateToolsetRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateToolset response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes the specified toolset.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the toolset to delete.
 * @param {boolean} [request.force]
 *   Optional. Indicates whether to forcefully delete the toolset, even if it is
 *   still referenced by app/agents.
 *
 *   *  If `force = false`, the deletion fails if any agents still
 *   reference the toolset.
 *   *  If `force = true`, all existing references from agents will be
 *   removed and the toolset will be deleted.
 * @param {string} [request.etag]
 *   Optional. The current etag of the toolset. If an etag is not provided, the
 *   deletion will overwrite any concurrent changes. If an etag is provided and
 *   does not match the current etag of the toolset, deletion will be blocked
 *   and an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_toolset.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteToolset_async
 */
  deleteToolset(
      request?: protos.google.cloud.ces.v1beta.IDeleteToolsetRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteToolsetRequest|undefined, {}|undefined
      ]>;
  deleteToolset(
      request: protos.google.cloud.ces.v1beta.IDeleteToolsetRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteToolsetRequest|null|undefined,
          {}|null|undefined>): void;
  deleteToolset(
      request: protos.google.cloud.ces.v1beta.IDeleteToolsetRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteToolsetRequest|null|undefined,
          {}|null|undefined>): void;
  deleteToolset(
      request?: protos.google.cloud.ces.v1beta.IDeleteToolsetRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteToolsetRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteToolsetRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteToolsetRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteToolset request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteToolsetRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteToolset response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteToolset(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteToolsetRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteToolset response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified app version.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the app version to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.AppVersion|AppVersion}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_app_version.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetAppVersion_async
 */
  getAppVersion(
      request?: protos.google.cloud.ces.v1beta.IGetAppVersionRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IAppVersion,
        protos.google.cloud.ces.v1beta.IGetAppVersionRequest|undefined, {}|undefined
      ]>;
  getAppVersion(
      request: protos.google.cloud.ces.v1beta.IGetAppVersionRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAppVersion,
          protos.google.cloud.ces.v1beta.IGetAppVersionRequest|null|undefined,
          {}|null|undefined>): void;
  getAppVersion(
      request: protos.google.cloud.ces.v1beta.IGetAppVersionRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAppVersion,
          protos.google.cloud.ces.v1beta.IGetAppVersionRequest|null|undefined,
          {}|null|undefined>): void;
  getAppVersion(
      request?: protos.google.cloud.ces.v1beta.IGetAppVersionRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IAppVersion,
          protos.google.cloud.ces.v1beta.IGetAppVersionRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IAppVersion,
          protos.google.cloud.ces.v1beta.IGetAppVersionRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IAppVersion,
        protos.google.cloud.ces.v1beta.IGetAppVersionRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getAppVersion request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IAppVersion,
        protos.google.cloud.ces.v1beta.IGetAppVersionRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getAppVersion response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getAppVersion(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IAppVersion,
        protos.google.cloud.ces.v1beta.IGetAppVersionRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getAppVersion response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates a new app version in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to create an app version in.
 * @param {string} [request.appVersionId]
 *   Optional. The ID to use for the app version, which will become the final
 *   component of the app version's resource name. If not provided, a unique ID
 *   will be automatically assigned for the app version.
 * @param {google.cloud.ces.v1beta.AppVersion} request.appVersion
 *   Required. The app version to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.AppVersion|AppVersion}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.create_app_version.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_CreateAppVersion_async
 */
  createAppVersion(
      request?: protos.google.cloud.ces.v1beta.ICreateAppVersionRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IAppVersion,
        protos.google.cloud.ces.v1beta.ICreateAppVersionRequest|undefined, {}|undefined
      ]>;
  createAppVersion(
      request: protos.google.cloud.ces.v1beta.ICreateAppVersionRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAppVersion,
          protos.google.cloud.ces.v1beta.ICreateAppVersionRequest|null|undefined,
          {}|null|undefined>): void;
  createAppVersion(
      request: protos.google.cloud.ces.v1beta.ICreateAppVersionRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IAppVersion,
          protos.google.cloud.ces.v1beta.ICreateAppVersionRequest|null|undefined,
          {}|null|undefined>): void;
  createAppVersion(
      request?: protos.google.cloud.ces.v1beta.ICreateAppVersionRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IAppVersion,
          protos.google.cloud.ces.v1beta.ICreateAppVersionRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IAppVersion,
          protos.google.cloud.ces.v1beta.ICreateAppVersionRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IAppVersion,
        protos.google.cloud.ces.v1beta.ICreateAppVersionRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createAppVersion request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IAppVersion,
        protos.google.cloud.ces.v1beta.ICreateAppVersionRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createAppVersion response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createAppVersion(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IAppVersion,
        protos.google.cloud.ces.v1beta.ICreateAppVersionRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createAppVersion response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes the specified app version.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the app version to delete.
 * @param {string} [request.etag]
 *   Optional. The current etag of the app version. If an etag is not provided,
 *   the deletion will overwrite any concurrent changes. If an etag is provided
 *   and does not match the current etag of the app version, deletion will be
 *   blocked and an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_app_version.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteAppVersion_async
 */
  deleteAppVersion(
      request?: protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest|undefined, {}|undefined
      ]>;
  deleteAppVersion(
      request: protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest|null|undefined,
          {}|null|undefined>): void;
  deleteAppVersion(
      request: protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest|null|undefined,
          {}|null|undefined>): void;
  deleteAppVersion(
      request?: protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteAppVersion request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteAppVersion response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteAppVersion(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteAppVersionRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteAppVersion response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets the specified changelog.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the changelog to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Changelog|Changelog}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.get_changelog.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_GetChangelog_async
 */
  getChangelog(
      request?: protos.google.cloud.ces.v1beta.IGetChangelogRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IChangelog,
        protos.google.cloud.ces.v1beta.IGetChangelogRequest|undefined, {}|undefined
      ]>;
  getChangelog(
      request: protos.google.cloud.ces.v1beta.IGetChangelogRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IChangelog,
          protos.google.cloud.ces.v1beta.IGetChangelogRequest|null|undefined,
          {}|null|undefined>): void;
  getChangelog(
      request: protos.google.cloud.ces.v1beta.IGetChangelogRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IChangelog,
          protos.google.cloud.ces.v1beta.IGetChangelogRequest|null|undefined,
          {}|null|undefined>): void;
  getChangelog(
      request?: protos.google.cloud.ces.v1beta.IGetChangelogRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IChangelog,
          protos.google.cloud.ces.v1beta.IGetChangelogRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IChangelog,
          protos.google.cloud.ces.v1beta.IGetChangelogRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IChangelog,
        protos.google.cloud.ces.v1beta.IGetChangelogRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getChangelog request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IChangelog,
        protos.google.cloud.ces.v1beta.IGetChangelogRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getChangelog response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getChangelog(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IChangelog,
        protos.google.cloud.ces.v1beta.IGetChangelogRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getChangelog response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }

/**
 * Creates a new app in the given project and location.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the location to create an app in.
 * @param {string} [request.appId]
 *   Optional. The ID to use for the app, which will become the final component
 *   of the app's resource name. If not provided, a unique ID will be
 *   automatically assigned for the app.
 * @param {google.cloud.ces.v1beta.App} request.app
 *   Required. The app to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.create_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_CreateApp_async
 */
  createApp(
      request?: protos.google.cloud.ces.v1beta.ICreateAppRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  createApp(
      request: protos.google.cloud.ces.v1beta.ICreateAppRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  createApp(
      request: protos.google.cloud.ces.v1beta.ICreateAppRequest,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  createApp(
      request?: protos.google.cloud.ces.v1beta.ICreateAppRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('createApp response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('createApp request %j', request);
    return this.innerApiCalls.createApp(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('createApp response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `createApp()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.create_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_CreateApp_async
 */
  async checkCreateAppProgress(name: string): Promise<LROperation<protos.google.cloud.ces.v1beta.App, protos.google.cloud.ces.v1beta.OperationMetadata>>{
    this._log.info('createApp long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.createApp, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.cloud.ces.v1beta.App, protos.google.cloud.ces.v1beta.OperationMetadata>;
  }
/**
 * Deletes the specified app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the app to delete.
 * @param {string} [request.etag]
 *   Optional. The current etag of the app. If an etag is not provided, the
 *   deletion will overwrite any concurrent changes. If an etag is provided and
 *   does not match the current etag of the app, deletion will be blocked and an
 *   ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteApp_async
 */
  deleteApp(
      request?: protos.google.cloud.ces.v1beta.IDeleteAppRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  deleteApp(
      request: protos.google.cloud.ces.v1beta.IDeleteAppRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  deleteApp(
      request: protos.google.cloud.ces.v1beta.IDeleteAppRequest,
      callback: Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  deleteApp(
      request?: protos.google.cloud.ces.v1beta.IDeleteAppRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('deleteApp response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('deleteApp request %j', request);
    return this.innerApiCalls.deleteApp(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('deleteApp response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `deleteApp()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.delete_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_DeleteApp_async
 */
  async checkDeleteAppProgress(name: string): Promise<LROperation<protos.google.protobuf.Empty, protos.google.cloud.ces.v1beta.OperationMetadata>>{
    this._log.info('deleteApp long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.deleteApp, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.protobuf.Empty, protos.google.cloud.ces.v1beta.OperationMetadata>;
  }
/**
 * Exports the specified app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the app to export.
 * @param {google.cloud.ces.v1beta.ExportAppRequest.ExportFormat} request.exportFormat
 *   Required. The format to export the app in.
 * @param {string} [request.gcsUri]
 *   Optional. The [Google Cloud
 *   Storage](https://cloud.google.com/storage/docs/) URI to which to export the
 *   app. The format of this URI must be `gs://<bucket-name>/<object-name>`. The
 *   exported app archive will be written directly to the specified GCS object.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.export_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ExportApp_async
 */
  exportApp(
      request?: protos.google.cloud.ces.v1beta.IExportAppRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  exportApp(
      request: protos.google.cloud.ces.v1beta.IExportAppRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  exportApp(
      request: protos.google.cloud.ces.v1beta.IExportAppRequest,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  exportApp(
      request?: protos.google.cloud.ces.v1beta.IExportAppRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('exportApp response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('exportApp request %j', request);
    return this.innerApiCalls.exportApp(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('exportApp response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `exportApp()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.export_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ExportApp_async
 */
  async checkExportAppProgress(name: string): Promise<LROperation<protos.google.cloud.ces.v1beta.ExportAppResponse, protos.google.cloud.ces.v1beta.OperationMetadata>>{
    this._log.info('exportApp long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.exportApp, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.cloud.ces.v1beta.ExportAppResponse, protos.google.cloud.ces.v1beta.OperationMetadata>;
  }
/**
 * Imports the specified app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.gcsUri
 *   The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
 *   from which to import app. The format of this URI must be
 *   `gs://<bucket-name>/<object-name>`.
 * @param {Buffer} request.appContent
 *   Raw bytes representing the compressed zip file with the app folder
 *   structure.
 * @param {string} request.parent
 *   Required. The parent resource name with the location of the app to import.
 * @param {string} [request.displayName]
 *   Optional. The display name of the app to import.
 *   * If the app is created on import, and the display name is specified,
 *   the imported app will use this display name. If a conflict is detected
 *   with an existing app, a timestamp will be appended to the display name
 *   to make it unique.
 *   * If the app is a reimport, this field should not be set. Providing a
 *   display name during reimport will result in an INVALID_ARGUMENT error.
 * @param {string} [request.appId]
 *   Optional. The ID to use for the imported app.
 *   *  If not specified, a unique ID will be automatically assigned for
 *   the app.
 *   *  Otherwise, the imported app will use this ID as the final component of
 *   its resource name. If an app with the same ID already exists at the
 *   specified location in the project, the content of the existing app will be
 *   replaced.
 * @param {google.cloud.ces.v1beta.ImportAppRequest.ImportOptions} [request.importOptions]
 *   Optional. Options governing the import process for the app.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.import_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ImportApp_async
 */
  importApp(
      request?: protos.google.cloud.ces.v1beta.IImportAppRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  importApp(
      request: protos.google.cloud.ces.v1beta.IImportAppRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  importApp(
      request: protos.google.cloud.ces.v1beta.IImportAppRequest,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  importApp(
      request?: protos.google.cloud.ces.v1beta.IImportAppRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('importApp response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('importApp request %j', request);
    return this.innerApiCalls.importApp(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('importApp response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `importApp()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.import_app.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ImportApp_async
 */
  async checkImportAppProgress(name: string): Promise<LROperation<protos.google.cloud.ces.v1beta.ImportAppResponse, protos.google.cloud.ces.v1beta.OperationMetadata>>{
    this._log.info('importApp long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.importApp, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.cloud.ces.v1beta.ImportAppResponse, protos.google.cloud.ces.v1beta.OperationMetadata>;
  }
/**
 * Batch deletes the specified conversations.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to delete conversations from.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {string[]} request.conversations
 *   Required. The resource names of the conversations to delete.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.batch_delete_conversations.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_BatchDeleteConversations_async
 */
  batchDeleteConversations(
      request?: protos.google.cloud.ces.v1beta.IBatchDeleteConversationsRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  batchDeleteConversations(
      request: protos.google.cloud.ces.v1beta.IBatchDeleteConversationsRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  batchDeleteConversations(
      request: protos.google.cloud.ces.v1beta.IBatchDeleteConversationsRequest,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  batchDeleteConversations(
      request?: protos.google.cloud.ces.v1beta.IBatchDeleteConversationsRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('batchDeleteConversations response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('batchDeleteConversations request %j', request);
    return this.innerApiCalls.batchDeleteConversations(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('batchDeleteConversations response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `batchDeleteConversations()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.batch_delete_conversations.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_BatchDeleteConversations_async
 */
  async checkBatchDeleteConversationsProgress(name: string): Promise<LROperation<protos.google.cloud.ces.v1beta.BatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.OperationMetadata>>{
    this._log.info('batchDeleteConversations long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.batchDeleteConversations, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.cloud.ces.v1beta.BatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.OperationMetadata>;
  }
/**
 * Restores the specified app version.
 * This will create a new app version from the current draft app and overwrite
 * the current draft with the specified app version.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the app version to restore.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.restore_app_version.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_RestoreAppVersion_async
 */
  restoreAppVersion(
      request?: protos.google.cloud.ces.v1beta.IRestoreAppVersionRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  restoreAppVersion(
      request: protos.google.cloud.ces.v1beta.IRestoreAppVersionRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  restoreAppVersion(
      request: protos.google.cloud.ces.v1beta.IRestoreAppVersionRequest,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  restoreAppVersion(
      request?: protos.google.cloud.ces.v1beta.IRestoreAppVersionRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('restoreAppVersion response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('restoreAppVersion request %j', request);
    return this.innerApiCalls.restoreAppVersion(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('restoreAppVersion response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `restoreAppVersion()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.restore_app_version.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_RestoreAppVersion_async
 */
  async checkRestoreAppVersionProgress(name: string): Promise<LROperation<protos.google.cloud.ces.v1beta.RestoreAppVersionResponse, protos.google.cloud.ces.v1beta.OperationMetadata>>{
    this._log.info('restoreAppVersion long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.restoreAppVersion, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.cloud.ces.v1beta.RestoreAppVersionResponse, protos.google.cloud.ces.v1beta.OperationMetadata>;
  }
 /**
 * Lists apps in the given project and location.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the location to list apps from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListAppsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListApps|AgentService.ListApps}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the apps.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.App|App}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listAppsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listApps(
      request?: protos.google.cloud.ces.v1beta.IListAppsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IApp[],
        protos.google.cloud.ces.v1beta.IListAppsRequest|null,
        protos.google.cloud.ces.v1beta.IListAppsResponse
      ]>;
  listApps(
      request: protos.google.cloud.ces.v1beta.IListAppsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAppsRequest,
          protos.google.cloud.ces.v1beta.IListAppsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IApp>): void;
  listApps(
      request: protos.google.cloud.ces.v1beta.IListAppsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAppsRequest,
          protos.google.cloud.ces.v1beta.IListAppsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IApp>): void;
  listApps(
      request?: protos.google.cloud.ces.v1beta.IListAppsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAppsRequest,
          protos.google.cloud.ces.v1beta.IListAppsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IApp>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAppsRequest,
          protos.google.cloud.ces.v1beta.IListAppsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IApp>):
      Promise<[
        protos.google.cloud.ces.v1beta.IApp[],
        protos.google.cloud.ces.v1beta.IListAppsRequest|null,
        protos.google.cloud.ces.v1beta.IListAppsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListAppsRequest,
      protos.google.cloud.ces.v1beta.IListAppsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IApp>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listApps values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listApps request %j', request);
    return this.innerApiCalls
      .listApps(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IApp[],
        protos.google.cloud.ces.v1beta.IListAppsRequest|null,
        protos.google.cloud.ces.v1beta.IListAppsResponse
      ]) => {
        this._log.info('listApps values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listApps`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the location to list apps from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListAppsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListApps|AgentService.ListApps}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the apps.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.App|App} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listAppsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listAppsStream(
      request?: protos.google.cloud.ces.v1beta.IListAppsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listApps'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listApps stream %j', request);
    return this.descriptors.page.listApps.createStream(
      this.innerApiCalls.listApps as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listApps`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the location to list apps from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListAppsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListApps|AgentService.ListApps}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the apps.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.App|App}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_apps.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListApps_async
 */
  listAppsAsync(
      request?: protos.google.cloud.ces.v1beta.IListAppsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IApp>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listApps'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listApps iterate %j', request);
    return this.descriptors.page.listApps.asyncIterate(
      this.innerApiCalls['listApps'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IApp>;
  }
 /**
 * Lists agents in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list agents from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListAgentsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListAgents|AgentService.ListAgents}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the agents.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.Agent|Agent}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listAgentsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listAgents(
      request?: protos.google.cloud.ces.v1beta.IListAgentsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IAgent[],
        protos.google.cloud.ces.v1beta.IListAgentsRequest|null,
        protos.google.cloud.ces.v1beta.IListAgentsResponse
      ]>;
  listAgents(
      request: protos.google.cloud.ces.v1beta.IListAgentsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAgentsRequest,
          protos.google.cloud.ces.v1beta.IListAgentsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IAgent>): void;
  listAgents(
      request: protos.google.cloud.ces.v1beta.IListAgentsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAgentsRequest,
          protos.google.cloud.ces.v1beta.IListAgentsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IAgent>): void;
  listAgents(
      request?: protos.google.cloud.ces.v1beta.IListAgentsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAgentsRequest,
          protos.google.cloud.ces.v1beta.IListAgentsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IAgent>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAgentsRequest,
          protos.google.cloud.ces.v1beta.IListAgentsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IAgent>):
      Promise<[
        protos.google.cloud.ces.v1beta.IAgent[],
        protos.google.cloud.ces.v1beta.IListAgentsRequest|null,
        protos.google.cloud.ces.v1beta.IListAgentsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListAgentsRequest,
      protos.google.cloud.ces.v1beta.IListAgentsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IAgent>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listAgents values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listAgents request %j', request);
    return this.innerApiCalls
      .listAgents(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IAgent[],
        protos.google.cloud.ces.v1beta.IListAgentsRequest|null,
        protos.google.cloud.ces.v1beta.IListAgentsResponse
      ]) => {
        this._log.info('listAgents values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listAgents`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list agents from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListAgentsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListAgents|AgentService.ListAgents}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the agents.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.Agent|Agent} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listAgentsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listAgentsStream(
      request?: protos.google.cloud.ces.v1beta.IListAgentsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listAgents'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listAgents stream %j', request);
    return this.descriptors.page.listAgents.createStream(
      this.innerApiCalls.listAgents as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listAgents`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list agents from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListAgentsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListAgents|AgentService.ListAgents}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the agents.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.Agent|Agent}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_agents.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListAgents_async
 */
  listAgentsAsync(
      request?: protos.google.cloud.ces.v1beta.IListAgentsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IAgent>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listAgents'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listAgents iterate %j', request);
    return this.descriptors.page.listAgents.asyncIterate(
      this.innerApiCalls['listAgents'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IAgent>;
  }
 /**
 * Lists examples in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list examples from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListExamplesResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListExamples|AgentService.ListExamples}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the examples.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.Example|Example}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listExamplesAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listExamples(
      request?: protos.google.cloud.ces.v1beta.IListExamplesRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IExample[],
        protos.google.cloud.ces.v1beta.IListExamplesRequest|null,
        protos.google.cloud.ces.v1beta.IListExamplesResponse
      ]>;
  listExamples(
      request: protos.google.cloud.ces.v1beta.IListExamplesRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListExamplesRequest,
          protos.google.cloud.ces.v1beta.IListExamplesResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IExample>): void;
  listExamples(
      request: protos.google.cloud.ces.v1beta.IListExamplesRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListExamplesRequest,
          protos.google.cloud.ces.v1beta.IListExamplesResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IExample>): void;
  listExamples(
      request?: protos.google.cloud.ces.v1beta.IListExamplesRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListExamplesRequest,
          protos.google.cloud.ces.v1beta.IListExamplesResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IExample>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListExamplesRequest,
          protos.google.cloud.ces.v1beta.IListExamplesResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IExample>):
      Promise<[
        protos.google.cloud.ces.v1beta.IExample[],
        protos.google.cloud.ces.v1beta.IListExamplesRequest|null,
        protos.google.cloud.ces.v1beta.IListExamplesResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListExamplesRequest,
      protos.google.cloud.ces.v1beta.IListExamplesResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IExample>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listExamples values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listExamples request %j', request);
    return this.innerApiCalls
      .listExamples(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IExample[],
        protos.google.cloud.ces.v1beta.IListExamplesRequest|null,
        protos.google.cloud.ces.v1beta.IListExamplesResponse
      ]) => {
        this._log.info('listExamples values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listExamples`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list examples from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListExamplesResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListExamples|AgentService.ListExamples}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the examples.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.Example|Example} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listExamplesAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listExamplesStream(
      request?: protos.google.cloud.ces.v1beta.IListExamplesRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listExamples'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listExamples stream %j', request);
    return this.descriptors.page.listExamples.createStream(
      this.innerApiCalls.listExamples as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listExamples`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list examples from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListExamplesResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListExamples|AgentService.ListExamples}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the examples.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.Example|Example}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_examples.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListExamples_async
 */
  listExamplesAsync(
      request?: protos.google.cloud.ces.v1beta.IListExamplesRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IExample>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listExamples'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listExamples iterate %j', request);
    return this.descriptors.page.listExamples.asyncIterate(
      this.innerApiCalls['listExamples'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IExample>;
  }
 /**
 * Lists tools in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list tools from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListToolsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListTools|AgentService.ListTools}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the tools. Use
 *   "include_system_tools=true" to include system tools in the response. See
 *   https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.Tool|Tool}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listToolsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listTools(
      request?: protos.google.cloud.ces.v1beta.IListToolsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.ITool[],
        protos.google.cloud.ces.v1beta.IListToolsRequest|null,
        protos.google.cloud.ces.v1beta.IListToolsResponse
      ]>;
  listTools(
      request: protos.google.cloud.ces.v1beta.IListToolsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListToolsRequest,
          protos.google.cloud.ces.v1beta.IListToolsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.ITool>): void;
  listTools(
      request: protos.google.cloud.ces.v1beta.IListToolsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListToolsRequest,
          protos.google.cloud.ces.v1beta.IListToolsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.ITool>): void;
  listTools(
      request?: protos.google.cloud.ces.v1beta.IListToolsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListToolsRequest,
          protos.google.cloud.ces.v1beta.IListToolsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.ITool>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListToolsRequest,
          protos.google.cloud.ces.v1beta.IListToolsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.ITool>):
      Promise<[
        protos.google.cloud.ces.v1beta.ITool[],
        protos.google.cloud.ces.v1beta.IListToolsRequest|null,
        protos.google.cloud.ces.v1beta.IListToolsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListToolsRequest,
      protos.google.cloud.ces.v1beta.IListToolsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.ITool>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listTools values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listTools request %j', request);
    return this.innerApiCalls
      .listTools(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.ITool[],
        protos.google.cloud.ces.v1beta.IListToolsRequest|null,
        protos.google.cloud.ces.v1beta.IListToolsResponse
      ]) => {
        this._log.info('listTools values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listTools`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list tools from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListToolsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListTools|AgentService.ListTools}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the tools. Use
 *   "include_system_tools=true" to include system tools in the response. See
 *   https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.Tool|Tool} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listToolsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listToolsStream(
      request?: protos.google.cloud.ces.v1beta.IListToolsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listTools'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listTools stream %j', request);
    return this.descriptors.page.listTools.createStream(
      this.innerApiCalls.listTools as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listTools`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list tools from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListToolsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListTools|AgentService.ListTools}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the tools. Use
 *   "include_system_tools=true" to include system tools in the response. See
 *   https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.Tool|Tool}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_tools.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListTools_async
 */
  listToolsAsync(
      request?: protos.google.cloud.ces.v1beta.IListToolsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.ITool>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listTools'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listTools iterate %j', request);
    return this.descriptors.page.listTools.asyncIterate(
      this.innerApiCalls['listTools'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.ITool>;
  }
 /**
 * Lists conversations in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list conversations from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListConversationsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListConversations|AgentService.ListConversations}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the conversations.
 *   See https://google.aip.dev/160 for more details.
 * @param {google.cloud.ces.v1beta.Conversation.Source} [request.source]
 *   Optional. Indicate the source of the conversation. If not set, Source.Live
 *   will be applied by default.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.Conversation|Conversation}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listConversationsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listConversations(
      request?: protos.google.cloud.ces.v1beta.IListConversationsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IConversation[],
        protos.google.cloud.ces.v1beta.IListConversationsRequest|null,
        protos.google.cloud.ces.v1beta.IListConversationsResponse
      ]>;
  listConversations(
      request: protos.google.cloud.ces.v1beta.IListConversationsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListConversationsRequest,
          protos.google.cloud.ces.v1beta.IListConversationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IConversation>): void;
  listConversations(
      request: protos.google.cloud.ces.v1beta.IListConversationsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListConversationsRequest,
          protos.google.cloud.ces.v1beta.IListConversationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IConversation>): void;
  listConversations(
      request?: protos.google.cloud.ces.v1beta.IListConversationsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListConversationsRequest,
          protos.google.cloud.ces.v1beta.IListConversationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IConversation>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListConversationsRequest,
          protos.google.cloud.ces.v1beta.IListConversationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IConversation>):
      Promise<[
        protos.google.cloud.ces.v1beta.IConversation[],
        protos.google.cloud.ces.v1beta.IListConversationsRequest|null,
        protos.google.cloud.ces.v1beta.IListConversationsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListConversationsRequest,
      protos.google.cloud.ces.v1beta.IListConversationsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IConversation>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listConversations values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listConversations request %j', request);
    return this.innerApiCalls
      .listConversations(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IConversation[],
        protos.google.cloud.ces.v1beta.IListConversationsRequest|null,
        protos.google.cloud.ces.v1beta.IListConversationsResponse
      ]) => {
        this._log.info('listConversations values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listConversations`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list conversations from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListConversationsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListConversations|AgentService.ListConversations}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the conversations.
 *   See https://google.aip.dev/160 for more details.
 * @param {google.cloud.ces.v1beta.Conversation.Source} [request.source]
 *   Optional. Indicate the source of the conversation. If not set, Source.Live
 *   will be applied by default.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.Conversation|Conversation} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listConversationsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listConversationsStream(
      request?: protos.google.cloud.ces.v1beta.IListConversationsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listConversations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listConversations stream %j', request);
    return this.descriptors.page.listConversations.createStream(
      this.innerApiCalls.listConversations as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listConversations`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list conversations from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListConversationsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListConversations|AgentService.ListConversations}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the conversations.
 *   See https://google.aip.dev/160 for more details.
 * @param {google.cloud.ces.v1beta.Conversation.Source} [request.source]
 *   Optional. Indicate the source of the conversation. If not set, Source.Live
 *   will be applied by default.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.Conversation|Conversation}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_conversations.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListConversations_async
 */
  listConversationsAsync(
      request?: protos.google.cloud.ces.v1beta.IListConversationsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IConversation>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listConversations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listConversations iterate %j', request);
    return this.descriptors.page.listConversations.asyncIterate(
      this.innerApiCalls['listConversations'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IConversation>;
  }
 /**
 * Lists guardrails in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list guardrails from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListGuardrailsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListGuardrails|AgentService.ListGuardrails}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the guardrails.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.Guardrail|Guardrail}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listGuardrailsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listGuardrails(
      request?: protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IGuardrail[],
        protos.google.cloud.ces.v1beta.IListGuardrailsRequest|null,
        protos.google.cloud.ces.v1beta.IListGuardrailsResponse
      ]>;
  listGuardrails(
      request: protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
          protos.google.cloud.ces.v1beta.IListGuardrailsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IGuardrail>): void;
  listGuardrails(
      request: protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
          protos.google.cloud.ces.v1beta.IListGuardrailsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IGuardrail>): void;
  listGuardrails(
      request?: protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
          protos.google.cloud.ces.v1beta.IListGuardrailsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IGuardrail>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
          protos.google.cloud.ces.v1beta.IListGuardrailsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IGuardrail>):
      Promise<[
        protos.google.cloud.ces.v1beta.IGuardrail[],
        protos.google.cloud.ces.v1beta.IListGuardrailsRequest|null,
        protos.google.cloud.ces.v1beta.IListGuardrailsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
      protos.google.cloud.ces.v1beta.IListGuardrailsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IGuardrail>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listGuardrails values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listGuardrails request %j', request);
    return this.innerApiCalls
      .listGuardrails(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IGuardrail[],
        protos.google.cloud.ces.v1beta.IListGuardrailsRequest|null,
        protos.google.cloud.ces.v1beta.IListGuardrailsResponse
      ]) => {
        this._log.info('listGuardrails values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listGuardrails`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list guardrails from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListGuardrailsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListGuardrails|AgentService.ListGuardrails}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the guardrails.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.Guardrail|Guardrail} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listGuardrailsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listGuardrailsStream(
      request?: protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listGuardrails'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listGuardrails stream %j', request);
    return this.descriptors.page.listGuardrails.createStream(
      this.innerApiCalls.listGuardrails as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listGuardrails`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list guardrails from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListGuardrailsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListGuardrails|AgentService.ListGuardrails}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the guardrails.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.Guardrail|Guardrail}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_guardrails.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListGuardrails_async
 */
  listGuardrailsAsync(
      request?: protos.google.cloud.ces.v1beta.IListGuardrailsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IGuardrail>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listGuardrails'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listGuardrails iterate %j', request);
    return this.descriptors.page.listGuardrails.asyncIterate(
      this.innerApiCalls['listGuardrails'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IGuardrail>;
  }
 /**
 * Lists deployments in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The parent app.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {number} [request.pageSize]
 *   Optional. The maximum number of deployments to return. The service may
 *   return fewer than this value. If unspecified, at most 50 deployments will
 *   be returned. The maximum value is 1000; values above 1000 will be coerced
 *   to 1000.
 * @param {string} [request.pageToken]
 *   Optional. A page token, received from a previous `ListDeployments` call.
 *   Provide this to retrieve the subsequent page.
 *
 *   When paginating, all other parameters provided to `ListDeployments` must
 *   match the call that provided the page token.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.Deployment|Deployment}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listDeploymentsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listDeployments(
      request?: protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IDeployment[],
        protos.google.cloud.ces.v1beta.IListDeploymentsRequest|null,
        protos.google.cloud.ces.v1beta.IListDeploymentsResponse
      ]>;
  listDeployments(
      request: protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
          protos.google.cloud.ces.v1beta.IListDeploymentsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IDeployment>): void;
  listDeployments(
      request: protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
          protos.google.cloud.ces.v1beta.IListDeploymentsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IDeployment>): void;
  listDeployments(
      request?: protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
          protos.google.cloud.ces.v1beta.IListDeploymentsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IDeployment>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
          protos.google.cloud.ces.v1beta.IListDeploymentsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IDeployment>):
      Promise<[
        protos.google.cloud.ces.v1beta.IDeployment[],
        protos.google.cloud.ces.v1beta.IListDeploymentsRequest|null,
        protos.google.cloud.ces.v1beta.IListDeploymentsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
      protos.google.cloud.ces.v1beta.IListDeploymentsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IDeployment>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listDeployments values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listDeployments request %j', request);
    return this.innerApiCalls
      .listDeployments(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IDeployment[],
        protos.google.cloud.ces.v1beta.IListDeploymentsRequest|null,
        protos.google.cloud.ces.v1beta.IListDeploymentsResponse
      ]) => {
        this._log.info('listDeployments values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listDeployments`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The parent app.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {number} [request.pageSize]
 *   Optional. The maximum number of deployments to return. The service may
 *   return fewer than this value. If unspecified, at most 50 deployments will
 *   be returned. The maximum value is 1000; values above 1000 will be coerced
 *   to 1000.
 * @param {string} [request.pageToken]
 *   Optional. A page token, received from a previous `ListDeployments` call.
 *   Provide this to retrieve the subsequent page.
 *
 *   When paginating, all other parameters provided to `ListDeployments` must
 *   match the call that provided the page token.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.Deployment|Deployment} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listDeploymentsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listDeploymentsStream(
      request?: protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listDeployments'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listDeployments stream %j', request);
    return this.descriptors.page.listDeployments.createStream(
      this.innerApiCalls.listDeployments as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listDeployments`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The parent app.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {number} [request.pageSize]
 *   Optional. The maximum number of deployments to return. The service may
 *   return fewer than this value. If unspecified, at most 50 deployments will
 *   be returned. The maximum value is 1000; values above 1000 will be coerced
 *   to 1000.
 * @param {string} [request.pageToken]
 *   Optional. A page token, received from a previous `ListDeployments` call.
 *   Provide this to retrieve the subsequent page.
 *
 *   When paginating, all other parameters provided to `ListDeployments` must
 *   match the call that provided the page token.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.Deployment|Deployment}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_deployments.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListDeployments_async
 */
  listDeploymentsAsync(
      request?: protos.google.cloud.ces.v1beta.IListDeploymentsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IDeployment>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listDeployments'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listDeployments iterate %j', request);
    return this.descriptors.page.listDeployments.asyncIterate(
      this.innerApiCalls['listDeployments'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IDeployment>;
  }
 /**
 * Lists toolsets in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list toolsets from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListToolsetsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListToolsets|AgentService.ListToolsets}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the toolsets.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.Toolset|Toolset}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listToolsetsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listToolsets(
      request?: protos.google.cloud.ces.v1beta.IListToolsetsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IToolset[],
        protos.google.cloud.ces.v1beta.IListToolsetsRequest|null,
        protos.google.cloud.ces.v1beta.IListToolsetsResponse
      ]>;
  listToolsets(
      request: protos.google.cloud.ces.v1beta.IListToolsetsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListToolsetsRequest,
          protos.google.cloud.ces.v1beta.IListToolsetsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IToolset>): void;
  listToolsets(
      request: protos.google.cloud.ces.v1beta.IListToolsetsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListToolsetsRequest,
          protos.google.cloud.ces.v1beta.IListToolsetsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IToolset>): void;
  listToolsets(
      request?: protos.google.cloud.ces.v1beta.IListToolsetsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListToolsetsRequest,
          protos.google.cloud.ces.v1beta.IListToolsetsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IToolset>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListToolsetsRequest,
          protos.google.cloud.ces.v1beta.IListToolsetsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IToolset>):
      Promise<[
        protos.google.cloud.ces.v1beta.IToolset[],
        protos.google.cloud.ces.v1beta.IListToolsetsRequest|null,
        protos.google.cloud.ces.v1beta.IListToolsetsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListToolsetsRequest,
      protos.google.cloud.ces.v1beta.IListToolsetsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IToolset>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listToolsets values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listToolsets request %j', request);
    return this.innerApiCalls
      .listToolsets(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IToolset[],
        protos.google.cloud.ces.v1beta.IListToolsetsRequest|null,
        protos.google.cloud.ces.v1beta.IListToolsetsResponse
      ]) => {
        this._log.info('listToolsets values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listToolsets`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list toolsets from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListToolsetsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListToolsets|AgentService.ListToolsets}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the toolsets.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.Toolset|Toolset} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listToolsetsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listToolsetsStream(
      request?: protos.google.cloud.ces.v1beta.IListToolsetsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listToolsets'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listToolsets stream %j', request);
    return this.descriptors.page.listToolsets.createStream(
      this.innerApiCalls.listToolsets as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listToolsets`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list toolsets from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListToolsetsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListToolsets|AgentService.ListToolsets}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the toolsets.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.Toolset|Toolset}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_toolsets.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListToolsets_async
 */
  listToolsetsAsync(
      request?: protos.google.cloud.ces.v1beta.IListToolsetsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IToolset>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listToolsets'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listToolsets iterate %j', request);
    return this.descriptors.page.listToolsets.asyncIterate(
      this.innerApiCalls['listToolsets'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IToolset>;
  }
 /**
 * Lists all app versions in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list app versions from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListAppVersionsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListAppVersions|AgentService.ListAppVersions}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the app versions.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.AppVersion|AppVersion}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listAppVersionsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listAppVersions(
      request?: protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IAppVersion[],
        protos.google.cloud.ces.v1beta.IListAppVersionsRequest|null,
        protos.google.cloud.ces.v1beta.IListAppVersionsResponse
      ]>;
  listAppVersions(
      request: protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
          protos.google.cloud.ces.v1beta.IListAppVersionsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IAppVersion>): void;
  listAppVersions(
      request: protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
          protos.google.cloud.ces.v1beta.IListAppVersionsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IAppVersion>): void;
  listAppVersions(
      request?: protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
          protos.google.cloud.ces.v1beta.IListAppVersionsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IAppVersion>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
          protos.google.cloud.ces.v1beta.IListAppVersionsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IAppVersion>):
      Promise<[
        protos.google.cloud.ces.v1beta.IAppVersion[],
        protos.google.cloud.ces.v1beta.IListAppVersionsRequest|null,
        protos.google.cloud.ces.v1beta.IListAppVersionsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
      protos.google.cloud.ces.v1beta.IListAppVersionsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IAppVersion>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listAppVersions values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listAppVersions request %j', request);
    return this.innerApiCalls
      .listAppVersions(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IAppVersion[],
        protos.google.cloud.ces.v1beta.IListAppVersionsRequest|null,
        protos.google.cloud.ces.v1beta.IListAppVersionsResponse
      ]) => {
        this._log.info('listAppVersions values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listAppVersions`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list app versions from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListAppVersionsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListAppVersions|AgentService.ListAppVersions}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the app versions.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.AppVersion|AppVersion} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listAppVersionsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listAppVersionsStream(
      request?: protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listAppVersions'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listAppVersions stream %j', request);
    return this.descriptors.page.listAppVersions.createStream(
      this.innerApiCalls.listAppVersions as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listAppVersions`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list app versions from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListAppVersionsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListAppVersions|AgentService.ListAppVersions}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the app versions.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.AppVersion|AppVersion}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_app_versions.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListAppVersions_async
 */
  listAppVersionsAsync(
      request?: protos.google.cloud.ces.v1beta.IListAppVersionsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IAppVersion>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listAppVersions'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listAppVersions iterate %j', request);
    return this.descriptors.page.listAppVersions.asyncIterate(
      this.innerApiCalls['listAppVersions'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IAppVersion>;
  }
 /**
 * Lists the changelogs of the specified app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list changelogs from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListChangelogsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListChangelogs|AgentService.ListChangelogs}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the changelogs.
 *   See https://google.aip.dev/160 for more details.
 *
 *   The filter string can be used to filter by `action`, `resource_type`,
 *   `resource_name`, `author`, and `create_time`.
 *   The `:` comparator can be used for case-insensitive partial matching on
 *   string fields, while `=` performs an exact case-sensitive match.
 *
 *   Examples:
 *   * `action:update` (case-insensitive partial match)
 *   * `action="Create"` (case-sensitive exact match)
 *   * `resource_type:agent`
 *   * `resource_name:my-agent`
 *   * `author:me@example.com`
 *   * `create_time > "2025-01-01T00:00:00Z"`
 *   * `create_time <= "2025-01-01T00:00:00Z" AND resource_type:tool`
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.Changelog|Changelog}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listChangelogsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listChangelogs(
      request?: protos.google.cloud.ces.v1beta.IListChangelogsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IChangelog[],
        protos.google.cloud.ces.v1beta.IListChangelogsRequest|null,
        protos.google.cloud.ces.v1beta.IListChangelogsResponse
      ]>;
  listChangelogs(
      request: protos.google.cloud.ces.v1beta.IListChangelogsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListChangelogsRequest,
          protos.google.cloud.ces.v1beta.IListChangelogsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IChangelog>): void;
  listChangelogs(
      request: protos.google.cloud.ces.v1beta.IListChangelogsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListChangelogsRequest,
          protos.google.cloud.ces.v1beta.IListChangelogsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IChangelog>): void;
  listChangelogs(
      request?: protos.google.cloud.ces.v1beta.IListChangelogsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListChangelogsRequest,
          protos.google.cloud.ces.v1beta.IListChangelogsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IChangelog>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListChangelogsRequest,
          protos.google.cloud.ces.v1beta.IListChangelogsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IChangelog>):
      Promise<[
        protos.google.cloud.ces.v1beta.IChangelog[],
        protos.google.cloud.ces.v1beta.IListChangelogsRequest|null,
        protos.google.cloud.ces.v1beta.IListChangelogsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListChangelogsRequest,
      protos.google.cloud.ces.v1beta.IListChangelogsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IChangelog>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listChangelogs values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listChangelogs request %j', request);
    return this.innerApiCalls
      .listChangelogs(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IChangelog[],
        protos.google.cloud.ces.v1beta.IListChangelogsRequest|null,
        protos.google.cloud.ces.v1beta.IListChangelogsResponse
      ]) => {
        this._log.info('listChangelogs values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listChangelogs`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list changelogs from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListChangelogsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListChangelogs|AgentService.ListChangelogs}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the changelogs.
 *   See https://google.aip.dev/160 for more details.
 *
 *   The filter string can be used to filter by `action`, `resource_type`,
 *   `resource_name`, `author`, and `create_time`.
 *   The `:` comparator can be used for case-insensitive partial matching on
 *   string fields, while `=` performs an exact case-sensitive match.
 *
 *   Examples:
 *   * `action:update` (case-insensitive partial match)
 *   * `action="Create"` (case-sensitive exact match)
 *   * `resource_type:agent`
 *   * `resource_name:my-agent`
 *   * `author:me@example.com`
 *   * `create_time > "2025-01-01T00:00:00Z"`
 *   * `create_time <= "2025-01-01T00:00:00Z" AND resource_type:tool`
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.Changelog|Changelog} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listChangelogsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listChangelogsStream(
      request?: protos.google.cloud.ces.v1beta.IListChangelogsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listChangelogs'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listChangelogs stream %j', request);
    return this.descriptors.page.listChangelogs.createStream(
      this.innerApiCalls.listChangelogs as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listChangelogs`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list changelogs from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListChangelogsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.AgentService.ListChangelogs|AgentService.ListChangelogs}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the changelogs.
 *   See https://google.aip.dev/160 for more details.
 *
 *   The filter string can be used to filter by `action`, `resource_type`,
 *   `resource_name`, `author`, and `create_time`.
 *   The `:` comparator can be used for case-insensitive partial matching on
 *   string fields, while `=` performs an exact case-sensitive match.
 *
 *   Examples:
 *   * `action:update` (case-insensitive partial match)
 *   * `action="Create"` (case-sensitive exact match)
 *   * `resource_type:agent`
 *   * `resource_name:my-agent`
 *   * `author:me@example.com`
 *   * `create_time > "2025-01-01T00:00:00Z"`
 *   * `create_time <= "2025-01-01T00:00:00Z" AND resource_type:tool`
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time" is supported.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.Changelog|Changelog}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/agent_service.list_changelogs.js</caption>
 * region_tag:ces_v1beta_generated_AgentService_ListChangelogs_async
 */
  listChangelogsAsync(
      request?: protos.google.cloud.ces.v1beta.IListChangelogsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IChangelog>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listChangelogs'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listChangelogs iterate %j', request);
    return this.descriptors.page.listChangelogs.asyncIterate(
      this.innerApiCalls['listChangelogs'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IChangelog>;
  }
/**
   * Gets information about a location.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Resource name for the location.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html | CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link google.cloud.location.Location | Location}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   * @example
   * ```
   * const [response] = await client.getLocation(request);
   * ```
   */
  getLocation(
    request: LocationProtos.google.cloud.location.IGetLocationRequest,
    options?:
      | gax.CallOptions
      | Callback<
          LocationProtos.google.cloud.location.ILocation,
          | LocationProtos.google.cloud.location.IGetLocationRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LocationProtos.google.cloud.location.ILocation,
      | LocationProtos.google.cloud.location.IGetLocationRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<LocationProtos.google.cloud.location.ILocation> {
    return this.locationsClient.getLocation(request, options, callback);
  }

/**
   * Lists information about the supported locations for this service. Returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   The resource that owns the locations collection, if applicable.
   * @param {string} request.filter
   *   The standard list filter.
   * @param {number} request.pageSize
   *   The standard list page size.
   * @param {string} request.pageToken
   *   The standard list page token.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
   *   When you iterate the returned iterable, each element will be an object representing
   *   {@link google.cloud.location.Location | Location}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   * @example
   * ```
   * const iterable = client.listLocationsAsync(request);
   * for await (const response of iterable) {
   *   // process response
   * }
   * ```
   */
  listLocationsAsync(
    request: LocationProtos.google.cloud.location.IListLocationsRequest,
    options?: CallOptions
  ): AsyncIterable<LocationProtos.google.cloud.location.ILocation> {
    return this.locationsClient.listLocationsAsync(request, options);
  }

/**
   * Gets the latest state of a long-running operation.  Clients can use this
   * method to poll the operation result at intervals as recommended by the API
   * service.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   *   e.g, timeout, retries, paginations, etc. See {@link
   *   https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions}
   *   for the details.
   * @param {function(?Error, ?Object)=} callback
   *   The function which will be called with the result of the API call.
   *
   *   The second parameter to the callback is an object representing
   *   {@link google.longrunning.Operation | google.longrunning.Operation}.
   * @return {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   * {@link google.longrunning.Operation | google.longrunning.Operation}.
   * The promise has a method named "cancel" which cancels the ongoing API call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * const name = '';
   * const [response] = await client.getOperation({name});
   * // doThingsWith(response)
   * ```
   */
  getOperation(
    request: protos.google.longrunning.GetOperationRequest,
    optionsOrCallback?:
      | gax.CallOptions
      | Callback<
          protos.google.longrunning.Operation,
          protos.google.longrunning.GetOperationRequest,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.longrunning.Operation,
      protos.google.longrunning.GetOperationRequest,
      {} | null | undefined
    >
  ): Promise<[protos.google.longrunning.Operation]> {
     let options: gax.CallOptions;
     if (typeof optionsOrCallback === 'function' && callback === undefined) {
       callback = optionsOrCallback;
       options = {};
     } else {
       options = optionsOrCallback as gax.CallOptions;
     }
     options = options || {};
     options.otherArgs = options.otherArgs || {};
     options.otherArgs.headers = options.otherArgs.headers || {};
     options.otherArgs.headers['x-goog-request-params'] =
       this._gaxModule.routingHeader.fromParams({
         name: request.name ?? '',
       });
    return this.operationsClient.getOperation(request, options, callback);
  }
  /**
   * Lists operations that match the specified filter in the request. If the
   * server doesn't support this method, it returns `UNIMPLEMENTED`. Returns an iterable object.
   *
   * For-await-of syntax is used with the iterable to recursively get response element on-demand.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation collection.
   * @param {string} request.filter - The standard list filter.
   * @param {number=} request.pageSize -
   *   The maximum number of resources contained in the underlying API
   *   response. If page streaming is performed per-resource, this
   *   parameter does not affect the return value. If page streaming is
   *   performed per-page, this determines the maximum number of
   *   resources in a page.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   *   e.g, timeout, retries, paginations, etc. See {@link
   *   https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions} for the
   *   details.
   * @returns {Object}
   *   An iterable Object that conforms to {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | iteration protocols}.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * for await (const response of client.listOperationsAsync(request));
   * // doThingsWith(response)
   * ```
   */
  listOperationsAsync(
    request: protos.google.longrunning.ListOperationsRequest,
    options?: gax.CallOptions
  ): AsyncIterable<protos.google.longrunning.IOperation> {
     options = options || {};
     options.otherArgs = options.otherArgs || {};
     options.otherArgs.headers = options.otherArgs.headers || {};
     options.otherArgs.headers['x-goog-request-params'] =
       this._gaxModule.routingHeader.fromParams({
         name: request.name ?? '',
       });
    return this.operationsClient.listOperationsAsync(request, options);
  }
  /**
   * Starts asynchronous cancellation on a long-running operation.  The server
   * makes a best effort to cancel the operation, but success is not
   * guaranteed.  If the server doesn't support this method, it returns
   * `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
   * {@link Operations.GetOperation} or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an {@link Operation.error} value with a {@link google.rpc.Status.code} of
   * 1, corresponding to `Code.CANCELLED`.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource to be cancelled.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   * e.g, timeout, retries, paginations, etc. See {@link
   * https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions} for the
   * details.
   * @param {function(?Error)=} callback
   *   The function which will be called with the result of the API call.
   * @return {Promise} - The promise which resolves when API call finishes.
   *   The promise has a method named "cancel" which cancels the ongoing API
   * call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * await client.cancelOperation({name: ''});
   * ```
   */
   cancelOperation(
    request: protos.google.longrunning.CancelOperationRequest,
    optionsOrCallback?:
      | gax.CallOptions
      | Callback<
          protos.google.longrunning.CancelOperationRequest,
          protos.google.protobuf.Empty,
          {} | undefined | null
        >,
    callback?: Callback<
      protos.google.longrunning.CancelOperationRequest,
      protos.google.protobuf.Empty,
      {} | undefined | null
    >
  ): Promise<protos.google.protobuf.Empty> {
     let options: gax.CallOptions;
     if (typeof optionsOrCallback === 'function' && callback === undefined) {
       callback = optionsOrCallback;
       options = {};
     } else {
       options = optionsOrCallback as gax.CallOptions;
     }
     options = options || {};
     options.otherArgs = options.otherArgs || {};
     options.otherArgs.headers = options.otherArgs.headers || {};
     options.otherArgs.headers['x-goog-request-params'] =
       this._gaxModule.routingHeader.fromParams({
         name: request.name ?? '',
       });
    return this.operationsClient.cancelOperation(request, options, callback);
  }

  /**
   * Deletes a long-running operation. This method indicates that the client is
   * no longer interested in the operation result. It does not cancel the
   * operation. If the server doesn't support this method, it returns
   * `google.rpc.Code.UNIMPLEMENTED`.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource to be deleted.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   * e.g, timeout, retries, paginations, etc. See {@link
   * https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions}
   * for the details.
   * @param {function(?Error)=} callback
   *   The function which will be called with the result of the API call.
   * @return {Promise} - The promise which resolves when API call finishes.
   *   The promise has a method named "cancel" which cancels the ongoing API
   * call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * await client.deleteOperation({name: ''});
   * ```
   */
  deleteOperation(
    request: protos.google.longrunning.DeleteOperationRequest,
    optionsOrCallback?:
      | gax.CallOptions
      | Callback<
          protos.google.protobuf.Empty,
          protos.google.longrunning.DeleteOperationRequest,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.protobuf.Empty,
      protos.google.longrunning.DeleteOperationRequest,
      {} | null | undefined
    >
  ): Promise<protos.google.protobuf.Empty> {
     let options: gax.CallOptions;
     if (typeof optionsOrCallback === 'function' && callback === undefined) {
       callback = optionsOrCallback;
       options = {};
     } else {
       options = optionsOrCallback as gax.CallOptions;
     }
     options = options || {};
     options.otherArgs = options.otherArgs || {};
     options.otherArgs.headers = options.otherArgs.headers || {};
     options.otherArgs.headers['x-goog-request-params'] =
       this._gaxModule.routingHeader.fromParams({
         name: request.name ?? '',
       });
    return this.operationsClient.deleteOperation(request, options, callback);
  }

  // --------------------
  // -- Path templates --
  // --------------------

  /**
   * Return a fully-qualified agent resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} agent
   * @returns {string} Resource name string.
   */
  agentPath(project:string,location:string,app:string,agent:string) {
    return this.pathTemplates.agentPathTemplate.render({
      project: project,
      location: location,
      app: app,
      agent: agent,
    });
  }

  /**
   * Parse the project from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).project;
  }

  /**
   * Parse the location from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).location;
  }

  /**
   * Parse the app from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).app;
  }

  /**
   * Parse the agent from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the agent.
   */
  matchAgentFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).agent;
  }

  /**
   * Return a fully-qualified app resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @returns {string} Resource name string.
   */
  appPath(project:string,location:string,app:string) {
    return this.pathTemplates.appPathTemplate.render({
      project: project,
      location: location,
      app: app,
    });
  }

  /**
   * Parse the project from App resource.
   *
   * @param {string} appName
   *   A fully-qualified path representing App resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromAppName(appName: string) {
    return this.pathTemplates.appPathTemplate.match(appName).project;
  }

  /**
   * Parse the location from App resource.
   *
   * @param {string} appName
   *   A fully-qualified path representing App resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromAppName(appName: string) {
    return this.pathTemplates.appPathTemplate.match(appName).location;
  }

  /**
   * Parse the app from App resource.
   *
   * @param {string} appName
   *   A fully-qualified path representing App resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromAppName(appName: string) {
    return this.pathTemplates.appPathTemplate.match(appName).app;
  }

  /**
   * Return a fully-qualified appVersion resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} version
   * @returns {string} Resource name string.
   */
  appVersionPath(project:string,location:string,app:string,version:string) {
    return this.pathTemplates.appVersionPathTemplate.render({
      project: project,
      location: location,
      app: app,
      version: version,
    });
  }

  /**
   * Parse the project from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).project;
  }

  /**
   * Parse the location from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).location;
  }

  /**
   * Parse the app from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).app;
  }

  /**
   * Parse the version from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the version.
   */
  matchVersionFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).version;
  }

  /**
   * Return a fully-qualified changelog resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} changelog
   * @returns {string} Resource name string.
   */
  changelogPath(project:string,location:string,app:string,changelog:string) {
    return this.pathTemplates.changelogPathTemplate.render({
      project: project,
      location: location,
      app: app,
      changelog: changelog,
    });
  }

  /**
   * Parse the project from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).project;
  }

  /**
   * Parse the location from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).location;
  }

  /**
   * Parse the app from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).app;
  }

  /**
   * Parse the changelog from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the changelog.
   */
  matchChangelogFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).changelog;
  }

  /**
   * Return a fully-qualified conversation resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} conversation
   * @returns {string} Resource name string.
   */
  conversationPath(project:string,location:string,app:string,conversation:string) {
    return this.pathTemplates.conversationPathTemplate.render({
      project: project,
      location: location,
      app: app,
      conversation: conversation,
    });
  }

  /**
   * Parse the project from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).project;
  }

  /**
   * Parse the location from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).location;
  }

  /**
   * Parse the app from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).app;
  }

  /**
   * Parse the conversation from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the conversation.
   */
  matchConversationFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).conversation;
  }

  /**
   * Return a fully-qualified deployment resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} deployment
   * @returns {string} Resource name string.
   */
  deploymentPath(project:string,location:string,app:string,deployment:string) {
    return this.pathTemplates.deploymentPathTemplate.render({
      project: project,
      location: location,
      app: app,
      deployment: deployment,
    });
  }

  /**
   * Parse the project from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).project;
  }

  /**
   * Parse the location from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).location;
  }

  /**
   * Parse the app from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).app;
  }

  /**
   * Parse the deployment from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the deployment.
   */
  matchDeploymentFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).deployment;
  }

  /**
   * Return a fully-qualified evaluation resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation
   * @returns {string} Resource name string.
   */
  evaluationPath(project:string,location:string,app:string,evaluation:string) {
    return this.pathTemplates.evaluationPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation: evaluation,
    });
  }

  /**
   * Parse the project from Evaluation resource.
   *
   * @param {string} evaluationName
   *   A fully-qualified path representing Evaluation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationName(evaluationName: string) {
    return this.pathTemplates.evaluationPathTemplate.match(evaluationName).project;
  }

  /**
   * Parse the location from Evaluation resource.
   *
   * @param {string} evaluationName
   *   A fully-qualified path representing Evaluation resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationName(evaluationName: string) {
    return this.pathTemplates.evaluationPathTemplate.match(evaluationName).location;
  }

  /**
   * Parse the app from Evaluation resource.
   *
   * @param {string} evaluationName
   *   A fully-qualified path representing Evaluation resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationName(evaluationName: string) {
    return this.pathTemplates.evaluationPathTemplate.match(evaluationName).app;
  }

  /**
   * Parse the evaluation from Evaluation resource.
   *
   * @param {string} evaluationName
   *   A fully-qualified path representing Evaluation resource.
   * @returns {string} A string representing the evaluation.
   */
  matchEvaluationFromEvaluationName(evaluationName: string) {
    return this.pathTemplates.evaluationPathTemplate.match(evaluationName).evaluation;
  }

  /**
   * Return a fully-qualified evaluationDataset resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation_dataset
   * @returns {string} Resource name string.
   */
  evaluationDatasetPath(project:string,location:string,app:string,evaluationDataset:string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation_dataset: evaluationDataset,
    });
  }

  /**
   * Parse the project from EvaluationDataset resource.
   *
   * @param {string} evaluationDatasetName
   *   A fully-qualified path representing EvaluationDataset resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationDatasetName(evaluationDatasetName: string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.match(evaluationDatasetName).project;
  }

  /**
   * Parse the location from EvaluationDataset resource.
   *
   * @param {string} evaluationDatasetName
   *   A fully-qualified path representing EvaluationDataset resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationDatasetName(evaluationDatasetName: string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.match(evaluationDatasetName).location;
  }

  /**
   * Parse the app from EvaluationDataset resource.
   *
   * @param {string} evaluationDatasetName
   *   A fully-qualified path representing EvaluationDataset resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationDatasetName(evaluationDatasetName: string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.match(evaluationDatasetName).app;
  }

  /**
   * Parse the evaluation_dataset from EvaluationDataset resource.
   *
   * @param {string} evaluationDatasetName
   *   A fully-qualified path representing EvaluationDataset resource.
   * @returns {string} A string representing the evaluation_dataset.
   */
  matchEvaluationDatasetFromEvaluationDatasetName(evaluationDatasetName: string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.match(evaluationDatasetName).evaluation_dataset;
  }

  /**
   * Return a fully-qualified evaluationExpectation resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation_expectation
   * @returns {string} Resource name string.
   */
  evaluationExpectationPath(project:string,location:string,app:string,evaluationExpectation:string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation_expectation: evaluationExpectation,
    });
  }

  /**
   * Parse the project from EvaluationExpectation resource.
   *
   * @param {string} evaluationExpectationName
   *   A fully-qualified path representing EvaluationExpectation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationExpectationName(evaluationExpectationName: string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.match(evaluationExpectationName).project;
  }

  /**
   * Parse the location from EvaluationExpectation resource.
   *
   * @param {string} evaluationExpectationName
   *   A fully-qualified path representing EvaluationExpectation resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationExpectationName(evaluationExpectationName: string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.match(evaluationExpectationName).location;
  }

  /**
   * Parse the app from EvaluationExpectation resource.
   *
   * @param {string} evaluationExpectationName
   *   A fully-qualified path representing EvaluationExpectation resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationExpectationName(evaluationExpectationName: string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.match(evaluationExpectationName).app;
  }

  /**
   * Parse the evaluation_expectation from EvaluationExpectation resource.
   *
   * @param {string} evaluationExpectationName
   *   A fully-qualified path representing EvaluationExpectation resource.
   * @returns {string} A string representing the evaluation_expectation.
   */
  matchEvaluationExpectationFromEvaluationExpectationName(evaluationExpectationName: string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.match(evaluationExpectationName).evaluation_expectation;
  }

  /**
   * Return a fully-qualified evaluationResult resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation
   * @param {string} evaluation_result
   * @returns {string} Resource name string.
   */
  evaluationResultPath(project:string,location:string,app:string,evaluation:string,evaluationResult:string) {
    return this.pathTemplates.evaluationResultPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation: evaluation,
      evaluation_result: evaluationResult,
    });
  }

  /**
   * Parse the project from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).project;
  }

  /**
   * Parse the location from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).location;
  }

  /**
   * Parse the app from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).app;
  }

  /**
   * Parse the evaluation from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the evaluation.
   */
  matchEvaluationFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).evaluation;
  }

  /**
   * Parse the evaluation_result from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the evaluation_result.
   */
  matchEvaluationResultFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).evaluation_result;
  }

  /**
   * Return a fully-qualified evaluationRun resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation_run
   * @returns {string} Resource name string.
   */
  evaluationRunPath(project:string,location:string,app:string,evaluationRun:string) {
    return this.pathTemplates.evaluationRunPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation_run: evaluationRun,
    });
  }

  /**
   * Parse the project from EvaluationRun resource.
   *
   * @param {string} evaluationRunName
   *   A fully-qualified path representing EvaluationRun resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationRunName(evaluationRunName: string) {
    return this.pathTemplates.evaluationRunPathTemplate.match(evaluationRunName).project;
  }

  /**
   * Parse the location from EvaluationRun resource.
   *
   * @param {string} evaluationRunName
   *   A fully-qualified path representing EvaluationRun resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationRunName(evaluationRunName: string) {
    return this.pathTemplates.evaluationRunPathTemplate.match(evaluationRunName).location;
  }

  /**
   * Parse the app from EvaluationRun resource.
   *
   * @param {string} evaluationRunName
   *   A fully-qualified path representing EvaluationRun resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationRunName(evaluationRunName: string) {
    return this.pathTemplates.evaluationRunPathTemplate.match(evaluationRunName).app;
  }

  /**
   * Parse the evaluation_run from EvaluationRun resource.
   *
   * @param {string} evaluationRunName
   *   A fully-qualified path representing EvaluationRun resource.
   * @returns {string} A string representing the evaluation_run.
   */
  matchEvaluationRunFromEvaluationRunName(evaluationRunName: string) {
    return this.pathTemplates.evaluationRunPathTemplate.match(evaluationRunName).evaluation_run;
  }

  /**
   * Return a fully-qualified example resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} example
   * @returns {string} Resource name string.
   */
  examplePath(project:string,location:string,app:string,example:string) {
    return this.pathTemplates.examplePathTemplate.render({
      project: project,
      location: location,
      app: app,
      example: example,
    });
  }

  /**
   * Parse the project from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).project;
  }

  /**
   * Parse the location from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).location;
  }

  /**
   * Parse the app from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).app;
  }

  /**
   * Parse the example from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the example.
   */
  matchExampleFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).example;
  }

  /**
   * Return a fully-qualified guardrail resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} guardrail
   * @returns {string} Resource name string.
   */
  guardrailPath(project:string,location:string,app:string,guardrail:string) {
    return this.pathTemplates.guardrailPathTemplate.render({
      project: project,
      location: location,
      app: app,
      guardrail: guardrail,
    });
  }

  /**
   * Parse the project from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).project;
  }

  /**
   * Parse the location from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).location;
  }

  /**
   * Parse the app from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).app;
  }

  /**
   * Parse the guardrail from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the guardrail.
   */
  matchGuardrailFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).guardrail;
  }

  /**
   * Return a fully-qualified location resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @returns {string} Resource name string.
   */
  locationPath(project:string,location:string) {
    return this.pathTemplates.locationPathTemplate.render({
      project: project,
      location: location,
    });
  }

  /**
   * Parse the project from Location resource.
   *
   * @param {string} locationName
   *   A fully-qualified path representing Location resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromLocationName(locationName: string) {
    return this.pathTemplates.locationPathTemplate.match(locationName).project;
  }

  /**
   * Parse the location from Location resource.
   *
   * @param {string} locationName
   *   A fully-qualified path representing Location resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromLocationName(locationName: string) {
    return this.pathTemplates.locationPathTemplate.match(locationName).location;
  }

  /**
   * Return a fully-qualified omnichannel resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} omnichannel
   * @returns {string} Resource name string.
   */
  omnichannelPath(project:string,location:string,omnichannel:string) {
    return this.pathTemplates.omnichannelPathTemplate.render({
      project: project,
      location: location,
      omnichannel: omnichannel,
    });
  }

  /**
   * Parse the project from Omnichannel resource.
   *
   * @param {string} omnichannelName
   *   A fully-qualified path representing Omnichannel resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromOmnichannelName(omnichannelName: string) {
    return this.pathTemplates.omnichannelPathTemplate.match(omnichannelName).project;
  }

  /**
   * Parse the location from Omnichannel resource.
   *
   * @param {string} omnichannelName
   *   A fully-qualified path representing Omnichannel resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromOmnichannelName(omnichannelName: string) {
    return this.pathTemplates.omnichannelPathTemplate.match(omnichannelName).location;
  }

  /**
   * Parse the omnichannel from Omnichannel resource.
   *
   * @param {string} omnichannelName
   *   A fully-qualified path representing Omnichannel resource.
   * @returns {string} A string representing the omnichannel.
   */
  matchOmnichannelFromOmnichannelName(omnichannelName: string) {
    return this.pathTemplates.omnichannelPathTemplate.match(omnichannelName).omnichannel;
  }

  /**
   * Return a fully-qualified project resource name string.
   *
   * @param {string} project
   * @returns {string} Resource name string.
   */
  projectPath(project:string) {
    return this.pathTemplates.projectPathTemplate.render({
      project: project,
    });
  }

  /**
   * Parse the project from Project resource.
   *
   * @param {string} projectName
   *   A fully-qualified path representing Project resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectName(projectName: string) {
    return this.pathTemplates.projectPathTemplate.match(projectName).project;
  }

  /**
   * Return a fully-qualified scheduledEvaluationRun resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} scheduled_evaluation_run
   * @returns {string} Resource name string.
   */
  scheduledEvaluationRunPath(project:string,location:string,app:string,scheduledEvaluationRun:string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.render({
      project: project,
      location: location,
      app: app,
      scheduled_evaluation_run: scheduledEvaluationRun,
    });
  }

  /**
   * Parse the project from ScheduledEvaluationRun resource.
   *
   * @param {string} scheduledEvaluationRunName
   *   A fully-qualified path representing ScheduledEvaluationRun resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromScheduledEvaluationRunName(scheduledEvaluationRunName: string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.match(scheduledEvaluationRunName).project;
  }

  /**
   * Parse the location from ScheduledEvaluationRun resource.
   *
   * @param {string} scheduledEvaluationRunName
   *   A fully-qualified path representing ScheduledEvaluationRun resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromScheduledEvaluationRunName(scheduledEvaluationRunName: string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.match(scheduledEvaluationRunName).location;
  }

  /**
   * Parse the app from ScheduledEvaluationRun resource.
   *
   * @param {string} scheduledEvaluationRunName
   *   A fully-qualified path representing ScheduledEvaluationRun resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromScheduledEvaluationRunName(scheduledEvaluationRunName: string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.match(scheduledEvaluationRunName).app;
  }

  /**
   * Parse the scheduled_evaluation_run from ScheduledEvaluationRun resource.
   *
   * @param {string} scheduledEvaluationRunName
   *   A fully-qualified path representing ScheduledEvaluationRun resource.
   * @returns {string} A string representing the scheduled_evaluation_run.
   */
  matchScheduledEvaluationRunFromScheduledEvaluationRunName(scheduledEvaluationRunName: string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.match(scheduledEvaluationRunName).scheduled_evaluation_run;
  }

  /**
   * Return a fully-qualified tool resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} tool
   * @returns {string} Resource name string.
   */
  toolPath(project:string,location:string,app:string,tool:string) {
    return this.pathTemplates.toolPathTemplate.render({
      project: project,
      location: location,
      app: app,
      tool: tool,
    });
  }

  /**
   * Parse the project from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).project;
  }

  /**
   * Parse the location from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).location;
  }

  /**
   * Parse the app from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).app;
  }

  /**
   * Parse the tool from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the tool.
   */
  matchToolFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).tool;
  }

  /**
   * Return a fully-qualified toolset resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} toolset
   * @returns {string} Resource name string.
   */
  toolsetPath(project:string,location:string,app:string,toolset:string) {
    return this.pathTemplates.toolsetPathTemplate.render({
      project: project,
      location: location,
      app: app,
      toolset: toolset,
    });
  }

  /**
   * Parse the project from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).project;
  }

  /**
   * Parse the location from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).location;
  }

  /**
   * Parse the app from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).app;
  }

  /**
   * Parse the toolset from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the toolset.
   */
  matchToolsetFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).toolset;
  }

  /**
   * Terminate the gRPC channel and close the client.
   *
   * The client will no longer be usable and all future behavior is undefined.
   * @returns {Promise} A promise that resolves when the client is closed.
   */
  close(): Promise<void> {
    if (this.agentServiceStub && !this._terminated) {
      return this.agentServiceStub.then(stub => {
        this._log.info('ending gRPC channel');
        this._terminated = true;
        stub.close();
        this.locationsClient.close().catch(err => {throw err});
        void this.operationsClient.close();
      });
    }
    return Promise.resolve();
  }
}