// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

/* global window */
import type * as gax from 'google-gax';
import type {Callback, CallOptions, Descriptors, ClientOptions, GrpcClientOptions, LROperation, PaginationCallback, GaxCall, LocationsClient, LocationProtos} from 'google-gax';
import {Transform} from 'stream';
import * as protos from '../../protos/protos';
import jsonProtos = require('../../protos/protos.json');
import {loggingUtils as logging, decodeAnyProtosInArray} from 'google-gax';

/**
 * Client JSON configuration object, loaded from
 * `src/v1beta/evaluation_service_client_config.json`.
 * This file defines retry strategy and timeouts for all API methods in this library.
 */
import * as gapicConfig from './evaluation_service_client_config.json';
const version = require('../../../package.json').version;

/**
 *  EvaluationService exposes methods to perform evaluation for the CES app.
 * @class
 * @memberof v1beta
 */
export class EvaluationServiceClient {
  private _terminated = false;
  private _opts: ClientOptions;
  private _providedCustomServicePath: boolean;
  private _gaxModule: typeof gax | typeof gax.fallback;
  private _gaxGrpc: gax.GrpcClient | gax.fallback.GrpcClient;
  private _protos: {};
  private _defaults: {[method: string]: gax.CallSettings};
  private _universeDomain: string;
  private _servicePath: string;
  private _log = logging.log('ces');

  auth: gax.GoogleAuth;
  descriptors: Descriptors = {
    page: {},
    stream: {},
    longrunning: {},
    batching: {},
  };
  warn: (code: string, message: string, warnType?: string) => void;
  innerApiCalls: {[name: string]: Function};
  locationsClient: LocationsClient;
  pathTemplates: {[name: string]: gax.PathTemplate};
  operationsClient: gax.OperationsClient;
  evaluationServiceStub?: Promise<{[name: string]: Function}>;

  /**
   * Construct an instance of EvaluationServiceClient.
   *
   * @param {object} [options] - The configuration object.
   * The options accepted by the constructor are described in detail
   * in [this document](https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#creating-the-client-instance).
   * The common options are:
   * @param {object} [options.credentials] - Credentials object.
   * @param {string} [options.credentials.client_email]
   * @param {string} [options.credentials.private_key]
   * @param {string} [options.email] - Account email address. Required when
   *     using a .pem or .p12 keyFilename.
   * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
   *     .p12 key downloaded from the Google Developers Console. If you provide
   *     a path to a JSON file, the projectId option below is not necessary.
   *     NOTE: .pem and .p12 require you to specify options.email as well.
   * @param {number} [options.port] - The port on which to connect to
   *     the remote host.
   * @param {string} [options.projectId] - The project ID from the Google
   *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
   *     the environment variable GCLOUD_PROJECT for your project ID. If your
   *     app is running in an environment which supports
   *     {@link https://cloud.google.com/docs/authentication/application-default-credentials Application Default Credentials},
   *     your project ID will be detected automatically.
   * @param {string} [options.apiEndpoint] - The domain name of the
   *     API remote host.
   * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
   *     Follows the structure of {@link gapicConfig}.
   * @param {boolean} [options.fallback] - Use HTTP/1.1 REST mode.
   *     For more information, please check the
   *     {@link https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#http11-rest-api-mode documentation}.
   * @param {gax} [gaxInstance]: loaded instance of `google-gax`. Useful if you
   *     need to avoid loading the default gRPC version and want to use the fallback
   *     HTTP implementation. Load only fallback version and pass it to the constructor:
   *     ```
   *     const gax = require('google-gax/build/src/fallback'); // avoids loading google-gax with gRPC
   *     const client = new EvaluationServiceClient({fallback: true}, gax);
   *     ```
   */
  constructor(opts?: ClientOptions, gaxInstance?: typeof gax | typeof gax.fallback) {
    // Ensure that options include all the required fields.
    const staticMembers = this.constructor as typeof EvaluationServiceClient;
    if (opts?.universe_domain && opts?.universeDomain && opts?.universe_domain !== opts?.universeDomain) {
      throw new Error('Please set either universe_domain or universeDomain, but not both.');
    }
    const universeDomainEnvVar = (typeof process === 'object' && typeof process.env === 'object') ? process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] : undefined;
    this._universeDomain = opts?.universeDomain ?? opts?.universe_domain ?? universeDomainEnvVar ?? 'googleapis.com';
    this._servicePath = 'ces.' + this._universeDomain;
    const servicePath = opts?.servicePath || opts?.apiEndpoint || this._servicePath;
    this._providedCustomServicePath = !!(opts?.servicePath || opts?.apiEndpoint);
    const port = opts?.port || staticMembers.port;
    const clientConfig = opts?.clientConfig ?? {};
    const fallback = opts?.fallback ?? (typeof window !== 'undefined' && typeof window?.fetch === 'function');
    opts = Object.assign({servicePath, port, clientConfig, fallback}, opts);

    // Request numeric enum values if REST transport is used.
    opts.numericEnums = true;

    // If scopes are unset in options and we're connecting to a non-default endpoint, set scopes just in case.
    if (servicePath !== this._servicePath && !('scopes' in opts)) {
      opts['scopes'] = staticMembers.scopes;
    }

    // Load google-gax module synchronously if needed
    if (!gaxInstance) {
      gaxInstance = require('google-gax') as typeof gax;
    }

    // Choose either gRPC or proto-over-HTTP implementation of google-gax.
    this._gaxModule = opts.fallback ? gaxInstance.fallback : gaxInstance;

    // Create a `gaxGrpc` object, with any grpc-specific options sent to the client.
    this._gaxGrpc = new this._gaxModule.GrpcClient(opts);

    // Save options to use in initialize() method.
    this._opts = opts;

    // Save the auth object to the client, for use by other methods.
    this.auth = (this._gaxGrpc.auth as gax.GoogleAuth);

    // Set useJWTAccessWithScope on the auth object.
    this.auth.useJWTAccessWithScope = true;

    // Set defaultServicePath on the auth object.
    this.auth.defaultServicePath = this._servicePath;

    // Set the default scopes in auth client if needed.
    if (servicePath === this._servicePath) {
      this.auth.defaultScopes = staticMembers.scopes;
    }
    this.locationsClient = new this._gaxModule.LocationsClient(
      this._gaxGrpc,
      opts
    );
  

    // Determine the client header string.
    const clientHeader = [
      `gax/${this._gaxModule.version}`,
      `gapic/${version}`,
    ];
    if (typeof process === 'object' && 'versions' in process) {
      clientHeader.push(`gl-node/${process.versions.node}`);
    } else {
      clientHeader.push(`gl-web/${this._gaxModule.version}`);
    }
    if (!opts.fallback) {
      clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
    } else {
      clientHeader.push(`rest/${this._gaxGrpc.grpcVersion}`);
    }
    if (opts.libName && opts.libVersion) {
      clientHeader.push(`${opts.libName}/${opts.libVersion}`);
    }
    // Load the applicable protos.
    this._protos = this._gaxGrpc.loadProtoJSON(jsonProtos);

    // This API contains "path templates"; forward-slash-separated
    // identifiers to uniquely identify resources within the API.
    // Create useful helper objects for these.
    this.pathTemplates = {
      agentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/agents/{agent}'
      ),
      appPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}'
      ),
      appVersionPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/versions/{version}'
      ),
      changelogPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/changelogs/{changelog}'
      ),
      conversationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}'
      ),
      deploymentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}'
      ),
      evaluationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}'
      ),
      evaluationDatasetPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluation_dataset}'
      ),
      evaluationExpectationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluationExpectations/{evaluation_expectation}'
      ),
      evaluationResultPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{evaluation_result}'
      ),
      evaluationRunPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluation_run}'
      ),
      examplePathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/examples/{example}'
      ),
      guardrailPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}'
      ),
      locationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}'
      ),
      omnichannelPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/omnichannels/{omnichannel}'
      ),
      projectPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}'
      ),
      scheduledEvaluationRunPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}'
      ),
      toolPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/tools/{tool}'
      ),
      toolsetPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}'
      ),
    };

    // Some of the methods on this service return "paged" results,
    // (e.g. 50 results at a time, with tokens to get subsequent
    // pages). Denote the keys used for pagination and results.
    this.descriptors.page = {
      listEvaluations:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'evaluations'),
      listEvaluationResults:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'evaluationResults'),
      listEvaluationDatasets:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'evaluationDatasets'),
      listEvaluationRuns:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'evaluationRuns'),
      listEvaluationExpectations:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'evaluationExpectations'),
      listScheduledEvaluationRuns:
          new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'scheduledEvaluationRuns')
    };

    const protoFilesRoot = this._gaxModule.protobufFromJSON(jsonProtos);
    // This API contains "long-running operations", which return a
    // an Operation object that allows for tracking of the operation,
    // rather than holding a request open.
    const lroOptions: GrpcClientOptions = {
      auth: this.auth,
      grpc: 'grpc' in this._gaxGrpc ? this._gaxGrpc.grpc : undefined
    };
    if (opts.fallback) {
      lroOptions.protoJson = protoFilesRoot;
      lroOptions.httpRules = [{selector: 'google.cloud.location.Locations.GetLocation',get: '/v1beta/{name=projects/*/locations/*}',},{selector: 'google.cloud.location.Locations.ListLocations',get: '/v1beta/{name=projects/*}/locations',},{selector: 'google.longrunning.Operations.CancelOperation',post: '/v1beta/{name=projects/*/locations/*/operations/*}:cancel',body: '*',},{selector: 'google.longrunning.Operations.DeleteOperation',delete: '/v1beta/{name=projects/*/locations/*/operations/*}',},{selector: 'google.longrunning.Operations.GetOperation',get: '/v1beta/{name=projects/*/locations/*/operations/*}',},{selector: 'google.longrunning.Operations.ListOperations',get: '/v1beta/{name=projects/*/locations/*}/operations',}];
    }
    this.operationsClient = this._gaxModule.lro(lroOptions).operationsClient(opts);
    const runEvaluationResponse = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.RunEvaluationResponse') as gax.protobuf.Type;
    const runEvaluationMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.RunEvaluationOperationMetadata') as gax.protobuf.Type;
    const generateEvaluationResponse = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.Evaluation') as gax.protobuf.Type;
    const generateEvaluationMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.GenerateEvaluationOperationMetadata') as gax.protobuf.Type;
    const importEvaluationsResponse = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.ImportEvaluationsResponse') as gax.protobuf.Type;
    const importEvaluationsMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.ImportEvaluationsOperationMetadata') as gax.protobuf.Type;
    const deleteEvaluationRunResponse = protoFilesRoot.lookup(
      '.google.protobuf.Empty') as gax.protobuf.Type;
    const deleteEvaluationRunMetadata = protoFilesRoot.lookup(
      '.google.cloud.ces.v1beta.DeleteEvaluationRunOperationMetadata') as gax.protobuf.Type;

    this.descriptors.longrunning = {
      runEvaluation: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        runEvaluationResponse.decode.bind(runEvaluationResponse),
        runEvaluationMetadata.decode.bind(runEvaluationMetadata)),
      generateEvaluation: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        generateEvaluationResponse.decode.bind(generateEvaluationResponse),
        generateEvaluationMetadata.decode.bind(generateEvaluationMetadata)),
      importEvaluations: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        importEvaluationsResponse.decode.bind(importEvaluationsResponse),
        importEvaluationsMetadata.decode.bind(importEvaluationsMetadata)),
      deleteEvaluationRun: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        deleteEvaluationRunResponse.decode.bind(deleteEvaluationRunResponse),
        deleteEvaluationRunMetadata.decode.bind(deleteEvaluationRunMetadata))
    };

    // Put together the default options sent with requests.
    this._defaults = this._gaxGrpc.constructSettings(
        'google.cloud.ces.v1beta.EvaluationService', gapicConfig as gax.ClientConfig,
        opts.clientConfig || {}, {'x-goog-api-client': clientHeader.join(' ')});

    // Set up a dictionary of "inner API calls"; the core implementation
    // of calling the API is handled in `google-gax`, with this code
    // merely providing the destination and request information.
    this.innerApiCalls = {};

    // Add a warn function to the client constructor so it can be easily tested.
    this.warn = this._gaxModule.warn;
  }

  /**
   * Initialize the client.
   * Performs asynchronous operations (such as authentication) and prepares the client.
   * This function will be called automatically when any class method is called for the
   * first time, but if you need to initialize it before calling an actual method,
   * feel free to call initialize() directly.
   *
   * You can await on this method if you want to make sure the client is initialized.
   *
   * @returns {Promise} A promise that resolves to an authenticated service stub.
   */
  initialize() {
    // If the client stub promise is already initialized, return immediately.
    if (this.evaluationServiceStub) {
      return this.evaluationServiceStub;
    }

    // Put together the "service stub" for
    // google.cloud.ces.v1beta.EvaluationService.
    this.evaluationServiceStub = this._gaxGrpc.createStub(
        this._opts.fallback ?
          (this._protos as protobuf.Root).lookupService('google.cloud.ces.v1beta.EvaluationService') :
          // eslint-disable-next-line @typescript-eslint/no-explicit-any
          (this._protos as any).google.cloud.ces.v1beta.EvaluationService,
        this._opts, this._providedCustomServicePath) as Promise<{[method: string]: Function}>;

    // Iterate over each of the methods that the service provides
    // and create an API call method for each.
    const evaluationServiceStubMethods =
        ['runEvaluation', 'createEvaluation', 'generateEvaluation', 'importEvaluations', 'createEvaluationDataset', 'updateEvaluation', 'updateEvaluationDataset', 'deleteEvaluation', 'deleteEvaluationResult', 'deleteEvaluationDataset', 'deleteEvaluationRun', 'getEvaluation', 'getEvaluationResult', 'getEvaluationDataset', 'getEvaluationRun', 'listEvaluations', 'listEvaluationResults', 'listEvaluationDatasets', 'listEvaluationRuns', 'listEvaluationExpectations', 'getEvaluationExpectation', 'createEvaluationExpectation', 'updateEvaluationExpectation', 'deleteEvaluationExpectation', 'createScheduledEvaluationRun', 'getScheduledEvaluationRun', 'listScheduledEvaluationRuns', 'updateScheduledEvaluationRun', 'deleteScheduledEvaluationRun', 'testPersonaVoice'];
    for (const methodName of evaluationServiceStubMethods) {
      const callPromise = this.evaluationServiceStub.then(
        stub => (...args: Array<{}>) => {
          if (this._terminated) {
            return Promise.reject('The client has already been closed.');
          }
          const func = stub[methodName];
          return func.apply(stub, args);
        },
        (err: Error|null|undefined) => () => {
          throw err;
        });

      const descriptor =
        this.descriptors.page[methodName] ||
        this.descriptors.longrunning[methodName] ||
        undefined;
      const apiCall = this._gaxModule.createApiCall(
        callPromise,
        this._defaults[methodName],
        descriptor,
        this._opts.fallback
      );

      this.innerApiCalls[methodName] = apiCall;
    }

    return this.evaluationServiceStub;
  }

  /**
   * The DNS address for this API service.
   * @deprecated Use the apiEndpoint method of the client instance.
   * @returns {string} The DNS address for this service.
   */
  static get servicePath() {
    if (typeof process === 'object' && typeof process.emitWarning === 'function') {
      process.emitWarning('Static servicePath is deprecated, please use the instance method instead.', 'DeprecationWarning');
    }
    return 'ces.googleapis.com';
  }

  /**
   * The DNS address for this API service - same as servicePath.
   * @deprecated Use the apiEndpoint method of the client instance.
   * @returns {string} The DNS address for this service.
   */
  static get apiEndpoint() {
    if (typeof process === 'object' && typeof process.emitWarning === 'function') {
      process.emitWarning('Static apiEndpoint is deprecated, please use the instance method instead.', 'DeprecationWarning');
    }
    return 'ces.googleapis.com';
  }

  /**
   * The DNS address for this API service.
   * @returns {string} The DNS address for this service.
   */
  get apiEndpoint() {
    return this._servicePath;
  }

  get universeDomain() {
    return this._universeDomain;
  }

  /**
   * The port for this API service.
   * @returns {number} The default port for this service.
   */
  static get port() {
    return 443;
  }

  /**
   * The scopes needed to make gRPC calls for every method defined
   * in this service.
   * @returns {string[]} List of default scopes.
   */
  static get scopes() {
    return [
      'https://www.googleapis.com/auth/ces',
      'https://www.googleapis.com/auth/cloud-platform'
    ];
  }

  getProjectId(): Promise<string>;
  getProjectId(callback: Callback<string, undefined, undefined>): void;
  /**
   * Return the project ID used by this class.
   * @returns {Promise} A promise that resolves to string containing the project ID.
   */
  getProjectId(callback?: Callback<string, undefined, undefined>):
      Promise<string>|void {
    if (callback) {
      this.auth.getProjectId(callback);
      return;
    }
    return this.auth.getProjectId();
  }

  // -------------------
  // -- Service calls --
  // -------------------
/**
 * Creates an evaluation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The app to create the evaluation for.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {string} [request.evaluationId]
 *   Optional. The ID to use for the evaluation, which will become the final
 *   component of the evaluation's resource name. If not provided, a unique ID
 *   will be automatically assigned for the evaluation.
 * @param {google.cloud.ces.v1beta.Evaluation} request.evaluation
 *   Required. The evaluation to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Evaluation|Evaluation}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.create_evaluation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_CreateEvaluation_async
 */
  createEvaluation(
      request?: protos.google.cloud.ces.v1beta.ICreateEvaluationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.ICreateEvaluationRequest|undefined, {}|undefined
      ]>;
  createEvaluation(
      request: protos.google.cloud.ces.v1beta.ICreateEvaluationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.ICreateEvaluationRequest|null|undefined,
          {}|null|undefined>): void;
  createEvaluation(
      request: protos.google.cloud.ces.v1beta.ICreateEvaluationRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.ICreateEvaluationRequest|null|undefined,
          {}|null|undefined>): void;
  createEvaluation(
      request?: protos.google.cloud.ces.v1beta.ICreateEvaluationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.ICreateEvaluationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.ICreateEvaluationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.ICreateEvaluationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createEvaluation request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.ICreateEvaluationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createEvaluation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createEvaluation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.ICreateEvaluationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createEvaluation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates an evaluation dataset.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The app to create the evaluation for.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {string} [request.evaluationDatasetId]
 *   Optional. The ID to use for the evaluation dataset, which will become the
 *   final component of the evaluation dataset's resource name. If not provided,
 *   a unique ID will be automatically assigned for the evaluation.
 * @param {google.cloud.ces.v1beta.EvaluationDataset} request.evaluationDataset
 *   Required. The evaluation dataset to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.EvaluationDataset|EvaluationDataset}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.create_evaluation_dataset.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_CreateEvaluationDataset_async
 */
  createEvaluationDataset(
      request?: protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest|undefined, {}|undefined
      ]>;
  createEvaluationDataset(
      request: protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>): void;
  createEvaluationDataset(
      request: protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>): void;
  createEvaluationDataset(
      request?: protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createEvaluationDataset request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createEvaluationDataset response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createEvaluationDataset(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.ICreateEvaluationDatasetRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createEvaluationDataset response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates an evaluation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.Evaluation} request.evaluation
 *   Required. The evaluation to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Evaluation|Evaluation}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.update_evaluation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_UpdateEvaluation_async
 */
  updateEvaluation(
      request?: protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest|undefined, {}|undefined
      ]>;
  updateEvaluation(
      request: protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest|null|undefined,
          {}|null|undefined>): void;
  updateEvaluation(
      request: protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest|null|undefined,
          {}|null|undefined>): void;
  updateEvaluation(
      request?: protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'evaluation.name': request.evaluation!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateEvaluation request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateEvaluation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateEvaluation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateEvaluation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates an evaluation dataset.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.EvaluationDataset} request.evaluationDataset
 *   Required. The evaluation dataset to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.EvaluationDataset|EvaluationDataset}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.update_evaluation_dataset.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_UpdateEvaluationDataset_async
 */
  updateEvaluationDataset(
      request?: protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest|undefined, {}|undefined
      ]>;
  updateEvaluationDataset(
      request: protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>): void;
  updateEvaluationDataset(
      request: protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>): void;
  updateEvaluationDataset(
      request?: protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'evaluation_dataset.name': request.evaluationDataset!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateEvaluationDataset request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateEvaluationDataset response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateEvaluationDataset(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationDatasetRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateEvaluationDataset response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes an evaluation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation to delete.
 * @param {boolean} [request.force]
 *   Optional. Indicates whether to forcefully delete the evaluation, even if it
 *   is still referenced by evaluation datasets.
 *
 *   *  If `force = false`, the deletion will fail if any datasets still
 *   reference the evaluation.
 *   *  If `force = true`, all existing references from datasets will be removed
 *   and the evaluation will be deleted.
 * @param {string} [request.etag]
 *   Optional. The current etag of the evaluation. If an etag is not provided,
 *   the deletion will overwrite any concurrent changes. If an etag is provided
 *   and does not match the current etag of the evaluation, deletion will be
 *   blocked and an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.delete_evaluation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_DeleteEvaluation_async
 */
  deleteEvaluation(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest|undefined, {}|undefined
      ]>;
  deleteEvaluation(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluation(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluation(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteEvaluation request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteEvaluation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteEvaluation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteEvaluation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes an evaluation result.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation result to delete.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.delete_evaluation_result.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_DeleteEvaluationResult_async
 */
  deleteEvaluationResult(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest|undefined, {}|undefined
      ]>;
  deleteEvaluationResult(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluationResult(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluationResult(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteEvaluationResult request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteEvaluationResult response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteEvaluationResult(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationResultRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteEvaluationResult response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes an evaluation dataset.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation dataset to delete.
 * @param {string} [request.etag]
 *   Optional. The current etag of the evaluation dataset. If an etag is not
 *   provided, the deletion will overwrite any concurrent changes. If an etag is
 *   provided and does not match the current etag of the evaluation dataset,
 *   deletion will be blocked and an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.delete_evaluation_dataset.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_DeleteEvaluationDataset_async
 */
  deleteEvaluationDataset(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest|undefined, {}|undefined
      ]>;
  deleteEvaluationDataset(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluationDataset(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluationDataset(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteEvaluationDataset request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteEvaluationDataset response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteEvaluationDataset(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationDatasetRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteEvaluationDataset response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified evaluation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.Evaluation|Evaluation}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.get_evaluation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_GetEvaluation_async
 */
  getEvaluation(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.IGetEvaluationRequest|undefined, {}|undefined
      ]>;
  getEvaluation(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.IGetEvaluationRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluation(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.IGetEvaluationRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluation(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.IGetEvaluationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluation,
          protos.google.cloud.ces.v1beta.IGetEvaluationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.IGetEvaluationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getEvaluation request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.IGetEvaluationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getEvaluation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getEvaluation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluation,
        protos.google.cloud.ces.v1beta.IGetEvaluationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getEvaluation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified evaluation result.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation result to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.EvaluationResult|EvaluationResult}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.get_evaluation_result.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_GetEvaluationResult_async
 */
  getEvaluationResult(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationResult,
        protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest|undefined, {}|undefined
      ]>;
  getEvaluationResult(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationResult,
          protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluationResult(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationResult,
          protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluationResult(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluationResult,
          protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationResult,
          protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationResult,
        protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getEvaluationResult request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluationResult,
        protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getEvaluationResult response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getEvaluationResult(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluationResult,
        protos.google.cloud.ces.v1beta.IGetEvaluationResultRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getEvaluationResult response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified evaluation dataset.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation dataset to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.EvaluationDataset|EvaluationDataset}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.get_evaluation_dataset.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_GetEvaluationDataset_async
 */
  getEvaluationDataset(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest|undefined, {}|undefined
      ]>;
  getEvaluationDataset(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluationDataset(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluationDataset(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationDataset,
          protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getEvaluationDataset request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getEvaluationDataset response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getEvaluationDataset(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluationDataset,
        protos.google.cloud.ces.v1beta.IGetEvaluationDatasetRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getEvaluationDataset response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified evaluation run.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation run to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.EvaluationRun|EvaluationRun}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.get_evaluation_run.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_GetEvaluationRun_async
 */
  getEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationRun,
        protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest|undefined, {}|undefined
      ]>;
  getEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationRun,
          protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationRun,
          protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluationRun,
          protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationRun,
          protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationRun,
        protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getEvaluationRun request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluationRun,
        protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getEvaluationRun response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getEvaluationRun(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluationRun,
        protos.google.cloud.ces.v1beta.IGetEvaluationRunRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getEvaluationRun response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified evaluation expectation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation expectation to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.EvaluationExpectation|EvaluationExpectation}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.get_evaluation_expectation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_GetEvaluationExpectation_async
 */
  getEvaluationExpectation(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest|undefined, {}|undefined
      ]>;
  getEvaluationExpectation(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluationExpectation(
      request: protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>): void;
  getEvaluationExpectation(
      request?: protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getEvaluationExpectation request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getEvaluationExpectation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getEvaluationExpectation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.IGetEvaluationExpectationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getEvaluationExpectation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates an evaluation expectation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The app to create the evaluation expectation for.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {string} [request.evaluationExpectationId]
 *   Optional. The ID to use for the evaluation expectation, which will become
 *   the final component of the evaluation expectation's resource name. If not
 *   provided, a unique ID will be automatically assigned for the evaluation
 *   expectation.
 * @param {google.cloud.ces.v1beta.EvaluationExpectation} request.evaluationExpectation
 *   Required. The evaluation expectation to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.EvaluationExpectation|EvaluationExpectation}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.create_evaluation_expectation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_CreateEvaluationExpectation_async
 */
  createEvaluationExpectation(
      request?: protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest|undefined, {}|undefined
      ]>;
  createEvaluationExpectation(
      request: protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>): void;
  createEvaluationExpectation(
      request: protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>): void;
  createEvaluationExpectation(
      request?: protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createEvaluationExpectation request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createEvaluationExpectation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createEvaluationExpectation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.ICreateEvaluationExpectationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createEvaluationExpectation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates an evaluation expectation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.EvaluationExpectation} request.evaluationExpectation
 *   Required. The evaluation expectation to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.EvaluationExpectation|EvaluationExpectation}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.update_evaluation_expectation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_UpdateEvaluationExpectation_async
 */
  updateEvaluationExpectation(
      request?: protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest|undefined, {}|undefined
      ]>;
  updateEvaluationExpectation(
      request: protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>): void;
  updateEvaluationExpectation(
      request: protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>): void;
  updateEvaluationExpectation(
      request?: protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IEvaluationExpectation,
          protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'evaluation_expectation.name': request.evaluationExpectation!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateEvaluationExpectation request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateEvaluationExpectation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateEvaluationExpectation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IEvaluationExpectation,
        protos.google.cloud.ces.v1beta.IUpdateEvaluationExpectationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateEvaluationExpectation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes an evaluation expectation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation expectation to delete.
 * @param {string} [request.etag]
 *   Optional. The current etag of the evaluation expectation. If an etag is not
 *   provided, the deletion will overwrite any concurrent changes. If an etag is
 *   provided and does not match the current etag of the evaluation expectation,
 *   deletion will be blocked and an ABORTED error will be returned.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.delete_evaluation_expectation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_DeleteEvaluationExpectation_async
 */
  deleteEvaluationExpectation(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest|undefined, {}|undefined
      ]>;
  deleteEvaluationExpectation(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluationExpectation(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluationExpectation(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteEvaluationExpectation request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteEvaluationExpectation response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteEvaluationExpectation(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteEvaluationExpectationRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteEvaluationExpectation response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Creates a scheduled evaluation run.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The app to create the scheduled evaluation run for.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {string} [request.scheduledEvaluationRunId]
 *   Optional. The ID to use for the scheduled evaluation run, which will become
 *   the final component of the scheduled evaluation run's resource name. If not
 *   provided, a unique ID will be automatically assigned.
 * @param {google.cloud.ces.v1beta.ScheduledEvaluationRun} request.scheduledEvaluationRun
 *   Required. The scheduled evaluation run to create.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.ScheduledEvaluationRun|ScheduledEvaluationRun}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.create_scheduled_evaluation_run.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_CreateScheduledEvaluationRun_async
 */
  createScheduledEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest|undefined, {}|undefined
      ]>;
  createScheduledEvaluationRun(
      request: protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  createScheduledEvaluationRun(
      request: protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  createScheduledEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('createScheduledEvaluationRun request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('createScheduledEvaluationRun response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.createScheduledEvaluationRun(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.ICreateScheduledEvaluationRunRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('createScheduledEvaluationRun response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Gets details of the specified scheduled evaluation run.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the scheduled evaluation run to retrieve.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.ScheduledEvaluationRun|ScheduledEvaluationRun}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.get_scheduled_evaluation_run.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_GetScheduledEvaluationRun_async
 */
  getScheduledEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest|undefined, {}|undefined
      ]>;
  getScheduledEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  getScheduledEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  getScheduledEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('getScheduledEvaluationRun request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getScheduledEvaluationRun response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.getScheduledEvaluationRun(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.IGetScheduledEvaluationRunRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('getScheduledEvaluationRun response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Updates a scheduled evaluation run.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.ScheduledEvaluationRun} request.scheduledEvaluationRun
 *   Required. The scheduled evaluation run to update.
 * @param {google.protobuf.FieldMask} [request.updateMask]
 *   Optional. Field mask is used to control which fields get updated. If the
 *   mask is not present, all fields will be updated.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.ScheduledEvaluationRun|ScheduledEvaluationRun}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.update_scheduled_evaluation_run.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_UpdateScheduledEvaluationRun_async
 */
  updateScheduledEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest|undefined, {}|undefined
      ]>;
  updateScheduledEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  updateScheduledEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  updateScheduledEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
          protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'scheduled_evaluation_run.name': request.scheduledEvaluationRun!.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('updateScheduledEvaluationRun request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('updateScheduledEvaluationRun response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.updateScheduledEvaluationRun(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun,
        protos.google.cloud.ces.v1beta.IUpdateScheduledEvaluationRunRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('updateScheduledEvaluationRun response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Deletes a scheduled evaluation run.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the scheduled evaluation run to delete.
 * @param {string} [request.etag]
 *   Optional. The etag of the ScheduledEvaluationRun.
 *   If provided, it must match the server's etag.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.delete_scheduled_evaluation_run.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_DeleteScheduledEvaluationRun_async
 */
  deleteScheduledEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest,
      options?: CallOptions):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest|undefined, {}|undefined
      ]>;
  deleteScheduledEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  deleteScheduledEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest,
      callback: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>): void;
  deleteScheduledEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.protobuf.IEmpty,
          protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('deleteScheduledEvaluationRun request %j', request);
    const wrappedCallback: Callback<
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteScheduledEvaluationRun response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.deleteScheduledEvaluationRun(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.protobuf.IEmpty,
        protos.google.cloud.ces.v1beta.IDeleteScheduledEvaluationRunRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('deleteScheduledEvaluationRun response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }
/**
 * Tests the voice of a persona. Also accepts a default persona.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.app
 *   Required. the resource name of the app to test the persona voice for.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {string} request.personaId
 *   Required. The persona ID to test the voice for. Also accepts "default".
 * @param {string} request.text
 *   Required. The text to test the voice for.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing {@link protos.google.cloud.ces.v1beta.TestPersonaVoiceResponse|TestPersonaVoiceResponse}.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.test_persona_voice.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_TestPersonaVoice_async
 */
  testPersonaVoice(
      request?: protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.ITestPersonaVoiceResponse,
        protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest|undefined, {}|undefined
      ]>;
  testPersonaVoice(
      request: protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest,
      options: CallOptions,
      callback: Callback<
          protos.google.cloud.ces.v1beta.ITestPersonaVoiceResponse,
          protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest|null|undefined,
          {}|null|undefined>): void;
  testPersonaVoice(
      request: protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest,
      callback: Callback<
          protos.google.cloud.ces.v1beta.ITestPersonaVoiceResponse,
          protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest|null|undefined,
          {}|null|undefined>): void;
  testPersonaVoice(
      request?: protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest,
      optionsOrCallback?: CallOptions|Callback<
          protos.google.cloud.ces.v1beta.ITestPersonaVoiceResponse,
          protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          protos.google.cloud.ces.v1beta.ITestPersonaVoiceResponse,
          protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest|null|undefined,
          {}|null|undefined>):
      Promise<[
        protos.google.cloud.ces.v1beta.ITestPersonaVoiceResponse,
        protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'app': request.app ?? '',
    });
    this.initialize().catch(err => {throw err});
    this._log.info('testPersonaVoice request %j', request);
    const wrappedCallback: Callback<
        protos.google.cloud.ces.v1beta.ITestPersonaVoiceResponse,
        protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest|null|undefined,
        {}|null|undefined>|undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('testPersonaVoice response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls.testPersonaVoice(request, options, wrappedCallback)
      ?.then(([response, options, rawResponse]: [
        protos.google.cloud.ces.v1beta.ITestPersonaVoiceResponse,
        protos.google.cloud.ces.v1beta.ITestPersonaVoiceRequest|undefined,
        {}|undefined
      ]) => {
        this._log.info('testPersonaVoice response %j', response);
        return [response, options, rawResponse];
      }).catch((error: any) => {
        if (error && 'statusDetails' in error && error.statusDetails instanceof Array) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(jsonProtos) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(error.statusDetails, protos);
        }
        throw error;
      });
  }

/**
 * Runs an evaluation of the app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.app
 *   Required. The app to evaluate.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {string[]} [request.evaluations]
 *   Optional. List of evaluations to run.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
 * @param {string} [request.evaluationDataset]
 *   Optional. An evaluation dataset to run.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
 * @param {string} [request.displayName]
 *   Optional. The display name of the evaluation run.
 * @param {string} [request.appVersion]
 *   Optional. The app version to evaluate.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
 * @param {google.cloud.ces.v1beta.EvaluationConfig} [request.config]
 *   Optional. The configuration to use for the run.
 * @param {number} [request.runCount]
 *   Optional. The number of times to run the evaluation. If not set, the
 *   default value is 1 per golden, and 5 per scenario.
 * @param {number[]} [request.personaRunConfigs]
 *   Optional. The configuration to use for the run per persona.
 * @param {google.cloud.ces.v1beta.OptimizationConfig} [request.optimizationConfig]
 *   Optional. Configuration for running the optimization step after the
 *   evaluation run. If not set, the optimization step will not be run.
 * @param {string} [request.scheduledEvaluationRun]
 *   Optional. The resource name of the `ScheduledEvaluationRun` that is
 *   triggering this evaluation run.
 *
 *   If this field is set, the `scheduled_evaluation_run` field on the created
 *   `EvaluationRun` resource will be populated from this value.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
 * @param {google.cloud.ces.v1beta.GoldenRunMethod} [request.goldenRunMethod]
 *   Optional. The method to run the evaluation if it is a golden evaluation. If
 *   not set, default to STABLE.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.run_evaluation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_RunEvaluation_async
 */
  runEvaluation(
      request?: protos.google.cloud.ces.v1beta.IRunEvaluationRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  runEvaluation(
      request: protos.google.cloud.ces.v1beta.IRunEvaluationRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  runEvaluation(
      request: protos.google.cloud.ces.v1beta.IRunEvaluationRequest,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  runEvaluation(
      request?: protos.google.cloud.ces.v1beta.IRunEvaluationRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'app': request.app ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('runEvaluation response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('runEvaluation request %j', request);
    return this.innerApiCalls.runEvaluation(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('runEvaluation response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `runEvaluation()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.run_evaluation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_RunEvaluation_async
 */
  async checkRunEvaluationProgress(name: string): Promise<LROperation<protos.google.cloud.ces.v1beta.RunEvaluationResponse, protos.google.cloud.ces.v1beta.RunEvaluationOperationMetadata>>{
    this._log.info('runEvaluation long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.runEvaluation, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.cloud.ces.v1beta.RunEvaluationResponse, protos.google.cloud.ces.v1beta.RunEvaluationOperationMetadata>;
  }
/**
 * Creates a golden evaluation from a conversation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.conversation
 *   Required. The conversation to create the golden evaluation for.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}`
 * @param {google.cloud.ces.v1beta.Conversation.Source} [request.source]
 *   Optional. Indicate the source of the conversation. If not set, all sources
 *   will be searched.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.generate_evaluation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_GenerateEvaluation_async
 */
  generateEvaluation(
      request?: protos.google.cloud.ces.v1beta.IGenerateEvaluationRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  generateEvaluation(
      request: protos.google.cloud.ces.v1beta.IGenerateEvaluationRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  generateEvaluation(
      request: protos.google.cloud.ces.v1beta.IGenerateEvaluationRequest,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  generateEvaluation(
      request?: protos.google.cloud.ces.v1beta.IGenerateEvaluationRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'conversation': request.conversation ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('generateEvaluation response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('generateEvaluation request %j', request);
    return this.innerApiCalls.generateEvaluation(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('generateEvaluation response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `generateEvaluation()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.generate_evaluation.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_GenerateEvaluation_async
 */
  async checkGenerateEvaluationProgress(name: string): Promise<LROperation<protos.google.cloud.ces.v1beta.Evaluation, protos.google.cloud.ces.v1beta.GenerateEvaluationOperationMetadata>>{
    this._log.info('generateEvaluation long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.generateEvaluation, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.cloud.ces.v1beta.Evaluation, protos.google.cloud.ces.v1beta.GenerateEvaluationOperationMetadata>;
  }
/**
 * Imports evaluations into the app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {google.cloud.ces.v1beta.ImportEvaluationsRequest.ConversationList} request.conversationList
 *   The conversations to import the evaluations from.
 * @param {string} request.gcsUri
 *   The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
 *   from which to import evaluations. The format of this URI must be
 *   `gs://<bucket-name>/<object-name>`.
 * @param {Buffer} request.csvContent
 *   Raw bytes representing the csv file with the evaluations structure.
 * @param {string} request.parent
 *   Required. The app to import the evaluations into.
 *   Format:
 *   `projects/{project}/locations/{location}/apps/{app}`
 * @param {google.cloud.ces.v1beta.ImportEvaluationsRequest.ImportOptions} [request.importOptions]
 *   Optional. Options governing the import process for the evaluations.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.import_evaluations.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_ImportEvaluations_async
 */
  importEvaluations(
      request?: protos.google.cloud.ces.v1beta.IImportEvaluationsRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  importEvaluations(
      request: protos.google.cloud.ces.v1beta.IImportEvaluationsRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  importEvaluations(
      request: protos.google.cloud.ces.v1beta.IImportEvaluationsRequest,
      callback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  importEvaluations(
      request?: protos.google.cloud.ces.v1beta.IImportEvaluationsRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('importEvaluations response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('importEvaluations request %j', request);
    return this.innerApiCalls.importEvaluations(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('importEvaluations response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `importEvaluations()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.import_evaluations.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_ImportEvaluations_async
 */
  async checkImportEvaluationsProgress(name: string): Promise<LROperation<protos.google.cloud.ces.v1beta.ImportEvaluationsResponse, protos.google.cloud.ces.v1beta.ImportEvaluationsOperationMetadata>>{
    this._log.info('importEvaluations long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.importEvaluations, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.cloud.ces.v1beta.ImportEvaluationsResponse, protos.google.cloud.ces.v1beta.ImportEvaluationsOperationMetadata>;
  }
/**
 * Deletes an evaluation run.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.name
 *   Required. The resource name of the evaluation run to delete.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is an object representing
 *   a long running operation. Its `promise()` method returns a promise
 *   you can `await` for.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.delete_evaluation_run.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_DeleteEvaluationRun_async
 */
  deleteEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationRunRequest,
      options?: CallOptions):
      Promise<[
        LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>;
  deleteEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationRunRequest,
      options: CallOptions,
      callback: Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluationRun(
      request: protos.google.cloud.ces.v1beta.IDeleteEvaluationRunRequest,
      callback: Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>): void;
  deleteEvaluationRun(
      request?: protos.google.cloud.ces.v1beta.IDeleteEvaluationRunRequest,
      optionsOrCallback?: CallOptions|Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>,
      callback?: Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>):
      Promise<[
        LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>,
        protos.google.longrunning.IOperation|undefined, {}|undefined
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'name': request.name ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: Callback<
          LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>,
          protos.google.longrunning.IOperation|null|undefined,
          {}|null|undefined>|undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('deleteEvaluationRun response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('deleteEvaluationRun request %j', request);
    return this.innerApiCalls.deleteEvaluationRun(request, options, wrappedCallback)
    ?.then(([response, rawResponse, _]: [
      LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>,
      protos.google.longrunning.IOperation|undefined, {}|undefined
    ]) => {
      this._log.info('deleteEvaluationRun response %j', rawResponse);
      return [response, rawResponse, _];
    });
  }
/**
 * Check the status of the long running operation returned by `deleteEvaluationRun()`.
 * @param {String} name
 *   The operation name that will be passed.
 * @returns {Promise} - The promise which resolves to an object.
 *   The decoded operation object has result and metadata field to get information from.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.delete_evaluation_run.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_DeleteEvaluationRun_async
 */
  async checkDeleteEvaluationRunProgress(name: string): Promise<LROperation<protos.google.protobuf.Empty, protos.google.cloud.ces.v1beta.DeleteEvaluationRunOperationMetadata>>{
    this._log.info('deleteEvaluationRun long-running');
    const request = new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest({name});
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(operation, this.descriptors.longrunning.deleteEvaluationRun, this._gaxModule.createDefaultBackoffSettings());
    return decodeOperation as LROperation<protos.google.protobuf.Empty, protos.google.cloud.ces.v1beta.DeleteEvaluationRunOperationMetadata>;
  }
 /**
 * Lists all evaluations in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluations from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluations|EvaluationService.ListEvaluations}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluations.
 *   See https://google.aip.dev/160 for more details.
 *   Currently supports filtering by the following fields:
 *   * evaluation_datasets, using the evaluation dataset ID in the format
 *     evaluation_datasets:evaluation_dataset_id.
 *   * tags, using the tag in the format tags:tag.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {boolean} [request.lastTenResults]
 *   Optional. Whether to include the last 10 evaluation results for each
 *   evaluation in the response.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.Evaluation|Evaluation}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listEvaluationsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluations(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluation[],
        protos.google.cloud.ces.v1beta.IListEvaluationsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationsResponse
      ]>;
  listEvaluations(
      request: protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluation>): void;
  listEvaluations(
      request: protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluation>): void;
  listEvaluations(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluation>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluation>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluation[],
        protos.google.cloud.ces.v1beta.IListEvaluationsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
      protos.google.cloud.ces.v1beta.IListEvaluationsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IEvaluation>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listEvaluations values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listEvaluations request %j', request);
    return this.innerApiCalls
      .listEvaluations(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IEvaluation[],
        protos.google.cloud.ces.v1beta.IListEvaluationsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationsResponse
      ]) => {
        this._log.info('listEvaluations values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listEvaluations`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluations from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluations|EvaluationService.ListEvaluations}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluations.
 *   See https://google.aip.dev/160 for more details.
 *   Currently supports filtering by the following fields:
 *   * evaluation_datasets, using the evaluation dataset ID in the format
 *     evaluation_datasets:evaluation_dataset_id.
 *   * tags, using the tag in the format tags:tag.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {boolean} [request.lastTenResults]
 *   Optional. Whether to include the last 10 evaluation results for each
 *   evaluation in the response.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.Evaluation|Evaluation} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listEvaluationsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluationsStream(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluations stream %j', request);
    return this.descriptors.page.listEvaluations.createStream(
      this.innerApiCalls.listEvaluations as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listEvaluations`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluations from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluations|EvaluationService.ListEvaluations}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluations.
 *   See https://google.aip.dev/160 for more details.
 *   Currently supports filtering by the following fields:
 *   * evaluation_datasets, using the evaluation dataset ID in the format
 *     evaluation_datasets:evaluation_dataset_id.
 *   * tags, using the tag in the format tags:tag.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {boolean} [request.lastTenResults]
 *   Optional. Whether to include the last 10 evaluation results for each
 *   evaluation in the response.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.Evaluation|Evaluation}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.list_evaluations.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_ListEvaluations_async
 */
  listEvaluationsAsync(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluation>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluations iterate %j', request);
    return this.descriptors.page.listEvaluations.asyncIterate(
      this.innerApiCalls['listEvaluations'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluation>;
  }
 /**
 * Lists all evaluation results for a given evaluation.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the evaluation to list evaluation results
 *   from. To filter by evaluation run, use `-` as the evaluation ID and specify
 *   the evaluation run ID in the filter. For example:
 *   `projects/{project}/locations/{location}/apps/{app}/evaluations/-`
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationResultsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationResults|EvaluationService.ListEvaluationResults}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation results.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.EvaluationResult|EvaluationResult}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listEvaluationResultsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluationResults(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationResult[],
        protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationResultsResponse
      ]>;
  listEvaluationResults(
      request: protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationResultsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationResult>): void;
  listEvaluationResults(
      request: protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationResultsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationResult>): void;
  listEvaluationResults(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationResultsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationResult>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationResultsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationResult>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationResult[],
        protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationResultsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
      protos.google.cloud.ces.v1beta.IListEvaluationResultsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IEvaluationResult>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listEvaluationResults values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listEvaluationResults request %j', request);
    return this.innerApiCalls
      .listEvaluationResults(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IEvaluationResult[],
        protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationResultsResponse
      ]) => {
        this._log.info('listEvaluationResults values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listEvaluationResults`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the evaluation to list evaluation results
 *   from. To filter by evaluation run, use `-` as the evaluation ID and specify
 *   the evaluation run ID in the filter. For example:
 *   `projects/{project}/locations/{location}/apps/{app}/evaluations/-`
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationResultsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationResults|EvaluationService.ListEvaluationResults}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation results.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.EvaluationResult|EvaluationResult} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listEvaluationResultsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluationResultsStream(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluationResults'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluationResults stream %j', request);
    return this.descriptors.page.listEvaluationResults.createStream(
      this.innerApiCalls.listEvaluationResults as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listEvaluationResults`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the evaluation to list evaluation results
 *   from. To filter by evaluation run, use `-` as the evaluation ID and specify
 *   the evaluation run ID in the filter. For example:
 *   `projects/{project}/locations/{location}/apps/{app}/evaluations/-`
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationResultsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationResults|EvaluationService.ListEvaluationResults}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation results.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.EvaluationResult|EvaluationResult}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.list_evaluation_results.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_ListEvaluationResults_async
 */
  listEvaluationResultsAsync(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationResultsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluationResult>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluationResults'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluationResults iterate %j', request);
    return this.descriptors.page.listEvaluationResults.asyncIterate(
      this.innerApiCalls['listEvaluationResults'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluationResult>;
  }
 /**
 * Lists all evaluation datasets in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluation datasets from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationDatasetsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationDatasets|EvaluationService.ListEvaluationDatasets}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation datasets.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.EvaluationDataset|EvaluationDataset}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listEvaluationDatasetsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluationDatasets(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationDataset[],
        protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationDatasetsResponse
      ]>;
  listEvaluationDatasets(
      request: protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationDatasetsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationDataset>): void;
  listEvaluationDatasets(
      request: protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationDatasetsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationDataset>): void;
  listEvaluationDatasets(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationDatasetsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationDataset>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationDatasetsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationDataset>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationDataset[],
        protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationDatasetsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
      protos.google.cloud.ces.v1beta.IListEvaluationDatasetsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IEvaluationDataset>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listEvaluationDatasets values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listEvaluationDatasets request %j', request);
    return this.innerApiCalls
      .listEvaluationDatasets(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IEvaluationDataset[],
        protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationDatasetsResponse
      ]) => {
        this._log.info('listEvaluationDatasets values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listEvaluationDatasets`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluation datasets from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationDatasetsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationDatasets|EvaluationService.ListEvaluationDatasets}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation datasets.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.EvaluationDataset|EvaluationDataset} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listEvaluationDatasetsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluationDatasetsStream(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluationDatasets'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluationDatasets stream %j', request);
    return this.descriptors.page.listEvaluationDatasets.createStream(
      this.innerApiCalls.listEvaluationDatasets as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listEvaluationDatasets`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluation datasets from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationDatasetsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationDatasets|EvaluationService.ListEvaluationDatasets}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation datasets.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.EvaluationDataset|EvaluationDataset}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.list_evaluation_datasets.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_ListEvaluationDatasets_async
 */
  listEvaluationDatasetsAsync(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationDatasetsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluationDataset>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluationDatasets'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluationDatasets iterate %j', request);
    return this.descriptors.page.listEvaluationDatasets.asyncIterate(
      this.innerApiCalls['listEvaluationDatasets'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluationDataset>;
  }
 /**
 * Lists all evaluation runs in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluation runs from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationRunsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationRuns|EvaluationService.ListEvaluationRuns}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation runs.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.EvaluationRun|EvaluationRun}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listEvaluationRunsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluationRuns(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationRun[],
        protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationRunsResponse
      ]>;
  listEvaluationRuns(
      request: protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationRunsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationRun>): void;
  listEvaluationRuns(
      request: protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationRunsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationRun>): void;
  listEvaluationRuns(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationRunsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationRun>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationRunsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationRun>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationRun[],
        protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationRunsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
      protos.google.cloud.ces.v1beta.IListEvaluationRunsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IEvaluationRun>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listEvaluationRuns values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listEvaluationRuns request %j', request);
    return this.innerApiCalls
      .listEvaluationRuns(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IEvaluationRun[],
        protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationRunsResponse
      ]) => {
        this._log.info('listEvaluationRuns values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listEvaluationRuns`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluation runs from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationRunsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationRuns|EvaluationService.ListEvaluationRuns}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation runs.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.EvaluationRun|EvaluationRun} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listEvaluationRunsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluationRunsStream(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluationRuns'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluationRuns stream %j', request);
    return this.descriptors.page.listEvaluationRuns.createStream(
      this.innerApiCalls.listEvaluationRuns as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listEvaluationRuns`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluation runs from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationRunsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationRuns|EvaluationService.ListEvaluationRuns}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation runs.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.EvaluationRun|EvaluationRun}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.list_evaluation_runs.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_ListEvaluationRuns_async
 */
  listEvaluationRunsAsync(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationRunsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluationRun>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluationRuns'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluationRuns iterate %j', request);
    return this.descriptors.page.listEvaluationRuns.asyncIterate(
      this.innerApiCalls['listEvaluationRuns'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluationRun>;
  }
 /**
 * Lists all evaluation expectations in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluation expectations
 *   from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationExpectationsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationExpectations|EvaluationService.ListEvaluationExpectations}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation expectations.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.EvaluationExpectation|EvaluationExpectation}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listEvaluationExpectationsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluationExpectations(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationExpectation[],
        protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationExpectationsResponse
      ]>;
  listEvaluationExpectations(
      request: protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationExpectationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationExpectation>): void;
  listEvaluationExpectations(
      request: protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationExpectationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationExpectation>): void;
  listEvaluationExpectations(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationExpectationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationExpectation>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
          protos.google.cloud.ces.v1beta.IListEvaluationExpectationsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IEvaluationExpectation>):
      Promise<[
        protos.google.cloud.ces.v1beta.IEvaluationExpectation[],
        protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationExpectationsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
      protos.google.cloud.ces.v1beta.IListEvaluationExpectationsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IEvaluationExpectation>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listEvaluationExpectations values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listEvaluationExpectations request %j', request);
    return this.innerApiCalls
      .listEvaluationExpectations(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IEvaluationExpectation[],
        protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest|null,
        protos.google.cloud.ces.v1beta.IListEvaluationExpectationsResponse
      ]) => {
        this._log.info('listEvaluationExpectations values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listEvaluationExpectations`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluation expectations
 *   from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationExpectationsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationExpectations|EvaluationService.ListEvaluationExpectations}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation expectations.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.EvaluationExpectation|EvaluationExpectation} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listEvaluationExpectationsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listEvaluationExpectationsStream(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluationExpectations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluationExpectations stream %j', request);
    return this.descriptors.page.listEvaluationExpectations.createStream(
      this.innerApiCalls.listEvaluationExpectations as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listEvaluationExpectations`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list evaluation expectations
 *   from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListEvaluationExpectationsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListEvaluationExpectations|EvaluationService.ListEvaluationExpectations}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the evaluation expectations.
 *   See https://google.aip.dev/160 for more details.
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Only "name" and "create_time", and
 *   "update_time" are supported. Time fields are ordered in descending order,
 *   and the name field is ordered in ascending order. If not included,
 *   "update_time" will be the default. See https://google.aip.dev/132#ordering
 *   for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.EvaluationExpectation|EvaluationExpectation}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.list_evaluation_expectations.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_ListEvaluationExpectations_async
 */
  listEvaluationExpectationsAsync(
      request?: protos.google.cloud.ces.v1beta.IListEvaluationExpectationsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluationExpectation>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listEvaluationExpectations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listEvaluationExpectations iterate %j', request);
    return this.descriptors.page.listEvaluationExpectations.asyncIterate(
      this.innerApiCalls['listEvaluationExpectations'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IEvaluationExpectation>;
  }
 /**
 * Lists all scheduled evaluation runs in the given app.
 *
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list scheduled evaluation runs
 *   from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListScheduledEvaluationRuns|EvaluationService.ListScheduledEvaluationRuns}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the scheduled evaluation runs.
 *   See https://google.aip.dev/160 for more details.
 *   Currently supports filtering by:
 *   * request.evaluations:evaluation_id
 *   * request.evaluation_dataset:evaluation_dataset_id
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Supported fields are:
 *   "name" (ascending), "create_time" (descending), "update_time" (descending),
 *   "next_scheduled_execution" (ascending), and
 *   "last_completed_run.create_time" (descending).
 *   If not included, "update_time" will be the default.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Promise} - The promise which resolves to an array.
 *   The first element of the array is Array of {@link protos.google.cloud.ces.v1beta.ScheduledEvaluationRun|ScheduledEvaluationRun}.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed and will merge results from all the pages into this array.
 *   Note that it can affect your quota.
 *   We recommend using `listScheduledEvaluationRunsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listScheduledEvaluationRuns(
      request?: protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
      options?: CallOptions):
      Promise<[
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun[],
        protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest|null,
        protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsResponse
      ]>;
  listScheduledEvaluationRuns(
      request: protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
      options: CallOptions,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
          protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun>): void;
  listScheduledEvaluationRuns(
      request: protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
      callback: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
          protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun>): void;
  listScheduledEvaluationRuns(
      request?: protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
      optionsOrCallback?: CallOptions|PaginationCallback<
          protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
          protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun>,
      callback?: PaginationCallback<
          protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
          protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsResponse|null|undefined,
          protos.google.cloud.ces.v1beta.IScheduledEvaluationRun>):
      Promise<[
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun[],
        protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest|null,
        protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsResponse
      ]>|void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    }
    else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    this.initialize().catch(err => {throw err});
    const wrappedCallback: PaginationCallback<
      protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
      protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsResponse|null|undefined,
      protos.google.cloud.ces.v1beta.IScheduledEvaluationRun>|undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listScheduledEvaluationRuns values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listScheduledEvaluationRuns request %j', request);
    return this.innerApiCalls
      .listScheduledEvaluationRuns(request, options, wrappedCallback)
      ?.then(([response, input, output]: [
        protos.google.cloud.ces.v1beta.IScheduledEvaluationRun[],
        protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest|null,
        protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsResponse
      ]) => {
        this._log.info('listScheduledEvaluationRuns values %j', response);
        return [response, input, output];
      });
  }

/**
 * Equivalent to `listScheduledEvaluationRuns`, but returns a NodeJS Stream object.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list scheduled evaluation runs
 *   from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListScheduledEvaluationRuns|EvaluationService.ListScheduledEvaluationRuns}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the scheduled evaluation runs.
 *   See https://google.aip.dev/160 for more details.
 *   Currently supports filtering by:
 *   * request.evaluations:evaluation_id
 *   * request.evaluation_dataset:evaluation_dataset_id
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Supported fields are:
 *   "name" (ascending), "create_time" (descending), "update_time" (descending),
 *   "next_scheduled_execution" (ascending), and
 *   "last_completed_run.create_time" (descending).
 *   If not included, "update_time" will be the default.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Stream}
 *   An object stream which emits an object representing {@link protos.google.cloud.ces.v1beta.ScheduledEvaluationRun|ScheduledEvaluationRun} on 'data' event.
 *   The client library will perform auto-pagination by default: it will call the API as many
 *   times as needed. Note that it can affect your quota.
 *   We recommend using `listScheduledEvaluationRunsAsync()`
 *   method described below for async iteration which you can stop as needed.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 */
  listScheduledEvaluationRunsStream(
      request?: protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
      options?: CallOptions):
    Transform{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listScheduledEvaluationRuns'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listScheduledEvaluationRuns stream %j', request);
    return this.descriptors.page.listScheduledEvaluationRuns.createStream(
      this.innerApiCalls.listScheduledEvaluationRuns as GaxCall,
      request,
      callSettings
    );
  }

/**
 * Equivalent to `listScheduledEvaluationRuns`, but returns an iterable object.
 *
 * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
 * @param {Object} request
 *   The request object that will be sent.
 * @param {string} request.parent
 *   Required. The resource name of the app to list scheduled evaluation runs
 *   from.
 * @param {number} [request.pageSize]
 *   Optional. Requested page size. Server may return fewer items than
 *   requested. If unspecified, server will pick an appropriate default.
 * @param {string} [request.pageToken]
 *   Optional. The
 *   {@link protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsResponse.next_page_token|next_page_token}
 *   value returned from a previous list
 *   {@link protos.google.cloud.ces.v1beta.EvaluationService.ListScheduledEvaluationRuns|EvaluationService.ListScheduledEvaluationRuns}
 *   call.
 * @param {string} [request.filter]
 *   Optional. Filter to be applied when listing the scheduled evaluation runs.
 *   See https://google.aip.dev/160 for more details.
 *   Currently supports filtering by:
 *   * request.evaluations:evaluation_id
 *   * request.evaluation_dataset:evaluation_dataset_id
 * @param {string} [request.orderBy]
 *   Optional. Field to sort by. Supported fields are:
 *   "name" (ascending), "create_time" (descending), "update_time" (descending),
 *   "next_scheduled_execution" (ascending), and
 *   "last_completed_run.create_time" (descending).
 *   If not included, "update_time" will be the default.
 *   See https://google.aip.dev/132#ordering for more details.
 * @param {object} [options]
 *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
 * @returns {Object}
 *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
 *   When you iterate the returned iterable, each element will be an object representing
 *   {@link protos.google.cloud.ces.v1beta.ScheduledEvaluationRun|ScheduledEvaluationRun}. The API will be called under the hood as needed, once per the page,
 *   so you can stop the iteration when you don't need more results.
 *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
 *   for more details and examples.
 * @example <caption>include:samples/generated/v1beta/evaluation_service.list_scheduled_evaluation_runs.js</caption>
 * region_tag:ces_v1beta_generated_EvaluationService_ListScheduledEvaluationRuns_async
 */
  listScheduledEvaluationRunsAsync(
      request?: protos.google.cloud.ces.v1beta.IListScheduledEvaluationRunsRequest,
      options?: CallOptions):
    AsyncIterable<protos.google.cloud.ces.v1beta.IScheduledEvaluationRun>{
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers[
      'x-goog-request-params'
    ] = this._gaxModule.routingHeader.fromParams({
      'parent': request.parent ?? '',
    });
    const defaultCallSettings = this._defaults['listScheduledEvaluationRuns'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {throw err});
    this._log.info('listScheduledEvaluationRuns iterate %j', request);
    return this.descriptors.page.listScheduledEvaluationRuns.asyncIterate(
      this.innerApiCalls['listScheduledEvaluationRuns'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.cloud.ces.v1beta.IScheduledEvaluationRun>;
  }
/**
   * Gets information about a location.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Resource name for the location.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html | CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link google.cloud.location.Location | Location}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   * @example
   * ```
   * const [response] = await client.getLocation(request);
   * ```
   */
  getLocation(
    request: LocationProtos.google.cloud.location.IGetLocationRequest,
    options?:
      | gax.CallOptions
      | Callback<
          LocationProtos.google.cloud.location.ILocation,
          | LocationProtos.google.cloud.location.IGetLocationRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LocationProtos.google.cloud.location.ILocation,
      | LocationProtos.google.cloud.location.IGetLocationRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<LocationProtos.google.cloud.location.ILocation> {
    return this.locationsClient.getLocation(request, options, callback);
  }

/**
   * Lists information about the supported locations for this service. Returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   The resource that owns the locations collection, if applicable.
   * @param {string} request.filter
   *   The standard list filter.
   * @param {number} request.pageSize
   *   The standard list page size.
   * @param {string} request.pageToken
   *   The standard list page token.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
   *   When you iterate the returned iterable, each element will be an object representing
   *   {@link google.cloud.location.Location | Location}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   * @example
   * ```
   * const iterable = client.listLocationsAsync(request);
   * for await (const response of iterable) {
   *   // process response
   * }
   * ```
   */
  listLocationsAsync(
    request: LocationProtos.google.cloud.location.IListLocationsRequest,
    options?: CallOptions
  ): AsyncIterable<LocationProtos.google.cloud.location.ILocation> {
    return this.locationsClient.listLocationsAsync(request, options);
  }

/**
   * Gets the latest state of a long-running operation.  Clients can use this
   * method to poll the operation result at intervals as recommended by the API
   * service.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   *   e.g, timeout, retries, paginations, etc. See {@link
   *   https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions}
   *   for the details.
   * @param {function(?Error, ?Object)=} callback
   *   The function which will be called with the result of the API call.
   *
   *   The second parameter to the callback is an object representing
   *   {@link google.longrunning.Operation | google.longrunning.Operation}.
   * @return {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   * {@link google.longrunning.Operation | google.longrunning.Operation}.
   * The promise has a method named "cancel" which cancels the ongoing API call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * const name = '';
   * const [response] = await client.getOperation({name});
   * // doThingsWith(response)
   * ```
   */
  getOperation(
    request: protos.google.longrunning.GetOperationRequest,
    optionsOrCallback?:
      | gax.CallOptions
      | Callback<
          protos.google.longrunning.Operation,
          protos.google.longrunning.GetOperationRequest,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.longrunning.Operation,
      protos.google.longrunning.GetOperationRequest,
      {} | null | undefined
    >
  ): Promise<[protos.google.longrunning.Operation]> {
     let options: gax.CallOptions;
     if (typeof optionsOrCallback === 'function' && callback === undefined) {
       callback = optionsOrCallback;
       options = {};
     } else {
       options = optionsOrCallback as gax.CallOptions;
     }
     options = options || {};
     options.otherArgs = options.otherArgs || {};
     options.otherArgs.headers = options.otherArgs.headers || {};
     options.otherArgs.headers['x-goog-request-params'] =
       this._gaxModule.routingHeader.fromParams({
         name: request.name ?? '',
       });
    return this.operationsClient.getOperation(request, options, callback);
  }
  /**
   * Lists operations that match the specified filter in the request. If the
   * server doesn't support this method, it returns `UNIMPLEMENTED`. Returns an iterable object.
   *
   * For-await-of syntax is used with the iterable to recursively get response element on-demand.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation collection.
   * @param {string} request.filter - The standard list filter.
   * @param {number=} request.pageSize -
   *   The maximum number of resources contained in the underlying API
   *   response. If page streaming is performed per-resource, this
   *   parameter does not affect the return value. If page streaming is
   *   performed per-page, this determines the maximum number of
   *   resources in a page.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   *   e.g, timeout, retries, paginations, etc. See {@link
   *   https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions} for the
   *   details.
   * @returns {Object}
   *   An iterable Object that conforms to {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | iteration protocols}.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * for await (const response of client.listOperationsAsync(request));
   * // doThingsWith(response)
   * ```
   */
  listOperationsAsync(
    request: protos.google.longrunning.ListOperationsRequest,
    options?: gax.CallOptions
  ): AsyncIterable<protos.google.longrunning.IOperation> {
     options = options || {};
     options.otherArgs = options.otherArgs || {};
     options.otherArgs.headers = options.otherArgs.headers || {};
     options.otherArgs.headers['x-goog-request-params'] =
       this._gaxModule.routingHeader.fromParams({
         name: request.name ?? '',
       });
    return this.operationsClient.listOperationsAsync(request, options);
  }
  /**
   * Starts asynchronous cancellation on a long-running operation.  The server
   * makes a best effort to cancel the operation, but success is not
   * guaranteed.  If the server doesn't support this method, it returns
   * `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
   * {@link Operations.GetOperation} or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an {@link Operation.error} value with a {@link google.rpc.Status.code} of
   * 1, corresponding to `Code.CANCELLED`.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource to be cancelled.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   * e.g, timeout, retries, paginations, etc. See {@link
   * https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions} for the
   * details.
   * @param {function(?Error)=} callback
   *   The function which will be called with the result of the API call.
   * @return {Promise} - The promise which resolves when API call finishes.
   *   The promise has a method named "cancel" which cancels the ongoing API
   * call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * await client.cancelOperation({name: ''});
   * ```
   */
   cancelOperation(
    request: protos.google.longrunning.CancelOperationRequest,
    optionsOrCallback?:
      | gax.CallOptions
      | Callback<
          protos.google.longrunning.CancelOperationRequest,
          protos.google.protobuf.Empty,
          {} | undefined | null
        >,
    callback?: Callback<
      protos.google.longrunning.CancelOperationRequest,
      protos.google.protobuf.Empty,
      {} | undefined | null
    >
  ): Promise<protos.google.protobuf.Empty> {
     let options: gax.CallOptions;
     if (typeof optionsOrCallback === 'function' && callback === undefined) {
       callback = optionsOrCallback;
       options = {};
     } else {
       options = optionsOrCallback as gax.CallOptions;
     }
     options = options || {};
     options.otherArgs = options.otherArgs || {};
     options.otherArgs.headers = options.otherArgs.headers || {};
     options.otherArgs.headers['x-goog-request-params'] =
       this._gaxModule.routingHeader.fromParams({
         name: request.name ?? '',
       });
    return this.operationsClient.cancelOperation(request, options, callback);
  }

  /**
   * Deletes a long-running operation. This method indicates that the client is
   * no longer interested in the operation result. It does not cancel the
   * operation. If the server doesn't support this method, it returns
   * `google.rpc.Code.UNIMPLEMENTED`.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource to be deleted.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   * e.g, timeout, retries, paginations, etc. See {@link
   * https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions}
   * for the details.
   * @param {function(?Error)=} callback
   *   The function which will be called with the result of the API call.
   * @return {Promise} - The promise which resolves when API call finishes.
   *   The promise has a method named "cancel" which cancels the ongoing API
   * call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * await client.deleteOperation({name: ''});
   * ```
   */
  deleteOperation(
    request: protos.google.longrunning.DeleteOperationRequest,
    optionsOrCallback?:
      | gax.CallOptions
      | Callback<
          protos.google.protobuf.Empty,
          protos.google.longrunning.DeleteOperationRequest,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.protobuf.Empty,
      protos.google.longrunning.DeleteOperationRequest,
      {} | null | undefined
    >
  ): Promise<protos.google.protobuf.Empty> {
     let options: gax.CallOptions;
     if (typeof optionsOrCallback === 'function' && callback === undefined) {
       callback = optionsOrCallback;
       options = {};
     } else {
       options = optionsOrCallback as gax.CallOptions;
     }
     options = options || {};
     options.otherArgs = options.otherArgs || {};
     options.otherArgs.headers = options.otherArgs.headers || {};
     options.otherArgs.headers['x-goog-request-params'] =
       this._gaxModule.routingHeader.fromParams({
         name: request.name ?? '',
       });
    return this.operationsClient.deleteOperation(request, options, callback);
  }

  // --------------------
  // -- Path templates --
  // --------------------

  /**
   * Return a fully-qualified agent resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} agent
   * @returns {string} Resource name string.
   */
  agentPath(project:string,location:string,app:string,agent:string) {
    return this.pathTemplates.agentPathTemplate.render({
      project: project,
      location: location,
      app: app,
      agent: agent,
    });
  }

  /**
   * Parse the project from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).project;
  }

  /**
   * Parse the location from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).location;
  }

  /**
   * Parse the app from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).app;
  }

  /**
   * Parse the agent from Agent resource.
   *
   * @param {string} agentName
   *   A fully-qualified path representing Agent resource.
   * @returns {string} A string representing the agent.
   */
  matchAgentFromAgentName(agentName: string) {
    return this.pathTemplates.agentPathTemplate.match(agentName).agent;
  }

  /**
   * Return a fully-qualified app resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @returns {string} Resource name string.
   */
  appPath(project:string,location:string,app:string) {
    return this.pathTemplates.appPathTemplate.render({
      project: project,
      location: location,
      app: app,
    });
  }

  /**
   * Parse the project from App resource.
   *
   * @param {string} appName
   *   A fully-qualified path representing App resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromAppName(appName: string) {
    return this.pathTemplates.appPathTemplate.match(appName).project;
  }

  /**
   * Parse the location from App resource.
   *
   * @param {string} appName
   *   A fully-qualified path representing App resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromAppName(appName: string) {
    return this.pathTemplates.appPathTemplate.match(appName).location;
  }

  /**
   * Parse the app from App resource.
   *
   * @param {string} appName
   *   A fully-qualified path representing App resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromAppName(appName: string) {
    return this.pathTemplates.appPathTemplate.match(appName).app;
  }

  /**
   * Return a fully-qualified appVersion resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} version
   * @returns {string} Resource name string.
   */
  appVersionPath(project:string,location:string,app:string,version:string) {
    return this.pathTemplates.appVersionPathTemplate.render({
      project: project,
      location: location,
      app: app,
      version: version,
    });
  }

  /**
   * Parse the project from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).project;
  }

  /**
   * Parse the location from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).location;
  }

  /**
   * Parse the app from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).app;
  }

  /**
   * Parse the version from AppVersion resource.
   *
   * @param {string} appVersionName
   *   A fully-qualified path representing AppVersion resource.
   * @returns {string} A string representing the version.
   */
  matchVersionFromAppVersionName(appVersionName: string) {
    return this.pathTemplates.appVersionPathTemplate.match(appVersionName).version;
  }

  /**
   * Return a fully-qualified changelog resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} changelog
   * @returns {string} Resource name string.
   */
  changelogPath(project:string,location:string,app:string,changelog:string) {
    return this.pathTemplates.changelogPathTemplate.render({
      project: project,
      location: location,
      app: app,
      changelog: changelog,
    });
  }

  /**
   * Parse the project from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).project;
  }

  /**
   * Parse the location from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).location;
  }

  /**
   * Parse the app from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).app;
  }

  /**
   * Parse the changelog from Changelog resource.
   *
   * @param {string} changelogName
   *   A fully-qualified path representing Changelog resource.
   * @returns {string} A string representing the changelog.
   */
  matchChangelogFromChangelogName(changelogName: string) {
    return this.pathTemplates.changelogPathTemplate.match(changelogName).changelog;
  }

  /**
   * Return a fully-qualified conversation resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} conversation
   * @returns {string} Resource name string.
   */
  conversationPath(project:string,location:string,app:string,conversation:string) {
    return this.pathTemplates.conversationPathTemplate.render({
      project: project,
      location: location,
      app: app,
      conversation: conversation,
    });
  }

  /**
   * Parse the project from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).project;
  }

  /**
   * Parse the location from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).location;
  }

  /**
   * Parse the app from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).app;
  }

  /**
   * Parse the conversation from Conversation resource.
   *
   * @param {string} conversationName
   *   A fully-qualified path representing Conversation resource.
   * @returns {string} A string representing the conversation.
   */
  matchConversationFromConversationName(conversationName: string) {
    return this.pathTemplates.conversationPathTemplate.match(conversationName).conversation;
  }

  /**
   * Return a fully-qualified deployment resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} deployment
   * @returns {string} Resource name string.
   */
  deploymentPath(project:string,location:string,app:string,deployment:string) {
    return this.pathTemplates.deploymentPathTemplate.render({
      project: project,
      location: location,
      app: app,
      deployment: deployment,
    });
  }

  /**
   * Parse the project from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).project;
  }

  /**
   * Parse the location from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).location;
  }

  /**
   * Parse the app from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).app;
  }

  /**
   * Parse the deployment from Deployment resource.
   *
   * @param {string} deploymentName
   *   A fully-qualified path representing Deployment resource.
   * @returns {string} A string representing the deployment.
   */
  matchDeploymentFromDeploymentName(deploymentName: string) {
    return this.pathTemplates.deploymentPathTemplate.match(deploymentName).deployment;
  }

  /**
   * Return a fully-qualified evaluation resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation
   * @returns {string} Resource name string.
   */
  evaluationPath(project:string,location:string,app:string,evaluation:string) {
    return this.pathTemplates.evaluationPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation: evaluation,
    });
  }

  /**
   * Parse the project from Evaluation resource.
   *
   * @param {string} evaluationName
   *   A fully-qualified path representing Evaluation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationName(evaluationName: string) {
    return this.pathTemplates.evaluationPathTemplate.match(evaluationName).project;
  }

  /**
   * Parse the location from Evaluation resource.
   *
   * @param {string} evaluationName
   *   A fully-qualified path representing Evaluation resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationName(evaluationName: string) {
    return this.pathTemplates.evaluationPathTemplate.match(evaluationName).location;
  }

  /**
   * Parse the app from Evaluation resource.
   *
   * @param {string} evaluationName
   *   A fully-qualified path representing Evaluation resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationName(evaluationName: string) {
    return this.pathTemplates.evaluationPathTemplate.match(evaluationName).app;
  }

  /**
   * Parse the evaluation from Evaluation resource.
   *
   * @param {string} evaluationName
   *   A fully-qualified path representing Evaluation resource.
   * @returns {string} A string representing the evaluation.
   */
  matchEvaluationFromEvaluationName(evaluationName: string) {
    return this.pathTemplates.evaluationPathTemplate.match(evaluationName).evaluation;
  }

  /**
   * Return a fully-qualified evaluationDataset resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation_dataset
   * @returns {string} Resource name string.
   */
  evaluationDatasetPath(project:string,location:string,app:string,evaluationDataset:string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation_dataset: evaluationDataset,
    });
  }

  /**
   * Parse the project from EvaluationDataset resource.
   *
   * @param {string} evaluationDatasetName
   *   A fully-qualified path representing EvaluationDataset resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationDatasetName(evaluationDatasetName: string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.match(evaluationDatasetName).project;
  }

  /**
   * Parse the location from EvaluationDataset resource.
   *
   * @param {string} evaluationDatasetName
   *   A fully-qualified path representing EvaluationDataset resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationDatasetName(evaluationDatasetName: string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.match(evaluationDatasetName).location;
  }

  /**
   * Parse the app from EvaluationDataset resource.
   *
   * @param {string} evaluationDatasetName
   *   A fully-qualified path representing EvaluationDataset resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationDatasetName(evaluationDatasetName: string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.match(evaluationDatasetName).app;
  }

  /**
   * Parse the evaluation_dataset from EvaluationDataset resource.
   *
   * @param {string} evaluationDatasetName
   *   A fully-qualified path representing EvaluationDataset resource.
   * @returns {string} A string representing the evaluation_dataset.
   */
  matchEvaluationDatasetFromEvaluationDatasetName(evaluationDatasetName: string) {
    return this.pathTemplates.evaluationDatasetPathTemplate.match(evaluationDatasetName).evaluation_dataset;
  }

  /**
   * Return a fully-qualified evaluationExpectation resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation_expectation
   * @returns {string} Resource name string.
   */
  evaluationExpectationPath(project:string,location:string,app:string,evaluationExpectation:string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation_expectation: evaluationExpectation,
    });
  }

  /**
   * Parse the project from EvaluationExpectation resource.
   *
   * @param {string} evaluationExpectationName
   *   A fully-qualified path representing EvaluationExpectation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationExpectationName(evaluationExpectationName: string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.match(evaluationExpectationName).project;
  }

  /**
   * Parse the location from EvaluationExpectation resource.
   *
   * @param {string} evaluationExpectationName
   *   A fully-qualified path representing EvaluationExpectation resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationExpectationName(evaluationExpectationName: string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.match(evaluationExpectationName).location;
  }

  /**
   * Parse the app from EvaluationExpectation resource.
   *
   * @param {string} evaluationExpectationName
   *   A fully-qualified path representing EvaluationExpectation resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationExpectationName(evaluationExpectationName: string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.match(evaluationExpectationName).app;
  }

  /**
   * Parse the evaluation_expectation from EvaluationExpectation resource.
   *
   * @param {string} evaluationExpectationName
   *   A fully-qualified path representing EvaluationExpectation resource.
   * @returns {string} A string representing the evaluation_expectation.
   */
  matchEvaluationExpectationFromEvaluationExpectationName(evaluationExpectationName: string) {
    return this.pathTemplates.evaluationExpectationPathTemplate.match(evaluationExpectationName).evaluation_expectation;
  }

  /**
   * Return a fully-qualified evaluationResult resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation
   * @param {string} evaluation_result
   * @returns {string} Resource name string.
   */
  evaluationResultPath(project:string,location:string,app:string,evaluation:string,evaluationResult:string) {
    return this.pathTemplates.evaluationResultPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation: evaluation,
      evaluation_result: evaluationResult,
    });
  }

  /**
   * Parse the project from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).project;
  }

  /**
   * Parse the location from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).location;
  }

  /**
   * Parse the app from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).app;
  }

  /**
   * Parse the evaluation from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the evaluation.
   */
  matchEvaluationFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).evaluation;
  }

  /**
   * Parse the evaluation_result from EvaluationResult resource.
   *
   * @param {string} evaluationResultName
   *   A fully-qualified path representing EvaluationResult resource.
   * @returns {string} A string representing the evaluation_result.
   */
  matchEvaluationResultFromEvaluationResultName(evaluationResultName: string) {
    return this.pathTemplates.evaluationResultPathTemplate.match(evaluationResultName).evaluation_result;
  }

  /**
   * Return a fully-qualified evaluationRun resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} evaluation_run
   * @returns {string} Resource name string.
   */
  evaluationRunPath(project:string,location:string,app:string,evaluationRun:string) {
    return this.pathTemplates.evaluationRunPathTemplate.render({
      project: project,
      location: location,
      app: app,
      evaluation_run: evaluationRun,
    });
  }

  /**
   * Parse the project from EvaluationRun resource.
   *
   * @param {string} evaluationRunName
   *   A fully-qualified path representing EvaluationRun resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromEvaluationRunName(evaluationRunName: string) {
    return this.pathTemplates.evaluationRunPathTemplate.match(evaluationRunName).project;
  }

  /**
   * Parse the location from EvaluationRun resource.
   *
   * @param {string} evaluationRunName
   *   A fully-qualified path representing EvaluationRun resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromEvaluationRunName(evaluationRunName: string) {
    return this.pathTemplates.evaluationRunPathTemplate.match(evaluationRunName).location;
  }

  /**
   * Parse the app from EvaluationRun resource.
   *
   * @param {string} evaluationRunName
   *   A fully-qualified path representing EvaluationRun resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromEvaluationRunName(evaluationRunName: string) {
    return this.pathTemplates.evaluationRunPathTemplate.match(evaluationRunName).app;
  }

  /**
   * Parse the evaluation_run from EvaluationRun resource.
   *
   * @param {string} evaluationRunName
   *   A fully-qualified path representing EvaluationRun resource.
   * @returns {string} A string representing the evaluation_run.
   */
  matchEvaluationRunFromEvaluationRunName(evaluationRunName: string) {
    return this.pathTemplates.evaluationRunPathTemplate.match(evaluationRunName).evaluation_run;
  }

  /**
   * Return a fully-qualified example resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} example
   * @returns {string} Resource name string.
   */
  examplePath(project:string,location:string,app:string,example:string) {
    return this.pathTemplates.examplePathTemplate.render({
      project: project,
      location: location,
      app: app,
      example: example,
    });
  }

  /**
   * Parse the project from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).project;
  }

  /**
   * Parse the location from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).location;
  }

  /**
   * Parse the app from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).app;
  }

  /**
   * Parse the example from Example resource.
   *
   * @param {string} exampleName
   *   A fully-qualified path representing Example resource.
   * @returns {string} A string representing the example.
   */
  matchExampleFromExampleName(exampleName: string) {
    return this.pathTemplates.examplePathTemplate.match(exampleName).example;
  }

  /**
   * Return a fully-qualified guardrail resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} guardrail
   * @returns {string} Resource name string.
   */
  guardrailPath(project:string,location:string,app:string,guardrail:string) {
    return this.pathTemplates.guardrailPathTemplate.render({
      project: project,
      location: location,
      app: app,
      guardrail: guardrail,
    });
  }

  /**
   * Parse the project from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).project;
  }

  /**
   * Parse the location from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).location;
  }

  /**
   * Parse the app from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).app;
  }

  /**
   * Parse the guardrail from Guardrail resource.
   *
   * @param {string} guardrailName
   *   A fully-qualified path representing Guardrail resource.
   * @returns {string} A string representing the guardrail.
   */
  matchGuardrailFromGuardrailName(guardrailName: string) {
    return this.pathTemplates.guardrailPathTemplate.match(guardrailName).guardrail;
  }

  /**
   * Return a fully-qualified location resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @returns {string} Resource name string.
   */
  locationPath(project:string,location:string) {
    return this.pathTemplates.locationPathTemplate.render({
      project: project,
      location: location,
    });
  }

  /**
   * Parse the project from Location resource.
   *
   * @param {string} locationName
   *   A fully-qualified path representing Location resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromLocationName(locationName: string) {
    return this.pathTemplates.locationPathTemplate.match(locationName).project;
  }

  /**
   * Parse the location from Location resource.
   *
   * @param {string} locationName
   *   A fully-qualified path representing Location resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromLocationName(locationName: string) {
    return this.pathTemplates.locationPathTemplate.match(locationName).location;
  }

  /**
   * Return a fully-qualified omnichannel resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} omnichannel
   * @returns {string} Resource name string.
   */
  omnichannelPath(project:string,location:string,omnichannel:string) {
    return this.pathTemplates.omnichannelPathTemplate.render({
      project: project,
      location: location,
      omnichannel: omnichannel,
    });
  }

  /**
   * Parse the project from Omnichannel resource.
   *
   * @param {string} omnichannelName
   *   A fully-qualified path representing Omnichannel resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromOmnichannelName(omnichannelName: string) {
    return this.pathTemplates.omnichannelPathTemplate.match(omnichannelName).project;
  }

  /**
   * Parse the location from Omnichannel resource.
   *
   * @param {string} omnichannelName
   *   A fully-qualified path representing Omnichannel resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromOmnichannelName(omnichannelName: string) {
    return this.pathTemplates.omnichannelPathTemplate.match(omnichannelName).location;
  }

  /**
   * Parse the omnichannel from Omnichannel resource.
   *
   * @param {string} omnichannelName
   *   A fully-qualified path representing Omnichannel resource.
   * @returns {string} A string representing the omnichannel.
   */
  matchOmnichannelFromOmnichannelName(omnichannelName: string) {
    return this.pathTemplates.omnichannelPathTemplate.match(omnichannelName).omnichannel;
  }

  /**
   * Return a fully-qualified project resource name string.
   *
   * @param {string} project
   * @returns {string} Resource name string.
   */
  projectPath(project:string) {
    return this.pathTemplates.projectPathTemplate.render({
      project: project,
    });
  }

  /**
   * Parse the project from Project resource.
   *
   * @param {string} projectName
   *   A fully-qualified path representing Project resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectName(projectName: string) {
    return this.pathTemplates.projectPathTemplate.match(projectName).project;
  }

  /**
   * Return a fully-qualified scheduledEvaluationRun resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} scheduled_evaluation_run
   * @returns {string} Resource name string.
   */
  scheduledEvaluationRunPath(project:string,location:string,app:string,scheduledEvaluationRun:string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.render({
      project: project,
      location: location,
      app: app,
      scheduled_evaluation_run: scheduledEvaluationRun,
    });
  }

  /**
   * Parse the project from ScheduledEvaluationRun resource.
   *
   * @param {string} scheduledEvaluationRunName
   *   A fully-qualified path representing ScheduledEvaluationRun resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromScheduledEvaluationRunName(scheduledEvaluationRunName: string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.match(scheduledEvaluationRunName).project;
  }

  /**
   * Parse the location from ScheduledEvaluationRun resource.
   *
   * @param {string} scheduledEvaluationRunName
   *   A fully-qualified path representing ScheduledEvaluationRun resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromScheduledEvaluationRunName(scheduledEvaluationRunName: string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.match(scheduledEvaluationRunName).location;
  }

  /**
   * Parse the app from ScheduledEvaluationRun resource.
   *
   * @param {string} scheduledEvaluationRunName
   *   A fully-qualified path representing ScheduledEvaluationRun resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromScheduledEvaluationRunName(scheduledEvaluationRunName: string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.match(scheduledEvaluationRunName).app;
  }

  /**
   * Parse the scheduled_evaluation_run from ScheduledEvaluationRun resource.
   *
   * @param {string} scheduledEvaluationRunName
   *   A fully-qualified path representing ScheduledEvaluationRun resource.
   * @returns {string} A string representing the scheduled_evaluation_run.
   */
  matchScheduledEvaluationRunFromScheduledEvaluationRunName(scheduledEvaluationRunName: string) {
    return this.pathTemplates.scheduledEvaluationRunPathTemplate.match(scheduledEvaluationRunName).scheduled_evaluation_run;
  }

  /**
   * Return a fully-qualified tool resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} tool
   * @returns {string} Resource name string.
   */
  toolPath(project:string,location:string,app:string,tool:string) {
    return this.pathTemplates.toolPathTemplate.render({
      project: project,
      location: location,
      app: app,
      tool: tool,
    });
  }

  /**
   * Parse the project from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).project;
  }

  /**
   * Parse the location from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).location;
  }

  /**
   * Parse the app from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).app;
  }

  /**
   * Parse the tool from Tool resource.
   *
   * @param {string} toolName
   *   A fully-qualified path representing Tool resource.
   * @returns {string} A string representing the tool.
   */
  matchToolFromToolName(toolName: string) {
    return this.pathTemplates.toolPathTemplate.match(toolName).tool;
  }

  /**
   * Return a fully-qualified toolset resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} app
   * @param {string} toolset
   * @returns {string} Resource name string.
   */
  toolsetPath(project:string,location:string,app:string,toolset:string) {
    return this.pathTemplates.toolsetPathTemplate.render({
      project: project,
      location: location,
      app: app,
      toolset: toolset,
    });
  }

  /**
   * Parse the project from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).project;
  }

  /**
   * Parse the location from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).location;
  }

  /**
   * Parse the app from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the app.
   */
  matchAppFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).app;
  }

  /**
   * Parse the toolset from Toolset resource.
   *
   * @param {string} toolsetName
   *   A fully-qualified path representing Toolset resource.
   * @returns {string} A string representing the toolset.
   */
  matchToolsetFromToolsetName(toolsetName: string) {
    return this.pathTemplates.toolsetPathTemplate.match(toolsetName).toolset;
  }

  /**
   * Terminate the gRPC channel and close the client.
   *
   * The client will no longer be usable and all future behavior is undefined.
   * @returns {Promise} A promise that resolves when the client is closed.
   */
  close(): Promise<void> {
    if (this.evaluationServiceStub && !this._terminated) {
      return this.evaluationServiceStub.then(stub => {
        this._log.info('ending gRPC channel');
        this._terminated = true;
        stub.close();
        this.locationsClient.close().catch(err => {throw err});
        void this.operationsClient.close();
      });
    }
    return Promise.resolve();
  }
}