// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

import * as protos from '../protos/protos';
import * as assert from 'assert';
import * as sinon from 'sinon';
import {SinonStub} from 'sinon';
import {describe, it} from 'mocha';
import * as agentserviceModule from '../src';

import {PassThrough} from 'stream';

import {protobuf, LROperation, operationsProtos, LocationProtos} from 'google-gax';

// Dynamically loaded proto JSON is needed to get the type information
// to fill in default values for request objects
const root = protobuf.Root.fromJSON(require('../protos/protos.json')).resolveAll();

// eslint-disable-next-line @typescript-eslint/no-unused-vars
function getTypeDefaultValue(typeName: string, fields: string[]) {
    let type = root.lookupType(typeName) as protobuf.Type;
    for (const field of fields.slice(0, -1)) {
        type = type.fields[field]?.resolvedType as protobuf.Type;
    }
    return type.fields[fields[fields.length - 1]]?.defaultValue;
}

function generateSampleMessage<T extends object>(instance: T) {
    const filledObject = (instance.constructor as typeof protobuf.Message)
        .toObject(instance as protobuf.Message<T>, {defaults: true});
    return (instance.constructor as typeof protobuf.Message).fromObject(filledObject) as T;
}

function stubSimpleCall<ResponseType>(response?: ResponseType, error?: Error) {
    return error ? sinon.stub().rejects(error) : sinon.stub().resolves([response]);
}

function stubSimpleCallWithCallback<ResponseType>(response?: ResponseType, error?: Error) {
    return error ? sinon.stub().callsArgWith(2, error) : sinon.stub().callsArgWith(2, null, response);
}

function stubLongRunningCall<ResponseType>(response?: ResponseType, callError?: Error, lroError?: Error) {
    const innerStub = lroError ? sinon.stub().rejects(lroError) : sinon.stub().resolves([response]);
    const mockOperation = {
        promise: innerStub,
    };
    return callError ? sinon.stub().rejects(callError) : sinon.stub().resolves([mockOperation]);
}

function stubLongRunningCallWithCallback<ResponseType>(response?: ResponseType, callError?: Error, lroError?: Error) {
    const innerStub = lroError ? sinon.stub().rejects(lroError) : sinon.stub().resolves([response]);
    const mockOperation = {
        promise: innerStub,
    };
    return callError ? sinon.stub().callsArgWith(2, callError) : sinon.stub().callsArgWith(2, null, mockOperation);
}

function stubPageStreamingCall<ResponseType>(responses?: ResponseType[], error?: Error) {
    const pagingStub = sinon.stub();
    if (responses) {
        for (let i = 0; i < responses.length; ++i) {
            pagingStub.onCall(i).callsArgWith(2, null, responses[i]);
        }
    }
    const transformStub = error ? sinon.stub().callsArgWith(2, error) : pagingStub;
    const mockStream = new PassThrough({
        objectMode: true,
        transform: transformStub,
    });
    // trigger as many responses as needed
    if (responses) {
        for (let i = 0; i < responses.length; ++i) {
            setImmediate(() => { mockStream.write({}); });
        }
        setImmediate(() => { mockStream.end(); });
    } else {
        setImmediate(() => { mockStream.write({}); });
        setImmediate(() => { mockStream.end(); });
    }
    return sinon.stub().returns(mockStream);
}

function stubAsyncIterationCall<ResponseType>(responses?: ResponseType[], error?: Error) {
    let counter = 0;
    const asyncIterable = {
        [Symbol.asyncIterator]() {
            return {
                async next() {
                    if (error) {
                        return Promise.reject(error);
                    }
                    if (counter >= responses!.length) {
                        return Promise.resolve({done: true, value: undefined});
                    }
                    return Promise.resolve({done: false, value: responses![counter++]});
                }
            };
        }
    };
    return sinon.stub().returns(asyncIterable);
}

describe('v1beta.AgentServiceClient', () => {
    describe('Common methods', () => {
        it('has apiEndpoint', () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient();
            const apiEndpoint = client.apiEndpoint;
            assert.strictEqual(apiEndpoint, 'ces.googleapis.com');
        });

        it('has universeDomain', () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient();
            const universeDomain = client.universeDomain;
            assert.strictEqual(universeDomain, "googleapis.com");
        });

        if (typeof process === 'object' && typeof process.emitWarning === 'function') {
            it('throws DeprecationWarning if static servicePath is used', () => {
                const stub = sinon.stub(process, 'emitWarning');
                const servicePath = agentserviceModule.v1beta.AgentServiceClient.servicePath;
                assert.strictEqual(servicePath, 'ces.googleapis.com');
                assert(stub.called);
                stub.restore();
            });

            it('throws DeprecationWarning if static apiEndpoint is used', () => {
                const stub = sinon.stub(process, 'emitWarning');
                const apiEndpoint = agentserviceModule.v1beta.AgentServiceClient.apiEndpoint;
                assert.strictEqual(apiEndpoint, 'ces.googleapis.com');
                assert(stub.called);
                stub.restore();
            });
        }
        it('sets apiEndpoint according to universe domain camelCase', () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({universeDomain: 'example.com'});
            const servicePath = client.apiEndpoint;
            assert.strictEqual(servicePath, 'ces.example.com');
        });

        it('sets apiEndpoint according to universe domain snakeCase', () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({universe_domain: 'example.com'});
            const servicePath = client.apiEndpoint;
            assert.strictEqual(servicePath, 'ces.example.com');
        });

        if (typeof process === 'object' && 'env' in process) {
            describe('GOOGLE_CLOUD_UNIVERSE_DOMAIN environment variable', () => {
                it('sets apiEndpoint from environment variable', () => {
                    const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
                    const client = new agentserviceModule.v1beta.AgentServiceClient();
                    const servicePath = client.apiEndpoint;
                    assert.strictEqual(servicePath, 'ces.example.com');
                    if (saved) {
                        process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
                    } else {
                        delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    }
                });

                it('value configured in code has priority over environment variable', () => {
                    const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
                    const client = new agentserviceModule.v1beta.AgentServiceClient({universeDomain: 'configured.example.com'});
                    const servicePath = client.apiEndpoint;
                    assert.strictEqual(servicePath, 'ces.configured.example.com');
                    if (saved) {
                        process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
                    } else {
                        delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    }
                });
            });
        }
        it('does not allow setting both universeDomain and universe_domain', () => {
            assert.throws(() => { new agentserviceModule.v1beta.AgentServiceClient({universe_domain: 'example.com', universeDomain: 'example.net'}); });
        });

        it('has port', () => {
            const port = agentserviceModule.v1beta.AgentServiceClient.port;
            assert(port);
            assert(typeof port === 'number');
        });

        it('should create a client with no option', () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient();
            assert(client);
        });

        it('should create a client with gRPC fallback', () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                fallback: true,
            });
            assert(client);
        });

        it('has initialize method and supports deferred initialization', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            assert.strictEqual(client.agentServiceStub, undefined);
            await client.initialize();
            assert(client.agentServiceStub);
        });

        it('has close method for the initialized client', done => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            client.initialize().catch(err => {throw err});
            assert(client.agentServiceStub);
            client.close().then(() => {
                done();
            }).catch(err => {throw err});
        });

        it('has close method for the non-initialized client', done => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            assert.strictEqual(client.agentServiceStub, undefined);
            client.close().then(() => {
                done();
            }).catch(err => {throw err});
        });

        it('has getProjectId method', async () => {
            const fakeProjectId = 'fake-project-id';
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            client.auth.getProjectId = sinon.stub().resolves(fakeProjectId);
            const result = await client.getProjectId();
            assert.strictEqual(result, fakeProjectId);
            assert((client.auth.getProjectId as SinonStub).calledWithExactly());
        });

        it('has getProjectId method with callback', async () => {
            const fakeProjectId = 'fake-project-id';
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            client.auth.getProjectId = sinon.stub().callsArgWith(0, null, fakeProjectId);
            const promise = new Promise((resolve, reject) => {
                client.getProjectId((err?: Error|null, projectId?: string|null) => {
                    if (err) {
                        reject(err);
                    } else {
                        resolve(projectId);
                    }
                });
            });
            const result = await promise;
            assert.strictEqual(result, fakeProjectId);
        });
    });

    describe('getApp', () => {
        it('invokes getApp without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.App()
            );
            client.innerApiCalls.getApp = stubSimpleCall(expectedResponse);
            const [response] = await client.getApp(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getApp without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.App()
            );
            client.innerApiCalls.getApp = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getApp(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IApp|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getApp with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getApp = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getApp(request), expectedError);
            const actualRequest = (client.innerApiCalls.getApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getApp with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getApp(request), expectedError);
        });
    });

    describe('updateApp', () => {
        it('invokes updateApp without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateAppRequest()
            );
            request.app ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateAppRequest', ['app', 'name']);
            request.app.name = defaultValue1;
            const expectedHeaderRequestParams = `app.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.App()
            );
            client.innerApiCalls.updateApp = stubSimpleCall(expectedResponse);
            const [response] = await client.updateApp(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateApp without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateAppRequest()
            );
            request.app ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateAppRequest', ['app', 'name']);
            request.app.name = defaultValue1;
            const expectedHeaderRequestParams = `app.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.App()
            );
            client.innerApiCalls.updateApp = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateApp(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IApp|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateApp with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateAppRequest()
            );
            request.app ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateAppRequest', ['app', 'name']);
            request.app.name = defaultValue1;
            const expectedHeaderRequestParams = `app.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateApp = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateApp(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateApp with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateAppRequest()
            );
            request.app ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateAppRequest', ['app', 'name']);
            request.app.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateApp(request), expectedError);
        });
    });

    describe('getAgent', () => {
        it('invokes getAgent without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAgentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Agent()
            );
            client.innerApiCalls.getAgent = stubSimpleCall(expectedResponse);
            const [response] = await client.getAgent(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getAgent without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAgentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Agent()
            );
            client.innerApiCalls.getAgent = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getAgent(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IAgent|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getAgent with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAgentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getAgent = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getAgent(request), expectedError);
            const actualRequest = (client.innerApiCalls.getAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getAgent with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAgentRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getAgent(request), expectedError);
        });
    });

    describe('createAgent', () => {
        it('invokes createAgent without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAgentRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Agent()
            );
            client.innerApiCalls.createAgent = stubSimpleCall(expectedResponse);
            const [response] = await client.createAgent(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createAgent without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAgentRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Agent()
            );
            client.innerApiCalls.createAgent = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createAgent(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IAgent|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createAgent with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAgentRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createAgent = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createAgent(request), expectedError);
            const actualRequest = (client.innerApiCalls.createAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createAgent with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAgentRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createAgent(request), expectedError);
        });
    });

    describe('updateAgent', () => {
        it('invokes updateAgent without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateAgentRequest()
            );
            request.agent ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateAgentRequest', ['agent', 'name']);
            request.agent.name = defaultValue1;
            const expectedHeaderRequestParams = `agent.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Agent()
            );
            client.innerApiCalls.updateAgent = stubSimpleCall(expectedResponse);
            const [response] = await client.updateAgent(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateAgent without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateAgentRequest()
            );
            request.agent ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateAgentRequest', ['agent', 'name']);
            request.agent.name = defaultValue1;
            const expectedHeaderRequestParams = `agent.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Agent()
            );
            client.innerApiCalls.updateAgent = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateAgent(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IAgent|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateAgent with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateAgentRequest()
            );
            request.agent ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateAgentRequest', ['agent', 'name']);
            request.agent.name = defaultValue1;
            const expectedHeaderRequestParams = `agent.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateAgent = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateAgent(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateAgent with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateAgentRequest()
            );
            request.agent ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateAgentRequest', ['agent', 'name']);
            request.agent.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateAgent(request), expectedError);
        });
    });

    describe('deleteAgent', () => {
        it('invokes deleteAgent without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAgentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteAgent = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteAgent(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteAgent without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAgentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteAgent = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteAgent(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteAgent with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAgentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteAgent = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteAgent(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteAgent as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteAgent as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteAgent with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAgentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAgentRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteAgent(request), expectedError);
        });
    });

    describe('getExample', () => {
        it('invokes getExample without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetExampleRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Example()
            );
            client.innerApiCalls.getExample = stubSimpleCall(expectedResponse);
            const [response] = await client.getExample(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getExample without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetExampleRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Example()
            );
            client.innerApiCalls.getExample = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getExample(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IExample|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getExample with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetExampleRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getExample = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getExample(request), expectedError);
            const actualRequest = (client.innerApiCalls.getExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getExample with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetExampleRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getExample(request), expectedError);
        });
    });

    describe('createExample', () => {
        it('invokes createExample without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateExampleRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Example()
            );
            client.innerApiCalls.createExample = stubSimpleCall(expectedResponse);
            const [response] = await client.createExample(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createExample without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateExampleRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Example()
            );
            client.innerApiCalls.createExample = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createExample(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IExample|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createExample with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateExampleRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createExample = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createExample(request), expectedError);
            const actualRequest = (client.innerApiCalls.createExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createExample with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateExampleRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createExample(request), expectedError);
        });
    });

    describe('updateExample', () => {
        it('invokes updateExample without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateExampleRequest()
            );
            request.example ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateExampleRequest', ['example', 'name']);
            request.example.name = defaultValue1;
            const expectedHeaderRequestParams = `example.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Example()
            );
            client.innerApiCalls.updateExample = stubSimpleCall(expectedResponse);
            const [response] = await client.updateExample(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateExample without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateExampleRequest()
            );
            request.example ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateExampleRequest', ['example', 'name']);
            request.example.name = defaultValue1;
            const expectedHeaderRequestParams = `example.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Example()
            );
            client.innerApiCalls.updateExample = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateExample(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IExample|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateExample with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateExampleRequest()
            );
            request.example ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateExampleRequest', ['example', 'name']);
            request.example.name = defaultValue1;
            const expectedHeaderRequestParams = `example.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateExample = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateExample(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateExample with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateExampleRequest()
            );
            request.example ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateExampleRequest', ['example', 'name']);
            request.example.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateExample(request), expectedError);
        });
    });

    describe('deleteExample', () => {
        it('invokes deleteExample without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteExampleRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteExample = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteExample(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteExample without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteExampleRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteExample = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteExample(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteExample with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteExampleRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteExample = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteExample(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteExample as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteExample as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteExample with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteExampleRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteExampleRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteExample(request), expectedError);
        });
    });

    describe('getTool', () => {
        it('invokes getTool without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetToolRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Tool()
            );
            client.innerApiCalls.getTool = stubSimpleCall(expectedResponse);
            const [response] = await client.getTool(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getTool without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetToolRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Tool()
            );
            client.innerApiCalls.getTool = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getTool(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.ITool|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getTool with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetToolRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getTool = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getTool(request), expectedError);
            const actualRequest = (client.innerApiCalls.getTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getTool with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetToolRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getTool(request), expectedError);
        });
    });

    describe('getConversation', () => {
        it('invokes getConversation without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetConversationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetConversationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Conversation()
            );
            client.innerApiCalls.getConversation = stubSimpleCall(expectedResponse);
            const [response] = await client.getConversation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getConversation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getConversation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getConversation without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetConversationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetConversationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Conversation()
            );
            client.innerApiCalls.getConversation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getConversation(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IConversation|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getConversation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getConversation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getConversation with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetConversationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetConversationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getConversation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getConversation(request), expectedError);
            const actualRequest = (client.innerApiCalls.getConversation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getConversation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getConversation with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetConversationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetConversationRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getConversation(request), expectedError);
        });
    });

    describe('deleteConversation', () => {
        it('invokes deleteConversation without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteConversationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteConversationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteConversation = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteConversation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteConversation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteConversation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteConversation without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteConversationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteConversationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteConversation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteConversation(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteConversation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteConversation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteConversation with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteConversationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteConversationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteConversation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteConversation(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteConversation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteConversation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteConversation with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteConversationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteConversationRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteConversation(request), expectedError);
        });
    });

    describe('createTool', () => {
        it('invokes createTool without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateToolRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Tool()
            );
            client.innerApiCalls.createTool = stubSimpleCall(expectedResponse);
            const [response] = await client.createTool(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createTool without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateToolRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Tool()
            );
            client.innerApiCalls.createTool = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createTool(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.ITool|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createTool with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateToolRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createTool = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createTool(request), expectedError);
            const actualRequest = (client.innerApiCalls.createTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createTool with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateToolRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createTool(request), expectedError);
        });
    });

    describe('updateTool', () => {
        it('invokes updateTool without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateToolRequest()
            );
            request.tool ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateToolRequest', ['tool', 'name']);
            request.tool.name = defaultValue1;
            const expectedHeaderRequestParams = `tool.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Tool()
            );
            client.innerApiCalls.updateTool = stubSimpleCall(expectedResponse);
            const [response] = await client.updateTool(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateTool without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateToolRequest()
            );
            request.tool ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateToolRequest', ['tool', 'name']);
            request.tool.name = defaultValue1;
            const expectedHeaderRequestParams = `tool.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Tool()
            );
            client.innerApiCalls.updateTool = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateTool(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.ITool|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateTool with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateToolRequest()
            );
            request.tool ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateToolRequest', ['tool', 'name']);
            request.tool.name = defaultValue1;
            const expectedHeaderRequestParams = `tool.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateTool = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateTool(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateTool with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateToolRequest()
            );
            request.tool ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateToolRequest', ['tool', 'name']);
            request.tool.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateTool(request), expectedError);
        });
    });

    describe('deleteTool', () => {
        it('invokes deleteTool without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteToolRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteTool = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteTool(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteTool without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteToolRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteTool = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteTool(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteTool with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteToolRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteTool = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteTool(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteTool as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteTool as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteTool with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteToolRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteToolRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteTool(request), expectedError);
        });
    });

    describe('getGuardrail', () => {
        it('invokes getGuardrail without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetGuardrailRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Guardrail()
            );
            client.innerApiCalls.getGuardrail = stubSimpleCall(expectedResponse);
            const [response] = await client.getGuardrail(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getGuardrail without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetGuardrailRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Guardrail()
            );
            client.innerApiCalls.getGuardrail = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getGuardrail(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IGuardrail|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getGuardrail with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetGuardrailRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getGuardrail = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getGuardrail(request), expectedError);
            const actualRequest = (client.innerApiCalls.getGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getGuardrail with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetGuardrailRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getGuardrail(request), expectedError);
        });
    });

    describe('createGuardrail', () => {
        it('invokes createGuardrail without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateGuardrailRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Guardrail()
            );
            client.innerApiCalls.createGuardrail = stubSimpleCall(expectedResponse);
            const [response] = await client.createGuardrail(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createGuardrail without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateGuardrailRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Guardrail()
            );
            client.innerApiCalls.createGuardrail = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createGuardrail(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IGuardrail|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createGuardrail with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateGuardrailRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createGuardrail = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createGuardrail(request), expectedError);
            const actualRequest = (client.innerApiCalls.createGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createGuardrail with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateGuardrailRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createGuardrail(request), expectedError);
        });
    });

    describe('updateGuardrail', () => {
        it('invokes updateGuardrail without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateGuardrailRequest()
            );
            request.guardrail ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateGuardrailRequest', ['guardrail', 'name']);
            request.guardrail.name = defaultValue1;
            const expectedHeaderRequestParams = `guardrail.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Guardrail()
            );
            client.innerApiCalls.updateGuardrail = stubSimpleCall(expectedResponse);
            const [response] = await client.updateGuardrail(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateGuardrail without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateGuardrailRequest()
            );
            request.guardrail ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateGuardrailRequest', ['guardrail', 'name']);
            request.guardrail.name = defaultValue1;
            const expectedHeaderRequestParams = `guardrail.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Guardrail()
            );
            client.innerApiCalls.updateGuardrail = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateGuardrail(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IGuardrail|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateGuardrail with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateGuardrailRequest()
            );
            request.guardrail ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateGuardrailRequest', ['guardrail', 'name']);
            request.guardrail.name = defaultValue1;
            const expectedHeaderRequestParams = `guardrail.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateGuardrail = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateGuardrail(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateGuardrail with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateGuardrailRequest()
            );
            request.guardrail ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateGuardrailRequest', ['guardrail', 'name']);
            request.guardrail.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateGuardrail(request), expectedError);
        });
    });

    describe('deleteGuardrail', () => {
        it('invokes deleteGuardrail without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteGuardrailRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteGuardrail = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteGuardrail(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteGuardrail without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteGuardrailRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteGuardrail = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteGuardrail(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteGuardrail with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteGuardrailRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteGuardrail = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteGuardrail(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteGuardrail as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteGuardrail as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteGuardrail with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteGuardrailRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteGuardrailRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteGuardrail(request), expectedError);
        });
    });

    describe('getDeployment', () => {
        it('invokes getDeployment without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetDeploymentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Deployment()
            );
            client.innerApiCalls.getDeployment = stubSimpleCall(expectedResponse);
            const [response] = await client.getDeployment(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getDeployment without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetDeploymentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Deployment()
            );
            client.innerApiCalls.getDeployment = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getDeployment(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IDeployment|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getDeployment with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetDeploymentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getDeployment = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getDeployment(request), expectedError);
            const actualRequest = (client.innerApiCalls.getDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getDeployment with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetDeploymentRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getDeployment(request), expectedError);
        });
    });

    describe('createDeployment', () => {
        it('invokes createDeployment without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateDeploymentRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Deployment()
            );
            client.innerApiCalls.createDeployment = stubSimpleCall(expectedResponse);
            const [response] = await client.createDeployment(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createDeployment without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateDeploymentRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Deployment()
            );
            client.innerApiCalls.createDeployment = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createDeployment(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IDeployment|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createDeployment with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateDeploymentRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createDeployment = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createDeployment(request), expectedError);
            const actualRequest = (client.innerApiCalls.createDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createDeployment with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateDeploymentRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createDeployment(request), expectedError);
        });
    });

    describe('updateDeployment', () => {
        it('invokes updateDeployment without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateDeploymentRequest()
            );
            request.deployment ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateDeploymentRequest', ['deployment', 'name']);
            request.deployment.name = defaultValue1;
            const expectedHeaderRequestParams = `deployment.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Deployment()
            );
            client.innerApiCalls.updateDeployment = stubSimpleCall(expectedResponse);
            const [response] = await client.updateDeployment(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateDeployment without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateDeploymentRequest()
            );
            request.deployment ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateDeploymentRequest', ['deployment', 'name']);
            request.deployment.name = defaultValue1;
            const expectedHeaderRequestParams = `deployment.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Deployment()
            );
            client.innerApiCalls.updateDeployment = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateDeployment(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IDeployment|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateDeployment with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateDeploymentRequest()
            );
            request.deployment ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateDeploymentRequest', ['deployment', 'name']);
            request.deployment.name = defaultValue1;
            const expectedHeaderRequestParams = `deployment.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateDeployment = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateDeployment(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateDeployment with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateDeploymentRequest()
            );
            request.deployment ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateDeploymentRequest', ['deployment', 'name']);
            request.deployment.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateDeployment(request), expectedError);
        });
    });

    describe('deleteDeployment', () => {
        it('invokes deleteDeployment without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteDeploymentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteDeployment = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteDeployment(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteDeployment without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteDeploymentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteDeployment = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteDeployment(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteDeployment with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteDeploymentRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteDeployment = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteDeployment(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteDeployment as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteDeployment as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteDeployment with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteDeploymentRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteDeploymentRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteDeployment(request), expectedError);
        });
    });

    describe('getToolset', () => {
        it('invokes getToolset without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetToolsetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Toolset()
            );
            client.innerApiCalls.getToolset = stubSimpleCall(expectedResponse);
            const [response] = await client.getToolset(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getToolset without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetToolsetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Toolset()
            );
            client.innerApiCalls.getToolset = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getToolset(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IToolset|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getToolset with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetToolsetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getToolset = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getToolset(request), expectedError);
            const actualRequest = (client.innerApiCalls.getToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getToolset with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetToolsetRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getToolset(request), expectedError);
        });
    });

    describe('createToolset', () => {
        it('invokes createToolset without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateToolsetRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Toolset()
            );
            client.innerApiCalls.createToolset = stubSimpleCall(expectedResponse);
            const [response] = await client.createToolset(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createToolset without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateToolsetRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Toolset()
            );
            client.innerApiCalls.createToolset = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createToolset(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IToolset|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createToolset with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateToolsetRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createToolset = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createToolset(request), expectedError);
            const actualRequest = (client.innerApiCalls.createToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createToolset with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateToolsetRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createToolset(request), expectedError);
        });
    });

    describe('updateToolset', () => {
        it('invokes updateToolset without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateToolsetRequest()
            );
            request.toolset ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateToolsetRequest', ['toolset', 'name']);
            request.toolset.name = defaultValue1;
            const expectedHeaderRequestParams = `toolset.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Toolset()
            );
            client.innerApiCalls.updateToolset = stubSimpleCall(expectedResponse);
            const [response] = await client.updateToolset(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateToolset without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateToolsetRequest()
            );
            request.toolset ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateToolsetRequest', ['toolset', 'name']);
            request.toolset.name = defaultValue1;
            const expectedHeaderRequestParams = `toolset.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Toolset()
            );
            client.innerApiCalls.updateToolset = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateToolset(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IToolset|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateToolset with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateToolsetRequest()
            );
            request.toolset ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateToolsetRequest', ['toolset', 'name']);
            request.toolset.name = defaultValue1;
            const expectedHeaderRequestParams = `toolset.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateToolset = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateToolset(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateToolset with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateToolsetRequest()
            );
            request.toolset ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateToolsetRequest', ['toolset', 'name']);
            request.toolset.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateToolset(request), expectedError);
        });
    });

    describe('deleteToolset', () => {
        it('invokes deleteToolset without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteToolsetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteToolset = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteToolset(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteToolset without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteToolsetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteToolset = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteToolset(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteToolset with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteToolsetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteToolset = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteToolset(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteToolset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteToolset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteToolset with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteToolsetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteToolsetRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteToolset(request), expectedError);
        });
    });

    describe('getAppVersion', () => {
        it('invokes getAppVersion without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.AppVersion()
            );
            client.innerApiCalls.getAppVersion = stubSimpleCall(expectedResponse);
            const [response] = await client.getAppVersion(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getAppVersion without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.AppVersion()
            );
            client.innerApiCalls.getAppVersion = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getAppVersion(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IAppVersion|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getAppVersion with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getAppVersion = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getAppVersion(request), expectedError);
            const actualRequest = (client.innerApiCalls.getAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getAppVersion with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getAppVersion(request), expectedError);
        });
    });

    describe('createAppVersion', () => {
        it('invokes createAppVersion without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAppVersionRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.AppVersion()
            );
            client.innerApiCalls.createAppVersion = stubSimpleCall(expectedResponse);
            const [response] = await client.createAppVersion(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createAppVersion without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAppVersionRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.AppVersion()
            );
            client.innerApiCalls.createAppVersion = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createAppVersion(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IAppVersion|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createAppVersion with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAppVersionRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createAppVersion = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createAppVersion(request), expectedError);
            const actualRequest = (client.innerApiCalls.createAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createAppVersion with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAppVersionRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createAppVersion(request), expectedError);
        });
    });

    describe('deleteAppVersion', () => {
        it('invokes deleteAppVersion without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteAppVersion = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteAppVersion(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteAppVersion without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteAppVersion = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteAppVersion(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteAppVersion with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteAppVersion = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteAppVersion(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteAppVersion with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteAppVersion(request), expectedError);
        });
    });

    describe('getChangelog', () => {
        it('invokes getChangelog without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetChangelogRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetChangelogRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Changelog()
            );
            client.innerApiCalls.getChangelog = stubSimpleCall(expectedResponse);
            const [response] = await client.getChangelog(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getChangelog as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getChangelog as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getChangelog without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetChangelogRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetChangelogRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Changelog()
            );
            client.innerApiCalls.getChangelog = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getChangelog(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IChangelog|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getChangelog as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getChangelog as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getChangelog with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetChangelogRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetChangelogRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getChangelog = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getChangelog(request), expectedError);
            const actualRequest = (client.innerApiCalls.getChangelog as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getChangelog as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getChangelog with closed client', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetChangelogRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetChangelogRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getChangelog(request), expectedError);
        });
    });

    describe('createApp', () => {
        it('invokes createApp without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAppRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.createApp = stubLongRunningCall(expectedResponse);
            const [operation] = await client.createApp(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createApp without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAppRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.createApp = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createApp(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.cloud.ces.v1beta.IApp, protos.google.cloud.ces.v1beta.IOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createApp with call error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAppRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createApp = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.createApp(request), expectedError);
            const actualRequest = (client.innerApiCalls.createApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createApp with LRO error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateAppRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createApp = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.createApp(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.createApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkCreateAppProgress without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkCreateAppProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkCreateAppProgress with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkCreateAppProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('deleteApp', () => {
        it('invokes deleteApp without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.deleteApp = stubLongRunningCall(expectedResponse);
            const [operation] = await client.deleteApp(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteApp without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.deleteApp = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteApp(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteApp with call error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteApp = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.deleteApp(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteApp with LRO error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteApp = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.deleteApp(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.deleteApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkDeleteAppProgress without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkDeleteAppProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkDeleteAppProgress with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkDeleteAppProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('exportApp', () => {
        it('invokes exportApp without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ExportAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ExportAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.exportApp = stubLongRunningCall(expectedResponse);
            const [operation] = await client.exportApp(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.exportApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.exportApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes exportApp without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ExportAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ExportAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.exportApp = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.exportApp(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.cloud.ces.v1beta.IExportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.exportApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.exportApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes exportApp with call error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ExportAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ExportAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.exportApp = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.exportApp(request), expectedError);
            const actualRequest = (client.innerApiCalls.exportApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.exportApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes exportApp with LRO error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ExportAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ExportAppRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.exportApp = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.exportApp(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.exportApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.exportApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkExportAppProgress without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkExportAppProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkExportAppProgress with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkExportAppProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('importApp', () => {
        it('invokes importApp without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ImportAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ImportAppRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.importApp = stubLongRunningCall(expectedResponse);
            const [operation] = await client.importApp(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.importApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.importApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes importApp without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ImportAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ImportAppRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.importApp = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.importApp(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.cloud.ces.v1beta.IImportAppResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.importApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.importApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes importApp with call error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ImportAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ImportAppRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.importApp = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.importApp(request), expectedError);
            const actualRequest = (client.innerApiCalls.importApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.importApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes importApp with LRO error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ImportAppRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ImportAppRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.importApp = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.importApp(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.importApp as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.importApp as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkImportAppProgress without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkImportAppProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkImportAppProgress with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkImportAppProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('batchDeleteConversations', () => {
        it('invokes batchDeleteConversations without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.BatchDeleteConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.BatchDeleteConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.batchDeleteConversations = stubLongRunningCall(expectedResponse);
            const [operation] = await client.batchDeleteConversations(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.batchDeleteConversations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.batchDeleteConversations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes batchDeleteConversations without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.BatchDeleteConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.BatchDeleteConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.batchDeleteConversations = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.batchDeleteConversations(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.cloud.ces.v1beta.IBatchDeleteConversationsResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.batchDeleteConversations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.batchDeleteConversations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes batchDeleteConversations with call error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.BatchDeleteConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.BatchDeleteConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.batchDeleteConversations = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.batchDeleteConversations(request), expectedError);
            const actualRequest = (client.innerApiCalls.batchDeleteConversations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.batchDeleteConversations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes batchDeleteConversations with LRO error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.BatchDeleteConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.BatchDeleteConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.batchDeleteConversations = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.batchDeleteConversations(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.batchDeleteConversations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.batchDeleteConversations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkBatchDeleteConversationsProgress without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkBatchDeleteConversationsProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkBatchDeleteConversationsProgress with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkBatchDeleteConversationsProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('restoreAppVersion', () => {
        it('invokes restoreAppVersion without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.RestoreAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.RestoreAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.restoreAppVersion = stubLongRunningCall(expectedResponse);
            const [operation] = await client.restoreAppVersion(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.restoreAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.restoreAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes restoreAppVersion without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.RestoreAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.RestoreAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.restoreAppVersion = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.restoreAppVersion(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.cloud.ces.v1beta.IRestoreAppVersionResponse, protos.google.cloud.ces.v1beta.IOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.restoreAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.restoreAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes restoreAppVersion with call error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.RestoreAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.RestoreAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.restoreAppVersion = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.restoreAppVersion(request), expectedError);
            const actualRequest = (client.innerApiCalls.restoreAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.restoreAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes restoreAppVersion with LRO error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.RestoreAppVersionRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.RestoreAppVersionRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.restoreAppVersion = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.restoreAppVersion(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.restoreAppVersion as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.restoreAppVersion as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkRestoreAppVersionProgress without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkRestoreAppVersionProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkRestoreAppVersionProgress with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkRestoreAppVersionProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('listApps', () => {
        it('invokes listApps without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
            ];
            client.innerApiCalls.listApps = stubSimpleCall(expectedResponse);
            const [response] = await client.listApps(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listApps as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listApps as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listApps without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
            ];
            client.innerApiCalls.listApps = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listApps(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IApp[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listApps as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listApps as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listApps with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listApps = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listApps(request), expectedError);
            const actualRequest = (client.innerApiCalls.listApps as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listApps as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listAppsStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
            ];
            client.descriptors.page.listApps.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listAppsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.App[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.App) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listApps.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listApps, request));
            assert(
                (client.descriptors.page.listApps.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listAppsStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listApps.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listAppsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.App[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.App) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listApps.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listApps, request));
            assert(
                (client.descriptors.page.listApps.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listApps without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.App()),
            ];
            client.descriptors.page.listApps.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IApp[] = [];
            const iterable = client.listAppsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listApps.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listApps.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listApps with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listApps.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listAppsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IApp[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listApps.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listApps.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listAgents', () => {
        it('invokes listAgents without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAgentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAgentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
            ];
            client.innerApiCalls.listAgents = stubSimpleCall(expectedResponse);
            const [response] = await client.listAgents(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listAgents as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listAgents as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listAgents without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAgentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAgentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
            ];
            client.innerApiCalls.listAgents = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listAgents(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IAgent[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listAgents as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listAgents as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listAgents with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAgentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAgentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listAgents = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listAgents(request), expectedError);
            const actualRequest = (client.innerApiCalls.listAgents as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listAgents as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listAgentsStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAgentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAgentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
            ];
            client.descriptors.page.listAgents.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listAgentsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Agent[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Agent) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listAgents.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listAgents, request));
            assert(
                (client.descriptors.page.listAgents.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listAgentsStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAgentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAgentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listAgents.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listAgentsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Agent[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Agent) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listAgents.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listAgents, request));
            assert(
                (client.descriptors.page.listAgents.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listAgents without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAgentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAgentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Agent()),
            ];
            client.descriptors.page.listAgents.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IAgent[] = [];
            const iterable = client.listAgentsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listAgents.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listAgents.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listAgents with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAgentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAgentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listAgents.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listAgentsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IAgent[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listAgents.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listAgents.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listExamples', () => {
        it('invokes listExamples without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListExamplesRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListExamplesRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
            ];
            client.innerApiCalls.listExamples = stubSimpleCall(expectedResponse);
            const [response] = await client.listExamples(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listExamples as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listExamples as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listExamples without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListExamplesRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListExamplesRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
            ];
            client.innerApiCalls.listExamples = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listExamples(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IExample[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listExamples as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listExamples as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listExamples with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListExamplesRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListExamplesRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listExamples = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listExamples(request), expectedError);
            const actualRequest = (client.innerApiCalls.listExamples as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listExamples as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listExamplesStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListExamplesRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListExamplesRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
            ];
            client.descriptors.page.listExamples.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listExamplesStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Example[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Example) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listExamples.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listExamples, request));
            assert(
                (client.descriptors.page.listExamples.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listExamplesStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListExamplesRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListExamplesRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listExamples.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listExamplesStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Example[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Example) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listExamples.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listExamples, request));
            assert(
                (client.descriptors.page.listExamples.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listExamples without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListExamplesRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListExamplesRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Example()),
            ];
            client.descriptors.page.listExamples.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IExample[] = [];
            const iterable = client.listExamplesAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listExamples.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listExamples.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listExamples with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListExamplesRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListExamplesRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listExamples.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listExamplesAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IExample[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listExamples.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listExamples.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listTools', () => {
        it('invokes listTools without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
            ];
            client.innerApiCalls.listTools = stubSimpleCall(expectedResponse);
            const [response] = await client.listTools(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listTools as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listTools as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listTools without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
            ];
            client.innerApiCalls.listTools = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listTools(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.ITool[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listTools as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listTools as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listTools with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listTools = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listTools(request), expectedError);
            const actualRequest = (client.innerApiCalls.listTools as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listTools as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listToolsStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
            ];
            client.descriptors.page.listTools.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listToolsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Tool[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Tool) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listTools.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listTools, request));
            assert(
                (client.descriptors.page.listTools.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listToolsStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listTools.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listToolsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Tool[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Tool) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listTools.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listTools, request));
            assert(
                (client.descriptors.page.listTools.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listTools without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Tool()),
            ];
            client.descriptors.page.listTools.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.ITool[] = [];
            const iterable = client.listToolsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listTools.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listTools.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listTools with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listTools.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listToolsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.ITool[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listTools.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listTools.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listConversations', () => {
        it('invokes listConversations without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
            ];
            client.innerApiCalls.listConversations = stubSimpleCall(expectedResponse);
            const [response] = await client.listConversations(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listConversations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listConversations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listConversations without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
            ];
            client.innerApiCalls.listConversations = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listConversations(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IConversation[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listConversations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listConversations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listConversations with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listConversations = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listConversations(request), expectedError);
            const actualRequest = (client.innerApiCalls.listConversations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listConversations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listConversationsStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
            ];
            client.descriptors.page.listConversations.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listConversationsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Conversation[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Conversation) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listConversations.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listConversations, request));
            assert(
                (client.descriptors.page.listConversations.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listConversationsStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listConversations.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listConversationsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Conversation[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Conversation) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listConversations.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listConversations, request));
            assert(
                (client.descriptors.page.listConversations.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listConversations without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Conversation()),
            ];
            client.descriptors.page.listConversations.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IConversation[] = [];
            const iterable = client.listConversationsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listConversations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listConversations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listConversations with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListConversationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListConversationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listConversations.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listConversationsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IConversation[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listConversations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listConversations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listGuardrails', () => {
        it('invokes listGuardrails without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListGuardrailsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListGuardrailsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
            ];
            client.innerApiCalls.listGuardrails = stubSimpleCall(expectedResponse);
            const [response] = await client.listGuardrails(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listGuardrails as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listGuardrails as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listGuardrails without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListGuardrailsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListGuardrailsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
            ];
            client.innerApiCalls.listGuardrails = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listGuardrails(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IGuardrail[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listGuardrails as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listGuardrails as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listGuardrails with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListGuardrailsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListGuardrailsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listGuardrails = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listGuardrails(request), expectedError);
            const actualRequest = (client.innerApiCalls.listGuardrails as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listGuardrails as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listGuardrailsStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListGuardrailsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListGuardrailsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
            ];
            client.descriptors.page.listGuardrails.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listGuardrailsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Guardrail[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Guardrail) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listGuardrails.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listGuardrails, request));
            assert(
                (client.descriptors.page.listGuardrails.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listGuardrailsStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListGuardrailsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListGuardrailsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listGuardrails.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listGuardrailsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Guardrail[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Guardrail) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listGuardrails.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listGuardrails, request));
            assert(
                (client.descriptors.page.listGuardrails.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listGuardrails without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListGuardrailsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListGuardrailsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Guardrail()),
            ];
            client.descriptors.page.listGuardrails.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IGuardrail[] = [];
            const iterable = client.listGuardrailsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listGuardrails.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listGuardrails.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listGuardrails with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListGuardrailsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListGuardrailsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listGuardrails.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listGuardrailsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IGuardrail[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listGuardrails.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listGuardrails.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listDeployments', () => {
        it('invokes listDeployments without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListDeploymentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListDeploymentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
            ];
            client.innerApiCalls.listDeployments = stubSimpleCall(expectedResponse);
            const [response] = await client.listDeployments(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listDeployments as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listDeployments as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listDeployments without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListDeploymentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListDeploymentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
            ];
            client.innerApiCalls.listDeployments = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listDeployments(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IDeployment[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listDeployments as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listDeployments as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listDeployments with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListDeploymentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListDeploymentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listDeployments = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listDeployments(request), expectedError);
            const actualRequest = (client.innerApiCalls.listDeployments as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listDeployments as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listDeploymentsStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListDeploymentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListDeploymentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
            ];
            client.descriptors.page.listDeployments.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listDeploymentsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Deployment[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Deployment) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listDeployments.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listDeployments, request));
            assert(
                (client.descriptors.page.listDeployments.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listDeploymentsStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListDeploymentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListDeploymentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listDeployments.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listDeploymentsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Deployment[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Deployment) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listDeployments.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listDeployments, request));
            assert(
                (client.descriptors.page.listDeployments.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listDeployments without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListDeploymentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListDeploymentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Deployment()),
            ];
            client.descriptors.page.listDeployments.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IDeployment[] = [];
            const iterable = client.listDeploymentsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listDeployments.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listDeployments.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listDeployments with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListDeploymentsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListDeploymentsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listDeployments.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listDeploymentsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IDeployment[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listDeployments.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listDeployments.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listToolsets', () => {
        it('invokes listToolsets without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
            ];
            client.innerApiCalls.listToolsets = stubSimpleCall(expectedResponse);
            const [response] = await client.listToolsets(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listToolsets as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listToolsets as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listToolsets without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
            ];
            client.innerApiCalls.listToolsets = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listToolsets(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IToolset[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listToolsets as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listToolsets as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listToolsets with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listToolsets = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listToolsets(request), expectedError);
            const actualRequest = (client.innerApiCalls.listToolsets as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listToolsets as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listToolsetsStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
            ];
            client.descriptors.page.listToolsets.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listToolsetsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Toolset[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Toolset) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listToolsets.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listToolsets, request));
            assert(
                (client.descriptors.page.listToolsets.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listToolsetsStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listToolsets.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listToolsetsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Toolset[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Toolset) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listToolsets.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listToolsets, request));
            assert(
                (client.descriptors.page.listToolsets.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listToolsets without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Toolset()),
            ];
            client.descriptors.page.listToolsets.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IToolset[] = [];
            const iterable = client.listToolsetsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listToolsets.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listToolsets.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listToolsets with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListToolsetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListToolsetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listToolsets.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listToolsetsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IToolset[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listToolsets.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listToolsets.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listAppVersions', () => {
        it('invokes listAppVersions without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppVersionsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppVersionsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
            ];
            client.innerApiCalls.listAppVersions = stubSimpleCall(expectedResponse);
            const [response] = await client.listAppVersions(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listAppVersions as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listAppVersions as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listAppVersions without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppVersionsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppVersionsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
            ];
            client.innerApiCalls.listAppVersions = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listAppVersions(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IAppVersion[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listAppVersions as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listAppVersions as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listAppVersions with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppVersionsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppVersionsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listAppVersions = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listAppVersions(request), expectedError);
            const actualRequest = (client.innerApiCalls.listAppVersions as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listAppVersions as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listAppVersionsStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppVersionsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppVersionsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
            ];
            client.descriptors.page.listAppVersions.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listAppVersionsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.AppVersion[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.AppVersion) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listAppVersions.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listAppVersions, request));
            assert(
                (client.descriptors.page.listAppVersions.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listAppVersionsStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppVersionsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppVersionsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listAppVersions.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listAppVersionsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.AppVersion[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.AppVersion) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listAppVersions.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listAppVersions, request));
            assert(
                (client.descriptors.page.listAppVersions.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listAppVersions without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppVersionsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppVersionsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.AppVersion()),
            ];
            client.descriptors.page.listAppVersions.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IAppVersion[] = [];
            const iterable = client.listAppVersionsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listAppVersions.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listAppVersions.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listAppVersions with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListAppVersionsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListAppVersionsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listAppVersions.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listAppVersionsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IAppVersion[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listAppVersions.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listAppVersions.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listChangelogs', () => {
        it('invokes listChangelogs without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListChangelogsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListChangelogsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
            ];
            client.innerApiCalls.listChangelogs = stubSimpleCall(expectedResponse);
            const [response] = await client.listChangelogs(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listChangelogs as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listChangelogs as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listChangelogs without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListChangelogsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListChangelogsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
            ];
            client.innerApiCalls.listChangelogs = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listChangelogs(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IChangelog[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listChangelogs as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listChangelogs as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listChangelogs with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListChangelogsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListChangelogsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listChangelogs = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listChangelogs(request), expectedError);
            const actualRequest = (client.innerApiCalls.listChangelogs as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listChangelogs as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listChangelogsStream without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListChangelogsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListChangelogsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
            ];
            client.descriptors.page.listChangelogs.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listChangelogsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Changelog[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Changelog) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listChangelogs.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listChangelogs, request));
            assert(
                (client.descriptors.page.listChangelogs.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listChangelogsStream with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListChangelogsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListChangelogsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listChangelogs.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listChangelogsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Changelog[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Changelog) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listChangelogs.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listChangelogs, request));
            assert(
                (client.descriptors.page.listChangelogs.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listChangelogs without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListChangelogsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListChangelogsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Changelog()),
            ];
            client.descriptors.page.listChangelogs.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IChangelog[] = [];
            const iterable = client.listChangelogsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listChangelogs.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listChangelogs.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listChangelogs with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListChangelogsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListChangelogsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listChangelogs.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listChangelogsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IChangelog[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listChangelogs.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listChangelogs.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });
    describe('getLocation', () => {
        it('invokes getLocation without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.GetLocationRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedOptions = {
                otherArgs: {
                    headers: {
                        'x-goog-request-params': expectedHeaderRequestParams,
                    },
                },
            };
            const expectedResponse = generateSampleMessage(
              new LocationProtos.google.cloud.location.Location()
            );
            client.locationsClient.getLocation = stubSimpleCall(expectedResponse);
            const response = await client.getLocation(request, expectedOptions);
            assert.deepStrictEqual(response, [expectedResponse]);
            assert((client.locationsClient.getLocation as SinonStub)
                .getCall(0).calledWith(request, expectedOptions, undefined));
        });
        it('invokes getLocation without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.GetLocationRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedOptions = {
                otherArgs: {
                    headers: {
                        'x-goog-request-params': expectedHeaderRequestParams,
                    },
                },
            };
            const expectedResponse = generateSampleMessage(
              new LocationProtos.google.cloud.location.Location()
            );
            client.locationsClient.getLocation = sinon.stub().callsArgWith(2, null, expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getLocation(
                    request,
                    expectedOptions,
                    (
                        err?: Error | null,
                        result?: LocationProtos.google.cloud.location.ILocation | null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            assert((client.locationsClient.getLocation as SinonStub)
                .getCall(0));
        });
        it('invokes getLocation with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.GetLocationRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedOptions = {
                otherArgs: {
                    headers: {
                        'x-goog-request-params': expectedHeaderRequestParams,
                    },
                },
            };
            const expectedError = new Error('expected');
            client.locationsClient.getLocation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getLocation(request, expectedOptions), expectedError);
            assert((client.locationsClient.getLocation as SinonStub)
                .getCall(0).calledWith(request, expectedOptions, undefined));
        });
    });
    describe('listLocationsAsync', () => {
        it('uses async iteration with listLocations without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
                new LocationProtos.google.cloud.location.ListLocationsRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedResponse = [
                generateSampleMessage(
                    new LocationProtos.google.cloud.location.Location()
                ),
                generateSampleMessage(
                    new LocationProtos.google.cloud.location.Location()
                ),
                generateSampleMessage(
                    new LocationProtos.google.cloud.location.Location()
                ),
            ];
            client.locationsClient.descriptors.page.listLocations.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: LocationProtos.google.cloud.location.ILocation[] = [];
            const iterable = client.listLocationsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
        it('uses async iteration with listLocations with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.ListLocationsRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedError = new Error('expected');
            client.locationsClient.descriptors.page.listLocations.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listLocationsAsync(request);
            await assert.rejects(async () => {
                const responses: LocationProtos.google.cloud.location.ILocation[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });
    describe('getOperation', () => {
        it('invokes getOperation without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.GetOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new operationsProtos.google.longrunning.Operation()
            );
            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const response = await client.getOperation(request);
            assert.deepStrictEqual(response, [expectedResponse]);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0).calledWith(request)
            );
        });
        it('invokes getOperation without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.GetOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new operationsProtos.google.longrunning.Operation()
            );
            client.operationsClient.getOperation = sinon.stub().callsArgWith(2, null, expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.operationsClient.getOperation(
                    request,
                    undefined,
                    (
                        err?: Error | null,
                        result?: operationsProtos.google.longrunning.Operation | null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    }).catch(err => {throw err});
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
        it('invokes getOperation with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.GetOperationRequest()
            );
            const expectedError = new Error('expected');
            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(async () => {await client.getOperation(request)}, expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0).calledWith(request));
        });
    });
    describe('cancelOperation', () => {
        it('invokes cancelOperation without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.CancelOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new protos.google.protobuf.Empty()
            );
            client.operationsClient.cancelOperation = stubSimpleCall(expectedResponse);
            const response = await client.cancelOperation(request);
            assert.deepStrictEqual(response, [expectedResponse]);
            assert((client.operationsClient.cancelOperation as SinonStub)
                .getCall(0).calledWith(request)
            );
        });
        it('invokes cancelOperation without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.CancelOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new protos.google.protobuf.Empty()
            );
            client.operationsClient.cancelOperation = sinon.stub().callsArgWith(2, null, expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.operationsClient.cancelOperation(
                    request,
                    undefined,
                    (
                        err?: Error | null,
                        result?: protos.google.protobuf.Empty | null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    }).catch(err => {throw err});
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            assert((client.operationsClient.cancelOperation as SinonStub)
                .getCall(0));
        });
        it('invokes cancelOperation with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.CancelOperationRequest()
            );
            const expectedError = new Error('expected');
            client.operationsClient.cancelOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(async () => {await client.cancelOperation(request)}, expectedError);
            assert((client.operationsClient.cancelOperation as SinonStub)
                .getCall(0).calledWith(request));
        });
    });
    describe('deleteOperation', () => {
        it('invokes deleteOperation without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.DeleteOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new protos.google.protobuf.Empty()
            );
            client.operationsClient.deleteOperation = stubSimpleCall(expectedResponse);
            const response = await client.deleteOperation(request);
            assert.deepStrictEqual(response, [expectedResponse]);
            assert((client.operationsClient.deleteOperation as SinonStub)
                .getCall(0).calledWith(request)
            );
        });
        it('invokes deleteOperation without error using callback', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.DeleteOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new protos.google.protobuf.Empty()
            );
            client.operationsClient.deleteOperation = sinon.stub().callsArgWith(2, null, expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.operationsClient.deleteOperation(
                    request,
                    undefined,
                    (
                        err?: Error | null,
                        result?: protos.google.protobuf.Empty | null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    }).catch(err => {throw err});
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            assert((client.operationsClient.deleteOperation as SinonStub)
                .getCall(0));
        });
        it('invokes deleteOperation with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.DeleteOperationRequest()
            );
            const expectedError = new Error('expected');
            client.operationsClient.deleteOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(async () => {await client.deleteOperation(request)}, expectedError);
            assert((client.operationsClient.deleteOperation as SinonStub)
                .getCall(0).calledWith(request));
        });
    });
    describe('listOperationsAsync', () => {
        it('uses async iteration with listOperations without error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.ListOperationsRequest()
            );
            const expectedResponse = [
                generateSampleMessage(
                    new operationsProtos.google.longrunning.ListOperationsResponse()
                ),
                generateSampleMessage(
                    new operationsProtos.google.longrunning.ListOperationsResponse()
                ),
                generateSampleMessage(
                    new operationsProtos.google.longrunning.ListOperationsResponse()
                ),
            ];
            client.operationsClient.descriptor.listOperations.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: operationsProtos.google.longrunning.IOperation[] = [];
            const iterable = client.operationsClient.listOperationsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.operationsClient.descriptor.listOperations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
        });
        it('uses async iteration with listOperations with error', async () => {
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.ListOperationsRequest()
            );
            const expectedError = new Error('expected');
            client.operationsClient.descriptor.listOperations.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.operationsClient.listOperationsAsync(request);
            await assert.rejects(async () => {
                const responses: operationsProtos.google.longrunning.IOperation[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.operationsClient.descriptor.listOperations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
        });
    });

    describe('Path templates', () => {

        describe('agent', async () => {
            const fakePath = "/rendered/path/agent";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                agent: "agentValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.agentPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.agentPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('agentPath', () => {
                const result = client.agentPath("projectValue", "locationValue", "appValue", "agentValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.agentPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromAgentName', () => {
                const result = client.matchProjectFromAgentName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromAgentName', () => {
                const result = client.matchLocationFromAgentName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromAgentName', () => {
                const result = client.matchAppFromAgentName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAgentFromAgentName', () => {
                const result = client.matchAgentFromAgentName(fakePath);
                assert.strictEqual(result, "agentValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('app', async () => {
            const fakePath = "/rendered/path/app";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.appPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.appPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('appPath', () => {
                const result = client.appPath("projectValue", "locationValue", "appValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.appPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromAppName', () => {
                const result = client.matchProjectFromAppName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.appPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromAppName', () => {
                const result = client.matchLocationFromAppName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.appPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromAppName', () => {
                const result = client.matchAppFromAppName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.appPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('appVersion', async () => {
            const fakePath = "/rendered/path/appVersion";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                version: "versionValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.appVersionPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.appVersionPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('appVersionPath', () => {
                const result = client.appVersionPath("projectValue", "locationValue", "appValue", "versionValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.appVersionPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromAppVersionName', () => {
                const result = client.matchProjectFromAppVersionName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromAppVersionName', () => {
                const result = client.matchLocationFromAppVersionName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromAppVersionName', () => {
                const result = client.matchAppFromAppVersionName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchVersionFromAppVersionName', () => {
                const result = client.matchVersionFromAppVersionName(fakePath);
                assert.strictEqual(result, "versionValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('changelog', async () => {
            const fakePath = "/rendered/path/changelog";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                changelog: "changelogValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.changelogPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.changelogPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('changelogPath', () => {
                const result = client.changelogPath("projectValue", "locationValue", "appValue", "changelogValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.changelogPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromChangelogName', () => {
                const result = client.matchProjectFromChangelogName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromChangelogName', () => {
                const result = client.matchLocationFromChangelogName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromChangelogName', () => {
                const result = client.matchAppFromChangelogName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchChangelogFromChangelogName', () => {
                const result = client.matchChangelogFromChangelogName(fakePath);
                assert.strictEqual(result, "changelogValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('conversation', async () => {
            const fakePath = "/rendered/path/conversation";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                conversation: "conversationValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.conversationPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.conversationPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('conversationPath', () => {
                const result = client.conversationPath("projectValue", "locationValue", "appValue", "conversationValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.conversationPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromConversationName', () => {
                const result = client.matchProjectFromConversationName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromConversationName', () => {
                const result = client.matchLocationFromConversationName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromConversationName', () => {
                const result = client.matchAppFromConversationName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchConversationFromConversationName', () => {
                const result = client.matchConversationFromConversationName(fakePath);
                assert.strictEqual(result, "conversationValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('deployment', async () => {
            const fakePath = "/rendered/path/deployment";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                deployment: "deploymentValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.deploymentPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.deploymentPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('deploymentPath', () => {
                const result = client.deploymentPath("projectValue", "locationValue", "appValue", "deploymentValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.deploymentPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromDeploymentName', () => {
                const result = client.matchProjectFromDeploymentName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromDeploymentName', () => {
                const result = client.matchLocationFromDeploymentName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromDeploymentName', () => {
                const result = client.matchAppFromDeploymentName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchDeploymentFromDeploymentName', () => {
                const result = client.matchDeploymentFromDeploymentName(fakePath);
                assert.strictEqual(result, "deploymentValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluation', async () => {
            const fakePath = "/rendered/path/evaluation";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation: "evaluationValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationPath', () => {
                const result = client.evaluationPath("projectValue", "locationValue", "appValue", "evaluationValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationName', () => {
                const result = client.matchProjectFromEvaluationName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationName', () => {
                const result = client.matchLocationFromEvaluationName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationName', () => {
                const result = client.matchAppFromEvaluationName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationFromEvaluationName', () => {
                const result = client.matchEvaluationFromEvaluationName(fakePath);
                assert.strictEqual(result, "evaluationValue");
                assert((client.pathTemplates.evaluationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluationDataset', async () => {
            const fakePath = "/rendered/path/evaluationDataset";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation_dataset: "evaluationDatasetValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationDatasetPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationDatasetPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationDatasetPath', () => {
                const result = client.evaluationDatasetPath("projectValue", "locationValue", "appValue", "evaluationDatasetValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationDatasetPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationDatasetName', () => {
                const result = client.matchProjectFromEvaluationDatasetName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationDatasetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationDatasetName', () => {
                const result = client.matchLocationFromEvaluationDatasetName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationDatasetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationDatasetName', () => {
                const result = client.matchAppFromEvaluationDatasetName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationDatasetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationDatasetFromEvaluationDatasetName', () => {
                const result = client.matchEvaluationDatasetFromEvaluationDatasetName(fakePath);
                assert.strictEqual(result, "evaluationDatasetValue");
                assert((client.pathTemplates.evaluationDatasetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluationExpectation', async () => {
            const fakePath = "/rendered/path/evaluationExpectation";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation_expectation: "evaluationExpectationValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationExpectationPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationExpectationPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationExpectationPath', () => {
                const result = client.evaluationExpectationPath("projectValue", "locationValue", "appValue", "evaluationExpectationValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationExpectationPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationExpectationName', () => {
                const result = client.matchProjectFromEvaluationExpectationName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationExpectationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationExpectationName', () => {
                const result = client.matchLocationFromEvaluationExpectationName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationExpectationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationExpectationName', () => {
                const result = client.matchAppFromEvaluationExpectationName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationExpectationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationExpectationFromEvaluationExpectationName', () => {
                const result = client.matchEvaluationExpectationFromEvaluationExpectationName(fakePath);
                assert.strictEqual(result, "evaluationExpectationValue");
                assert((client.pathTemplates.evaluationExpectationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluationResult', async () => {
            const fakePath = "/rendered/path/evaluationResult";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation: "evaluationValue",
                evaluation_result: "evaluationResultValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationResultPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationResultPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationResultPath', () => {
                const result = client.evaluationResultPath("projectValue", "locationValue", "appValue", "evaluationValue", "evaluationResultValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationResultPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationResultName', () => {
                const result = client.matchProjectFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationResultName', () => {
                const result = client.matchLocationFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationResultName', () => {
                const result = client.matchAppFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationFromEvaluationResultName', () => {
                const result = client.matchEvaluationFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "evaluationValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationResultFromEvaluationResultName', () => {
                const result = client.matchEvaluationResultFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "evaluationResultValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluationRun', async () => {
            const fakePath = "/rendered/path/evaluationRun";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation_run: "evaluationRunValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationRunPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationRunPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationRunPath', () => {
                const result = client.evaluationRunPath("projectValue", "locationValue", "appValue", "evaluationRunValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationRunPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationRunName', () => {
                const result = client.matchProjectFromEvaluationRunName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationRunName', () => {
                const result = client.matchLocationFromEvaluationRunName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationRunName', () => {
                const result = client.matchAppFromEvaluationRunName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationRunFromEvaluationRunName', () => {
                const result = client.matchEvaluationRunFromEvaluationRunName(fakePath);
                assert.strictEqual(result, "evaluationRunValue");
                assert((client.pathTemplates.evaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('example', async () => {
            const fakePath = "/rendered/path/example";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                example: "exampleValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.examplePathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.examplePathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('examplePath', () => {
                const result = client.examplePath("projectValue", "locationValue", "appValue", "exampleValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.examplePathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromExampleName', () => {
                const result = client.matchProjectFromExampleName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromExampleName', () => {
                const result = client.matchLocationFromExampleName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromExampleName', () => {
                const result = client.matchAppFromExampleName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchExampleFromExampleName', () => {
                const result = client.matchExampleFromExampleName(fakePath);
                assert.strictEqual(result, "exampleValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('guardrail', async () => {
            const fakePath = "/rendered/path/guardrail";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                guardrail: "guardrailValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.guardrailPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.guardrailPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('guardrailPath', () => {
                const result = client.guardrailPath("projectValue", "locationValue", "appValue", "guardrailValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.guardrailPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromGuardrailName', () => {
                const result = client.matchProjectFromGuardrailName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromGuardrailName', () => {
                const result = client.matchLocationFromGuardrailName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromGuardrailName', () => {
                const result = client.matchAppFromGuardrailName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchGuardrailFromGuardrailName', () => {
                const result = client.matchGuardrailFromGuardrailName(fakePath);
                assert.strictEqual(result, "guardrailValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('location', async () => {
            const fakePath = "/rendered/path/location";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.locationPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.locationPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('locationPath', () => {
                const result = client.locationPath("projectValue", "locationValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.locationPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromLocationName', () => {
                const result = client.matchProjectFromLocationName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.locationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromLocationName', () => {
                const result = client.matchLocationFromLocationName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.locationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('omnichannel', async () => {
            const fakePath = "/rendered/path/omnichannel";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                omnichannel: "omnichannelValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.omnichannelPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.omnichannelPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('omnichannelPath', () => {
                const result = client.omnichannelPath("projectValue", "locationValue", "omnichannelValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.omnichannelPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromOmnichannelName', () => {
                const result = client.matchProjectFromOmnichannelName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.omnichannelPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromOmnichannelName', () => {
                const result = client.matchLocationFromOmnichannelName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.omnichannelPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchOmnichannelFromOmnichannelName', () => {
                const result = client.matchOmnichannelFromOmnichannelName(fakePath);
                assert.strictEqual(result, "omnichannelValue");
                assert((client.pathTemplates.omnichannelPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('project', async () => {
            const fakePath = "/rendered/path/project";
            const expectedParameters = {
                project: "projectValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.projectPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.projectPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('projectPath', () => {
                const result = client.projectPath("projectValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.projectPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromProjectName', () => {
                const result = client.matchProjectFromProjectName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.projectPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('scheduledEvaluationRun', async () => {
            const fakePath = "/rendered/path/scheduledEvaluationRun";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                scheduled_evaluation_run: "scheduledEvaluationRunValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.scheduledEvaluationRunPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.scheduledEvaluationRunPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('scheduledEvaluationRunPath', () => {
                const result = client.scheduledEvaluationRunPath("projectValue", "locationValue", "appValue", "scheduledEvaluationRunValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromScheduledEvaluationRunName', () => {
                const result = client.matchProjectFromScheduledEvaluationRunName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromScheduledEvaluationRunName', () => {
                const result = client.matchLocationFromScheduledEvaluationRunName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromScheduledEvaluationRunName', () => {
                const result = client.matchAppFromScheduledEvaluationRunName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchScheduledEvaluationRunFromScheduledEvaluationRunName', () => {
                const result = client.matchScheduledEvaluationRunFromScheduledEvaluationRunName(fakePath);
                assert.strictEqual(result, "scheduledEvaluationRunValue");
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('tool', async () => {
            const fakePath = "/rendered/path/tool";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                tool: "toolValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.toolPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.toolPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('toolPath', () => {
                const result = client.toolPath("projectValue", "locationValue", "appValue", "toolValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.toolPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromToolName', () => {
                const result = client.matchProjectFromToolName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromToolName', () => {
                const result = client.matchLocationFromToolName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromToolName', () => {
                const result = client.matchAppFromToolName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchToolFromToolName', () => {
                const result = client.matchToolFromToolName(fakePath);
                assert.strictEqual(result, "toolValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('toolset', async () => {
            const fakePath = "/rendered/path/toolset";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                toolset: "toolsetValue",
            };
            const client = new agentserviceModule.v1beta.AgentServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.toolsetPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.toolsetPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('toolsetPath', () => {
                const result = client.toolsetPath("projectValue", "locationValue", "appValue", "toolsetValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.toolsetPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromToolsetName', () => {
                const result = client.matchProjectFromToolsetName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromToolsetName', () => {
                const result = client.matchLocationFromToolsetName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromToolsetName', () => {
                const result = client.matchAppFromToolsetName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchToolsetFromToolsetName', () => {
                const result = client.matchToolsetFromToolsetName(fakePath);
                assert.strictEqual(result, "toolsetValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });
    });
});
