// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

import * as protos from '../protos/protos';
import * as assert from 'assert';
import * as sinon from 'sinon';
import {SinonStub} from 'sinon';
import {describe, it} from 'mocha';
import * as evaluationserviceModule from '../src';

import {PassThrough} from 'stream';

import {protobuf, LROperation, operationsProtos, LocationProtos} from 'google-gax';

// Dynamically loaded proto JSON is needed to get the type information
// to fill in default values for request objects
const root = protobuf.Root.fromJSON(require('../protos/protos.json')).resolveAll();

// eslint-disable-next-line @typescript-eslint/no-unused-vars
function getTypeDefaultValue(typeName: string, fields: string[]) {
    let type = root.lookupType(typeName) as protobuf.Type;
    for (const field of fields.slice(0, -1)) {
        type = type.fields[field]?.resolvedType as protobuf.Type;
    }
    return type.fields[fields[fields.length - 1]]?.defaultValue;
}

function generateSampleMessage<T extends object>(instance: T) {
    const filledObject = (instance.constructor as typeof protobuf.Message)
        .toObject(instance as protobuf.Message<T>, {defaults: true});
    return (instance.constructor as typeof protobuf.Message).fromObject(filledObject) as T;
}

function stubSimpleCall<ResponseType>(response?: ResponseType, error?: Error) {
    return error ? sinon.stub().rejects(error) : sinon.stub().resolves([response]);
}

function stubSimpleCallWithCallback<ResponseType>(response?: ResponseType, error?: Error) {
    return error ? sinon.stub().callsArgWith(2, error) : sinon.stub().callsArgWith(2, null, response);
}

function stubLongRunningCall<ResponseType>(response?: ResponseType, callError?: Error, lroError?: Error) {
    const innerStub = lroError ? sinon.stub().rejects(lroError) : sinon.stub().resolves([response]);
    const mockOperation = {
        promise: innerStub,
    };
    return callError ? sinon.stub().rejects(callError) : sinon.stub().resolves([mockOperation]);
}

function stubLongRunningCallWithCallback<ResponseType>(response?: ResponseType, callError?: Error, lroError?: Error) {
    const innerStub = lroError ? sinon.stub().rejects(lroError) : sinon.stub().resolves([response]);
    const mockOperation = {
        promise: innerStub,
    };
    return callError ? sinon.stub().callsArgWith(2, callError) : sinon.stub().callsArgWith(2, null, mockOperation);
}

function stubPageStreamingCall<ResponseType>(responses?: ResponseType[], error?: Error) {
    const pagingStub = sinon.stub();
    if (responses) {
        for (let i = 0; i < responses.length; ++i) {
            pagingStub.onCall(i).callsArgWith(2, null, responses[i]);
        }
    }
    const transformStub = error ? sinon.stub().callsArgWith(2, error) : pagingStub;
    const mockStream = new PassThrough({
        objectMode: true,
        transform: transformStub,
    });
    // trigger as many responses as needed
    if (responses) {
        for (let i = 0; i < responses.length; ++i) {
            setImmediate(() => { mockStream.write({}); });
        }
        setImmediate(() => { mockStream.end(); });
    } else {
        setImmediate(() => { mockStream.write({}); });
        setImmediate(() => { mockStream.end(); });
    }
    return sinon.stub().returns(mockStream);
}

function stubAsyncIterationCall<ResponseType>(responses?: ResponseType[], error?: Error) {
    let counter = 0;
    const asyncIterable = {
        [Symbol.asyncIterator]() {
            return {
                async next() {
                    if (error) {
                        return Promise.reject(error);
                    }
                    if (counter >= responses!.length) {
                        return Promise.resolve({done: true, value: undefined});
                    }
                    return Promise.resolve({done: false, value: responses![counter++]});
                }
            };
        }
    };
    return sinon.stub().returns(asyncIterable);
}

describe('v1beta.EvaluationServiceClient', () => {
    describe('Common methods', () => {
        it('has apiEndpoint', () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient();
            const apiEndpoint = client.apiEndpoint;
            assert.strictEqual(apiEndpoint, 'ces.googleapis.com');
        });

        it('has universeDomain', () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient();
            const universeDomain = client.universeDomain;
            assert.strictEqual(universeDomain, "googleapis.com");
        });

        if (typeof process === 'object' && typeof process.emitWarning === 'function') {
            it('throws DeprecationWarning if static servicePath is used', () => {
                const stub = sinon.stub(process, 'emitWarning');
                const servicePath = evaluationserviceModule.v1beta.EvaluationServiceClient.servicePath;
                assert.strictEqual(servicePath, 'ces.googleapis.com');
                assert(stub.called);
                stub.restore();
            });

            it('throws DeprecationWarning if static apiEndpoint is used', () => {
                const stub = sinon.stub(process, 'emitWarning');
                const apiEndpoint = evaluationserviceModule.v1beta.EvaluationServiceClient.apiEndpoint;
                assert.strictEqual(apiEndpoint, 'ces.googleapis.com');
                assert(stub.called);
                stub.restore();
            });
        }
        it('sets apiEndpoint according to universe domain camelCase', () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({universeDomain: 'example.com'});
            const servicePath = client.apiEndpoint;
            assert.strictEqual(servicePath, 'ces.example.com');
        });

        it('sets apiEndpoint according to universe domain snakeCase', () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({universe_domain: 'example.com'});
            const servicePath = client.apiEndpoint;
            assert.strictEqual(servicePath, 'ces.example.com');
        });

        if (typeof process === 'object' && 'env' in process) {
            describe('GOOGLE_CLOUD_UNIVERSE_DOMAIN environment variable', () => {
                it('sets apiEndpoint from environment variable', () => {
                    const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
                    const client = new evaluationserviceModule.v1beta.EvaluationServiceClient();
                    const servicePath = client.apiEndpoint;
                    assert.strictEqual(servicePath, 'ces.example.com');
                    if (saved) {
                        process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
                    } else {
                        delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    }
                });

                it('value configured in code has priority over environment variable', () => {
                    const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
                    const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({universeDomain: 'configured.example.com'});
                    const servicePath = client.apiEndpoint;
                    assert.strictEqual(servicePath, 'ces.configured.example.com');
                    if (saved) {
                        process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
                    } else {
                        delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
                    }
                });
            });
        }
        it('does not allow setting both universeDomain and universe_domain', () => {
            assert.throws(() => { new evaluationserviceModule.v1beta.EvaluationServiceClient({universe_domain: 'example.com', universeDomain: 'example.net'}); });
        });

        it('has port', () => {
            const port = evaluationserviceModule.v1beta.EvaluationServiceClient.port;
            assert(port);
            assert(typeof port === 'number');
        });

        it('should create a client with no option', () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient();
            assert(client);
        });

        it('should create a client with gRPC fallback', () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                fallback: true,
            });
            assert(client);
        });

        it('has initialize method and supports deferred initialization', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            assert.strictEqual(client.evaluationServiceStub, undefined);
            await client.initialize();
            assert(client.evaluationServiceStub);
        });

        it('has close method for the initialized client', done => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            client.initialize().catch(err => {throw err});
            assert(client.evaluationServiceStub);
            client.close().then(() => {
                done();
            }).catch(err => {throw err});
        });

        it('has close method for the non-initialized client', done => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            assert.strictEqual(client.evaluationServiceStub, undefined);
            client.close().then(() => {
                done();
            }).catch(err => {throw err});
        });

        it('has getProjectId method', async () => {
            const fakeProjectId = 'fake-project-id';
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            client.auth.getProjectId = sinon.stub().resolves(fakeProjectId);
            const result = await client.getProjectId();
            assert.strictEqual(result, fakeProjectId);
            assert((client.auth.getProjectId as SinonStub).calledWithExactly());
        });

        it('has getProjectId method with callback', async () => {
            const fakeProjectId = 'fake-project-id';
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            client.auth.getProjectId = sinon.stub().callsArgWith(0, null, fakeProjectId);
            const promise = new Promise((resolve, reject) => {
                client.getProjectId((err?: Error|null, projectId?: string|null) => {
                    if (err) {
                        reject(err);
                    } else {
                        resolve(projectId);
                    }
                });
            });
            const result = await promise;
            assert.strictEqual(result, fakeProjectId);
        });
    });

    describe('createEvaluation', () => {
        it('invokes createEvaluation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Evaluation()
            );
            client.innerApiCalls.createEvaluation = stubSimpleCall(expectedResponse);
            const [response] = await client.createEvaluation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createEvaluation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Evaluation()
            );
            client.innerApiCalls.createEvaluation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createEvaluation(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluation|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createEvaluation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createEvaluation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createEvaluation(request), expectedError);
            const actualRequest = (client.innerApiCalls.createEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createEvaluation with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createEvaluation(request), expectedError);
        });
    });

    describe('createEvaluationDataset', () => {
        it('invokes createEvaluationDataset without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationDatasetRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationDataset()
            );
            client.innerApiCalls.createEvaluationDataset = stubSimpleCall(expectedResponse);
            const [response] = await client.createEvaluationDataset(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createEvaluationDataset without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationDatasetRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationDataset()
            );
            client.innerApiCalls.createEvaluationDataset = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createEvaluationDataset(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationDataset|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createEvaluationDataset with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationDatasetRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createEvaluationDataset = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createEvaluationDataset(request), expectedError);
            const actualRequest = (client.innerApiCalls.createEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createEvaluationDataset with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationDatasetRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createEvaluationDataset(request), expectedError);
        });
    });

    describe('updateEvaluation', () => {
        it('invokes updateEvaluation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationRequest()
            );
            request.evaluation ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationRequest', ['evaluation', 'name']);
            request.evaluation.name = defaultValue1;
            const expectedHeaderRequestParams = `evaluation.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Evaluation()
            );
            client.innerApiCalls.updateEvaluation = stubSimpleCall(expectedResponse);
            const [response] = await client.updateEvaluation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateEvaluation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationRequest()
            );
            request.evaluation ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationRequest', ['evaluation', 'name']);
            request.evaluation.name = defaultValue1;
            const expectedHeaderRequestParams = `evaluation.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Evaluation()
            );
            client.innerApiCalls.updateEvaluation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateEvaluation(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluation|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateEvaluation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationRequest()
            );
            request.evaluation ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationRequest', ['evaluation', 'name']);
            request.evaluation.name = defaultValue1;
            const expectedHeaderRequestParams = `evaluation.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateEvaluation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateEvaluation(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateEvaluation with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationRequest()
            );
            request.evaluation ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationRequest', ['evaluation', 'name']);
            request.evaluation.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateEvaluation(request), expectedError);
        });
    });

    describe('updateEvaluationDataset', () => {
        it('invokes updateEvaluationDataset without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationDatasetRequest()
            );
            request.evaluationDataset ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationDatasetRequest', ['evaluationDataset', 'name']);
            request.evaluationDataset.name = defaultValue1;
            const expectedHeaderRequestParams = `evaluation_dataset.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationDataset()
            );
            client.innerApiCalls.updateEvaluationDataset = stubSimpleCall(expectedResponse);
            const [response] = await client.updateEvaluationDataset(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateEvaluationDataset without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationDatasetRequest()
            );
            request.evaluationDataset ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationDatasetRequest', ['evaluationDataset', 'name']);
            request.evaluationDataset.name = defaultValue1;
            const expectedHeaderRequestParams = `evaluation_dataset.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationDataset()
            );
            client.innerApiCalls.updateEvaluationDataset = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateEvaluationDataset(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationDataset|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateEvaluationDataset with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationDatasetRequest()
            );
            request.evaluationDataset ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationDatasetRequest', ['evaluationDataset', 'name']);
            request.evaluationDataset.name = defaultValue1;
            const expectedHeaderRequestParams = `evaluation_dataset.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateEvaluationDataset = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateEvaluationDataset(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateEvaluationDataset with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationDatasetRequest()
            );
            request.evaluationDataset ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationDatasetRequest', ['evaluationDataset', 'name']);
            request.evaluationDataset.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateEvaluationDataset(request), expectedError);
        });
    });

    describe('deleteEvaluation', () => {
        it('invokes deleteEvaluation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteEvaluation = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteEvaluation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteEvaluation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteEvaluation(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteEvaluation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteEvaluation(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluation with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteEvaluation(request), expectedError);
        });
    });

    describe('deleteEvaluationResult', () => {
        it('invokes deleteEvaluationResult without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationResultRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationResultRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteEvaluationResult = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteEvaluationResult(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluationResult as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationResult as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationResult without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationResultRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationResultRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteEvaluationResult = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteEvaluationResult(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluationResult as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationResult as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationResult with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationResultRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationResultRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteEvaluationResult = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteEvaluationResult(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteEvaluationResult as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationResult as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationResult with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationResultRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationResultRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteEvaluationResult(request), expectedError);
        });
    });

    describe('deleteEvaluationDataset', () => {
        it('invokes deleteEvaluationDataset without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationDatasetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteEvaluationDataset = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteEvaluationDataset(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationDataset without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationDatasetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteEvaluationDataset = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteEvaluationDataset(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationDataset with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationDatasetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteEvaluationDataset = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteEvaluationDataset(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationDataset with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationDatasetRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteEvaluationDataset(request), expectedError);
        });
    });

    describe('getEvaluation', () => {
        it('invokes getEvaluation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Evaluation()
            );
            client.innerApiCalls.getEvaluation = stubSimpleCall(expectedResponse);
            const [response] = await client.getEvaluation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.Evaluation()
            );
            client.innerApiCalls.getEvaluation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getEvaluation(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluation|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getEvaluation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getEvaluation(request), expectedError);
            const actualRequest = (client.innerApiCalls.getEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluation with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getEvaluation(request), expectedError);
        });
    });

    describe('getEvaluationResult', () => {
        it('invokes getEvaluationResult without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationResultRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationResultRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationResult()
            );
            client.innerApiCalls.getEvaluationResult = stubSimpleCall(expectedResponse);
            const [response] = await client.getEvaluationResult(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluationResult as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationResult as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationResult without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationResultRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationResultRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationResult()
            );
            client.innerApiCalls.getEvaluationResult = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getEvaluationResult(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationResult|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluationResult as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationResult as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationResult with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationResultRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationResultRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getEvaluationResult = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getEvaluationResult(request), expectedError);
            const actualRequest = (client.innerApiCalls.getEvaluationResult as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationResult as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationResult with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationResultRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationResultRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getEvaluationResult(request), expectedError);
        });
    });

    describe('getEvaluationDataset', () => {
        it('invokes getEvaluationDataset without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationDatasetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationDataset()
            );
            client.innerApiCalls.getEvaluationDataset = stubSimpleCall(expectedResponse);
            const [response] = await client.getEvaluationDataset(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationDataset without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationDatasetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationDataset()
            );
            client.innerApiCalls.getEvaluationDataset = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getEvaluationDataset(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationDataset|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationDataset with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationDatasetRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getEvaluationDataset = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getEvaluationDataset(request), expectedError);
            const actualRequest = (client.innerApiCalls.getEvaluationDataset as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationDataset as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationDataset with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationDatasetRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationDatasetRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getEvaluationDataset(request), expectedError);
        });
    });

    describe('getEvaluationRun', () => {
        it('invokes getEvaluationRun without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationRun()
            );
            client.innerApiCalls.getEvaluationRun = stubSimpleCall(expectedResponse);
            const [response] = await client.getEvaluationRun(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationRun without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationRun()
            );
            client.innerApiCalls.getEvaluationRun = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getEvaluationRun(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationRun|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationRun with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getEvaluationRun = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getEvaluationRun(request), expectedError);
            const actualRequest = (client.innerApiCalls.getEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationRun with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getEvaluationRun(request), expectedError);
        });
    });

    describe('getEvaluationExpectation', () => {
        it('invokes getEvaluationExpectation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationExpectationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationExpectation()
            );
            client.innerApiCalls.getEvaluationExpectation = stubSimpleCall(expectedResponse);
            const [response] = await client.getEvaluationExpectation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationExpectation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationExpectationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationExpectation()
            );
            client.innerApiCalls.getEvaluationExpectation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getEvaluationExpectation(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationExpectation|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationExpectation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationExpectationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getEvaluationExpectation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getEvaluationExpectation(request), expectedError);
            const actualRequest = (client.innerApiCalls.getEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getEvaluationExpectation with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetEvaluationExpectationRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getEvaluationExpectation(request), expectedError);
        });
    });

    describe('createEvaluationExpectation', () => {
        it('invokes createEvaluationExpectation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationExpectationRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationExpectation()
            );
            client.innerApiCalls.createEvaluationExpectation = stubSimpleCall(expectedResponse);
            const [response] = await client.createEvaluationExpectation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createEvaluationExpectation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationExpectationRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationExpectation()
            );
            client.innerApiCalls.createEvaluationExpectation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createEvaluationExpectation(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationExpectation|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createEvaluationExpectation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationExpectationRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createEvaluationExpectation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createEvaluationExpectation(request), expectedError);
            const actualRequest = (client.innerApiCalls.createEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createEvaluationExpectation with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateEvaluationExpectationRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createEvaluationExpectation(request), expectedError);
        });
    });

    describe('updateEvaluationExpectation', () => {
        it('invokes updateEvaluationExpectation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationExpectationRequest()
            );
            request.evaluationExpectation ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationExpectationRequest', ['evaluationExpectation', 'name']);
            request.evaluationExpectation.name = defaultValue1;
            const expectedHeaderRequestParams = `evaluation_expectation.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationExpectation()
            );
            client.innerApiCalls.updateEvaluationExpectation = stubSimpleCall(expectedResponse);
            const [response] = await client.updateEvaluationExpectation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateEvaluationExpectation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationExpectationRequest()
            );
            request.evaluationExpectation ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationExpectationRequest', ['evaluationExpectation', 'name']);
            request.evaluationExpectation.name = defaultValue1;
            const expectedHeaderRequestParams = `evaluation_expectation.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.EvaluationExpectation()
            );
            client.innerApiCalls.updateEvaluationExpectation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateEvaluationExpectation(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationExpectation|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateEvaluationExpectation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationExpectationRequest()
            );
            request.evaluationExpectation ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationExpectationRequest', ['evaluationExpectation', 'name']);
            request.evaluationExpectation.name = defaultValue1;
            const expectedHeaderRequestParams = `evaluation_expectation.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateEvaluationExpectation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateEvaluationExpectation(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateEvaluationExpectation with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateEvaluationExpectationRequest()
            );
            request.evaluationExpectation ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateEvaluationExpectationRequest', ['evaluationExpectation', 'name']);
            request.evaluationExpectation.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateEvaluationExpectation(request), expectedError);
        });
    });

    describe('deleteEvaluationExpectation', () => {
        it('invokes deleteEvaluationExpectation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationExpectationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteEvaluationExpectation = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteEvaluationExpectation(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationExpectation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationExpectationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteEvaluationExpectation = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteEvaluationExpectation(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationExpectation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationExpectationRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteEvaluationExpectation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteEvaluationExpectation(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteEvaluationExpectation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationExpectation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationExpectation with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationExpectationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationExpectationRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteEvaluationExpectation(request), expectedError);
        });
    });

    describe('createScheduledEvaluationRun', () => {
        it('invokes createScheduledEvaluationRun without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateScheduledEvaluationRunRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()
            );
            client.innerApiCalls.createScheduledEvaluationRun = stubSimpleCall(expectedResponse);
            const [response] = await client.createScheduledEvaluationRun(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createScheduledEvaluationRun without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateScheduledEvaluationRunRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()
            );
            client.innerApiCalls.createScheduledEvaluationRun = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.createScheduledEvaluationRun(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IScheduledEvaluationRun|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.createScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createScheduledEvaluationRun with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateScheduledEvaluationRunRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.createScheduledEvaluationRun = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.createScheduledEvaluationRun(request), expectedError);
            const actualRequest = (client.innerApiCalls.createScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.createScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes createScheduledEvaluationRun with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.CreateScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.CreateScheduledEvaluationRunRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.createScheduledEvaluationRun(request), expectedError);
        });
    });

    describe('getScheduledEvaluationRun', () => {
        it('invokes getScheduledEvaluationRun without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetScheduledEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()
            );
            client.innerApiCalls.getScheduledEvaluationRun = stubSimpleCall(expectedResponse);
            const [response] = await client.getScheduledEvaluationRun(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getScheduledEvaluationRun without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetScheduledEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()
            );
            client.innerApiCalls.getScheduledEvaluationRun = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getScheduledEvaluationRun(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IScheduledEvaluationRun|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.getScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getScheduledEvaluationRun with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetScheduledEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.getScheduledEvaluationRun = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getScheduledEvaluationRun(request), expectedError);
            const actualRequest = (client.innerApiCalls.getScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.getScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes getScheduledEvaluationRun with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GetScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GetScheduledEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.getScheduledEvaluationRun(request), expectedError);
        });
    });

    describe('updateScheduledEvaluationRun', () => {
        it('invokes updateScheduledEvaluationRun without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateScheduledEvaluationRunRequest()
            );
            request.scheduledEvaluationRun ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateScheduledEvaluationRunRequest', ['scheduledEvaluationRun', 'name']);
            request.scheduledEvaluationRun.name = defaultValue1;
            const expectedHeaderRequestParams = `scheduled_evaluation_run.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()
            );
            client.innerApiCalls.updateScheduledEvaluationRun = stubSimpleCall(expectedResponse);
            const [response] = await client.updateScheduledEvaluationRun(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateScheduledEvaluationRun without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateScheduledEvaluationRunRequest()
            );
            request.scheduledEvaluationRun ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateScheduledEvaluationRunRequest', ['scheduledEvaluationRun', 'name']);
            request.scheduledEvaluationRun.name = defaultValue1;
            const expectedHeaderRequestParams = `scheduled_evaluation_run.name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()
            );
            client.innerApiCalls.updateScheduledEvaluationRun = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.updateScheduledEvaluationRun(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IScheduledEvaluationRun|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.updateScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateScheduledEvaluationRun with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateScheduledEvaluationRunRequest()
            );
            request.scheduledEvaluationRun ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateScheduledEvaluationRunRequest', ['scheduledEvaluationRun', 'name']);
            request.scheduledEvaluationRun.name = defaultValue1;
            const expectedHeaderRequestParams = `scheduled_evaluation_run.name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.updateScheduledEvaluationRun = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.updateScheduledEvaluationRun(request), expectedError);
            const actualRequest = (client.innerApiCalls.updateScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.updateScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes updateScheduledEvaluationRun with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.UpdateScheduledEvaluationRunRequest()
            );
            request.scheduledEvaluationRun ??= {};
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.UpdateScheduledEvaluationRunRequest', ['scheduledEvaluationRun', 'name']);
            request.scheduledEvaluationRun.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.updateScheduledEvaluationRun(request), expectedError);
        });
    });

    describe('deleteScheduledEvaluationRun', () => {
        it('invokes deleteScheduledEvaluationRun without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteScheduledEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteScheduledEvaluationRun = stubSimpleCall(expectedResponse);
            const [response] = await client.deleteScheduledEvaluationRun(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteScheduledEvaluationRun without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteScheduledEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.protobuf.Empty()
            );
            client.innerApiCalls.deleteScheduledEvaluationRun = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteScheduledEvaluationRun(
                    request,
                    (err?: Error|null, result?: protos.google.protobuf.IEmpty|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteScheduledEvaluationRun with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteScheduledEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteScheduledEvaluationRun = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.deleteScheduledEvaluationRun(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteScheduledEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteScheduledEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteScheduledEvaluationRun with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteScheduledEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteScheduledEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.deleteScheduledEvaluationRun(request), expectedError);
        });
    });

    describe('testPersonaVoice', () => {
        it('invokes testPersonaVoice without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.TestPersonaVoiceRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.TestPersonaVoiceRequest', ['app']);
            request.app = defaultValue1;
            const expectedHeaderRequestParams = `app=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.TestPersonaVoiceResponse()
            );
            client.innerApiCalls.testPersonaVoice = stubSimpleCall(expectedResponse);
            const [response] = await client.testPersonaVoice(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.testPersonaVoice as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.testPersonaVoice as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes testPersonaVoice without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.TestPersonaVoiceRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.TestPersonaVoiceRequest', ['app']);
            request.app = defaultValue1;
            const expectedHeaderRequestParams = `app=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.TestPersonaVoiceResponse()
            );
            client.innerApiCalls.testPersonaVoice = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.testPersonaVoice(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.ITestPersonaVoiceResponse|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.testPersonaVoice as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.testPersonaVoice as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes testPersonaVoice with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.TestPersonaVoiceRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.TestPersonaVoiceRequest', ['app']);
            request.app = defaultValue1;
            const expectedHeaderRequestParams = `app=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.testPersonaVoice = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.testPersonaVoice(request), expectedError);
            const actualRequest = (client.innerApiCalls.testPersonaVoice as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.testPersonaVoice as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes testPersonaVoice with closed client', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.TestPersonaVoiceRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.TestPersonaVoiceRequest', ['app']);
            request.app = defaultValue1;
            const expectedError = new Error('The client has already been closed.');
            client.close().catch(err => {throw err});
            await assert.rejects(client.testPersonaVoice(request), expectedError);
        });
    });

    describe('runEvaluation', () => {
        it('invokes runEvaluation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.RunEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.RunEvaluationRequest', ['app']);
            request.app = defaultValue1;
            const expectedHeaderRequestParams = `app=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.runEvaluation = stubLongRunningCall(expectedResponse);
            const [operation] = await client.runEvaluation(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.runEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.runEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes runEvaluation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.RunEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.RunEvaluationRequest', ['app']);
            request.app = defaultValue1;
            const expectedHeaderRequestParams = `app=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.runEvaluation = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.runEvaluation(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.cloud.ces.v1beta.IRunEvaluationResponse, protos.google.cloud.ces.v1beta.IRunEvaluationOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.runEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.runEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes runEvaluation with call error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.RunEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.RunEvaluationRequest', ['app']);
            request.app = defaultValue1;
            const expectedHeaderRequestParams = `app=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.runEvaluation = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.runEvaluation(request), expectedError);
            const actualRequest = (client.innerApiCalls.runEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.runEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes runEvaluation with LRO error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.RunEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.RunEvaluationRequest', ['app']);
            request.app = defaultValue1;
            const expectedHeaderRequestParams = `app=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.runEvaluation = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.runEvaluation(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.runEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.runEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkRunEvaluationProgress without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkRunEvaluationProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkRunEvaluationProgress with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkRunEvaluationProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('generateEvaluation', () => {
        it('invokes generateEvaluation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GenerateEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GenerateEvaluationRequest', ['conversation']);
            request.conversation = defaultValue1;
            const expectedHeaderRequestParams = `conversation=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.generateEvaluation = stubLongRunningCall(expectedResponse);
            const [operation] = await client.generateEvaluation(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.generateEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.generateEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes generateEvaluation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GenerateEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GenerateEvaluationRequest', ['conversation']);
            request.conversation = defaultValue1;
            const expectedHeaderRequestParams = `conversation=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.generateEvaluation = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.generateEvaluation(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.cloud.ces.v1beta.IEvaluation, protos.google.cloud.ces.v1beta.IGenerateEvaluationOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.generateEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.generateEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes generateEvaluation with call error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GenerateEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GenerateEvaluationRequest', ['conversation']);
            request.conversation = defaultValue1;
            const expectedHeaderRequestParams = `conversation=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.generateEvaluation = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.generateEvaluation(request), expectedError);
            const actualRequest = (client.innerApiCalls.generateEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.generateEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes generateEvaluation with LRO error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.GenerateEvaluationRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.GenerateEvaluationRequest', ['conversation']);
            request.conversation = defaultValue1;
            const expectedHeaderRequestParams = `conversation=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.generateEvaluation = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.generateEvaluation(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.generateEvaluation as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.generateEvaluation as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkGenerateEvaluationProgress without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkGenerateEvaluationProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkGenerateEvaluationProgress with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkGenerateEvaluationProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('importEvaluations', () => {
        it('invokes importEvaluations without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ImportEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ImportEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.importEvaluations = stubLongRunningCall(expectedResponse);
            const [operation] = await client.importEvaluations(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.importEvaluations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.importEvaluations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes importEvaluations without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ImportEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ImportEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.importEvaluations = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.importEvaluations(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.cloud.ces.v1beta.IImportEvaluationsResponse, protos.google.cloud.ces.v1beta.IImportEvaluationsOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.importEvaluations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.importEvaluations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes importEvaluations with call error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ImportEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ImportEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.importEvaluations = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.importEvaluations(request), expectedError);
            const actualRequest = (client.innerApiCalls.importEvaluations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.importEvaluations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes importEvaluations with LRO error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ImportEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ImportEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.importEvaluations = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.importEvaluations(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.importEvaluations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.importEvaluations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkImportEvaluationsProgress without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkImportEvaluationsProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkImportEvaluationsProgress with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkImportEvaluationsProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('deleteEvaluationRun', () => {
        it('invokes deleteEvaluationRun without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.deleteEvaluationRun = stubLongRunningCall(expectedResponse);
            const [operation] = await client.deleteEvaluationRun(request);
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationRun without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedResponse = generateSampleMessage(
              new protos.google.longrunning.Operation()
            );
            client.innerApiCalls.deleteEvaluationRun = stubLongRunningCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.deleteEvaluationRun(
                    request,
                    (err?: Error|null,
                     result?: LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>|null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const operation = await promise as LROperation<protos.google.protobuf.IEmpty, protos.google.cloud.ces.v1beta.IDeleteEvaluationRunOperationMetadata>;
            const [response] = await operation.promise();
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.deleteEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationRun with call error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteEvaluationRun = stubLongRunningCall(undefined, expectedError);
            await assert.rejects(client.deleteEvaluationRun(request), expectedError);
            const actualRequest = (client.innerApiCalls.deleteEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes deleteEvaluationRun with LRO error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.DeleteEvaluationRunRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.DeleteEvaluationRunRequest', ['name']);
            request.name = defaultValue1;
            const expectedHeaderRequestParams = `name=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.deleteEvaluationRun = stubLongRunningCall(undefined, undefined, expectedError);
            const [operation] = await client.deleteEvaluationRun(request);
            await assert.rejects(operation.promise(), expectedError);
            const actualRequest = (client.innerApiCalls.deleteEvaluationRun as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.deleteEvaluationRun as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes checkDeleteEvaluationRunProgress without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedResponse = generateSampleMessage(
              new operationsProtos.google.longrunning.Operation()
            );
            expectedResponse.name = 'test';
            expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
            expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')}

            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const decodedOperation = await client.checkDeleteEvaluationRunProgress(expectedResponse.name);
            assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
            assert(decodedOperation.metadata);
            assert((client.operationsClient.getOperation as SinonStub).getCall(0));
        });

        it('invokes checkDeleteEvaluationRunProgress with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const expectedError = new Error('expected');

            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.checkDeleteEvaluationRunProgress(''), expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
    });

    describe('listEvaluations', () => {
        it('invokes listEvaluations without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
            ];
            client.innerApiCalls.listEvaluations = stubSimpleCall(expectedResponse);
            const [response] = await client.listEvaluations(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluations without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
            ];
            client.innerApiCalls.listEvaluations = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listEvaluations(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluation[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluations with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listEvaluations = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listEvaluations(request), expectedError);
            const actualRequest = (client.innerApiCalls.listEvaluations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationsStream without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
            ];
            client.descriptors.page.listEvaluations.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listEvaluationsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Evaluation[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Evaluation) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listEvaluations.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluations, request));
            assert(
                (client.descriptors.page.listEvaluations.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listEvaluationsStream with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluations.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listEvaluationsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.Evaluation[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.Evaluation) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listEvaluations.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluations, request));
            assert(
                (client.descriptors.page.listEvaluations.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listEvaluations without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.Evaluation()),
            ];
            client.descriptors.page.listEvaluations.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IEvaluation[] = [];
            const iterable = client.listEvaluationsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listEvaluations with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluations.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listEvaluationsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IEvaluation[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listEvaluationResults', () => {
        it('invokes listEvaluationResults without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationResultsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationResultsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
            ];
            client.innerApiCalls.listEvaluationResults = stubSimpleCall(expectedResponse);
            const [response] = await client.listEvaluationResults(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluationResults as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationResults as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationResults without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationResultsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationResultsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
            ];
            client.innerApiCalls.listEvaluationResults = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listEvaluationResults(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationResult[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluationResults as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationResults as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationResults with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationResultsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationResultsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listEvaluationResults = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listEvaluationResults(request), expectedError);
            const actualRequest = (client.innerApiCalls.listEvaluationResults as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationResults as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationResultsStream without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationResultsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationResultsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
            ];
            client.descriptors.page.listEvaluationResults.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listEvaluationResultsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.EvaluationResult[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.EvaluationResult) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listEvaluationResults.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluationResults, request));
            assert(
                (client.descriptors.page.listEvaluationResults.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listEvaluationResultsStream with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationResultsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationResultsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluationResults.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listEvaluationResultsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.EvaluationResult[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.EvaluationResult) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listEvaluationResults.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluationResults, request));
            assert(
                (client.descriptors.page.listEvaluationResults.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listEvaluationResults without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationResultsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationResultsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationResult()),
            ];
            client.descriptors.page.listEvaluationResults.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IEvaluationResult[] = [];
            const iterable = client.listEvaluationResultsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluationResults.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluationResults.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listEvaluationResults with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationResultsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationResultsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluationResults.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listEvaluationResultsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IEvaluationResult[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluationResults.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluationResults.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listEvaluationDatasets', () => {
        it('invokes listEvaluationDatasets without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
            ];
            client.innerApiCalls.listEvaluationDatasets = stubSimpleCall(expectedResponse);
            const [response] = await client.listEvaluationDatasets(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluationDatasets as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationDatasets as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationDatasets without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
            ];
            client.innerApiCalls.listEvaluationDatasets = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listEvaluationDatasets(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationDataset[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluationDatasets as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationDatasets as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationDatasets with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listEvaluationDatasets = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listEvaluationDatasets(request), expectedError);
            const actualRequest = (client.innerApiCalls.listEvaluationDatasets as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationDatasets as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationDatasetsStream without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
            ];
            client.descriptors.page.listEvaluationDatasets.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listEvaluationDatasetsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.EvaluationDataset[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.EvaluationDataset) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listEvaluationDatasets.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluationDatasets, request));
            assert(
                (client.descriptors.page.listEvaluationDatasets.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listEvaluationDatasetsStream with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluationDatasets.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listEvaluationDatasetsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.EvaluationDataset[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.EvaluationDataset) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listEvaluationDatasets.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluationDatasets, request));
            assert(
                (client.descriptors.page.listEvaluationDatasets.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listEvaluationDatasets without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationDataset()),
            ];
            client.descriptors.page.listEvaluationDatasets.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IEvaluationDataset[] = [];
            const iterable = client.listEvaluationDatasetsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluationDatasets.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluationDatasets.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listEvaluationDatasets with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationDatasetsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluationDatasets.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listEvaluationDatasetsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IEvaluationDataset[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluationDatasets.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluationDatasets.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listEvaluationRuns', () => {
        it('invokes listEvaluationRuns without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
            ];
            client.innerApiCalls.listEvaluationRuns = stubSimpleCall(expectedResponse);
            const [response] = await client.listEvaluationRuns(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluationRuns as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationRuns as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationRuns without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
            ];
            client.innerApiCalls.listEvaluationRuns = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listEvaluationRuns(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationRun[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluationRuns as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationRuns as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationRuns with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listEvaluationRuns = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listEvaluationRuns(request), expectedError);
            const actualRequest = (client.innerApiCalls.listEvaluationRuns as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationRuns as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationRunsStream without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
            ];
            client.descriptors.page.listEvaluationRuns.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listEvaluationRunsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.EvaluationRun[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.EvaluationRun) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listEvaluationRuns.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluationRuns, request));
            assert(
                (client.descriptors.page.listEvaluationRuns.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listEvaluationRunsStream with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluationRuns.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listEvaluationRunsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.EvaluationRun[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.EvaluationRun) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listEvaluationRuns.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluationRuns, request));
            assert(
                (client.descriptors.page.listEvaluationRuns.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listEvaluationRuns without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationRun()),
            ];
            client.descriptors.page.listEvaluationRuns.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IEvaluationRun[] = [];
            const iterable = client.listEvaluationRunsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluationRuns.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluationRuns.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listEvaluationRuns with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluationRuns.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listEvaluationRunsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IEvaluationRun[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluationRuns.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluationRuns.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listEvaluationExpectations', () => {
        it('invokes listEvaluationExpectations without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
            ];
            client.innerApiCalls.listEvaluationExpectations = stubSimpleCall(expectedResponse);
            const [response] = await client.listEvaluationExpectations(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluationExpectations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationExpectations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationExpectations without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
            ];
            client.innerApiCalls.listEvaluationExpectations = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listEvaluationExpectations(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IEvaluationExpectation[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listEvaluationExpectations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationExpectations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationExpectations with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listEvaluationExpectations = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listEvaluationExpectations(request), expectedError);
            const actualRequest = (client.innerApiCalls.listEvaluationExpectations as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listEvaluationExpectations as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listEvaluationExpectationsStream without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
            ];
            client.descriptors.page.listEvaluationExpectations.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listEvaluationExpectationsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.EvaluationExpectation[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.EvaluationExpectation) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listEvaluationExpectations.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluationExpectations, request));
            assert(
                (client.descriptors.page.listEvaluationExpectations.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listEvaluationExpectationsStream with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluationExpectations.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listEvaluationExpectationsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.EvaluationExpectation[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.EvaluationExpectation) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listEvaluationExpectations.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listEvaluationExpectations, request));
            assert(
                (client.descriptors.page.listEvaluationExpectations.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listEvaluationExpectations without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.EvaluationExpectation()),
            ];
            client.descriptors.page.listEvaluationExpectations.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IEvaluationExpectation[] = [];
            const iterable = client.listEvaluationExpectationsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluationExpectations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluationExpectations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listEvaluationExpectations with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListEvaluationExpectationsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listEvaluationExpectations.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listEvaluationExpectationsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IEvaluationExpectation[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listEvaluationExpectations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listEvaluationExpectations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });

    describe('listScheduledEvaluationRuns', () => {
        it('invokes listScheduledEvaluationRuns without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
            ];
            client.innerApiCalls.listScheduledEvaluationRuns = stubSimpleCall(expectedResponse);
            const [response] = await client.listScheduledEvaluationRuns(request);
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listScheduledEvaluationRuns as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listScheduledEvaluationRuns as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listScheduledEvaluationRuns without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
            ];
            client.innerApiCalls.listScheduledEvaluationRuns = stubSimpleCallWithCallback(expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.listScheduledEvaluationRuns(
                    request,
                    (err?: Error|null, result?: protos.google.cloud.ces.v1beta.IScheduledEvaluationRun[]|null) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            const actualRequest = (client.innerApiCalls.listScheduledEvaluationRuns as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listScheduledEvaluationRuns as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listScheduledEvaluationRuns with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.innerApiCalls.listScheduledEvaluationRuns = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.listScheduledEvaluationRuns(request), expectedError);
            const actualRequest = (client.innerApiCalls.listScheduledEvaluationRuns as SinonStub)
                .getCall(0).args[0];
            assert.deepStrictEqual(actualRequest, request);
            const actualHeaderRequestParams = (client.innerApiCalls.listScheduledEvaluationRuns as SinonStub)
                .getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
            assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
        });

        it('invokes listScheduledEvaluationRunsStream without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
            ];
            client.descriptors.page.listScheduledEvaluationRuns.createStream = stubPageStreamingCall(expectedResponse);
            const stream = client.listScheduledEvaluationRunsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.ScheduledEvaluationRun[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.ScheduledEvaluationRun) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            const responses = await promise;
            assert.deepStrictEqual(responses, expectedResponse);
            assert((client.descriptors.page.listScheduledEvaluationRuns.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listScheduledEvaluationRuns, request));
            assert(
                (client.descriptors.page.listScheduledEvaluationRuns.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('invokes listScheduledEvaluationRunsStream with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listScheduledEvaluationRuns.createStream = stubPageStreamingCall(undefined, expectedError);
            const stream = client.listScheduledEvaluationRunsStream(request);
            const promise = new Promise((resolve, reject) => {
                const responses: protos.google.cloud.ces.v1beta.ScheduledEvaluationRun[] = [];
                stream.on('data', (response: protos.google.cloud.ces.v1beta.ScheduledEvaluationRun) => {
                    responses.push(response);
                });
                stream.on('end', () => {
                    resolve(responses);
                });
                stream.on('error', (err: Error) => {
                    reject(err);
                });
            });
            await assert.rejects(promise, expectedError);
            assert((client.descriptors.page.listScheduledEvaluationRuns.createStream as SinonStub)
                .getCall(0).calledWith(client.innerApiCalls.listScheduledEvaluationRuns, request));
            assert(
                (client.descriptors.page.listScheduledEvaluationRuns.createStream as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                         expectedHeaderRequestParams
                    ) 
            );
        });

        it('uses async iteration with listScheduledEvaluationRuns without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedResponse = [
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
              generateSampleMessage(new protos.google.cloud.ces.v1beta.ScheduledEvaluationRun()),
            ];
            client.descriptors.page.listScheduledEvaluationRuns.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: protos.google.cloud.ces.v1beta.IScheduledEvaluationRun[] = [];
            const iterable = client.listScheduledEvaluationRunsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.descriptors.page.listScheduledEvaluationRuns.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listScheduledEvaluationRuns.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });

        it('uses async iteration with listScheduledEvaluationRuns with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new protos.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest()
            );
            const defaultValue1 =
              getTypeDefaultValue('.google.cloud.ces.v1beta.ListScheduledEvaluationRunsRequest', ['parent']);
            request.parent = defaultValue1;
            const expectedHeaderRequestParams = `parent=${defaultValue1 ?? '' }`;
            const expectedError = new Error('expected');
            client.descriptors.page.listScheduledEvaluationRuns.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listScheduledEvaluationRunsAsync(request);
            await assert.rejects(async () => {
                const responses: protos.google.cloud.ces.v1beta.IScheduledEvaluationRun[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.descriptors.page.listScheduledEvaluationRuns.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.descriptors.page.listScheduledEvaluationRuns.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });
    describe('getLocation', () => {
        it('invokes getLocation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.GetLocationRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedOptions = {
                otherArgs: {
                    headers: {
                        'x-goog-request-params': expectedHeaderRequestParams,
                    },
                },
            };
            const expectedResponse = generateSampleMessage(
              new LocationProtos.google.cloud.location.Location()
            );
            client.locationsClient.getLocation = stubSimpleCall(expectedResponse);
            const response = await client.getLocation(request, expectedOptions);
            assert.deepStrictEqual(response, [expectedResponse]);
            assert((client.locationsClient.getLocation as SinonStub)
                .getCall(0).calledWith(request, expectedOptions, undefined));
        });
        it('invokes getLocation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.GetLocationRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedOptions = {
                otherArgs: {
                    headers: {
                        'x-goog-request-params': expectedHeaderRequestParams,
                    },
                },
            };
            const expectedResponse = generateSampleMessage(
              new LocationProtos.google.cloud.location.Location()
            );
            client.locationsClient.getLocation = sinon.stub().callsArgWith(2, null, expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.getLocation(
                    request,
                    expectedOptions,
                    (
                        err?: Error | null,
                        result?: LocationProtos.google.cloud.location.ILocation | null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    });
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            assert((client.locationsClient.getLocation as SinonStub)
                .getCall(0));
        });
        it('invokes getLocation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.GetLocationRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedOptions = {
                otherArgs: {
                    headers: {
                        'x-goog-request-params': expectedHeaderRequestParams,
                    },
                },
            };
            const expectedError = new Error('expected');
            client.locationsClient.getLocation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(client.getLocation(request, expectedOptions), expectedError);
            assert((client.locationsClient.getLocation as SinonStub)
                .getCall(0).calledWith(request, expectedOptions, undefined));
        });
    });
    describe('listLocationsAsync', () => {
        it('uses async iteration with listLocations without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
                new LocationProtos.google.cloud.location.ListLocationsRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedResponse = [
                generateSampleMessage(
                    new LocationProtos.google.cloud.location.Location()
                ),
                generateSampleMessage(
                    new LocationProtos.google.cloud.location.Location()
                ),
                generateSampleMessage(
                    new LocationProtos.google.cloud.location.Location()
                ),
            ];
            client.locationsClient.descriptors.page.listLocations.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: LocationProtos.google.cloud.location.ILocation[] = [];
            const iterable = client.listLocationsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
        it('uses async iteration with listLocations with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new LocationProtos.google.cloud.location.ListLocationsRequest()
            );
            request.name = '';
            const expectedHeaderRequestParams = 'name=';
            const expectedError = new Error('expected');
            client.locationsClient.descriptors.page.listLocations.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.listLocationsAsync(request);
            await assert.rejects(async () => {
                const responses: LocationProtos.google.cloud.location.ILocation[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
            assert(
                (client.locationsClient.descriptors.page.listLocations.asyncIterate as SinonStub)
                    .getCall(0).args[2].otherArgs.headers['x-goog-request-params'].includes(
                        expectedHeaderRequestParams
                    )
            );
        });
    });
    describe('getOperation', () => {
        it('invokes getOperation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.GetOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new operationsProtos.google.longrunning.Operation()
            );
            client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
            const response = await client.getOperation(request);
            assert.deepStrictEqual(response, [expectedResponse]);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0).calledWith(request)
            );
        });
        it('invokes getOperation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.GetOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new operationsProtos.google.longrunning.Operation()
            );
            client.operationsClient.getOperation = sinon.stub().callsArgWith(2, null, expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.operationsClient.getOperation(
                    request,
                    undefined,
                    (
                        err?: Error | null,
                        result?: operationsProtos.google.longrunning.Operation | null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    }).catch(err => {throw err});
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0));
        });
        it('invokes getOperation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.GetOperationRequest()
            );
            const expectedError = new Error('expected');
            client.operationsClient.getOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(async () => {await client.getOperation(request)}, expectedError);
            assert((client.operationsClient.getOperation as SinonStub)
                .getCall(0).calledWith(request));
        });
    });
    describe('cancelOperation', () => {
        it('invokes cancelOperation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.CancelOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new protos.google.protobuf.Empty()
            );
            client.operationsClient.cancelOperation = stubSimpleCall(expectedResponse);
            const response = await client.cancelOperation(request);
            assert.deepStrictEqual(response, [expectedResponse]);
            assert((client.operationsClient.cancelOperation as SinonStub)
                .getCall(0).calledWith(request)
            );
        });
        it('invokes cancelOperation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.CancelOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new protos.google.protobuf.Empty()
            );
            client.operationsClient.cancelOperation = sinon.stub().callsArgWith(2, null, expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.operationsClient.cancelOperation(
                    request,
                    undefined,
                    (
                        err?: Error | null,
                        result?: protos.google.protobuf.Empty | null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    }).catch(err => {throw err});
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            assert((client.operationsClient.cancelOperation as SinonStub)
                .getCall(0));
        });
        it('invokes cancelOperation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.CancelOperationRequest()
            );
            const expectedError = new Error('expected');
            client.operationsClient.cancelOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(async () => {await client.cancelOperation(request)}, expectedError);
            assert((client.operationsClient.cancelOperation as SinonStub)
                .getCall(0).calledWith(request));
        });
    });
    describe('deleteOperation', () => {
        it('invokes deleteOperation without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.DeleteOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new protos.google.protobuf.Empty()
            );
            client.operationsClient.deleteOperation = stubSimpleCall(expectedResponse);
            const response = await client.deleteOperation(request);
            assert.deepStrictEqual(response, [expectedResponse]);
            assert((client.operationsClient.deleteOperation as SinonStub)
                .getCall(0).calledWith(request)
            );
        });
        it('invokes deleteOperation without error using callback', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.DeleteOperationRequest()
            );
            const expectedResponse = generateSampleMessage(
                new protos.google.protobuf.Empty()
            );
            client.operationsClient.deleteOperation = sinon.stub().callsArgWith(2, null, expectedResponse);
            const promise = new Promise((resolve, reject) => {
                 client.operationsClient.deleteOperation(
                    request,
                    undefined,
                    (
                        err?: Error | null,
                        result?: protos.google.protobuf.Empty | null
                    ) => {
                        if (err) {
                            reject(err);
                        } else {
                            resolve(result);
                        }
                    }).catch(err => {throw err});
            });
            const response = await promise;
            assert.deepStrictEqual(response, expectedResponse);
            assert((client.operationsClient.deleteOperation as SinonStub)
                .getCall(0));
        });
        it('invokes deleteOperation with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.DeleteOperationRequest()
            );
            const expectedError = new Error('expected');
            client.operationsClient.deleteOperation = stubSimpleCall(undefined, expectedError);
            await assert.rejects(async () => {await client.deleteOperation(request)}, expectedError);
            assert((client.operationsClient.deleteOperation as SinonStub)
                .getCall(0).calledWith(request));
        });
    });
    describe('listOperationsAsync', () => {
        it('uses async iteration with listOperations without error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
              credentials: {client_email: 'bogus', private_key: 'bogus'},
              projectId: 'bogus',
            });
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.ListOperationsRequest()
            );
            const expectedResponse = [
                generateSampleMessage(
                    new operationsProtos.google.longrunning.ListOperationsResponse()
                ),
                generateSampleMessage(
                    new operationsProtos.google.longrunning.ListOperationsResponse()
                ),
                generateSampleMessage(
                    new operationsProtos.google.longrunning.ListOperationsResponse()
                ),
            ];
            client.operationsClient.descriptor.listOperations.asyncIterate = stubAsyncIterationCall(expectedResponse);
            const responses: operationsProtos.google.longrunning.IOperation[] = [];
            const iterable = client.operationsClient.listOperationsAsync(request);
            for await (const resource of iterable) {
                responses.push(resource!);
            }
            assert.deepStrictEqual(responses, expectedResponse);
            assert.deepStrictEqual(
                (client.operationsClient.descriptor.listOperations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
        });
        it('uses async iteration with listOperations with error', async () => {
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            const request = generateSampleMessage(
              new operationsProtos.google.longrunning.ListOperationsRequest()
            );
            const expectedError = new Error('expected');
            client.operationsClient.descriptor.listOperations.asyncIterate = stubAsyncIterationCall(undefined, expectedError);
            const iterable = client.operationsClient.listOperationsAsync(request);
            await assert.rejects(async () => {
                const responses: operationsProtos.google.longrunning.IOperation[] = [];
                for await (const resource of iterable) {
                    responses.push(resource!);
                }
            });
            assert.deepStrictEqual(
                (client.operationsClient.descriptor.listOperations.asyncIterate as SinonStub)
                    .getCall(0).args[1], request);
        });
    });

    describe('Path templates', () => {

        describe('agent', async () => {
            const fakePath = "/rendered/path/agent";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                agent: "agentValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.agentPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.agentPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('agentPath', () => {
                const result = client.agentPath("projectValue", "locationValue", "appValue", "agentValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.agentPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromAgentName', () => {
                const result = client.matchProjectFromAgentName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromAgentName', () => {
                const result = client.matchLocationFromAgentName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromAgentName', () => {
                const result = client.matchAppFromAgentName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAgentFromAgentName', () => {
                const result = client.matchAgentFromAgentName(fakePath);
                assert.strictEqual(result, "agentValue");
                assert((client.pathTemplates.agentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('app', async () => {
            const fakePath = "/rendered/path/app";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.appPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.appPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('appPath', () => {
                const result = client.appPath("projectValue", "locationValue", "appValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.appPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromAppName', () => {
                const result = client.matchProjectFromAppName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.appPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromAppName', () => {
                const result = client.matchLocationFromAppName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.appPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromAppName', () => {
                const result = client.matchAppFromAppName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.appPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('appVersion', async () => {
            const fakePath = "/rendered/path/appVersion";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                version: "versionValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.appVersionPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.appVersionPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('appVersionPath', () => {
                const result = client.appVersionPath("projectValue", "locationValue", "appValue", "versionValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.appVersionPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromAppVersionName', () => {
                const result = client.matchProjectFromAppVersionName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromAppVersionName', () => {
                const result = client.matchLocationFromAppVersionName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromAppVersionName', () => {
                const result = client.matchAppFromAppVersionName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchVersionFromAppVersionName', () => {
                const result = client.matchVersionFromAppVersionName(fakePath);
                assert.strictEqual(result, "versionValue");
                assert((client.pathTemplates.appVersionPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('changelog', async () => {
            const fakePath = "/rendered/path/changelog";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                changelog: "changelogValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.changelogPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.changelogPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('changelogPath', () => {
                const result = client.changelogPath("projectValue", "locationValue", "appValue", "changelogValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.changelogPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromChangelogName', () => {
                const result = client.matchProjectFromChangelogName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromChangelogName', () => {
                const result = client.matchLocationFromChangelogName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromChangelogName', () => {
                const result = client.matchAppFromChangelogName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchChangelogFromChangelogName', () => {
                const result = client.matchChangelogFromChangelogName(fakePath);
                assert.strictEqual(result, "changelogValue");
                assert((client.pathTemplates.changelogPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('conversation', async () => {
            const fakePath = "/rendered/path/conversation";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                conversation: "conversationValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.conversationPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.conversationPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('conversationPath', () => {
                const result = client.conversationPath("projectValue", "locationValue", "appValue", "conversationValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.conversationPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromConversationName', () => {
                const result = client.matchProjectFromConversationName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromConversationName', () => {
                const result = client.matchLocationFromConversationName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromConversationName', () => {
                const result = client.matchAppFromConversationName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchConversationFromConversationName', () => {
                const result = client.matchConversationFromConversationName(fakePath);
                assert.strictEqual(result, "conversationValue");
                assert((client.pathTemplates.conversationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('deployment', async () => {
            const fakePath = "/rendered/path/deployment";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                deployment: "deploymentValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.deploymentPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.deploymentPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('deploymentPath', () => {
                const result = client.deploymentPath("projectValue", "locationValue", "appValue", "deploymentValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.deploymentPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromDeploymentName', () => {
                const result = client.matchProjectFromDeploymentName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromDeploymentName', () => {
                const result = client.matchLocationFromDeploymentName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromDeploymentName', () => {
                const result = client.matchAppFromDeploymentName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchDeploymentFromDeploymentName', () => {
                const result = client.matchDeploymentFromDeploymentName(fakePath);
                assert.strictEqual(result, "deploymentValue");
                assert((client.pathTemplates.deploymentPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluation', async () => {
            const fakePath = "/rendered/path/evaluation";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation: "evaluationValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationPath', () => {
                const result = client.evaluationPath("projectValue", "locationValue", "appValue", "evaluationValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationName', () => {
                const result = client.matchProjectFromEvaluationName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationName', () => {
                const result = client.matchLocationFromEvaluationName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationName', () => {
                const result = client.matchAppFromEvaluationName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationFromEvaluationName', () => {
                const result = client.matchEvaluationFromEvaluationName(fakePath);
                assert.strictEqual(result, "evaluationValue");
                assert((client.pathTemplates.evaluationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluationDataset', async () => {
            const fakePath = "/rendered/path/evaluationDataset";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation_dataset: "evaluationDatasetValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationDatasetPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationDatasetPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationDatasetPath', () => {
                const result = client.evaluationDatasetPath("projectValue", "locationValue", "appValue", "evaluationDatasetValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationDatasetPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationDatasetName', () => {
                const result = client.matchProjectFromEvaluationDatasetName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationDatasetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationDatasetName', () => {
                const result = client.matchLocationFromEvaluationDatasetName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationDatasetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationDatasetName', () => {
                const result = client.matchAppFromEvaluationDatasetName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationDatasetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationDatasetFromEvaluationDatasetName', () => {
                const result = client.matchEvaluationDatasetFromEvaluationDatasetName(fakePath);
                assert.strictEqual(result, "evaluationDatasetValue");
                assert((client.pathTemplates.evaluationDatasetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluationExpectation', async () => {
            const fakePath = "/rendered/path/evaluationExpectation";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation_expectation: "evaluationExpectationValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationExpectationPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationExpectationPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationExpectationPath', () => {
                const result = client.evaluationExpectationPath("projectValue", "locationValue", "appValue", "evaluationExpectationValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationExpectationPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationExpectationName', () => {
                const result = client.matchProjectFromEvaluationExpectationName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationExpectationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationExpectationName', () => {
                const result = client.matchLocationFromEvaluationExpectationName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationExpectationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationExpectationName', () => {
                const result = client.matchAppFromEvaluationExpectationName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationExpectationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationExpectationFromEvaluationExpectationName', () => {
                const result = client.matchEvaluationExpectationFromEvaluationExpectationName(fakePath);
                assert.strictEqual(result, "evaluationExpectationValue");
                assert((client.pathTemplates.evaluationExpectationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluationResult', async () => {
            const fakePath = "/rendered/path/evaluationResult";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation: "evaluationValue",
                evaluation_result: "evaluationResultValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationResultPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationResultPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationResultPath', () => {
                const result = client.evaluationResultPath("projectValue", "locationValue", "appValue", "evaluationValue", "evaluationResultValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationResultPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationResultName', () => {
                const result = client.matchProjectFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationResultName', () => {
                const result = client.matchLocationFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationResultName', () => {
                const result = client.matchAppFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationFromEvaluationResultName', () => {
                const result = client.matchEvaluationFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "evaluationValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationResultFromEvaluationResultName', () => {
                const result = client.matchEvaluationResultFromEvaluationResultName(fakePath);
                assert.strictEqual(result, "evaluationResultValue");
                assert((client.pathTemplates.evaluationResultPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('evaluationRun', async () => {
            const fakePath = "/rendered/path/evaluationRun";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                evaluation_run: "evaluationRunValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.evaluationRunPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.evaluationRunPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('evaluationRunPath', () => {
                const result = client.evaluationRunPath("projectValue", "locationValue", "appValue", "evaluationRunValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.evaluationRunPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromEvaluationRunName', () => {
                const result = client.matchProjectFromEvaluationRunName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.evaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromEvaluationRunName', () => {
                const result = client.matchLocationFromEvaluationRunName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.evaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromEvaluationRunName', () => {
                const result = client.matchAppFromEvaluationRunName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.evaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchEvaluationRunFromEvaluationRunName', () => {
                const result = client.matchEvaluationRunFromEvaluationRunName(fakePath);
                assert.strictEqual(result, "evaluationRunValue");
                assert((client.pathTemplates.evaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('example', async () => {
            const fakePath = "/rendered/path/example";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                example: "exampleValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.examplePathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.examplePathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('examplePath', () => {
                const result = client.examplePath("projectValue", "locationValue", "appValue", "exampleValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.examplePathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromExampleName', () => {
                const result = client.matchProjectFromExampleName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromExampleName', () => {
                const result = client.matchLocationFromExampleName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromExampleName', () => {
                const result = client.matchAppFromExampleName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchExampleFromExampleName', () => {
                const result = client.matchExampleFromExampleName(fakePath);
                assert.strictEqual(result, "exampleValue");
                assert((client.pathTemplates.examplePathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('guardrail', async () => {
            const fakePath = "/rendered/path/guardrail";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                guardrail: "guardrailValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.guardrailPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.guardrailPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('guardrailPath', () => {
                const result = client.guardrailPath("projectValue", "locationValue", "appValue", "guardrailValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.guardrailPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromGuardrailName', () => {
                const result = client.matchProjectFromGuardrailName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromGuardrailName', () => {
                const result = client.matchLocationFromGuardrailName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromGuardrailName', () => {
                const result = client.matchAppFromGuardrailName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchGuardrailFromGuardrailName', () => {
                const result = client.matchGuardrailFromGuardrailName(fakePath);
                assert.strictEqual(result, "guardrailValue");
                assert((client.pathTemplates.guardrailPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('location', async () => {
            const fakePath = "/rendered/path/location";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.locationPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.locationPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('locationPath', () => {
                const result = client.locationPath("projectValue", "locationValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.locationPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromLocationName', () => {
                const result = client.matchProjectFromLocationName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.locationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromLocationName', () => {
                const result = client.matchLocationFromLocationName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.locationPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('omnichannel', async () => {
            const fakePath = "/rendered/path/omnichannel";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                omnichannel: "omnichannelValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.omnichannelPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.omnichannelPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('omnichannelPath', () => {
                const result = client.omnichannelPath("projectValue", "locationValue", "omnichannelValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.omnichannelPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromOmnichannelName', () => {
                const result = client.matchProjectFromOmnichannelName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.omnichannelPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromOmnichannelName', () => {
                const result = client.matchLocationFromOmnichannelName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.omnichannelPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchOmnichannelFromOmnichannelName', () => {
                const result = client.matchOmnichannelFromOmnichannelName(fakePath);
                assert.strictEqual(result, "omnichannelValue");
                assert((client.pathTemplates.omnichannelPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('project', async () => {
            const fakePath = "/rendered/path/project";
            const expectedParameters = {
                project: "projectValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.projectPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.projectPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('projectPath', () => {
                const result = client.projectPath("projectValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.projectPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromProjectName', () => {
                const result = client.matchProjectFromProjectName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.projectPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('scheduledEvaluationRun', async () => {
            const fakePath = "/rendered/path/scheduledEvaluationRun";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                scheduled_evaluation_run: "scheduledEvaluationRunValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.scheduledEvaluationRunPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.scheduledEvaluationRunPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('scheduledEvaluationRunPath', () => {
                const result = client.scheduledEvaluationRunPath("projectValue", "locationValue", "appValue", "scheduledEvaluationRunValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromScheduledEvaluationRunName', () => {
                const result = client.matchProjectFromScheduledEvaluationRunName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromScheduledEvaluationRunName', () => {
                const result = client.matchLocationFromScheduledEvaluationRunName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromScheduledEvaluationRunName', () => {
                const result = client.matchAppFromScheduledEvaluationRunName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchScheduledEvaluationRunFromScheduledEvaluationRunName', () => {
                const result = client.matchScheduledEvaluationRunFromScheduledEvaluationRunName(fakePath);
                assert.strictEqual(result, "scheduledEvaluationRunValue");
                assert((client.pathTemplates.scheduledEvaluationRunPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('tool', async () => {
            const fakePath = "/rendered/path/tool";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                tool: "toolValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.toolPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.toolPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('toolPath', () => {
                const result = client.toolPath("projectValue", "locationValue", "appValue", "toolValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.toolPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromToolName', () => {
                const result = client.matchProjectFromToolName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromToolName', () => {
                const result = client.matchLocationFromToolName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromToolName', () => {
                const result = client.matchAppFromToolName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchToolFromToolName', () => {
                const result = client.matchToolFromToolName(fakePath);
                assert.strictEqual(result, "toolValue");
                assert((client.pathTemplates.toolPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });

        describe('toolset', async () => {
            const fakePath = "/rendered/path/toolset";
            const expectedParameters = {
                project: "projectValue",
                location: "locationValue",
                app: "appValue",
                toolset: "toolsetValue",
            };
            const client = new evaluationserviceModule.v1beta.EvaluationServiceClient({
                credentials: {client_email: 'bogus', private_key: 'bogus'},
                projectId: 'bogus',
            });
            await client.initialize();
            client.pathTemplates.toolsetPathTemplate.render =
                sinon.stub().returns(fakePath);
            client.pathTemplates.toolsetPathTemplate.match =
                sinon.stub().returns(expectedParameters);

            it('toolsetPath', () => {
                const result = client.toolsetPath("projectValue", "locationValue", "appValue", "toolsetValue");
                assert.strictEqual(result, fakePath);
                assert((client.pathTemplates.toolsetPathTemplate.render as SinonStub)
                    .getCall(-1).calledWith(expectedParameters));
            });

            it('matchProjectFromToolsetName', () => {
                const result = client.matchProjectFromToolsetName(fakePath);
                assert.strictEqual(result, "projectValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchLocationFromToolsetName', () => {
                const result = client.matchLocationFromToolsetName(fakePath);
                assert.strictEqual(result, "locationValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchAppFromToolsetName', () => {
                const result = client.matchAppFromToolsetName(fakePath);
                assert.strictEqual(result, "appValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });

            it('matchToolsetFromToolsetName', () => {
                const result = client.matchToolsetFromToolsetName(fakePath);
                assert.strictEqual(result, "toolsetValue");
                assert((client.pathTemplates.toolsetPathTemplate.match as SinonStub)
                    .getCall(-1).calledWith(fakePath));
            });
        });
    });
});
