// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated code. DO NOT EDIT!

#pragma warning disable CS8981
using gax = Google.Api.Gax;
using gccv = Google.Cloud.Ces.V1Beta;
using sys = System;

namespace Google.Cloud.Ces.V1Beta
{
    /// <summary>Resource name for the <c>Agent</c> resource.</summary>
    public sealed partial class AgentName : gax::IResourceName, sys::IEquatable<AgentName>
    {
        /// <summary>The possible contents of <see cref="AgentName"/>.</summary>
        public enum ResourceNameType
        {
            /// <summary>An unparsed resource name.</summary>
            Unparsed = 0,

            /// <summary>
            /// A resource name with pattern <c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c>.
            /// </summary>
            ProjectLocationAppAgent = 1,
        }

        private static gax::PathTemplate s_projectLocationAppAgent = new gax::PathTemplate("projects/{project}/locations/{location}/apps/{app}/agents/{agent}");

        /// <summary>Creates a <see cref="AgentName"/> containing an unparsed resource name.</summary>
        /// <param name="unparsedResourceName">The unparsed resource name. Must not be <c>null</c>.</param>
        /// <returns>
        /// A new instance of <see cref="AgentName"/> containing the provided <paramref name="unparsedResourceName"/>.
        /// </returns>
        public static AgentName FromUnparsed(gax::UnparsedResourceName unparsedResourceName) =>
            new AgentName(ResourceNameType.Unparsed, gax::GaxPreconditions.CheckNotNull(unparsedResourceName, nameof(unparsedResourceName)));

        /// <summary>
        /// Creates a <see cref="AgentName"/> with the pattern
        /// <c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c>.
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="appId">The <c>App</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="agentId">The <c>Agent</c> ID. Must not be <c>null</c> or empty.</param>
        /// <returns>A new instance of <see cref="AgentName"/> constructed from the provided ids.</returns>
        public static AgentName FromProjectLocationAppAgent(string projectId, string locationId, string appId, string agentId) =>
            new AgentName(ResourceNameType.ProjectLocationAppAgent, projectId: gax::GaxPreconditions.CheckNotNullOrEmpty(projectId, nameof(projectId)), locationId: gax::GaxPreconditions.CheckNotNullOrEmpty(locationId, nameof(locationId)), appId: gax::GaxPreconditions.CheckNotNullOrEmpty(appId, nameof(appId)), agentId: gax::GaxPreconditions.CheckNotNullOrEmpty(agentId, nameof(agentId)));

        /// <summary>
        /// Formats the IDs into the string representation of this <see cref="AgentName"/> with pattern
        /// <c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c>.
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="appId">The <c>App</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="agentId">The <c>Agent</c> ID. Must not be <c>null</c> or empty.</param>
        /// <returns>
        /// The string representation of this <see cref="AgentName"/> with pattern
        /// <c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c>.
        /// </returns>
        public static string Format(string projectId, string locationId, string appId, string agentId) =>
            FormatProjectLocationAppAgent(projectId, locationId, appId, agentId);

        /// <summary>
        /// Formats the IDs into the string representation of this <see cref="AgentName"/> with pattern
        /// <c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c>.
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="appId">The <c>App</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="agentId">The <c>Agent</c> ID. Must not be <c>null</c> or empty.</param>
        /// <returns>
        /// The string representation of this <see cref="AgentName"/> with pattern
        /// <c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c>.
        /// </returns>
        public static string FormatProjectLocationAppAgent(string projectId, string locationId, string appId, string agentId) =>
            s_projectLocationAppAgent.Expand(gax::GaxPreconditions.CheckNotNullOrEmpty(projectId, nameof(projectId)), gax::GaxPreconditions.CheckNotNullOrEmpty(locationId, nameof(locationId)), gax::GaxPreconditions.CheckNotNullOrEmpty(appId, nameof(appId)), gax::GaxPreconditions.CheckNotNullOrEmpty(agentId, nameof(agentId)));

        /// <summary>Parses the given resource name string into a new <see cref="AgentName"/> instance.</summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item>
        /// <description><c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c></description>
        /// </item>
        /// </list>
        /// </remarks>
        /// <param name="agentName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <returns>The parsed <see cref="AgentName"/> if successful.</returns>
        public static AgentName Parse(string agentName) => Parse(agentName, false);

        /// <summary>
        /// Parses the given resource name string into a new <see cref="AgentName"/> instance; optionally allowing an
        /// unparseable resource name.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item>
        /// <description><c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c></description>
        /// </item>
        /// </list>
        /// Or may be in any format if <paramref name="allowUnparsed"/> is <c>true</c>.
        /// </remarks>
        /// <param name="agentName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <param name="allowUnparsed">
        /// If <c>true</c> will successfully store an unparseable resource name into the <see cref="UnparsedResource"/>
        /// property; otherwise will throw an <see cref="sys::ArgumentException"/> if an unparseable resource name is
        /// specified.
        /// </param>
        /// <returns>The parsed <see cref="AgentName"/> if successful.</returns>
        public static AgentName Parse(string agentName, bool allowUnparsed) =>
            TryParse(agentName, allowUnparsed, out AgentName result) ? result : throw new sys::ArgumentException("The given resource-name matches no pattern.");

        /// <summary>
        /// Tries to parse the given resource name string into a new <see cref="AgentName"/> instance.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item>
        /// <description><c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c></description>
        /// </item>
        /// </list>
        /// </remarks>
        /// <param name="agentName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <param name="result">
        /// When this method returns, the parsed <see cref="AgentName"/>, or <c>null</c> if parsing failed.
        /// </param>
        /// <returns><c>true</c> if the name was parsed successfully; <c>false</c> otherwise.</returns>
        public static bool TryParse(string agentName, out AgentName result) => TryParse(agentName, false, out result);

        /// <summary>
        /// Tries to parse the given resource name string into a new <see cref="AgentName"/> instance; optionally
        /// allowing an unparseable resource name.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item>
        /// <description><c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c></description>
        /// </item>
        /// </list>
        /// Or may be in any format if <paramref name="allowUnparsed"/> is <c>true</c>.
        /// </remarks>
        /// <param name="agentName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <param name="allowUnparsed">
        /// If <c>true</c> will successfully store an unparseable resource name into the <see cref="UnparsedResource"/>
        /// property; otherwise will throw an <see cref="sys::ArgumentException"/> if an unparseable resource name is
        /// specified.
        /// </param>
        /// <param name="result">
        /// When this method returns, the parsed <see cref="AgentName"/>, or <c>null</c> if parsing failed.
        /// </param>
        /// <returns><c>true</c> if the name was parsed successfully; <c>false</c> otherwise.</returns>
        public static bool TryParse(string agentName, bool allowUnparsed, out AgentName result)
        {
            gax::GaxPreconditions.CheckNotNull(agentName, nameof(agentName));
            gax::TemplatedResourceName resourceName;
            if (s_projectLocationAppAgent.TryParseName(agentName, out resourceName))
            {
                result = FromProjectLocationAppAgent(resourceName[0], resourceName[1], resourceName[2], resourceName[3]);
                return true;
            }
            if (allowUnparsed)
            {
                if (gax::UnparsedResourceName.TryParse(agentName, out gax::UnparsedResourceName unparsedResourceName))
                {
                    result = FromUnparsed(unparsedResourceName);
                    return true;
                }
            }
            result = null;
            return false;
        }

        private AgentName(ResourceNameType type, gax::UnparsedResourceName unparsedResourceName = null, string agentId = null, string appId = null, string locationId = null, string projectId = null)
        {
            Type = type;
            UnparsedResource = unparsedResourceName;
            AgentId = agentId;
            AppId = appId;
            LocationId = locationId;
            ProjectId = projectId;
        }

        /// <summary>
        /// Constructs a new instance of a <see cref="AgentName"/> class from the component parts of pattern
        /// <c>projects/{project}/locations/{location}/apps/{app}/agents/{agent}</c>
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="appId">The <c>App</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="agentId">The <c>Agent</c> ID. Must not be <c>null</c> or empty.</param>
        public AgentName(string projectId, string locationId, string appId, string agentId) : this(ResourceNameType.ProjectLocationAppAgent, projectId: gax::GaxPreconditions.CheckNotNullOrEmpty(projectId, nameof(projectId)), locationId: gax::GaxPreconditions.CheckNotNullOrEmpty(locationId, nameof(locationId)), appId: gax::GaxPreconditions.CheckNotNullOrEmpty(appId, nameof(appId)), agentId: gax::GaxPreconditions.CheckNotNullOrEmpty(agentId, nameof(agentId)))
        {
        }

        /// <summary>The <see cref="ResourceNameType"/> of the contained resource name.</summary>
        public ResourceNameType Type { get; }

        /// <summary>
        /// The contained <see cref="gax::UnparsedResourceName"/>. Only non-<c>null</c> if this instance contains an
        /// unparsed resource name.
        /// </summary>
        public gax::UnparsedResourceName UnparsedResource { get; }

        /// <summary>
        /// The <c>Agent</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string AgentId { get; }

        /// <summary>
        /// The <c>App</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string AppId { get; }

        /// <summary>
        /// The <c>Location</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string LocationId { get; }

        /// <summary>
        /// The <c>Project</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string ProjectId { get; }

        /// <summary>Whether this instance contains a resource name with a known pattern.</summary>
        public bool IsKnownPattern => Type != ResourceNameType.Unparsed;

        /// <summary>The string representation of the resource name.</summary>
        /// <returns>The string representation of the resource name.</returns>
        public override string ToString()
        {
            switch (Type)
            {
                case ResourceNameType.Unparsed: return UnparsedResource.ToString();
                case ResourceNameType.ProjectLocationAppAgent: return s_projectLocationAppAgent.Expand(ProjectId, LocationId, AppId, AgentId);
                default: throw new sys::InvalidOperationException("Unrecognized resource-type.");
            }
        }

        /// <summary>Returns a hash code for this resource name.</summary>
        public override int GetHashCode() => ToString().GetHashCode();

        /// <inheritdoc/>
        public override bool Equals(object obj) => Equals(obj as AgentName);

        /// <inheritdoc/>
        public bool Equals(AgentName other) => ToString() == other?.ToString();

        /// <summary>Determines whether two specified resource names have the same value.</summary>
        /// <param name="a">The first resource name to compare, or null.</param>
        /// <param name="b">The second resource name to compare, or null.</param>
        /// <returns>
        /// true if the value of <paramref name="a"/> is the same as the value of <paramref name="b"/>; otherwise,
        /// false.
        /// </returns>
        public static bool operator ==(AgentName a, AgentName b) => ReferenceEquals(a, b) || (a?.Equals(b) ?? false);

        /// <summary>Determines whether two specified resource names have different values.</summary>
        /// <param name="a">The first resource name to compare, or null.</param>
        /// <param name="b">The second resource name to compare, or null.</param>
        /// <returns>
        /// true if the value of <paramref name="a"/> is different from the value of <paramref name="b"/>; otherwise,
        /// false.
        /// </returns>
        public static bool operator !=(AgentName a, AgentName b) => !(a == b);
    }

    /// <summary>Resource name for the <c>DialogflowAgent</c> resource.</summary>
    public sealed partial class DialogflowAgentName : gax::IResourceName, sys::IEquatable<DialogflowAgentName>
    {
        /// <summary>The possible contents of <see cref="DialogflowAgentName"/>.</summary>
        public enum ResourceNameType
        {
            /// <summary>An unparsed resource name.</summary>
            Unparsed = 0,

            /// <summary>
            /// A resource name with pattern <c>projects/{project}/locations/{location}/agents/{agent}</c>.
            /// </summary>
            ProjectLocationAgent = 1,
        }

        private static gax::PathTemplate s_projectLocationAgent = new gax::PathTemplate("projects/{project}/locations/{location}/agents/{agent}");

        /// <summary>Creates a <see cref="DialogflowAgentName"/> containing an unparsed resource name.</summary>
        /// <param name="unparsedResourceName">The unparsed resource name. Must not be <c>null</c>.</param>
        /// <returns>
        /// A new instance of <see cref="DialogflowAgentName"/> containing the provided
        /// <paramref name="unparsedResourceName"/>.
        /// </returns>
        public static DialogflowAgentName FromUnparsed(gax::UnparsedResourceName unparsedResourceName) =>
            new DialogflowAgentName(ResourceNameType.Unparsed, gax::GaxPreconditions.CheckNotNull(unparsedResourceName, nameof(unparsedResourceName)));

        /// <summary>
        /// Creates a <see cref="DialogflowAgentName"/> with the pattern
        /// <c>projects/{project}/locations/{location}/agents/{agent}</c>.
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="agentId">The <c>Agent</c> ID. Must not be <c>null</c> or empty.</param>
        /// <returns>A new instance of <see cref="DialogflowAgentName"/> constructed from the provided ids.</returns>
        public static DialogflowAgentName FromProjectLocationAgent(string projectId, string locationId, string agentId) =>
            new DialogflowAgentName(ResourceNameType.ProjectLocationAgent, projectId: gax::GaxPreconditions.CheckNotNullOrEmpty(projectId, nameof(projectId)), locationId: gax::GaxPreconditions.CheckNotNullOrEmpty(locationId, nameof(locationId)), agentId: gax::GaxPreconditions.CheckNotNullOrEmpty(agentId, nameof(agentId)));

        /// <summary>
        /// Formats the IDs into the string representation of this <see cref="DialogflowAgentName"/> with pattern
        /// <c>projects/{project}/locations/{location}/agents/{agent}</c>.
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="agentId">The <c>Agent</c> ID. Must not be <c>null</c> or empty.</param>
        /// <returns>
        /// The string representation of this <see cref="DialogflowAgentName"/> with pattern
        /// <c>projects/{project}/locations/{location}/agents/{agent}</c>.
        /// </returns>
        public static string Format(string projectId, string locationId, string agentId) =>
            FormatProjectLocationAgent(projectId, locationId, agentId);

        /// <summary>
        /// Formats the IDs into the string representation of this <see cref="DialogflowAgentName"/> with pattern
        /// <c>projects/{project}/locations/{location}/agents/{agent}</c>.
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="agentId">The <c>Agent</c> ID. Must not be <c>null</c> or empty.</param>
        /// <returns>
        /// The string representation of this <see cref="DialogflowAgentName"/> with pattern
        /// <c>projects/{project}/locations/{location}/agents/{agent}</c>.
        /// </returns>
        public static string FormatProjectLocationAgent(string projectId, string locationId, string agentId) =>
            s_projectLocationAgent.Expand(gax::GaxPreconditions.CheckNotNullOrEmpty(projectId, nameof(projectId)), gax::GaxPreconditions.CheckNotNullOrEmpty(locationId, nameof(locationId)), gax::GaxPreconditions.CheckNotNullOrEmpty(agentId, nameof(agentId)));

        /// <summary>
        /// Parses the given resource name string into a new <see cref="DialogflowAgentName"/> instance.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item><description><c>projects/{project}/locations/{location}/agents/{agent}</c></description></item>
        /// </list>
        /// </remarks>
        /// <param name="dialogflowAgentName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <returns>The parsed <see cref="DialogflowAgentName"/> if successful.</returns>
        public static DialogflowAgentName Parse(string dialogflowAgentName) => Parse(dialogflowAgentName, false);

        /// <summary>
        /// Parses the given resource name string into a new <see cref="DialogflowAgentName"/> instance; optionally
        /// allowing an unparseable resource name.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item><description><c>projects/{project}/locations/{location}/agents/{agent}</c></description></item>
        /// </list>
        /// Or may be in any format if <paramref name="allowUnparsed"/> is <c>true</c>.
        /// </remarks>
        /// <param name="dialogflowAgentName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <param name="allowUnparsed">
        /// If <c>true</c> will successfully store an unparseable resource name into the <see cref="UnparsedResource"/>
        /// property; otherwise will throw an <see cref="sys::ArgumentException"/> if an unparseable resource name is
        /// specified.
        /// </param>
        /// <returns>The parsed <see cref="DialogflowAgentName"/> if successful.</returns>
        public static DialogflowAgentName Parse(string dialogflowAgentName, bool allowUnparsed) =>
            TryParse(dialogflowAgentName, allowUnparsed, out DialogflowAgentName result) ? result : throw new sys::ArgumentException("The given resource-name matches no pattern.");

        /// <summary>
        /// Tries to parse the given resource name string into a new <see cref="DialogflowAgentName"/> instance.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item><description><c>projects/{project}/locations/{location}/agents/{agent}</c></description></item>
        /// </list>
        /// </remarks>
        /// <param name="dialogflowAgentName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <param name="result">
        /// When this method returns, the parsed <see cref="DialogflowAgentName"/>, or <c>null</c> if parsing failed.
        /// </param>
        /// <returns><c>true</c> if the name was parsed successfully; <c>false</c> otherwise.</returns>
        public static bool TryParse(string dialogflowAgentName, out DialogflowAgentName result) =>
            TryParse(dialogflowAgentName, false, out result);

        /// <summary>
        /// Tries to parse the given resource name string into a new <see cref="DialogflowAgentName"/> instance;
        /// optionally allowing an unparseable resource name.
        /// </summary>
        /// <remarks>
        /// To parse successfully, the resource name must be formatted as one of the following:
        /// <list type="bullet">
        /// <item><description><c>projects/{project}/locations/{location}/agents/{agent}</c></description></item>
        /// </list>
        /// Or may be in any format if <paramref name="allowUnparsed"/> is <c>true</c>.
        /// </remarks>
        /// <param name="dialogflowAgentName">The resource name in string form. Must not be <c>null</c>.</param>
        /// <param name="allowUnparsed">
        /// If <c>true</c> will successfully store an unparseable resource name into the <see cref="UnparsedResource"/>
        /// property; otherwise will throw an <see cref="sys::ArgumentException"/> if an unparseable resource name is
        /// specified.
        /// </param>
        /// <param name="result">
        /// When this method returns, the parsed <see cref="DialogflowAgentName"/>, or <c>null</c> if parsing failed.
        /// </param>
        /// <returns><c>true</c> if the name was parsed successfully; <c>false</c> otherwise.</returns>
        public static bool TryParse(string dialogflowAgentName, bool allowUnparsed, out DialogflowAgentName result)
        {
            gax::GaxPreconditions.CheckNotNull(dialogflowAgentName, nameof(dialogflowAgentName));
            gax::TemplatedResourceName resourceName;
            if (s_projectLocationAgent.TryParseName(dialogflowAgentName, out resourceName))
            {
                result = FromProjectLocationAgent(resourceName[0], resourceName[1], resourceName[2]);
                return true;
            }
            if (allowUnparsed)
            {
                if (gax::UnparsedResourceName.TryParse(dialogflowAgentName, out gax::UnparsedResourceName unparsedResourceName))
                {
                    result = FromUnparsed(unparsedResourceName);
                    return true;
                }
            }
            result = null;
            return false;
        }

        private DialogflowAgentName(ResourceNameType type, gax::UnparsedResourceName unparsedResourceName = null, string agentId = null, string locationId = null, string projectId = null)
        {
            Type = type;
            UnparsedResource = unparsedResourceName;
            AgentId = agentId;
            LocationId = locationId;
            ProjectId = projectId;
        }

        /// <summary>
        /// Constructs a new instance of a <see cref="DialogflowAgentName"/> class from the component parts of pattern
        /// <c>projects/{project}/locations/{location}/agents/{agent}</c>
        /// </summary>
        /// <param name="projectId">The <c>Project</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="locationId">The <c>Location</c> ID. Must not be <c>null</c> or empty.</param>
        /// <param name="agentId">The <c>Agent</c> ID. Must not be <c>null</c> or empty.</param>
        public DialogflowAgentName(string projectId, string locationId, string agentId) : this(ResourceNameType.ProjectLocationAgent, projectId: gax::GaxPreconditions.CheckNotNullOrEmpty(projectId, nameof(projectId)), locationId: gax::GaxPreconditions.CheckNotNullOrEmpty(locationId, nameof(locationId)), agentId: gax::GaxPreconditions.CheckNotNullOrEmpty(agentId, nameof(agentId)))
        {
        }

        /// <summary>The <see cref="ResourceNameType"/> of the contained resource name.</summary>
        public ResourceNameType Type { get; }

        /// <summary>
        /// The contained <see cref="gax::UnparsedResourceName"/>. Only non-<c>null</c> if this instance contains an
        /// unparsed resource name.
        /// </summary>
        public gax::UnparsedResourceName UnparsedResource { get; }

        /// <summary>
        /// The <c>Agent</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string AgentId { get; }

        /// <summary>
        /// The <c>Location</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string LocationId { get; }

        /// <summary>
        /// The <c>Project</c> ID. Will not be <c>null</c>, unless this instance contains an unparsed resource name.
        /// </summary>
        public string ProjectId { get; }

        /// <summary>Whether this instance contains a resource name with a known pattern.</summary>
        public bool IsKnownPattern => Type != ResourceNameType.Unparsed;

        /// <summary>The string representation of the resource name.</summary>
        /// <returns>The string representation of the resource name.</returns>
        public override string ToString()
        {
            switch (Type)
            {
                case ResourceNameType.Unparsed: return UnparsedResource.ToString();
                case ResourceNameType.ProjectLocationAgent: return s_projectLocationAgent.Expand(ProjectId, LocationId, AgentId);
                default: throw new sys::InvalidOperationException("Unrecognized resource-type.");
            }
        }

        /// <summary>Returns a hash code for this resource name.</summary>
        public override int GetHashCode() => ToString().GetHashCode();

        /// <inheritdoc/>
        public override bool Equals(object obj) => Equals(obj as DialogflowAgentName);

        /// <inheritdoc/>
        public bool Equals(DialogflowAgentName other) => ToString() == other?.ToString();

        /// <summary>Determines whether two specified resource names have the same value.</summary>
        /// <param name="a">The first resource name to compare, or null.</param>
        /// <param name="b">The second resource name to compare, or null.</param>
        /// <returns>
        /// true if the value of <paramref name="a"/> is the same as the value of <paramref name="b"/>; otherwise,
        /// false.
        /// </returns>
        public static bool operator ==(DialogflowAgentName a, DialogflowAgentName b) => ReferenceEquals(a, b) || (a?.Equals(b) ?? false);

        /// <summary>Determines whether two specified resource names have different values.</summary>
        /// <param name="a">The first resource name to compare, or null.</param>
        /// <param name="b">The second resource name to compare, or null.</param>
        /// <returns>
        /// true if the value of <paramref name="a"/> is different from the value of <paramref name="b"/>; otherwise,
        /// false.
        /// </returns>
        public static bool operator !=(DialogflowAgentName a, DialogflowAgentName b) => !(a == b);
    }

    public partial class Agent
    {
        /// <summary>
        /// <see cref="gccv::AgentName"/>-typed view over the <see cref="Name"/> resource name property.
        /// </summary>
        public gccv::AgentName AgentName
        {
            get => string.IsNullOrEmpty(Name) ? null : gccv::AgentName.Parse(Name, allowUnparsed: true);
            set => Name = value?.ToString() ?? "";
        }

        /// <summary><see cref="ToolName"/>-typed view over the <see cref="Tools"/> resource name property.</summary>
        public gax::ResourceNameList<ToolName> ToolsAsToolNames
        {
            get => new gax::ResourceNameList<ToolName>(Tools, s => string.IsNullOrEmpty(s) ? null : ToolName.Parse(s, allowUnparsed: true));
        }

        /// <summary>
        /// <see cref="gccv::AgentName"/>-typed view over the <see cref="ChildAgents"/> resource name property.
        /// </summary>
        public gax::ResourceNameList<gccv::AgentName> ChildAgentsAsAgentNames
        {
            get => new gax::ResourceNameList<gccv::AgentName>(ChildAgents, s => string.IsNullOrEmpty(s) ? null : gccv::AgentName.Parse(s, allowUnparsed: true));
        }

        /// <summary>
        /// <see cref="GuardrailName"/>-typed view over the <see cref="Guardrails"/> resource name property.
        /// </summary>
        public gax::ResourceNameList<GuardrailName> GuardrailsAsGuardrailNames
        {
            get => new gax::ResourceNameList<GuardrailName>(Guardrails, s => string.IsNullOrEmpty(s) ? null : GuardrailName.Parse(s, allowUnparsed: true));
        }

        public partial class Types
        {
            public partial class RemoteDialogflowAgent
            {
                /// <summary>
                /// <see cref="DialogflowAgentName"/>-typed view over the <see cref="Agent"/> resource name property.
                /// </summary>
                public DialogflowAgentName AgentAsDialogflowAgentName
                {
                    get => string.IsNullOrEmpty(Agent) ? null : DialogflowAgentName.Parse(Agent, allowUnparsed: true);
                    set => Agent = value?.ToString() ?? "";
                }
            }

            public partial class AgentToolset
            {
                /// <summary>
                /// <see cref="ToolsetName"/>-typed view over the <see cref="Toolset"/> resource name property.
                /// </summary>
                public ToolsetName ToolsetAsToolsetName
                {
                    get => string.IsNullOrEmpty(Toolset) ? null : ToolsetName.Parse(Toolset, allowUnparsed: true);
                    set => Toolset = value?.ToString() ?? "";
                }
            }
        }
    }
}
