/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.ces.v1beta.stub;

import static com.google.cloud.ces.v1beta.ToolServiceClient.ListLocationsPagedResponse;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.ces.v1beta.ExecuteToolRequest;
import com.google.cloud.ces.v1beta.ExecuteToolResponse;
import com.google.cloud.ces.v1beta.RetrieveToolSchemaRequest;
import com.google.cloud.ces.v1beta.RetrieveToolSchemaResponse;
import com.google.cloud.ces.v1beta.RetrieveToolsRequest;
import com.google.cloud.ces.v1beta.RetrieveToolsResponse;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * gRPC stub implementation for the ToolService service API.
 *
 * <p>This class is for advanced usage and reflects the underlying API directly.
 */
@BetaApi
@Generated("by gapic-generator-java")
public class GrpcToolServiceStub extends ToolServiceStub {
  private static final MethodDescriptor<ExecuteToolRequest, ExecuteToolResponse>
      executeToolMethodDescriptor =
          MethodDescriptor.<ExecuteToolRequest, ExecuteToolResponse>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName("google.cloud.ces.v1beta.ToolService/ExecuteTool")
              .setRequestMarshaller(ProtoUtils.marshaller(ExecuteToolRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(ExecuteToolResponse.getDefaultInstance()))
              .setSampledToLocalTracing(true)
              .build();

  private static final MethodDescriptor<RetrieveToolSchemaRequest, RetrieveToolSchemaResponse>
      retrieveToolSchemaMethodDescriptor =
          MethodDescriptor.<RetrieveToolSchemaRequest, RetrieveToolSchemaResponse>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName("google.cloud.ces.v1beta.ToolService/RetrieveToolSchema")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(RetrieveToolSchemaRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(RetrieveToolSchemaResponse.getDefaultInstance()))
              .setSampledToLocalTracing(true)
              .build();

  private static final MethodDescriptor<RetrieveToolsRequest, RetrieveToolsResponse>
      retrieveToolsMethodDescriptor =
          MethodDescriptor.<RetrieveToolsRequest, RetrieveToolsResponse>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName("google.cloud.ces.v1beta.ToolService/RetrieveTools")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(RetrieveToolsRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(RetrieveToolsResponse.getDefaultInstance()))
              .setSampledToLocalTracing(true)
              .build();

  private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse>
      listLocationsMethodDescriptor =
          MethodDescriptor.<ListLocationsRequest, ListLocationsResponse>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName("google.cloud.location.Locations/ListLocations")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(ListLocationsRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(ListLocationsResponse.getDefaultInstance()))
              .setSampledToLocalTracing(true)
              .build();

  private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor =
      MethodDescriptor.<GetLocationRequest, Location>newBuilder()
          .setType(MethodDescriptor.MethodType.UNARY)
          .setFullMethodName("google.cloud.location.Locations/GetLocation")
          .setRequestMarshaller(ProtoUtils.marshaller(GetLocationRequest.getDefaultInstance()))
          .setResponseMarshaller(ProtoUtils.marshaller(Location.getDefaultInstance()))
          .setSampledToLocalTracing(true)
          .build();

  private final UnaryCallable<ExecuteToolRequest, ExecuteToolResponse> executeToolCallable;
  private final UnaryCallable<RetrieveToolSchemaRequest, RetrieveToolSchemaResponse>
      retrieveToolSchemaCallable;
  private final UnaryCallable<RetrieveToolsRequest, RetrieveToolsResponse> retrieveToolsCallable;
  private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
  private final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse>
      listLocationsPagedCallable;
  private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;

  private final BackgroundResource backgroundResources;
  private final GrpcOperationsStub operationsStub;
  private final GrpcStubCallableFactory callableFactory;

  public static final GrpcToolServiceStub create(ToolServiceStubSettings settings)
      throws IOException {
    return new GrpcToolServiceStub(settings, ClientContext.create(settings));
  }

  public static final GrpcToolServiceStub create(ClientContext clientContext) throws IOException {
    return new GrpcToolServiceStub(ToolServiceStubSettings.newBuilder().build(), clientContext);
  }

  public static final GrpcToolServiceStub create(
      ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
    return new GrpcToolServiceStub(
        ToolServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
  }

  /**
   * Constructs an instance of GrpcToolServiceStub, using the given settings. This is protected so
   * that it is easy to make a subclass, but otherwise, the static factory methods should be
   * preferred.
   */
  protected GrpcToolServiceStub(ToolServiceStubSettings settings, ClientContext clientContext)
      throws IOException {
    this(settings, clientContext, new GrpcToolServiceCallableFactory());
  }

  /**
   * Constructs an instance of GrpcToolServiceStub, using the given settings. This is protected so
   * that it is easy to make a subclass, but otherwise, the static factory methods should be
   * preferred.
   */
  protected GrpcToolServiceStub(
      ToolServiceStubSettings settings,
      ClientContext clientContext,
      GrpcStubCallableFactory callableFactory)
      throws IOException {
    this.callableFactory = callableFactory;
    this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);

    GrpcCallSettings<ExecuteToolRequest, ExecuteToolResponse> executeToolTransportSettings =
        GrpcCallSettings.<ExecuteToolRequest, ExecuteToolResponse>newBuilder()
            .setMethodDescriptor(executeToolMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("parent", String.valueOf(request.getParent()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<RetrieveToolSchemaRequest, RetrieveToolSchemaResponse>
        retrieveToolSchemaTransportSettings =
            GrpcCallSettings.<RetrieveToolSchemaRequest, RetrieveToolSchemaResponse>newBuilder()
                .setMethodDescriptor(retrieveToolSchemaMethodDescriptor)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add("parent", String.valueOf(request.getParent()));
                      return builder.build();
                    })
                .build();
    GrpcCallSettings<RetrieveToolsRequest, RetrieveToolsResponse> retrieveToolsTransportSettings =
        GrpcCallSettings.<RetrieveToolsRequest, RetrieveToolsResponse>newBuilder()
            .setMethodDescriptor(retrieveToolsMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("toolset", String.valueOf(request.getToolset()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<ListLocationsRequest, ListLocationsResponse> listLocationsTransportSettings =
        GrpcCallSettings.<ListLocationsRequest, ListLocationsResponse>newBuilder()
            .setMethodDescriptor(listLocationsMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("name", String.valueOf(request.getName()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<GetLocationRequest, Location> getLocationTransportSettings =
        GrpcCallSettings.<GetLocationRequest, Location>newBuilder()
            .setMethodDescriptor(getLocationMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("name", String.valueOf(request.getName()));
                  return builder.build();
                })
            .build();

    this.executeToolCallable =
        callableFactory.createUnaryCallable(
            executeToolTransportSettings, settings.executeToolSettings(), clientContext);
    this.retrieveToolSchemaCallable =
        callableFactory.createUnaryCallable(
            retrieveToolSchemaTransportSettings,
            settings.retrieveToolSchemaSettings(),
            clientContext);
    this.retrieveToolsCallable =
        callableFactory.createUnaryCallable(
            retrieveToolsTransportSettings, settings.retrieveToolsSettings(), clientContext);
    this.listLocationsCallable =
        callableFactory.createUnaryCallable(
            listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
    this.listLocationsPagedCallable =
        callableFactory.createPagedCallable(
            listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
    this.getLocationCallable =
        callableFactory.createUnaryCallable(
            getLocationTransportSettings, settings.getLocationSettings(), clientContext);

    this.backgroundResources =
        new BackgroundResourceAggregation(clientContext.getBackgroundResources());
  }

  public GrpcOperationsStub getOperationsStub() {
    return operationsStub;
  }

  @Override
  public UnaryCallable<ExecuteToolRequest, ExecuteToolResponse> executeToolCallable() {
    return executeToolCallable;
  }

  @Override
  public UnaryCallable<RetrieveToolSchemaRequest, RetrieveToolSchemaResponse>
      retrieveToolSchemaCallable() {
    return retrieveToolSchemaCallable;
  }

  @Override
  public UnaryCallable<RetrieveToolsRequest, RetrieveToolsResponse> retrieveToolsCallable() {
    return retrieveToolsCallable;
  }

  @Override
  public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
    return listLocationsCallable;
  }

  @Override
  public UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse>
      listLocationsPagedCallable() {
    return listLocationsPagedCallable;
  }

  @Override
  public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
    return getLocationCallable;
  }

  @Override
  public final void close() {
    try {
      backgroundResources.close();
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw new IllegalStateException("Failed to close resource", e);
    }
  }

  @Override
  public void shutdown() {
    backgroundResources.shutdown();
  }

  @Override
  public boolean isShutdown() {
    return backgroundResources.isShutdown();
  }

  @Override
  public boolean isTerminated() {
    return backgroundResources.isTerminated();
  }

  @Override
  public void shutdownNow() {
    backgroundResources.shutdownNow();
  }

  @Override
  public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
    return backgroundResources.awaitTermination(duration, unit);
  }
}
