<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1beta/agent.proto

namespace Google\Cloud\Ces\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An agent acts as the fundamental building block that provides instructions to
 * the Large Language Model (LLM) for executing specific tasks.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1beta.Agent</code>
 */
class Agent extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The unique identifier of the agent.
     * Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Display name of the agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Optional. Human-readable description of the agent.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. Configurations for the LLM model.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ModelSettings model_settings = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $model_settings = null;
    /**
     * Optional. Instructions for the LLM model to guide the agent's behavior.
     *
     * Generated from protobuf field <code>string instruction = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $instruction = '';
    /**
     * Optional. List of available tools for the agent.
     * Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
     *
     * Generated from protobuf field <code>repeated string tools = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $tools;
    /**
     * Optional. List of child agents in the agent tree.
     * Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *
     * Generated from protobuf field <code>repeated string child_agents = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $child_agents;
    /**
     * Optional. The callbacks to execute before the agent is called.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback before_agent_callbacks = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $before_agent_callbacks;
    /**
     * Optional. The callbacks to execute after the agent is called.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback after_agent_callbacks = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $after_agent_callbacks;
    /**
     * Optional. The callbacks to execute before the model is called. If there are
     * multiple calls to the model, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback before_model_callbacks = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $before_model_callbacks;
    /**
     * Optional. The callbacks to execute after the model is called. If there are
     * multiple calls to the model, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback after_model_callbacks = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $after_model_callbacks;
    /**
     * Optional. The callbacks to execute before the tool is invoked. If there are
     * multiple tool invocations, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback before_tool_callbacks = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $before_tool_callbacks;
    /**
     * Optional. The callbacks to execute after the tool is invoked. If there are
     * multiple tool invocations, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback after_tool_callbacks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $after_tool_callbacks;
    /**
     * Output only. Timestamp when the agent was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Timestamp when the agent was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. List of guardrails for the agent.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
     *
     * Generated from protobuf field <code>repeated string guardrails = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $guardrails;
    /**
     * Etag used to ensure the object hasn't changed during a read-modify-write
     * operation. If the etag is empty, the update will overwrite any concurrent
     * changes.
     *
     * Generated from protobuf field <code>string etag = 24;</code>
     */
    protected $etag = '';
    /**
     * Optional. List of toolsets for the agent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Agent.AgentToolset toolsets = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $toolsets;
    /**
     * Output only. If the agent is generated by the LLM assistant, this field
     * contains a descriptive summary of the generation.
     *
     * Generated from protobuf field <code>string generated_summary = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $generated_summary = '';
    protected $agent_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Ces\V1beta\Agent\LlmAgent $llm_agent
     *           Optional. The default agent type.
     *     @type \Google\Cloud\Ces\V1beta\Agent\RemoteDialogflowAgent $remote_dialogflow_agent
     *           Optional. The remote
     *           [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
     *           agent to be used for the agent execution. If this field is set, all other
     *           agent level properties will be ignored.
     *           Note: If the Dialogflow agent is in a different project from the app, you
     *           should grant `roles/dialogflow.client` to the CES service agent
     *           `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *     @type string $name
     *           Identifier. The unique identifier of the agent.
     *           Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *     @type string $display_name
     *           Required. Display name of the agent.
     *     @type string $description
     *           Optional. Human-readable description of the agent.
     *     @type \Google\Cloud\Ces\V1beta\ModelSettings $model_settings
     *           Optional. Configurations for the LLM model.
     *     @type string $instruction
     *           Optional. Instructions for the LLM model to guide the agent's behavior.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $tools
     *           Optional. List of available tools for the agent.
     *           Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $child_agents
     *           Optional. List of child agents in the agent tree.
     *           Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *     @type array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $before_agent_callbacks
     *           Optional. The callbacks to execute before the agent is called.
     *           The provided callbacks are executed sequentially in the exact order they
     *           are given in the list. If a callback returns an overridden response,
     *           execution stops and any remaining callbacks are skipped.
     *     @type array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $after_agent_callbacks
     *           Optional. The callbacks to execute after the agent is called.
     *           The provided callbacks are executed sequentially in the exact order they
     *           are given in the list. If a callback returns an overridden response,
     *           execution stops and any remaining callbacks are skipped.
     *     @type array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $before_model_callbacks
     *           Optional. The callbacks to execute before the model is called. If there are
     *           multiple calls to the model, the callback will be executed multiple times.
     *           The provided callbacks are executed sequentially in the exact order they
     *           are given in the list. If a callback returns an overridden response,
     *           execution stops and any remaining callbacks are skipped.
     *     @type array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $after_model_callbacks
     *           Optional. The callbacks to execute after the model is called. If there are
     *           multiple calls to the model, the callback will be executed multiple times.
     *           The provided callbacks are executed sequentially in the exact order they
     *           are given in the list. If a callback returns an overridden response,
     *           execution stops and any remaining callbacks are skipped.
     *     @type array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $before_tool_callbacks
     *           Optional. The callbacks to execute before the tool is invoked. If there are
     *           multiple tool invocations, the callback will be executed multiple times.
     *           The provided callbacks are executed sequentially in the exact order they
     *           are given in the list. If a callback returns an overridden response,
     *           execution stops and any remaining callbacks are skipped.
     *     @type array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $after_tool_callbacks
     *           Optional. The callbacks to execute after the tool is invoked. If there are
     *           multiple tool invocations, the callback will be executed multiple times.
     *           The provided callbacks are executed sequentially in the exact order they
     *           are given in the list. If a callback returns an overridden response,
     *           execution stops and any remaining callbacks are skipped.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp when the agent was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Timestamp when the agent was last updated.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $guardrails
     *           Optional. List of guardrails for the agent.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
     *     @type string $etag
     *           Etag used to ensure the object hasn't changed during a read-modify-write
     *           operation. If the etag is empty, the update will overwrite any concurrent
     *           changes.
     *     @type array<\Google\Cloud\Ces\V1beta\Agent\AgentToolset>|\Google\Protobuf\Internal\RepeatedField $toolsets
     *           Optional. List of toolsets for the agent.
     *     @type string $generated_summary
     *           Output only. If the agent is generated by the LLM assistant, this field
     *           contains a descriptive summary of the generation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1Beta\Agent::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The default agent type.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.Agent.LlmAgent llm_agent = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\Agent\LlmAgent|null
     */
    public function getLlmAgent()
    {
        return $this->readOneof(26);
    }

    public function hasLlmAgent()
    {
        return $this->hasOneof(26);
    }

    /**
     * Optional. The default agent type.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.Agent.LlmAgent llm_agent = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\Agent\LlmAgent $var
     * @return $this
     */
    public function setLlmAgent($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\Agent\LlmAgent::class);
        $this->writeOneof(26, $var);

        return $this;
    }

    /**
     * Optional. The remote
     * [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
     * agent to be used for the agent execution. If this field is set, all other
     * agent level properties will be ignored.
     * Note: If the Dialogflow agent is in a different project from the app, you
     * should grant `roles/dialogflow.client` to the CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.Agent.RemoteDialogflowAgent remote_dialogflow_agent = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\Agent\RemoteDialogflowAgent|null
     */
    public function getRemoteDialogflowAgent()
    {
        return $this->readOneof(27);
    }

    public function hasRemoteDialogflowAgent()
    {
        return $this->hasOneof(27);
    }

    /**
     * Optional. The remote
     * [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
     * agent to be used for the agent execution. If this field is set, all other
     * agent level properties will be ignored.
     * Note: If the Dialogflow agent is in a different project from the app, you
     * should grant `roles/dialogflow.client` to the CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.Agent.RemoteDialogflowAgent remote_dialogflow_agent = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\Agent\RemoteDialogflowAgent $var
     * @return $this
     */
    public function setRemoteDialogflowAgent($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\Agent\RemoteDialogflowAgent::class);
        $this->writeOneof(27, $var);

        return $this;
    }

    /**
     * Identifier. The unique identifier of the agent.
     * Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The unique identifier of the agent.
     * Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Display name of the agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. Display name of the agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. Human-readable description of the agent.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. Human-readable description of the agent.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. Configurations for the LLM model.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ModelSettings model_settings = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\ModelSettings|null
     */
    public function getModelSettings()
    {
        return $this->model_settings;
    }

    public function hasModelSettings()
    {
        return isset($this->model_settings);
    }

    public function clearModelSettings()
    {
        unset($this->model_settings);
    }

    /**
     * Optional. Configurations for the LLM model.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ModelSettings model_settings = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\ModelSettings $var
     * @return $this
     */
    public function setModelSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\ModelSettings::class);
        $this->model_settings = $var;

        return $this;
    }

    /**
     * Optional. Instructions for the LLM model to guide the agent's behavior.
     *
     * Generated from protobuf field <code>string instruction = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getInstruction()
    {
        return $this->instruction;
    }

    /**
     * Optional. Instructions for the LLM model to guide the agent's behavior.
     *
     * Generated from protobuf field <code>string instruction = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setInstruction($var)
    {
        GPBUtil::checkString($var, True);
        $this->instruction = $var;

        return $this;
    }

    /**
     * Optional. List of available tools for the agent.
     * Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
     *
     * Generated from protobuf field <code>repeated string tools = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTools()
    {
        return $this->tools;
    }

    /**
     * Optional. List of available tools for the agent.
     * Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
     *
     * Generated from protobuf field <code>repeated string tools = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTools($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tools = $arr;

        return $this;
    }

    /**
     * Optional. List of child agents in the agent tree.
     * Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *
     * Generated from protobuf field <code>repeated string child_agents = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getChildAgents()
    {
        return $this->child_agents;
    }

    /**
     * Optional. List of child agents in the agent tree.
     * Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *
     * Generated from protobuf field <code>repeated string child_agents = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setChildAgents($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->child_agents = $arr;

        return $this;
    }

    /**
     * Optional. The callbacks to execute before the agent is called.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback before_agent_callbacks = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBeforeAgentCallbacks()
    {
        return $this->before_agent_callbacks;
    }

    /**
     * Optional. The callbacks to execute before the agent is called.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback before_agent_callbacks = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBeforeAgentCallbacks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\Callback::class);
        $this->before_agent_callbacks = $arr;

        return $this;
    }

    /**
     * Optional. The callbacks to execute after the agent is called.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback after_agent_callbacks = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAfterAgentCallbacks()
    {
        return $this->after_agent_callbacks;
    }

    /**
     * Optional. The callbacks to execute after the agent is called.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback after_agent_callbacks = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAfterAgentCallbacks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\Callback::class);
        $this->after_agent_callbacks = $arr;

        return $this;
    }

    /**
     * Optional. The callbacks to execute before the model is called. If there are
     * multiple calls to the model, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback before_model_callbacks = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBeforeModelCallbacks()
    {
        return $this->before_model_callbacks;
    }

    /**
     * Optional. The callbacks to execute before the model is called. If there are
     * multiple calls to the model, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback before_model_callbacks = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBeforeModelCallbacks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\Callback::class);
        $this->before_model_callbacks = $arr;

        return $this;
    }

    /**
     * Optional. The callbacks to execute after the model is called. If there are
     * multiple calls to the model, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback after_model_callbacks = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAfterModelCallbacks()
    {
        return $this->after_model_callbacks;
    }

    /**
     * Optional. The callbacks to execute after the model is called. If there are
     * multiple calls to the model, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback after_model_callbacks = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAfterModelCallbacks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\Callback::class);
        $this->after_model_callbacks = $arr;

        return $this;
    }

    /**
     * Optional. The callbacks to execute before the tool is invoked. If there are
     * multiple tool invocations, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback before_tool_callbacks = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBeforeToolCallbacks()
    {
        return $this->before_tool_callbacks;
    }

    /**
     * Optional. The callbacks to execute before the tool is invoked. If there are
     * multiple tool invocations, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback before_tool_callbacks = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBeforeToolCallbacks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\Callback::class);
        $this->before_tool_callbacks = $arr;

        return $this;
    }

    /**
     * Optional. The callbacks to execute after the tool is invoked. If there are
     * multiple tool invocations, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback after_tool_callbacks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAfterToolCallbacks()
    {
        return $this->after_tool_callbacks;
    }

    /**
     * Optional. The callbacks to execute after the tool is invoked. If there are
     * multiple tool invocations, the callback will be executed multiple times.
     * The provided callbacks are executed sequentially in the exact order they
     * are given in the list. If a callback returns an overridden response,
     * execution stops and any remaining callbacks are skipped.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Callback after_tool_callbacks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1beta\Callback>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAfterToolCallbacks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\Callback::class);
        $this->after_tool_callbacks = $arr;

        return $this;
    }

    /**
     * Output only. Timestamp when the agent was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp when the agent was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when the agent was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Timestamp when the agent was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. List of guardrails for the agent.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
     *
     * Generated from protobuf field <code>repeated string guardrails = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuardrails()
    {
        return $this->guardrails;
    }

    /**
     * Optional. List of guardrails for the agent.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
     *
     * Generated from protobuf field <code>repeated string guardrails = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuardrails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->guardrails = $arr;

        return $this;
    }

    /**
     * Etag used to ensure the object hasn't changed during a read-modify-write
     * operation. If the etag is empty, the update will overwrite any concurrent
     * changes.
     *
     * Generated from protobuf field <code>string etag = 24;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Etag used to ensure the object hasn't changed during a read-modify-write
     * operation. If the etag is empty, the update will overwrite any concurrent
     * changes.
     *
     * Generated from protobuf field <code>string etag = 24;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Optional. List of toolsets for the agent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Agent.AgentToolset toolsets = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getToolsets()
    {
        return $this->toolsets;
    }

    /**
     * Optional. List of toolsets for the agent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.Agent.AgentToolset toolsets = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1beta\Agent\AgentToolset>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setToolsets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\Agent\AgentToolset::class);
        $this->toolsets = $arr;

        return $this;
    }

    /**
     * Output only. If the agent is generated by the LLM assistant, this field
     * contains a descriptive summary of the generation.
     *
     * Generated from protobuf field <code>string generated_summary = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getGeneratedSummary()
    {
        return $this->generated_summary;
    }

    /**
     * Output only. If the agent is generated by the LLM assistant, this field
     * contains a descriptive summary of the generation.
     *
     * Generated from protobuf field <code>string generated_summary = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setGeneratedSummary($var)
    {
        GPBUtil::checkString($var, True);
        $this->generated_summary = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getAgentType()
    {
        return $this->whichOneof("agent_type");
    }

}

