<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1beta/app.proto

namespace Google\Cloud\Ces\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An app serves as a top-level container for a group of agents, including the
 * root agent and its sub-agents, along with their associated configurations.
 * These agents work together to achieve specific goals within the app's
 * context.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1beta.App</code>
 */
class App extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The unique identifier of the app.
     * Format: `projects/{project}/locations/{location}/apps/{app}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Display name of the app.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Optional. Human-readable description of the app.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. Whether the app is pinned in the app list.
     *
     * Generated from protobuf field <code>bool pinned = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $pinned = false;
    /**
     * Optional. The root agent is the entry point of the app.
     * Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *
     * Generated from protobuf field <code>string root_agent = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $root_agent = '';
    /**
     * Optional. Language settings of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.LanguageSettings language_settings = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $language_settings = null;
    /**
     * Optional. TimeZone settings of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.TimeZoneSettings time_zone_settings = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $time_zone_settings = null;
    /**
     * Optional. Audio processing configuration of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.AudioProcessingConfig audio_processing_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $audio_processing_config = null;
    /**
     * Optional. Logging settings of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.LoggingSettings logging_settings = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $logging_settings = null;
    /**
     * Optional. The default LLM model settings for the app.
     * Individual resources (e.g. agents, guardrails) can override these
     * configurations as needed.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ModelSettings model_settings = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $model_settings = null;
    /**
     * Optional. The tool execution mode for the app. If not provided, will
     * default to PARALLEL.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.App.ToolExecutionMode tool_execution_mode = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $tool_execution_mode = 0;
    /**
     * Optional. The evaluation thresholds for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationMetricsThresholds evaluation_metrics_thresholds = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $evaluation_metrics_thresholds = null;
    /**
     * Optional. The declarations of the variables.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.App.VariableDeclaration variable_declarations = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $variable_declarations;
    /**
     * Output only. The declarations of predefined variables for the app.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.App.VariableDeclaration predefined_variable_declarations = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $predefined_variable_declarations;
    /**
     * Optional. Instructions for all the agents in the app.
     * You can use this instruction to set up a stable identity or personality
     * across all the agents.
     *
     * Generated from protobuf field <code>string global_instruction = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $global_instruction = '';
    /**
     * Optional. List of guardrails for the app.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
     *
     * Generated from protobuf field <code>repeated string guardrails = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $guardrails;
    /**
     * Optional. The data store settings for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.DataStoreSettings data_store_settings = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $data_store_settings = null;
    /**
     * Optional. The default channel profile used by the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ChannelProfile default_channel_profile = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $default_channel_profile = null;
    /**
     * Optional. Metadata about the app. This field can be used to store
     * additional information relevant to the app's details or intended usages.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $metadata;
    /**
     * Output only. Timestamp when the app was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Timestamp when the app was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. Etag used to ensure the object hasn't changed during a
     * read-modify-write operation. If the etag is empty, the update will
     * overwrite any concurrent changes.
     *
     * Generated from protobuf field <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $etag = '';
    /**
     * Output only. Number of deployments in the app.
     *
     * Generated from protobuf field <code>int32 deployment_count = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $deployment_count = 0;
    /**
     * Optional. The default client certificate settings for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ClientCertificateSettings client_certificate_settings = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $client_certificate_settings = null;
    /**
     * Optional. The evaluation personas for the app. This field is used to define
     * the personas that can be used for evaluation. Maximum of 30 personas can be
     * defined.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.EvaluationPersona evaluation_personas = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $evaluation_personas;
    /**
     * Optional. The evaluation settings for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationSettings evaluation_settings = 33 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $evaluation_settings = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The unique identifier of the app.
     *           Format: `projects/{project}/locations/{location}/apps/{app}`
     *     @type string $display_name
     *           Required. Display name of the app.
     *     @type string $description
     *           Optional. Human-readable description of the app.
     *     @type bool $pinned
     *           Optional. Whether the app is pinned in the app list.
     *     @type string $root_agent
     *           Optional. The root agent is the entry point of the app.
     *           Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *     @type \Google\Cloud\Ces\V1beta\LanguageSettings $language_settings
     *           Optional. Language settings of the app.
     *     @type \Google\Cloud\Ces\V1beta\TimeZoneSettings $time_zone_settings
     *           Optional. TimeZone settings of the app.
     *     @type \Google\Cloud\Ces\V1beta\AudioProcessingConfig $audio_processing_config
     *           Optional. Audio processing configuration of the app.
     *     @type \Google\Cloud\Ces\V1beta\LoggingSettings $logging_settings
     *           Optional. Logging settings of the app.
     *     @type \Google\Cloud\Ces\V1beta\ModelSettings $model_settings
     *           Optional. The default LLM model settings for the app.
     *           Individual resources (e.g. agents, guardrails) can override these
     *           configurations as needed.
     *     @type int $tool_execution_mode
     *           Optional. The tool execution mode for the app. If not provided, will
     *           default to PARALLEL.
     *     @type \Google\Cloud\Ces\V1beta\EvaluationMetricsThresholds $evaluation_metrics_thresholds
     *           Optional. The evaluation thresholds for the app.
     *     @type array<\Google\Cloud\Ces\V1beta\App\VariableDeclaration>|\Google\Protobuf\Internal\RepeatedField $variable_declarations
     *           Optional. The declarations of the variables.
     *     @type array<\Google\Cloud\Ces\V1beta\App\VariableDeclaration>|\Google\Protobuf\Internal\RepeatedField $predefined_variable_declarations
     *           Output only. The declarations of predefined variables for the app.
     *     @type string $global_instruction
     *           Optional. Instructions for all the agents in the app.
     *           You can use this instruction to set up a stable identity or personality
     *           across all the agents.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $guardrails
     *           Optional. List of guardrails for the app.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
     *     @type \Google\Cloud\Ces\V1beta\DataStoreSettings $data_store_settings
     *           Optional. The data store settings for the app.
     *     @type \Google\Cloud\Ces\V1beta\ChannelProfile $default_channel_profile
     *           Optional. The default channel profile used by the app.
     *     @type array|\Google\Protobuf\Internal\MapField $metadata
     *           Optional. Metadata about the app. This field can be used to store
     *           additional information relevant to the app's details or intended usages.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp when the app was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Timestamp when the app was last updated.
     *     @type string $etag
     *           Output only. Etag used to ensure the object hasn't changed during a
     *           read-modify-write operation. If the etag is empty, the update will
     *           overwrite any concurrent changes.
     *     @type int $deployment_count
     *           Output only. Number of deployments in the app.
     *     @type \Google\Cloud\Ces\V1beta\ClientCertificateSettings $client_certificate_settings
     *           Optional. The default client certificate settings for the app.
     *     @type array<\Google\Cloud\Ces\V1beta\EvaluationPersona>|\Google\Protobuf\Internal\RepeatedField $evaluation_personas
     *           Optional. The evaluation personas for the app. This field is used to define
     *           the personas that can be used for evaluation. Maximum of 30 personas can be
     *           defined.
     *     @type \Google\Cloud\Ces\V1beta\EvaluationSettings $evaluation_settings
     *           Optional. The evaluation settings for the app.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1Beta\App::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The unique identifier of the app.
     * Format: `projects/{project}/locations/{location}/apps/{app}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The unique identifier of the app.
     * Format: `projects/{project}/locations/{location}/apps/{app}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Display name of the app.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. Display name of the app.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. Human-readable description of the app.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. Human-readable description of the app.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. Whether the app is pinned in the app list.
     *
     * Generated from protobuf field <code>bool pinned = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getPinned()
    {
        return $this->pinned;
    }

    /**
     * Optional. Whether the app is pinned in the app list.
     *
     * Generated from protobuf field <code>bool pinned = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setPinned($var)
    {
        GPBUtil::checkBool($var);
        $this->pinned = $var;

        return $this;
    }

    /**
     * Optional. The root agent is the entry point of the app.
     * Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *
     * Generated from protobuf field <code>string root_agent = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getRootAgent()
    {
        return $this->root_agent;
    }

    /**
     * Optional. The root agent is the entry point of the app.
     * Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
     *
     * Generated from protobuf field <code>string root_agent = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setRootAgent($var)
    {
        GPBUtil::checkString($var, True);
        $this->root_agent = $var;

        return $this;
    }

    /**
     * Optional. Language settings of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.LanguageSettings language_settings = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\LanguageSettings|null
     */
    public function getLanguageSettings()
    {
        return $this->language_settings;
    }

    public function hasLanguageSettings()
    {
        return isset($this->language_settings);
    }

    public function clearLanguageSettings()
    {
        unset($this->language_settings);
    }

    /**
     * Optional. Language settings of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.LanguageSettings language_settings = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\LanguageSettings $var
     * @return $this
     */
    public function setLanguageSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\LanguageSettings::class);
        $this->language_settings = $var;

        return $this;
    }

    /**
     * Optional. TimeZone settings of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.TimeZoneSettings time_zone_settings = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\TimeZoneSettings|null
     */
    public function getTimeZoneSettings()
    {
        return $this->time_zone_settings;
    }

    public function hasTimeZoneSettings()
    {
        return isset($this->time_zone_settings);
    }

    public function clearTimeZoneSettings()
    {
        unset($this->time_zone_settings);
    }

    /**
     * Optional. TimeZone settings of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.TimeZoneSettings time_zone_settings = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\TimeZoneSettings $var
     * @return $this
     */
    public function setTimeZoneSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\TimeZoneSettings::class);
        $this->time_zone_settings = $var;

        return $this;
    }

    /**
     * Optional. Audio processing configuration of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.AudioProcessingConfig audio_processing_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\AudioProcessingConfig|null
     */
    public function getAudioProcessingConfig()
    {
        return $this->audio_processing_config;
    }

    public function hasAudioProcessingConfig()
    {
        return isset($this->audio_processing_config);
    }

    public function clearAudioProcessingConfig()
    {
        unset($this->audio_processing_config);
    }

    /**
     * Optional. Audio processing configuration of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.AudioProcessingConfig audio_processing_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\AudioProcessingConfig $var
     * @return $this
     */
    public function setAudioProcessingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\AudioProcessingConfig::class);
        $this->audio_processing_config = $var;

        return $this;
    }

    /**
     * Optional. Logging settings of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.LoggingSettings logging_settings = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\LoggingSettings|null
     */
    public function getLoggingSettings()
    {
        return $this->logging_settings;
    }

    public function hasLoggingSettings()
    {
        return isset($this->logging_settings);
    }

    public function clearLoggingSettings()
    {
        unset($this->logging_settings);
    }

    /**
     * Optional. Logging settings of the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.LoggingSettings logging_settings = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\LoggingSettings $var
     * @return $this
     */
    public function setLoggingSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\LoggingSettings::class);
        $this->logging_settings = $var;

        return $this;
    }

    /**
     * Optional. The default LLM model settings for the app.
     * Individual resources (e.g. agents, guardrails) can override these
     * configurations as needed.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ModelSettings model_settings = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\ModelSettings|null
     */
    public function getModelSettings()
    {
        return $this->model_settings;
    }

    public function hasModelSettings()
    {
        return isset($this->model_settings);
    }

    public function clearModelSettings()
    {
        unset($this->model_settings);
    }

    /**
     * Optional. The default LLM model settings for the app.
     * Individual resources (e.g. agents, guardrails) can override these
     * configurations as needed.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ModelSettings model_settings = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\ModelSettings $var
     * @return $this
     */
    public function setModelSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\ModelSettings::class);
        $this->model_settings = $var;

        return $this;
    }

    /**
     * Optional. The tool execution mode for the app. If not provided, will
     * default to PARALLEL.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.App.ToolExecutionMode tool_execution_mode = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getToolExecutionMode()
    {
        return $this->tool_execution_mode;
    }

    /**
     * Optional. The tool execution mode for the app. If not provided, will
     * default to PARALLEL.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.App.ToolExecutionMode tool_execution_mode = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setToolExecutionMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ces\V1beta\App\ToolExecutionMode::class);
        $this->tool_execution_mode = $var;

        return $this;
    }

    /**
     * Optional. The evaluation thresholds for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationMetricsThresholds evaluation_metrics_thresholds = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationMetricsThresholds|null
     */
    public function getEvaluationMetricsThresholds()
    {
        return $this->evaluation_metrics_thresholds;
    }

    public function hasEvaluationMetricsThresholds()
    {
        return isset($this->evaluation_metrics_thresholds);
    }

    public function clearEvaluationMetricsThresholds()
    {
        unset($this->evaluation_metrics_thresholds);
    }

    /**
     * Optional. The evaluation thresholds for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationMetricsThresholds evaluation_metrics_thresholds = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationMetricsThresholds $var
     * @return $this
     */
    public function setEvaluationMetricsThresholds($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationMetricsThresholds::class);
        $this->evaluation_metrics_thresholds = $var;

        return $this;
    }

    /**
     * Optional. The declarations of the variables.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.App.VariableDeclaration variable_declarations = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVariableDeclarations()
    {
        return $this->variable_declarations;
    }

    /**
     * Optional. The declarations of the variables.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.App.VariableDeclaration variable_declarations = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1beta\App\VariableDeclaration>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVariableDeclarations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\App\VariableDeclaration::class);
        $this->variable_declarations = $arr;

        return $this;
    }

    /**
     * Output only. The declarations of predefined variables for the app.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.App.VariableDeclaration predefined_variable_declarations = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPredefinedVariableDeclarations()
    {
        return $this->predefined_variable_declarations;
    }

    /**
     * Output only. The declarations of predefined variables for the app.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.App.VariableDeclaration predefined_variable_declarations = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Ces\V1beta\App\VariableDeclaration>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPredefinedVariableDeclarations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\App\VariableDeclaration::class);
        $this->predefined_variable_declarations = $arr;

        return $this;
    }

    /**
     * Optional. Instructions for all the agents in the app.
     * You can use this instruction to set up a stable identity or personality
     * across all the agents.
     *
     * Generated from protobuf field <code>string global_instruction = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getGlobalInstruction()
    {
        return $this->global_instruction;
    }

    /**
     * Optional. Instructions for all the agents in the app.
     * You can use this instruction to set up a stable identity or personality
     * across all the agents.
     *
     * Generated from protobuf field <code>string global_instruction = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setGlobalInstruction($var)
    {
        GPBUtil::checkString($var, True);
        $this->global_instruction = $var;

        return $this;
    }

    /**
     * Optional. List of guardrails for the app.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
     *
     * Generated from protobuf field <code>repeated string guardrails = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuardrails()
    {
        return $this->guardrails;
    }

    /**
     * Optional. List of guardrails for the app.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
     *
     * Generated from protobuf field <code>repeated string guardrails = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuardrails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->guardrails = $arr;

        return $this;
    }

    /**
     * Optional. The data store settings for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.DataStoreSettings data_store_settings = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\DataStoreSettings|null
     */
    public function getDataStoreSettings()
    {
        return $this->data_store_settings;
    }

    public function hasDataStoreSettings()
    {
        return isset($this->data_store_settings);
    }

    public function clearDataStoreSettings()
    {
        unset($this->data_store_settings);
    }

    /**
     * Optional. The data store settings for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.DataStoreSettings data_store_settings = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\DataStoreSettings $var
     * @return $this
     */
    public function setDataStoreSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\DataStoreSettings::class);
        $this->data_store_settings = $var;

        return $this;
    }

    /**
     * Optional. The default channel profile used by the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ChannelProfile default_channel_profile = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\ChannelProfile|null
     */
    public function getDefaultChannelProfile()
    {
        return $this->default_channel_profile;
    }

    public function hasDefaultChannelProfile()
    {
        return isset($this->default_channel_profile);
    }

    public function clearDefaultChannelProfile()
    {
        unset($this->default_channel_profile);
    }

    /**
     * Optional. The default channel profile used by the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ChannelProfile default_channel_profile = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\ChannelProfile $var
     * @return $this
     */
    public function setDefaultChannelProfile($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\ChannelProfile::class);
        $this->default_channel_profile = $var;

        return $this;
    }

    /**
     * Optional. Metadata about the app. This field can be used to store
     * additional information relevant to the app's details or intended usages.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * Optional. Metadata about the app. This field can be used to store
     * additional information relevant to the app's details or intended usages.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMetadata($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata = $arr;

        return $this;
    }

    /**
     * Output only. Timestamp when the app was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp when the app was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when the app was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Timestamp when the app was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Etag used to ensure the object hasn't changed during a
     * read-modify-write operation. If the etag is empty, the update will
     * overwrite any concurrent changes.
     *
     * Generated from protobuf field <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Output only. Etag used to ensure the object hasn't changed during a
     * read-modify-write operation. If the etag is empty, the update will
     * overwrite any concurrent changes.
     *
     * Generated from protobuf field <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Output only. Number of deployments in the app.
     *
     * Generated from protobuf field <code>int32 deployment_count = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getDeploymentCount()
    {
        return $this->deployment_count;
    }

    /**
     * Output only. Number of deployments in the app.
     *
     * Generated from protobuf field <code>int32 deployment_count = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDeploymentCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->deployment_count = $var;

        return $this;
    }

    /**
     * Optional. The default client certificate settings for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ClientCertificateSettings client_certificate_settings = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\ClientCertificateSettings|null
     */
    public function getClientCertificateSettings()
    {
        return $this->client_certificate_settings;
    }

    public function hasClientCertificateSettings()
    {
        return isset($this->client_certificate_settings);
    }

    public function clearClientCertificateSettings()
    {
        unset($this->client_certificate_settings);
    }

    /**
     * Optional. The default client certificate settings for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.ClientCertificateSettings client_certificate_settings = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\ClientCertificateSettings $var
     * @return $this
     */
    public function setClientCertificateSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\ClientCertificateSettings::class);
        $this->client_certificate_settings = $var;

        return $this;
    }

    /**
     * Optional. The evaluation personas for the app. This field is used to define
     * the personas that can be used for evaluation. Maximum of 30 personas can be
     * defined.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.EvaluationPersona evaluation_personas = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEvaluationPersonas()
    {
        return $this->evaluation_personas;
    }

    /**
     * Optional. The evaluation personas for the app. This field is used to define
     * the personas that can be used for evaluation. Maximum of 30 personas can be
     * defined.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.EvaluationPersona evaluation_personas = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Ces\V1beta\EvaluationPersona>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEvaluationPersonas($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\EvaluationPersona::class);
        $this->evaluation_personas = $arr;

        return $this;
    }

    /**
     * Optional. The evaluation settings for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationSettings evaluation_settings = 33 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationSettings|null
     */
    public function getEvaluationSettings()
    {
        return $this->evaluation_settings;
    }

    public function hasEvaluationSettings()
    {
        return isset($this->evaluation_settings);
    }

    public function clearEvaluationSettings()
    {
        unset($this->evaluation_settings);
    }

    /**
     * Optional. The evaluation settings for the app.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationSettings evaluation_settings = 33 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationSettings $var
     * @return $this
     */
    public function setEvaluationSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationSettings::class);
        $this->evaluation_settings = $var;

        return $this;
    }

}

