<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1beta/bigquery_export.proto

namespace Google\Cloud\Ces\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Settings to describe the BigQuery export behaviors for the app.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1beta.BigQueryExportSettings</code>
 */
class BigQueryExportSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Indicates whether the BigQuery export is enabled.
     *
     * Generated from protobuf field <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enabled = false;
    /**
     * Optional. The project ID of the BigQuery dataset to export the data to.
     * Note: If the BigQuery dataset is in a different project from the app,
     * you should grant `roles/bigquery.admin` role to the CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $project = '';
    /**
     * Optional. The BigQuery dataset to export the data to.
     *
     * Generated from protobuf field <code>string dataset = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $dataset = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enabled
     *           Optional. Indicates whether the BigQuery export is enabled.
     *     @type string $project
     *           Optional. The project ID of the BigQuery dataset to export the data to.
     *           Note: If the BigQuery dataset is in a different project from the app,
     *           you should grant `roles/bigquery.admin` role to the CES service agent
     *           `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *     @type string $dataset
     *           Optional. The BigQuery dataset to export the data to.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1Beta\BigqueryExport::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Indicates whether the BigQuery export is enabled.
     *
     * Generated from protobuf field <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * Optional. Indicates whether the BigQuery export is enabled.
     *
     * Generated from protobuf field <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->enabled = $var;

        return $this;
    }

    /**
     * Optional. The project ID of the BigQuery dataset to export the data to.
     * Note: If the BigQuery dataset is in a different project from the app,
     * you should grant `roles/bigquery.admin` role to the CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * Optional. The project ID of the BigQuery dataset to export the data to.
     * Note: If the BigQuery dataset is in a different project from the app,
     * you should grant `roles/bigquery.admin` role to the CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * Optional. The BigQuery dataset to export the data to.
     *
     * Generated from protobuf field <code>string dataset = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDataset()
    {
        return $this->dataset;
    }

    /**
     * Optional. The BigQuery dataset to export the data to.
     *
     * Generated from protobuf field <code>string dataset = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDataset($var)
    {
        GPBUtil::checkString($var, True);
        $this->dataset = $var;

        return $this;
    }

}

