<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1beta/evaluation.proto

namespace Google\Cloud\Ces\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An evaluation result represents the output of running an Evaluation.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1beta.EvaluationResult</code>
 */
class EvaluationResult extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The unique identifier of the evaluation result.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Display name of the Evaluation Result. Unique within an
     * Evaluation. By default, it has the following format:
     * "<evaluation-display-name> result
     * - <timestamp>".
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Output only. Timestamp when the evaluation result was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The outcome of the evaluation. Only populated if
     * execution_state is COMPLETE.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.Outcome evaluation_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $evaluation_status = 0;
    /**
     * Output only. The evaluation run that produced this result.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
     *
     * Generated from protobuf field <code>string evaluation_run = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $evaluation_run = '';
    /**
     * Output only. The persona used to generate the conversation for the
     * evaluation result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationPersona persona = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $persona = null;
    /**
     * Output only. Error information for the evaluation result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationErrorInfo error_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $error_info = null;
    /**
     * Output only. Deprecated: Use `error_info` instead. Errors encountered
     * during execution.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 14 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @deprecated
     */
    protected $error = null;
    /**
     * Output only. The user who initiated the evaluation run that resulted in
     * this result.
     *
     * Generated from protobuf field <code>string initiated_by = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $initiated_by = '';
    /**
     * Output only. The app version used to generate the conversation that
     * resulted in this result. Format:
     * `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
     *
     * Generated from protobuf field <code>string app_version = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $app_version = '';
    /**
     * Output only. The display name of the `app_version` that the evaluation ran
     * against.
     *
     * Generated from protobuf field <code>string app_version_display_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $app_version_display_name = '';
    /**
     * Output only. The changelog of the app version that the evaluation ran
     * against. This is populated if user runs evaluation on latest/draft.
     *
     * Generated from protobuf field <code>string changelog = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $changelog = '';
    /**
     * Output only. The create time of the changelog of the app version that the
     * evaluation ran against. This is populated if user runs evaluation on
     * latest/draft.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp changelog_create_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $changelog_create_time = null;
    /**
     * Output only. The state of the evaluation result execution.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.ExecutionState execution_state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $execution_state = 0;
    /**
     * Output only. The evaluation thresholds for the result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationMetricsThresholds evaluation_metrics_thresholds = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $evaluation_metrics_thresholds = null;
    /**
     * Output only. The configuration used in the evaluation run that resulted in
     * this result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationConfig config = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $config = null;
    /**
     * Output only. The method used to run the golden evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.GoldenRunMethod golden_run_method = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $golden_run_method = 0;
    protected $result;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Ces\V1beta\EvaluationResult\GoldenResult $golden_result
     *           Output only. The outcome of a golden evaluation.
     *     @type \Google\Cloud\Ces\V1beta\EvaluationResult\ScenarioResult $scenario_result
     *           Output only. The outcome of a scenario evaluation.
     *     @type string $name
     *           Identifier. The unique identifier of the evaluation result.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
     *     @type string $display_name
     *           Required. Display name of the Evaluation Result. Unique within an
     *           Evaluation. By default, it has the following format:
     *           "<evaluation-display-name> result
     *           - <timestamp>".
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp when the evaluation result was created.
     *     @type int $evaluation_status
     *           Output only. The outcome of the evaluation. Only populated if
     *           execution_state is COMPLETE.
     *     @type string $evaluation_run
     *           Output only. The evaluation run that produced this result.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
     *     @type \Google\Cloud\Ces\V1beta\EvaluationPersona $persona
     *           Output only. The persona used to generate the conversation for the
     *           evaluation result.
     *     @type \Google\Cloud\Ces\V1beta\EvaluationErrorInfo $error_info
     *           Output only. Error information for the evaluation result.
     *     @type \Google\Rpc\Status $error
     *           Output only. Deprecated: Use `error_info` instead. Errors encountered
     *           during execution.
     *     @type string $initiated_by
     *           Output only. The user who initiated the evaluation run that resulted in
     *           this result.
     *     @type string $app_version
     *           Output only. The app version used to generate the conversation that
     *           resulted in this result. Format:
     *           `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
     *     @type string $app_version_display_name
     *           Output only. The display name of the `app_version` that the evaluation ran
     *           against.
     *     @type string $changelog
     *           Output only. The changelog of the app version that the evaluation ran
     *           against. This is populated if user runs evaluation on latest/draft.
     *     @type \Google\Protobuf\Timestamp $changelog_create_time
     *           Output only. The create time of the changelog of the app version that the
     *           evaluation ran against. This is populated if user runs evaluation on
     *           latest/draft.
     *     @type int $execution_state
     *           Output only. The state of the evaluation result execution.
     *     @type \Google\Cloud\Ces\V1beta\EvaluationMetricsThresholds $evaluation_metrics_thresholds
     *           Output only. The evaluation thresholds for the result.
     *     @type \Google\Cloud\Ces\V1beta\EvaluationConfig $config
     *           Output only. The configuration used in the evaluation run that resulted in
     *           this result.
     *     @type int $golden_run_method
     *           Output only. The method used to run the golden evaluation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1Beta\Evaluation::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The outcome of a golden evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.GoldenResult golden_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationResult\GoldenResult|null
     */
    public function getGoldenResult()
    {
        return $this->readOneof(7);
    }

    public function hasGoldenResult()
    {
        return $this->hasOneof(7);
    }

    /**
     * Output only. The outcome of a golden evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.GoldenResult golden_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationResult\GoldenResult $var
     * @return $this
     */
    public function setGoldenResult($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationResult\GoldenResult::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Output only. The outcome of a scenario evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.ScenarioResult scenario_result = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationResult\ScenarioResult|null
     */
    public function getScenarioResult()
    {
        return $this->readOneof(8);
    }

    public function hasScenarioResult()
    {
        return $this->hasOneof(8);
    }

    /**
     * Output only. The outcome of a scenario evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.ScenarioResult scenario_result = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationResult\ScenarioResult $var
     * @return $this
     */
    public function setScenarioResult($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationResult\ScenarioResult::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Identifier. The unique identifier of the evaluation result.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The unique identifier of the evaluation result.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Display name of the Evaluation Result. Unique within an
     * Evaluation. By default, it has the following format:
     * "<evaluation-display-name> result
     * - <timestamp>".
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. Display name of the Evaluation Result. Unique within an
     * Evaluation. By default, it has the following format:
     * "<evaluation-display-name> result
     * - <timestamp>".
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when the evaluation result was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp when the evaluation result was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The outcome of the evaluation. Only populated if
     * execution_state is COMPLETE.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.Outcome evaluation_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getEvaluationStatus()
    {
        return $this->evaluation_status;
    }

    /**
     * Output only. The outcome of the evaluation. Only populated if
     * execution_state is COMPLETE.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.Outcome evaluation_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setEvaluationStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ces\V1beta\EvaluationResult\Outcome::class);
        $this->evaluation_status = $var;

        return $this;
    }

    /**
     * Output only. The evaluation run that produced this result.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
     *
     * Generated from protobuf field <code>string evaluation_run = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEvaluationRun()
    {
        return $this->evaluation_run;
    }

    /**
     * Output only. The evaluation run that produced this result.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
     *
     * Generated from protobuf field <code>string evaluation_run = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEvaluationRun($var)
    {
        GPBUtil::checkString($var, True);
        $this->evaluation_run = $var;

        return $this;
    }

    /**
     * Output only. The persona used to generate the conversation for the
     * evaluation result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationPersona persona = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationPersona|null
     */
    public function getPersona()
    {
        return $this->persona;
    }

    public function hasPersona()
    {
        return isset($this->persona);
    }

    public function clearPersona()
    {
        unset($this->persona);
    }

    /**
     * Output only. The persona used to generate the conversation for the
     * evaluation result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationPersona persona = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationPersona $var
     * @return $this
     */
    public function setPersona($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationPersona::class);
        $this->persona = $var;

        return $this;
    }

    /**
     * Output only. Error information for the evaluation result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationErrorInfo error_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationErrorInfo|null
     */
    public function getErrorInfo()
    {
        return $this->error_info;
    }

    public function hasErrorInfo()
    {
        return isset($this->error_info);
    }

    public function clearErrorInfo()
    {
        unset($this->error_info);
    }

    /**
     * Output only. Error information for the evaluation result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationErrorInfo error_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationErrorInfo $var
     * @return $this
     */
    public function setErrorInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationErrorInfo::class);
        $this->error_info = $var;

        return $this;
    }

    /**
     * Output only. Deprecated: Use `error_info` instead. Errors encountered
     * during execution.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 14 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     * @deprecated
     */
    public function getError()
    {
        if (isset($this->error)) {
            @trigger_error('error is deprecated.', E_USER_DEPRECATED);
        }
        return $this->error;
    }

    public function hasError()
    {
        if (isset($this->error)) {
            @trigger_error('error is deprecated.', E_USER_DEPRECATED);
        }
        return isset($this->error);
    }

    public function clearError()
    {
        @trigger_error('error is deprecated.', E_USER_DEPRECATED);
        unset($this->error);
    }

    /**
     * Output only. Deprecated: Use `error_info` instead. Errors encountered
     * during execution.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 14 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     * @deprecated
     */
    public function setError($var)
    {
        @trigger_error('error is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

    /**
     * Output only. The user who initiated the evaluation run that resulted in
     * this result.
     *
     * Generated from protobuf field <code>string initiated_by = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getInitiatedBy()
    {
        return $this->initiated_by;
    }

    /**
     * Output only. The user who initiated the evaluation run that resulted in
     * this result.
     *
     * Generated from protobuf field <code>string initiated_by = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setInitiatedBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->initiated_by = $var;

        return $this;
    }

    /**
     * Output only. The app version used to generate the conversation that
     * resulted in this result. Format:
     * `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
     *
     * Generated from protobuf field <code>string app_version = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAppVersion()
    {
        return $this->app_version;
    }

    /**
     * Output only. The app version used to generate the conversation that
     * resulted in this result. Format:
     * `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
     *
     * Generated from protobuf field <code>string app_version = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAppVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->app_version = $var;

        return $this;
    }

    /**
     * Output only. The display name of the `app_version` that the evaluation ran
     * against.
     *
     * Generated from protobuf field <code>string app_version_display_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getAppVersionDisplayName()
    {
        return $this->app_version_display_name;
    }

    /**
     * Output only. The display name of the `app_version` that the evaluation ran
     * against.
     *
     * Generated from protobuf field <code>string app_version_display_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setAppVersionDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->app_version_display_name = $var;

        return $this;
    }

    /**
     * Output only. The changelog of the app version that the evaluation ran
     * against. This is populated if user runs evaluation on latest/draft.
     *
     * Generated from protobuf field <code>string changelog = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getChangelog()
    {
        return $this->changelog;
    }

    /**
     * Output only. The changelog of the app version that the evaluation ran
     * against. This is populated if user runs evaluation on latest/draft.
     *
     * Generated from protobuf field <code>string changelog = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setChangelog($var)
    {
        GPBUtil::checkString($var, True);
        $this->changelog = $var;

        return $this;
    }

    /**
     * Output only. The create time of the changelog of the app version that the
     * evaluation ran against. This is populated if user runs evaluation on
     * latest/draft.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp changelog_create_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getChangelogCreateTime()
    {
        return $this->changelog_create_time;
    }

    public function hasChangelogCreateTime()
    {
        return isset($this->changelog_create_time);
    }

    public function clearChangelogCreateTime()
    {
        unset($this->changelog_create_time);
    }

    /**
     * Output only. The create time of the changelog of the app version that the
     * evaluation ran against. This is populated if user runs evaluation on
     * latest/draft.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp changelog_create_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setChangelogCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->changelog_create_time = $var;

        return $this;
    }

    /**
     * Output only. The state of the evaluation result execution.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.ExecutionState execution_state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getExecutionState()
    {
        return $this->execution_state;
    }

    /**
     * Output only. The state of the evaluation result execution.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationResult.ExecutionState execution_state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setExecutionState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ces\V1beta\EvaluationResult\ExecutionState::class);
        $this->execution_state = $var;

        return $this;
    }

    /**
     * Output only. The evaluation thresholds for the result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationMetricsThresholds evaluation_metrics_thresholds = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationMetricsThresholds|null
     */
    public function getEvaluationMetricsThresholds()
    {
        return $this->evaluation_metrics_thresholds;
    }

    public function hasEvaluationMetricsThresholds()
    {
        return isset($this->evaluation_metrics_thresholds);
    }

    public function clearEvaluationMetricsThresholds()
    {
        unset($this->evaluation_metrics_thresholds);
    }

    /**
     * Output only. The evaluation thresholds for the result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationMetricsThresholds evaluation_metrics_thresholds = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationMetricsThresholds $var
     * @return $this
     */
    public function setEvaluationMetricsThresholds($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationMetricsThresholds::class);
        $this->evaluation_metrics_thresholds = $var;

        return $this;
    }

    /**
     * Output only. The configuration used in the evaluation run that resulted in
     * this result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationConfig config = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationConfig|null
     */
    public function getConfig()
    {
        return $this->config;
    }

    public function hasConfig()
    {
        return isset($this->config);
    }

    public function clearConfig()
    {
        unset($this->config);
    }

    /**
     * Output only. The configuration used in the evaluation run that resulted in
     * this result.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationConfig config = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationConfig $var
     * @return $this
     */
    public function setConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationConfig::class);
        $this->config = $var;

        return $this;
    }

    /**
     * Output only. The method used to run the golden evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.GoldenRunMethod golden_run_method = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getGoldenRunMethod()
    {
        return $this->golden_run_method;
    }

    /**
     * Output only. The method used to run the golden evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.GoldenRunMethod golden_run_method = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setGoldenRunMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ces\V1beta\GoldenRunMethod::class);
        $this->golden_run_method = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getResult()
    {
        return $this->whichOneof("result");
    }

}

