<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1beta/evaluation.proto

namespace Google\Cloud\Ces\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An evaluation run represents an all the evaluation results from an
 * evaluation execution.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1beta.EvaluationRun</code>
 */
class EvaluationRun extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The unique identifier of the evaluation run.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. User-defined display name of the evaluation run.
     * default: "<evaluation-dataset-display-name> run - <timestamp>".
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Output only. The evaluation results that are part of this run.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
     *
     * Generated from protobuf field <code>repeated string evaluation_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $evaluation_results;
    /**
     * Output only. Timestamp when the evaluation run was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The user who initiated the evaluation run.
     *
     * Generated from protobuf field <code>string initiated_by = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $initiated_by = '';
    /**
     * Output only. The app version to evaluate.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
     *
     * Generated from protobuf field <code>string app_version = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $app_version = '';
    /**
     * Output only. The display name of the `app_version` that the evaluation ran
     * against.
     *
     * Generated from protobuf field <code>string app_version_display_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $app_version_display_name = '';
    /**
     * Output only. The changelog of the app version that the evaluation ran
     * against. This is populated if user runs evaluation on latest/draft.
     *
     * Generated from protobuf field <code>string changelog = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $changelog = '';
    /**
     * Output only. The create time of the changelog of the app version that the
     * evaluation ran against. This is populated if user runs evaluation on
     * latest/draft.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp changelog_create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $changelog_create_time = null;
    /**
     * Output only. The evaluations that are part of this run. The list may
     * contain evaluations of either type. This field is mutually exclusive with
     * `evaluation_dataset`.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
     *
     * Generated from protobuf field <code>repeated string evaluations = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $evaluations;
    /**
     * Output only. The evaluation dataset that this run is associated with. This
     * field is mutually exclusive with `evaluations`. Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
     *
     * Generated from protobuf field <code>string evaluation_dataset = 8 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $evaluation_dataset = '';
    /**
     * Output only. The type of the evaluations in this run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationRun.EvaluationType evaluation_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $evaluation_type = 0;
    /**
     * Output only. The state of the evaluation run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationRun.EvaluationRunState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The progress of the evaluation run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationRun.Progress progress = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $progress = null;
    /**
     * Output only. The configuration used in the run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationConfig config = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $config = null;
    /**
     * Output only. Deprecated: Use error_info instead. Errors encountered during
     * execution.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 14 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @deprecated
     */
    protected $error = null;
    /**
     * Output only. Error information for the evaluation run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationErrorInfo error_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $error_info = null;
    /**
     * Output only. Map of evaluation name to EvaluationRunSummary.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.ces.v1beta.EvaluationRun.EvaluationRunSummary> evaluation_run_summaries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $evaluation_run_summaries;
    /**
     * Output only. The number of times the evaluations inside the run were run.
     *
     * Generated from protobuf field <code>int32 run_count = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $run_count = 0;
    /**
     * Output only. The configuration to use for the run per persona.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.PersonaRunConfig persona_run_configs = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $persona_run_configs;
    /**
     * Optional. Configuration for running the optimization step after the
     * evaluation run. If not set, the optimization step will not be run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.OptimizationConfig optimization_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $optimization_config = null;
    /**
     * Output only. The scheduled evaluation run resource name that created this
     * evaluation run. This field is only set if the evaluation run was created
     * by a scheduled evaluation run.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
     *
     * Generated from protobuf field <code>string scheduled_evaluation_run = 20 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $scheduled_evaluation_run = '';
    /**
     * Output only. The method used to run the evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.GoldenRunMethod golden_run_method = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $golden_run_method = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The unique identifier of the evaluation run.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
     *     @type string $display_name
     *           Optional. User-defined display name of the evaluation run.
     *           default: "<evaluation-dataset-display-name> run - <timestamp>".
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $evaluation_results
     *           Output only. The evaluation results that are part of this run.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp when the evaluation run was created.
     *     @type string $initiated_by
     *           Output only. The user who initiated the evaluation run.
     *     @type string $app_version
     *           Output only. The app version to evaluate.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
     *     @type string $app_version_display_name
     *           Output only. The display name of the `app_version` that the evaluation ran
     *           against.
     *     @type string $changelog
     *           Output only. The changelog of the app version that the evaluation ran
     *           against. This is populated if user runs evaluation on latest/draft.
     *     @type \Google\Protobuf\Timestamp $changelog_create_time
     *           Output only. The create time of the changelog of the app version that the
     *           evaluation ran against. This is populated if user runs evaluation on
     *           latest/draft.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $evaluations
     *           Output only. The evaluations that are part of this run. The list may
     *           contain evaluations of either type. This field is mutually exclusive with
     *           `evaluation_dataset`.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
     *     @type string $evaluation_dataset
     *           Output only. The evaluation dataset that this run is associated with. This
     *           field is mutually exclusive with `evaluations`. Format:
     *           `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
     *     @type int $evaluation_type
     *           Output only. The type of the evaluations in this run.
     *     @type int $state
     *           Output only. The state of the evaluation run.
     *     @type \Google\Cloud\Ces\V1beta\EvaluationRun\Progress $progress
     *           Output only. The progress of the evaluation run.
     *     @type \Google\Cloud\Ces\V1beta\EvaluationConfig $config
     *           Output only. The configuration used in the run.
     *     @type \Google\Rpc\Status $error
     *           Output only. Deprecated: Use error_info instead. Errors encountered during
     *           execution.
     *     @type \Google\Cloud\Ces\V1beta\EvaluationErrorInfo $error_info
     *           Output only. Error information for the evaluation run.
     *     @type array|\Google\Protobuf\Internal\MapField $evaluation_run_summaries
     *           Output only. Map of evaluation name to EvaluationRunSummary.
     *     @type int $run_count
     *           Output only. The number of times the evaluations inside the run were run.
     *     @type array<\Google\Cloud\Ces\V1beta\PersonaRunConfig>|\Google\Protobuf\Internal\RepeatedField $persona_run_configs
     *           Output only. The configuration to use for the run per persona.
     *     @type \Google\Cloud\Ces\V1beta\OptimizationConfig $optimization_config
     *           Optional. Configuration for running the optimization step after the
     *           evaluation run. If not set, the optimization step will not be run.
     *     @type string $scheduled_evaluation_run
     *           Output only. The scheduled evaluation run resource name that created this
     *           evaluation run. This field is only set if the evaluation run was created
     *           by a scheduled evaluation run.
     *           Format:
     *           `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
     *     @type int $golden_run_method
     *           Output only. The method used to run the evaluation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1Beta\Evaluation::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The unique identifier of the evaluation run.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The unique identifier of the evaluation run.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. User-defined display name of the evaluation run.
     * default: "<evaluation-dataset-display-name> run - <timestamp>".
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. User-defined display name of the evaluation run.
     * default: "<evaluation-dataset-display-name> run - <timestamp>".
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The evaluation results that are part of this run.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
     *
     * Generated from protobuf field <code>repeated string evaluation_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEvaluationResults()
    {
        return $this->evaluation_results;
    }

    /**
     * Output only. The evaluation results that are part of this run.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
     *
     * Generated from protobuf field <code>repeated string evaluation_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEvaluationResults($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->evaluation_results = $arr;

        return $this;
    }

    /**
     * Output only. Timestamp when the evaluation run was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp when the evaluation run was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The user who initiated the evaluation run.
     *
     * Generated from protobuf field <code>string initiated_by = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getInitiatedBy()
    {
        return $this->initiated_by;
    }

    /**
     * Output only. The user who initiated the evaluation run.
     *
     * Generated from protobuf field <code>string initiated_by = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setInitiatedBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->initiated_by = $var;

        return $this;
    }

    /**
     * Output only. The app version to evaluate.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
     *
     * Generated from protobuf field <code>string app_version = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAppVersion()
    {
        return $this->app_version;
    }

    /**
     * Output only. The app version to evaluate.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
     *
     * Generated from protobuf field <code>string app_version = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAppVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->app_version = $var;

        return $this;
    }

    /**
     * Output only. The display name of the `app_version` that the evaluation ran
     * against.
     *
     * Generated from protobuf field <code>string app_version_display_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getAppVersionDisplayName()
    {
        return $this->app_version_display_name;
    }

    /**
     * Output only. The display name of the `app_version` that the evaluation ran
     * against.
     *
     * Generated from protobuf field <code>string app_version_display_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setAppVersionDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->app_version_display_name = $var;

        return $this;
    }

    /**
     * Output only. The changelog of the app version that the evaluation ran
     * against. This is populated if user runs evaluation on latest/draft.
     *
     * Generated from protobuf field <code>string changelog = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getChangelog()
    {
        return $this->changelog;
    }

    /**
     * Output only. The changelog of the app version that the evaluation ran
     * against. This is populated if user runs evaluation on latest/draft.
     *
     * Generated from protobuf field <code>string changelog = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setChangelog($var)
    {
        GPBUtil::checkString($var, True);
        $this->changelog = $var;

        return $this;
    }

    /**
     * Output only. The create time of the changelog of the app version that the
     * evaluation ran against. This is populated if user runs evaluation on
     * latest/draft.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp changelog_create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getChangelogCreateTime()
    {
        return $this->changelog_create_time;
    }

    public function hasChangelogCreateTime()
    {
        return isset($this->changelog_create_time);
    }

    public function clearChangelogCreateTime()
    {
        unset($this->changelog_create_time);
    }

    /**
     * Output only. The create time of the changelog of the app version that the
     * evaluation ran against. This is populated if user runs evaluation on
     * latest/draft.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp changelog_create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setChangelogCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->changelog_create_time = $var;

        return $this;
    }

    /**
     * Output only. The evaluations that are part of this run. The list may
     * contain evaluations of either type. This field is mutually exclusive with
     * `evaluation_dataset`.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
     *
     * Generated from protobuf field <code>repeated string evaluations = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEvaluations()
    {
        return $this->evaluations;
    }

    /**
     * Output only. The evaluations that are part of this run. The list may
     * contain evaluations of either type. This field is mutually exclusive with
     * `evaluation_dataset`.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
     *
     * Generated from protobuf field <code>repeated string evaluations = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEvaluations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->evaluations = $arr;

        return $this;
    }

    /**
     * Output only. The evaluation dataset that this run is associated with. This
     * field is mutually exclusive with `evaluations`. Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
     *
     * Generated from protobuf field <code>string evaluation_dataset = 8 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEvaluationDataset()
    {
        return $this->evaluation_dataset;
    }

    /**
     * Output only. The evaluation dataset that this run is associated with. This
     * field is mutually exclusive with `evaluations`. Format:
     * `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
     *
     * Generated from protobuf field <code>string evaluation_dataset = 8 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEvaluationDataset($var)
    {
        GPBUtil::checkString($var, True);
        $this->evaluation_dataset = $var;

        return $this;
    }

    /**
     * Output only. The type of the evaluations in this run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationRun.EvaluationType evaluation_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getEvaluationType()
    {
        return $this->evaluation_type;
    }

    /**
     * Output only. The type of the evaluations in this run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationRun.EvaluationType evaluation_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setEvaluationType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ces\V1beta\EvaluationRun\EvaluationType::class);
        $this->evaluation_type = $var;

        return $this;
    }

    /**
     * Output only. The state of the evaluation run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationRun.EvaluationRunState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the evaluation run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationRun.EvaluationRunState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ces\V1beta\EvaluationRun\EvaluationRunState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The progress of the evaluation run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationRun.Progress progress = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationRun\Progress|null
     */
    public function getProgress()
    {
        return $this->progress;
    }

    public function hasProgress()
    {
        return isset($this->progress);
    }

    public function clearProgress()
    {
        unset($this->progress);
    }

    /**
     * Output only. The progress of the evaluation run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationRun.Progress progress = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationRun\Progress $var
     * @return $this
     */
    public function setProgress($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationRun\Progress::class);
        $this->progress = $var;

        return $this;
    }

    /**
     * Output only. The configuration used in the run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationConfig config = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationConfig|null
     */
    public function getConfig()
    {
        return $this->config;
    }

    public function hasConfig()
    {
        return isset($this->config);
    }

    public function clearConfig()
    {
        unset($this->config);
    }

    /**
     * Output only. The configuration used in the run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationConfig config = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationConfig $var
     * @return $this
     */
    public function setConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationConfig::class);
        $this->config = $var;

        return $this;
    }

    /**
     * Output only. Deprecated: Use error_info instead. Errors encountered during
     * execution.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 14 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     * @deprecated
     */
    public function getError()
    {
        if (isset($this->error)) {
            @trigger_error('error is deprecated.', E_USER_DEPRECATED);
        }
        return $this->error;
    }

    public function hasError()
    {
        if (isset($this->error)) {
            @trigger_error('error is deprecated.', E_USER_DEPRECATED);
        }
        return isset($this->error);
    }

    public function clearError()
    {
        @trigger_error('error is deprecated.', E_USER_DEPRECATED);
        unset($this->error);
    }

    /**
     * Output only. Deprecated: Use error_info instead. Errors encountered during
     * execution.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 14 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     * @deprecated
     */
    public function setError($var)
    {
        @trigger_error('error is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

    /**
     * Output only. Error information for the evaluation run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationErrorInfo error_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Ces\V1beta\EvaluationErrorInfo|null
     */
    public function getErrorInfo()
    {
        return $this->error_info;
    }

    public function hasErrorInfo()
    {
        return isset($this->error_info);
    }

    public function clearErrorInfo()
    {
        unset($this->error_info);
    }

    /**
     * Output only. Error information for the evaluation run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.EvaluationErrorInfo error_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Ces\V1beta\EvaluationErrorInfo $var
     * @return $this
     */
    public function setErrorInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\EvaluationErrorInfo::class);
        $this->error_info = $var;

        return $this;
    }

    /**
     * Output only. Map of evaluation name to EvaluationRunSummary.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.ces.v1beta.EvaluationRun.EvaluationRunSummary> evaluation_run_summaries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getEvaluationRunSummaries()
    {
        return $this->evaluation_run_summaries;
    }

    /**
     * Output only. Map of evaluation name to EvaluationRunSummary.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.ces.v1beta.EvaluationRun.EvaluationRunSummary> evaluation_run_summaries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setEvaluationRunSummaries($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\EvaluationRun\EvaluationRunSummary::class);
        $this->evaluation_run_summaries = $arr;

        return $this;
    }

    /**
     * Output only. The number of times the evaluations inside the run were run.
     *
     * Generated from protobuf field <code>int32 run_count = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getRunCount()
    {
        return $this->run_count;
    }

    /**
     * Output only. The number of times the evaluations inside the run were run.
     *
     * Generated from protobuf field <code>int32 run_count = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setRunCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->run_count = $var;

        return $this;
    }

    /**
     * Output only. The configuration to use for the run per persona.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.PersonaRunConfig persona_run_configs = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPersonaRunConfigs()
    {
        return $this->persona_run_configs;
    }

    /**
     * Output only. The configuration to use for the run per persona.
     *
     * Generated from protobuf field <code>repeated .google.cloud.ces.v1beta.PersonaRunConfig persona_run_configs = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Ces\V1beta\PersonaRunConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPersonaRunConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Ces\V1beta\PersonaRunConfig::class);
        $this->persona_run_configs = $arr;

        return $this;
    }

    /**
     * Optional. Configuration for running the optimization step after the
     * evaluation run. If not set, the optimization step will not be run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.OptimizationConfig optimization_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Ces\V1beta\OptimizationConfig|null
     */
    public function getOptimizationConfig()
    {
        return $this->optimization_config;
    }

    public function hasOptimizationConfig()
    {
        return isset($this->optimization_config);
    }

    public function clearOptimizationConfig()
    {
        unset($this->optimization_config);
    }

    /**
     * Optional. Configuration for running the optimization step after the
     * evaluation run. If not set, the optimization step will not be run.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.OptimizationConfig optimization_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Ces\V1beta\OptimizationConfig $var
     * @return $this
     */
    public function setOptimizationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1beta\OptimizationConfig::class);
        $this->optimization_config = $var;

        return $this;
    }

    /**
     * Output only. The scheduled evaluation run resource name that created this
     * evaluation run. This field is only set if the evaluation run was created
     * by a scheduled evaluation run.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
     *
     * Generated from protobuf field <code>string scheduled_evaluation_run = 20 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getScheduledEvaluationRun()
    {
        return $this->scheduled_evaluation_run;
    }

    /**
     * Output only. The scheduled evaluation run resource name that created this
     * evaluation run. This field is only set if the evaluation run was created
     * by a scheduled evaluation run.
     * Format:
     * `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
     *
     * Generated from protobuf field <code>string scheduled_evaluation_run = 20 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setScheduledEvaluationRun($var)
    {
        GPBUtil::checkString($var, True);
        $this->scheduled_evaluation_run = $var;

        return $this;
    }

    /**
     * Output only. The method used to run the evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.GoldenRunMethod golden_run_method = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getGoldenRunMethod()
    {
        return $this->golden_run_method;
    }

    /**
     * Output only. The method used to run the evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1beta.GoldenRunMethod golden_run_method = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setGoldenRunMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ces\V1beta\GoldenRunMethod::class);
        $this->golden_run_method = $var;

        return $this;
    }

}

