<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * This file was automatically generated - do not edit!
 */

require_once __DIR__ . '/../../../vendor/autoload.php';

// [START ces_v1beta_generated_AgentService_RestoreAppVersion_sync]
use Google\ApiCore\ApiException;
use Google\ApiCore\OperationResponse;
use Google\Cloud\Ces\V1beta\Client\AgentServiceClient;
use Google\Cloud\Ces\V1beta\RestoreAppVersionRequest;
use Google\Cloud\Ces\V1beta\RestoreAppVersionResponse;
use Google\Rpc\Status;

/**
 * Restores the specified app version.
 * This will create a new app version from the current draft app and overwrite
 * the current draft with the specified app version.
 *
 * @param string $formattedName The resource name of the app version to restore. Please see
 *                              {@see AgentServiceClient::appVersionName()} for help formatting this field.
 */
function restore_app_version_sample(string $formattedName): void
{
    // Create a client.
    $agentServiceClient = new AgentServiceClient();

    // Prepare the request message.
    $request = (new RestoreAppVersionRequest())
        ->setName($formattedName);

    // Call the API and handle any network failures.
    try {
        /** @var OperationResponse $response */
        $response = $agentServiceClient->restoreAppVersion($request);
        $response->pollUntilComplete();

        if ($response->operationSucceeded()) {
            /** @var RestoreAppVersionResponse $result */
            $result = $response->getResult();
            printf('Operation successful with response data: %s' . PHP_EOL, $result->serializeToJsonString());
        } else {
            /** @var Status $error */
            $error = $response->getError();
            printf('Operation failed with error data: %s' . PHP_EOL, $error->serializeToJsonString());
        }
    } catch (ApiException $ex) {
        printf('Call failed with message: %s' . PHP_EOL, $ex->getMessage());
    }
}

/**
 * Helper to execute the sample.
 *
 * This sample has been automatically generated and should be regarded as a code
 * template only. It will require modifications to work:
 *  - It may require correct/in-range values for request initialization.
 *  - It may require specifying regional endpoints when creating the service client,
 *    please see the apiEndpoint client configuration option for more details.
 */
function callSample(): void
{
    $formattedName = AgentServiceClient::appVersionName(
        '[PROJECT]',
        '[LOCATION]',
        '[APP]',
        '[VERSION]'
    );

    restore_app_version_sample($formattedName);
}
// [END ces_v1beta_generated_AgentService_RestoreAppVersion_sync]
