<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * This file was automatically generated - do not edit!
 */

require_once __DIR__ . '/../../../vendor/autoload.php';

// [START ces_v1beta_generated_EvaluationService_CreateEvaluationDataset_sync]
use Google\ApiCore\ApiException;
use Google\Cloud\Ces\V1beta\Client\EvaluationServiceClient;
use Google\Cloud\Ces\V1beta\CreateEvaluationDatasetRequest;
use Google\Cloud\Ces\V1beta\EvaluationDataset;

/**
 * Creates an evaluation dataset.
 *
 * @param string $formattedParent              The app to create the evaluation for.
 *                                             Format:
 *                                             `projects/{project}/locations/{location}/apps/{app}`
 *                                             Please see {@see EvaluationServiceClient::appName()} for help formatting this field.
 * @param string $evaluationDatasetDisplayName User-defined display name of the evaluation dataset. Unique
 *                                             within an App.
 */
function create_evaluation_dataset_sample(
    string $formattedParent,
    string $evaluationDatasetDisplayName
): void {
    // Create a client.
    $evaluationServiceClient = new EvaluationServiceClient();

    // Prepare the request message.
    $evaluationDataset = (new EvaluationDataset())
        ->setDisplayName($evaluationDatasetDisplayName);
    $request = (new CreateEvaluationDatasetRequest())
        ->setParent($formattedParent)
        ->setEvaluationDataset($evaluationDataset);

    // Call the API and handle any network failures.
    try {
        /** @var EvaluationDataset $response */
        $response = $evaluationServiceClient->createEvaluationDataset($request);
        printf('Response data: %s' . PHP_EOL, $response->serializeToJsonString());
    } catch (ApiException $ex) {
        printf('Call failed with message: %s' . PHP_EOL, $ex->getMessage());
    }
}

/**
 * Helper to execute the sample.
 *
 * This sample has been automatically generated and should be regarded as a code
 * template only. It will require modifications to work:
 *  - It may require correct/in-range values for request initialization.
 *  - It may require specifying regional endpoints when creating the service client,
 *    please see the apiEndpoint client configuration option for more details.
 */
function callSample(): void
{
    $formattedParent = EvaluationServiceClient::appName('[PROJECT]', '[LOCATION]', '[APP]');
    $evaluationDatasetDisplayName = '[DISPLAY_NAME]';

    create_evaluation_dataset_sample($formattedParent, $evaluationDatasetDisplayName);
}
// [END ces_v1beta_generated_EvaluationService_CreateEvaluationDataset_sync]
