<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * This file was automatically generated - do not edit!
 */

require_once __DIR__ . '/../../../vendor/autoload.php';

// [START ces_v1beta_generated_EvaluationService_CreateScheduledEvaluationRun_sync]
use Google\ApiCore\ApiException;
use Google\Cloud\Ces\V1beta\Client\EvaluationServiceClient;
use Google\Cloud\Ces\V1beta\CreateScheduledEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\RunEvaluationRequest;
use Google\Cloud\Ces\V1beta\ScheduledEvaluationRun;
use Google\Cloud\Ces\V1beta\ScheduledEvaluationRun\SchedulingConfig;
use Google\Cloud\Ces\V1beta\ScheduledEvaluationRun\SchedulingConfig\Frequency;
use Google\Protobuf\Timestamp;

/**
 * Creates a scheduled evaluation run.
 *
 * @param string $formattedParent                                 The app to create the scheduled evaluation run for.
 *                                                                Format:
 *                                                                `projects/{project}/locations/{location}/apps/{app}`
 *                                                                Please see {@see EvaluationServiceClient::appName()} for help formatting this field.
 * @param string $scheduledEvaluationRunDisplayName               User-defined display name of the scheduled evaluation run config.
 * @param string $formattedScheduledEvaluationRunRequestApp       The app to evaluate.
 *                                                                Format:
 *                                                                `projects/{project}/locations/{location}/apps/{app}`
 *                                                                Please see {@see EvaluationServiceClient::appName()} for help formatting this field.
 * @param int    $scheduledEvaluationRunSchedulingConfigFrequency The frequency with which to run the eval
 */
function create_scheduled_evaluation_run_sample(
    string $formattedParent,
    string $scheduledEvaluationRunDisplayName,
    string $formattedScheduledEvaluationRunRequestApp,
    int $scheduledEvaluationRunSchedulingConfigFrequency
): void {
    // Create a client.
    $evaluationServiceClient = new EvaluationServiceClient();

    // Prepare the request message.
    $scheduledEvaluationRunRequest = (new RunEvaluationRequest())
        ->setApp($formattedScheduledEvaluationRunRequestApp);
    $scheduledEvaluationRunSchedulingConfigStartTime = new Timestamp();
    $scheduledEvaluationRunSchedulingConfig = (new SchedulingConfig())
        ->setFrequency($scheduledEvaluationRunSchedulingConfigFrequency)
        ->setStartTime($scheduledEvaluationRunSchedulingConfigStartTime);
    $scheduledEvaluationRun = (new ScheduledEvaluationRun())
        ->setDisplayName($scheduledEvaluationRunDisplayName)
        ->setRequest($scheduledEvaluationRunRequest)
        ->setSchedulingConfig($scheduledEvaluationRunSchedulingConfig);
    $request = (new CreateScheduledEvaluationRunRequest())
        ->setParent($formattedParent)
        ->setScheduledEvaluationRun($scheduledEvaluationRun);

    // Call the API and handle any network failures.
    try {
        /** @var ScheduledEvaluationRun $response */
        $response = $evaluationServiceClient->createScheduledEvaluationRun($request);
        printf('Response data: %s' . PHP_EOL, $response->serializeToJsonString());
    } catch (ApiException $ex) {
        printf('Call failed with message: %s' . PHP_EOL, $ex->getMessage());
    }
}

/**
 * Helper to execute the sample.
 *
 * This sample has been automatically generated and should be regarded as a code
 * template only. It will require modifications to work:
 *  - It may require correct/in-range values for request initialization.
 *  - It may require specifying regional endpoints when creating the service client,
 *    please see the apiEndpoint client configuration option for more details.
 */
function callSample(): void
{
    $formattedParent = EvaluationServiceClient::appName('[PROJECT]', '[LOCATION]', '[APP]');
    $scheduledEvaluationRunDisplayName = '[DISPLAY_NAME]';
    $formattedScheduledEvaluationRunRequestApp = EvaluationServiceClient::appName(
        '[PROJECT]',
        '[LOCATION]',
        '[APP]'
    );
    $scheduledEvaluationRunSchedulingConfigFrequency = Frequency::FREQUENCY_UNSPECIFIED;

    create_scheduled_evaluation_run_sample(
        $formattedParent,
        $scheduledEvaluationRunDisplayName,
        $formattedScheduledEvaluationRunRequestApp,
        $scheduledEvaluationRunSchedulingConfigFrequency
    );
}
// [END ces_v1beta_generated_EvaluationService_CreateScheduledEvaluationRun_sync]
